/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta2/storage.proto

package com.google.cloud.bigquery.storage.v1beta2;

/**
 *
 *
 * <pre>
 * Estimated stream statistics for a given Stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.StreamStats}
 */
public final class StreamStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.StreamStats)
    StreamStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamStats.newBuilder() to construct.
  private StreamStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamStats() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamStats();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.class,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder.class);
  }

  public interface ProgressOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The fraction of rows assigned to the stream that have been processed by
     * the server so far, not including the rows in the current response
     * message.
     * This value, along with `at_response_end`, can be used to interpolate
     * the progress made as the rows in the message are being processed using
     * the following formula: `at_response_start + (at_response_end -
     * at_response_start) * rows_processed_from_response / rows_in_response`.
     * Note that if a filter is provided, the `at_response_end` value of the
     * previous response may not necessarily be equal to the
     * `at_response_start` value of the current response.
     * </pre>
     *
     * <code>double at_response_start = 1;</code>
     *
     * @return The atResponseStart.
     */
    double getAtResponseStart();

    /**
     *
     *
     * <pre>
     * Similar to `at_response_start`, except that this value includes the
     * rows in the current response.
     * </pre>
     *
     * <code>double at_response_end = 2;</code>
     *
     * @return The atResponseEnd.
     */
    double getAtResponseEnd();
  }
  /** Protobuf type {@code google.cloud.bigquery.storage.v1beta2.StreamStats.Progress} */
  public static final class Progress extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)
      ProgressOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Progress.newBuilder() to construct.
    private Progress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Progress() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Progress();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_Progress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_Progress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.class,
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder.class);
    }

    public static final int AT_RESPONSE_START_FIELD_NUMBER = 1;
    private double atResponseStart_ = 0D;
    /**
     *
     *
     * <pre>
     * The fraction of rows assigned to the stream that have been processed by
     * the server so far, not including the rows in the current response
     * message.
     * This value, along with `at_response_end`, can be used to interpolate
     * the progress made as the rows in the message are being processed using
     * the following formula: `at_response_start + (at_response_end -
     * at_response_start) * rows_processed_from_response / rows_in_response`.
     * Note that if a filter is provided, the `at_response_end` value of the
     * previous response may not necessarily be equal to the
     * `at_response_start` value of the current response.
     * </pre>
     *
     * <code>double at_response_start = 1;</code>
     *
     * @return The atResponseStart.
     */
    @java.lang.Override
    public double getAtResponseStart() {
      return atResponseStart_;
    }

    public static final int AT_RESPONSE_END_FIELD_NUMBER = 2;
    private double atResponseEnd_ = 0D;
    /**
     *
     *
     * <pre>
     * Similar to `at_response_start`, except that this value includes the
     * rows in the current response.
     * </pre>
     *
     * <code>double at_response_end = 2;</code>
     *
     * @return The atResponseEnd.
     */
    @java.lang.Override
    public double getAtResponseEnd() {
      return atResponseEnd_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(atResponseStart_) != 0) {
        output.writeDouble(1, atResponseStart_);
      }
      if (java.lang.Double.doubleToRawLongBits(atResponseEnd_) != 0) {
        output.writeDouble(2, atResponseEnd_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(atResponseStart_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, atResponseStart_);
      }
      if (java.lang.Double.doubleToRawLongBits(atResponseEnd_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, atResponseEnd_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress other =
          (com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress) obj;

      if (java.lang.Double.doubleToLongBits(getAtResponseStart())
          != java.lang.Double.doubleToLongBits(other.getAtResponseStart())) return false;
      if (java.lang.Double.doubleToLongBits(getAtResponseEnd())
          != java.lang.Double.doubleToLongBits(other.getAtResponseEnd())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AT_RESPONSE_START_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAtResponseStart()));
      hash = (37 * hash) + AT_RESPONSE_END_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAtResponseEnd()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.bigquery.storage.v1beta2.StreamStats.Progress} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_Progress_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_Progress_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.class,
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder.class);
      }

      // Construct using com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        atResponseStart_ = 0D;
        atResponseEnd_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1beta2.StorageProto
            .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_Progress_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress build() {
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress buildPartial() {
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress result =
            new com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.atResponseStart_ = atResponseStart_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.atResponseEnd_ = atResponseEnd_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress other) {
        if (other
            == com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance())
          return this;
        if (other.getAtResponseStart() != 0D) {
          setAtResponseStart(other.getAtResponseStart());
        }
        if (other.getAtResponseEnd() != 0D) {
          setAtResponseEnd(other.getAtResponseEnd());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  atResponseStart_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              case 17:
                {
                  atResponseEnd_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double atResponseStart_;
      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by
       * the server so far, not including the rows in the current response
       * message.
       * This value, along with `at_response_end`, can be used to interpolate
       * the progress made as the rows in the message are being processed using
       * the following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the
       * `at_response_start` value of the current response.
       * </pre>
       *
       * <code>double at_response_start = 1;</code>
       *
       * @return The atResponseStart.
       */
      @java.lang.Override
      public double getAtResponseStart() {
        return atResponseStart_;
      }
      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by
       * the server so far, not including the rows in the current response
       * message.
       * This value, along with `at_response_end`, can be used to interpolate
       * the progress made as the rows in the message are being processed using
       * the following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the
       * `at_response_start` value of the current response.
       * </pre>
       *
       * <code>double at_response_start = 1;</code>
       *
       * @param value The atResponseStart to set.
       * @return This builder for chaining.
       */
      public Builder setAtResponseStart(double value) {

        atResponseStart_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The fraction of rows assigned to the stream that have been processed by
       * the server so far, not including the rows in the current response
       * message.
       * This value, along with `at_response_end`, can be used to interpolate
       * the progress made as the rows in the message are being processed using
       * the following formula: `at_response_start + (at_response_end -
       * at_response_start) * rows_processed_from_response / rows_in_response`.
       * Note that if a filter is provided, the `at_response_end` value of the
       * previous response may not necessarily be equal to the
       * `at_response_start` value of the current response.
       * </pre>
       *
       * <code>double at_response_start = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAtResponseStart() {
        bitField0_ = (bitField0_ & ~0x00000001);
        atResponseStart_ = 0D;
        onChanged();
        return this;
      }

      private double atResponseEnd_;
      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the
       * rows in the current response.
       * </pre>
       *
       * <code>double at_response_end = 2;</code>
       *
       * @return The atResponseEnd.
       */
      @java.lang.Override
      public double getAtResponseEnd() {
        return atResponseEnd_;
      }
      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the
       * rows in the current response.
       * </pre>
       *
       * <code>double at_response_end = 2;</code>
       *
       * @param value The atResponseEnd to set.
       * @return This builder for chaining.
       */
      public Builder setAtResponseEnd(double value) {

        atResponseEnd_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Similar to `at_response_start`, except that this value includes the
       * rows in the current response.
       * </pre>
       *
       * <code>double at_response_end = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAtResponseEnd() {
        bitField0_ = (bitField0_ & ~0x00000002);
        atResponseEnd_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.StreamStats.Progress)
    private static final com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress();
    }

    public static com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Progress> PARSER =
        new com.google.protobuf.AbstractParser<Progress>() {
          @java.lang.Override
          public Progress parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Progress> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Progress> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PROGRESS_FIELD_NUMBER = 2;
  private com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress_;
  /**
   *
   *
   * <pre>
   * Represents the progress of the current stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return progress_ != null;
  }
  /**
   *
   *
   * <pre>
   * Represents the progress of the current stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress getProgress() {
    return progress_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance()
        : progress_;
  }
  /**
   *
   *
   * <pre>
   * Represents the progress of the current stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder
      getProgressOrBuilder() {
    return progress_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance()
        : progress_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (progress_ != null) {
      output.writeMessage(2, getProgress());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (progress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getProgress());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta2.StreamStats)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1beta2.StreamStats other =
        (com.google.cloud.bigquery.storage.v1beta2.StreamStats) obj;

    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (!getProgress().equals(other.getProgress())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1beta2.StreamStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Estimated stream statistics for a given Stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.StreamStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.StreamStats)
      com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.class,
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1beta2.StreamStats.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_StreamStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1beta2.StreamStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats build() {
      com.google.cloud.bigquery.storage.v1beta2.StreamStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats buildPartial() {
      com.google.cloud.bigquery.storage.v1beta2.StreamStats result =
          new com.google.cloud.bigquery.storage.v1beta2.StreamStats(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1beta2.StreamStats result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.progress_ = progressBuilder_ == null ? progress_ : progressBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1beta2.StreamStats) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1beta2.StreamStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1beta2.StreamStats other) {
      if (other == com.google.cloud.bigquery.storage.v1beta2.StreamStats.getDefaultInstance())
        return this;
      if (other.hasProgress()) {
        mergeProgress(other.getProgress());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getProgressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder>
        progressBuilder_;
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     *
     * @return Whether the progress field is set.
     */
    public boolean hasProgress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     *
     * @return The progress.
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress getProgress() {
      if (progressBuilder_ == null) {
        return progress_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance()
            : progress_;
      } else {
        return progressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public Builder setProgress(
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progress_ = value;
      } else {
        progressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public Builder setProgress(
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        progress_ = builderForValue.build();
      } else {
        progressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public Builder mergeProgress(
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress value) {
      if (progressBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && progress_ != null
            && progress_
                != com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
                    .getDefaultInstance()) {
          getProgressBuilder().mergeFrom(value);
        } else {
          progress_ = value;
        }
      } else {
        progressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00000001);
      progress_ = null;
      if (progressBuilder_ != null) {
        progressBuilder_.dispose();
        progressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder
        getProgressBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getProgressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder
        getProgressOrBuilder() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilder();
      } else {
        return progress_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.getDefaultInstance()
            : progress_;
      }
    }
    /**
     *
     *
     * <pre>
     * Represents the progress of the current stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress progress = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder>
        getProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress,
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.Progress.Builder,
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.ProgressOrBuilder>(
                getProgress(), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.StreamStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.StreamStats)
  private static final com.google.cloud.bigquery.storage.v1beta2.StreamStats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta2.StreamStats();
  }

  public static com.google.cloud.bigquery.storage.v1beta2.StreamStats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamStats> PARSER =
      new com.google.protobuf.AbstractParser<StreamStats>() {
        @java.lang.Override
        public StreamStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.StreamStats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
