/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.storage.v1beta2;

/**
 *
 *
 * <pre>
 * Response message for `BatchCommitWriteStreams`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse}
 */
public final class BatchCommitWriteStreamsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse)
    BatchCommitWriteStreamsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchCommitWriteStreamsResponse.newBuilder() to construct.
  private BatchCommitWriteStreamsResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchCommitWriteStreamsResponse() {
    streamErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchCommitWriteStreamsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_BatchCommitWriteStreamsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_BatchCommitWriteStreamsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.class,
            com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.Builder
                .class);
  }

  private int bitField0_;
  public static final int COMMIT_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp commitTime_;
  /**
   *
   *
   * <pre>
   * The time at which streams were committed in microseconds granularity.
   * This field will only exist when there are no stream errors.
   * **Note** if this field is not set, it means the commit was not successful.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 1;</code>
   *
   * @return Whether the commitTime field is set.
   */
  @java.lang.Override
  public boolean hasCommitTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which streams were committed in microseconds granularity.
   * This field will only exist when there are no stream errors.
   * **Note** if this field is not set, it means the commit was not successful.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 1;</code>
   *
   * @return The commitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTime() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which streams were committed in microseconds granularity.
   * This field will only exist when there are no stream errors.
   * **Note** if this field is not set, it means the commit was not successful.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }

  public static final int STREAM_ERRORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1beta2.StorageError> streamErrors_;
  /**
   *
   *
   * <pre>
   * Stream level error if commit failed. Only streams with error will be in
   * the list.
   * If empty, there is no error and all streams are committed successfully.
   * If non empty, certain streams have errors and ZERO stream is committed due
   * to atomicity guarantee.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1beta2.StorageError>
      getStreamErrorsList() {
    return streamErrors_;
  }
  /**
   *
   *
   * <pre>
   * Stream level error if commit failed. Only streams with error will be in
   * the list.
   * If empty, there is no error and all streams are committed successfully.
   * If non empty, certain streams have errors and ZERO stream is committed due
   * to atomicity guarantee.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder>
      getStreamErrorsOrBuilderList() {
    return streamErrors_;
  }
  /**
   *
   *
   * <pre>
   * Stream level error if commit failed. Only streams with error will be in
   * the list.
   * If empty, there is no error and all streams are committed successfully.
   * If non empty, certain streams have errors and ZERO stream is committed due
   * to atomicity guarantee.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
   */
  @java.lang.Override
  public int getStreamErrorsCount() {
    return streamErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Stream level error if commit failed. Only streams with error will be in
   * the list.
   * If empty, there is no error and all streams are committed successfully.
   * If non empty, certain streams have errors and ZERO stream is committed due
   * to atomicity guarantee.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.StorageError getStreamErrors(int index) {
    return streamErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Stream level error if commit failed. Only streams with error will be in
   * the list.
   * If empty, there is no error and all streams are committed successfully.
   * If non empty, certain streams have errors and ZERO stream is committed due
   * to atomicity guarantee.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder getStreamErrorsOrBuilder(
      int index) {
    return streamErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommitTime());
    }
    for (int i = 0; i < streamErrors_.size(); i++) {
      output.writeMessage(2, streamErrors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommitTime());
    }
    for (int i = 0; i < streamErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, streamErrors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse other =
        (com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse) obj;

    if (hasCommitTime() != other.hasCommitTime()) return false;
    if (hasCommitTime()) {
      if (!getCommitTime().equals(other.getCommitTime())) return false;
    }
    if (!getStreamErrorsList().equals(other.getStreamErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommitTime()) {
      hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTime().hashCode();
    }
    if (getStreamErrorsCount() > 0) {
      hash = (37 * hash) + STREAM_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getStreamErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for `BatchCommitWriteStreams`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse)
      com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_BatchCommitWriteStreamsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_BatchCommitWriteStreamsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.class,
              com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommitTimeFieldBuilder();
        getStreamErrorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      if (streamErrorsBuilder_ == null) {
        streamErrors_ = java.util.Collections.emptyList();
      } else {
        streamErrors_ = null;
        streamErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_BatchCommitWriteStreamsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse build() {
      com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
        buildPartial() {
      com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse result =
          new com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse result) {
      if (streamErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          streamErrors_ = java.util.Collections.unmodifiableList(streamErrors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.streamErrors_ = streamErrors_;
      } else {
        result.streamErrors_ = streamErrorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commitTime_ = commitTimeBuilder_ == null ? commitTime_ : commitTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse) {
        return mergeFrom(
            (com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse other) {
      if (other
          == com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
              .getDefaultInstance()) return this;
      if (other.hasCommitTime()) {
        mergeCommitTime(other.getCommitTime());
      }
      if (streamErrorsBuilder_ == null) {
        if (!other.streamErrors_.isEmpty()) {
          if (streamErrors_.isEmpty()) {
            streamErrors_ = other.streamErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStreamErrorsIsMutable();
            streamErrors_.addAll(other.streamErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.streamErrors_.isEmpty()) {
          if (streamErrorsBuilder_.isEmpty()) {
            streamErrorsBuilder_.dispose();
            streamErrorsBuilder_ = null;
            streamErrors_ = other.streamErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            streamErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStreamErrorsFieldBuilder()
                    : null;
          } else {
            streamErrorsBuilder_.addAllMessages(other.streamErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCommitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.bigquery.storage.v1beta2.StorageError m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1beta2.StorageError.parser(),
                        extensionRegistry);
                if (streamErrorsBuilder_ == null) {
                  ensureStreamErrorsIsMutable();
                  streamErrors_.add(m);
                } else {
                  streamErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp commitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return Whether the commitTime field is set.
     */
    public boolean hasCommitTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     *
     * @return The commitTime.
     */
    public com.google.protobuf.Timestamp getCommitTime() {
      if (commitTimeBuilder_ == null) {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      } else {
        return commitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitTime_ = value;
      } else {
        commitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimeBuilder_ == null) {
        commitTime_ = builderForValue.build();
      } else {
        commitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && commitTime_ != null
            && commitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitTimeBuilder().mergeFrom(value);
        } else {
          commitTime_ = value;
        }
      } else {
        commitTimeBuilder_.mergeFrom(value);
      }
      if (commitTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public Builder clearCommitTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCommitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      if (commitTimeBuilder_ != null) {
        return commitTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which streams were committed in microseconds granularity.
     * This field will only exist when there are no stream errors.
     * **Note** if this field is not set, it means the commit was not successful.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimeFieldBuilder() {
      if (commitTimeBuilder_ == null) {
        commitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitTime(), getParentForChildren(), isClean());
        commitTime_ = null;
      }
      return commitTimeBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1beta2.StorageError> streamErrors_ =
        java.util.Collections.emptyList();

    private void ensureStreamErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        streamErrors_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1beta2.StorageError>(
                streamErrors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StorageError,
            com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder>
        streamErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1beta2.StorageError>
        getStreamErrorsList() {
      if (streamErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(streamErrors_);
      } else {
        return streamErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public int getStreamErrorsCount() {
      if (streamErrorsBuilder_ == null) {
        return streamErrors_.size();
      } else {
        return streamErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StorageError getStreamErrors(int index) {
      if (streamErrorsBuilder_ == null) {
        return streamErrors_.get(index);
      } else {
        return streamErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder setStreamErrors(
        int index, com.google.cloud.bigquery.storage.v1beta2.StorageError value) {
      if (streamErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamErrorsIsMutable();
        streamErrors_.set(index, value);
        onChanged();
      } else {
        streamErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder setStreamErrors(
        int index, com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder builderForValue) {
      if (streamErrorsBuilder_ == null) {
        ensureStreamErrorsIsMutable();
        streamErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        streamErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder addStreamErrors(com.google.cloud.bigquery.storage.v1beta2.StorageError value) {
      if (streamErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamErrorsIsMutable();
        streamErrors_.add(value);
        onChanged();
      } else {
        streamErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder addStreamErrors(
        int index, com.google.cloud.bigquery.storage.v1beta2.StorageError value) {
      if (streamErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamErrorsIsMutable();
        streamErrors_.add(index, value);
        onChanged();
      } else {
        streamErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder addStreamErrors(
        com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder builderForValue) {
      if (streamErrorsBuilder_ == null) {
        ensureStreamErrorsIsMutable();
        streamErrors_.add(builderForValue.build());
        onChanged();
      } else {
        streamErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder addStreamErrors(
        int index, com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder builderForValue) {
      if (streamErrorsBuilder_ == null) {
        ensureStreamErrorsIsMutable();
        streamErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        streamErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder addAllStreamErrors(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1beta2.StorageError>
            values) {
      if (streamErrorsBuilder_ == null) {
        ensureStreamErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, streamErrors_);
        onChanged();
      } else {
        streamErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder clearStreamErrors() {
      if (streamErrorsBuilder_ == null) {
        streamErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        streamErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public Builder removeStreamErrors(int index) {
      if (streamErrorsBuilder_ == null) {
        ensureStreamErrorsIsMutable();
        streamErrors_.remove(index);
        onChanged();
      } else {
        streamErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder getStreamErrorsBuilder(
        int index) {
      return getStreamErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder getStreamErrorsOrBuilder(
        int index) {
      if (streamErrorsBuilder_ == null) {
        return streamErrors_.get(index);
      } else {
        return streamErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder>
        getStreamErrorsOrBuilderList() {
      if (streamErrorsBuilder_ != null) {
        return streamErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(streamErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder addStreamErrorsBuilder() {
      return getStreamErrorsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1beta2.StorageError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder addStreamErrorsBuilder(
        int index) {
      return getStreamErrorsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.storage.v1beta2.StorageError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Stream level error if commit failed. Only streams with error will be in
     * the list.
     * If empty, there is no error and all streams are committed successfully.
     * If non empty, certain streams have errors and ZERO stream is committed due
     * to atomicity guarantee.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.storage.v1beta2.StorageError stream_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder>
        getStreamErrorsBuilderList() {
      return getStreamErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StorageError,
            com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder>
        getStreamErrorsFieldBuilder() {
      if (streamErrorsBuilder_ == null) {
        streamErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.StorageError,
                com.google.cloud.bigquery.storage.v1beta2.StorageError.Builder,
                com.google.cloud.bigquery.storage.v1beta2.StorageErrorOrBuilder>(
                streamErrors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        streamErrors_ = null;
      }
      return streamErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse)
  private static final com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse();
  }

  public static com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchCommitWriteStreamsResponse>() {
        @java.lang.Override
        public BatchCommitWriteStreamsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchCommitWriteStreamsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
