/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/table.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A backup of a Cloud Bigtable table.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Backup}
 */
public final class Backup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Backup)
    BackupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Backup.newBuilder() to construct.
  private Backup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Backup() {
    name_ = "";
    sourceTable_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Backup();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Backup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Backup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Backup.class,
            com.google.bigtable.admin.v2.Backup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the backup.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Backup.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The pending backup is still being created. Operations on the
     * backup may fail with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The backup is complete and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The pending backup is still being created. Operations on the
     * backup may fail with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The backup is complete and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Backup.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Backup.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}/
   *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
   * The final segment of the name must be between 1 and 50 characters
   * in length.
   * The backup is stored in the cluster identified by the prefix of the backup
   * name of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}/
   *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
   * The final segment of the name must be between 1 and 50 characters
   * in length.
   * The backup is stored in the cluster identified by the prefix of the backup
   * name of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TABLE_FIELD_NUMBER = 2;
  private volatile java.lang.Object sourceTable_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. Name of the table from which this backup was created. This needs
   * to be in the same instance as the backup. Values are of the form
   * `projects/{project}/instances/{instance}/tables/{source_table}`.
   * </pre>
   *
   * <code>
   * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The sourceTable.
   */
  @java.lang.Override
  public java.lang.String getSourceTable() {
    java.lang.Object ref = sourceTable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceTable_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. Name of the table from which this backup was created. This needs
   * to be in the same instance as the backup. Values are of the form
   * `projects/{project}/instances/{instance}/tables/{source_table}`.
   * </pre>
   *
   * <code>
   * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for sourceTable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceTableBytes() {
    java.lang.Object ref = sourceTable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceTable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time`
   * has passed, Cloud Bigtable will delete the backup and free the
   * resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time`
   * has passed, Cloud Bigtable will delete the backup and free the
   * resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 30 days
   * from the time the request is received. Once the `expire_time`
   * has passed, Cloud Bigtable will delete the backup and free the
   * resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return getExpireTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. `start_time` is the time that the backup was started
   * (i.e. approximately the time the
   * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
   * row data in this backup will be no older than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. `start_time` is the time that the backup was started
   * (i.e. approximately the time the
   * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
   * row data in this backup will be no older than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. `start_time` is the time that the backup was started
   * (i.e. approximately the time the
   * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
   * row data in this backup will be no older than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. `end_time` is the time that the backup was finished. The row
   * data in the backup will be no newer than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. `end_time` is the time that the backup was finished. The row
   * data in the backup will be no newer than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. `end_time` is the time that the backup was finished. The row
   * data in the backup will be no newer than this timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int SIZE_BYTES_FIELD_NUMBER = 6;
  private long sizeBytes_;
  /**
   *
   *
   * <pre>
   * Output only. Size of the backup in bytes.
   * </pre>
   *
   * <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sizeBytes.
   */
  @java.lang.Override
  public long getSizeBytes() {
    return sizeBytes_;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Backup.State getState() {
    @SuppressWarnings("deprecation")
    com.google.bigtable.admin.v2.Backup.State result =
        com.google.bigtable.admin.v2.Backup.State.valueOf(state_);
    return result == null ? com.google.bigtable.admin.v2.Backup.State.UNRECOGNIZED : result;
  }

  public static final int ENCRYPTION_INFO_FIELD_NUMBER = 9;
  private com.google.bigtable.admin.v2.EncryptionInfo encryptionInfo_;
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionInfo field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionInfo() {
    return encryptionInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionInfo.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.EncryptionInfo getEncryptionInfo() {
    return encryptionInfo_ == null
        ? com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance()
        : encryptionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder() {
    return getEncryptionInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceTable_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceTable_);
    }
    if (expireTime_ != null) {
      output.writeMessage(3, getExpireTime());
    }
    if (startTime_ != null) {
      output.writeMessage(4, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(5, getEndTime());
    }
    if (sizeBytes_ != 0L) {
      output.writeInt64(6, sizeBytes_);
    }
    if (state_ != com.google.bigtable.admin.v2.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (encryptionInfo_ != null) {
      output.writeMessage(9, getEncryptionInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceTable_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceTable_);
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExpireTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (sizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, sizeBytes_);
    }
    if (state_ != com.google.bigtable.admin.v2.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (encryptionInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getEncryptionInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Backup)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Backup other = (com.google.bigtable.admin.v2.Backup) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getSourceTable().equals(other.getSourceTable())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (getSizeBytes() != other.getSizeBytes()) return false;
    if (state_ != other.state_) return false;
    if (hasEncryptionInfo() != other.hasEncryptionInfo()) return false;
    if (hasEncryptionInfo()) {
      if (!getEncryptionInfo().equals(other.getEncryptionInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SOURCE_TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceTable().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSizeBytes());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasEncryptionInfo()) {
      hash = (37 * hash) + ENCRYPTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Backup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Backup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Backup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Backup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A backup of a Cloud Bigtable table.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Backup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Backup)
      com.google.bigtable.admin.v2.BackupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Backup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Backup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Backup.class,
              com.google.bigtable.admin.v2.Backup.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Backup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      sourceTable_ = "";

      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      sizeBytes_ = 0L;

      state_ = 0;

      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = null;
      } else {
        encryptionInfo_ = null;
        encryptionInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Backup_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Backup getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Backup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Backup build() {
      com.google.bigtable.admin.v2.Backup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Backup buildPartial() {
      com.google.bigtable.admin.v2.Backup result = new com.google.bigtable.admin.v2.Backup(this);
      result.name_ = name_;
      result.sourceTable_ = sourceTable_;
      if (expireTimeBuilder_ == null) {
        result.expireTime_ = expireTime_;
      } else {
        result.expireTime_ = expireTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.sizeBytes_ = sizeBytes_;
      result.state_ = state_;
      if (encryptionInfoBuilder_ == null) {
        result.encryptionInfo_ = encryptionInfo_;
      } else {
        result.encryptionInfo_ = encryptionInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Backup) {
        return mergeFrom((com.google.bigtable.admin.v2.Backup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Backup other) {
      if (other == com.google.bigtable.admin.v2.Backup.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getSourceTable().isEmpty()) {
        sourceTable_ = other.sourceTable_;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getSizeBytes() != 0L) {
        setSizeBytes(other.getSizeBytes());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasEncryptionInfo()) {
        mergeEncryptionInfo(other.getEncryptionInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                sourceTable_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 48:
              {
                sizeBytes_ = input.readInt64();

                break;
              } // case 48
            case 56:
              {
                state_ = input.readEnum();

                break;
              } // case 56
            case 74:
              {
                input.readMessage(getEncryptionInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/
     *    backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
     * The final segment of the name must be between 1 and 50 characters
     * in length.
     * The backup is stored in the cluster identified by the prefix of the backup
     * name of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sourceTable_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. Name of the table from which this backup was created. This needs
     * to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     * </pre>
     *
     * <code>
     * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The sourceTable.
     */
    public java.lang.String getSourceTable() {
      java.lang.Object ref = sourceTable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceTable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Name of the table from which this backup was created. This needs
     * to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     * </pre>
     *
     * <code>
     * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for sourceTable.
     */
    public com.google.protobuf.ByteString getSourceTableBytes() {
      java.lang.Object ref = sourceTable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Name of the table from which this backup was created. This needs
     * to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     * </pre>
     *
     * <code>
     * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The sourceTable to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sourceTable_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Name of the table from which this backup was created. This needs
     * to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     * </pre>
     *
     * <code>
     * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceTable() {

      sourceTable_ = getDefaultInstance().getSourceTable();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. Name of the table from which this backup was created. This needs
     * to be in the same instance as the backup. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{source_table}`.
     * </pre>
     *
     * <code>
     * string source_table = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for sourceTable to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sourceTable_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return expireTimeBuilder_ != null || expireTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expireTime_ != null) {
          expireTime_ =
              com.google.protobuf.Timestamp.newBuilder(expireTime_).mergeFrom(value).buildPartial();
        } else {
          expireTime_ = value;
        }
        onChanged();
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        expireTime_ = null;
        onChanged();
      } else {
        expireTime_ = null;
        expireTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {

      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 30 days
     * from the time the request is received. Once the `expire_time`
     * has passed, Cloud Bigtable will delete the backup and free the
     * resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `start_time` is the time that the backup was started
     * (i.e. approximately the time the
     * [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup] request is received).  The
     * row data in this backup will be no older than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. `end_time` is the time that the backup was finished. The row
     * data in the backup will be no newer than this timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private long sizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sizeBytes.
     */
    @java.lang.Override
    public long getSizeBytes() {
      return sizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setSizeBytes(long value) {

      sizeBytes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSizeBytes() {

      sizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Backup.State getState() {
      @SuppressWarnings("deprecation")
      com.google.bigtable.admin.v2.Backup.State result =
          com.google.bigtable.admin.v2.Backup.State.valueOf(state_);
      return result == null ? com.google.bigtable.admin.v2.Backup.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.bigtable.admin.v2.Backup.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Backup.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.EncryptionInfo encryptionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.EncryptionInfo,
            com.google.bigtable.admin.v2.EncryptionInfo.Builder,
            com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
        encryptionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the encryptionInfo field is set.
     */
    public boolean hasEncryptionInfo() {
      return encryptionInfoBuilder_ != null || encryptionInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionInfo.
     */
    public com.google.bigtable.admin.v2.EncryptionInfo getEncryptionInfo() {
      if (encryptionInfoBuilder_ == null) {
        return encryptionInfo_ == null
            ? com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance()
            : encryptionInfo_;
      } else {
        return encryptionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(com.google.bigtable.admin.v2.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionInfo_ = value;
        onChanged();
      } else {
        encryptionInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(
        com.google.bigtable.admin.v2.EncryptionInfo.Builder builderForValue) {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = builderForValue.build();
        onChanged();
      } else {
        encryptionInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEncryptionInfo(com.google.bigtable.admin.v2.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (encryptionInfo_ != null) {
          encryptionInfo_ =
              com.google.bigtable.admin.v2.EncryptionInfo.newBuilder(encryptionInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionInfo_ = value;
        }
        onChanged();
      } else {
        encryptionInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionInfo() {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = null;
        onChanged();
      } else {
        encryptionInfo_ = null;
        encryptionInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.bigtable.admin.v2.EncryptionInfo.Builder getEncryptionInfoBuilder() {

      onChanged();
      return getEncryptionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.bigtable.admin.v2.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder() {
      if (encryptionInfoBuilder_ != null) {
        return encryptionInfoBuilder_.getMessageOrBuilder();
      } else {
        return encryptionInfo_ == null
            ? com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance()
            : encryptionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo encryption_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.EncryptionInfo,
            com.google.bigtable.admin.v2.EncryptionInfo.Builder,
            com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
        getEncryptionInfoFieldBuilder() {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.EncryptionInfo,
                com.google.bigtable.admin.v2.EncryptionInfo.Builder,
                com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>(
                getEncryptionInfo(), getParentForChildren(), isClean());
        encryptionInfo_ = null;
      }
      return encryptionInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Backup)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Backup)
  private static final com.google.bigtable.admin.v2.Backup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Backup();
  }

  public static com.google.bigtable.admin.v2.Backup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Backup> PARSER =
      new com.google.protobuf.AbstractParser<Backup>() {
        @java.lang.Override
        public Backup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Backup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Backup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Backup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
