/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Response message for BigtableInstanceAdmin.ListInstances.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.ListInstancesResponse}
 */
public final class ListInstancesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.ListInstancesResponse)
    ListInstancesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListInstancesResponse.newBuilder() to construct.
  private ListInstancesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListInstancesResponse() {
    instances_ = java.util.Collections.emptyList();
    failedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListInstancesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_ListInstancesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_ListInstancesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.ListInstancesResponse.class,
            com.google.bigtable.admin.v2.ListInstancesResponse.Builder.class);
  }

  public static final int INSTANCES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.bigtable.admin.v2.Instance> instances_;
  /**
   *
   *
   * <pre>
   * The list of requested instances.
   * </pre>
   *
   * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.admin.v2.Instance> getInstancesList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * The list of requested instances.
   * </pre>
   *
   * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.admin.v2.InstanceOrBuilder>
      getInstancesOrBuilderList() {
    return instances_;
  }
  /**
   *
   *
   * <pre>
   * The list of requested instances.
   * </pre>
   *
   * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
   */
  @java.lang.Override
  public int getInstancesCount() {
    return instances_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of requested instances.
   * </pre>
   *
   * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Instance getInstances(int index) {
    return instances_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of requested instances.
   * </pre>
   *
   * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.InstanceOrBuilder getInstancesOrBuilder(int index) {
    return instances_.get(index);
  }

  public static final int FAILED_LOCATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList failedLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Locations from which Instance information could not be retrieved,
   * due to an outage or some other transient condition.
   * Instances whose Clusters are all in one of the failed locations
   * may be missing from `instances`, and Instances with at least one
   * Cluster in a failed location may only have partial information returned.
   * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
   * </pre>
   *
   * <code>repeated string failed_locations = 2;</code>
   *
   * @return A list containing the failedLocations.
   */
  public com.google.protobuf.ProtocolStringList getFailedLocationsList() {
    return failedLocations_;
  }
  /**
   *
   *
   * <pre>
   * Locations from which Instance information could not be retrieved,
   * due to an outage or some other transient condition.
   * Instances whose Clusters are all in one of the failed locations
   * may be missing from `instances`, and Instances with at least one
   * Cluster in a failed location may only have partial information returned.
   * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
   * </pre>
   *
   * <code>repeated string failed_locations = 2;</code>
   *
   * @return The count of failedLocations.
   */
  public int getFailedLocationsCount() {
    return failedLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * Locations from which Instance information could not be retrieved,
   * due to an outage or some other transient condition.
   * Instances whose Clusters are all in one of the failed locations
   * may be missing from `instances`, and Instances with at least one
   * Cluster in a failed location may only have partial information returned.
   * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
   * </pre>
   *
   * <code>repeated string failed_locations = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The failedLocations at the given index.
   */
  public java.lang.String getFailedLocations(int index) {
    return failedLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Locations from which Instance information could not be retrieved,
   * due to an outage or some other transient condition.
   * Instances whose Clusters are all in one of the failed locations
   * may be missing from `instances`, and Instances with at least one
   * Cluster in a failed location may only have partial information returned.
   * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
   * </pre>
   *
   * <code>repeated string failed_locations = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the failedLocations at the given index.
   */
  public com.google.protobuf.ByteString getFailedLocationsBytes(int index) {
    return failedLocations_.getByteString(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * DEPRECATED: This field is unused and ignored.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED: This field is unused and ignored.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < instances_.size(); i++) {
      output.writeMessage(1, instances_.get(i));
    }
    for (int i = 0; i < failedLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, failedLocations_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < instances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, instances_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < failedLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(failedLocations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFailedLocationsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.ListInstancesResponse)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.ListInstancesResponse other =
        (com.google.bigtable.admin.v2.ListInstancesResponse) obj;

    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (!getFailedLocationsList().equals(other.getFailedLocationsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (getFailedLocationsCount() > 0) {
      hash = (37 * hash) + FAILED_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFailedLocationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.ListInstancesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for BigtableInstanceAdmin.ListInstances.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.ListInstancesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.ListInstancesResponse)
      com.google.bigtable.admin.v2.ListInstancesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_ListInstancesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_ListInstancesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.ListInstancesResponse.class,
              com.google.bigtable.admin.v2.ListInstancesResponse.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.ListInstancesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
      } else {
        instances_ = null;
        instancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      failedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_ListInstancesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListInstancesResponse getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.ListInstancesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListInstancesResponse build() {
      com.google.bigtable.admin.v2.ListInstancesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ListInstancesResponse buildPartial() {
      com.google.bigtable.admin.v2.ListInstancesResponse result =
          new com.google.bigtable.admin.v2.ListInstancesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.bigtable.admin.v2.ListInstancesResponse result) {
      if (instancesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          instances_ = java.util.Collections.unmodifiableList(instances_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.instances_ = instances_;
      } else {
        result.instances_ = instancesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.bigtable.admin.v2.ListInstancesResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        failedLocations_.makeImmutable();
        result.failedLocations_ = failedLocations_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.ListInstancesResponse) {
        return mergeFrom((com.google.bigtable.admin.v2.ListInstancesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.ListInstancesResponse other) {
      if (other == com.google.bigtable.admin.v2.ListInstancesResponse.getDefaultInstance())
        return this;
      if (instancesBuilder_ == null) {
        if (!other.instances_.isEmpty()) {
          if (instances_.isEmpty()) {
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInstancesIsMutable();
            instances_.addAll(other.instances_);
          }
          onChanged();
        }
      } else {
        if (!other.instances_.isEmpty()) {
          if (instancesBuilder_.isEmpty()) {
            instancesBuilder_.dispose();
            instancesBuilder_ = null;
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000001);
            instancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstancesFieldBuilder()
                    : null;
          } else {
            instancesBuilder_.addAllMessages(other.instances_);
          }
        }
      }
      if (!other.failedLocations_.isEmpty()) {
        if (failedLocations_.isEmpty()) {
          failedLocations_ = other.failedLocations_;
          bitField0_ |= 0x00000002;
        } else {
          ensureFailedLocationsIsMutable();
          failedLocations_.addAll(other.failedLocations_);
        }
        onChanged();
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.bigtable.admin.v2.Instance m =
                    input.readMessage(
                        com.google.bigtable.admin.v2.Instance.parser(), extensionRegistry);
                if (instancesBuilder_ == null) {
                  ensureInstancesIsMutable();
                  instances_.add(m);
                } else {
                  instancesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFailedLocationsIsMutable();
                failedLocations_.add(s);
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.bigtable.admin.v2.Instance> instances_ =
        java.util.Collections.emptyList();

    private void ensureInstancesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        instances_ = new java.util.ArrayList<com.google.bigtable.admin.v2.Instance>(instances_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.admin.v2.Instance,
            com.google.bigtable.admin.v2.Instance.Builder,
            com.google.bigtable.admin.v2.InstanceOrBuilder>
        instancesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public java.util.List<com.google.bigtable.admin.v2.Instance> getInstancesList() {
      if (instancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instances_);
      } else {
        return instancesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public int getInstancesCount() {
      if (instancesBuilder_ == null) {
        return instances_.size();
      } else {
        return instancesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public com.google.bigtable.admin.v2.Instance getInstances(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder setInstances(int index, com.google.bigtable.admin.v2.Instance value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.set(index, value);
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder setInstances(
        int index, com.google.bigtable.admin.v2.Instance.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.set(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder addInstances(com.google.bigtable.admin.v2.Instance value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder addInstances(int index, com.google.bigtable.admin.v2.Instance value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(index, value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder addInstances(com.google.bigtable.admin.v2.Instance.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder addInstances(
        int index, com.google.bigtable.admin.v2.Instance.Builder builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder addAllInstances(
        java.lang.Iterable<? extends com.google.bigtable.admin.v2.Instance> values) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
        onChanged();
      } else {
        instancesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder clearInstances() {
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        instancesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public Builder removeInstances(int index) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.remove(index);
        onChanged();
      } else {
        instancesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public com.google.bigtable.admin.v2.Instance.Builder getInstancesBuilder(int index) {
      return getInstancesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public com.google.bigtable.admin.v2.InstanceOrBuilder getInstancesOrBuilder(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public java.util.List<? extends com.google.bigtable.admin.v2.InstanceOrBuilder>
        getInstancesOrBuilderList() {
      if (instancesBuilder_ != null) {
        return instancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instances_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public com.google.bigtable.admin.v2.Instance.Builder addInstancesBuilder() {
      return getInstancesFieldBuilder()
          .addBuilder(com.google.bigtable.admin.v2.Instance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public com.google.bigtable.admin.v2.Instance.Builder addInstancesBuilder(int index) {
      return getInstancesFieldBuilder()
          .addBuilder(index, com.google.bigtable.admin.v2.Instance.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of requested instances.
     * </pre>
     *
     * <code>repeated .google.bigtable.admin.v2.Instance instances = 1;</code>
     */
    public java.util.List<com.google.bigtable.admin.v2.Instance.Builder> getInstancesBuilderList() {
      return getInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.admin.v2.Instance,
            com.google.bigtable.admin.v2.Instance.Builder,
            com.google.bigtable.admin.v2.InstanceOrBuilder>
        getInstancesFieldBuilder() {
      if (instancesBuilder_ == null) {
        instancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.admin.v2.Instance,
                com.google.bigtable.admin.v2.Instance.Builder,
                com.google.bigtable.admin.v2.InstanceOrBuilder>(
                instances_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        instances_ = null;
      }
      return instancesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList failedLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFailedLocationsIsMutable() {
      if (!failedLocations_.isModifiable()) {
        failedLocations_ = new com.google.protobuf.LazyStringArrayList(failedLocations_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @return A list containing the failedLocations.
     */
    public com.google.protobuf.ProtocolStringList getFailedLocationsList() {
      failedLocations_.makeImmutable();
      return failedLocations_;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @return The count of failedLocations.
     */
    public int getFailedLocationsCount() {
      return failedLocations_.size();
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The failedLocations at the given index.
     */
    public java.lang.String getFailedLocations(int index) {
      return failedLocations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the failedLocations at the given index.
     */
    public com.google.protobuf.ByteString getFailedLocationsBytes(int index) {
      return failedLocations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The failedLocations to set.
     * @return This builder for chaining.
     */
    public Builder setFailedLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFailedLocationsIsMutable();
      failedLocations_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param value The failedLocations to add.
     * @return This builder for chaining.
     */
    public Builder addFailedLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFailedLocationsIsMutable();
      failedLocations_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param values The failedLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllFailedLocations(java.lang.Iterable<java.lang.String> values) {
      ensureFailedLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, failedLocations_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedLocations() {
      failedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations from which Instance information could not be retrieved,
     * due to an outage or some other transient condition.
     * Instances whose Clusters are all in one of the failed locations
     * may be missing from `instances`, and Instances with at least one
     * Cluster in a failed location may only have partial information returned.
     * Values are of the form `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
     * </pre>
     *
     * <code>repeated string failed_locations = 2;</code>
     *
     * @param value The bytes of the failedLocations to add.
     * @return This builder for chaining.
     */
    public Builder addFailedLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFailedLocationsIsMutable();
      failedLocations_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * DEPRECATED: This field is unused and ignored.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED: This field is unused and ignored.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED: This field is unused and ignored.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED: This field is unused and ignored.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED: This field is unused and ignored.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.ListInstancesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.ListInstancesResponse)
  private static final com.google.bigtable.admin.v2.ListInstancesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.ListInstancesResponse();
  }

  public static com.google.bigtable.admin.v2.ListInstancesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListInstancesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListInstancesResponse>() {
        @java.lang.Override
        public ListInstancesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListInstancesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListInstancesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.ListInstancesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
