/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies][google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies]
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.ModifyColumnFamiliesRequest}
 */
public final class ModifyColumnFamiliesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.ModifyColumnFamiliesRequest)
    ModifyColumnFamiliesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModifyColumnFamiliesRequest.newBuilder() to construct.
  private ModifyColumnFamiliesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModifyColumnFamiliesRequest() {
    name_ = "";
    modifications_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModifyColumnFamiliesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.class,
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Builder.class);
  }

  public interface ModificationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The ID of the column family to be modified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The ID of the column family to be modified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     *
     * @return Whether the create field is set.
     */
    boolean hasCreate();
    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     *
     * @return The create.
     */
    com.google.bigtable.admin.v2.ColumnFamily getCreate();
    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     */
    com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getCreateOrBuilder();

    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     *
     * @return Whether the update field is set.
     */
    boolean hasUpdate();
    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     *
     * @return The update.
     */
    com.google.bigtable.admin.v2.ColumnFamily getUpdate();
    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     */
    com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getUpdateOrBuilder();

    /**
     *
     *
     * <pre>
     * Drop (delete) the column family with the given ID, or fail if no such
     * family exists.
     * </pre>
     *
     * <code>bool drop = 4;</code>
     *
     * @return Whether the drop field is set.
     */
    boolean hasDrop();
    /**
     *
     *
     * <pre>
     * Drop (delete) the column family with the given ID, or fail if no such
     * family exists.
     * </pre>
     *
     * <code>bool drop = 4;</code>
     *
     * @return The drop.
     */
    boolean getDrop();

    com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.ModCase getModCase();
  }
  /**
   *
   *
   * <pre>
   * A create, update, or delete of a particular column family.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification}
   */
  public static final class Modification extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)
      ModificationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Modification.newBuilder() to construct.
    private Modification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Modification() {
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Modification();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_Modification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_Modification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.class,
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder.class);
    }

    private int modCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object mod_;

    public enum ModCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CREATE(2),
      UPDATE(3),
      DROP(4),
      MOD_NOT_SET(0);
      private final int value;

      private ModCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ModCase valueOf(int value) {
        return forNumber(value);
      }

      public static ModCase forNumber(int value) {
        switch (value) {
          case 2:
            return CREATE;
          case 3:
            return UPDATE;
          case 4:
            return DROP;
          case 0:
            return MOD_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ModCase getModCase() {
      return ModCase.forNumber(modCase_);
    }

    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the column family to be modified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the column family to be modified.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     *
     * @return Whether the create field is set.
     */
    @java.lang.Override
    public boolean hasCreate() {
      return modCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     *
     * @return The create.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamily getCreate() {
      if (modCase_ == 2) {
        return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
      }
      return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Create a new column family with the specified schema, or fail if
     * one already exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getCreateOrBuilder() {
      if (modCase_ == 2) {
        return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
      }
      return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
    }

    public static final int UPDATE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     *
     * @return Whether the update field is set.
     */
    @java.lang.Override
    public boolean hasUpdate() {
      return modCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     *
     * @return The update.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamily getUpdate() {
      if (modCase_ == 3) {
        return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
      }
      return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Update an existing column family to the specified schema, or fail
     * if no column family exists with the given ID.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getUpdateOrBuilder() {
      if (modCase_ == 3) {
        return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
      }
      return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
    }

    public static final int DROP_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Drop (delete) the column family with the given ID, or fail if no such
     * family exists.
     * </pre>
     *
     * <code>bool drop = 4;</code>
     *
     * @return Whether the drop field is set.
     */
    @java.lang.Override
    public boolean hasDrop() {
      return modCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Drop (delete) the column family with the given ID, or fail if no such
     * family exists.
     * </pre>
     *
     * <code>bool drop = 4;</code>
     *
     * @return The drop.
     */
    @java.lang.Override
    public boolean getDrop() {
      if (modCase_ == 4) {
        return (java.lang.Boolean) mod_;
      }
      return false;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (modCase_ == 2) {
        output.writeMessage(2, (com.google.bigtable.admin.v2.ColumnFamily) mod_);
      }
      if (modCase_ == 3) {
        output.writeMessage(3, (com.google.bigtable.admin.v2.ColumnFamily) mod_);
      }
      if (modCase_ == 4) {
        output.writeBool(4, (boolean) ((java.lang.Boolean) mod_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (modCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.bigtable.admin.v2.ColumnFamily) mod_);
      }
      if (modCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.bigtable.admin.v2.ColumnFamily) mod_);
      }
      if (modCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, (boolean) ((java.lang.Boolean) mod_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification other =
          (com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification) obj;

      if (!getId().equals(other.getId())) return false;
      if (!getModCase().equals(other.getModCase())) return false;
      switch (modCase_) {
        case 2:
          if (!getCreate().equals(other.getCreate())) return false;
          break;
        case 3:
          if (!getUpdate().equals(other.getUpdate())) return false;
          break;
        case 4:
          if (getDrop() != other.getDrop()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      switch (modCase_) {
        case 2:
          hash = (37 * hash) + CREATE_FIELD_NUMBER;
          hash = (53 * hash) + getCreate().hashCode();
          break;
        case 3:
          hash = (37 * hash) + UPDATE_FIELD_NUMBER;
          hash = (53 * hash) + getUpdate().hashCode();
          break;
        case 4:
          hash = (37 * hash) + DROP_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDrop());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A create, update, or delete of a particular column family.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.BigtableTableAdminProto
            .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_Modification_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.BigtableTableAdminProto
            .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_Modification_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.class,
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
                    .class);
      }

      // Construct using
      // com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        if (createBuilder_ != null) {
          createBuilder_.clear();
        }
        if (updateBuilder_ != null) {
          updateBuilder_.clear();
        }
        modCase_ = 0;
        mod_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.BigtableTableAdminProto
            .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_Modification_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification build() {
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification buildPartial() {
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification result =
            new com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
      }

      private void buildPartialOneofs(
          com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification result) {
        result.modCase_ = modCase_;
        result.mod_ = this.mod_;
        if (modCase_ == 2 && createBuilder_ != null) {
          result.mod_ = createBuilder_.build();
        }
        if (modCase_ == 3 && updateBuilder_ != null) {
          result.mod_ = updateBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification) {
          return mergeFrom(
              (com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification other) {
        if (other
            == com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
                .getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getModCase()) {
          case CREATE:
            {
              mergeCreate(other.getCreate());
              break;
            }
          case UPDATE:
            {
              mergeUpdate(other.getUpdate());
              break;
            }
          case DROP:
            {
              setDrop(other.getDrop());
              break;
            }
          case MOD_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getCreateFieldBuilder().getBuilder(), extensionRegistry);
                  modCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getUpdateFieldBuilder().getBuilder(), extensionRegistry);
                  modCase_ = 3;
                  break;
                } // case 26
              case 32:
                {
                  mod_ = input.readBool();
                  modCase_ = 4;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int modCase_ = 0;
      private java.lang.Object mod_;

      public ModCase getModCase() {
        return ModCase.forNumber(modCase_);
      }

      public Builder clearMod() {
        modCase_ = 0;
        mod_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the column family to be modified.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the column family to be modified.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the column family to be modified.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the column family to be modified.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the column family to be modified.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.ColumnFamily,
              com.google.bigtable.admin.v2.ColumnFamily.Builder,
              com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>
          createBuilder_;
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       *
       * @return Whether the create field is set.
       */
      @java.lang.Override
      public boolean hasCreate() {
        return modCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       *
       * @return The create.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.ColumnFamily getCreate() {
        if (createBuilder_ == null) {
          if (modCase_ == 2) {
            return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        } else {
          if (modCase_ == 2) {
            return createBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      public Builder setCreate(com.google.bigtable.admin.v2.ColumnFamily value) {
        if (createBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mod_ = value;
          onChanged();
        } else {
          createBuilder_.setMessage(value);
        }
        modCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      public Builder setCreate(com.google.bigtable.admin.v2.ColumnFamily.Builder builderForValue) {
        if (createBuilder_ == null) {
          mod_ = builderForValue.build();
          onChanged();
        } else {
          createBuilder_.setMessage(builderForValue.build());
        }
        modCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      public Builder mergeCreate(com.google.bigtable.admin.v2.ColumnFamily value) {
        if (createBuilder_ == null) {
          if (modCase_ == 2
              && mod_ != com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance()) {
            mod_ =
                com.google.bigtable.admin.v2.ColumnFamily.newBuilder(
                        (com.google.bigtable.admin.v2.ColumnFamily) mod_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mod_ = value;
          }
          onChanged();
        } else {
          if (modCase_ == 2) {
            createBuilder_.mergeFrom(value);
          } else {
            createBuilder_.setMessage(value);
          }
        }
        modCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      public Builder clearCreate() {
        if (createBuilder_ == null) {
          if (modCase_ == 2) {
            modCase_ = 0;
            mod_ = null;
            onChanged();
          }
        } else {
          if (modCase_ == 2) {
            modCase_ = 0;
            mod_ = null;
          }
          createBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      public com.google.bigtable.admin.v2.ColumnFamily.Builder getCreateBuilder() {
        return getCreateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getCreateOrBuilder() {
        if ((modCase_ == 2) && (createBuilder_ != null)) {
          return createBuilder_.getMessageOrBuilder();
        } else {
          if (modCase_ == 2) {
            return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Create a new column family with the specified schema, or fail if
       * one already exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily create = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.ColumnFamily,
              com.google.bigtable.admin.v2.ColumnFamily.Builder,
              com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>
          getCreateFieldBuilder() {
        if (createBuilder_ == null) {
          if (!(modCase_ == 2)) {
            mod_ = com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
          }
          createBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.ColumnFamily,
                  com.google.bigtable.admin.v2.ColumnFamily.Builder,
                  com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>(
                  (com.google.bigtable.admin.v2.ColumnFamily) mod_,
                  getParentForChildren(),
                  isClean());
          mod_ = null;
        }
        modCase_ = 2;
        onChanged();
        return createBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.ColumnFamily,
              com.google.bigtable.admin.v2.ColumnFamily.Builder,
              com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>
          updateBuilder_;
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       *
       * @return Whether the update field is set.
       */
      @java.lang.Override
      public boolean hasUpdate() {
        return modCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       *
       * @return The update.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.ColumnFamily getUpdate() {
        if (updateBuilder_ == null) {
          if (modCase_ == 3) {
            return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        } else {
          if (modCase_ == 3) {
            return updateBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      public Builder setUpdate(com.google.bigtable.admin.v2.ColumnFamily value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mod_ = value;
          onChanged();
        } else {
          updateBuilder_.setMessage(value);
        }
        modCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      public Builder setUpdate(com.google.bigtable.admin.v2.ColumnFamily.Builder builderForValue) {
        if (updateBuilder_ == null) {
          mod_ = builderForValue.build();
          onChanged();
        } else {
          updateBuilder_.setMessage(builderForValue.build());
        }
        modCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      public Builder mergeUpdate(com.google.bigtable.admin.v2.ColumnFamily value) {
        if (updateBuilder_ == null) {
          if (modCase_ == 3
              && mod_ != com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance()) {
            mod_ =
                com.google.bigtable.admin.v2.ColumnFamily.newBuilder(
                        (com.google.bigtable.admin.v2.ColumnFamily) mod_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mod_ = value;
          }
          onChanged();
        } else {
          if (modCase_ == 3) {
            updateBuilder_.mergeFrom(value);
          } else {
            updateBuilder_.setMessage(value);
          }
        }
        modCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      public Builder clearUpdate() {
        if (updateBuilder_ == null) {
          if (modCase_ == 3) {
            modCase_ = 0;
            mod_ = null;
            onChanged();
          }
        } else {
          if (modCase_ == 3) {
            modCase_ = 0;
            mod_ = null;
          }
          updateBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      public com.google.bigtable.admin.v2.ColumnFamily.Builder getUpdateBuilder() {
        return getUpdateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.ColumnFamilyOrBuilder getUpdateOrBuilder() {
        if ((modCase_ == 3) && (updateBuilder_ != null)) {
          return updateBuilder_.getMessageOrBuilder();
        } else {
          if (modCase_ == 3) {
            return (com.google.bigtable.admin.v2.ColumnFamily) mod_;
          }
          return com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Update an existing column family to the specified schema, or fail
       * if no column family exists with the given ID.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.ColumnFamily update = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.ColumnFamily,
              com.google.bigtable.admin.v2.ColumnFamily.Builder,
              com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>
          getUpdateFieldBuilder() {
        if (updateBuilder_ == null) {
          if (!(modCase_ == 3)) {
            mod_ = com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance();
          }
          updateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.ColumnFamily,
                  com.google.bigtable.admin.v2.ColumnFamily.Builder,
                  com.google.bigtable.admin.v2.ColumnFamilyOrBuilder>(
                  (com.google.bigtable.admin.v2.ColumnFamily) mod_,
                  getParentForChildren(),
                  isClean());
          mod_ = null;
        }
        modCase_ = 3;
        onChanged();
        return updateBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Drop (delete) the column family with the given ID, or fail if no such
       * family exists.
       * </pre>
       *
       * <code>bool drop = 4;</code>
       *
       * @return Whether the drop field is set.
       */
      public boolean hasDrop() {
        return modCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Drop (delete) the column family with the given ID, or fail if no such
       * family exists.
       * </pre>
       *
       * <code>bool drop = 4;</code>
       *
       * @return The drop.
       */
      public boolean getDrop() {
        if (modCase_ == 4) {
          return (java.lang.Boolean) mod_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Drop (delete) the column family with the given ID, or fail if no such
       * family exists.
       * </pre>
       *
       * <code>bool drop = 4;</code>
       *
       * @param value The drop to set.
       * @return This builder for chaining.
       */
      public Builder setDrop(boolean value) {

        modCase_ = 4;
        mod_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Drop (delete) the column family with the given ID, or fail if no such
       * family exists.
       * </pre>
       *
       * <code>bool drop = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDrop() {
        if (modCase_ == 4) {
          modCase_ = 0;
          mod_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification)
    private static final com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification();
    }

    public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Modification> PARSER =
        new com.google.protobuf.AbstractParser<Modification>() {
          @java.lang.Override
          public Modification parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Modification> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Modification> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table whose families should be modified.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table whose families should be modified.
   * Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODIFICATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>
      modifications_;
  /**
   *
   *
   * <pre>
   * Required. Modifications to be atomically applied to the specified table's families.
   * Entries are applied in order, meaning that earlier modifications can be
   * masked by later ones (in the case of repeated updates to the same family,
   * for example).
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>
      getModificationsList() {
    return modifications_;
  }
  /**
   *
   *
   * <pre>
   * Required. Modifications to be atomically applied to the specified table's families.
   * Entries are applied in order, meaning that earlier modifications can be
   * masked by later ones (in the case of repeated updates to the same family,
   * for example).
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder>
      getModificationsOrBuilderList() {
    return modifications_;
  }
  /**
   *
   *
   * <pre>
   * Required. Modifications to be atomically applied to the specified table's families.
   * Entries are applied in order, meaning that earlier modifications can be
   * masked by later ones (in the case of repeated updates to the same family,
   * for example).
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getModificationsCount() {
    return modifications_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Modifications to be atomically applied to the specified table's families.
   * Entries are applied in order, meaning that earlier modifications can be
   * masked by later ones (in the case of repeated updates to the same family,
   * for example).
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification getModifications(
      int index) {
    return modifications_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Modifications to be atomically applied to the specified table's families.
   * Entries are applied in order, meaning that earlier modifications can be
   * masked by later ones (in the case of repeated updates to the same family,
   * for example).
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder
      getModificationsOrBuilder(int index) {
    return modifications_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < modifications_.size(); i++) {
      output.writeMessage(2, modifications_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < modifications_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, modifications_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest other =
        (com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getModificationsList().equals(other.getModificationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getModificationsCount() > 0) {
      hash = (37 * hash) + MODIFICATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getModificationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies][google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies]
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.ModifyColumnFamiliesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.ModifyColumnFamiliesRequest)
      com.google.bigtable.admin.v2.ModifyColumnFamiliesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.class,
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (modificationsBuilder_ == null) {
        modifications_ = java.util.Collections.emptyList();
      } else {
        modifications_ = null;
        modificationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_ModifyColumnFamiliesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest build() {
      com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest buildPartial() {
      com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest result =
          new com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest result) {
      if (modificationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          modifications_ = java.util.Collections.unmodifiableList(modifications_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.modifications_ = modifications_;
      } else {
        result.modifications_ = modificationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest) {
        return mergeFrom((com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest other) {
      if (other == com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (modificationsBuilder_ == null) {
        if (!other.modifications_.isEmpty()) {
          if (modifications_.isEmpty()) {
            modifications_ = other.modifications_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureModificationsIsMutable();
            modifications_.addAll(other.modifications_);
          }
          onChanged();
        }
      } else {
        if (!other.modifications_.isEmpty()) {
          if (modificationsBuilder_.isEmpty()) {
            modificationsBuilder_.dispose();
            modificationsBuilder_ = null;
            modifications_ = other.modifications_;
            bitField0_ = (bitField0_ & ~0x00000002);
            modificationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getModificationsFieldBuilder()
                    : null;
          } else {
            modificationsBuilder_.addAllMessages(other.modifications_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification m =
                    input.readMessage(
                        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
                            .parser(),
                        extensionRegistry);
                if (modificationsBuilder_ == null) {
                  ensureModificationsIsMutable();
                  modifications_.add(m);
                } else {
                  modificationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table whose families should be modified.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table whose families should be modified.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table whose families should be modified.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table whose families should be modified.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table whose families should be modified.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>
        modifications_ = java.util.Collections.emptyList();

    private void ensureModificationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        modifications_ =
            new java.util.ArrayList<
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>(
                modifications_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification,
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder,
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder>
        modificationsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>
        getModificationsList() {
      if (modificationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(modifications_);
      } else {
        return modificationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getModificationsCount() {
      if (modificationsBuilder_ == null) {
        return modifications_.size();
      } else {
        return modificationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification getModifications(
        int index) {
      if (modificationsBuilder_ == null) {
        return modifications_.get(index);
      } else {
        return modificationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModifications(
        int index, com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification value) {
      if (modificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModificationsIsMutable();
        modifications_.set(index, value);
        onChanged();
      } else {
        modificationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setModifications(
        int index,
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
            builderForValue) {
      if (modificationsBuilder_ == null) {
        ensureModificationsIsMutable();
        modifications_.set(index, builderForValue.build());
        onChanged();
      } else {
        modificationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModifications(
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification value) {
      if (modificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModificationsIsMutable();
        modifications_.add(value);
        onChanged();
      } else {
        modificationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModifications(
        int index, com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification value) {
      if (modificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureModificationsIsMutable();
        modifications_.add(index, value);
        onChanged();
      } else {
        modificationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModifications(
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
            builderForValue) {
      if (modificationsBuilder_ == null) {
        ensureModificationsIsMutable();
        modifications_.add(builderForValue.build());
        onChanged();
      } else {
        modificationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addModifications(
        int index,
        com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
            builderForValue) {
      if (modificationsBuilder_ == null) {
        ensureModificationsIsMutable();
        modifications_.add(index, builderForValue.build());
        onChanged();
      } else {
        modificationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllModifications(
        java.lang.Iterable<
                ? extends com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification>
            values) {
      if (modificationsBuilder_ == null) {
        ensureModificationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, modifications_);
        onChanged();
      } else {
        modificationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearModifications() {
      if (modificationsBuilder_ == null) {
        modifications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        modificationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeModifications(int index) {
      if (modificationsBuilder_ == null) {
        ensureModificationsIsMutable();
        modifications_.remove(index);
        onChanged();
      } else {
        modificationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
        getModificationsBuilder(int index) {
      return getModificationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder
        getModificationsOrBuilder(int index) {
      if (modificationsBuilder_ == null) {
        return modifications_.get(index);
      } else {
        return modificationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder>
        getModificationsOrBuilderList() {
      if (modificationsBuilder_ != null) {
        return modificationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(modifications_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
        addModificationsBuilder() {
      return getModificationsFieldBuilder()
          .addBuilder(
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder
        addModificationsBuilder(int index) {
      return getModificationsFieldBuilder()
          .addBuilder(
              index,
              com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Modifications to be atomically applied to the specified table's families.
     * Entries are applied in order, meaning that earlier modifications can be
     * masked by later ones (in the case of repeated updates to the same family,
     * for example).
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification modifications = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder>
        getModificationsBuilderList() {
      return getModificationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification,
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder,
            com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder>
        getModificationsFieldBuilder() {
      if (modificationsBuilder_ == null) {
        modificationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification,
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification.Builder,
                com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.ModificationOrBuilder>(
                modifications_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        modifications_ = null;
      }
      return modificationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.ModifyColumnFamiliesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.ModifyColumnFamiliesRequest)
  private static final com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest();
  }

  public static com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModifyColumnFamiliesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ModifyColumnFamiliesRequest>() {
        @java.lang.Override
        public ModifyColumnFamiliesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModifyColumnFamiliesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModifyColumnFamiliesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
