/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/table.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A snapshot of a table at a particular time. A snapshot can be used as a
 * checkpoint for data restoration or a data source for a new table.
 *
 * Note: This is a private alpha release of Cloud Bigtable snapshots. This
 * feature is not currently available to most Cloud Bigtable customers. This
 * feature might be changed in backward-incompatible ways and is not recommended
 * for production use. It is not subject to any SLA or deprecation policy.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Snapshot}
 */
public final class Snapshot extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Snapshot)
    SnapshotOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Snapshot.newBuilder() to construct.
  private Snapshot(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Snapshot() {
    name_ = "";
    state_ = 0;
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Snapshot();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Snapshot_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Snapshot_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Snapshot.class,
            com.google.bigtable.admin.v2.Snapshot.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a snapshot.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Snapshot.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the snapshot could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    STATE_NOT_KNOWN(0),
    /**
     *
     *
     * <pre>
     * The snapshot has been successfully created and can serve all requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    READY(1),
    /**
     *
     *
     * <pre>
     * The snapshot is currently being created, and may be destroyed if the
     * creation process encounters an error. A snapshot may not be restored to a
     * table while it is being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    CREATING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the snapshot could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    public static final int STATE_NOT_KNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The snapshot has been successfully created and can serve all requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    public static final int READY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The snapshot is currently being created, and may be destroyed if the
     * creation process encounters an error. A snapshot may not be restored to a
     * table while it is being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    public static final int CREATING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_NOT_KNOWN;
        case 1:
          return READY;
        case 2:
          return CREATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Snapshot.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Snapshot.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique name of the snapshot.
   * Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique name of the snapshot.
   * Values are of the form
   * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TABLE_FIELD_NUMBER = 2;
  private com.google.bigtable.admin.v2.Table sourceTable_;
  /**
   *
   *
   * <pre>
   * Output only. The source table at the time the snapshot was taken.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
   *
   * @return Whether the sourceTable field is set.
   */
  @java.lang.Override
  public boolean hasSourceTable() {
    return sourceTable_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source table at the time the snapshot was taken.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
   *
   * @return The sourceTable.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Table getSourceTable() {
    return sourceTable_ == null
        ? com.google.bigtable.admin.v2.Table.getDefaultInstance()
        : sourceTable_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source table at the time the snapshot was taken.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.TableOrBuilder getSourceTableOrBuilder() {
    return sourceTable_ == null
        ? com.google.bigtable.admin.v2.Table.getDefaultInstance()
        : sourceTable_;
  }

  public static final int DATA_SIZE_BYTES_FIELD_NUMBER = 3;
  private long dataSizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The size of the data in the source table at the time the
   * snapshot was taken. In some cases, this value may be computed
   * asynchronously via a background process and a placeholder of 0 will be used
   * in the meantime.
   * </pre>
   *
   * <code>int64 data_size_bytes = 3;</code>
   *
   * @return The dataSizeBytes.
   */
  @java.lang.Override
  public long getDataSizeBytes() {
    return dataSizeBytes_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot will be deleted. The maximum amount
   * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
   * the default maximum of 365 days will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 5;</code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot will be deleted. The maximum amount
   * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
   * the default maximum of 365 days will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 5;</code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the snapshot will be deleted. The maximum amount
   * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
   * the default maximum of 365 days will be used.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the snapshot.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the snapshot.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Snapshot.State getState() {
    com.google.bigtable.admin.v2.Snapshot.State result =
        com.google.bigtable.admin.v2.Snapshot.State.forNumber(state_);
    return result == null ? com.google.bigtable.admin.v2.Snapshot.State.UNRECOGNIZED : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Description of the snapshot.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Description of the snapshot.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (sourceTable_ != null) {
      output.writeMessage(2, getSourceTable());
    }
    if (dataSizeBytes_ != 0L) {
      output.writeInt64(3, dataSizeBytes_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(5, getDeleteTime());
    }
    if (state_ != com.google.bigtable.admin.v2.Snapshot.State.STATE_NOT_KNOWN.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (sourceTable_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSourceTable());
    }
    if (dataSizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, dataSizeBytes_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDeleteTime());
    }
    if (state_ != com.google.bigtable.admin.v2.Snapshot.State.STATE_NOT_KNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Snapshot)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Snapshot other = (com.google.bigtable.admin.v2.Snapshot) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSourceTable() != other.hasSourceTable()) return false;
    if (hasSourceTable()) {
      if (!getSourceTable().equals(other.getSourceTable())) return false;
    }
    if (getDataSizeBytes() != other.getDataSizeBytes()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSourceTable()) {
      hash = (37 * hash) + SOURCE_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceTable().hashCode();
    }
    hash = (37 * hash) + DATA_SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDataSizeBytes());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Snapshot parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Snapshot prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A snapshot of a table at a particular time. A snapshot can be used as a
   * checkpoint for data restoration or a data source for a new table.
   *
   * Note: This is a private alpha release of Cloud Bigtable snapshots. This
   * feature is not currently available to most Cloud Bigtable customers. This
   * feature might be changed in backward-incompatible ways and is not recommended
   * for production use. It is not subject to any SLA or deprecation policy.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Snapshot}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Snapshot)
      com.google.bigtable.admin.v2.SnapshotOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Snapshot_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Snapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Snapshot.class,
              com.google.bigtable.admin.v2.Snapshot.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Snapshot.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      sourceTable_ = null;
      if (sourceTableBuilder_ != null) {
        sourceTableBuilder_.dispose();
        sourceTableBuilder_ = null;
      }
      dataSizeBytes_ = 0L;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      state_ = 0;
      description_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Snapshot_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Snapshot getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Snapshot.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Snapshot build() {
      com.google.bigtable.admin.v2.Snapshot result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Snapshot buildPartial() {
      com.google.bigtable.admin.v2.Snapshot result =
          new com.google.bigtable.admin.v2.Snapshot(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.Snapshot result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceTable_ =
            sourceTableBuilder_ == null ? sourceTable_ : sourceTableBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataSizeBytes_ = dataSizeBytes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Snapshot) {
        return mergeFrom((com.google.bigtable.admin.v2.Snapshot) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Snapshot other) {
      if (other == com.google.bigtable.admin.v2.Snapshot.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSourceTable()) {
        mergeSourceTable(other.getSourceTable());
      }
      if (other.getDataSizeBytes() != 0L) {
        setDataSizeBytes(other.getDataSizeBytes());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSourceTableFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                dataSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique name of the snapshot.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of the snapshot.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of the snapshot.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of the snapshot.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique name of the snapshot.
     * Values are of the form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.Table sourceTable_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Table,
            com.google.bigtable.admin.v2.Table.Builder,
            com.google.bigtable.admin.v2.TableOrBuilder>
        sourceTableBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     *
     * @return Whether the sourceTable field is set.
     */
    public boolean hasSourceTable() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     *
     * @return The sourceTable.
     */
    public com.google.bigtable.admin.v2.Table getSourceTable() {
      if (sourceTableBuilder_ == null) {
        return sourceTable_ == null
            ? com.google.bigtable.admin.v2.Table.getDefaultInstance()
            : sourceTable_;
      } else {
        return sourceTableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public Builder setSourceTable(com.google.bigtable.admin.v2.Table value) {
      if (sourceTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceTable_ = value;
      } else {
        sourceTableBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public Builder setSourceTable(com.google.bigtable.admin.v2.Table.Builder builderForValue) {
      if (sourceTableBuilder_ == null) {
        sourceTable_ = builderForValue.build();
      } else {
        sourceTableBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public Builder mergeSourceTable(com.google.bigtable.admin.v2.Table value) {
      if (sourceTableBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && sourceTable_ != null
            && sourceTable_ != com.google.bigtable.admin.v2.Table.getDefaultInstance()) {
          getSourceTableBuilder().mergeFrom(value);
        } else {
          sourceTable_ = value;
        }
      } else {
        sourceTableBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public Builder clearSourceTable() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sourceTable_ = null;
      if (sourceTableBuilder_ != null) {
        sourceTableBuilder_.dispose();
        sourceTableBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public com.google.bigtable.admin.v2.Table.Builder getSourceTableBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSourceTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    public com.google.bigtable.admin.v2.TableOrBuilder getSourceTableOrBuilder() {
      if (sourceTableBuilder_ != null) {
        return sourceTableBuilder_.getMessageOrBuilder();
      } else {
        return sourceTable_ == null
            ? com.google.bigtable.admin.v2.Table.getDefaultInstance()
            : sourceTable_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The source table at the time the snapshot was taken.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Table source_table = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Table,
            com.google.bigtable.admin.v2.Table.Builder,
            com.google.bigtable.admin.v2.TableOrBuilder>
        getSourceTableFieldBuilder() {
      if (sourceTableBuilder_ == null) {
        sourceTableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Table,
                com.google.bigtable.admin.v2.Table.Builder,
                com.google.bigtable.admin.v2.TableOrBuilder>(
                getSourceTable(), getParentForChildren(), isClean());
        sourceTable_ = null;
      }
      return sourceTableBuilder_;
    }

    private long dataSizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The size of the data in the source table at the time the
     * snapshot was taken. In some cases, this value may be computed
     * asynchronously via a background process and a placeholder of 0 will be used
     * in the meantime.
     * </pre>
     *
     * <code>int64 data_size_bytes = 3;</code>
     *
     * @return The dataSizeBytes.
     */
    @java.lang.Override
    public long getDataSizeBytes() {
      return dataSizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the data in the source table at the time the
     * snapshot was taken. In some cases, this value may be computed
     * asynchronously via a background process and a placeholder of 0 will be used
     * in the meantime.
     * </pre>
     *
     * <code>int64 data_size_bytes = 3;</code>
     *
     * @param value The dataSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setDataSizeBytes(long value) {

      dataSizeBytes_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the data in the source table at the time the
     * snapshot was taken. In some cases, this value may be computed
     * asynchronously via a background process and a placeholder of 0 will be used
     * in the meantime.
     * </pre>
     *
     * <code>int64 data_size_bytes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the snapshot will be deleted. The maximum amount
     * of time a snapshot can stay active is 365 days. If 'ttl' is not specified,
     * the default maximum of 365 days will be used.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the snapshot.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the snapshot.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the snapshot.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Snapshot.State getState() {
      com.google.bigtable.admin.v2.Snapshot.State result =
          com.google.bigtable.admin.v2.Snapshot.State.forNumber(state_);
      return result == null ? com.google.bigtable.admin.v2.Snapshot.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the snapshot.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.bigtable.admin.v2.Snapshot.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the snapshot.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Snapshot.State state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Description of the snapshot.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the snapshot.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the snapshot.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the snapshot.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Description of the snapshot.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Snapshot)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Snapshot)
  private static final com.google.bigtable.admin.v2.Snapshot DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Snapshot();
  }

  public static com.google.bigtable.admin.v2.Snapshot getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Snapshot> PARSER =
      new com.google.protobuf.AbstractParser<Snapshot>() {
        @java.lang.Override
        public Snapshot parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Snapshot> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Snapshot> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Snapshot getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
