/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/table.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Encryption information for a given resource.
 * If this resource is protected with customer managed encryption, the in-use
 * Cloud Key Management Service (Cloud KMS) key version is specified along with
 * its status.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.EncryptionInfo}
 */
public final class EncryptionInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.EncryptionInfo)
    EncryptionInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EncryptionInfo.newBuilder() to construct.
  private EncryptionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EncryptionInfo() {
    encryptionType_ = 0;
    kmsKeyVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EncryptionInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_EncryptionInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_EncryptionInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.EncryptionInfo.class,
            com.google.bigtable.admin.v2.EncryptionInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible encryption types for a resource.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.EncryptionInfo.EncryptionType}
   */
  public enum EncryptionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Encryption type was not specified, though data at rest remains encrypted.
     * </pre>
     *
     * <code>ENCRYPTION_TYPE_UNSPECIFIED = 0;</code>
     */
    ENCRYPTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The data backing this resource is encrypted at rest with a key that is
     * fully managed by Google. No key version or status will be populated.
     * This is the default state.
     * </pre>
     *
     * <code>GOOGLE_DEFAULT_ENCRYPTION = 1;</code>
     */
    GOOGLE_DEFAULT_ENCRYPTION(1),
    /**
     *
     *
     * <pre>
     * The data backing this resource is encrypted at rest with a key that is
     * managed by the customer.
     * The in-use version of the key and its status are populated for
     * CMEK-protected tables.
     * CMEK-protected backups are pinned to the key version that was in use at
     * the time the backup was taken. This key version is populated but its
     * status is not tracked and is reported as `UNKNOWN`.
     * </pre>
     *
     * <code>CUSTOMER_MANAGED_ENCRYPTION = 2;</code>
     */
    CUSTOMER_MANAGED_ENCRYPTION(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Encryption type was not specified, though data at rest remains encrypted.
     * </pre>
     *
     * <code>ENCRYPTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ENCRYPTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The data backing this resource is encrypted at rest with a key that is
     * fully managed by Google. No key version or status will be populated.
     * This is the default state.
     * </pre>
     *
     * <code>GOOGLE_DEFAULT_ENCRYPTION = 1;</code>
     */
    public static final int GOOGLE_DEFAULT_ENCRYPTION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The data backing this resource is encrypted at rest with a key that is
     * managed by the customer.
     * The in-use version of the key and its status are populated for
     * CMEK-protected tables.
     * CMEK-protected backups are pinned to the key version that was in use at
     * the time the backup was taken. This key version is populated but its
     * status is not tracked and is reported as `UNKNOWN`.
     * </pre>
     *
     * <code>CUSTOMER_MANAGED_ENCRYPTION = 2;</code>
     */
    public static final int CUSTOMER_MANAGED_ENCRYPTION_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EncryptionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EncryptionType forNumber(int value) {
      switch (value) {
        case 0:
          return ENCRYPTION_TYPE_UNSPECIFIED;
        case 1:
          return GOOGLE_DEFAULT_ENCRYPTION;
        case 2:
          return CUSTOMER_MANAGED_ENCRYPTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EncryptionType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EncryptionType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EncryptionType>() {
          public EncryptionType findValueByNumber(int number) {
            return EncryptionType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.EncryptionInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final EncryptionType[] VALUES = values();

    public static EncryptionType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EncryptionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.EncryptionInfo.EncryptionType)
  }

  public static final int ENCRYPTION_TYPE_FIELD_NUMBER = 3;
  private int encryptionType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The type of encryption used to protect this resource.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for encryptionType.
   */
  @java.lang.Override
  public int getEncryptionTypeValue() {
    return encryptionType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The type of encryption used to protect this resource.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType getEncryptionType() {
    com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType result =
        com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.forNumber(encryptionType_);
    return result == null
        ? com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.UNRECOGNIZED
        : result;
  }

  public static final int ENCRYPTION_STATUS_FIELD_NUMBER = 4;
  private com.google.rpc.Status encryptionStatus_;
  /**
   *
   *
   * <pre>
   * Output only. The status of encrypt/decrypt calls on underlying data for
   * this resource. Regardless of status, the existing data is always encrypted
   * at rest.
   * </pre>
   *
   * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionStatus field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionStatus() {
    return encryptionStatus_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of encrypt/decrypt calls on underlying data for
   * this resource. Regardless of status, the existing data is always encrypted
   * at rest.
   * </pre>
   *
   * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getEncryptionStatus() {
    return encryptionStatus_ == null
        ? com.google.rpc.Status.getDefaultInstance()
        : encryptionStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of encrypt/decrypt calls on underlying data for
   * this resource. Regardless of status, the existing data is always encrypted
   * at rest.
   * </pre>
   *
   * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getEncryptionStatusOrBuilder() {
    return encryptionStatus_ == null
        ? com.google.rpc.Status.getDefaultInstance()
        : encryptionStatus_;
  }

  public static final int KMS_KEY_VERSION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The version of the Cloud KMS key specified in the parent
   * cluster that is in use for the data underlying this table.
   * </pre>
   *
   * <code>
   * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyVersion.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersion() {
    java.lang.Object ref = kmsKeyVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The version of the Cloud KMS key specified in the parent
   * cluster that is in use for the data underlying this table.
   * </pre>
   *
   * <code>
   * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionBytes() {
    java.lang.Object ref = kmsKeyVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKeyVersion_);
    }
    if (encryptionType_
        != com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.ENCRYPTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, encryptionType_);
    }
    if (encryptionStatus_ != null) {
      output.writeMessage(4, getEncryptionStatus());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKeyVersion_);
    }
    if (encryptionType_
        != com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.ENCRYPTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, encryptionType_);
    }
    if (encryptionStatus_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionStatus());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.EncryptionInfo)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.EncryptionInfo other =
        (com.google.bigtable.admin.v2.EncryptionInfo) obj;

    if (encryptionType_ != other.encryptionType_) return false;
    if (hasEncryptionStatus() != other.hasEncryptionStatus()) return false;
    if (hasEncryptionStatus()) {
      if (!getEncryptionStatus().equals(other.getEncryptionStatus())) return false;
    }
    if (!getKmsKeyVersion().equals(other.getKmsKeyVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENCRYPTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + encryptionType_;
    if (hasEncryptionStatus()) {
      hash = (37 * hash) + ENCRYPTION_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionStatus().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.EncryptionInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encryption information for a given resource.
   * If this resource is protected with customer managed encryption, the in-use
   * Cloud Key Management Service (Cloud KMS) key version is specified along with
   * its status.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.EncryptionInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.EncryptionInfo)
      com.google.bigtable.admin.v2.EncryptionInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_EncryptionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_EncryptionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.EncryptionInfo.class,
              com.google.bigtable.admin.v2.EncryptionInfo.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.EncryptionInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      encryptionType_ = 0;
      encryptionStatus_ = null;
      if (encryptionStatusBuilder_ != null) {
        encryptionStatusBuilder_.dispose();
        encryptionStatusBuilder_ = null;
      }
      kmsKeyVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_EncryptionInfo_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfo getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfo build() {
      com.google.bigtable.admin.v2.EncryptionInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfo buildPartial() {
      com.google.bigtable.admin.v2.EncryptionInfo result =
          new com.google.bigtable.admin.v2.EncryptionInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.EncryptionInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.encryptionType_ = encryptionType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.encryptionStatus_ =
            encryptionStatusBuilder_ == null ? encryptionStatus_ : encryptionStatusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kmsKeyVersion_ = kmsKeyVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.EncryptionInfo) {
        return mergeFrom((com.google.bigtable.admin.v2.EncryptionInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.EncryptionInfo other) {
      if (other == com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance()) return this;
      if (other.encryptionType_ != 0) {
        setEncryptionTypeValue(other.getEncryptionTypeValue());
      }
      if (other.hasEncryptionStatus()) {
        mergeEncryptionStatus(other.getEncryptionStatus());
      }
      if (!other.getKmsKeyVersion().isEmpty()) {
        kmsKeyVersion_ = other.kmsKeyVersion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                kmsKeyVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 24:
              {
                encryptionType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getEncryptionStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int encryptionType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The type of encryption used to protect this resource.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for encryptionType.
     */
    @java.lang.Override
    public int getEncryptionTypeValue() {
      return encryptionType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of encryption used to protect this resource.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for encryptionType to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionTypeValue(int value) {
      encryptionType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of encryption used to protect this resource.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType getEncryptionType() {
      com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType result =
          com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.forNumber(encryptionType_);
      return result == null
          ? com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of encryption used to protect this resource.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The encryptionType to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionType(
        com.google.bigtable.admin.v2.EncryptionInfo.EncryptionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      encryptionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of encryption used to protect this resource.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.EncryptionInfo.EncryptionType encryption_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      encryptionType_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status encryptionStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        encryptionStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the encryptionStatus field is set.
     */
    public boolean hasEncryptionStatus() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionStatus.
     */
    public com.google.rpc.Status getEncryptionStatus() {
      if (encryptionStatusBuilder_ == null) {
        return encryptionStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : encryptionStatus_;
      } else {
        return encryptionStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionStatus(com.google.rpc.Status value) {
      if (encryptionStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionStatus_ = value;
      } else {
        encryptionStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionStatus(com.google.rpc.Status.Builder builderForValue) {
      if (encryptionStatusBuilder_ == null) {
        encryptionStatus_ = builderForValue.build();
      } else {
        encryptionStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEncryptionStatus(com.google.rpc.Status value) {
      if (encryptionStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && encryptionStatus_ != null
            && encryptionStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getEncryptionStatusBuilder().mergeFrom(value);
        } else {
          encryptionStatus_ = value;
        }
      } else {
        encryptionStatusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionStatus() {
      bitField0_ = (bitField0_ & ~0x00000002);
      encryptionStatus_ = null;
      if (encryptionStatusBuilder_ != null) {
        encryptionStatusBuilder_.dispose();
        encryptionStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getEncryptionStatusBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEncryptionStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getEncryptionStatusOrBuilder() {
      if (encryptionStatusBuilder_ != null) {
        return encryptionStatusBuilder_.getMessageOrBuilder();
      } else {
        return encryptionStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : encryptionStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of encrypt/decrypt calls on underlying data for
     * this resource. Regardless of status, the existing data is always encrypted
     * at rest.
     * </pre>
     *
     * <code>.google.rpc.Status encryption_status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getEncryptionStatusFieldBuilder() {
      if (encryptionStatusBuilder_ == null) {
        encryptionStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getEncryptionStatus(), getParentForChildren(), isClean());
        encryptionStatus_ = null;
      }
      return encryptionStatusBuilder_;
    }

    private java.lang.Object kmsKeyVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The version of the Cloud KMS key specified in the parent
     * cluster that is in use for the data underlying this table.
     * </pre>
     *
     * <code>
     * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyVersion.
     */
    public java.lang.String getKmsKeyVersion() {
      java.lang.Object ref = kmsKeyVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of the Cloud KMS key specified in the parent
     * cluster that is in use for the data underlying this table.
     * </pre>
     *
     * <code>
     * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyVersion.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionBytes() {
      java.lang.Object ref = kmsKeyVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of the Cloud KMS key specified in the parent
     * cluster that is in use for the data underlying this table.
     * </pre>
     *
     * <code>
     * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of the Cloud KMS key specified in the parent
     * cluster that is in use for the data underlying this table.
     * </pre>
     *
     * <code>
     * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersion() {
      kmsKeyVersion_ = getDefaultInstance().getKmsKeyVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The version of the Cloud KMS key specified in the parent
     * cluster that is in use for the data underlying this table.
     * </pre>
     *
     * <code>
     * string kms_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.EncryptionInfo)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.EncryptionInfo)
  private static final com.google.bigtable.admin.v2.EncryptionInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.EncryptionInfo();
  }

  public static com.google.bigtable.admin.v2.EncryptionInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EncryptionInfo> PARSER =
      new com.google.protobuf.AbstractParser<EncryptionInfo>() {
        @java.lang.Override
        public EncryptionInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EncryptionInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EncryptionInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.EncryptionInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
