/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

// Protobuf Java Version: 3.25.2
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.CheckConsistencyRequest}
 */
public final class CheckConsistencyRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.CheckConsistencyRequest)
    CheckConsistencyRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckConsistencyRequest.newBuilder() to construct.
  private CheckConsistencyRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckConsistencyRequest() {
    name_ = "";
    consistencyToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckConsistencyRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_CheckConsistencyRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableTableAdminProto
        .internal_static_google_bigtable_admin_v2_CheckConsistencyRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.CheckConsistencyRequest.class,
            com.google.bigtable.admin.v2.CheckConsistencyRequest.Builder.class);
  }

  private int modeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STANDARD_READ_REMOTE_WRITES(3),
    DATA_BOOST_READ_LOCAL_WRITES(4),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 3:
          return STANDARD_READ_REMOTE_WRITES;
        case 4:
          return DATA_BOOST_READ_LOCAL_WRITES;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique name of the Table for which to check replication
   * consistency. Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the Table for which to check replication
   * consistency. Values are of the form
   * `projects/{project}/instances/{instance}/tables/{table}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSISTENCY_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object consistencyToken_ = "";
  /**
   *
   *
   * <pre>
   * Required. The token created using GenerateConsistencyToken for the Table.
   * </pre>
   *
   * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The consistencyToken.
   */
  @java.lang.Override
  public java.lang.String getConsistencyToken() {
    java.lang.Object ref = consistencyToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      consistencyToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The token created using GenerateConsistencyToken for the Table.
   * </pre>
   *
   * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for consistencyToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConsistencyTokenBytes() {
    java.lang.Object ref = consistencyToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      consistencyToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STANDARD_READ_REMOTE_WRITES_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `StandardIsolation` can
   * see all writes committed before the token was created, even if the
   * read and write target different clusters.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
   * </code>
   *
   * @return Whether the standardReadRemoteWrites field is set.
   */
  @java.lang.Override
  public boolean hasStandardReadRemoteWrites() {
    return modeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `StandardIsolation` can
   * see all writes committed before the token was created, even if the
   * read and write target different clusters.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
   * </code>
   *
   * @return The standardReadRemoteWrites.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.StandardReadRemoteWrites getStandardReadRemoteWrites() {
    if (modeCase_ == 3) {
      return (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_;
    }
    return com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `StandardIsolation` can
   * see all writes committed before the token was created, even if the
   * read and write target different clusters.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.StandardReadRemoteWritesOrBuilder
      getStandardReadRemoteWritesOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_;
    }
    return com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
  }

  public static final int DATA_BOOST_READ_LOCAL_WRITES_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
   * can see all writes committed before the token was created, but only if
   * the read and write target the same cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
   * </code>
   *
   * @return Whether the dataBoostReadLocalWrites field is set.
   */
  @java.lang.Override
  public boolean hasDataBoostReadLocalWrites() {
    return modeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
   * can see all writes committed before the token was created, but only if
   * the read and write target the same cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
   * </code>
   *
   * @return The dataBoostReadLocalWrites.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.DataBoostReadLocalWrites getDataBoostReadLocalWrites() {
    if (modeCase_ == 4) {
      return (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_;
    }
    return com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
   * can see all writes committed before the token was created, but only if
   * the read and write target the same cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.DataBoostReadLocalWritesOrBuilder
      getDataBoostReadLocalWritesOrBuilder() {
    if (modeCase_ == 4) {
      return (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_;
    }
    return com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consistencyToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, consistencyToken_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(3, (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_);
    }
    if (modeCase_ == 4) {
      output.writeMessage(4, (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consistencyToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, consistencyToken_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_);
    }
    if (modeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.CheckConsistencyRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.CheckConsistencyRequest other =
        (com.google.bigtable.admin.v2.CheckConsistencyRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getConsistencyToken().equals(other.getConsistencyToken())) return false;
    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 3:
        if (!getStandardReadRemoteWrites().equals(other.getStandardReadRemoteWrites()))
          return false;
        break;
      case 4:
        if (!getDataBoostReadLocalWrites().equals(other.getDataBoostReadLocalWrites()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CONSISTENCY_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getConsistencyToken().hashCode();
    switch (modeCase_) {
      case 3:
        hash = (37 * hash) + STANDARD_READ_REMOTE_WRITES_FIELD_NUMBER;
        hash = (53 * hash) + getStandardReadRemoteWrites().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DATA_BOOST_READ_LOCAL_WRITES_FIELD_NUMBER;
        hash = (53 * hash) + getDataBoostReadLocalWrites().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.CheckConsistencyRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.CheckConsistencyRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.CheckConsistencyRequest)
      com.google.bigtable.admin.v2.CheckConsistencyRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_CheckConsistencyRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_CheckConsistencyRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.CheckConsistencyRequest.class,
              com.google.bigtable.admin.v2.CheckConsistencyRequest.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.CheckConsistencyRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      consistencyToken_ = "";
      if (standardReadRemoteWritesBuilder_ != null) {
        standardReadRemoteWritesBuilder_.clear();
      }
      if (dataBoostReadLocalWritesBuilder_ != null) {
        dataBoostReadLocalWritesBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableTableAdminProto
          .internal_static_google_bigtable_admin_v2_CheckConsistencyRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CheckConsistencyRequest getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.CheckConsistencyRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CheckConsistencyRequest build() {
      com.google.bigtable.admin.v2.CheckConsistencyRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CheckConsistencyRequest buildPartial() {
      com.google.bigtable.admin.v2.CheckConsistencyRequest result =
          new com.google.bigtable.admin.v2.CheckConsistencyRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.CheckConsistencyRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.consistencyToken_ = consistencyToken_;
      }
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.CheckConsistencyRequest result) {
      result.modeCase_ = modeCase_;
      result.mode_ = this.mode_;
      if (modeCase_ == 3 && standardReadRemoteWritesBuilder_ != null) {
        result.mode_ = standardReadRemoteWritesBuilder_.build();
      }
      if (modeCase_ == 4 && dataBoostReadLocalWritesBuilder_ != null) {
        result.mode_ = dataBoostReadLocalWritesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.CheckConsistencyRequest) {
        return mergeFrom((com.google.bigtable.admin.v2.CheckConsistencyRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.CheckConsistencyRequest other) {
      if (other == com.google.bigtable.admin.v2.CheckConsistencyRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getConsistencyToken().isEmpty()) {
        consistencyToken_ = other.consistencyToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getModeCase()) {
        case STANDARD_READ_REMOTE_WRITES:
          {
            mergeStandardReadRemoteWrites(other.getStandardReadRemoteWrites());
            break;
          }
        case DATA_BOOST_READ_LOCAL_WRITES:
          {
            mergeDataBoostReadLocalWrites(other.getDataBoostReadLocalWrites());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                consistencyToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getStandardReadRemoteWritesFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getDataBoostReadLocalWritesFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the Table for which to check replication
     * consistency. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the Table for which to check replication
     * consistency. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the Table for which to check replication
     * consistency. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the Table for which to check replication
     * consistency. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the Table for which to check replication
     * consistency. Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object consistencyToken_ = "";
    /**
     *
     *
     * <pre>
     * Required. The token created using GenerateConsistencyToken for the Table.
     * </pre>
     *
     * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consistencyToken.
     */
    public java.lang.String getConsistencyToken() {
      java.lang.Object ref = consistencyToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consistencyToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The token created using GenerateConsistencyToken for the Table.
     * </pre>
     *
     * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consistencyToken.
     */
    public com.google.protobuf.ByteString getConsistencyTokenBytes() {
      java.lang.Object ref = consistencyToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        consistencyToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The token created using GenerateConsistencyToken for the Table.
     * </pre>
     *
     * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The consistencyToken to set.
     * @return This builder for chaining.
     */
    public Builder setConsistencyToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencyToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The token created using GenerateConsistencyToken for the Table.
     * </pre>
     *
     * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsistencyToken() {
      consistencyToken_ = getDefaultInstance().getConsistencyToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The token created using GenerateConsistencyToken for the Table.
     * </pre>
     *
     * <code>string consistency_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for consistencyToken to set.
     * @return This builder for chaining.
     */
    public Builder setConsistencyTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      consistencyToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.StandardReadRemoteWrites,
            com.google.bigtable.admin.v2.StandardReadRemoteWrites.Builder,
            com.google.bigtable.admin.v2.StandardReadRemoteWritesOrBuilder>
        standardReadRemoteWritesBuilder_;
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     *
     * @return Whether the standardReadRemoteWrites field is set.
     */
    @java.lang.Override
    public boolean hasStandardReadRemoteWrites() {
      return modeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     *
     * @return The standardReadRemoteWrites.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.StandardReadRemoteWrites getStandardReadRemoteWrites() {
      if (standardReadRemoteWritesBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_;
        }
        return com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return standardReadRemoteWritesBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    public Builder setStandardReadRemoteWrites(
        com.google.bigtable.admin.v2.StandardReadRemoteWrites value) {
      if (standardReadRemoteWritesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        standardReadRemoteWritesBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    public Builder setStandardReadRemoteWrites(
        com.google.bigtable.admin.v2.StandardReadRemoteWrites.Builder builderForValue) {
      if (standardReadRemoteWritesBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        standardReadRemoteWritesBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    public Builder mergeStandardReadRemoteWrites(
        com.google.bigtable.admin.v2.StandardReadRemoteWrites value) {
      if (standardReadRemoteWritesBuilder_ == null) {
        if (modeCase_ == 3
            && mode_
                != com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance()) {
          mode_ =
              com.google.bigtable.admin.v2.StandardReadRemoteWrites.newBuilder(
                      (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          standardReadRemoteWritesBuilder_.mergeFrom(value);
        } else {
          standardReadRemoteWritesBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    public Builder clearStandardReadRemoteWrites() {
      if (standardReadRemoteWritesBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        standardReadRemoteWritesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    public com.google.bigtable.admin.v2.StandardReadRemoteWrites.Builder
        getStandardReadRemoteWritesBuilder() {
      return getStandardReadRemoteWritesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.StandardReadRemoteWritesOrBuilder
        getStandardReadRemoteWritesOrBuilder() {
      if ((modeCase_ == 3) && (standardReadRemoteWritesBuilder_ != null)) {
        return standardReadRemoteWritesBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_;
        }
        return com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `StandardIsolation` can
     * see all writes committed before the token was created, even if the
     * read and write target different clusters.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StandardReadRemoteWrites standard_read_remote_writes = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.StandardReadRemoteWrites,
            com.google.bigtable.admin.v2.StandardReadRemoteWrites.Builder,
            com.google.bigtable.admin.v2.StandardReadRemoteWritesOrBuilder>
        getStandardReadRemoteWritesFieldBuilder() {
      if (standardReadRemoteWritesBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ = com.google.bigtable.admin.v2.StandardReadRemoteWrites.getDefaultInstance();
        }
        standardReadRemoteWritesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.StandardReadRemoteWrites,
                com.google.bigtable.admin.v2.StandardReadRemoteWrites.Builder,
                com.google.bigtable.admin.v2.StandardReadRemoteWritesOrBuilder>(
                (com.google.bigtable.admin.v2.StandardReadRemoteWrites) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      return standardReadRemoteWritesBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.DataBoostReadLocalWrites,
            com.google.bigtable.admin.v2.DataBoostReadLocalWrites.Builder,
            com.google.bigtable.admin.v2.DataBoostReadLocalWritesOrBuilder>
        dataBoostReadLocalWritesBuilder_;
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     *
     * @return Whether the dataBoostReadLocalWrites field is set.
     */
    @java.lang.Override
    public boolean hasDataBoostReadLocalWrites() {
      return modeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     *
     * @return The dataBoostReadLocalWrites.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.DataBoostReadLocalWrites getDataBoostReadLocalWrites() {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        if (modeCase_ == 4) {
          return (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_;
        }
        return com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
      } else {
        if (modeCase_ == 4) {
          return dataBoostReadLocalWritesBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    public Builder setDataBoostReadLocalWrites(
        com.google.bigtable.admin.v2.DataBoostReadLocalWrites value) {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        dataBoostReadLocalWritesBuilder_.setMessage(value);
      }
      modeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    public Builder setDataBoostReadLocalWrites(
        com.google.bigtable.admin.v2.DataBoostReadLocalWrites.Builder builderForValue) {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        dataBoostReadLocalWritesBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    public Builder mergeDataBoostReadLocalWrites(
        com.google.bigtable.admin.v2.DataBoostReadLocalWrites value) {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        if (modeCase_ == 4
            && mode_
                != com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance()) {
          mode_ =
              com.google.bigtable.admin.v2.DataBoostReadLocalWrites.newBuilder(
                      (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 4) {
          dataBoostReadLocalWritesBuilder_.mergeFrom(value);
        } else {
          dataBoostReadLocalWritesBuilder_.setMessage(value);
        }
      }
      modeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    public Builder clearDataBoostReadLocalWrites() {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        if (modeCase_ == 4) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 4) {
          modeCase_ = 0;
          mode_ = null;
        }
        dataBoostReadLocalWritesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    public com.google.bigtable.admin.v2.DataBoostReadLocalWrites.Builder
        getDataBoostReadLocalWritesBuilder() {
      return getDataBoostReadLocalWritesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.DataBoostReadLocalWritesOrBuilder
        getDataBoostReadLocalWritesOrBuilder() {
      if ((modeCase_ == 4) && (dataBoostReadLocalWritesBuilder_ != null)) {
        return dataBoostReadLocalWritesBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 4) {
          return (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_;
        }
        return com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Checks that reads using an app profile with `DataBoostIsolationReadOnly`
     * can see all writes committed before the token was created, but only if
     * the read and write target the same cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.DataBoostReadLocalWrites data_boost_read_local_writes = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.DataBoostReadLocalWrites,
            com.google.bigtable.admin.v2.DataBoostReadLocalWrites.Builder,
            com.google.bigtable.admin.v2.DataBoostReadLocalWritesOrBuilder>
        getDataBoostReadLocalWritesFieldBuilder() {
      if (dataBoostReadLocalWritesBuilder_ == null) {
        if (!(modeCase_ == 4)) {
          mode_ = com.google.bigtable.admin.v2.DataBoostReadLocalWrites.getDefaultInstance();
        }
        dataBoostReadLocalWritesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.DataBoostReadLocalWrites,
                com.google.bigtable.admin.v2.DataBoostReadLocalWrites.Builder,
                com.google.bigtable.admin.v2.DataBoostReadLocalWritesOrBuilder>(
                (com.google.bigtable.admin.v2.DataBoostReadLocalWrites) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 4;
      onChanged();
      return dataBoostReadLocalWritesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.CheckConsistencyRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.CheckConsistencyRequest)
  private static final com.google.bigtable.admin.v2.CheckConsistencyRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.CheckConsistencyRequest();
  }

  public static com.google.bigtable.admin.v2.CheckConsistencyRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckConsistencyRequest> PARSER =
      new com.google.protobuf.AbstractParser<CheckConsistencyRequest>() {
        @java.lang.Override
        public CheckConsistencyRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CheckConsistencyRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckConsistencyRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.CheckConsistencyRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
