/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/types.proto

// Protobuf Java Version: 3.25.2
package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * `Type` represents the type of data that is written to, read from, or stored
 * in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
 * familiarity and consistency across products and features.
 *
 * For compatibility with Bigtable's existing untyped APIs, each `Type` includes
 * an `Encoding` which describes how to convert to/from the underlying data.
 * This might involve composing a series of steps into an "encoding chain," for
 * example to convert from INT64 -&gt; STRING -&gt; raw bytes. In most cases, a "link"
 * in the encoding chain will be based an on existing GoogleSQL conversion
 * function like `CAST`.
 *
 * Each link in the encoding chain also defines the following properties:
 *  * Natural sort: Does the encoded value sort consistently with the original
 *    typed value? Note that Bigtable will always sort data based on the raw
 *    encoded value, *not* the decoded type.
 *     - Example: STRING values sort in the same order as their UTF-8 encodings.
 *     - Counterexample: Encoding INT64 to a fixed-width STRING does *not*
 *       preserve sort order when dealing with negative numbers.
 *       INT64(1) &gt; INT64(-1), but STRING("-00001") &gt; STRING("00001).
 *     - The overall encoding chain sorts naturally if *every* link does.
 *  * Self-delimiting: If we concatenate two encoded values, can we always tell
 *    where the first one ends and the second one begins?
 *     - Example: If we encode INT64s to fixed-width STRINGs, the first value
 *       will always contain exactly N digits, possibly preceded by a sign.
 *     - Counterexample: If we concatenate two UTF-8 encoded STRINGs, we have
 *       no way to tell where the first one ends.
 *     - The overall encoding chain is self-delimiting if *any* link is.
 *  * Compatibility: Which other systems have matching encoding schemes? For
 *    example, does this encoding have a GoogleSQL equivalent? HBase? Java?
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Type}
 */
public final class Type extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type)
    TypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Type.newBuilder() to construct.
  private Type(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Type() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Type();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TypesProto
        .internal_static_google_bigtable_admin_v2_Type_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TypesProto
        .internal_static_google_bigtable_admin_v2_Type_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Type.class,
            com.google.bigtable.admin.v2.Type.Builder.class);
  }

  public interface BytesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding();
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Bytes
   * Values of type `Bytes` are stored in `Value.bytes_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes}
   */
  public static final class Bytes extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes)
      BytesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Bytes.newBuilder() to construct.
    private Bytes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Bytes() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Bytes();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Bytes_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Bytes.class,
              com.google.bigtable.admin.v2.Type.Bytes.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return Whether the raw field is set.
       */
      boolean hasRaw();
      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return The raw.
       */
      com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw();
      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       */
      com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder();

      com.google.bigtable.admin.v2.Type.Bytes.Encoding.EncodingCase getEncodingCase();
    }
    /**
     *
     *
     * <pre>
     * Rules used to convert to/from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Encoding();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.class,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder.class);
      }

      public interface RawOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
          com.google.protobuf.MessageOrBuilder {}
      /**
       *
       *
       * <pre>
       * Leaves the value "as-is"
       * * Natural sort? Yes
       * * Self-delimiting? No
       * * Compatibility? N/A
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding.Raw}
       */
      public static final class Raw extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
          RawOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use Raw.newBuilder() to construct.
        private Raw(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Raw() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Raw();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.class,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder.class);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw other =
              (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) obj;

          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Leaves the value "as-is"
         * * Natural sort? Yes
         * * Self-delimiting? No
         * * Compatibility? N/A
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding.Raw}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.class,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder.class);
          }

          // Construct using com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_Raw_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw build() {
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw buildPartial() {
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw result =
                new com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw(this);
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) {
              return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw other) {
            if (other == com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance())
              return this;
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes.Encoding.Raw)
        private static final com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw();
        }

        public static com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Raw> PARSER =
            new com.google.protobuf.AbstractParser<Raw>() {
              @java.lang.Override
              public Raw parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Raw> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Raw> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        RAW(1),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return RAW;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int RAW_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return Whether the raw field is set.
       */
      @java.lang.Override
      public boolean hasRaw() {
        return encodingCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       *
       * @return The raw.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Use `Raw` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(1, (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Bytes.Encoding other =
            (com.google.bigtable.admin.v2.Type.Bytes.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getRaw().equals(other.getRaw())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + RAW_FIELD_NUMBER;
            hash = (53 * hash) + getRaw().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Bytes.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Rules used to convert to/from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes.Encoding)
          com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Bytes.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (rawBuilder_ != null) {
            rawBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Bytes_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding build() {
          com.google.bigtable.admin.v2.Type.Bytes.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Bytes.Encoding result =
              new com.google.bigtable.admin.v2.Type.Bytes.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Bytes.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Bytes.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && rawBuilder_ != null) {
            result.encoding_ = rawBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Bytes.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case RAW:
              {
                mergeRaw(other.getRaw());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getRawFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>
            rawBuilder_;
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         *
         * @return Whether the raw field is set.
         */
        @java.lang.Override
        public boolean hasRaw() {
          return encodingCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         *
         * @return The raw.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw getRaw() {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return rawBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder setRaw(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw value) {
          if (rawBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            rawBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder setRaw(
            com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder builderForValue) {
          if (rawBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            rawBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder mergeRaw(com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw value) {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              rawBuilder_.mergeFrom(value);
            } else {
              rawBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public Builder clearRaw() {
          if (rawBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            rawBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder getRawBuilder() {
          return getRawFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder getRawOrBuilder() {
          if ((encodingCase_ == 1) && (rawBuilder_ != null)) {
            return rawBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Use `Raw` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw raw = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>
            getRawFieldBuilder() {
          if (rawBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ = com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.getDefaultInstance();
            }
            rawBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw.Builder,
                    com.google.bigtable.admin.v2.Type.Bytes.Encoding.RawOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Bytes.Encoding.Raw) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return rawBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Bytes.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.Bytes.Encoding encoding_;
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
          : encoding_;
    }
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Bytes)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Bytes other = (com.google.bigtable.admin.v2.Type.Bytes) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Bytes parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Bytes prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * Values of type `Bytes` are stored in `Value.bytes_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Bytes}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Bytes)
        com.google.bigtable.admin.v2.Type.BytesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Bytes.class,
                com.google.bigtable.admin.v2.Type.Bytes.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Bytes.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Bytes_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes build() {
        com.google.bigtable.admin.v2.Type.Bytes result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Bytes buildPartial() {
        com.google.bigtable.admin.v2.Type.Bytes result =
            new com.google.bigtable.admin.v2.Type.Bytes(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Bytes result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Bytes) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Bytes) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Bytes other) {
        if (other == com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.Bytes.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Bytes.Encoding,
              com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>
          encodingBuilder_;
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Bytes.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Bytes.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEncodingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.Encoding.getDefaultInstance()
              : encoding_;
        }
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Bytes.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Bytes.Encoding,
              com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>
          getEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding,
                  com.google.bigtable.admin.v2.Type.Bytes.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Bytes.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Bytes)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Bytes)
    private static final com.google.bigtable.admin.v2.Type.Bytes DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Bytes();
    }

    public static com.google.bigtable.admin.v2.Type.Bytes getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bytes> PARSER =
        new com.google.protobuf.AbstractParser<Bytes>() {
          @java.lang.Override
          public Bytes parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Bytes> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bytes> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface Int64OrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    boolean hasEncoding();
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding();
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     */
    com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Int64
   * Values of type `Int64` are stored in `Value.int_value`.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Int64}
   */
  public static final class Int64 extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64)
      Int64OrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Int64.newBuilder() to construct.
    private Int64(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Int64() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Int64();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Int64_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Int64.class,
              com.google.bigtable.admin.v2.Type.Int64.Builder.class);
    }

    public interface EncodingOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64.Encoding)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return Whether the bigEndianBytes field is set.
       */
      boolean hasBigEndianBytes();
      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return The bigEndianBytes.
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes();
      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       */
      com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
          getBigEndianBytesOrBuilder();

      com.google.bigtable.admin.v2.Type.Int64.Encoding.EncodingCase getEncodingCase();
    }
    /**
     *
     *
     * <pre>
     * Rules used to convert to/from lower level types.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding}
     */
    public static final class Encoding extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64.Encoding)
        EncodingOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Encoding.newBuilder() to construct.
      private Encoding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Encoding() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Encoding();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Int64.Encoding.class,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder.class);
      }

      public interface BigEndianBytesOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         *
         * @return Whether the bytesType field is set.
         */
        boolean hasBytesType();
        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         *
         * @return The bytesType.
         */
        com.google.bigtable.admin.v2.Type.Bytes getBytesType();
        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         */
        com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Encodes the value as an 8-byte big endian twos complement `Bytes`
       * value.
       * * Natural sort? No (positive values only)
       * * Self-delimiting? Yes
       * * Compatibility?
       *    - BigQuery Federation `BINARY` encoding
       *    - HBase `Bytes.toBytes`
       *    - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes}
       */
      public static final class BigEndianBytes extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
          BigEndianBytesOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use BigEndianBytes.newBuilder() to construct.
        private BigEndianBytes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private BigEndianBytes() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new BigEndianBytes();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.class,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder.class);
        }

        private int bitField0_;
        public static final int BYTES_TYPE_FIELD_NUMBER = 1;
        private com.google.bigtable.admin.v2.Type.Bytes bytesType_;
        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         *
         * @return Whether the bytesType field is set.
         */
        @java.lang.Override
        public boolean hasBytesType() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         *
         * @return The bytesType.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
          return bytesType_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
              : bytesType_;
        }
        /**
         *
         *
         * <pre>
         * The underlying `Bytes` type, which may be able to encode further.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
          return bytesType_ == null
              ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
              : bytesType_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getBytesType());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBytesType());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)) {
            return super.equals(obj);
          }
          com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes other =
              (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) obj;

          if (hasBytesType() != other.hasBytesType()) return false;
          if (hasBytesType()) {
            if (!getBytesType().equals(other.getBytesType())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasBytesType()) {
            hash = (37 * hash) + BYTES_TYPE_FIELD_NUMBER;
            hash = (53 * hash) + getBytesType().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Encodes the value as an 8-byte big endian twos complement `Bytes`
         * value.
         * * Natural sort? No (positive values only)
         * * Self-delimiting? Yes
         * * Compatibility?
         *    - BigQuery Federation `BINARY` encoding
         *    - HBase `Bytes.toBytes`
         *    - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
         * </pre>
         *
         * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.class,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder.class);
          }

          // Construct using
          // com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getBytesTypeFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            bytesType_ = null;
            if (bytesTypeBuilder_ != null) {
              bytesTypeBuilder_.dispose();
              bytesTypeBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.bigtable.admin.v2.TypesProto
                .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_BigEndianBytes_descriptor;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
              getDefaultInstanceForType() {
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes build() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes buildPartial() {
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result =
                new com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.bytesType_ =
                  bytesTypeBuilder_ == null ? bytesType_ : bytesTypeBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) {
              return mergeFrom(
                  (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes other) {
            if (other
                == com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                    .getDefaultInstance()) return this;
            if (other.hasBytesType()) {
              mergeBytesType(other.getBytesType());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getBytesTypeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.bigtable.admin.v2.Type.Bytes bytesType_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type.Bytes,
                  com.google.bigtable.admin.v2.Type.Bytes.Builder,
                  com.google.bigtable.admin.v2.Type.BytesOrBuilder>
              bytesTypeBuilder_;
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           *
           * @return Whether the bytesType field is set.
           */
          public boolean hasBytesType() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           *
           * @return The bytesType.
           */
          public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
            if (bytesTypeBuilder_ == null) {
              return bytesType_ == null
                  ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
                  : bytesType_;
            } else {
              return bytesTypeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
            if (bytesTypeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              bytesType_ = value;
            } else {
              bytesTypeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public Builder setBytesType(
              com.google.bigtable.admin.v2.Type.Bytes.Builder builderForValue) {
            if (bytesTypeBuilder_ == null) {
              bytesType_ = builderForValue.build();
            } else {
              bytesTypeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public Builder mergeBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
            if (bytesTypeBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && bytesType_ != null
                  && bytesType_ != com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) {
                getBytesTypeBuilder().mergeFrom(value);
              } else {
                bytesType_ = value;
              }
            } else {
              bytesTypeBuilder_.mergeFrom(value);
            }
            if (bytesType_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public Builder clearBytesType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            bytesType_ = null;
            if (bytesTypeBuilder_ != null) {
              bytesTypeBuilder_.dispose();
              bytesTypeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public com.google.bigtable.admin.v2.Type.Bytes.Builder getBytesTypeBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getBytesTypeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
            if (bytesTypeBuilder_ != null) {
              return bytesTypeBuilder_.getMessageOrBuilder();
            } else {
              return bytesType_ == null
                  ? com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()
                  : bytesType_;
            }
          }
          /**
           *
           *
           * <pre>
           * The underlying `Bytes` type, which may be able to encode further.
           * </pre>
           *
           * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type.Bytes,
                  com.google.bigtable.admin.v2.Type.Bytes.Builder,
                  com.google.bigtable.admin.v2.Type.BytesOrBuilder>
              getBytesTypeFieldBuilder() {
            if (bytesTypeBuilder_ == null) {
              bytesTypeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.bigtable.admin.v2.Type.Bytes,
                      com.google.bigtable.admin.v2.Type.Bytes.Builder,
                      com.google.bigtable.admin.v2.Type.BytesOrBuilder>(
                      getBytesType(), getParentForChildren(), isClean());
              bytesType_ = null;
            }
            return bytesTypeBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
        }

        // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
        private static final com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes();
        }

        public static com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<BigEndianBytes> PARSER =
            new com.google.protobuf.AbstractParser<BigEndianBytes>() {
              @java.lang.Override
              public BigEndianBytes parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<BigEndianBytes> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BigEndianBytes> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int encodingCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object encoding_;

      public enum EncodingCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        BIG_ENDIAN_BYTES(1),
        ENCODING_NOT_SET(0);
        private final int value;

        private EncodingCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static EncodingCase valueOf(int value) {
          return forNumber(value);
        }

        public static EncodingCase forNumber(int value) {
          switch (value) {
            case 1:
              return BIG_ENDIAN_BYTES;
            case 0:
              return ENCODING_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public EncodingCase getEncodingCase() {
        return EncodingCase.forNumber(encodingCase_);
      }

      public static final int BIG_ENDIAN_BYTES_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return Whether the bigEndianBytes field is set.
       */
      @java.lang.Override
      public boolean hasBigEndianBytes() {
        return encodingCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       *
       * @return The bigEndianBytes.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Use `BigEndianBytes` encoding.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
          getBigEndianBytesOrBuilder() {
        if (encodingCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (encodingCase_ == 1) {
          output.writeMessage(
              1, (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (encodingCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1, (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Int64.Encoding other =
            (com.google.bigtable.admin.v2.Type.Int64.Encoding) obj;

        if (!getEncodingCase().equals(other.getEncodingCase())) return false;
        switch (encodingCase_) {
          case 1:
            if (!getBigEndianBytes().equals(other.getBigEndianBytes())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (encodingCase_) {
          case 1:
            hash = (37 * hash) + BIG_ENDIAN_BYTES_FIELD_NUMBER;
            hash = (53 * hash) + getBigEndianBytes().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Int64.Encoding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Rules used to convert to/from lower level types.
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Int64.Encoding}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64.Encoding)
          com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.class,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Int64.Encoding.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (bigEndianBytesBuilder_ != null) {
            bigEndianBytesBuilder_.clear();
          }
          encodingCase_ = 0;
          encoding_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Int64_Encoding_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding build() {
          com.google.bigtable.admin.v2.Type.Int64.Encoding result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding buildPartial() {
          com.google.bigtable.admin.v2.Type.Int64.Encoding result =
              new com.google.bigtable.admin.v2.Type.Int64.Encoding(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.bigtable.admin.v2.Type.Int64.Encoding result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Int64.Encoding result) {
          result.encodingCase_ = encodingCase_;
          result.encoding_ = this.encoding_;
          if (encodingCase_ == 1 && bigEndianBytesBuilder_ != null) {
            result.encoding_ = bigEndianBytesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Int64.Encoding) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Int64.Encoding) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Int64.Encoding other) {
          if (other == com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance())
            return this;
          switch (other.getEncodingCase()) {
            case BIG_ENDIAN_BYTES:
              {
                mergeBigEndianBytes(other.getBigEndianBytes());
                break;
              }
            case ENCODING_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getBigEndianBytesFieldBuilder().getBuilder(), extensionRegistry);
                    encodingCase_ = 1;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int encodingCase_ = 0;
        private java.lang.Object encoding_;

        public EncodingCase getEncodingCase() {
          return EncodingCase.forNumber(encodingCase_);
        }

        public Builder clearEncoding() {
          encodingCase_ = 0;
          encoding_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>
            bigEndianBytesBuilder_;
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         *
         * @return Whether the bigEndianBytes field is set.
         */
        @java.lang.Override
        public boolean hasBigEndianBytes() {
          return encodingCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         *
         * @return The bigEndianBytes.
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes getBigEndianBytes() {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          } else {
            if (encodingCase_ == 1) {
              return bigEndianBytesBuilder_.getMessage();
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder setBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes value) {
          if (bigEndianBytesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            encoding_ = value;
            onChanged();
          } else {
            bigEndianBytesBuilder_.setMessage(value);
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder setBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder
                builderForValue) {
          if (bigEndianBytesBuilder_ == null) {
            encoding_ = builderForValue.build();
            onChanged();
          } else {
            bigEndianBytesBuilder_.setMessage(builderForValue.build());
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder mergeBigEndianBytes(
            com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes value) {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1
                && encoding_
                    != com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                        .getDefaultInstance()) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.newBuilder(
                          (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes)
                              encoding_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              encoding_ = value;
            }
            onChanged();
          } else {
            if (encodingCase_ == 1) {
              bigEndianBytesBuilder_.mergeFrom(value);
            } else {
              bigEndianBytesBuilder_.setMessage(value);
            }
          }
          encodingCase_ = 1;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public Builder clearBigEndianBytes() {
          if (bigEndianBytesBuilder_ == null) {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
              onChanged();
            }
          } else {
            if (encodingCase_ == 1) {
              encodingCase_ = 0;
              encoding_ = null;
            }
            bigEndianBytesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder
            getBigEndianBytesBuilder() {
          return getBigEndianBytesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder
            getBigEndianBytesOrBuilder() {
          if ((encodingCase_ == 1) && (bigEndianBytesBuilder_ != null)) {
            return bigEndianBytesBuilder_.getMessageOrBuilder();
          } else {
            if (encodingCase_ == 1) {
              return (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_;
            }
            return com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                .getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Use `BigEndianBytes` encoding.
         * </pre>
         *
         * <code>.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes big_endian_bytes = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>
            getBigEndianBytesFieldBuilder() {
          if (bigEndianBytesBuilder_ == null) {
            if (!(encodingCase_ == 1)) {
              encoding_ =
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes
                      .getDefaultInstance();
            }
            bigEndianBytesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes.Builder,
                    com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytesOrBuilder>(
                    (com.google.bigtable.admin.v2.Type.Int64.Encoding.BigEndianBytes) encoding_,
                    getParentForChildren(),
                    isClean());
            encoding_ = null;
          }
          encodingCase_ = 1;
          onChanged();
          return bigEndianBytesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64.Encoding)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64.Encoding)
      private static final com.google.bigtable.admin.v2.Type.Int64.Encoding DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64.Encoding();
      }

      public static com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Encoding> PARSER =
          new com.google.protobuf.AbstractParser<Encoding>() {
            @java.lang.Override
            public Encoding parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Encoding> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Encoding> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64.Encoding getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int ENCODING_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type.Int64.Encoding encoding_;
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return Whether the encoding field is set.
     */
    @java.lang.Override
    public boolean hasEncoding() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
          : encoding_;
    }
    /**
     *
     *
     * <pre>
     * The encoding to use when converting to/from lower level types.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder() {
      return encoding_ == null
          ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
          : encoding_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEncoding());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEncoding());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Int64)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Int64 other = (com.google.bigtable.admin.v2.Type.Int64) obj;

      if (hasEncoding() != other.hasEncoding()) return false;
      if (hasEncoding()) {
        if (!getEncoding().equals(other.getEncoding())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEncoding()) {
        hash = (37 * hash) + ENCODING_FIELD_NUMBER;
        hash = (53 * hash) + getEncoding().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Int64 parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Int64 prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * Values of type `Int64` are stored in `Value.int_value`.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Int64}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Int64)
        com.google.bigtable.admin.v2.Type.Int64OrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Int64.class,
                com.google.bigtable.admin.v2.Type.Int64.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Int64.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEncodingFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Int64_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 build() {
        com.google.bigtable.admin.v2.Type.Int64 result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Int64 buildPartial() {
        com.google.bigtable.admin.v2.Type.Int64 result =
            new com.google.bigtable.admin.v2.Type.Int64(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Int64 result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.encoding_ = encodingBuilder_ == null ? encoding_ : encodingBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Int64) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Int64) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Int64 other) {
        if (other == com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance()) return this;
        if (other.hasEncoding()) {
          mergeEncoding(other.getEncoding());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getEncodingFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type.Int64.Encoding encoding_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Int64.Encoding,
              com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
          encodingBuilder_;
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       *
       * @return Whether the encoding field is set.
       */
      public boolean hasEncoding() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       *
       * @return The encoding.
       */
      public com.google.bigtable.admin.v2.Type.Int64.Encoding getEncoding() {
        if (encodingBuilder_ == null) {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
              : encoding_;
        } else {
          return encodingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
        if (encodingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encoding_ = value;
        } else {
          encodingBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder setEncoding(
          com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder builderForValue) {
        if (encodingBuilder_ == null) {
          encoding_ = builderForValue.build();
        } else {
          encodingBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder mergeEncoding(com.google.bigtable.admin.v2.Type.Int64.Encoding value) {
        if (encodingBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && encoding_ != null
              && encoding_
                  != com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()) {
            getEncodingBuilder().mergeFrom(value);
          } else {
            encoding_ = value;
          }
        } else {
          encodingBuilder_.mergeFrom(value);
        }
        if (encoding_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000001);
        encoding_ = null;
        if (encodingBuilder_ != null) {
          encodingBuilder_.dispose();
          encodingBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder getEncodingBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEncodingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder getEncodingOrBuilder() {
        if (encodingBuilder_ != null) {
          return encodingBuilder_.getMessageOrBuilder();
        } else {
          return encoding_ == null
              ? com.google.bigtable.admin.v2.Type.Int64.Encoding.getDefaultInstance()
              : encoding_;
        }
      }
      /**
       *
       *
       * <pre>
       * The encoding to use when converting to/from lower level types.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Int64.Encoding encoding = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Int64.Encoding,
              com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
              com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>
          getEncodingFieldBuilder() {
        if (encodingBuilder_ == null) {
          encodingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type.Int64.Encoding,
                  com.google.bigtable.admin.v2.Type.Int64.Encoding.Builder,
                  com.google.bigtable.admin.v2.Type.Int64.EncodingOrBuilder>(
                  getEncoding(), getParentForChildren(), isClean());
          encoding_ = null;
        }
        return encodingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Int64)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Int64)
    private static final com.google.bigtable.admin.v2.Type.Int64 DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Int64();
    }

    public static com.google.bigtable.admin.v2.Type.Int64 getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Int64> PARSER =
        new com.google.protobuf.AbstractParser<Int64>() {
          @java.lang.Override
          public Int64 parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Int64> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Int64> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64 getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AggregateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return Whether the inputType field is set.
     */
    boolean hasInputType();
    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return The inputType.
     */
    com.google.bigtable.admin.v2.Type getInputType();
    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateType field is set.
     */
    boolean hasStateType();
    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateType.
     */
    com.google.bigtable.admin.v2.Type getStateType();
    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return Whether the sum field is set.
     */
    boolean hasSum();
    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return The sum.
     */
    com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum();
    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     */
    com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder();

    com.google.bigtable.admin.v2.Type.Aggregate.AggregatorCase getAggregatorCase();
  }
  /**
   *
   *
   * <pre>
   * A value that combines incremental updates into a summarized value.
   *
   * Data is never directly written or read using type `Aggregate`. Writes will
   * provide either the `input_type` or `state_type`, and reads will always
   * return the `state_type` .
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate}
   */
  public static final class Aggregate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate)
      AggregateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Aggregate.newBuilder() to construct.
    private Aggregate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Aggregate() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Aggregate();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_Aggregate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.Aggregate.class,
              com.google.bigtable.admin.v2.Type.Aggregate.Builder.class);
    }

    public interface SumOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Type.Aggregate.Sum)
        com.google.protobuf.MessageOrBuilder {}
    /**
     *
     *
     * <pre>
     * Computes the sum of the input values.
     * Allowed input: `Int64`
     * State: same as input
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Sum}
     */
    public static final class Sum extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Type.Aggregate.Sum)
        SumOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Sum.newBuilder() to construct.
      private Sum(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Sum() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Sum();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate.Sum)) {
          return super.equals(obj);
        }
        com.google.bigtable.admin.v2.Type.Aggregate.Sum other =
            (com.google.bigtable.admin.v2.Type.Aggregate.Sum) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate.Sum prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Computes the sum of the input values.
       * Allowed input: `Int64`
       * State: same as input
       * </pre>
       *
       * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate.Sum}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate.Sum)
          com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.class,
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder.class);
        }

        // Construct using com.google.bigtable.admin.v2.Type.Aggregate.Sum.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.bigtable.admin.v2.TypesProto
              .internal_static_google_bigtable_admin_v2_Type_Aggregate_Sum_descriptor;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstanceForType() {
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum build() {
          com.google.bigtable.admin.v2.Type.Aggregate.Sum result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.bigtable.admin.v2.Type.Aggregate.Sum buildPartial() {
          com.google.bigtable.admin.v2.Type.Aggregate.Sum result =
              new com.google.bigtable.admin.v2.Type.Aggregate.Sum(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate.Sum) {
            return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate.Sum) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate.Sum other) {
          if (other == com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance())
            return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate.Sum)
      }

      // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate.Sum)
      private static final com.google.bigtable.admin.v2.Type.Aggregate.Sum DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate.Sum();
      }

      public static com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Sum> PARSER =
          new com.google.protobuf.AbstractParser<Sum>() {
            @java.lang.Override
            public Sum parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Sum> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Sum> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int aggregatorCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object aggregator_;

    public enum AggregatorCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SUM(4),
      AGGREGATOR_NOT_SET(0);
      private final int value;

      private AggregatorCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AggregatorCase valueOf(int value) {
        return forNumber(value);
      }

      public static AggregatorCase forNumber(int value) {
        switch (value) {
          case 4:
            return SUM;
          case 0:
            return AGGREGATOR_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AggregatorCase getAggregatorCase() {
      return AggregatorCase.forNumber(aggregatorCase_);
    }

    public static final int INPUT_TYPE_FIELD_NUMBER = 1;
    private com.google.bigtable.admin.v2.Type inputType_;
    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return Whether the inputType field is set.
     */
    @java.lang.Override
    public boolean hasInputType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     *
     * @return The inputType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getInputType() {
      return inputType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : inputType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the inputs that are accumulated by this `Aggregate`, which must
     * specify a full encoding.
     * Use `AddInput` mutations to accumulate new inputs.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder() {
      return inputType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : inputType_;
    }

    public static final int STATE_TYPE_FIELD_NUMBER = 2;
    private com.google.bigtable.admin.v2.Type stateType_;
    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateType field is set.
     */
    @java.lang.Override
    public boolean hasStateType() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getStateType() {
      return stateType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : stateType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type that holds the internal accumulator state for the
     * `Aggregate`. This is a function of the `input_type` and `aggregator`
     * chosen, and will always specify a full encoding.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder() {
      return stateType_ == null
          ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
          : stateType_;
    }

    public static final int SUM_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return aggregatorCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     *
     * @return The sum.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum() {
      if (aggregatorCase_ == 4) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Sum aggregator.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder() {
      if (aggregatorCase_ == 4) {
        return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
      }
      return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getInputType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getStateType());
      }
      if (aggregatorCase_ == 4) {
        output.writeMessage(4, (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputType());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStateType());
      }
      if (aggregatorCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Type.Aggregate)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Type.Aggregate other =
          (com.google.bigtable.admin.v2.Type.Aggregate) obj;

      if (hasInputType() != other.hasInputType()) return false;
      if (hasInputType()) {
        if (!getInputType().equals(other.getInputType())) return false;
      }
      if (hasStateType() != other.hasStateType()) return false;
      if (hasStateType()) {
        if (!getStateType().equals(other.getStateType())) return false;
      }
      if (!getAggregatorCase().equals(other.getAggregatorCase())) return false;
      switch (aggregatorCase_) {
        case 4:
          if (!getSum().equals(other.getSum())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasInputType()) {
        hash = (37 * hash) + INPUT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getInputType().hashCode();
      }
      if (hasStateType()) {
        hash = (37 * hash) + STATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getStateType().hashCode();
      }
      switch (aggregatorCase_) {
        case 4:
          hash = (37 * hash) + SUM_FIELD_NUMBER;
          hash = (53 * hash) + getSum().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Type.Aggregate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A value that combines incremental updates into a summarized value.
     *
     * Data is never directly written or read using type `Aggregate`. Writes will
     * provide either the `input_type` or `state_type`, and reads will always
     * return the `state_type` .
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Type.Aggregate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type.Aggregate)
        com.google.bigtable.admin.v2.Type.AggregateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Type.Aggregate.class,
                com.google.bigtable.admin.v2.Type.Aggregate.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Type.Aggregate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getInputTypeFieldBuilder();
          getStateTypeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        inputType_ = null;
        if (inputTypeBuilder_ != null) {
          inputTypeBuilder_.dispose();
          inputTypeBuilder_ = null;
        }
        stateType_ = null;
        if (stateTypeBuilder_ != null) {
          stateTypeBuilder_.dispose();
          stateTypeBuilder_ = null;
        }
        if (sumBuilder_ != null) {
          sumBuilder_.clear();
        }
        aggregatorCase_ = 0;
        aggregator_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TypesProto
            .internal_static_google_bigtable_admin_v2_Type_Aggregate_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate build() {
        com.google.bigtable.admin.v2.Type.Aggregate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate buildPartial() {
        com.google.bigtable.admin.v2.Type.Aggregate result =
            new com.google.bigtable.admin.v2.Type.Aggregate(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.admin.v2.Type.Aggregate result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.inputType_ = inputTypeBuilder_ == null ? inputType_ : inputTypeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stateType_ = stateTypeBuilder_ == null ? stateType_ : stateTypeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.bigtable.admin.v2.Type.Aggregate result) {
        result.aggregatorCase_ = aggregatorCase_;
        result.aggregator_ = this.aggregator_;
        if (aggregatorCase_ == 4 && sumBuilder_ != null) {
          result.aggregator_ = sumBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Type.Aggregate) {
          return mergeFrom((com.google.bigtable.admin.v2.Type.Aggregate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Type.Aggregate other) {
        if (other == com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance()) return this;
        if (other.hasInputType()) {
          mergeInputType(other.getInputType());
        }
        if (other.hasStateType()) {
          mergeStateType(other.getStateType());
        }
        switch (other.getAggregatorCase()) {
          case SUM:
            {
              mergeSum(other.getSum());
              break;
            }
          case AGGREGATOR_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getInputTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getStateTypeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 34:
                {
                  input.readMessage(getSumFieldBuilder().getBuilder(), extensionRegistry);
                  aggregatorCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int aggregatorCase_ = 0;
      private java.lang.Object aggregator_;

      public AggregatorCase getAggregatorCase() {
        return AggregatorCase.forNumber(aggregatorCase_);
      }

      public Builder clearAggregator() {
        aggregatorCase_ = 0;
        aggregator_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.bigtable.admin.v2.Type inputType_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          inputTypeBuilder_;
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       *
       * @return Whether the inputType field is set.
       */
      public boolean hasInputType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       *
       * @return The inputType.
       */
      public com.google.bigtable.admin.v2.Type getInputType() {
        if (inputTypeBuilder_ == null) {
          return inputType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : inputType_;
        } else {
          return inputTypeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder setInputType(com.google.bigtable.admin.v2.Type value) {
        if (inputTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputType_ = value;
        } else {
          inputTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder setInputType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (inputTypeBuilder_ == null) {
          inputType_ = builderForValue.build();
        } else {
          inputTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder mergeInputType(com.google.bigtable.admin.v2.Type value) {
        if (inputTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && inputType_ != null
              && inputType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getInputTypeBuilder().mergeFrom(value);
          } else {
            inputType_ = value;
          }
        } else {
          inputTypeBuilder_.mergeFrom(value);
        }
        if (inputType_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public Builder clearInputType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        inputType_ = null;
        if (inputTypeBuilder_ != null) {
          inputTypeBuilder_.dispose();
          inputTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getInputTypeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getInputTypeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getInputTypeOrBuilder() {
        if (inputTypeBuilder_ != null) {
          return inputTypeBuilder_.getMessageOrBuilder();
        } else {
          return inputType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : inputType_;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the inputs that are accumulated by this `Aggregate`, which must
       * specify a full encoding.
       * Use `AddInput` mutations to accumulate new inputs.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type input_type = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          getInputTypeFieldBuilder() {
        if (inputTypeBuilder_ == null) {
          inputTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getInputType(), getParentForChildren(), isClean());
          inputType_ = null;
        }
        return inputTypeBuilder_;
      }

      private com.google.bigtable.admin.v2.Type stateType_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          stateTypeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the stateType field is set.
       */
      public boolean hasStateType() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The stateType.
       */
      public com.google.bigtable.admin.v2.Type getStateType() {
        if (stateTypeBuilder_ == null) {
          return stateType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : stateType_;
        } else {
          return stateTypeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateType(com.google.bigtable.admin.v2.Type value) {
        if (stateTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stateType_ = value;
        } else {
          stateTypeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateType(com.google.bigtable.admin.v2.Type.Builder builderForValue) {
        if (stateTypeBuilder_ == null) {
          stateType_ = builderForValue.build();
        } else {
          stateTypeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeStateType(com.google.bigtable.admin.v2.Type value) {
        if (stateTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && stateType_ != null
              && stateType_ != com.google.bigtable.admin.v2.Type.getDefaultInstance()) {
            getStateTypeBuilder().mergeFrom(value);
          } else {
            stateType_ = value;
          }
        } else {
          stateTypeBuilder_.mergeFrom(value);
        }
        if (stateType_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearStateType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stateType_ = null;
        if (stateTypeBuilder_ != null) {
          stateTypeBuilder_.dispose();
          stateTypeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.Type.Builder getStateTypeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStateTypeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.TypeOrBuilder getStateTypeOrBuilder() {
        if (stateTypeBuilder_ != null) {
          return stateTypeBuilder_.getMessageOrBuilder();
        } else {
          return stateType_ == null
              ? com.google.bigtable.admin.v2.Type.getDefaultInstance()
              : stateType_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Type that holds the internal accumulator state for the
       * `Aggregate`. This is a function of the `input_type` and `aggregator`
       * chosen, and will always specify a full encoding.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Type state_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type,
              com.google.bigtable.admin.v2.Type.Builder,
              com.google.bigtable.admin.v2.TypeOrBuilder>
          getStateTypeFieldBuilder() {
        if (stateTypeBuilder_ == null) {
          stateTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type,
                  com.google.bigtable.admin.v2.Type.Builder,
                  com.google.bigtable.admin.v2.TypeOrBuilder>(
                  getStateType(), getParentForChildren(), isClean());
          stateType_ = null;
        }
        return stateTypeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Aggregate.Sum,
              com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>
          sumBuilder_;
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       *
       * @return Whether the sum field is set.
       */
      @java.lang.Override
      public boolean hasSum() {
        return aggregatorCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       *
       * @return The sum.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum getSum() {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        } else {
          if (aggregatorCase_ == 4) {
            return sumBuilder_.getMessage();
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder setSum(com.google.bigtable.admin.v2.Type.Aggregate.Sum value) {
        if (sumBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          aggregator_ = value;
          onChanged();
        } else {
          sumBuilder_.setMessage(value);
        }
        aggregatorCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder setSum(
          com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder builderForValue) {
        if (sumBuilder_ == null) {
          aggregator_ = builderForValue.build();
          onChanged();
        } else {
          sumBuilder_.setMessage(builderForValue.build());
        }
        aggregatorCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder mergeSum(com.google.bigtable.admin.v2.Type.Aggregate.Sum value) {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4
              && aggregator_
                  != com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance()) {
            aggregator_ =
                com.google.bigtable.admin.v2.Type.Aggregate.Sum.newBuilder(
                        (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            aggregator_ = value;
          }
          onChanged();
        } else {
          if (aggregatorCase_ == 4) {
            sumBuilder_.mergeFrom(value);
          } else {
            sumBuilder_.setMessage(value);
          }
        }
        aggregatorCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public Builder clearSum() {
        if (sumBuilder_ == null) {
          if (aggregatorCase_ == 4) {
            aggregatorCase_ = 0;
            aggregator_ = null;
            onChanged();
          }
        } else {
          if (aggregatorCase_ == 4) {
            aggregatorCase_ = 0;
            aggregator_ = null;
          }
          sumBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      public com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder getSumBuilder() {
        return getSumFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder getSumOrBuilder() {
        if ((aggregatorCase_ == 4) && (sumBuilder_ != null)) {
          return sumBuilder_.getMessageOrBuilder();
        } else {
          if (aggregatorCase_ == 4) {
            return (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_;
          }
          return com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Sum aggregator.
       * </pre>
       *
       * <code>.google.bigtable.admin.v2.Type.Aggregate.Sum sum = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.admin.v2.Type.Aggregate.Sum,
              com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
              com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>
          getSumFieldBuilder() {
        if (sumBuilder_ == null) {
          if (!(aggregatorCase_ == 4)) {
            aggregator_ = com.google.bigtable.admin.v2.Type.Aggregate.Sum.getDefaultInstance();
          }
          sumBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum,
                  com.google.bigtable.admin.v2.Type.Aggregate.Sum.Builder,
                  com.google.bigtable.admin.v2.Type.Aggregate.SumOrBuilder>(
                  (com.google.bigtable.admin.v2.Type.Aggregate.Sum) aggregator_,
                  getParentForChildren(),
                  isClean());
          aggregator_ = null;
        }
        aggregatorCase_ = 4;
        onChanged();
        return sumBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type.Aggregate)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type.Aggregate)
    private static final com.google.bigtable.admin.v2.Type.Aggregate DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type.Aggregate();
    }

    public static com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Aggregate> PARSER =
        new com.google.protobuf.AbstractParser<Aggregate>() {
          @java.lang.Override
          public Aggregate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Aggregate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Aggregate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BYTES_TYPE(1),
    INT64_TYPE(5),
    AGGREGATE_TYPE(6),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 1:
          return BYTES_TYPE;
        case 5:
          return INT64_TYPE;
        case 6:
          return AGGREGATE_TYPE;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int BYTES_TYPE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   *
   * @return Whether the bytesType field is set.
   */
  @java.lang.Override
  public boolean hasBytesType() {
    return kindCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   *
   * @return The bytesType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
    if (kindCase_ == 1) {
      return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Bytes
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
    if (kindCase_ == 1) {
      return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
  }

  public static final int INT64_TYPE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   *
   * @return Whether the int64Type field is set.
   */
  @java.lang.Override
  public boolean hasInt64Type() {
    return kindCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   *
   * @return The int64Type.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Int64 getInt64Type() {
    if (kindCase_ == 5) {
      return (com.google.bigtable.admin.v2.Type.Int64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Int64
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Int64OrBuilder getInt64TypeOrBuilder() {
    if (kindCase_ == 5) {
      return (com.google.bigtable.admin.v2.Type.Int64) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
  }

  public static final int AGGREGATE_TYPE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   *
   * @return Whether the aggregateType field is set.
   */
  @java.lang.Override
  public boolean hasAggregateType() {
    return kindCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   *
   * @return The aggregateType.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.Aggregate getAggregateType() {
    if (kindCase_ == 6) {
      return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Aggregate
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Type.AggregateOrBuilder getAggregateTypeOrBuilder() {
    if (kindCase_ == 6) {
      return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
    }
    return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (kindCase_ == 1) {
      output.writeMessage(1, (com.google.bigtable.admin.v2.Type.Bytes) kind_);
    }
    if (kindCase_ == 5) {
      output.writeMessage(5, (com.google.bigtable.admin.v2.Type.Int64) kind_);
    }
    if (kindCase_ == 6) {
      output.writeMessage(6, (com.google.bigtable.admin.v2.Type.Aggregate) kind_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kindCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.admin.v2.Type.Bytes) kind_);
    }
    if (kindCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.bigtable.admin.v2.Type.Int64) kind_);
    }
    if (kindCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.bigtable.admin.v2.Type.Aggregate) kind_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Type)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Type other = (com.google.bigtable.admin.v2.Type) obj;

    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 1:
        if (!getBytesType().equals(other.getBytesType())) return false;
        break;
      case 5:
        if (!getInt64Type().equals(other.getInt64Type())) return false;
        break;
      case 6:
        if (!getAggregateType().equals(other.getAggregateType())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (kindCase_) {
      case 1:
        hash = (37 * hash) + BYTES_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getBytesType().hashCode();
        break;
      case 5:
        hash = (37 * hash) + INT64_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getInt64Type().hashCode();
        break;
      case 6:
        hash = (37 * hash) + AGGREGATE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getAggregateType().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Type parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Type prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Type` represents the type of data that is written to, read from, or stored
   * in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
   * familiarity and consistency across products and features.
   *
   * For compatibility with Bigtable's existing untyped APIs, each `Type` includes
   * an `Encoding` which describes how to convert to/from the underlying data.
   * This might involve composing a series of steps into an "encoding chain," for
   * example to convert from INT64 -&gt; STRING -&gt; raw bytes. In most cases, a "link"
   * in the encoding chain will be based an on existing GoogleSQL conversion
   * function like `CAST`.
   *
   * Each link in the encoding chain also defines the following properties:
   *  * Natural sort: Does the encoded value sort consistently with the original
   *    typed value? Note that Bigtable will always sort data based on the raw
   *    encoded value, *not* the decoded type.
   *     - Example: STRING values sort in the same order as their UTF-8 encodings.
   *     - Counterexample: Encoding INT64 to a fixed-width STRING does *not*
   *       preserve sort order when dealing with negative numbers.
   *       INT64(1) &gt; INT64(-1), but STRING("-00001") &gt; STRING("00001).
   *     - The overall encoding chain sorts naturally if *every* link does.
   *  * Self-delimiting: If we concatenate two encoded values, can we always tell
   *    where the first one ends and the second one begins?
   *     - Example: If we encode INT64s to fixed-width STRINGs, the first value
   *       will always contain exactly N digits, possibly preceded by a sign.
   *     - Counterexample: If we concatenate two UTF-8 encoded STRINGs, we have
   *       no way to tell where the first one ends.
   *     - The overall encoding chain is self-delimiting if *any* link is.
   *  * Compatibility: Which other systems have matching encoding schemes? For
   *    example, does this encoding have a GoogleSQL equivalent? HBase? Java?
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Type}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Type)
      com.google.bigtable.admin.v2.TypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Type.class,
              com.google.bigtable.admin.v2.Type.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Type.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bytesTypeBuilder_ != null) {
        bytesTypeBuilder_.clear();
      }
      if (int64TypeBuilder_ != null) {
        int64TypeBuilder_.clear();
      }
      if (aggregateTypeBuilder_ != null) {
        aggregateTypeBuilder_.clear();
      }
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TypesProto
          .internal_static_google_bigtable_admin_v2_Type_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Type.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type build() {
      com.google.bigtable.admin.v2.Type result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Type buildPartial() {
      com.google.bigtable.admin.v2.Type result = new com.google.bigtable.admin.v2.Type(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.Type result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.admin.v2.Type result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
      if (kindCase_ == 1 && bytesTypeBuilder_ != null) {
        result.kind_ = bytesTypeBuilder_.build();
      }
      if (kindCase_ == 5 && int64TypeBuilder_ != null) {
        result.kind_ = int64TypeBuilder_.build();
      }
      if (kindCase_ == 6 && aggregateTypeBuilder_ != null) {
        result.kind_ = aggregateTypeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Type) {
        return mergeFrom((com.google.bigtable.admin.v2.Type) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Type other) {
      if (other == com.google.bigtable.admin.v2.Type.getDefaultInstance()) return this;
      switch (other.getKindCase()) {
        case BYTES_TYPE:
          {
            mergeBytesType(other.getBytesType());
            break;
          }
        case INT64_TYPE:
          {
            mergeInt64Type(other.getInt64Type());
            break;
          }
        case AGGREGATE_TYPE:
          {
            mergeAggregateType(other.getAggregateType());
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBytesTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 1;
                break;
              } // case 10
            case 42:
              {
                input.readMessage(getInt64TypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getAggregateTypeFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Bytes,
            com.google.bigtable.admin.v2.Type.Bytes.Builder,
            com.google.bigtable.admin.v2.Type.BytesOrBuilder>
        bytesTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     *
     * @return Whether the bytesType field is set.
     */
    @java.lang.Override
    public boolean hasBytesType() {
      return kindCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     *
     * @return The bytesType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Bytes getBytesType() {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      } else {
        if (kindCase_ == 1) {
          return bytesTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
      if (bytesTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        bytesTypeBuilder_.setMessage(value);
      }
      kindCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder setBytesType(com.google.bigtable.admin.v2.Type.Bytes.Builder builderForValue) {
      if (bytesTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        bytesTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder mergeBytesType(com.google.bigtable.admin.v2.Type.Bytes value) {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1
            && kind_ != com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Bytes.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Bytes) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 1) {
          bytesTypeBuilder_.mergeFrom(value);
        } else {
          bytesTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public Builder clearBytesType() {
      if (bytesTypeBuilder_ == null) {
        if (kindCase_ == 1) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 1) {
          kindCase_ = 0;
          kind_ = null;
        }
        bytesTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    public com.google.bigtable.admin.v2.Type.Bytes.Builder getBytesTypeBuilder() {
      return getBytesTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.BytesOrBuilder getBytesTypeOrBuilder() {
      if ((kindCase_ == 1) && (bytesTypeBuilder_ != null)) {
        return bytesTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 1) {
          return (com.google.bigtable.admin.v2.Type.Bytes) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Bytes
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Bytes bytes_type = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Bytes,
            com.google.bigtable.admin.v2.Type.Bytes.Builder,
            com.google.bigtable.admin.v2.Type.BytesOrBuilder>
        getBytesTypeFieldBuilder() {
      if (bytesTypeBuilder_ == null) {
        if (!(kindCase_ == 1)) {
          kind_ = com.google.bigtable.admin.v2.Type.Bytes.getDefaultInstance();
        }
        bytesTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Bytes,
                com.google.bigtable.admin.v2.Type.Bytes.Builder,
                com.google.bigtable.admin.v2.Type.BytesOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Bytes) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 1;
      onChanged();
      return bytesTypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Int64,
            com.google.bigtable.admin.v2.Type.Int64.Builder,
            com.google.bigtable.admin.v2.Type.Int64OrBuilder>
        int64TypeBuilder_;
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     *
     * @return Whether the int64Type field is set.
     */
    @java.lang.Override
    public boolean hasInt64Type() {
      return kindCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     *
     * @return The int64Type.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64 getInt64Type() {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5) {
          return (com.google.bigtable.admin.v2.Type.Int64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      } else {
        if (kindCase_ == 5) {
          return int64TypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder setInt64Type(com.google.bigtable.admin.v2.Type.Int64 value) {
      if (int64TypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        int64TypeBuilder_.setMessage(value);
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder setInt64Type(com.google.bigtable.admin.v2.Type.Int64.Builder builderForValue) {
      if (int64TypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        int64TypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder mergeInt64Type(com.google.bigtable.admin.v2.Type.Int64 value) {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5
            && kind_ != com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Int64.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Int64) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 5) {
          int64TypeBuilder_.mergeFrom(value);
        } else {
          int64TypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public Builder clearInt64Type() {
      if (int64TypeBuilder_ == null) {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
        }
        int64TypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    public com.google.bigtable.admin.v2.Type.Int64.Builder getInt64TypeBuilder() {
      return getInt64TypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Int64OrBuilder getInt64TypeOrBuilder() {
      if ((kindCase_ == 5) && (int64TypeBuilder_ != null)) {
        return int64TypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 5) {
          return (com.google.bigtable.admin.v2.Type.Int64) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Int64
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Int64 int64_type = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Int64,
            com.google.bigtable.admin.v2.Type.Int64.Builder,
            com.google.bigtable.admin.v2.Type.Int64OrBuilder>
        getInt64TypeFieldBuilder() {
      if (int64TypeBuilder_ == null) {
        if (!(kindCase_ == 5)) {
          kind_ = com.google.bigtable.admin.v2.Type.Int64.getDefaultInstance();
        }
        int64TypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Int64,
                com.google.bigtable.admin.v2.Type.Int64.Builder,
                com.google.bigtable.admin.v2.Type.Int64OrBuilder>(
                (com.google.bigtable.admin.v2.Type.Int64) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 5;
      onChanged();
      return int64TypeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Aggregate,
            com.google.bigtable.admin.v2.Type.Aggregate.Builder,
            com.google.bigtable.admin.v2.Type.AggregateOrBuilder>
        aggregateTypeBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     *
     * @return Whether the aggregateType field is set.
     */
    @java.lang.Override
    public boolean hasAggregateType() {
      return kindCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     *
     * @return The aggregateType.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.Aggregate getAggregateType() {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6) {
          return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      } else {
        if (kindCase_ == 6) {
          return aggregateTypeBuilder_.getMessage();
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder setAggregateType(com.google.bigtable.admin.v2.Type.Aggregate value) {
      if (aggregateTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        aggregateTypeBuilder_.setMessage(value);
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder setAggregateType(
        com.google.bigtable.admin.v2.Type.Aggregate.Builder builderForValue) {
      if (aggregateTypeBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        aggregateTypeBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder mergeAggregateType(com.google.bigtable.admin.v2.Type.Aggregate value) {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6
            && kind_ != com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance()) {
          kind_ =
              com.google.bigtable.admin.v2.Type.Aggregate.newBuilder(
                      (com.google.bigtable.admin.v2.Type.Aggregate) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 6) {
          aggregateTypeBuilder_.mergeFrom(value);
        } else {
          aggregateTypeBuilder_.setMessage(value);
        }
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public Builder clearAggregateType() {
      if (aggregateTypeBuilder_ == null) {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
        }
        aggregateTypeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    public com.google.bigtable.admin.v2.Type.Aggregate.Builder getAggregateTypeBuilder() {
      return getAggregateTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Type.AggregateOrBuilder getAggregateTypeOrBuilder() {
      if ((kindCase_ == 6) && (aggregateTypeBuilder_ != null)) {
        return aggregateTypeBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 6) {
          return (com.google.bigtable.admin.v2.Type.Aggregate) kind_;
        }
        return com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregate
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Type.Aggregate aggregate_type = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.Type.Aggregate,
            com.google.bigtable.admin.v2.Type.Aggregate.Builder,
            com.google.bigtable.admin.v2.Type.AggregateOrBuilder>
        getAggregateTypeFieldBuilder() {
      if (aggregateTypeBuilder_ == null) {
        if (!(kindCase_ == 6)) {
          kind_ = com.google.bigtable.admin.v2.Type.Aggregate.getDefaultInstance();
        }
        aggregateTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.Type.Aggregate,
                com.google.bigtable.admin.v2.Type.Aggregate.Builder,
                com.google.bigtable.admin.v2.Type.AggregateOrBuilder>(
                (com.google.bigtable.admin.v2.Type.Aggregate) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 6;
      onChanged();
      return aggregateTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Type)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Type)
  private static final com.google.bigtable.admin.v2.Type DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Type();
  }

  public static com.google.bigtable.admin.v2.Type getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Type> PARSER =
      new com.google.protobuf.AbstractParser<Type>() {
        @java.lang.Override
        public Type parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Type> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Type> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Type getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
