/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/table.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A collection of user data indexed by row, column, and timestamp.
 * Each table is served using the resources of its parent cluster.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Table}
 */
public final class Table extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Table)
    TableOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Table.newBuilder() to construct.
  private Table(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Table() {
    name_ = "";
    granularity_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Table();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Table(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                clusterStates_ =
                    com.google.protobuf.MapField.newMapField(
                        ClusterStatesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
                  clusterStates__ =
                      input.readMessage(
                          ClusterStatesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              clusterStates_
                  .getMutableMap()
                  .put(clusterStates__.getKey(), clusterStates__.getValue());
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                columnFamilies_ =
                    com.google.protobuf.MapField.newMapField(
                        ColumnFamiliesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
                  columnFamilies__ =
                      input.readMessage(
                          ColumnFamiliesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              columnFamilies_
                  .getMutableMap()
                  .put(columnFamilies__.getKey(), columnFamilies__.getValue());
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              granularity_ = rawValue;
              break;
            }
          case 50:
            {
              com.google.bigtable.admin.v2.RestoreInfo.Builder subBuilder = null;
              if (restoreInfo_ != null) {
                subBuilder = restoreInfo_.toBuilder();
              }
              restoreInfo_ =
                  input.readMessage(
                      com.google.bigtable.admin.v2.RestoreInfo.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(restoreInfo_);
                restoreInfo_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Table_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetClusterStates();
      case 3:
        return internalGetColumnFamilies();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.TableProto
        .internal_static_google_bigtable_admin_v2_Table_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Table.class,
            com.google.bigtable.admin.v2.Table.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible timestamp granularities to use when keeping multiple versions
   * of data in a table.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Table.TimestampGranularity}
   */
  public enum TimestampGranularity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The user did not specify a granularity. Should not be returned.
     * When specified during table creation, MILLIS will be used.
     * </pre>
     *
     * <code>TIMESTAMP_GRANULARITY_UNSPECIFIED = 0;</code>
     */
    TIMESTAMP_GRANULARITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The table keeps data versioned at a granularity of 1ms.
     * </pre>
     *
     * <code>MILLIS = 1;</code>
     */
    MILLIS(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The user did not specify a granularity. Should not be returned.
     * When specified during table creation, MILLIS will be used.
     * </pre>
     *
     * <code>TIMESTAMP_GRANULARITY_UNSPECIFIED = 0;</code>
     */
    public static final int TIMESTAMP_GRANULARITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The table keeps data versioned at a granularity of 1ms.
     * </pre>
     *
     * <code>MILLIS = 1;</code>
     */
    public static final int MILLIS_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimestampGranularity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TimestampGranularity forNumber(int value) {
      switch (value) {
        case 0:
          return TIMESTAMP_GRANULARITY_UNSPECIFIED;
        case 1:
          return MILLIS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TimestampGranularity>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TimestampGranularity>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TimestampGranularity>() {
              public TimestampGranularity findValueByNumber(int number) {
                return TimestampGranularity.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Table.getDescriptor().getEnumTypes().get(0);
    }

    private static final TimestampGranularity[] VALUES = values();

    public static TimestampGranularity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TimestampGranularity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Table.TimestampGranularity)
  }

  /**
   *
   *
   * <pre>
   * Defines a view over a table's fields.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Table.View}
   */
  public enum View implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Uses the default view for each method as documented in its request.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Only populates `name`.
     * </pre>
     *
     * <code>NAME_ONLY = 1;</code>
     */
    NAME_ONLY(1),
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's schema.
     * </pre>
     *
     * <code>SCHEMA_VIEW = 2;</code>
     */
    SCHEMA_VIEW(2),
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's replication
     * state.
     * </pre>
     *
     * <code>REPLICATION_VIEW = 3;</code>
     */
    REPLICATION_VIEW(3),
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's encryption state.
     * </pre>
     *
     * <code>ENCRYPTION_VIEW = 5;</code>
     */
    ENCRYPTION_VIEW(5),
    /**
     *
     *
     * <pre>
     * Populates all fields.
     * </pre>
     *
     * <code>FULL = 4;</code>
     */
    FULL(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Uses the default view for each method as documented in its request.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int VIEW_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Only populates `name`.
     * </pre>
     *
     * <code>NAME_ONLY = 1;</code>
     */
    public static final int NAME_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's schema.
     * </pre>
     *
     * <code>SCHEMA_VIEW = 2;</code>
     */
    public static final int SCHEMA_VIEW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's replication
     * state.
     * </pre>
     *
     * <code>REPLICATION_VIEW = 3;</code>
     */
    public static final int REPLICATION_VIEW_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Only populates `name` and fields related to the table's encryption state.
     * </pre>
     *
     * <code>ENCRYPTION_VIEW = 5;</code>
     */
    public static final int ENCRYPTION_VIEW_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Populates all fields.
     * </pre>
     *
     * <code>FULL = 4;</code>
     */
    public static final int FULL_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static View valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static View forNumber(int value) {
      switch (value) {
        case 0:
          return VIEW_UNSPECIFIED;
        case 1:
          return NAME_ONLY;
        case 2:
          return SCHEMA_VIEW;
        case 3:
          return REPLICATION_VIEW;
        case 5:
          return ENCRYPTION_VIEW;
        case 4:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<View> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<View> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<View>() {
          public View findValueByNumber(int number) {
            return View.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Table.getDescriptor().getEnumTypes().get(1);
    }

    private static final View[] VALUES = values();

    public static View valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private View(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Table.View)
  }

  public interface ClusterStateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.Table.ClusterState)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The state of replication for the table in this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for replicationState.
     */
    int getReplicationStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The state of replication for the table in this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The replicationState.
     */
    com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState getReplicationState();

    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.bigtable.admin.v2.EncryptionInfo> getEncryptionInfoList();
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.bigtable.admin.v2.EncryptionInfo getEncryptionInfo(int index);
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getEncryptionInfoCount();
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
        getEncryptionInfoOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.bigtable.admin.v2.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The state of a table's data in a particular cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Table.ClusterState}
   */
  public static final class ClusterState extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Table.ClusterState)
      ClusterStateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ClusterState.newBuilder() to construct.
    private ClusterState(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ClusterState() {
      replicationState_ = 0;
      encryptionInfo_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ClusterState();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ClusterState(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                replicationState_ = rawValue;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  encryptionInfo_ =
                      new java.util.ArrayList<com.google.bigtable.admin.v2.EncryptionInfo>();
                  mutable_bitField0_ |= 0x00000001;
                }
                encryptionInfo_.add(
                    input.readMessage(
                        com.google.bigtable.admin.v2.EncryptionInfo.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          encryptionInfo_ = java.util.Collections.unmodifiableList(encryptionInfo_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Table_ClusterState_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Table_ClusterState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Table.ClusterState.class,
              com.google.bigtable.admin.v2.Table.ClusterState.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Table replication states.
     * </pre>
     *
     * Protobuf enum {@code google.bigtable.admin.v2.Table.ClusterState.ReplicationState}
     */
    public enum ReplicationState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The replication state of the table is unknown in this cluster.
       * </pre>
       *
       * <code>STATE_NOT_KNOWN = 0;</code>
       */
      STATE_NOT_KNOWN(0),
      /**
       *
       *
       * <pre>
       * The cluster was recently created, and the table must finish copying
       * over pre-existing data from other clusters before it can begin
       * receiving live replication updates and serving Data API requests.
       * </pre>
       *
       * <code>INITIALIZING = 1;</code>
       */
      INITIALIZING(1),
      /**
       *
       *
       * <pre>
       * The table is temporarily unable to serve Data API requests from this
       * cluster due to planned internal maintenance.
       * </pre>
       *
       * <code>PLANNED_MAINTENANCE = 2;</code>
       */
      PLANNED_MAINTENANCE(2),
      /**
       *
       *
       * <pre>
       * The table is temporarily unable to serve Data API requests from this
       * cluster due to unplanned or emergency maintenance.
       * </pre>
       *
       * <code>UNPLANNED_MAINTENANCE = 3;</code>
       */
      UNPLANNED_MAINTENANCE(3),
      /**
       *
       *
       * <pre>
       * The table can serve Data API requests from this cluster. Depending on
       * replication delay, reads may not immediately reflect the state of the
       * table in other clusters.
       * </pre>
       *
       * <code>READY = 4;</code>
       */
      READY(4),
      /**
       *
       *
       * <pre>
       * The table is fully created and ready for use after a restore, and is
       * being optimized for performance. When optimizations are complete, the
       * table will transition to `READY` state.
       * </pre>
       *
       * <code>READY_OPTIMIZING = 5;</code>
       */
      READY_OPTIMIZING(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The replication state of the table is unknown in this cluster.
       * </pre>
       *
       * <code>STATE_NOT_KNOWN = 0;</code>
       */
      public static final int STATE_NOT_KNOWN_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The cluster was recently created, and the table must finish copying
       * over pre-existing data from other clusters before it can begin
       * receiving live replication updates and serving Data API requests.
       * </pre>
       *
       * <code>INITIALIZING = 1;</code>
       */
      public static final int INITIALIZING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The table is temporarily unable to serve Data API requests from this
       * cluster due to planned internal maintenance.
       * </pre>
       *
       * <code>PLANNED_MAINTENANCE = 2;</code>
       */
      public static final int PLANNED_MAINTENANCE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The table is temporarily unable to serve Data API requests from this
       * cluster due to unplanned or emergency maintenance.
       * </pre>
       *
       * <code>UNPLANNED_MAINTENANCE = 3;</code>
       */
      public static final int UNPLANNED_MAINTENANCE_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The table can serve Data API requests from this cluster. Depending on
       * replication delay, reads may not immediately reflect the state of the
       * table in other clusters.
       * </pre>
       *
       * <code>READY = 4;</code>
       */
      public static final int READY_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The table is fully created and ready for use after a restore, and is
       * being optimized for performance. When optimizations are complete, the
       * table will transition to `READY` state.
       * </pre>
       *
       * <code>READY_OPTIMIZING = 5;</code>
       */
      public static final int READY_OPTIMIZING_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ReplicationState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ReplicationState forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_NOT_KNOWN;
          case 1:
            return INITIALIZING;
          case 2:
            return PLANNED_MAINTENANCE;
          case 3:
            return UNPLANNED_MAINTENANCE;
          case 4:
            return READY;
          case 5:
            return READY_OPTIMIZING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ReplicationState>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ReplicationState>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ReplicationState>() {
                public ReplicationState findValueByNumber(int number) {
                  return ReplicationState.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.bigtable.admin.v2.Table.ClusterState.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ReplicationState[] VALUES = values();

      public static ReplicationState valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ReplicationState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Table.ClusterState.ReplicationState)
    }

    public static final int REPLICATION_STATE_FIELD_NUMBER = 1;
    private int replicationState_;
    /**
     *
     *
     * <pre>
     * Output only. The state of replication for the table in this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for replicationState.
     */
    @java.lang.Override
    public int getReplicationStateValue() {
      return replicationState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of replication for the table in this cluster.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The replicationState.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState getReplicationState() {
      @SuppressWarnings("deprecation")
      com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState result =
          com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.valueOf(
              replicationState_);
      return result == null
          ? com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.UNRECOGNIZED
          : result;
    }

    public static final int ENCRYPTION_INFO_FIELD_NUMBER = 2;
    private java.util.List<com.google.bigtable.admin.v2.EncryptionInfo> encryptionInfo_;
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.admin.v2.EncryptionInfo> getEncryptionInfoList() {
      return encryptionInfo_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
        getEncryptionInfoOrBuilderList() {
      return encryptionInfo_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getEncryptionInfoCount() {
      return encryptionInfo_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfo getEncryptionInfo(int index) {
      return encryptionInfo_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the table in this cluster.
     * If the encryption key protecting this resource is customer managed, then
     * its version can be rotated in Cloud Key Management Service (Cloud KMS).
     * The primary version of the key and its status will be reflected here when
     * changes propagate from Cloud KMS.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(
        int index) {
      return encryptionInfo_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (replicationState_
          != com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.STATE_NOT_KNOWN
              .getNumber()) {
        output.writeEnum(1, replicationState_);
      }
      for (int i = 0; i < encryptionInfo_.size(); i++) {
        output.writeMessage(2, encryptionInfo_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (replicationState_
          != com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.STATE_NOT_KNOWN
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, replicationState_);
      }
      for (int i = 0; i < encryptionInfo_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, encryptionInfo_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.Table.ClusterState)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.Table.ClusterState other =
          (com.google.bigtable.admin.v2.Table.ClusterState) obj;

      if (replicationState_ != other.replicationState_) return false;
      if (!getEncryptionInfoList().equals(other.getEncryptionInfoList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REPLICATION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + replicationState_;
      if (getEncryptionInfoCount() > 0) {
        hash = (37 * hash) + ENCRYPTION_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getEncryptionInfoList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.admin.v2.Table.ClusterState prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The state of a table's data in a particular cluster.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.Table.ClusterState}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Table.ClusterState)
        com.google.bigtable.admin.v2.Table.ClusterStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_Table_ClusterState_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_Table_ClusterState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.Table.ClusterState.class,
                com.google.bigtable.admin.v2.Table.ClusterState.Builder.class);
      }

      // Construct using com.google.bigtable.admin.v2.Table.ClusterState.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEncryptionInfoFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicationState_ = 0;

        if (encryptionInfoBuilder_ == null) {
          encryptionInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          encryptionInfoBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.TableProto
            .internal_static_google_bigtable_admin_v2_Table_ClusterState_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Table.ClusterState getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.Table.ClusterState.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Table.ClusterState build() {
        com.google.bigtable.admin.v2.Table.ClusterState result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.Table.ClusterState buildPartial() {
        com.google.bigtable.admin.v2.Table.ClusterState result =
            new com.google.bigtable.admin.v2.Table.ClusterState(this);
        int from_bitField0_ = bitField0_;
        result.replicationState_ = replicationState_;
        if (encryptionInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            encryptionInfo_ = java.util.Collections.unmodifiableList(encryptionInfo_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.encryptionInfo_ = encryptionInfo_;
        } else {
          result.encryptionInfo_ = encryptionInfoBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.Table.ClusterState) {
          return mergeFrom((com.google.bigtable.admin.v2.Table.ClusterState) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.admin.v2.Table.ClusterState other) {
        if (other == com.google.bigtable.admin.v2.Table.ClusterState.getDefaultInstance())
          return this;
        if (other.replicationState_ != 0) {
          setReplicationStateValue(other.getReplicationStateValue());
        }
        if (encryptionInfoBuilder_ == null) {
          if (!other.encryptionInfo_.isEmpty()) {
            if (encryptionInfo_.isEmpty()) {
              encryptionInfo_ = other.encryptionInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEncryptionInfoIsMutable();
              encryptionInfo_.addAll(other.encryptionInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.encryptionInfo_.isEmpty()) {
            if (encryptionInfoBuilder_.isEmpty()) {
              encryptionInfoBuilder_.dispose();
              encryptionInfoBuilder_ = null;
              encryptionInfo_ = other.encryptionInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
              encryptionInfoBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEncryptionInfoFieldBuilder()
                      : null;
            } else {
              encryptionInfoBuilder_.addAllMessages(other.encryptionInfo_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.bigtable.admin.v2.Table.ClusterState parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.bigtable.admin.v2.Table.ClusterState) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicationState_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The state of replication for the table in this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for replicationState.
       */
      @java.lang.Override
      public int getReplicationStateValue() {
        return replicationState_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of replication for the table in this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for replicationState to set.
       * @return This builder for chaining.
       */
      public Builder setReplicationStateValue(int value) {

        replicationState_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of replication for the table in this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The replicationState.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState
          getReplicationState() {
        @SuppressWarnings("deprecation")
        com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState result =
            com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.valueOf(
                replicationState_);
        return result == null
            ? com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of replication for the table in this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The replicationState to set.
       * @return This builder for chaining.
       */
      public Builder setReplicationState(
          com.google.bigtable.admin.v2.Table.ClusterState.ReplicationState value) {
        if (value == null) {
          throw new NullPointerException();
        }

        replicationState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of replication for the table in this cluster.
       * </pre>
       *
       * <code>
       * .google.bigtable.admin.v2.Table.ClusterState.ReplicationState replication_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReplicationState() {

        replicationState_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.bigtable.admin.v2.EncryptionInfo> encryptionInfo_ =
          java.util.Collections.emptyList();

      private void ensureEncryptionInfoIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          encryptionInfo_ =
              new java.util.ArrayList<com.google.bigtable.admin.v2.EncryptionInfo>(encryptionInfo_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.admin.v2.EncryptionInfo,
              com.google.bigtable.admin.v2.EncryptionInfo.Builder,
              com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
          encryptionInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.bigtable.admin.v2.EncryptionInfo> getEncryptionInfoList() {
        if (encryptionInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(encryptionInfo_);
        } else {
          return encryptionInfoBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getEncryptionInfoCount() {
        if (encryptionInfoBuilder_ == null) {
          return encryptionInfo_.size();
        } else {
          return encryptionInfoBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.EncryptionInfo getEncryptionInfo(int index) {
        if (encryptionInfoBuilder_ == null) {
          return encryptionInfo_.get(index);
        } else {
          return encryptionInfoBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setEncryptionInfo(
          int index, com.google.bigtable.admin.v2.EncryptionInfo value) {
        if (encryptionInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.set(index, value);
          onChanged();
        } else {
          encryptionInfoBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setEncryptionInfo(
          int index, com.google.bigtable.admin.v2.EncryptionInfo.Builder builderForValue) {
        if (encryptionInfoBuilder_ == null) {
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          encryptionInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addEncryptionInfo(com.google.bigtable.admin.v2.EncryptionInfo value) {
        if (encryptionInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.add(value);
          onChanged();
        } else {
          encryptionInfoBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addEncryptionInfo(
          int index, com.google.bigtable.admin.v2.EncryptionInfo value) {
        if (encryptionInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.add(index, value);
          onChanged();
        } else {
          encryptionInfoBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addEncryptionInfo(
          com.google.bigtable.admin.v2.EncryptionInfo.Builder builderForValue) {
        if (encryptionInfoBuilder_ == null) {
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.add(builderForValue.build());
          onChanged();
        } else {
          encryptionInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addEncryptionInfo(
          int index, com.google.bigtable.admin.v2.EncryptionInfo.Builder builderForValue) {
        if (encryptionInfoBuilder_ == null) {
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          encryptionInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllEncryptionInfo(
          java.lang.Iterable<? extends com.google.bigtable.admin.v2.EncryptionInfo> values) {
        if (encryptionInfoBuilder_ == null) {
          ensureEncryptionInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, encryptionInfo_);
          onChanged();
        } else {
          encryptionInfoBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearEncryptionInfo() {
        if (encryptionInfoBuilder_ == null) {
          encryptionInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          encryptionInfoBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeEncryptionInfo(int index) {
        if (encryptionInfoBuilder_ == null) {
          ensureEncryptionInfoIsMutable();
          encryptionInfo_.remove(index);
          onChanged();
        } else {
          encryptionInfoBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.EncryptionInfo.Builder getEncryptionInfoBuilder(
          int index) {
        return getEncryptionInfoFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(
          int index) {
        if (encryptionInfoBuilder_ == null) {
          return encryptionInfo_.get(index);
        } else {
          return encryptionInfoBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<? extends com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
          getEncryptionInfoOrBuilderList() {
        if (encryptionInfoBuilder_ != null) {
          return encryptionInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(encryptionInfo_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.EncryptionInfo.Builder addEncryptionInfoBuilder() {
        return getEncryptionInfoFieldBuilder()
            .addBuilder(com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.bigtable.admin.v2.EncryptionInfo.Builder addEncryptionInfoBuilder(
          int index) {
        return getEncryptionInfoFieldBuilder()
            .addBuilder(index, com.google.bigtable.admin.v2.EncryptionInfo.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The encryption information for the table in this cluster.
       * If the encryption key protecting this resource is customer managed, then
       * its version can be rotated in Cloud Key Management Service (Cloud KMS).
       * The primary version of the key and its status will be reflected here when
       * changes propagate from Cloud KMS.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.admin.v2.EncryptionInfo encryption_info = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.bigtable.admin.v2.EncryptionInfo.Builder>
          getEncryptionInfoBuilderList() {
        return getEncryptionInfoFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.admin.v2.EncryptionInfo,
              com.google.bigtable.admin.v2.EncryptionInfo.Builder,
              com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>
          getEncryptionInfoFieldBuilder() {
        if (encryptionInfoBuilder_ == null) {
          encryptionInfoBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.admin.v2.EncryptionInfo,
                  com.google.bigtable.admin.v2.EncryptionInfo.Builder,
                  com.google.bigtable.admin.v2.EncryptionInfoOrBuilder>(
                  encryptionInfo_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          encryptionInfo_ = null;
        }
        return encryptionInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Table.ClusterState)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Table.ClusterState)
    private static final com.google.bigtable.admin.v2.Table.ClusterState DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Table.ClusterState();
    }

    public static com.google.bigtable.admin.v2.Table.ClusterState getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ClusterState> PARSER =
        new com.google.protobuf.AbstractParser<ClusterState>() {
          @java.lang.Override
          public ClusterState parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ClusterState(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ClusterState> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ClusterState> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Table.ClusterState getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique name of the table. Values are of the form
   * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
   * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique name of the table. Values are of the form
   * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
   * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLUSTER_STATES_FIELD_NUMBER = 2;

  private static final class ClusterStatesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
                    newDefaultInstance(
                        com.google.bigtable.admin.v2.TableProto
                            .internal_static_google_bigtable_admin_v2_Table_ClusterStatesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.bigtable.admin.v2.Table.ClusterState.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
      clusterStates_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
      internalGetClusterStates() {
    if (clusterStates_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ClusterStatesDefaultEntryHolder.defaultEntry);
    }
    return clusterStates_;
  }

  public int getClusterStatesCount() {
    return internalGetClusterStates().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from cluster ID to per-cluster table state.
   * If it could not be determined whether or not the table has data in a
   * particular cluster (for example, if its zone is unavailable), then
   * there will be an entry for the cluster with UNKNOWN `replication_status`.
   * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsClusterStates(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetClusterStates().getMap().containsKey(key);
  }
  /** Use {@link #getClusterStatesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
      getClusterStates() {
    return getClusterStatesMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from cluster ID to per-cluster table state.
   * If it could not be determined whether or not the table has data in a
   * particular cluster (for example, if its zone is unavailable), then
   * there will be an entry for the cluster with UNKNOWN `replication_status`.
   * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
      getClusterStatesMap() {
    return internalGetClusterStates().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from cluster ID to per-cluster table state.
   * If it could not be determined whether or not the table has data in a
   * particular cluster (for example, if its zone is unavailable), then
   * there will be an entry for the cluster with UNKNOWN `replication_status`.
   * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Table.ClusterState getClusterStatesOrDefault(
      java.lang.String key, com.google.bigtable.admin.v2.Table.ClusterState defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState> map =
        internalGetClusterStates().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from cluster ID to per-cluster table state.
   * If it could not be determined whether or not the table has data in a
   * particular cluster (for example, if its zone is unavailable), then
   * there will be an entry for the cluster with UNKNOWN `replication_status`.
   * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Table.ClusterState getClusterStatesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState> map =
        internalGetClusterStates().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int COLUMN_FAMILIES_FIELD_NUMBER = 3;

  private static final class ColumnFamiliesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>newDefaultInstance(
                    com.google.bigtable.admin.v2.TableProto
                        .internal_static_google_bigtable_admin_v2_Table_ColumnFamiliesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.bigtable.admin.v2.ColumnFamily.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
      columnFamilies_;

  private com.google.protobuf.MapField<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
      internalGetColumnFamilies() {
    if (columnFamilies_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ColumnFamiliesDefaultEntryHolder.defaultEntry);
    }
    return columnFamilies_;
  }

  public int getColumnFamiliesCount() {
    return internalGetColumnFamilies().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The column families configured for this table, mapped by column family ID.
   * Views: `SCHEMA_VIEW`, `FULL`
   * </pre>
   *
   * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
   */
  @java.lang.Override
  public boolean containsColumnFamilies(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetColumnFamilies().getMap().containsKey(key);
  }
  /** Use {@link #getColumnFamiliesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
      getColumnFamilies() {
    return getColumnFamiliesMap();
  }
  /**
   *
   *
   * <pre>
   * The column families configured for this table, mapped by column family ID.
   * Views: `SCHEMA_VIEW`, `FULL`
   * </pre>
   *
   * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
      getColumnFamiliesMap() {
    return internalGetColumnFamilies().getMap();
  }
  /**
   *
   *
   * <pre>
   * The column families configured for this table, mapped by column family ID.
   * Views: `SCHEMA_VIEW`, `FULL`
   * </pre>
   *
   * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.ColumnFamily getColumnFamiliesOrDefault(
      java.lang.String key, com.google.bigtable.admin.v2.ColumnFamily defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> map =
        internalGetColumnFamilies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The column families configured for this table, mapped by column family ID.
   * Views: `SCHEMA_VIEW`, `FULL`
   * </pre>
   *
   * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.ColumnFamily getColumnFamiliesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> map =
        internalGetColumnFamilies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int GRANULARITY_FIELD_NUMBER = 4;
  private int granularity_;
  /**
   *
   *
   * <pre>
   * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
   * table. Timestamps not matching the granularity will be rejected.
   * If unspecified at creation time, the value will be set to `MILLIS`.
   * Views: `SCHEMA_VIEW`, `FULL`.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for granularity.
   */
  @java.lang.Override
  public int getGranularityValue() {
    return granularity_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
   * table. Timestamps not matching the granularity will be rejected.
   * If unspecified at creation time, the value will be set to `MILLIS`.
   * Views: `SCHEMA_VIEW`, `FULL`.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The granularity.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.Table.TimestampGranularity getGranularity() {
    @SuppressWarnings("deprecation")
    com.google.bigtable.admin.v2.Table.TimestampGranularity result =
        com.google.bigtable.admin.v2.Table.TimestampGranularity.valueOf(granularity_);
    return result == null
        ? com.google.bigtable.admin.v2.Table.TimestampGranularity.UNRECOGNIZED
        : result;
  }

  public static final int RESTORE_INFO_FIELD_NUMBER = 6;
  private com.google.bigtable.admin.v2.RestoreInfo restoreInfo_;
  /**
   *
   *
   * <pre>
   * Output only. If this table was restored from another data source (e.g. a backup), this
   * field will be populated with information about the restore.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the restoreInfo field is set.
   */
  @java.lang.Override
  public boolean hasRestoreInfo() {
    return restoreInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. If this table was restored from another data source (e.g. a backup), this
   * field will be populated with information about the restore.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The restoreInfo.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.RestoreInfo getRestoreInfo() {
    return restoreInfo_ == null
        ? com.google.bigtable.admin.v2.RestoreInfo.getDefaultInstance()
        : restoreInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If this table was restored from another data source (e.g. a backup), this
   * field will be populated with information about the restore.
   * </pre>
   *
   * <code>
   * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
    return getRestoreInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetClusterStates(), ClusterStatesDefaultEntryHolder.defaultEntry, 2);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetColumnFamilies(), ColumnFamiliesDefaultEntryHolder.defaultEntry, 3);
    if (granularity_
        != com.google.bigtable.admin.v2.Table.TimestampGranularity.TIMESTAMP_GRANULARITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, granularity_);
    }
    if (restoreInfo_ != null) {
      output.writeMessage(6, getRestoreInfo());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        entry : internalGetClusterStates().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
          clusterStates__ =
              ClusterStatesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, clusterStates__);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> entry :
        internalGetColumnFamilies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
          columnFamilies__ =
              ColumnFamiliesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, columnFamilies__);
    }
    if (granularity_
        != com.google.bigtable.admin.v2.Table.TimestampGranularity.TIMESTAMP_GRANULARITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, granularity_);
    }
    if (restoreInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRestoreInfo());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Table)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Table other = (com.google.bigtable.admin.v2.Table) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetClusterStates().equals(other.internalGetClusterStates())) return false;
    if (!internalGetColumnFamilies().equals(other.internalGetColumnFamilies())) return false;
    if (granularity_ != other.granularity_) return false;
    if (hasRestoreInfo() != other.hasRestoreInfo()) return false;
    if (hasRestoreInfo()) {
      if (!getRestoreInfo().equals(other.getRestoreInfo())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetClusterStates().getMap().isEmpty()) {
      hash = (37 * hash) + CLUSTER_STATES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetClusterStates().hashCode();
    }
    if (!internalGetColumnFamilies().getMap().isEmpty()) {
      hash = (37 * hash) + COLUMN_FAMILIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetColumnFamilies().hashCode();
    }
    hash = (37 * hash) + GRANULARITY_FIELD_NUMBER;
    hash = (53 * hash) + granularity_;
    if (hasRestoreInfo()) {
      hash = (37 * hash) + RESTORE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getRestoreInfo().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Table parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Table parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Table parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Table prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of user data indexed by row, column, and timestamp.
   * Each table is served using the resources of its parent cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Table}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Table)
      com.google.bigtable.admin.v2.TableOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Table_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetClusterStates();
        case 3:
          return internalGetColumnFamilies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableClusterStates();
        case 3:
          return internalGetMutableColumnFamilies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Table_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Table.class,
              com.google.bigtable.admin.v2.Table.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Table.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      internalGetMutableClusterStates().clear();
      internalGetMutableColumnFamilies().clear();
      granularity_ = 0;

      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = null;
      } else {
        restoreInfo_ = null;
        restoreInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.TableProto
          .internal_static_google_bigtable_admin_v2_Table_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Table getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Table.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Table build() {
      com.google.bigtable.admin.v2.Table result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Table buildPartial() {
      com.google.bigtable.admin.v2.Table result = new com.google.bigtable.admin.v2.Table(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.clusterStates_ = internalGetClusterStates();
      result.clusterStates_.makeImmutable();
      result.columnFamilies_ = internalGetColumnFamilies();
      result.columnFamilies_.makeImmutable();
      result.granularity_ = granularity_;
      if (restoreInfoBuilder_ == null) {
        result.restoreInfo_ = restoreInfo_;
      } else {
        result.restoreInfo_ = restoreInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Table) {
        return mergeFrom((com.google.bigtable.admin.v2.Table) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Table other) {
      if (other == com.google.bigtable.admin.v2.Table.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      internalGetMutableClusterStates().mergeFrom(other.internalGetClusterStates());
      internalGetMutableColumnFamilies().mergeFrom(other.internalGetColumnFamilies());
      if (other.granularity_ != 0) {
        setGranularityValue(other.getGranularityValue());
      }
      if (other.hasRestoreInfo()) {
        mergeRestoreInfo(other.getRestoreInfo());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.admin.v2.Table parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.admin.v2.Table) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique name of the table. Values are of the form
     * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the table. Values are of the form
     * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique name of the table. Values are of the form
     * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the table. Values are of the form
     * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique name of the table. Values are of the form
     * `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
     * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        clusterStates_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        internalGetClusterStates() {
      if (clusterStates_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ClusterStatesDefaultEntryHolder.defaultEntry);
      }
      return clusterStates_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        internalGetMutableClusterStates() {
      onChanged();
      ;
      if (clusterStates_ == null) {
        clusterStates_ =
            com.google.protobuf.MapField.newMapField(ClusterStatesDefaultEntryHolder.defaultEntry);
      }
      if (!clusterStates_.isMutable()) {
        clusterStates_ = clusterStates_.copy();
      }
      return clusterStates_;
    }

    public int getClusterStatesCount() {
      return internalGetClusterStates().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsClusterStates(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetClusterStates().getMap().containsKey(key);
    }
    /** Use {@link #getClusterStatesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        getClusterStates() {
      return getClusterStatesMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        getClusterStatesMap() {
      return internalGetClusterStates().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Table.ClusterState getClusterStatesOrDefault(
        java.lang.String key, com.google.bigtable.admin.v2.Table.ClusterState defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState> map =
          internalGetClusterStates().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Table.ClusterState getClusterStatesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState> map =
          internalGetClusterStates().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearClusterStates() {
      internalGetMutableClusterStates().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeClusterStates(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableClusterStates().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState>
        getMutableClusterStates() {
      return internalGetMutableClusterStates().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putClusterStates(
        java.lang.String key, com.google.bigtable.admin.v2.Table.ClusterState value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableClusterStates().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from cluster ID to per-cluster table state.
     * If it could not be determined whether or not the table has data in a
     * particular cluster (for example, if its zone is unavailable), then
     * there will be an entry for the cluster with UNKNOWN `replication_status`.
     * Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.Table.ClusterState&gt; cluster_states = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllClusterStates(
        java.util.Map<java.lang.String, com.google.bigtable.admin.v2.Table.ClusterState> values) {
      internalGetMutableClusterStates().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        columnFamilies_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        internalGetColumnFamilies() {
      if (columnFamilies_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ColumnFamiliesDefaultEntryHolder.defaultEntry);
      }
      return columnFamilies_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        internalGetMutableColumnFamilies() {
      onChanged();
      ;
      if (columnFamilies_ == null) {
        columnFamilies_ =
            com.google.protobuf.MapField.newMapField(ColumnFamiliesDefaultEntryHolder.defaultEntry);
      }
      if (!columnFamilies_.isMutable()) {
        columnFamilies_ = columnFamilies_.copy();
      }
      return columnFamilies_;
    }

    public int getColumnFamiliesCount() {
      return internalGetColumnFamilies().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    @java.lang.Override
    public boolean containsColumnFamilies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetColumnFamilies().getMap().containsKey(key);
    }
    /** Use {@link #getColumnFamiliesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        getColumnFamilies() {
      return getColumnFamiliesMap();
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        getColumnFamiliesMap() {
      return internalGetColumnFamilies().getMap();
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamily getColumnFamiliesOrDefault(
        java.lang.String key, com.google.bigtable.admin.v2.ColumnFamily defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> map =
          internalGetColumnFamilies().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.ColumnFamily getColumnFamiliesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> map =
          internalGetColumnFamilies().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearColumnFamilies() {
      internalGetMutableColumnFamilies().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    public Builder removeColumnFamilies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableColumnFamilies().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily>
        getMutableColumnFamilies() {
      return internalGetMutableColumnFamilies().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    public Builder putColumnFamilies(
        java.lang.String key, com.google.bigtable.admin.v2.ColumnFamily value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableColumnFamilies().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The column families configured for this table, mapped by column family ID.
     * Views: `SCHEMA_VIEW`, `FULL`
     * </pre>
     *
     * <code>map&lt;string, .google.bigtable.admin.v2.ColumnFamily&gt; column_families = 3;</code>
     */
    public Builder putAllColumnFamilies(
        java.util.Map<java.lang.String, com.google.bigtable.admin.v2.ColumnFamily> values) {
      internalGetMutableColumnFamilies().getMutableMap().putAll(values);
      return this;
    }

    private int granularity_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
     * table. Timestamps not matching the granularity will be rejected.
     * If unspecified at creation time, the value will be set to `MILLIS`.
     * Views: `SCHEMA_VIEW`, `FULL`.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for granularity.
     */
    @java.lang.Override
    public int getGranularityValue() {
      return granularity_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
     * table. Timestamps not matching the granularity will be rejected.
     * If unspecified at creation time, the value will be set to `MILLIS`.
     * Views: `SCHEMA_VIEW`, `FULL`.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for granularity to set.
     * @return This builder for chaining.
     */
    public Builder setGranularityValue(int value) {

      granularity_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
     * table. Timestamps not matching the granularity will be rejected.
     * If unspecified at creation time, the value will be set to `MILLIS`.
     * Views: `SCHEMA_VIEW`, `FULL`.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The granularity.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.Table.TimestampGranularity getGranularity() {
      @SuppressWarnings("deprecation")
      com.google.bigtable.admin.v2.Table.TimestampGranularity result =
          com.google.bigtable.admin.v2.Table.TimestampGranularity.valueOf(granularity_);
      return result == null
          ? com.google.bigtable.admin.v2.Table.TimestampGranularity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
     * table. Timestamps not matching the granularity will be rejected.
     * If unspecified at creation time, the value will be set to `MILLIS`.
     * Views: `SCHEMA_VIEW`, `FULL`.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The granularity to set.
     * @return This builder for chaining.
     */
    public Builder setGranularity(com.google.bigtable.admin.v2.Table.TimestampGranularity value) {
      if (value == null) {
        throw new NullPointerException();
      }

      granularity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored in this
     * table. Timestamps not matching the granularity will be rejected.
     * If unspecified at creation time, the value will be set to `MILLIS`.
     * Views: `SCHEMA_VIEW`, `FULL`.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.Table.TimestampGranularity granularity = 4 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGranularity() {

      granularity_ = 0;
      onChanged();
      return this;
    }

    private com.google.bigtable.admin.v2.RestoreInfo restoreInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.RestoreInfo,
            com.google.bigtable.admin.v2.RestoreInfo.Builder,
            com.google.bigtable.admin.v2.RestoreInfoOrBuilder>
        restoreInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the restoreInfo field is set.
     */
    public boolean hasRestoreInfo() {
      return restoreInfoBuilder_ != null || restoreInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The restoreInfo.
     */
    public com.google.bigtable.admin.v2.RestoreInfo getRestoreInfo() {
      if (restoreInfoBuilder_ == null) {
        return restoreInfo_ == null
            ? com.google.bigtable.admin.v2.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      } else {
        return restoreInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(com.google.bigtable.admin.v2.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        restoreInfo_ = value;
        onChanged();
      } else {
        restoreInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(
        com.google.bigtable.admin.v2.RestoreInfo.Builder builderForValue) {
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = builderForValue.build();
        onChanged();
      } else {
        restoreInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRestoreInfo(com.google.bigtable.admin.v2.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (restoreInfo_ != null) {
          restoreInfo_ =
              com.google.bigtable.admin.v2.RestoreInfo.newBuilder(restoreInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          restoreInfo_ = value;
        }
        onChanged();
      } else {
        restoreInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRestoreInfo() {
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = null;
        onChanged();
      } else {
        restoreInfo_ = null;
        restoreInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.bigtable.admin.v2.RestoreInfo.Builder getRestoreInfoBuilder() {

      onChanged();
      return getRestoreInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.bigtable.admin.v2.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
      if (restoreInfoBuilder_ != null) {
        return restoreInfoBuilder_.getMessageOrBuilder();
      } else {
        return restoreInfo_ == null
            ? com.google.bigtable.admin.v2.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If this table was restored from another data source (e.g. a backup), this
     * field will be populated with information about the restore.
     * </pre>
     *
     * <code>
     * .google.bigtable.admin.v2.RestoreInfo restore_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.RestoreInfo,
            com.google.bigtable.admin.v2.RestoreInfo.Builder,
            com.google.bigtable.admin.v2.RestoreInfoOrBuilder>
        getRestoreInfoFieldBuilder() {
      if (restoreInfoBuilder_ == null) {
        restoreInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.RestoreInfo,
                com.google.bigtable.admin.v2.RestoreInfo.Builder,
                com.google.bigtable.admin.v2.RestoreInfoOrBuilder>(
                getRestoreInfo(), getParentForChildren(), isClean());
        restoreInfo_ = null;
      }
      return restoreInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Table)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Table)
  private static final com.google.bigtable.admin.v2.Table DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Table();
  }

  public static com.google.bigtable.admin.v2.Table getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Table> PARSER =
      new com.google.protobuf.AbstractParser<Table>() {
        @java.lang.Override
        public Table parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Table(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Table> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Table> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Table getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
