/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.bigtable.v2.TableNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class TableName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/tables/{table}");
    private final String project;
    private final String instance;
    private final String table;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getTable() {
        return this.table;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TableName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
    }

    public static TableName create(String project, String instance, String table) {
        return TableName.newBuilder().setProject(project).setInstance(instance).setTable(table).build();
    }

    public static TableName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TableName.parse: formattedString not in valid format");
        return TableName.create((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("table"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return TableNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "table", this.table});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TableName) {
            TableName that = (TableName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.table.equals(that.table);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        return h ^= this.table.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String table;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getTable() {
            return this.table;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        private Builder() {
        }

        private Builder(TableName tableName) {
            this.project = tableName.project;
            this.instance = tableName.instance;
            this.table = tableName.table;
        }

        public TableName build() {
            return new TableName(this);
        }
    }
}

