/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/data.proto

// Protobuf Java Version: 3.25.2
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * `Value` represents a dynamically typed value.
 * The typed fields in `Value` are used as a transport encoding for the actual
 * value (which may be of a more complex type). See the documentation of the
 * `Type` message for more details.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.Value}
 */
public final class Value extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.Value)
    ValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Value.newBuilder() to construct.
  private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Value() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Value();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.DataProto.internal_static_google_bigtable_v2_Value_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.DataProto
        .internal_static_google_bigtable_v2_Value_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.Value.class, com.google.bigtable.v2.Value.Builder.class);
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RAW_VALUE(8),
    RAW_TIMESTAMP_MICROS(9),
    INT_VALUE(6),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 8:
          return RAW_VALUE;
        case 9:
          return RAW_TIMESTAMP_MICROS;
        case 6:
          return INT_VALUE;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int RAW_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Represents a raw byte sequence with no type information.
   * The `type` field must be omitted.
   * </pre>
   *
   * <code>bytes raw_value = 8;</code>
   *
   * @return Whether the rawValue field is set.
   */
  @java.lang.Override
  public boolean hasRawValue() {
    return kindCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Represents a raw byte sequence with no type information.
   * The `type` field must be omitted.
   * </pre>
   *
   * <code>bytes raw_value = 8;</code>
   *
   * @return The rawValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRawValue() {
    if (kindCase_ == 8) {
      return (com.google.protobuf.ByteString) kind_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int RAW_TIMESTAMP_MICROS_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Represents a raw cell timestamp with no type information.
   * The `type` field must be omitted.
   * </pre>
   *
   * <code>int64 raw_timestamp_micros = 9;</code>
   *
   * @return Whether the rawTimestampMicros field is set.
   */
  @java.lang.Override
  public boolean hasRawTimestampMicros() {
    return kindCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Represents a raw cell timestamp with no type information.
   * The `type` field must be omitted.
   * </pre>
   *
   * <code>int64 raw_timestamp_micros = 9;</code>
   *
   * @return The rawTimestampMicros.
   */
  @java.lang.Override
  public long getRawTimestampMicros() {
    if (kindCase_ == 9) {
      return (java.lang.Long) kind_;
    }
    return 0L;
  }

  public static final int INT_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Represents a typed value transported as an integer.
   * Default type for writes: `Int64`
   * </pre>
   *
   * <code>int64 int_value = 6;</code>
   *
   * @return Whether the intValue field is set.
   */
  @java.lang.Override
  public boolean hasIntValue() {
    return kindCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Represents a typed value transported as an integer.
   * Default type for writes: `Int64`
   * </pre>
   *
   * <code>int64 int_value = 6;</code>
   *
   * @return The intValue.
   */
  @java.lang.Override
  public long getIntValue() {
    if (kindCase_ == 6) {
      return (java.lang.Long) kind_;
    }
    return 0L;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (kindCase_ == 6) {
      output.writeInt64(6, (long) ((java.lang.Long) kind_));
    }
    if (kindCase_ == 8) {
      output.writeBytes(8, (com.google.protobuf.ByteString) kind_);
    }
    if (kindCase_ == 9) {
      output.writeInt64(9, (long) ((java.lang.Long) kind_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (kindCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              6, (long) ((java.lang.Long) kind_));
    }
    if (kindCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              8, (com.google.protobuf.ByteString) kind_);
    }
    if (kindCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              9, (long) ((java.lang.Long) kind_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.Value)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.Value other = (com.google.bigtable.v2.Value) obj;

    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 8:
        if (!getRawValue().equals(other.getRawValue())) return false;
        break;
      case 9:
        if (getRawTimestampMicros() != other.getRawTimestampMicros()) return false;
        break;
      case 6:
        if (getIntValue() != other.getIntValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (kindCase_) {
      case 8:
        hash = (37 * hash) + RAW_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getRawValue().hashCode();
        break;
      case 9:
        hash = (37 * hash) + RAW_TIMESTAMP_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRawTimestampMicros());
        break;
      case 6:
        hash = (37 * hash) + INT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIntValue());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.Value parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Value parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Value parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Value parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Value parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Value parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Value parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Value parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.Value parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Value parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.Value parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Value parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.Value prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Value` represents a dynamically typed value.
   * The typed fields in `Value` are used as a transport encoding for the actual
   * value (which may be of a more complex type). See the documentation of the
   * `Type` message for more details.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Value}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Value)
      com.google.bigtable.v2.ValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto.internal_static_google_bigtable_v2_Value_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Value_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Value.class, com.google.bigtable.v2.Value.Builder.class);
    }

    // Construct using com.google.bigtable.v2.Value.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.DataProto.internal_static_google_bigtable_v2_Value_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Value getDefaultInstanceForType() {
      return com.google.bigtable.v2.Value.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.Value build() {
      com.google.bigtable.v2.Value result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Value buildPartial() {
      com.google.bigtable.v2.Value result = new com.google.bigtable.v2.Value(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.Value result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.v2.Value result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.Value) {
        return mergeFrom((com.google.bigtable.v2.Value) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.Value other) {
      if (other == com.google.bigtable.v2.Value.getDefaultInstance()) return this;
      switch (other.getKindCase()) {
        case RAW_VALUE:
          {
            setRawValue(other.getRawValue());
            break;
          }
        case RAW_TIMESTAMP_MICROS:
          {
            setRawTimestampMicros(other.getRawTimestampMicros());
            break;
          }
        case INT_VALUE:
          {
            setIntValue(other.getIntValue());
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 48:
              {
                kind_ = input.readInt64();
                kindCase_ = 6;
                break;
              } // case 48
            case 66:
              {
                kind_ = input.readBytes();
                kindCase_ = 8;
                break;
              } // case 66
            case 72:
              {
                kind_ = input.readInt64();
                kindCase_ = 9;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Represents a raw byte sequence with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>bytes raw_value = 8;</code>
     *
     * @return Whether the rawValue field is set.
     */
    public boolean hasRawValue() {
      return kindCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw byte sequence with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>bytes raw_value = 8;</code>
     *
     * @return The rawValue.
     */
    public com.google.protobuf.ByteString getRawValue() {
      if (kindCase_ == 8) {
        return (com.google.protobuf.ByteString) kind_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw byte sequence with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>bytes raw_value = 8;</code>
     *
     * @param value The rawValue to set.
     * @return This builder for chaining.
     */
    public Builder setRawValue(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 8;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw byte sequence with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>bytes raw_value = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawValue() {
      if (kindCase_ == 8) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Represents a raw cell timestamp with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>int64 raw_timestamp_micros = 9;</code>
     *
     * @return Whether the rawTimestampMicros field is set.
     */
    public boolean hasRawTimestampMicros() {
      return kindCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw cell timestamp with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>int64 raw_timestamp_micros = 9;</code>
     *
     * @return The rawTimestampMicros.
     */
    public long getRawTimestampMicros() {
      if (kindCase_ == 9) {
        return (java.lang.Long) kind_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw cell timestamp with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>int64 raw_timestamp_micros = 9;</code>
     *
     * @param value The rawTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setRawTimestampMicros(long value) {

      kindCase_ = 9;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a raw cell timestamp with no type information.
     * The `type` field must be omitted.
     * </pre>
     *
     * <code>int64 raw_timestamp_micros = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawTimestampMicros() {
      if (kindCase_ == 9) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Represents a typed value transported as an integer.
     * Default type for writes: `Int64`
     * </pre>
     *
     * <code>int64 int_value = 6;</code>
     *
     * @return Whether the intValue field is set.
     */
    public boolean hasIntValue() {
      return kindCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Represents a typed value transported as an integer.
     * Default type for writes: `Int64`
     * </pre>
     *
     * <code>int64 int_value = 6;</code>
     *
     * @return The intValue.
     */
    public long getIntValue() {
      if (kindCase_ == 6) {
        return (java.lang.Long) kind_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Represents a typed value transported as an integer.
     * Default type for writes: `Int64`
     * </pre>
     *
     * <code>int64 int_value = 6;</code>
     *
     * @param value The intValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntValue(long value) {

      kindCase_ = 6;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Represents a typed value transported as an integer.
     * Default type for writes: `Int64`
     * </pre>
     *
     * <code>int64 int_value = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntValue() {
      if (kindCase_ == 6) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Value)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.Value)
  private static final com.google.bigtable.v2.Value DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.Value();
  }

  public static com.google.bigtable.v2.Value getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Value> PARSER =
      new com.google.protobuf.AbstractParser<Value>() {
        @java.lang.Override
        public Value parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Value> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Value> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.Value getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
