/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BillingAccountName
implements ResourceName {
    private static final PathTemplate BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}");
    private static final PathTemplate ORGANIZATION_BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/billingAccounts/{billing_account}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String billingAccount;
    private final String organization;

    @Deprecated
    protected BillingAccountName() {
        this.billingAccount = null;
        this.organization = null;
    }

    private BillingAccountName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.organization = null;
        this.pathTemplate = BILLING_ACCOUNT;
    }

    private BillingAccountName(OrganizationBillingAccountBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.pathTemplate = ORGANIZATION_BILLING_ACCOUNT;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newBillingAccountBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationBillingAccountBuilder newOrganizationBillingAccountBuilder() {
        return new OrganizationBillingAccountBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BillingAccountName of(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BillingAccountName ofBillingAccountName(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BillingAccountName ofOrganizationBillingAccountName(String organization, String billingAccount) {
        return BillingAccountName.newOrganizationBillingAccountBuilder().setOrganization(organization).setBillingAccount(billingAccount).build();
    }

    public static String format(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountName(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationBillingAccountName(String organization, String billingAccount) {
        return BillingAccountName.newOrganizationBillingAccountBuilder().setOrganization(organization).setBillingAccount(billingAccount).build().toString();
    }

    public static BillingAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (BILLING_ACCOUNT.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT.match(formattedString);
            return BillingAccountName.ofBillingAccountName((String)matchMap.get("billing_account"));
        }
        if (ORGANIZATION_BILLING_ACCOUNT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_BILLING_ACCOUNT.match(formattedString);
            return BillingAccountName.ofOrganizationBillingAccountName((String)matchMap.get("organization"), (String)matchMap.get("billing_account"));
        }
        throw new ValidationException("BillingAccountName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BillingAccountName> parseList(List<String> formattedStrings) {
        ArrayList<BillingAccountName> list = new ArrayList<BillingAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return BILLING_ACCOUNT.matches(formattedString) || ORGANIZATION_BILLING_ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingAccountName billingAccountName = this;
            synchronized (billingAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BillingAccountName that = (BillingAccountName)o;
            return Objects.equals(this.billingAccount, that.billingAccount) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.billingAccount);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationBillingAccountBuilder {
        private String organization;
        private String billingAccount;

        protected OrganizationBillingAccountBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public OrganizationBillingAccountBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationBillingAccountBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountName build() {
            return new BillingAccountName(this);
        }
    }

    public static class Builder {
        private String billingAccount;

        protected Builder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        private Builder(BillingAccountName billingAccountName) {
            Preconditions.checkArgument((boolean)Objects.equals(billingAccountName.pathTemplate, BILLING_ACCOUNT), (Object)"toBuilder is only supported when BillingAccountName has the pattern of billingAccounts/{billing_account}");
            this.billingAccount = billingAccountName.billingAccount;
        }

        public BillingAccountName build() {
            return new BillingAccountName(this);
        }
    }
}

