/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/v1/cloud_catalog.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.billing.v1;

/**
 *
 *
 * <pre>
 * Expresses a mathematical pricing formula. For Example:-
 *
 * `usage_unit: GBy`
 * `tiered_rates:`
 *    `[start_usage_amount: 20, unit_price: $10]`
 *    `[start_usage_amount: 100, unit_price: $5]`
 *
 * The above expresses a pricing formula where the first 20GB is free, the
 * next 80GB is priced at $10 per GB followed by $5 per GB for additional
 * usage.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.v1.PricingExpression}
 */
public final class PricingExpression extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.v1.PricingExpression)
    PricingExpressionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PricingExpression.newBuilder() to construct.
  private PricingExpression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PricingExpression() {
    usageUnit_ = "";
    tieredRates_ = java.util.Collections.emptyList();
    usageUnitDescription_ = "";
    baseUnit_ = "";
    baseUnitDescription_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PricingExpression();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_PricingExpression_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_PricingExpression_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.v1.PricingExpression.class,
            com.google.cloud.billing.v1.PricingExpression.Builder.class);
  }

  public interface TierRateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.billing.v1.PricingExpression.TierRate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Usage is priced at this rate only after this amount.
     * Example: start_usage_amount of 10 indicates that the usage will be priced
     * at the unit_price after the first 10 usage_units.
     * </pre>
     *
     * <code>double start_usage_amount = 1;</code>
     *
     * @return The startUsageAmount.
     */
    double getStartUsageAmount();

    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     *
     * @return Whether the unitPrice field is set.
     */
    boolean hasUnitPrice();
    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     *
     * @return The unitPrice.
     */
    com.google.type.Money getUnitPrice();
    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     */
    com.google.type.MoneyOrBuilder getUnitPriceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The price rate indicating starting usage and its corresponding price.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.v1.PricingExpression.TierRate}
   */
  public static final class TierRate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.billing.v1.PricingExpression.TierRate)
      TierRateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TierRate.newBuilder() to construct.
    private TierRate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TierRate() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TierRate();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingExpression_TierRate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingExpression_TierRate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.v1.PricingExpression.TierRate.class,
              com.google.cloud.billing.v1.PricingExpression.TierRate.Builder.class);
    }

    private int bitField0_;
    public static final int START_USAGE_AMOUNT_FIELD_NUMBER = 1;
    private double startUsageAmount_ = 0D;
    /**
     *
     *
     * <pre>
     * Usage is priced at this rate only after this amount.
     * Example: start_usage_amount of 10 indicates that the usage will be priced
     * at the unit_price after the first 10 usage_units.
     * </pre>
     *
     * <code>double start_usage_amount = 1;</code>
     *
     * @return The startUsageAmount.
     */
    @java.lang.Override
    public double getStartUsageAmount() {
      return startUsageAmount_;
    }

    public static final int UNIT_PRICE_FIELD_NUMBER = 2;
    private com.google.type.Money unitPrice_;
    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     *
     * @return Whether the unitPrice field is set.
     */
    @java.lang.Override
    public boolean hasUnitPrice() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     *
     * @return The unitPrice.
     */
    @java.lang.Override
    public com.google.type.Money getUnitPrice() {
      return unitPrice_ == null ? com.google.type.Money.getDefaultInstance() : unitPrice_;
    }
    /**
     *
     *
     * <pre>
     * The price per unit of usage.
     * Example: unit_price of amount $10 indicates that each unit will cost $10.
     * </pre>
     *
     * <code>.google.type.Money unit_price = 2;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getUnitPriceOrBuilder() {
      return unitPrice_ == null ? com.google.type.Money.getDefaultInstance() : unitPrice_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(startUsageAmount_) != 0) {
        output.writeDouble(1, startUsageAmount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getUnitPrice());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(startUsageAmount_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, startUsageAmount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUnitPrice());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.billing.v1.PricingExpression.TierRate)) {
        return super.equals(obj);
      }
      com.google.cloud.billing.v1.PricingExpression.TierRate other =
          (com.google.cloud.billing.v1.PricingExpression.TierRate) obj;

      if (java.lang.Double.doubleToLongBits(getStartUsageAmount())
          != java.lang.Double.doubleToLongBits(other.getStartUsageAmount())) return false;
      if (hasUnitPrice() != other.hasUnitPrice()) return false;
      if (hasUnitPrice()) {
        if (!getUnitPrice().equals(other.getUnitPrice())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + START_USAGE_AMOUNT_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getStartUsageAmount()));
      if (hasUnitPrice()) {
        hash = (37 * hash) + UNIT_PRICE_FIELD_NUMBER;
        hash = (53 * hash) + getUnitPrice().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.billing.v1.PricingExpression.TierRate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The price rate indicating starting usage and its corresponding price.
     * </pre>
     *
     * Protobuf type {@code google.cloud.billing.v1.PricingExpression.TierRate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.billing.v1.PricingExpression.TierRate)
        com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.billing.v1.CloudCatalogProto
            .internal_static_google_cloud_billing_v1_PricingExpression_TierRate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.billing.v1.CloudCatalogProto
            .internal_static_google_cloud_billing_v1_PricingExpression_TierRate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.billing.v1.PricingExpression.TierRate.class,
                com.google.cloud.billing.v1.PricingExpression.TierRate.Builder.class);
      }

      // Construct using com.google.cloud.billing.v1.PricingExpression.TierRate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUnitPriceFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startUsageAmount_ = 0D;
        unitPrice_ = null;
        if (unitPriceBuilder_ != null) {
          unitPriceBuilder_.dispose();
          unitPriceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.billing.v1.CloudCatalogProto
            .internal_static_google_cloud_billing_v1_PricingExpression_TierRate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.billing.v1.PricingExpression.TierRate getDefaultInstanceForType() {
        return com.google.cloud.billing.v1.PricingExpression.TierRate.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.billing.v1.PricingExpression.TierRate build() {
        com.google.cloud.billing.v1.PricingExpression.TierRate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.billing.v1.PricingExpression.TierRate buildPartial() {
        com.google.cloud.billing.v1.PricingExpression.TierRate result =
            new com.google.cloud.billing.v1.PricingExpression.TierRate(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.billing.v1.PricingExpression.TierRate result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startUsageAmount_ = startUsageAmount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.unitPrice_ = unitPriceBuilder_ == null ? unitPrice_ : unitPriceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.billing.v1.PricingExpression.TierRate) {
          return mergeFrom((com.google.cloud.billing.v1.PricingExpression.TierRate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.billing.v1.PricingExpression.TierRate other) {
        if (other == com.google.cloud.billing.v1.PricingExpression.TierRate.getDefaultInstance())
          return this;
        if (other.getStartUsageAmount() != 0D) {
          setStartUsageAmount(other.getStartUsageAmount());
        }
        if (other.hasUnitPrice()) {
          mergeUnitPrice(other.getUnitPrice());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  startUsageAmount_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              case 18:
                {
                  input.readMessage(getUnitPriceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double startUsageAmount_;
      /**
       *
       *
       * <pre>
       * Usage is priced at this rate only after this amount.
       * Example: start_usage_amount of 10 indicates that the usage will be priced
       * at the unit_price after the first 10 usage_units.
       * </pre>
       *
       * <code>double start_usage_amount = 1;</code>
       *
       * @return The startUsageAmount.
       */
      @java.lang.Override
      public double getStartUsageAmount() {
        return startUsageAmount_;
      }
      /**
       *
       *
       * <pre>
       * Usage is priced at this rate only after this amount.
       * Example: start_usage_amount of 10 indicates that the usage will be priced
       * at the unit_price after the first 10 usage_units.
       * </pre>
       *
       * <code>double start_usage_amount = 1;</code>
       *
       * @param value The startUsageAmount to set.
       * @return This builder for chaining.
       */
      public Builder setStartUsageAmount(double value) {

        startUsageAmount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Usage is priced at this rate only after this amount.
       * Example: start_usage_amount of 10 indicates that the usage will be priced
       * at the unit_price after the first 10 usage_units.
       * </pre>
       *
       * <code>double start_usage_amount = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartUsageAmount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startUsageAmount_ = 0D;
        onChanged();
        return this;
      }

      private com.google.type.Money unitPrice_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          unitPriceBuilder_;
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       *
       * @return Whether the unitPrice field is set.
       */
      public boolean hasUnitPrice() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       *
       * @return The unitPrice.
       */
      public com.google.type.Money getUnitPrice() {
        if (unitPriceBuilder_ == null) {
          return unitPrice_ == null ? com.google.type.Money.getDefaultInstance() : unitPrice_;
        } else {
          return unitPriceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public Builder setUnitPrice(com.google.type.Money value) {
        if (unitPriceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          unitPrice_ = value;
        } else {
          unitPriceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public Builder setUnitPrice(com.google.type.Money.Builder builderForValue) {
        if (unitPriceBuilder_ == null) {
          unitPrice_ = builderForValue.build();
        } else {
          unitPriceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public Builder mergeUnitPrice(com.google.type.Money value) {
        if (unitPriceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && unitPrice_ != null
              && unitPrice_ != com.google.type.Money.getDefaultInstance()) {
            getUnitPriceBuilder().mergeFrom(value);
          } else {
            unitPrice_ = value;
          }
        } else {
          unitPriceBuilder_.mergeFrom(value);
        }
        if (unitPrice_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public Builder clearUnitPrice() {
        bitField0_ = (bitField0_ & ~0x00000002);
        unitPrice_ = null;
        if (unitPriceBuilder_ != null) {
          unitPriceBuilder_.dispose();
          unitPriceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public com.google.type.Money.Builder getUnitPriceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getUnitPriceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      public com.google.type.MoneyOrBuilder getUnitPriceOrBuilder() {
        if (unitPriceBuilder_ != null) {
          return unitPriceBuilder_.getMessageOrBuilder();
        } else {
          return unitPrice_ == null ? com.google.type.Money.getDefaultInstance() : unitPrice_;
        }
      }
      /**
       *
       *
       * <pre>
       * The price per unit of usage.
       * Example: unit_price of amount $10 indicates that each unit will cost $10.
       * </pre>
       *
       * <code>.google.type.Money unit_price = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
          getUnitPriceFieldBuilder() {
        if (unitPriceBuilder_ == null) {
          unitPriceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Money,
                  com.google.type.Money.Builder,
                  com.google.type.MoneyOrBuilder>(
                  getUnitPrice(), getParentForChildren(), isClean());
          unitPrice_ = null;
        }
        return unitPriceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.billing.v1.PricingExpression.TierRate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.billing.v1.PricingExpression.TierRate)
    private static final com.google.cloud.billing.v1.PricingExpression.TierRate DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.billing.v1.PricingExpression.TierRate();
    }

    public static com.google.cloud.billing.v1.PricingExpression.TierRate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TierRate> PARSER =
        new com.google.protobuf.AbstractParser<TierRate>() {
          @java.lang.Override
          public TierRate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TierRate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TierRate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingExpression.TierRate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int USAGE_UNIT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object usageUnit_ = "";
  /**
   *
   *
   * <pre>
   * The short hand for unit of usage this pricing is specified in.
   * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
   * </pre>
   *
   * <code>string usage_unit = 1;</code>
   *
   * @return The usageUnit.
   */
  @java.lang.Override
  public java.lang.String getUsageUnit() {
    java.lang.Object ref = usageUnit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      usageUnit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The short hand for unit of usage this pricing is specified in.
   * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
   * </pre>
   *
   * <code>string usage_unit = 1;</code>
   *
   * @return The bytes for usageUnit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsageUnitBytes() {
    java.lang.Object ref = usageUnit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      usageUnit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_QUANTITY_FIELD_NUMBER = 2;
  private double displayQuantity_ = 0D;
  /**
   *
   *
   * <pre>
   * The recommended quantity of units for displaying pricing info. When
   * displaying pricing info it is recommended to display:
   * (unit_price * display_quantity) per display_quantity usage_unit.
   * This field does not affect the pricing formula and is for display purposes
   * only.
   * Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
   * the display_quantity is "1000" then the recommended way of displaying the
   * pricing info is "0.10 USD per 1000 GB"
   * </pre>
   *
   * <code>double display_quantity = 2;</code>
   *
   * @return The displayQuantity.
   */
  @java.lang.Override
  public double getDisplayQuantity() {
    return displayQuantity_;
  }

  public static final int TIERED_RATES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.billing.v1.PricingExpression.TierRate> tieredRates_;
  /**
   *
   *
   * <pre>
   * The list of tiered rates for this pricing. The total cost is computed by
   * applying each of the tiered rates on usage. This repeated list is sorted
   * by ascending order of start_usage_amount.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.billing.v1.PricingExpression.TierRate>
      getTieredRatesList() {
    return tieredRates_;
  }
  /**
   *
   *
   * <pre>
   * The list of tiered rates for this pricing. The total cost is computed by
   * applying each of the tiered rates on usage. This repeated list is sorted
   * by ascending order of start_usage_amount.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder>
      getTieredRatesOrBuilderList() {
    return tieredRates_;
  }
  /**
   *
   *
   * <pre>
   * The list of tiered rates for this pricing. The total cost is computed by
   * applying each of the tiered rates on usage. This repeated list is sorted
   * by ascending order of start_usage_amount.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
   */
  @java.lang.Override
  public int getTieredRatesCount() {
    return tieredRates_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of tiered rates for this pricing. The total cost is computed by
   * applying each of the tiered rates on usage. This repeated list is sorted
   * by ascending order of start_usage_amount.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingExpression.TierRate getTieredRates(int index) {
    return tieredRates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of tiered rates for this pricing. The total cost is computed by
   * applying each of the tiered rates on usage. This repeated list is sorted
   * by ascending order of start_usage_amount.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder getTieredRatesOrBuilder(
      int index) {
    return tieredRates_.get(index);
  }

  public static final int USAGE_UNIT_DESCRIPTION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object usageUnitDescription_ = "";
  /**
   *
   *
   * <pre>
   * The unit of usage in human readable form.
   * Example: "gibi byte".
   * </pre>
   *
   * <code>string usage_unit_description = 4;</code>
   *
   * @return The usageUnitDescription.
   */
  @java.lang.Override
  public java.lang.String getUsageUnitDescription() {
    java.lang.Object ref = usageUnitDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      usageUnitDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unit of usage in human readable form.
   * Example: "gibi byte".
   * </pre>
   *
   * <code>string usage_unit_description = 4;</code>
   *
   * @return The bytes for usageUnitDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsageUnitDescriptionBytes() {
    java.lang.Object ref = usageUnitDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      usageUnitDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_UNIT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseUnit_ = "";
  /**
   *
   *
   * <pre>
   * The base unit for the SKU which is the unit used in usage exports.
   * Example: "By"
   * </pre>
   *
   * <code>string base_unit = 5;</code>
   *
   * @return The baseUnit.
   */
  @java.lang.Override
  public java.lang.String getBaseUnit() {
    java.lang.Object ref = baseUnit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseUnit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The base unit for the SKU which is the unit used in usage exports.
   * Example: "By"
   * </pre>
   *
   * <code>string base_unit = 5;</code>
   *
   * @return The bytes for baseUnit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseUnitBytes() {
    java.lang.Object ref = baseUnit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseUnit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_UNIT_DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseUnitDescription_ = "";
  /**
   *
   *
   * <pre>
   * The base unit in human readable form.
   * Example: "byte".
   * </pre>
   *
   * <code>string base_unit_description = 6;</code>
   *
   * @return The baseUnitDescription.
   */
  @java.lang.Override
  public java.lang.String getBaseUnitDescription() {
    java.lang.Object ref = baseUnitDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseUnitDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The base unit in human readable form.
   * Example: "byte".
   * </pre>
   *
   * <code>string base_unit_description = 6;</code>
   *
   * @return The bytes for baseUnitDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseUnitDescriptionBytes() {
    java.lang.Object ref = baseUnitDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseUnitDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASE_UNIT_CONVERSION_FACTOR_FIELD_NUMBER = 7;
  private double baseUnitConversionFactor_ = 0D;
  /**
   *
   *
   * <pre>
   * Conversion factor for converting from price per usage_unit to price per
   * base_unit, and start_usage_amount to start_usage_amount in base_unit.
   * unit_price / base_unit_conversion_factor = price per base_unit.
   * start_usage_amount * base_unit_conversion_factor = start_usage_amount in
   * base_unit.
   * </pre>
   *
   * <code>double base_unit_conversion_factor = 7;</code>
   *
   * @return The baseUnitConversionFactor.
   */
  @java.lang.Override
  public double getBaseUnitConversionFactor() {
    return baseUnitConversionFactor_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usageUnit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, usageUnit_);
    }
    if (java.lang.Double.doubleToRawLongBits(displayQuantity_) != 0) {
      output.writeDouble(2, displayQuantity_);
    }
    for (int i = 0; i < tieredRates_.size(); i++) {
      output.writeMessage(3, tieredRates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usageUnitDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, usageUnitDescription_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUnit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, baseUnit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUnitDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, baseUnitDescription_);
    }
    if (java.lang.Double.doubleToRawLongBits(baseUnitConversionFactor_) != 0) {
      output.writeDouble(7, baseUnitConversionFactor_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usageUnit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, usageUnit_);
    }
    if (java.lang.Double.doubleToRawLongBits(displayQuantity_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, displayQuantity_);
    }
    for (int i = 0; i < tieredRates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, tieredRates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usageUnitDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, usageUnitDescription_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUnit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, baseUnit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseUnitDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, baseUnitDescription_);
    }
    if (java.lang.Double.doubleToRawLongBits(baseUnitConversionFactor_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(7, baseUnitConversionFactor_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.v1.PricingExpression)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.v1.PricingExpression other =
        (com.google.cloud.billing.v1.PricingExpression) obj;

    if (!getUsageUnit().equals(other.getUsageUnit())) return false;
    if (java.lang.Double.doubleToLongBits(getDisplayQuantity())
        != java.lang.Double.doubleToLongBits(other.getDisplayQuantity())) return false;
    if (!getTieredRatesList().equals(other.getTieredRatesList())) return false;
    if (!getUsageUnitDescription().equals(other.getUsageUnitDescription())) return false;
    if (!getBaseUnit().equals(other.getBaseUnit())) return false;
    if (!getBaseUnitDescription().equals(other.getBaseUnitDescription())) return false;
    if (java.lang.Double.doubleToLongBits(getBaseUnitConversionFactor())
        != java.lang.Double.doubleToLongBits(other.getBaseUnitConversionFactor())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + USAGE_UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUsageUnit().hashCode();
    hash = (37 * hash) + DISPLAY_QUANTITY_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDisplayQuantity()));
    if (getTieredRatesCount() > 0) {
      hash = (37 * hash) + TIERED_RATES_FIELD_NUMBER;
      hash = (53 * hash) + getTieredRatesList().hashCode();
    }
    hash = (37 * hash) + USAGE_UNIT_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getUsageUnitDescription().hashCode();
    hash = (37 * hash) + BASE_UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getBaseUnit().hashCode();
    hash = (37 * hash) + BASE_UNIT_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getBaseUnitDescription().hashCode();
    hash = (37 * hash) + BASE_UNIT_CONVERSION_FACTOR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getBaseUnitConversionFactor()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingExpression parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.v1.PricingExpression prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Expresses a mathematical pricing formula. For Example:-
   *
   * `usage_unit: GBy`
   * `tiered_rates:`
   *    `[start_usage_amount: 20, unit_price: $10]`
   *    `[start_usage_amount: 100, unit_price: $5]`
   *
   * The above expresses a pricing formula where the first 20GB is free, the
   * next 80GB is priced at $10 per GB followed by $5 per GB for additional
   * usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.v1.PricingExpression}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.v1.PricingExpression)
      com.google.cloud.billing.v1.PricingExpressionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingExpression_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingExpression_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.v1.PricingExpression.class,
              com.google.cloud.billing.v1.PricingExpression.Builder.class);
    }

    // Construct using com.google.cloud.billing.v1.PricingExpression.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      usageUnit_ = "";
      displayQuantity_ = 0D;
      if (tieredRatesBuilder_ == null) {
        tieredRates_ = java.util.Collections.emptyList();
      } else {
        tieredRates_ = null;
        tieredRatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      usageUnitDescription_ = "";
      baseUnit_ = "";
      baseUnitDescription_ = "";
      baseUnitConversionFactor_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingExpression_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingExpression getDefaultInstanceForType() {
      return com.google.cloud.billing.v1.PricingExpression.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingExpression build() {
      com.google.cloud.billing.v1.PricingExpression result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingExpression buildPartial() {
      com.google.cloud.billing.v1.PricingExpression result =
          new com.google.cloud.billing.v1.PricingExpression(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.billing.v1.PricingExpression result) {
      if (tieredRatesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          tieredRates_ = java.util.Collections.unmodifiableList(tieredRates_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.tieredRates_ = tieredRates_;
      } else {
        result.tieredRates_ = tieredRatesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.billing.v1.PricingExpression result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.usageUnit_ = usageUnit_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayQuantity_ = displayQuantity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.usageUnitDescription_ = usageUnitDescription_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.baseUnit_ = baseUnit_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.baseUnitDescription_ = baseUnitDescription_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.baseUnitConversionFactor_ = baseUnitConversionFactor_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.v1.PricingExpression) {
        return mergeFrom((com.google.cloud.billing.v1.PricingExpression) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.v1.PricingExpression other) {
      if (other == com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()) return this;
      if (!other.getUsageUnit().isEmpty()) {
        usageUnit_ = other.usageUnit_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getDisplayQuantity() != 0D) {
        setDisplayQuantity(other.getDisplayQuantity());
      }
      if (tieredRatesBuilder_ == null) {
        if (!other.tieredRates_.isEmpty()) {
          if (tieredRates_.isEmpty()) {
            tieredRates_ = other.tieredRates_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureTieredRatesIsMutable();
            tieredRates_.addAll(other.tieredRates_);
          }
          onChanged();
        }
      } else {
        if (!other.tieredRates_.isEmpty()) {
          if (tieredRatesBuilder_.isEmpty()) {
            tieredRatesBuilder_.dispose();
            tieredRatesBuilder_ = null;
            tieredRates_ = other.tieredRates_;
            bitField0_ = (bitField0_ & ~0x00000004);
            tieredRatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTieredRatesFieldBuilder()
                    : null;
          } else {
            tieredRatesBuilder_.addAllMessages(other.tieredRates_);
          }
        }
      }
      if (!other.getUsageUnitDescription().isEmpty()) {
        usageUnitDescription_ = other.usageUnitDescription_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBaseUnit().isEmpty()) {
        baseUnit_ = other.baseUnit_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getBaseUnitDescription().isEmpty()) {
        baseUnitDescription_ = other.baseUnitDescription_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getBaseUnitConversionFactor() != 0D) {
        setBaseUnitConversionFactor(other.getBaseUnitConversionFactor());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                usageUnit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 17:
              {
                displayQuantity_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            case 26:
              {
                com.google.cloud.billing.v1.PricingExpression.TierRate m =
                    input.readMessage(
                        com.google.cloud.billing.v1.PricingExpression.TierRate.parser(),
                        extensionRegistry);
                if (tieredRatesBuilder_ == null) {
                  ensureTieredRatesIsMutable();
                  tieredRates_.add(m);
                } else {
                  tieredRatesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                usageUnitDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                baseUnit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                baseUnitDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 57:
              {
                baseUnitConversionFactor_ = input.readDouble();
                bitField0_ |= 0x00000040;
                break;
              } // case 57
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object usageUnit_ = "";
    /**
     *
     *
     * <pre>
     * The short hand for unit of usage this pricing is specified in.
     * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
     * </pre>
     *
     * <code>string usage_unit = 1;</code>
     *
     * @return The usageUnit.
     */
    public java.lang.String getUsageUnit() {
      java.lang.Object ref = usageUnit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        usageUnit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short hand for unit of usage this pricing is specified in.
     * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
     * </pre>
     *
     * <code>string usage_unit = 1;</code>
     *
     * @return The bytes for usageUnit.
     */
    public com.google.protobuf.ByteString getUsageUnitBytes() {
      java.lang.Object ref = usageUnit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        usageUnit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short hand for unit of usage this pricing is specified in.
     * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
     * </pre>
     *
     * <code>string usage_unit = 1;</code>
     *
     * @param value The usageUnit to set.
     * @return This builder for chaining.
     */
    public Builder setUsageUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      usageUnit_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short hand for unit of usage this pricing is specified in.
     * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
     * </pre>
     *
     * <code>string usage_unit = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsageUnit() {
      usageUnit_ = getDefaultInstance().getUsageUnit();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short hand for unit of usage this pricing is specified in.
     * Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
     * </pre>
     *
     * <code>string usage_unit = 1;</code>
     *
     * @param value The bytes for usageUnit to set.
     * @return This builder for chaining.
     */
    public Builder setUsageUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      usageUnit_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private double displayQuantity_;
    /**
     *
     *
     * <pre>
     * The recommended quantity of units for displaying pricing info. When
     * displaying pricing info it is recommended to display:
     * (unit_price * display_quantity) per display_quantity usage_unit.
     * This field does not affect the pricing formula and is for display purposes
     * only.
     * Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
     * the display_quantity is "1000" then the recommended way of displaying the
     * pricing info is "0.10 USD per 1000 GB"
     * </pre>
     *
     * <code>double display_quantity = 2;</code>
     *
     * @return The displayQuantity.
     */
    @java.lang.Override
    public double getDisplayQuantity() {
      return displayQuantity_;
    }
    /**
     *
     *
     * <pre>
     * The recommended quantity of units for displaying pricing info. When
     * displaying pricing info it is recommended to display:
     * (unit_price * display_quantity) per display_quantity usage_unit.
     * This field does not affect the pricing formula and is for display purposes
     * only.
     * Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
     * the display_quantity is "1000" then the recommended way of displaying the
     * pricing info is "0.10 USD per 1000 GB"
     * </pre>
     *
     * <code>double display_quantity = 2;</code>
     *
     * @param value The displayQuantity to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayQuantity(double value) {

      displayQuantity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The recommended quantity of units for displaying pricing info. When
     * displaying pricing info it is recommended to display:
     * (unit_price * display_quantity) per display_quantity usage_unit.
     * This field does not affect the pricing formula and is for display purposes
     * only.
     * Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
     * the display_quantity is "1000" then the recommended way of displaying the
     * pricing info is "0.10 USD per 1000 GB"
     * </pre>
     *
     * <code>double display_quantity = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayQuantity() {
      bitField0_ = (bitField0_ & ~0x00000002);
      displayQuantity_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.billing.v1.PricingExpression.TierRate> tieredRates_ =
        java.util.Collections.emptyList();

    private void ensureTieredRatesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        tieredRates_ =
            new java.util.ArrayList<com.google.cloud.billing.v1.PricingExpression.TierRate>(
                tieredRates_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.v1.PricingExpression.TierRate,
            com.google.cloud.billing.v1.PricingExpression.TierRate.Builder,
            com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder>
        tieredRatesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public java.util.List<com.google.cloud.billing.v1.PricingExpression.TierRate>
        getTieredRatesList() {
      if (tieredRatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tieredRates_);
      } else {
        return tieredRatesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public int getTieredRatesCount() {
      if (tieredRatesBuilder_ == null) {
        return tieredRates_.size();
      } else {
        return tieredRatesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.TierRate getTieredRates(int index) {
      if (tieredRatesBuilder_ == null) {
        return tieredRates_.get(index);
      } else {
        return tieredRatesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder setTieredRates(
        int index, com.google.cloud.billing.v1.PricingExpression.TierRate value) {
      if (tieredRatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTieredRatesIsMutable();
        tieredRates_.set(index, value);
        onChanged();
      } else {
        tieredRatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder setTieredRates(
        int index, com.google.cloud.billing.v1.PricingExpression.TierRate.Builder builderForValue) {
      if (tieredRatesBuilder_ == null) {
        ensureTieredRatesIsMutable();
        tieredRates_.set(index, builderForValue.build());
        onChanged();
      } else {
        tieredRatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder addTieredRates(com.google.cloud.billing.v1.PricingExpression.TierRate value) {
      if (tieredRatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTieredRatesIsMutable();
        tieredRates_.add(value);
        onChanged();
      } else {
        tieredRatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder addTieredRates(
        int index, com.google.cloud.billing.v1.PricingExpression.TierRate value) {
      if (tieredRatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTieredRatesIsMutable();
        tieredRates_.add(index, value);
        onChanged();
      } else {
        tieredRatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder addTieredRates(
        com.google.cloud.billing.v1.PricingExpression.TierRate.Builder builderForValue) {
      if (tieredRatesBuilder_ == null) {
        ensureTieredRatesIsMutable();
        tieredRates_.add(builderForValue.build());
        onChanged();
      } else {
        tieredRatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder addTieredRates(
        int index, com.google.cloud.billing.v1.PricingExpression.TierRate.Builder builderForValue) {
      if (tieredRatesBuilder_ == null) {
        ensureTieredRatesIsMutable();
        tieredRates_.add(index, builderForValue.build());
        onChanged();
      } else {
        tieredRatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder addAllTieredRates(
        java.lang.Iterable<? extends com.google.cloud.billing.v1.PricingExpression.TierRate>
            values) {
      if (tieredRatesBuilder_ == null) {
        ensureTieredRatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tieredRates_);
        onChanged();
      } else {
        tieredRatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder clearTieredRates() {
      if (tieredRatesBuilder_ == null) {
        tieredRates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        tieredRatesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public Builder removeTieredRates(int index) {
      if (tieredRatesBuilder_ == null) {
        ensureTieredRatesIsMutable();
        tieredRates_.remove(index);
        onChanged();
      } else {
        tieredRatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.TierRate.Builder getTieredRatesBuilder(
        int index) {
      return getTieredRatesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder getTieredRatesOrBuilder(
        int index) {
      if (tieredRatesBuilder_ == null) {
        return tieredRates_.get(index);
      } else {
        return tieredRatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder>
        getTieredRatesOrBuilderList() {
      if (tieredRatesBuilder_ != null) {
        return tieredRatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tieredRates_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.TierRate.Builder addTieredRatesBuilder() {
      return getTieredRatesFieldBuilder()
          .addBuilder(com.google.cloud.billing.v1.PricingExpression.TierRate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.TierRate.Builder addTieredRatesBuilder(
        int index) {
      return getTieredRatesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.billing.v1.PricingExpression.TierRate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of tiered rates for this pricing. The total cost is computed by
     * applying each of the tiered rates on usage. This repeated list is sorted
     * by ascending order of start_usage_amount.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingExpression.TierRate tiered_rates = 3;</code>
     */
    public java.util.List<com.google.cloud.billing.v1.PricingExpression.TierRate.Builder>
        getTieredRatesBuilderList() {
      return getTieredRatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.v1.PricingExpression.TierRate,
            com.google.cloud.billing.v1.PricingExpression.TierRate.Builder,
            com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder>
        getTieredRatesFieldBuilder() {
      if (tieredRatesBuilder_ == null) {
        tieredRatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.billing.v1.PricingExpression.TierRate,
                com.google.cloud.billing.v1.PricingExpression.TierRate.Builder,
                com.google.cloud.billing.v1.PricingExpression.TierRateOrBuilder>(
                tieredRates_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        tieredRates_ = null;
      }
      return tieredRatesBuilder_;
    }

    private java.lang.Object usageUnitDescription_ = "";
    /**
     *
     *
     * <pre>
     * The unit of usage in human readable form.
     * Example: "gibi byte".
     * </pre>
     *
     * <code>string usage_unit_description = 4;</code>
     *
     * @return The usageUnitDescription.
     */
    public java.lang.String getUsageUnitDescription() {
      java.lang.Object ref = usageUnitDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        usageUnitDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unit of usage in human readable form.
     * Example: "gibi byte".
     * </pre>
     *
     * <code>string usage_unit_description = 4;</code>
     *
     * @return The bytes for usageUnitDescription.
     */
    public com.google.protobuf.ByteString getUsageUnitDescriptionBytes() {
      java.lang.Object ref = usageUnitDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        usageUnitDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unit of usage in human readable form.
     * Example: "gibi byte".
     * </pre>
     *
     * <code>string usage_unit_description = 4;</code>
     *
     * @param value The usageUnitDescription to set.
     * @return This builder for chaining.
     */
    public Builder setUsageUnitDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      usageUnitDescription_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unit of usage in human readable form.
     * Example: "gibi byte".
     * </pre>
     *
     * <code>string usage_unit_description = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsageUnitDescription() {
      usageUnitDescription_ = getDefaultInstance().getUsageUnitDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unit of usage in human readable form.
     * Example: "gibi byte".
     * </pre>
     *
     * <code>string usage_unit_description = 4;</code>
     *
     * @param value The bytes for usageUnitDescription to set.
     * @return This builder for chaining.
     */
    public Builder setUsageUnitDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      usageUnitDescription_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object baseUnit_ = "";
    /**
     *
     *
     * <pre>
     * The base unit for the SKU which is the unit used in usage exports.
     * Example: "By"
     * </pre>
     *
     * <code>string base_unit = 5;</code>
     *
     * @return The baseUnit.
     */
    public java.lang.String getBaseUnit() {
      java.lang.Object ref = baseUnit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseUnit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base unit for the SKU which is the unit used in usage exports.
     * Example: "By"
     * </pre>
     *
     * <code>string base_unit = 5;</code>
     *
     * @return The bytes for baseUnit.
     */
    public com.google.protobuf.ByteString getBaseUnitBytes() {
      java.lang.Object ref = baseUnit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseUnit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base unit for the SKU which is the unit used in usage exports.
     * Example: "By"
     * </pre>
     *
     * <code>string base_unit = 5;</code>
     *
     * @param value The baseUnit to set.
     * @return This builder for chaining.
     */
    public Builder setBaseUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseUnit_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base unit for the SKU which is the unit used in usage exports.
     * Example: "By"
     * </pre>
     *
     * <code>string base_unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseUnit() {
      baseUnit_ = getDefaultInstance().getBaseUnit();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base unit for the SKU which is the unit used in usage exports.
     * Example: "By"
     * </pre>
     *
     * <code>string base_unit = 5;</code>
     *
     * @param value The bytes for baseUnit to set.
     * @return This builder for chaining.
     */
    public Builder setBaseUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseUnit_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object baseUnitDescription_ = "";
    /**
     *
     *
     * <pre>
     * The base unit in human readable form.
     * Example: "byte".
     * </pre>
     *
     * <code>string base_unit_description = 6;</code>
     *
     * @return The baseUnitDescription.
     */
    public java.lang.String getBaseUnitDescription() {
      java.lang.Object ref = baseUnitDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseUnitDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base unit in human readable form.
     * Example: "byte".
     * </pre>
     *
     * <code>string base_unit_description = 6;</code>
     *
     * @return The bytes for baseUnitDescription.
     */
    public com.google.protobuf.ByteString getBaseUnitDescriptionBytes() {
      java.lang.Object ref = baseUnitDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseUnitDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base unit in human readable form.
     * Example: "byte".
     * </pre>
     *
     * <code>string base_unit_description = 6;</code>
     *
     * @param value The baseUnitDescription to set.
     * @return This builder for chaining.
     */
    public Builder setBaseUnitDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseUnitDescription_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base unit in human readable form.
     * Example: "byte".
     * </pre>
     *
     * <code>string base_unit_description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseUnitDescription() {
      baseUnitDescription_ = getDefaultInstance().getBaseUnitDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base unit in human readable form.
     * Example: "byte".
     * </pre>
     *
     * <code>string base_unit_description = 6;</code>
     *
     * @param value The bytes for baseUnitDescription to set.
     * @return This builder for chaining.
     */
    public Builder setBaseUnitDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseUnitDescription_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private double baseUnitConversionFactor_;
    /**
     *
     *
     * <pre>
     * Conversion factor for converting from price per usage_unit to price per
     * base_unit, and start_usage_amount to start_usage_amount in base_unit.
     * unit_price / base_unit_conversion_factor = price per base_unit.
     * start_usage_amount * base_unit_conversion_factor = start_usage_amount in
     * base_unit.
     * </pre>
     *
     * <code>double base_unit_conversion_factor = 7;</code>
     *
     * @return The baseUnitConversionFactor.
     */
    @java.lang.Override
    public double getBaseUnitConversionFactor() {
      return baseUnitConversionFactor_;
    }
    /**
     *
     *
     * <pre>
     * Conversion factor for converting from price per usage_unit to price per
     * base_unit, and start_usage_amount to start_usage_amount in base_unit.
     * unit_price / base_unit_conversion_factor = price per base_unit.
     * start_usage_amount * base_unit_conversion_factor = start_usage_amount in
     * base_unit.
     * </pre>
     *
     * <code>double base_unit_conversion_factor = 7;</code>
     *
     * @param value The baseUnitConversionFactor to set.
     * @return This builder for chaining.
     */
    public Builder setBaseUnitConversionFactor(double value) {

      baseUnitConversionFactor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversion factor for converting from price per usage_unit to price per
     * base_unit, and start_usage_amount to start_usage_amount in base_unit.
     * unit_price / base_unit_conversion_factor = price per base_unit.
     * start_usage_amount * base_unit_conversion_factor = start_usage_amount in
     * base_unit.
     * </pre>
     *
     * <code>double base_unit_conversion_factor = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseUnitConversionFactor() {
      bitField0_ = (bitField0_ & ~0x00000040);
      baseUnitConversionFactor_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.v1.PricingExpression)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.v1.PricingExpression)
  private static final com.google.cloud.billing.v1.PricingExpression DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.v1.PricingExpression();
  }

  public static com.google.cloud.billing.v1.PricingExpression getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PricingExpression> PARSER =
      new com.google.protobuf.AbstractParser<PricingExpression>() {
        @java.lang.Override
        public PricingExpression parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PricingExpression> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PricingExpression> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.v1.PricingExpression getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
