/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/v1/cloud_catalog.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.billing.v1;

/**
 *
 *
 * <pre>
 * Represents the pricing information for a SKU at a single point of time.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.v1.PricingInfo}
 */
public final class PricingInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.v1.PricingInfo)
    PricingInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PricingInfo.newBuilder() to construct.
  private PricingInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PricingInfo() {
    summary_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PricingInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_PricingInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_PricingInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.v1.PricingInfo.class,
            com.google.cloud.billing.v1.PricingInfo.Builder.class);
  }

  private int bitField0_;
  public static final int EFFECTIVE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp effectiveTime_;
  /**
   *
   *
   * <pre>
   * The timestamp from which this pricing was effective within the requested
   * time range. This is guaranteed to be greater than or equal to the
   * start_time field in the request and less than the end_time field in the
   * request. If a time range was not specified in the request this field will
   * be equivalent to a time within the last 12 hours, indicating the latest
   * pricing info.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp effective_time = 1;</code>
   *
   * @return Whether the effectiveTime field is set.
   */
  @java.lang.Override
  public boolean hasEffectiveTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp from which this pricing was effective within the requested
   * time range. This is guaranteed to be greater than or equal to the
   * start_time field in the request and less than the end_time field in the
   * request. If a time range was not specified in the request this field will
   * be equivalent to a time within the last 12 hours, indicating the latest
   * pricing info.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp effective_time = 1;</code>
   *
   * @return The effectiveTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEffectiveTime() {
    return effectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : effectiveTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp from which this pricing was effective within the requested
   * time range. This is guaranteed to be greater than or equal to the
   * start_time field in the request and less than the end_time field in the
   * request. If a time range was not specified in the request this field will
   * be equivalent to a time within the last 12 hours, indicating the latest
   * pricing info.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp effective_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
    return effectiveTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : effectiveTime_;
  }

  public static final int SUMMARY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object summary_ = "";
  /**
   *
   *
   * <pre>
   * An optional human readable summary of the pricing information, has a
   * maximum length of 256 characters.
   * </pre>
   *
   * <code>string summary = 2;</code>
   *
   * @return The summary.
   */
  @java.lang.Override
  public java.lang.String getSummary() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      summary_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional human readable summary of the pricing information, has a
   * maximum length of 256 characters.
   * </pre>
   *
   * <code>string summary = 2;</code>
   *
   * @return The bytes for summary.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSummaryBytes() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      summary_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRICING_EXPRESSION_FIELD_NUMBER = 3;
  private com.google.cloud.billing.v1.PricingExpression pricingExpression_;
  /**
   *
   *
   * <pre>
   * Expresses the pricing formula. See `PricingExpression` for an example.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
   *
   * @return Whether the pricingExpression field is set.
   */
  @java.lang.Override
  public boolean hasPricingExpression() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Expresses the pricing formula. See `PricingExpression` for an example.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
   *
   * @return The pricingExpression.
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingExpression getPricingExpression() {
    return pricingExpression_ == null
        ? com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()
        : pricingExpression_;
  }
  /**
   *
   *
   * <pre>
   * Expresses the pricing formula. See `PricingExpression` for an example.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingExpressionOrBuilder getPricingExpressionOrBuilder() {
    return pricingExpression_ == null
        ? com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()
        : pricingExpression_;
  }

  public static final int AGGREGATION_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.billing.v1.AggregationInfo aggregationInfo_;
  /**
   *
   *
   * <pre>
   * Aggregation Info. This can be left unspecified if the pricing expression
   * doesn't require aggregation.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
   *
   * @return Whether the aggregationInfo field is set.
   */
  @java.lang.Override
  public boolean hasAggregationInfo() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Aggregation Info. This can be left unspecified if the pricing expression
   * doesn't require aggregation.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
   *
   * @return The aggregationInfo.
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.AggregationInfo getAggregationInfo() {
    return aggregationInfo_ == null
        ? com.google.cloud.billing.v1.AggregationInfo.getDefaultInstance()
        : aggregationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Aggregation Info. This can be left unspecified if the pricing expression
   * doesn't require aggregation.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.AggregationInfoOrBuilder getAggregationInfoOrBuilder() {
    return aggregationInfo_ == null
        ? com.google.cloud.billing.v1.AggregationInfo.getDefaultInstance()
        : aggregationInfo_;
  }

  public static final int CURRENCY_CONVERSION_RATE_FIELD_NUMBER = 5;
  private double currencyConversionRate_ = 0D;
  /**
   *
   *
   * <pre>
   * Conversion rate used for currency conversion, from USD to the currency
   * specified in the request. This includes any surcharge collected for billing
   * in non USD currency. If a currency is not specified in the request this
   * defaults to 1.0.
   * Example: USD * currency_conversion_rate = JPY
   * </pre>
   *
   * <code>double currency_conversion_rate = 5;</code>
   *
   * @return The currencyConversionRate.
   */
  @java.lang.Override
  public double getCurrencyConversionRate() {
    return currencyConversionRate_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEffectiveTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, summary_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getPricingExpression());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getAggregationInfo());
    }
    if (java.lang.Double.doubleToRawLongBits(currencyConversionRate_) != 0) {
      output.writeDouble(5, currencyConversionRate_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEffectiveTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, summary_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPricingExpression());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAggregationInfo());
    }
    if (java.lang.Double.doubleToRawLongBits(currencyConversionRate_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(5, currencyConversionRate_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.v1.PricingInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.v1.PricingInfo other = (com.google.cloud.billing.v1.PricingInfo) obj;

    if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
    if (hasEffectiveTime()) {
      if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
    }
    if (!getSummary().equals(other.getSummary())) return false;
    if (hasPricingExpression() != other.hasPricingExpression()) return false;
    if (hasPricingExpression()) {
      if (!getPricingExpression().equals(other.getPricingExpression())) return false;
    }
    if (hasAggregationInfo() != other.hasAggregationInfo()) return false;
    if (hasAggregationInfo()) {
      if (!getAggregationInfo().equals(other.getAggregationInfo())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getCurrencyConversionRate())
        != java.lang.Double.doubleToLongBits(other.getCurrencyConversionRate())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEffectiveTime()) {
      hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEffectiveTime().hashCode();
    }
    hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
    hash = (53 * hash) + getSummary().hashCode();
    if (hasPricingExpression()) {
      hash = (37 * hash) + PRICING_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getPricingExpression().hashCode();
    }
    if (hasAggregationInfo()) {
      hash = (37 * hash) + AGGREGATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationInfo().hashCode();
    }
    hash = (37 * hash) + CURRENCY_CONVERSION_RATE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getCurrencyConversionRate()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.PricingInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.v1.PricingInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the pricing information for a SKU at a single point of time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.v1.PricingInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.v1.PricingInfo)
      com.google.cloud.billing.v1.PricingInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.v1.PricingInfo.class,
              com.google.cloud.billing.v1.PricingInfo.Builder.class);
    }

    // Construct using com.google.cloud.billing.v1.PricingInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEffectiveTimeFieldBuilder();
        getPricingExpressionFieldBuilder();
        getAggregationInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      effectiveTime_ = null;
      if (effectiveTimeBuilder_ != null) {
        effectiveTimeBuilder_.dispose();
        effectiveTimeBuilder_ = null;
      }
      summary_ = "";
      pricingExpression_ = null;
      if (pricingExpressionBuilder_ != null) {
        pricingExpressionBuilder_.dispose();
        pricingExpressionBuilder_ = null;
      }
      aggregationInfo_ = null;
      if (aggregationInfoBuilder_ != null) {
        aggregationInfoBuilder_.dispose();
        aggregationInfoBuilder_ = null;
      }
      currencyConversionRate_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_PricingInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingInfo getDefaultInstanceForType() {
      return com.google.cloud.billing.v1.PricingInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingInfo build() {
      com.google.cloud.billing.v1.PricingInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.PricingInfo buildPartial() {
      com.google.cloud.billing.v1.PricingInfo result =
          new com.google.cloud.billing.v1.PricingInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.billing.v1.PricingInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.effectiveTime_ =
            effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.summary_ = summary_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pricingExpression_ =
            pricingExpressionBuilder_ == null
                ? pricingExpression_
                : pricingExpressionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.aggregationInfo_ =
            aggregationInfoBuilder_ == null ? aggregationInfo_ : aggregationInfoBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.currencyConversionRate_ = currencyConversionRate_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.v1.PricingInfo) {
        return mergeFrom((com.google.cloud.billing.v1.PricingInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.v1.PricingInfo other) {
      if (other == com.google.cloud.billing.v1.PricingInfo.getDefaultInstance()) return this;
      if (other.hasEffectiveTime()) {
        mergeEffectiveTime(other.getEffectiveTime());
      }
      if (!other.getSummary().isEmpty()) {
        summary_ = other.summary_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPricingExpression()) {
        mergePricingExpression(other.getPricingExpression());
      }
      if (other.hasAggregationInfo()) {
        mergeAggregationInfo(other.getAggregationInfo());
      }
      if (other.getCurrencyConversionRate() != 0D) {
        setCurrencyConversionRate(other.getCurrencyConversionRate());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                summary_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPricingExpressionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getAggregationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 41:
              {
                currencyConversionRate_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 41
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp effectiveTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        effectiveTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    public boolean hasEffectiveTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     *
     * @return The effectiveTime.
     */
    public com.google.protobuf.Timestamp getEffectiveTime() {
      if (effectiveTimeBuilder_ == null) {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      } else {
        return effectiveTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
      if (effectiveTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        effectiveTime_ = value;
      } else {
        effectiveTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (effectiveTimeBuilder_ == null) {
        effectiveTime_ = builderForValue.build();
      } else {
        effectiveTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
      if (effectiveTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && effectiveTime_ != null
            && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEffectiveTimeBuilder().mergeFrom(value);
        } else {
          effectiveTime_ = value;
        }
      } else {
        effectiveTimeBuilder_.mergeFrom(value);
      }
      if (effectiveTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public Builder clearEffectiveTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      effectiveTime_ = null;
      if (effectiveTimeBuilder_ != null) {
        effectiveTimeBuilder_.dispose();
        effectiveTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEffectiveTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      if (effectiveTimeBuilder_ != null) {
        return effectiveTimeBuilder_.getMessageOrBuilder();
      } else {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEffectiveTimeFieldBuilder() {
      if (effectiveTimeBuilder_ == null) {
        effectiveTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEffectiveTime(), getParentForChildren(), isClean());
        effectiveTime_ = null;
      }
      return effectiveTimeBuilder_;
    }

    private java.lang.Object summary_ = "";
    /**
     *
     *
     * <pre>
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The summary.
     */
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return The bytes for summary.
     */
    public com.google.protobuf.ByteString getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @param value The summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummary(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      summary_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSummary() {
      summary_ = getDefaultInstance().getSummary();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     * </pre>
     *
     * <code>string summary = 2;</code>
     *
     * @param value The bytes for summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      summary_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.billing.v1.PricingExpression pricingExpression_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.PricingExpression,
            com.google.cloud.billing.v1.PricingExpression.Builder,
            com.google.cloud.billing.v1.PricingExpressionOrBuilder>
        pricingExpressionBuilder_;
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     *
     * @return Whether the pricingExpression field is set.
     */
    public boolean hasPricingExpression() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     *
     * @return The pricingExpression.
     */
    public com.google.cloud.billing.v1.PricingExpression getPricingExpression() {
      if (pricingExpressionBuilder_ == null) {
        return pricingExpression_ == null
            ? com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()
            : pricingExpression_;
      } else {
        return pricingExpressionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public Builder setPricingExpression(com.google.cloud.billing.v1.PricingExpression value) {
      if (pricingExpressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pricingExpression_ = value;
      } else {
        pricingExpressionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public Builder setPricingExpression(
        com.google.cloud.billing.v1.PricingExpression.Builder builderForValue) {
      if (pricingExpressionBuilder_ == null) {
        pricingExpression_ = builderForValue.build();
      } else {
        pricingExpressionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public Builder mergePricingExpression(com.google.cloud.billing.v1.PricingExpression value) {
      if (pricingExpressionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && pricingExpression_ != null
            && pricingExpression_
                != com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()) {
          getPricingExpressionBuilder().mergeFrom(value);
        } else {
          pricingExpression_ = value;
        }
      } else {
        pricingExpressionBuilder_.mergeFrom(value);
      }
      if (pricingExpression_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public Builder clearPricingExpression() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pricingExpression_ = null;
      if (pricingExpressionBuilder_ != null) {
        pricingExpressionBuilder_.dispose();
        pricingExpressionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpression.Builder getPricingExpressionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPricingExpressionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    public com.google.cloud.billing.v1.PricingExpressionOrBuilder getPricingExpressionOrBuilder() {
      if (pricingExpressionBuilder_ != null) {
        return pricingExpressionBuilder_.getMessageOrBuilder();
      } else {
        return pricingExpression_ == null
            ? com.google.cloud.billing.v1.PricingExpression.getDefaultInstance()
            : pricingExpression_;
      }
    }
    /**
     *
     *
     * <pre>
     * Expresses the pricing formula. See `PricingExpression` for an example.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.PricingExpression,
            com.google.cloud.billing.v1.PricingExpression.Builder,
            com.google.cloud.billing.v1.PricingExpressionOrBuilder>
        getPricingExpressionFieldBuilder() {
      if (pricingExpressionBuilder_ == null) {
        pricingExpressionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.v1.PricingExpression,
                com.google.cloud.billing.v1.PricingExpression.Builder,
                com.google.cloud.billing.v1.PricingExpressionOrBuilder>(
                getPricingExpression(), getParentForChildren(), isClean());
        pricingExpression_ = null;
      }
      return pricingExpressionBuilder_;
    }

    private com.google.cloud.billing.v1.AggregationInfo aggregationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.AggregationInfo,
            com.google.cloud.billing.v1.AggregationInfo.Builder,
            com.google.cloud.billing.v1.AggregationInfoOrBuilder>
        aggregationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     *
     * @return Whether the aggregationInfo field is set.
     */
    public boolean hasAggregationInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     *
     * @return The aggregationInfo.
     */
    public com.google.cloud.billing.v1.AggregationInfo getAggregationInfo() {
      if (aggregationInfoBuilder_ == null) {
        return aggregationInfo_ == null
            ? com.google.cloud.billing.v1.AggregationInfo.getDefaultInstance()
            : aggregationInfo_;
      } else {
        return aggregationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public Builder setAggregationInfo(com.google.cloud.billing.v1.AggregationInfo value) {
      if (aggregationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationInfo_ = value;
      } else {
        aggregationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public Builder setAggregationInfo(
        com.google.cloud.billing.v1.AggregationInfo.Builder builderForValue) {
      if (aggregationInfoBuilder_ == null) {
        aggregationInfo_ = builderForValue.build();
      } else {
        aggregationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public Builder mergeAggregationInfo(com.google.cloud.billing.v1.AggregationInfo value) {
      if (aggregationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && aggregationInfo_ != null
            && aggregationInfo_
                != com.google.cloud.billing.v1.AggregationInfo.getDefaultInstance()) {
          getAggregationInfoBuilder().mergeFrom(value);
        } else {
          aggregationInfo_ = value;
        }
      } else {
        aggregationInfoBuilder_.mergeFrom(value);
      }
      if (aggregationInfo_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public Builder clearAggregationInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      aggregationInfo_ = null;
      if (aggregationInfoBuilder_ != null) {
        aggregationInfoBuilder_.dispose();
        aggregationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public com.google.cloud.billing.v1.AggregationInfo.Builder getAggregationInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAggregationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    public com.google.cloud.billing.v1.AggregationInfoOrBuilder getAggregationInfoOrBuilder() {
      if (aggregationInfoBuilder_ != null) {
        return aggregationInfoBuilder_.getMessageOrBuilder();
      } else {
        return aggregationInfo_ == null
            ? com.google.cloud.billing.v1.AggregationInfo.getDefaultInstance()
            : aggregationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.AggregationInfo,
            com.google.cloud.billing.v1.AggregationInfo.Builder,
            com.google.cloud.billing.v1.AggregationInfoOrBuilder>
        getAggregationInfoFieldBuilder() {
      if (aggregationInfoBuilder_ == null) {
        aggregationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.v1.AggregationInfo,
                com.google.cloud.billing.v1.AggregationInfo.Builder,
                com.google.cloud.billing.v1.AggregationInfoOrBuilder>(
                getAggregationInfo(), getParentForChildren(), isClean());
        aggregationInfo_ = null;
      }
      return aggregationInfoBuilder_;
    }

    private double currencyConversionRate_;
    /**
     *
     *
     * <pre>
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     * </pre>
     *
     * <code>double currency_conversion_rate = 5;</code>
     *
     * @return The currencyConversionRate.
     */
    @java.lang.Override
    public double getCurrencyConversionRate() {
      return currencyConversionRate_;
    }
    /**
     *
     *
     * <pre>
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     * </pre>
     *
     * <code>double currency_conversion_rate = 5;</code>
     *
     * @param value The currencyConversionRate to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyConversionRate(double value) {

      currencyConversionRate_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     * </pre>
     *
     * <code>double currency_conversion_rate = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrencyConversionRate() {
      bitField0_ = (bitField0_ & ~0x00000010);
      currencyConversionRate_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.v1.PricingInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.v1.PricingInfo)
  private static final com.google.cloud.billing.v1.PricingInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.v1.PricingInfo();
  }

  public static com.google.cloud.billing.v1.PricingInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PricingInfo> PARSER =
      new com.google.protobuf.AbstractParser<PricingInfo>() {
        @java.lang.Override
        public PricingInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PricingInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PricingInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.v1.PricingInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
