/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/v1/cloud_billing.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.billing.v1;

public interface BillingAccountOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.billing.v1.BillingAccount)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the billing account. The resource name
   * has the form `billingAccounts/{billing_account_id}`. For example,
   * `billingAccounts/012345-567890-ABCDEF` would be the resource name for
   * billing account `012345-567890-ABCDEF`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the billing account. The resource name
   * has the form `billingAccounts/{billing_account_id}`. For example,
   * `billingAccounts/012345-567890-ABCDEF` would be the resource name for
   * billing account `012345-567890-ABCDEF`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. True if the billing account is open, and will therefore be
   * charged for any usage on associated projects. False if the billing account
   * is closed, and therefore projects associated with it are unable to use paid
   * services.
   * </pre>
   *
   * <code>bool open = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The open.
   */
  boolean getOpen();

  /**
   *
   *
   * <pre>
   * The display name given to the billing account, such as `My Billing
   * Account`. This name is displayed in the Google Cloud Console.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * The display name given to the billing account, such as `My Billing
   * Account`. This name is displayed in the Google Cloud Console.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * If this account is a
   * [subaccount](https://cloud.google.com/billing/docs/concepts), then this
   * will be the resource name of the parent billing account that it is being
   * resold through.
   * Otherwise this will be empty.
   * </pre>
   *
   * <code>string master_billing_account = 4;</code>
   *
   * @return The masterBillingAccount.
   */
  java.lang.String getMasterBillingAccount();
  /**
   *
   *
   * <pre>
   * If this account is a
   * [subaccount](https://cloud.google.com/billing/docs/concepts), then this
   * will be the resource name of the parent billing account that it is being
   * resold through.
   * Otherwise this will be empty.
   * </pre>
   *
   * <code>string master_billing_account = 4;</code>
   *
   * @return The bytes for masterBillingAccount.
   */
  com.google.protobuf.ByteString getMasterBillingAccountBytes();

  /**
   *
   *
   * <pre>
   * Output only. The billing account's parent resource identifier.
   * Use the `MoveBillingAccount` method to update the account's parent resource
   * if it is a organization.
   * Format:
   *   - `organizations/{organization_id}`, for example,
   *     `organizations/12345678`
   *   - `billingAccounts/{billing_account_id}`, for example,
   *     `billingAccounts/012345-567890-ABCDEF`
   * </pre>
   *
   * <code>string parent = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Output only. The billing account's parent resource identifier.
   * Use the `MoveBillingAccount` method to update the account's parent resource
   * if it is a organization.
   * Format:
   *   - `organizations/{organization_id}`, for example,
   *     `organizations/12345678`
   *   - `billingAccounts/{billing_account_id}`, for example,
   *     `billingAccounts/012345-567890-ABCDEF`
   * </pre>
   *
   * <code>string parent = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();
}
