/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/v1/cloud_catalog.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.billing.v1;

/**
 *
 *
 * <pre>
 * Encapsulates the geographic taxonomy data for a sku.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.v1.GeoTaxonomy}
 */
public final class GeoTaxonomy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.v1.GeoTaxonomy)
    GeoTaxonomyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GeoTaxonomy.newBuilder() to construct.
  private GeoTaxonomy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GeoTaxonomy() {
    type_ = 0;
    regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GeoTaxonomy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_GeoTaxonomy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_GeoTaxonomy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.v1.GeoTaxonomy.class,
            com.google.cloud.billing.v1.GeoTaxonomy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.billing.v1.GeoTaxonomy.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The type is not specified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The sku is global in nature, e.g. a license sku. Global skus are
     * available in all regions, and so have an empty region list.
     * </pre>
     *
     * <code>GLOBAL = 1;</code>
     */
    GLOBAL(1),
    /**
     *
     *
     * <pre>
     * The sku is available in a specific region, e.g. "us-west2".
     * </pre>
     *
     * <code>REGIONAL = 2;</code>
     */
    REGIONAL(2),
    /**
     *
     *
     * <pre>
     * The sku is associated with multiple regions, e.g. "us-west2" and
     * "us-east1".
     * </pre>
     *
     * <code>MULTI_REGIONAL = 3;</code>
     */
    MULTI_REGIONAL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The type is not specified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The sku is global in nature, e.g. a license sku. Global skus are
     * available in all regions, and so have an empty region list.
     * </pre>
     *
     * <code>GLOBAL = 1;</code>
     */
    public static final int GLOBAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The sku is available in a specific region, e.g. "us-west2".
     * </pre>
     *
     * <code>REGIONAL = 2;</code>
     */
    public static final int REGIONAL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The sku is associated with multiple regions, e.g. "us-west2" and
     * "us-east1".
     * </pre>
     *
     * <code>MULTI_REGIONAL = 3;</code>
     */
    public static final int MULTI_REGIONAL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return GLOBAL;
        case 2:
          return REGIONAL;
        case 3:
          return MULTI_REGIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.billing.v1.GeoTaxonomy.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.billing.v1.GeoTaxonomy.Type)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.GeoTaxonomy.Type getType() {
    com.google.cloud.billing.v1.GeoTaxonomy.Type result =
        com.google.cloud.billing.v1.GeoTaxonomy.Type.forNumber(type_);
    return result == null ? com.google.cloud.billing.v1.GeoTaxonomy.Type.UNRECOGNIZED : result;
  }

  public static final int REGIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList regions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of regions associated with a sku. Empty for Global skus, which are
   * associated with all Google Cloud regions.
   * </pre>
   *
   * <code>repeated string regions = 2;</code>
   *
   * @return A list containing the regions.
   */
  public com.google.protobuf.ProtocolStringList getRegionsList() {
    return regions_;
  }
  /**
   *
   *
   * <pre>
   * The list of regions associated with a sku. Empty for Global skus, which are
   * associated with all Google Cloud regions.
   * </pre>
   *
   * <code>repeated string regions = 2;</code>
   *
   * @return The count of regions.
   */
  public int getRegionsCount() {
    return regions_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of regions associated with a sku. Empty for Global skus, which are
   * associated with all Google Cloud regions.
   * </pre>
   *
   * <code>repeated string regions = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The regions at the given index.
   */
  public java.lang.String getRegions(int index) {
    return regions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of regions associated with a sku. Empty for Global skus, which are
   * associated with all Google Cloud regions.
   * </pre>
   *
   * <code>repeated string regions = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the regions at the given index.
   */
  public com.google.protobuf.ByteString getRegionsBytes(int index) {
    return regions_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.cloud.billing.v1.GeoTaxonomy.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    for (int i = 0; i < regions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, regions_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.cloud.billing.v1.GeoTaxonomy.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < regions_.size(); i++) {
        dataSize += computeStringSizeNoTag(regions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRegionsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.v1.GeoTaxonomy)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.v1.GeoTaxonomy other = (com.google.cloud.billing.v1.GeoTaxonomy) obj;

    if (type_ != other.type_) return false;
    if (!getRegionsList().equals(other.getRegionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getRegionsCount() > 0) {
      hash = (37 * hash) + REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRegionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.v1.GeoTaxonomy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encapsulates the geographic taxonomy data for a sku.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.v1.GeoTaxonomy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.v1.GeoTaxonomy)
      com.google.cloud.billing.v1.GeoTaxonomyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_GeoTaxonomy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_GeoTaxonomy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.v1.GeoTaxonomy.class,
              com.google.cloud.billing.v1.GeoTaxonomy.Builder.class);
    }

    // Construct using com.google.cloud.billing.v1.GeoTaxonomy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_GeoTaxonomy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.GeoTaxonomy getDefaultInstanceForType() {
      return com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.GeoTaxonomy build() {
      com.google.cloud.billing.v1.GeoTaxonomy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.GeoTaxonomy buildPartial() {
      com.google.cloud.billing.v1.GeoTaxonomy result =
          new com.google.cloud.billing.v1.GeoTaxonomy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.billing.v1.GeoTaxonomy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        regions_.makeImmutable();
        result.regions_ = regions_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.v1.GeoTaxonomy) {
        return mergeFrom((com.google.cloud.billing.v1.GeoTaxonomy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.v1.GeoTaxonomy other) {
      if (other == com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.regions_.isEmpty()) {
        if (regions_.isEmpty()) {
          regions_ = other.regions_;
          bitField0_ |= 0x00000002;
        } else {
          ensureRegionsIsMutable();
          regions_.addAll(other.regions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRegionsIsMutable();
                regions_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.billing.v1.GeoTaxonomy.Type getType() {
      com.google.cloud.billing.v1.GeoTaxonomy.Type result =
          com.google.cloud.billing.v1.GeoTaxonomy.Type.forNumber(type_);
      return result == null ? com.google.cloud.billing.v1.GeoTaxonomy.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.billing.v1.GeoTaxonomy.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy.Type type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList regions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRegionsIsMutable() {
      if (!regions_.isModifiable()) {
        regions_ = new com.google.protobuf.LazyStringArrayList(regions_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @return A list containing the regions.
     */
    public com.google.protobuf.ProtocolStringList getRegionsList() {
      regions_.makeImmutable();
      return regions_;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @return The count of regions.
     */
    public int getRegionsCount() {
      return regions_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The regions at the given index.
     */
    public java.lang.String getRegions(int index) {
      return regions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the regions at the given index.
     */
    public com.google.protobuf.ByteString getRegionsBytes(int index) {
      return regions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The regions to set.
     * @return This builder for chaining.
     */
    public Builder setRegions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param value The regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param values The regions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRegions(java.lang.Iterable<java.lang.String> values) {
      ensureRegionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, regions_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegions() {
      regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of regions associated with a sku. Empty for Global skus, which are
     * associated with all Google Cloud regions.
     * </pre>
     *
     * <code>repeated string regions = 2;</code>
     *
     * @param value The bytes of the regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRegionsIsMutable();
      regions_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.v1.GeoTaxonomy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.v1.GeoTaxonomy)
  private static final com.google.cloud.billing.v1.GeoTaxonomy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.v1.GeoTaxonomy();
  }

  public static com.google.cloud.billing.v1.GeoTaxonomy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GeoTaxonomy> PARSER =
      new com.google.protobuf.AbstractParser<GeoTaxonomy>() {
        @java.lang.Override
        public GeoTaxonomy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GeoTaxonomy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GeoTaxonomy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.v1.GeoTaxonomy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
