/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/v1/cloud_catalog.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.billing.v1;

/**
 *
 *
 * <pre>
 * Encapsulates a single SKU in Google Cloud
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.v1.Sku}
 */
public final class Sku extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.v1.Sku)
    SkuOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Sku.newBuilder() to construct.
  private Sku(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Sku() {
    name_ = "";
    skuId_ = "";
    description_ = "";
    serviceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    pricingInfo_ = java.util.Collections.emptyList();
    serviceProviderName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Sku();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_Sku_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.v1.CloudCatalogProto
        .internal_static_google_cloud_billing_v1_Sku_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.v1.Sku.class, com.google.cloud.billing.v1.Sku.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name for the SKU.
   * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name for the SKU.
   * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SKU_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skuId_ = "";
  /**
   *
   *
   * <pre>
   * The identifier for the SKU.
   * Example: "D041-B8A1-6E0B"
   * </pre>
   *
   * <code>string sku_id = 2;</code>
   *
   * @return The skuId.
   */
  @java.lang.Override
  public java.lang.String getSkuId() {
    java.lang.Object ref = skuId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skuId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The identifier for the SKU.
   * Example: "D041-B8A1-6E0B"
   * </pre>
   *
   * <code>string sku_id = 2;</code>
   *
   * @return The bytes for skuId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkuIdBytes() {
    java.lang.Object ref = skuId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skuId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A human readable description of the SKU, has a maximum length of 256
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human readable description of the SKU, has a maximum length of 256
   * characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CATEGORY_FIELD_NUMBER = 4;
  private com.google.cloud.billing.v1.Category category_;
  /**
   *
   *
   * <pre>
   * The category hierarchy of this SKU, purely for organizational purpose.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.Category category = 4;</code>
   *
   * @return Whether the category field is set.
   */
  @java.lang.Override
  public boolean hasCategory() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The category hierarchy of this SKU, purely for organizational purpose.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.Category category = 4;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.Category getCategory() {
    return category_ == null
        ? com.google.cloud.billing.v1.Category.getDefaultInstance()
        : category_;
  }
  /**
   *
   *
   * <pre>
   * The category hierarchy of this SKU, purely for organizational purpose.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.Category category = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.CategoryOrBuilder getCategoryOrBuilder() {
    return category_ == null
        ? com.google.cloud.billing.v1.Category.getDefaultInstance()
        : category_;
  }

  public static final int SERVICE_REGIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serviceRegions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of service regions this SKU is offered at.
   * Example: "asia-east1"
   * Service regions can be found at https://cloud.google.com/about/locations/
   * </pre>
   *
   * <code>repeated string service_regions = 5;</code>
   *
   * @return A list containing the serviceRegions.
   */
  public com.google.protobuf.ProtocolStringList getServiceRegionsList() {
    return serviceRegions_;
  }
  /**
   *
   *
   * <pre>
   * List of service regions this SKU is offered at.
   * Example: "asia-east1"
   * Service regions can be found at https://cloud.google.com/about/locations/
   * </pre>
   *
   * <code>repeated string service_regions = 5;</code>
   *
   * @return The count of serviceRegions.
   */
  public int getServiceRegionsCount() {
    return serviceRegions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of service regions this SKU is offered at.
   * Example: "asia-east1"
   * Service regions can be found at https://cloud.google.com/about/locations/
   * </pre>
   *
   * <code>repeated string service_regions = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The serviceRegions at the given index.
   */
  public java.lang.String getServiceRegions(int index) {
    return serviceRegions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of service regions this SKU is offered at.
   * Example: "asia-east1"
   * Service regions can be found at https://cloud.google.com/about/locations/
   * </pre>
   *
   * <code>repeated string service_regions = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceRegions at the given index.
   */
  public com.google.protobuf.ByteString getServiceRegionsBytes(int index) {
    return serviceRegions_.getByteString(index);
  }

  public static final int PRICING_INFO_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.billing.v1.PricingInfo> pricingInfo_;
  /**
   *
   *
   * <pre>
   * A timeline of pricing info for this SKU in chronological order.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.billing.v1.PricingInfo> getPricingInfoList() {
    return pricingInfo_;
  }
  /**
   *
   *
   * <pre>
   * A timeline of pricing info for this SKU in chronological order.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.billing.v1.PricingInfoOrBuilder>
      getPricingInfoOrBuilderList() {
    return pricingInfo_;
  }
  /**
   *
   *
   * <pre>
   * A timeline of pricing info for this SKU in chronological order.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
   */
  @java.lang.Override
  public int getPricingInfoCount() {
    return pricingInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * A timeline of pricing info for this SKU in chronological order.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingInfo getPricingInfo(int index) {
    return pricingInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A timeline of pricing info for this SKU in chronological order.
   * </pre>
   *
   * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.PricingInfoOrBuilder getPricingInfoOrBuilder(int index) {
    return pricingInfo_.get(index);
  }

  public static final int SERVICE_PROVIDER_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceProviderName_ = "";
  /**
   *
   *
   * <pre>
   * Identifies the service provider.
   * This is 'Google' for first party services in Google Cloud Platform.
   * </pre>
   *
   * <code>string service_provider_name = 7;</code>
   *
   * @return The serviceProviderName.
   */
  @java.lang.Override
  public java.lang.String getServiceProviderName() {
    java.lang.Object ref = serviceProviderName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceProviderName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifies the service provider.
   * This is 'Google' for first party services in Google Cloud Platform.
   * </pre>
   *
   * <code>string service_provider_name = 7;</code>
   *
   * @return The bytes for serviceProviderName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceProviderNameBytes() {
    java.lang.Object ref = serviceProviderName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceProviderName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GEO_TAXONOMY_FIELD_NUMBER = 8;
  private com.google.cloud.billing.v1.GeoTaxonomy geoTaxonomy_;
  /**
   *
   *
   * <pre>
   * The geographic taxonomy for this sku.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
   *
   * @return Whether the geoTaxonomy field is set.
   */
  @java.lang.Override
  public boolean hasGeoTaxonomy() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The geographic taxonomy for this sku.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
   *
   * @return The geoTaxonomy.
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.GeoTaxonomy getGeoTaxonomy() {
    return geoTaxonomy_ == null
        ? com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()
        : geoTaxonomy_;
  }
  /**
   *
   *
   * <pre>
   * The geographic taxonomy for this sku.
   * </pre>
   *
   * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.v1.GeoTaxonomyOrBuilder getGeoTaxonomyOrBuilder() {
    return geoTaxonomy_ == null
        ? com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()
        : geoTaxonomy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skuId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, skuId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCategory());
    }
    for (int i = 0; i < serviceRegions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceRegions_.getRaw(i));
    }
    for (int i = 0; i < pricingInfo_.size(); i++) {
      output.writeMessage(6, pricingInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceProviderName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceProviderName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getGeoTaxonomy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skuId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, skuId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCategory());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serviceRegions_.size(); i++) {
        dataSize += computeStringSizeNoTag(serviceRegions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServiceRegionsList().size();
    }
    for (int i = 0; i < pricingInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, pricingInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceProviderName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceProviderName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getGeoTaxonomy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.v1.Sku)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.v1.Sku other = (com.google.cloud.billing.v1.Sku) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getSkuId().equals(other.getSkuId())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCategory() != other.hasCategory()) return false;
    if (hasCategory()) {
      if (!getCategory().equals(other.getCategory())) return false;
    }
    if (!getServiceRegionsList().equals(other.getServiceRegionsList())) return false;
    if (!getPricingInfoList().equals(other.getPricingInfoList())) return false;
    if (!getServiceProviderName().equals(other.getServiceProviderName())) return false;
    if (hasGeoTaxonomy() != other.hasGeoTaxonomy()) return false;
    if (hasGeoTaxonomy()) {
      if (!getGeoTaxonomy().equals(other.getGeoTaxonomy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SKU_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSkuId().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCategory()) {
      hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
      hash = (53 * hash) + getCategory().hashCode();
    }
    if (getServiceRegionsCount() > 0) {
      hash = (37 * hash) + SERVICE_REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceRegionsList().hashCode();
    }
    if (getPricingInfoCount() > 0) {
      hash = (37 * hash) + PRICING_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPricingInfoList().hashCode();
    }
    hash = (37 * hash) + SERVICE_PROVIDER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceProviderName().hashCode();
    if (hasGeoTaxonomy()) {
      hash = (37 * hash) + GEO_TAXONOMY_FIELD_NUMBER;
      hash = (53 * hash) + getGeoTaxonomy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.Sku parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.Sku parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.v1.Sku parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.v1.Sku prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encapsulates a single SKU in Google Cloud
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.v1.Sku}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.v1.Sku)
      com.google.cloud.billing.v1.SkuOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_Sku_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_Sku_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.v1.Sku.class, com.google.cloud.billing.v1.Sku.Builder.class);
    }

    // Construct using com.google.cloud.billing.v1.Sku.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCategoryFieldBuilder();
        getPricingInfoFieldBuilder();
        getGeoTaxonomyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      skuId_ = "";
      description_ = "";
      category_ = null;
      if (categoryBuilder_ != null) {
        categoryBuilder_.dispose();
        categoryBuilder_ = null;
      }
      serviceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (pricingInfoBuilder_ == null) {
        pricingInfo_ = java.util.Collections.emptyList();
      } else {
        pricingInfo_ = null;
        pricingInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      serviceProviderName_ = "";
      geoTaxonomy_ = null;
      if (geoTaxonomyBuilder_ != null) {
        geoTaxonomyBuilder_.dispose();
        geoTaxonomyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.v1.CloudCatalogProto
          .internal_static_google_cloud_billing_v1_Sku_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.Sku getDefaultInstanceForType() {
      return com.google.cloud.billing.v1.Sku.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.Sku build() {
      com.google.cloud.billing.v1.Sku result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.v1.Sku buildPartial() {
      com.google.cloud.billing.v1.Sku result = new com.google.cloud.billing.v1.Sku(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.billing.v1.Sku result) {
      if (pricingInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          pricingInfo_ = java.util.Collections.unmodifiableList(pricingInfo_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.pricingInfo_ = pricingInfo_;
      } else {
        result.pricingInfo_ = pricingInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.billing.v1.Sku result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.skuId_ = skuId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.category_ = categoryBuilder_ == null ? category_ : categoryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        serviceRegions_.makeImmutable();
        result.serviceRegions_ = serviceRegions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceProviderName_ = serviceProviderName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.geoTaxonomy_ =
            geoTaxonomyBuilder_ == null ? geoTaxonomy_ : geoTaxonomyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.v1.Sku) {
        return mergeFrom((com.google.cloud.billing.v1.Sku) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.v1.Sku other) {
      if (other == com.google.cloud.billing.v1.Sku.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSkuId().isEmpty()) {
        skuId_ = other.skuId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCategory()) {
        mergeCategory(other.getCategory());
      }
      if (!other.serviceRegions_.isEmpty()) {
        if (serviceRegions_.isEmpty()) {
          serviceRegions_ = other.serviceRegions_;
          bitField0_ |= 0x00000010;
        } else {
          ensureServiceRegionsIsMutable();
          serviceRegions_.addAll(other.serviceRegions_);
        }
        onChanged();
      }
      if (pricingInfoBuilder_ == null) {
        if (!other.pricingInfo_.isEmpty()) {
          if (pricingInfo_.isEmpty()) {
            pricingInfo_ = other.pricingInfo_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensurePricingInfoIsMutable();
            pricingInfo_.addAll(other.pricingInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.pricingInfo_.isEmpty()) {
          if (pricingInfoBuilder_.isEmpty()) {
            pricingInfoBuilder_.dispose();
            pricingInfoBuilder_ = null;
            pricingInfo_ = other.pricingInfo_;
            bitField0_ = (bitField0_ & ~0x00000020);
            pricingInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPricingInfoFieldBuilder()
                    : null;
          } else {
            pricingInfoBuilder_.addAllMessages(other.pricingInfo_);
          }
        }
      }
      if (!other.getServiceProviderName().isEmpty()) {
        serviceProviderName_ = other.serviceProviderName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasGeoTaxonomy()) {
        mergeGeoTaxonomy(other.getGeoTaxonomy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                skuId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCategoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServiceRegionsIsMutable();
                serviceRegions_.add(s);
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.billing.v1.PricingInfo m =
                    input.readMessage(
                        com.google.cloud.billing.v1.PricingInfo.parser(), extensionRegistry);
                if (pricingInfoBuilder_ == null) {
                  ensurePricingInfoIsMutable();
                  pricingInfo_.add(m);
                } else {
                  pricingInfoBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                serviceProviderName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getGeoTaxonomyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name for the SKU.
     * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the SKU.
     * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name for the SKU.
     * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the SKU.
     * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name for the SKU.
     * Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object skuId_ = "";
    /**
     *
     *
     * <pre>
     * The identifier for the SKU.
     * Example: "D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string sku_id = 2;</code>
     *
     * @return The skuId.
     */
    public java.lang.String getSkuId() {
      java.lang.Object ref = skuId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skuId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier for the SKU.
     * Example: "D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string sku_id = 2;</code>
     *
     * @return The bytes for skuId.
     */
    public com.google.protobuf.ByteString getSkuIdBytes() {
      java.lang.Object ref = skuId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skuId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The identifier for the SKU.
     * Example: "D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string sku_id = 2;</code>
     *
     * @param value The skuId to set.
     * @return This builder for chaining.
     */
    public Builder setSkuId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skuId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier for the SKU.
     * Example: "D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string sku_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkuId() {
      skuId_ = getDefaultInstance().getSkuId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier for the SKU.
     * Example: "D041-B8A1-6E0B"
     * </pre>
     *
     * <code>string sku_id = 2;</code>
     *
     * @param value The bytes for skuId to set.
     * @return This builder for chaining.
     */
    public Builder setSkuIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skuId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human readable description of the SKU, has a maximum length of 256
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable description of the SKU, has a maximum length of 256
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable description of the SKU, has a maximum length of 256
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable description of the SKU, has a maximum length of 256
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human readable description of the SKU, has a maximum length of 256
     * characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.billing.v1.Category category_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.Category,
            com.google.cloud.billing.v1.Category.Builder,
            com.google.cloud.billing.v1.CategoryOrBuilder>
        categoryBuilder_;
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     *
     * @return Whether the category field is set.
     */
    public boolean hasCategory() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     *
     * @return The category.
     */
    public com.google.cloud.billing.v1.Category getCategory() {
      if (categoryBuilder_ == null) {
        return category_ == null
            ? com.google.cloud.billing.v1.Category.getDefaultInstance()
            : category_;
      } else {
        return categoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public Builder setCategory(com.google.cloud.billing.v1.Category value) {
      if (categoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        category_ = value;
      } else {
        categoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public Builder setCategory(com.google.cloud.billing.v1.Category.Builder builderForValue) {
      if (categoryBuilder_ == null) {
        category_ = builderForValue.build();
      } else {
        categoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public Builder mergeCategory(com.google.cloud.billing.v1.Category value) {
      if (categoryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && category_ != null
            && category_ != com.google.cloud.billing.v1.Category.getDefaultInstance()) {
          getCategoryBuilder().mergeFrom(value);
        } else {
          category_ = value;
        }
      } else {
        categoryBuilder_.mergeFrom(value);
      }
      if (category_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public Builder clearCategory() {
      bitField0_ = (bitField0_ & ~0x00000008);
      category_ = null;
      if (categoryBuilder_ != null) {
        categoryBuilder_.dispose();
        categoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public com.google.cloud.billing.v1.Category.Builder getCategoryBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCategoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    public com.google.cloud.billing.v1.CategoryOrBuilder getCategoryOrBuilder() {
      if (categoryBuilder_ != null) {
        return categoryBuilder_.getMessageOrBuilder();
      } else {
        return category_ == null
            ? com.google.cloud.billing.v1.Category.getDefaultInstance()
            : category_;
      }
    }
    /**
     *
     *
     * <pre>
     * The category hierarchy of this SKU, purely for organizational purpose.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.Category category = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.Category,
            com.google.cloud.billing.v1.Category.Builder,
            com.google.cloud.billing.v1.CategoryOrBuilder>
        getCategoryFieldBuilder() {
      if (categoryBuilder_ == null) {
        categoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.v1.Category,
                com.google.cloud.billing.v1.Category.Builder,
                com.google.cloud.billing.v1.CategoryOrBuilder>(
                getCategory(), getParentForChildren(), isClean());
        category_ = null;
      }
      return categoryBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList serviceRegions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServiceRegionsIsMutable() {
      if (!serviceRegions_.isModifiable()) {
        serviceRegions_ = new com.google.protobuf.LazyStringArrayList(serviceRegions_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @return A list containing the serviceRegions.
     */
    public com.google.protobuf.ProtocolStringList getServiceRegionsList() {
      serviceRegions_.makeImmutable();
      return serviceRegions_;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @return The count of serviceRegions.
     */
    public int getServiceRegionsCount() {
      return serviceRegions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The serviceRegions at the given index.
     */
    public java.lang.String getServiceRegions(int index) {
      return serviceRegions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the serviceRegions at the given index.
     */
    public com.google.protobuf.ByteString getServiceRegionsBytes(int index) {
      return serviceRegions_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The serviceRegions to set.
     * @return This builder for chaining.
     */
    public Builder setServiceRegions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceRegionsIsMutable();
      serviceRegions_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param value The serviceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addServiceRegions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServiceRegionsIsMutable();
      serviceRegions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param values The serviceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllServiceRegions(java.lang.Iterable<java.lang.String> values) {
      ensureServiceRegionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceRegions_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceRegions() {
      serviceRegions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of service regions this SKU is offered at.
     * Example: "asia-east1"
     * Service regions can be found at https://cloud.google.com/about/locations/
     * </pre>
     *
     * <code>repeated string service_regions = 5;</code>
     *
     * @param value The bytes of the serviceRegions to add.
     * @return This builder for chaining.
     */
    public Builder addServiceRegionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServiceRegionsIsMutable();
      serviceRegions_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.billing.v1.PricingInfo> pricingInfo_ =
        java.util.Collections.emptyList();

    private void ensurePricingInfoIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        pricingInfo_ =
            new java.util.ArrayList<com.google.cloud.billing.v1.PricingInfo>(pricingInfo_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.v1.PricingInfo,
            com.google.cloud.billing.v1.PricingInfo.Builder,
            com.google.cloud.billing.v1.PricingInfoOrBuilder>
        pricingInfoBuilder_;

    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public java.util.List<com.google.cloud.billing.v1.PricingInfo> getPricingInfoList() {
      if (pricingInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pricingInfo_);
      } else {
        return pricingInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public int getPricingInfoCount() {
      if (pricingInfoBuilder_ == null) {
        return pricingInfo_.size();
      } else {
        return pricingInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public com.google.cloud.billing.v1.PricingInfo getPricingInfo(int index) {
      if (pricingInfoBuilder_ == null) {
        return pricingInfo_.get(index);
      } else {
        return pricingInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder setPricingInfo(int index, com.google.cloud.billing.v1.PricingInfo value) {
      if (pricingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricingInfoIsMutable();
        pricingInfo_.set(index, value);
        onChanged();
      } else {
        pricingInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder setPricingInfo(
        int index, com.google.cloud.billing.v1.PricingInfo.Builder builderForValue) {
      if (pricingInfoBuilder_ == null) {
        ensurePricingInfoIsMutable();
        pricingInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        pricingInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder addPricingInfo(com.google.cloud.billing.v1.PricingInfo value) {
      if (pricingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricingInfoIsMutable();
        pricingInfo_.add(value);
        onChanged();
      } else {
        pricingInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder addPricingInfo(int index, com.google.cloud.billing.v1.PricingInfo value) {
      if (pricingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePricingInfoIsMutable();
        pricingInfo_.add(index, value);
        onChanged();
      } else {
        pricingInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder addPricingInfo(com.google.cloud.billing.v1.PricingInfo.Builder builderForValue) {
      if (pricingInfoBuilder_ == null) {
        ensurePricingInfoIsMutable();
        pricingInfo_.add(builderForValue.build());
        onChanged();
      } else {
        pricingInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder addPricingInfo(
        int index, com.google.cloud.billing.v1.PricingInfo.Builder builderForValue) {
      if (pricingInfoBuilder_ == null) {
        ensurePricingInfoIsMutable();
        pricingInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        pricingInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder addAllPricingInfo(
        java.lang.Iterable<? extends com.google.cloud.billing.v1.PricingInfo> values) {
      if (pricingInfoBuilder_ == null) {
        ensurePricingInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pricingInfo_);
        onChanged();
      } else {
        pricingInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder clearPricingInfo() {
      if (pricingInfoBuilder_ == null) {
        pricingInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        pricingInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public Builder removePricingInfo(int index) {
      if (pricingInfoBuilder_ == null) {
        ensurePricingInfoIsMutable();
        pricingInfo_.remove(index);
        onChanged();
      } else {
        pricingInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public com.google.cloud.billing.v1.PricingInfo.Builder getPricingInfoBuilder(int index) {
      return getPricingInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public com.google.cloud.billing.v1.PricingInfoOrBuilder getPricingInfoOrBuilder(int index) {
      if (pricingInfoBuilder_ == null) {
        return pricingInfo_.get(index);
      } else {
        return pricingInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.billing.v1.PricingInfoOrBuilder>
        getPricingInfoOrBuilderList() {
      if (pricingInfoBuilder_ != null) {
        return pricingInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pricingInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public com.google.cloud.billing.v1.PricingInfo.Builder addPricingInfoBuilder() {
      return getPricingInfoFieldBuilder()
          .addBuilder(com.google.cloud.billing.v1.PricingInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public com.google.cloud.billing.v1.PricingInfo.Builder addPricingInfoBuilder(int index) {
      return getPricingInfoFieldBuilder()
          .addBuilder(index, com.google.cloud.billing.v1.PricingInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A timeline of pricing info for this SKU in chronological order.
     * </pre>
     *
     * <code>repeated .google.cloud.billing.v1.PricingInfo pricing_info = 6;</code>
     */
    public java.util.List<com.google.cloud.billing.v1.PricingInfo.Builder>
        getPricingInfoBuilderList() {
      return getPricingInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.v1.PricingInfo,
            com.google.cloud.billing.v1.PricingInfo.Builder,
            com.google.cloud.billing.v1.PricingInfoOrBuilder>
        getPricingInfoFieldBuilder() {
      if (pricingInfoBuilder_ == null) {
        pricingInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.billing.v1.PricingInfo,
                com.google.cloud.billing.v1.PricingInfo.Builder,
                com.google.cloud.billing.v1.PricingInfoOrBuilder>(
                pricingInfo_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        pricingInfo_ = null;
      }
      return pricingInfoBuilder_;
    }

    private java.lang.Object serviceProviderName_ = "";
    /**
     *
     *
     * <pre>
     * Identifies the service provider.
     * This is 'Google' for first party services in Google Cloud Platform.
     * </pre>
     *
     * <code>string service_provider_name = 7;</code>
     *
     * @return The serviceProviderName.
     */
    public java.lang.String getServiceProviderName() {
      java.lang.Object ref = serviceProviderName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceProviderName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the service provider.
     * This is 'Google' for first party services in Google Cloud Platform.
     * </pre>
     *
     * <code>string service_provider_name = 7;</code>
     *
     * @return The bytes for serviceProviderName.
     */
    public com.google.protobuf.ByteString getServiceProviderNameBytes() {
      java.lang.Object ref = serviceProviderName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceProviderName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the service provider.
     * This is 'Google' for first party services in Google Cloud Platform.
     * </pre>
     *
     * <code>string service_provider_name = 7;</code>
     *
     * @param value The serviceProviderName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceProviderName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceProviderName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the service provider.
     * This is 'Google' for first party services in Google Cloud Platform.
     * </pre>
     *
     * <code>string service_provider_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceProviderName() {
      serviceProviderName_ = getDefaultInstance().getServiceProviderName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the service provider.
     * This is 'Google' for first party services in Google Cloud Platform.
     * </pre>
     *
     * <code>string service_provider_name = 7;</code>
     *
     * @param value The bytes for serviceProviderName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceProviderNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceProviderName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.billing.v1.GeoTaxonomy geoTaxonomy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.GeoTaxonomy,
            com.google.cloud.billing.v1.GeoTaxonomy.Builder,
            com.google.cloud.billing.v1.GeoTaxonomyOrBuilder>
        geoTaxonomyBuilder_;
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     *
     * @return Whether the geoTaxonomy field is set.
     */
    public boolean hasGeoTaxonomy() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     *
     * @return The geoTaxonomy.
     */
    public com.google.cloud.billing.v1.GeoTaxonomy getGeoTaxonomy() {
      if (geoTaxonomyBuilder_ == null) {
        return geoTaxonomy_ == null
            ? com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()
            : geoTaxonomy_;
      } else {
        return geoTaxonomyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public Builder setGeoTaxonomy(com.google.cloud.billing.v1.GeoTaxonomy value) {
      if (geoTaxonomyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geoTaxonomy_ = value;
      } else {
        geoTaxonomyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public Builder setGeoTaxonomy(com.google.cloud.billing.v1.GeoTaxonomy.Builder builderForValue) {
      if (geoTaxonomyBuilder_ == null) {
        geoTaxonomy_ = builderForValue.build();
      } else {
        geoTaxonomyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public Builder mergeGeoTaxonomy(com.google.cloud.billing.v1.GeoTaxonomy value) {
      if (geoTaxonomyBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && geoTaxonomy_ != null
            && geoTaxonomy_ != com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()) {
          getGeoTaxonomyBuilder().mergeFrom(value);
        } else {
          geoTaxonomy_ = value;
        }
      } else {
        geoTaxonomyBuilder_.mergeFrom(value);
      }
      if (geoTaxonomy_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public Builder clearGeoTaxonomy() {
      bitField0_ = (bitField0_ & ~0x00000080);
      geoTaxonomy_ = null;
      if (geoTaxonomyBuilder_ != null) {
        geoTaxonomyBuilder_.dispose();
        geoTaxonomyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public com.google.cloud.billing.v1.GeoTaxonomy.Builder getGeoTaxonomyBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getGeoTaxonomyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    public com.google.cloud.billing.v1.GeoTaxonomyOrBuilder getGeoTaxonomyOrBuilder() {
      if (geoTaxonomyBuilder_ != null) {
        return geoTaxonomyBuilder_.getMessageOrBuilder();
      } else {
        return geoTaxonomy_ == null
            ? com.google.cloud.billing.v1.GeoTaxonomy.getDefaultInstance()
            : geoTaxonomy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The geographic taxonomy for this sku.
     * </pre>
     *
     * <code>.google.cloud.billing.v1.GeoTaxonomy geo_taxonomy = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.v1.GeoTaxonomy,
            com.google.cloud.billing.v1.GeoTaxonomy.Builder,
            com.google.cloud.billing.v1.GeoTaxonomyOrBuilder>
        getGeoTaxonomyFieldBuilder() {
      if (geoTaxonomyBuilder_ == null) {
        geoTaxonomyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.v1.GeoTaxonomy,
                com.google.cloud.billing.v1.GeoTaxonomy.Builder,
                com.google.cloud.billing.v1.GeoTaxonomyOrBuilder>(
                getGeoTaxonomy(), getParentForChildren(), isClean());
        geoTaxonomy_ = null;
      }
      return geoTaxonomyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.v1.Sku)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.v1.Sku)
  private static final com.google.cloud.billing.v1.Sku DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.v1.Sku();
  }

  public static com.google.cloud.billing.v1.Sku getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Sku> PARSER =
      new com.google.protobuf.AbstractParser<Sku>() {
        @java.lang.Override
        public Sku parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Sku> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Sku> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.v1.Sku getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
