/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package com.google.cloud.billing.budgets.v1beta1;

/**
 *
 *
 * <pre>
 * AllUpdatesRule defines notifications that are sent based on budget spend
 * and thresholds.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.budgets.v1beta1.AllUpdatesRule}
 */
public final class AllUpdatesRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.budgets.v1beta1.AllUpdatesRule)
    AllUpdatesRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AllUpdatesRule.newBuilder() to construct.
  private AllUpdatesRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AllUpdatesRule() {
    pubsubTopic_ = "";
    schemaVersion_ = "";
    monitoringNotificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AllUpdatesRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_AllUpdatesRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_AllUpdatesRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.class,
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder.class);
  }

  public static final int PUBSUB_TOPIC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pubsubTopic_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the Pub/Sub topic where budget related messages will
   * be published, in the form `projects/{project_id}/topics/{topic_id}`.
   * Updates are sent at regular intervals to the topic. The topic needs to be
   * created before the budget is created; see
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
   * for more details.
   * Caller is expected to have
   * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
   * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
   * for more details on Pub/Sub roles and permissions.
   * </pre>
   *
   * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubsubTopic() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubsubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the Pub/Sub topic where budget related messages will
   * be published, in the form `projects/{project_id}/topics/{topic_id}`.
   * Updates are sent at regular intervals to the topic. The topic needs to be
   * created before the budget is created; see
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
   * for more details.
   * Caller is expected to have
   * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
   * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
   * for more details on Pub/Sub roles and permissions.
   * </pre>
   *
   * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubsubTopicBytes() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_VERSION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schemaVersion_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Required when
   * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
   * is set. The schema version of the notification sent to
   * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
   * Only "1.0" is accepted. It represents the JSON schema as defined in
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
   * </pre>
   *
   * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The schemaVersion.
   */
  @java.lang.Override
  public java.lang.String getSchemaVersion() {
    java.lang.Object ref = schemaVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schemaVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Required when
   * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
   * is set. The schema version of the notification sent to
   * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
   * Only "1.0" is accepted. It represents the JSON schema as defined in
   * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
   * </pre>
   *
   * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for schemaVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSchemaVersionBytes() {
    java.lang.Object ref = schemaVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schemaVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORING_NOTIFICATION_CHANNELS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList monitoringNotificationChannels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Targets to send notifications to when a threshold is exceeded.
   * This is in addition to default recipients who have billing account IAM
   * roles. The value is the full REST resource name of a monitoring
   * notification channel with the form
   * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
   * channels are allowed. See
   * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
   * for more details.
   * </pre>
   *
   * <code>
   * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the monitoringNotificationChannels.
   */
  public com.google.protobuf.ProtocolStringList getMonitoringNotificationChannelsList() {
    return monitoringNotificationChannels_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Targets to send notifications to when a threshold is exceeded.
   * This is in addition to default recipients who have billing account IAM
   * roles. The value is the full REST resource name of a monitoring
   * notification channel with the form
   * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
   * channels are allowed. See
   * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
   * for more details.
   * </pre>
   *
   * <code>
   * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of monitoringNotificationChannels.
   */
  public int getMonitoringNotificationChannelsCount() {
    return monitoringNotificationChannels_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Targets to send notifications to when a threshold is exceeded.
   * This is in addition to default recipients who have billing account IAM
   * roles. The value is the full REST resource name of a monitoring
   * notification channel with the form
   * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
   * channels are allowed. See
   * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
   * for more details.
   * </pre>
   *
   * <code>
   * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The monitoringNotificationChannels at the given index.
   */
  public java.lang.String getMonitoringNotificationChannels(int index) {
    return monitoringNotificationChannels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Targets to send notifications to when a threshold is exceeded.
   * This is in addition to default recipients who have billing account IAM
   * roles. The value is the full REST resource name of a monitoring
   * notification channel with the form
   * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
   * channels are allowed. See
   * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
   * for more details.
   * </pre>
   *
   * <code>
   * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the monitoringNotificationChannels at the given index.
   */
  public com.google.protobuf.ByteString getMonitoringNotificationChannelsBytes(int index) {
    return monitoringNotificationChannels_.getByteString(index);
  }

  public static final int DISABLE_DEFAULT_IAM_RECIPIENTS_FIELD_NUMBER = 4;
  private boolean disableDefaultIamRecipients_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When set to true, disables default notifications sent when a
   * threshold is exceeded. Default notifications are sent to those with Billing
   * Account Administrator and Billing Account User IAM roles for the target
   * account.
   * </pre>
   *
   * <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableDefaultIamRecipients.
   */
  @java.lang.Override
  public boolean getDisableDefaultIamRecipients() {
    return disableDefaultIamRecipients_;
  }

  public static final int ENABLE_PROJECT_LEVEL_RECIPIENTS_FIELD_NUMBER = 5;
  private boolean enableProjectLevelRecipients_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When set to true, and when the budget has a single project
   * configured, notifications will be sent to project level recipients of that
   * project. This field will be ignored if the budget has multiple or no
   * project configured.
   *
   * Currently, project level recipients are the users with `Owner` role on a
   * cloud project.
   * </pre>
   *
   * <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enableProjectLevelRecipients.
   */
  @java.lang.Override
  public boolean getEnableProjectLevelRecipients() {
    return enableProjectLevelRecipients_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaVersion_);
    }
    for (int i = 0; i < monitoringNotificationChannels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, monitoringNotificationChannels_.getRaw(i));
    }
    if (disableDefaultIamRecipients_ != false) {
      output.writeBool(4, disableDefaultIamRecipients_);
    }
    if (enableProjectLevelRecipients_ != false) {
      output.writeBool(5, enableProjectLevelRecipients_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pubsubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaVersion_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < monitoringNotificationChannels_.size(); i++) {
        dataSize += computeStringSizeNoTag(monitoringNotificationChannels_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMonitoringNotificationChannelsList().size();
    }
    if (disableDefaultIamRecipients_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(4, disableDefaultIamRecipients_);
    }
    if (enableProjectLevelRecipients_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableProjectLevelRecipients_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule other =
        (com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule) obj;

    if (!getPubsubTopic().equals(other.getPubsubTopic())) return false;
    if (!getSchemaVersion().equals(other.getSchemaVersion())) return false;
    if (!getMonitoringNotificationChannelsList()
        .equals(other.getMonitoringNotificationChannelsList())) return false;
    if (getDisableDefaultIamRecipients() != other.getDisableDefaultIamRecipients()) return false;
    if (getEnableProjectLevelRecipients() != other.getEnableProjectLevelRecipients()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubsubTopic().hashCode();
    hash = (37 * hash) + SCHEMA_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getSchemaVersion().hashCode();
    if (getMonitoringNotificationChannelsCount() > 0) {
      hash = (37 * hash) + MONITORING_NOTIFICATION_CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoringNotificationChannelsList().hashCode();
    }
    hash = (37 * hash) + DISABLE_DEFAULT_IAM_RECIPIENTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableDefaultIamRecipients());
    hash = (37 * hash) + ENABLE_PROJECT_LEVEL_RECIPIENTS_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableProjectLevelRecipients());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AllUpdatesRule defines notifications that are sent based on budget spend
   * and thresholds.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.budgets.v1beta1.AllUpdatesRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.budgets.v1beta1.AllUpdatesRule)
      com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_AllUpdatesRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_AllUpdatesRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.class,
              com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder.class);
    }

    // Construct using com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pubsubTopic_ = "";
      schemaVersion_ = "";
      monitoringNotificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      disableDefaultIamRecipients_ = false;
      enableProjectLevelRecipients_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_AllUpdatesRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule getDefaultInstanceForType() {
      return com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule build() {
      com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule buildPartial() {
      com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule result =
          new com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pubsubTopic_ = pubsubTopic_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.schemaVersion_ = schemaVersion_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        monitoringNotificationChannels_.makeImmutable();
        result.monitoringNotificationChannels_ = monitoringNotificationChannels_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.disableDefaultIamRecipients_ = disableDefaultIamRecipients_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableProjectLevelRecipients_ = enableProjectLevelRecipients_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule) {
        return mergeFrom((com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule other) {
      if (other == com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance())
        return this;
      if (!other.getPubsubTopic().isEmpty()) {
        pubsubTopic_ = other.pubsubTopic_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSchemaVersion().isEmpty()) {
        schemaVersion_ = other.schemaVersion_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.monitoringNotificationChannels_.isEmpty()) {
        if (monitoringNotificationChannels_.isEmpty()) {
          monitoringNotificationChannels_ = other.monitoringNotificationChannels_;
          bitField0_ |= 0x00000004;
        } else {
          ensureMonitoringNotificationChannelsIsMutable();
          monitoringNotificationChannels_.addAll(other.monitoringNotificationChannels_);
        }
        onChanged();
      }
      if (other.getDisableDefaultIamRecipients() != false) {
        setDisableDefaultIamRecipients(other.getDisableDefaultIamRecipients());
      }
      if (other.getEnableProjectLevelRecipients() != false) {
        setEnableProjectLevelRecipients(other.getEnableProjectLevelRecipients());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                schemaVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMonitoringNotificationChannelsIsMutable();
                monitoringNotificationChannels_.add(s);
                break;
              } // case 26
            case 32:
              {
                disableDefaultIamRecipients_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                enableProjectLevelRecipients_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object pubsubTopic_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the Pub/Sub topic where budget related messages will
     * be published, in the form `projects/{project_id}/topics/{topic_id}`.
     * Updates are sent at regular intervals to the topic. The topic needs to be
     * created before the budget is created; see
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
     * for more details.
     * Caller is expected to have
     * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
     * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
     * for more details on Pub/Sub roles and permissions.
     * </pre>
     *
     * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pubsubTopic.
     */
    public java.lang.String getPubsubTopic() {
      java.lang.Object ref = pubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Pub/Sub topic where budget related messages will
     * be published, in the form `projects/{project_id}/topics/{topic_id}`.
     * Updates are sent at regular intervals to the topic. The topic needs to be
     * created before the budget is created; see
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
     * for more details.
     * Caller is expected to have
     * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
     * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
     * for more details on Pub/Sub roles and permissions.
     * </pre>
     *
     * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pubsubTopic.
     */
    public com.google.protobuf.ByteString getPubsubTopicBytes() {
      java.lang.Object ref = pubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Pub/Sub topic where budget related messages will
     * be published, in the form `projects/{project_id}/topics/{topic_id}`.
     * Updates are sent at regular intervals to the topic. The topic needs to be
     * created before the budget is created; see
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
     * for more details.
     * Caller is expected to have
     * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
     * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
     * for more details on Pub/Sub roles and permissions.
     * </pre>
     *
     * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pubsubTopic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Pub/Sub topic where budget related messages will
     * be published, in the form `projects/{project_id}/topics/{topic_id}`.
     * Updates are sent at regular intervals to the topic. The topic needs to be
     * created before the budget is created; see
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
     * for more details.
     * Caller is expected to have
     * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
     * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
     * for more details on Pub/Sub roles and permissions.
     * </pre>
     *
     * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubsubTopic() {
      pubsubTopic_ = getDefaultInstance().getPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the Pub/Sub topic where budget related messages will
     * be published, in the form `projects/{project_id}/topics/{topic_id}`.
     * Updates are sent at regular intervals to the topic. The topic needs to be
     * created before the budget is created; see
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications
     * for more details.
     * Caller is expected to have
     * `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
     * budget, otherwise, the API call will fail with PERMISSION_DENIED. See
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task
     * for more details on Pub/Sub roles and permissions.
     * </pre>
     *
     * <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pubsubTopic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object schemaVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Required when
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     * </pre>
     *
     * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The schemaVersion.
     */
    public java.lang.String getSchemaVersion() {
      java.lang.Object ref = schemaVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     * </pre>
     *
     * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for schemaVersion.
     */
    public com.google.protobuf.ByteString getSchemaVersionBytes() {
      java.lang.Object ref = schemaVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     * </pre>
     *
     * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The schemaVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     * </pre>
     *
     * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchemaVersion() {
      schemaVersion_ = getDefaultInstance().getSchemaVersion();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [AllUpdatesRule.pubsub_topic][google.cloud.billing.budgets.v1beta1.AllUpdatesRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     * </pre>
     *
     * <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for schemaVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSchemaVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaVersion_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList monitoringNotificationChannels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMonitoringNotificationChannelsIsMutable() {
      if (!monitoringNotificationChannels_.isModifiable()) {
        monitoringNotificationChannels_ =
            new com.google.protobuf.LazyStringArrayList(monitoringNotificationChannels_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the monitoringNotificationChannels.
     */
    public com.google.protobuf.ProtocolStringList getMonitoringNotificationChannelsList() {
      monitoringNotificationChannels_.makeImmutable();
      return monitoringNotificationChannels_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of monitoringNotificationChannels.
     */
    public int getMonitoringNotificationChannelsCount() {
      return monitoringNotificationChannels_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The monitoringNotificationChannels at the given index.
     */
    public java.lang.String getMonitoringNotificationChannels(int index) {
      return monitoringNotificationChannels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the monitoringNotificationChannels at the given index.
     */
    public com.google.protobuf.ByteString getMonitoringNotificationChannelsBytes(int index) {
      return monitoringNotificationChannels_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The monitoringNotificationChannels to set.
     * @return This builder for chaining.
     */
    public Builder setMonitoringNotificationChannels(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMonitoringNotificationChannelsIsMutable();
      monitoringNotificationChannels_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The monitoringNotificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addMonitoringNotificationChannels(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMonitoringNotificationChannelsIsMutable();
      monitoringNotificationChannels_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The monitoringNotificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addAllMonitoringNotificationChannels(
        java.lang.Iterable<java.lang.String> values) {
      ensureMonitoringNotificationChannelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, monitoringNotificationChannels_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMonitoringNotificationChannels() {
      monitoringNotificationChannels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Targets to send notifications to when a threshold is exceeded.
     * This is in addition to default recipients who have billing account IAM
     * roles. The value is the full REST resource name of a monitoring
     * notification channel with the form
     * `projects/{project_id}/notificationChannels/{channel_id}`. A maximum of 5
     * channels are allowed. See
     * https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients
     * for more details.
     * </pre>
     *
     * <code>
     * repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the monitoringNotificationChannels to add.
     * @return This builder for chaining.
     */
    public Builder addMonitoringNotificationChannelsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMonitoringNotificationChannelsIsMutable();
      monitoringNotificationChannels_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean disableDefaultIamRecipients_;
    /**
     *
     *
     * <pre>
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     * </pre>
     *
     * <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The disableDefaultIamRecipients.
     */
    @java.lang.Override
    public boolean getDisableDefaultIamRecipients() {
      return disableDefaultIamRecipients_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     * </pre>
     *
     * <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The disableDefaultIamRecipients to set.
     * @return This builder for chaining.
     */
    public Builder setDisableDefaultIamRecipients(boolean value) {

      disableDefaultIamRecipients_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     * </pre>
     *
     * <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableDefaultIamRecipients() {
      bitField0_ = (bitField0_ & ~0x00000008);
      disableDefaultIamRecipients_ = false;
      onChanged();
      return this;
    }

    private boolean enableProjectLevelRecipients_;
    /**
     *
     *
     * <pre>
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     *
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     * </pre>
     *
     * <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableProjectLevelRecipients.
     */
    @java.lang.Override
    public boolean getEnableProjectLevelRecipients() {
      return enableProjectLevelRecipients_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     *
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     * </pre>
     *
     * <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enableProjectLevelRecipients to set.
     * @return This builder for chaining.
     */
    public Builder setEnableProjectLevelRecipients(boolean value) {

      enableProjectLevelRecipients_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     *
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     * </pre>
     *
     * <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableProjectLevelRecipients() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableProjectLevelRecipients_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.budgets.v1beta1.AllUpdatesRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.budgets.v1beta1.AllUpdatesRule)
  private static final com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule();
  }

  public static com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AllUpdatesRule> PARSER =
      new com.google.protobuf.AbstractParser<AllUpdatesRule>() {
        @java.lang.Override
        public AllUpdatesRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AllUpdatesRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AllUpdatesRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
