/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package com.google.cloud.billing.budgets.v1beta1;

/**
 *
 *
 * <pre>
 * A budget is a plan that describes what you expect to spend on Cloud
 * projects, plus the rules to execute as spend is tracked against that plan,
 * (for example, send an alert when 90% of the target spend is met).
 * The budget time period is configurable, with options such as month (default),
 * quarter, year, or custom time period.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.budgets.v1beta1.Budget}
 */
public final class Budget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.budgets.v1beta1.Budget)
    BudgetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Budget.newBuilder() to construct.
  private Budget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Budget() {
    name_ = "";
    displayName_ = "";
    thresholdRules_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Budget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_Budget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_Budget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.budgets.v1beta1.Budget.class,
            com.google.cloud.billing.budgets.v1beta1.Budget.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the budget.
   * The resource name implies the scope of a budget. Values are of the form
   * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the budget.
   * The resource name implies the scope of a budget. Values are of the form
   * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User data for display name in UI.
   * Validation: &lt;= 60 chars.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User data for display name in UI.
   * Validation: &lt;= 60 chars.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUDGET_FILTER_FIELD_NUMBER = 3;
  private com.google.cloud.billing.budgets.v1beta1.Filter budgetFilter_;
  /**
   *
   *
   * <pre>
   * Optional. Filters that define which resources are used to compute the
   * actual spend against the budget amount, such as projects, services, and the
   * budget's time period, as well as other filters.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the budgetFilter field is set.
   */
  @java.lang.Override
  public boolean hasBudgetFilter() {
    return budgetFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filters that define which resources are used to compute the
   * actual spend against the budget amount, such as projects, services, and the
   * budget's time period, as well as other filters.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The budgetFilter.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.Filter getBudgetFilter() {
    return budgetFilter_ == null
        ? com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance()
        : budgetFilter_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Filters that define which resources are used to compute the
   * actual spend against the budget amount, such as projects, services, and the
   * budget's time period, as well as other filters.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder getBudgetFilterOrBuilder() {
    return budgetFilter_ == null
        ? com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance()
        : budgetFilter_;
  }

  public static final int AMOUNT_FIELD_NUMBER = 4;
  private com.google.cloud.billing.budgets.v1beta1.BudgetAmount amount_;
  /**
   *
   *
   * <pre>
   * Required. Budgeted amount.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the amount field is set.
   */
  @java.lang.Override
  public boolean hasAmount() {
    return amount_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Budgeted amount.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The amount.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.BudgetAmount getAmount() {
    return amount_ == null
        ? com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance()
        : amount_;
  }
  /**
   *
   *
   * <pre>
   * Required. Budgeted amount.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder getAmountOrBuilder() {
    return amount_ == null
        ? com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance()
        : amount_;
  }

  public static final int THRESHOLD_RULES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.billing.budgets.v1beta1.ThresholdRule> thresholdRules_;
  /**
   *
   *
   * <pre>
   * Optional. Rules that trigger alerts (notifications of thresholds
   * being crossed) when spend exceeds the specified percentages of the budget.
   *
   * Optional for `pubsubTopic` notifications.
   *
   * Required if using email notifications.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.billing.budgets.v1beta1.ThresholdRule>
      getThresholdRulesList() {
    return thresholdRules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules that trigger alerts (notifications of thresholds
   * being crossed) when spend exceeds the specified percentages of the budget.
   *
   * Optional for `pubsubTopic` notifications.
   *
   * Required if using email notifications.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder>
      getThresholdRulesOrBuilderList() {
    return thresholdRules_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules that trigger alerts (notifications of thresholds
   * being crossed) when spend exceeds the specified percentages of the budget.
   *
   * Optional for `pubsubTopic` notifications.
   *
   * Required if using email notifications.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getThresholdRulesCount() {
    return thresholdRules_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules that trigger alerts (notifications of thresholds
   * being crossed) when spend exceeds the specified percentages of the budget.
   *
   * Optional for `pubsubTopic` notifications.
   *
   * Required if using email notifications.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.ThresholdRule getThresholdRules(int index) {
    return thresholdRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules that trigger alerts (notifications of thresholds
   * being crossed) when spend exceeds the specified percentages of the budget.
   *
   * Optional for `pubsubTopic` notifications.
   *
   * Required if using email notifications.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder getThresholdRulesOrBuilder(
      int index) {
    return thresholdRules_.get(index);
  }

  public static final int ALL_UPDATES_RULE_FIELD_NUMBER = 6;
  private com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule allUpdatesRule_;
  /**
   *
   *
   * <pre>
   * Optional. Rules to apply to notifications sent based on budget spend and
   * thresholds.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the allUpdatesRule field is set.
   */
  @java.lang.Override
  public boolean hasAllUpdatesRule() {
    return allUpdatesRule_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules to apply to notifications sent based on budget spend and
   * thresholds.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The allUpdatesRule.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule getAllUpdatesRule() {
    return allUpdatesRule_ == null
        ? com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance()
        : allUpdatesRule_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rules to apply to notifications sent based on budget spend and
   * thresholds.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder
      getAllUpdatesRuleOrBuilder() {
    return allUpdatesRule_ == null
        ? com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance()
        : allUpdatesRule_;
  }

  public static final int ETAG_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Etag to validate that the object is unchanged for a
   * read-modify-write operation.
   * An empty etag will cause an update to overwrite other changes.
   * </pre>
   *
   * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Etag to validate that the object is unchanged for a
   * read-modify-write operation.
   * An empty etag will cause an update to overwrite other changes.
   * </pre>
   *
   * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (budgetFilter_ != null) {
      output.writeMessage(3, getBudgetFilter());
    }
    if (amount_ != null) {
      output.writeMessage(4, getAmount());
    }
    for (int i = 0; i < thresholdRules_.size(); i++) {
      output.writeMessage(5, thresholdRules_.get(i));
    }
    if (allUpdatesRule_ != null) {
      output.writeMessage(6, getAllUpdatesRule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (budgetFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBudgetFilter());
    }
    if (amount_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAmount());
    }
    for (int i = 0; i < thresholdRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, thresholdRules_.get(i));
    }
    if (allUpdatesRule_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAllUpdatesRule());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.budgets.v1beta1.Budget)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.budgets.v1beta1.Budget other =
        (com.google.cloud.billing.budgets.v1beta1.Budget) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasBudgetFilter() != other.hasBudgetFilter()) return false;
    if (hasBudgetFilter()) {
      if (!getBudgetFilter().equals(other.getBudgetFilter())) return false;
    }
    if (hasAmount() != other.hasAmount()) return false;
    if (hasAmount()) {
      if (!getAmount().equals(other.getAmount())) return false;
    }
    if (!getThresholdRulesList().equals(other.getThresholdRulesList())) return false;
    if (hasAllUpdatesRule() != other.hasAllUpdatesRule()) return false;
    if (hasAllUpdatesRule()) {
      if (!getAllUpdatesRule().equals(other.getAllUpdatesRule())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasBudgetFilter()) {
      hash = (37 * hash) + BUDGET_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getBudgetFilter().hashCode();
    }
    if (hasAmount()) {
      hash = (37 * hash) + AMOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getAmount().hashCode();
    }
    if (getThresholdRulesCount() > 0) {
      hash = (37 * hash) + THRESHOLD_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getThresholdRulesList().hashCode();
    }
    if (hasAllUpdatesRule()) {
      hash = (37 * hash) + ALL_UPDATES_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getAllUpdatesRule().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.budgets.v1beta1.Budget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A budget is a plan that describes what you expect to spend on Cloud
   * projects, plus the rules to execute as spend is tracked against that plan,
   * (for example, send an alert when 90% of the target spend is met).
   * The budget time period is configurable, with options such as month (default),
   * quarter, year, or custom time period.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.budgets.v1beta1.Budget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.budgets.v1beta1.Budget)
      com.google.cloud.billing.budgets.v1beta1.BudgetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Budget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Budget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.budgets.v1beta1.Budget.class,
              com.google.cloud.billing.budgets.v1beta1.Budget.Builder.class);
    }

    // Construct using com.google.cloud.billing.budgets.v1beta1.Budget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      budgetFilter_ = null;
      if (budgetFilterBuilder_ != null) {
        budgetFilterBuilder_.dispose();
        budgetFilterBuilder_ = null;
      }
      amount_ = null;
      if (amountBuilder_ != null) {
        amountBuilder_.dispose();
        amountBuilder_ = null;
      }
      if (thresholdRulesBuilder_ == null) {
        thresholdRules_ = java.util.Collections.emptyList();
      } else {
        thresholdRules_ = null;
        thresholdRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      allUpdatesRule_ = null;
      if (allUpdatesRuleBuilder_ != null) {
        allUpdatesRuleBuilder_.dispose();
        allUpdatesRuleBuilder_ = null;
      }
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Budget_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Budget getDefaultInstanceForType() {
      return com.google.cloud.billing.budgets.v1beta1.Budget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Budget build() {
      com.google.cloud.billing.budgets.v1beta1.Budget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Budget buildPartial() {
      com.google.cloud.billing.budgets.v1beta1.Budget result =
          new com.google.cloud.billing.budgets.v1beta1.Budget(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.billing.budgets.v1beta1.Budget result) {
      if (thresholdRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          thresholdRules_ = java.util.Collections.unmodifiableList(thresholdRules_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.thresholdRules_ = thresholdRules_;
      } else {
        result.thresholdRules_ = thresholdRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.billing.budgets.v1beta1.Budget result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.budgetFilter_ =
            budgetFilterBuilder_ == null ? budgetFilter_ : budgetFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.amount_ = amountBuilder_ == null ? amount_ : amountBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.allUpdatesRule_ =
            allUpdatesRuleBuilder_ == null ? allUpdatesRule_ : allUpdatesRuleBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.etag_ = etag_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.budgets.v1beta1.Budget) {
        return mergeFrom((com.google.cloud.billing.budgets.v1beta1.Budget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.budgets.v1beta1.Budget other) {
      if (other == com.google.cloud.billing.budgets.v1beta1.Budget.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasBudgetFilter()) {
        mergeBudgetFilter(other.getBudgetFilter());
      }
      if (other.hasAmount()) {
        mergeAmount(other.getAmount());
      }
      if (thresholdRulesBuilder_ == null) {
        if (!other.thresholdRules_.isEmpty()) {
          if (thresholdRules_.isEmpty()) {
            thresholdRules_ = other.thresholdRules_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureThresholdRulesIsMutable();
            thresholdRules_.addAll(other.thresholdRules_);
          }
          onChanged();
        }
      } else {
        if (!other.thresholdRules_.isEmpty()) {
          if (thresholdRulesBuilder_.isEmpty()) {
            thresholdRulesBuilder_.dispose();
            thresholdRulesBuilder_ = null;
            thresholdRules_ = other.thresholdRules_;
            bitField0_ = (bitField0_ & ~0x00000010);
            thresholdRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getThresholdRulesFieldBuilder()
                    : null;
          } else {
            thresholdRulesBuilder_.addAllMessages(other.thresholdRules_);
          }
        }
      }
      if (other.hasAllUpdatesRule()) {
        mergeAllUpdatesRule(other.getAllUpdatesRule());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBudgetFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getAmountFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.billing.budgets.v1beta1.ThresholdRule m =
                    input.readMessage(
                        com.google.cloud.billing.budgets.v1beta1.ThresholdRule.parser(),
                        extensionRegistry);
                if (thresholdRulesBuilder_ == null) {
                  ensureThresholdRulesIsMutable();
                  thresholdRules_.add(m);
                } else {
                  thresholdRulesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getAllUpdatesRuleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the budget.
     * The resource name implies the scope of a budget. Values are of the form
     * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the budget.
     * The resource name implies the scope of a budget. Values are of the form
     * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the budget.
     * The resource name implies the scope of a budget. Values are of the form
     * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the budget.
     * The resource name implies the scope of a budget. Values are of the form
     * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the budget.
     * The resource name implies the scope of a budget. Values are of the form
     * `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User data for display name in UI.
     * Validation: &lt;= 60 chars.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User data for display name in UI.
     * Validation: &lt;= 60 chars.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User data for display name in UI.
     * Validation: &lt;= 60 chars.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User data for display name in UI.
     * Validation: &lt;= 60 chars.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User data for display name in UI.
     * Validation: &lt;= 60 chars.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.billing.budgets.v1beta1.Filter budgetFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.Filter,
            com.google.cloud.billing.budgets.v1beta1.Filter.Builder,
            com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder>
        budgetFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the budgetFilter field is set.
     */
    public boolean hasBudgetFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The budgetFilter.
     */
    public com.google.cloud.billing.budgets.v1beta1.Filter getBudgetFilter() {
      if (budgetFilterBuilder_ == null) {
        return budgetFilter_ == null
            ? com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance()
            : budgetFilter_;
      } else {
        return budgetFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBudgetFilter(com.google.cloud.billing.budgets.v1beta1.Filter value) {
      if (budgetFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        budgetFilter_ = value;
      } else {
        budgetFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBudgetFilter(
        com.google.cloud.billing.budgets.v1beta1.Filter.Builder builderForValue) {
      if (budgetFilterBuilder_ == null) {
        budgetFilter_ = builderForValue.build();
      } else {
        budgetFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBudgetFilter(com.google.cloud.billing.budgets.v1beta1.Filter value) {
      if (budgetFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && budgetFilter_ != null
            && budgetFilter_
                != com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance()) {
          getBudgetFilterBuilder().mergeFrom(value);
        } else {
          budgetFilter_ = value;
        }
      } else {
        budgetFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBudgetFilter() {
      bitField0_ = (bitField0_ & ~0x00000004);
      budgetFilter_ = null;
      if (budgetFilterBuilder_ != null) {
        budgetFilterBuilder_.dispose();
        budgetFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.Filter.Builder getBudgetFilterBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBudgetFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder getBudgetFilterOrBuilder() {
      if (budgetFilterBuilder_ != null) {
        return budgetFilterBuilder_.getMessageOrBuilder();
      } else {
        return budgetFilter_ == null
            ? com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance()
            : budgetFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filters that define which resources are used to compute the
     * actual spend against the budget amount, such as projects, services, and the
     * budget's time period, as well as other filters.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter budget_filter = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.Filter,
            com.google.cloud.billing.budgets.v1beta1.Filter.Builder,
            com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder>
        getBudgetFilterFieldBuilder() {
      if (budgetFilterBuilder_ == null) {
        budgetFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.Filter,
                com.google.cloud.billing.budgets.v1beta1.Filter.Builder,
                com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder>(
                getBudgetFilter(), getParentForChildren(), isClean());
        budgetFilter_ = null;
      }
      return budgetFilterBuilder_;
    }

    private com.google.cloud.billing.budgets.v1beta1.BudgetAmount amount_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount,
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder,
            com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder>
        amountBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the amount field is set.
     */
    public boolean hasAmount() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The amount.
     */
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmount getAmount() {
      if (amountBuilder_ == null) {
        return amount_ == null
            ? com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance()
            : amount_;
      } else {
        return amountBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAmount(com.google.cloud.billing.budgets.v1beta1.BudgetAmount value) {
      if (amountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        amount_ = value;
      } else {
        amountBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAmount(
        com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder builderForValue) {
      if (amountBuilder_ == null) {
        amount_ = builderForValue.build();
      } else {
        amountBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAmount(com.google.cloud.billing.budgets.v1beta1.BudgetAmount value) {
      if (amountBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && amount_ != null
            && amount_
                != com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance()) {
          getAmountBuilder().mergeFrom(value);
        } else {
          amount_ = value;
        }
      } else {
        amountBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAmount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      amount_ = null;
      if (amountBuilder_ != null) {
        amountBuilder_.dispose();
        amountBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder getAmountBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAmountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder getAmountOrBuilder() {
      if (amountBuilder_ != null) {
        return amountBuilder_.getMessageOrBuilder();
      } else {
        return amount_ == null
            ? com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance()
            : amount_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Budgeted amount.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.BudgetAmount amount = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount,
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder,
            com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder>
        getAmountFieldBuilder() {
      if (amountBuilder_ == null) {
        amountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.BudgetAmount,
                com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder,
                com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder>(
                getAmount(), getParentForChildren(), isClean());
        amount_ = null;
      }
      return amountBuilder_;
    }

    private java.util.List<com.google.cloud.billing.budgets.v1beta1.ThresholdRule> thresholdRules_ =
        java.util.Collections.emptyList();

    private void ensureThresholdRulesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        thresholdRules_ =
            new java.util.ArrayList<com.google.cloud.billing.budgets.v1beta1.ThresholdRule>(
                thresholdRules_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.ThresholdRule,
            com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder,
            com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder>
        thresholdRulesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.billing.budgets.v1beta1.ThresholdRule>
        getThresholdRulesList() {
      if (thresholdRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(thresholdRules_);
      } else {
        return thresholdRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getThresholdRulesCount() {
      if (thresholdRulesBuilder_ == null) {
        return thresholdRules_.size();
      } else {
        return thresholdRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.ThresholdRule getThresholdRules(int index) {
      if (thresholdRulesBuilder_ == null) {
        return thresholdRules_.get(index);
      } else {
        return thresholdRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setThresholdRules(
        int index, com.google.cloud.billing.budgets.v1beta1.ThresholdRule value) {
      if (thresholdRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdRulesIsMutable();
        thresholdRules_.set(index, value);
        onChanged();
      } else {
        thresholdRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setThresholdRules(
        int index, com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder builderForValue) {
      if (thresholdRulesBuilder_ == null) {
        ensureThresholdRulesIsMutable();
        thresholdRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        thresholdRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addThresholdRules(com.google.cloud.billing.budgets.v1beta1.ThresholdRule value) {
      if (thresholdRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdRulesIsMutable();
        thresholdRules_.add(value);
        onChanged();
      } else {
        thresholdRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addThresholdRules(
        int index, com.google.cloud.billing.budgets.v1beta1.ThresholdRule value) {
      if (thresholdRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureThresholdRulesIsMutable();
        thresholdRules_.add(index, value);
        onChanged();
      } else {
        thresholdRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addThresholdRules(
        com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder builderForValue) {
      if (thresholdRulesBuilder_ == null) {
        ensureThresholdRulesIsMutable();
        thresholdRules_.add(builderForValue.build());
        onChanged();
      } else {
        thresholdRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addThresholdRules(
        int index, com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder builderForValue) {
      if (thresholdRulesBuilder_ == null) {
        ensureThresholdRulesIsMutable();
        thresholdRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        thresholdRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllThresholdRules(
        java.lang.Iterable<? extends com.google.cloud.billing.budgets.v1beta1.ThresholdRule>
            values) {
      if (thresholdRulesBuilder_ == null) {
        ensureThresholdRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, thresholdRules_);
        onChanged();
      } else {
        thresholdRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearThresholdRules() {
      if (thresholdRulesBuilder_ == null) {
        thresholdRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        thresholdRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeThresholdRules(int index) {
      if (thresholdRulesBuilder_ == null) {
        ensureThresholdRulesIsMutable();
        thresholdRules_.remove(index);
        onChanged();
      } else {
        thresholdRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder getThresholdRulesBuilder(
        int index) {
      return getThresholdRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder
        getThresholdRulesOrBuilder(int index) {
      if (thresholdRulesBuilder_ == null) {
        return thresholdRules_.get(index);
      } else {
        return thresholdRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder>
        getThresholdRulesOrBuilderList() {
      if (thresholdRulesBuilder_ != null) {
        return thresholdRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(thresholdRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder
        addThresholdRulesBuilder() {
      return getThresholdRulesFieldBuilder()
          .addBuilder(com.google.cloud.billing.budgets.v1beta1.ThresholdRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder addThresholdRulesBuilder(
        int index) {
      return getThresholdRulesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.billing.budgets.v1beta1.ThresholdRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules that trigger alerts (notifications of thresholds
     * being crossed) when spend exceeds the specified percentages of the budget.
     *
     * Optional for `pubsubTopic` notifications.
     *
     * Required if using email notifications.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.billing.budgets.v1beta1.ThresholdRule threshold_rules = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder>
        getThresholdRulesBuilderList() {
      return getThresholdRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.ThresholdRule,
            com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder,
            com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder>
        getThresholdRulesFieldBuilder() {
      if (thresholdRulesBuilder_ == null) {
        thresholdRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.ThresholdRule,
                com.google.cloud.billing.budgets.v1beta1.ThresholdRule.Builder,
                com.google.cloud.billing.budgets.v1beta1.ThresholdRuleOrBuilder>(
                thresholdRules_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        thresholdRules_ = null;
      }
      return thresholdRulesBuilder_;
    }

    private com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule allUpdatesRule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule,
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder,
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder>
        allUpdatesRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the allUpdatesRule field is set.
     */
    public boolean hasAllUpdatesRule() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The allUpdatesRule.
     */
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule getAllUpdatesRule() {
      if (allUpdatesRuleBuilder_ == null) {
        return allUpdatesRule_ == null
            ? com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance()
            : allUpdatesRule_;
      } else {
        return allUpdatesRuleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAllUpdatesRule(
        com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule value) {
      if (allUpdatesRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        allUpdatesRule_ = value;
      } else {
        allUpdatesRuleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAllUpdatesRule(
        com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder builderForValue) {
      if (allUpdatesRuleBuilder_ == null) {
        allUpdatesRule_ = builderForValue.build();
      } else {
        allUpdatesRuleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAllUpdatesRule(
        com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule value) {
      if (allUpdatesRuleBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && allUpdatesRule_ != null
            && allUpdatesRule_
                != com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance()) {
          getAllUpdatesRuleBuilder().mergeFrom(value);
        } else {
          allUpdatesRule_ = value;
        }
      } else {
        allUpdatesRuleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAllUpdatesRule() {
      bitField0_ = (bitField0_ & ~0x00000020);
      allUpdatesRule_ = null;
      if (allUpdatesRuleBuilder_ != null) {
        allUpdatesRuleBuilder_.dispose();
        allUpdatesRuleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder
        getAllUpdatesRuleBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAllUpdatesRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder
        getAllUpdatesRuleOrBuilder() {
      if (allUpdatesRuleBuilder_ != null) {
        return allUpdatesRuleBuilder_.getMessageOrBuilder();
      } else {
        return allUpdatesRule_ == null
            ? com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.getDefaultInstance()
            : allUpdatesRule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rules to apply to notifications sent based on budget spend and
     * thresholds.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.AllUpdatesRule all_updates_rule = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule,
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder,
            com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder>
        getAllUpdatesRuleFieldBuilder() {
      if (allUpdatesRuleBuilder_ == null) {
        allUpdatesRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule,
                com.google.cloud.billing.budgets.v1beta1.AllUpdatesRule.Builder,
                com.google.cloud.billing.budgets.v1beta1.AllUpdatesRuleOrBuilder>(
                getAllUpdatesRule(), getParentForChildren(), isClean());
        allUpdatesRule_ = null;
      }
      return allUpdatesRuleBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Etag to validate that the object is unchanged for a
     * read-modify-write operation.
     * An empty etag will cause an update to overwrite other changes.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag to validate that the object is unchanged for a
     * read-modify-write operation.
     * An empty etag will cause an update to overwrite other changes.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag to validate that the object is unchanged for a
     * read-modify-write operation.
     * An empty etag will cause an update to overwrite other changes.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag to validate that the object is unchanged for a
     * read-modify-write operation.
     * An empty etag will cause an update to overwrite other changes.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag to validate that the object is unchanged for a
     * read-modify-write operation.
     * An empty etag will cause an update to overwrite other changes.
     * </pre>
     *
     * <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.budgets.v1beta1.Budget)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.budgets.v1beta1.Budget)
  private static final com.google.cloud.billing.budgets.v1beta1.Budget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.budgets.v1beta1.Budget();
  }

  public static com.google.cloud.billing.budgets.v1beta1.Budget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Budget> PARSER =
      new com.google.protobuf.AbstractParser<Budget>() {
        @java.lang.Override
        public Budget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Budget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Budget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.Budget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
