/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package com.google.cloud.billing.budgets.v1beta1;

/**
 *
 *
 * <pre>
 * The budgeted amount for each usage period.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.budgets.v1beta1.BudgetAmount}
 */
public final class BudgetAmount extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.budgets.v1beta1.BudgetAmount)
    BudgetAmountOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BudgetAmount.newBuilder() to construct.
  private BudgetAmount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BudgetAmount() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BudgetAmount();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_BudgetAmount_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_BudgetAmount_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount.class,
            com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder.class);
  }

  private int budgetAmountCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object budgetAmount_;

  public enum BudgetAmountCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SPECIFIED_AMOUNT(1),
    LAST_PERIOD_AMOUNT(2),
    BUDGETAMOUNT_NOT_SET(0);
    private final int value;

    private BudgetAmountCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BudgetAmountCase valueOf(int value) {
      return forNumber(value);
    }

    public static BudgetAmountCase forNumber(int value) {
      switch (value) {
        case 1:
          return SPECIFIED_AMOUNT;
        case 2:
          return LAST_PERIOD_AMOUNT;
        case 0:
          return BUDGETAMOUNT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BudgetAmountCase getBudgetAmountCase() {
    return BudgetAmountCase.forNumber(budgetAmountCase_);
  }

  public static final int SPECIFIED_AMOUNT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A specified amount to use as the budget.
   * `currency_code` is optional. If specified when creating a budget, it must
   * match the currency of the billing account. If specified when updating a
   * budget, it must match the currency_code of the existing budget.
   * The `currency_code` is provided on output.
   * </pre>
   *
   * <code>.google.type.Money specified_amount = 1;</code>
   *
   * @return Whether the specifiedAmount field is set.
   */
  @java.lang.Override
  public boolean hasSpecifiedAmount() {
    return budgetAmountCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A specified amount to use as the budget.
   * `currency_code` is optional. If specified when creating a budget, it must
   * match the currency of the billing account. If specified when updating a
   * budget, it must match the currency_code of the existing budget.
   * The `currency_code` is provided on output.
   * </pre>
   *
   * <code>.google.type.Money specified_amount = 1;</code>
   *
   * @return The specifiedAmount.
   */
  @java.lang.Override
  public com.google.type.Money getSpecifiedAmount() {
    if (budgetAmountCase_ == 1) {
      return (com.google.type.Money) budgetAmount_;
    }
    return com.google.type.Money.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A specified amount to use as the budget.
   * `currency_code` is optional. If specified when creating a budget, it must
   * match the currency of the billing account. If specified when updating a
   * budget, it must match the currency_code of the existing budget.
   * The `currency_code` is provided on output.
   * </pre>
   *
   * <code>.google.type.Money specified_amount = 1;</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getSpecifiedAmountOrBuilder() {
    if (budgetAmountCase_ == 1) {
      return (com.google.type.Money) budgetAmount_;
    }
    return com.google.type.Money.getDefaultInstance();
  }

  public static final int LAST_PERIOD_AMOUNT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Use the last period's actual spend as the budget for the present period.
   * LastPeriodAmount can only be set when the budget's time period is a
   * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
   * It cannot be set in combination with
   * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
   * </pre>
   *
   * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
   *
   * @return Whether the lastPeriodAmount field is set.
   */
  @java.lang.Override
  public boolean hasLastPeriodAmount() {
    return budgetAmountCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Use the last period's actual spend as the budget for the present period.
   * LastPeriodAmount can only be set when the budget's time period is a
   * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
   * It cannot be set in combination with
   * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
   * </pre>
   *
   * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
   *
   * @return The lastPeriodAmount.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount getLastPeriodAmount() {
    if (budgetAmountCase_ == 2) {
      return (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_;
    }
    return com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Use the last period's actual spend as the budget for the present period.
   * LastPeriodAmount can only be set when the budget's time period is a
   * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
   * It cannot be set in combination with
   * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
   * </pre>
   *
   * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.LastPeriodAmountOrBuilder
      getLastPeriodAmountOrBuilder() {
    if (budgetAmountCase_ == 2) {
      return (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_;
    }
    return com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (budgetAmountCase_ == 1) {
      output.writeMessage(1, (com.google.type.Money) budgetAmount_);
    }
    if (budgetAmountCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (budgetAmountCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.type.Money) budgetAmount_);
    }
    if (budgetAmountCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.budgets.v1beta1.BudgetAmount)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.budgets.v1beta1.BudgetAmount other =
        (com.google.cloud.billing.budgets.v1beta1.BudgetAmount) obj;

    if (!getBudgetAmountCase().equals(other.getBudgetAmountCase())) return false;
    switch (budgetAmountCase_) {
      case 1:
        if (!getSpecifiedAmount().equals(other.getSpecifiedAmount())) return false;
        break;
      case 2:
        if (!getLastPeriodAmount().equals(other.getLastPeriodAmount())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (budgetAmountCase_) {
      case 1:
        hash = (37 * hash) + SPECIFIED_AMOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getSpecifiedAmount().hashCode();
        break;
      case 2:
        hash = (37 * hash) + LAST_PERIOD_AMOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getLastPeriodAmount().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.billing.budgets.v1beta1.BudgetAmount prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The budgeted amount for each usage period.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.budgets.v1beta1.BudgetAmount}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.budgets.v1beta1.BudgetAmount)
      com.google.cloud.billing.budgets.v1beta1.BudgetAmountOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_BudgetAmount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_BudgetAmount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.budgets.v1beta1.BudgetAmount.class,
              com.google.cloud.billing.budgets.v1beta1.BudgetAmount.Builder.class);
    }

    // Construct using com.google.cloud.billing.budgets.v1beta1.BudgetAmount.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (specifiedAmountBuilder_ != null) {
        specifiedAmountBuilder_.clear();
      }
      if (lastPeriodAmountBuilder_ != null) {
        lastPeriodAmountBuilder_.clear();
      }
      budgetAmountCase_ = 0;
      budgetAmount_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_BudgetAmount_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmount getDefaultInstanceForType() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmount build() {
      com.google.cloud.billing.budgets.v1beta1.BudgetAmount result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.BudgetAmount buildPartial() {
      com.google.cloud.billing.budgets.v1beta1.BudgetAmount result =
          new com.google.cloud.billing.budgets.v1beta1.BudgetAmount(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.billing.budgets.v1beta1.BudgetAmount result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.billing.budgets.v1beta1.BudgetAmount result) {
      result.budgetAmountCase_ = budgetAmountCase_;
      result.budgetAmount_ = this.budgetAmount_;
      if (budgetAmountCase_ == 1 && specifiedAmountBuilder_ != null) {
        result.budgetAmount_ = specifiedAmountBuilder_.build();
      }
      if (budgetAmountCase_ == 2 && lastPeriodAmountBuilder_ != null) {
        result.budgetAmount_ = lastPeriodAmountBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.budgets.v1beta1.BudgetAmount) {
        return mergeFrom((com.google.cloud.billing.budgets.v1beta1.BudgetAmount) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.budgets.v1beta1.BudgetAmount other) {
      if (other == com.google.cloud.billing.budgets.v1beta1.BudgetAmount.getDefaultInstance())
        return this;
      switch (other.getBudgetAmountCase()) {
        case SPECIFIED_AMOUNT:
          {
            mergeSpecifiedAmount(other.getSpecifiedAmount());
            break;
          }
        case LAST_PERIOD_AMOUNT:
          {
            mergeLastPeriodAmount(other.getLastPeriodAmount());
            break;
          }
        case BUDGETAMOUNT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSpecifiedAmountFieldBuilder().getBuilder(), extensionRegistry);
                budgetAmountCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getLastPeriodAmountFieldBuilder().getBuilder(), extensionRegistry);
                budgetAmountCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int budgetAmountCase_ = 0;
    private java.lang.Object budgetAmount_;

    public BudgetAmountCase getBudgetAmountCase() {
      return BudgetAmountCase.forNumber(budgetAmountCase_);
    }

    public Builder clearBudgetAmount() {
      budgetAmountCase_ = 0;
      budgetAmount_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        specifiedAmountBuilder_;
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     *
     * @return Whether the specifiedAmount field is set.
     */
    @java.lang.Override
    public boolean hasSpecifiedAmount() {
      return budgetAmountCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     *
     * @return The specifiedAmount.
     */
    @java.lang.Override
    public com.google.type.Money getSpecifiedAmount() {
      if (specifiedAmountBuilder_ == null) {
        if (budgetAmountCase_ == 1) {
          return (com.google.type.Money) budgetAmount_;
        }
        return com.google.type.Money.getDefaultInstance();
      } else {
        if (budgetAmountCase_ == 1) {
          return specifiedAmountBuilder_.getMessage();
        }
        return com.google.type.Money.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    public Builder setSpecifiedAmount(com.google.type.Money value) {
      if (specifiedAmountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        budgetAmount_ = value;
        onChanged();
      } else {
        specifiedAmountBuilder_.setMessage(value);
      }
      budgetAmountCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    public Builder setSpecifiedAmount(com.google.type.Money.Builder builderForValue) {
      if (specifiedAmountBuilder_ == null) {
        budgetAmount_ = builderForValue.build();
        onChanged();
      } else {
        specifiedAmountBuilder_.setMessage(builderForValue.build());
      }
      budgetAmountCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    public Builder mergeSpecifiedAmount(com.google.type.Money value) {
      if (specifiedAmountBuilder_ == null) {
        if (budgetAmountCase_ == 1 && budgetAmount_ != com.google.type.Money.getDefaultInstance()) {
          budgetAmount_ =
              com.google.type.Money.newBuilder((com.google.type.Money) budgetAmount_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          budgetAmount_ = value;
        }
        onChanged();
      } else {
        if (budgetAmountCase_ == 1) {
          specifiedAmountBuilder_.mergeFrom(value);
        } else {
          specifiedAmountBuilder_.setMessage(value);
        }
      }
      budgetAmountCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    public Builder clearSpecifiedAmount() {
      if (specifiedAmountBuilder_ == null) {
        if (budgetAmountCase_ == 1) {
          budgetAmountCase_ = 0;
          budgetAmount_ = null;
          onChanged();
        }
      } else {
        if (budgetAmountCase_ == 1) {
          budgetAmountCase_ = 0;
          budgetAmount_ = null;
        }
        specifiedAmountBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    public com.google.type.Money.Builder getSpecifiedAmountBuilder() {
      return getSpecifiedAmountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    @java.lang.Override
    public com.google.type.MoneyOrBuilder getSpecifiedAmountOrBuilder() {
      if ((budgetAmountCase_ == 1) && (specifiedAmountBuilder_ != null)) {
        return specifiedAmountBuilder_.getMessageOrBuilder();
      } else {
        if (budgetAmountCase_ == 1) {
          return (com.google.type.Money) budgetAmount_;
        }
        return com.google.type.Money.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A specified amount to use as the budget.
     * `currency_code` is optional. If specified when creating a budget, it must
     * match the currency of the billing account. If specified when updating a
     * budget, it must match the currency_code of the existing budget.
     * The `currency_code` is provided on output.
     * </pre>
     *
     * <code>.google.type.Money specified_amount = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getSpecifiedAmountFieldBuilder() {
      if (specifiedAmountBuilder_ == null) {
        if (!(budgetAmountCase_ == 1)) {
          budgetAmount_ = com.google.type.Money.getDefaultInstance();
        }
        specifiedAmountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                (com.google.type.Money) budgetAmount_, getParentForChildren(), isClean());
        budgetAmount_ = null;
      }
      budgetAmountCase_ = 1;
      onChanged();
      return specifiedAmountBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount,
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.Builder,
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmountOrBuilder>
        lastPeriodAmountBuilder_;
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     *
     * @return Whether the lastPeriodAmount field is set.
     */
    @java.lang.Override
    public boolean hasLastPeriodAmount() {
      return budgetAmountCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     *
     * @return The lastPeriodAmount.
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount getLastPeriodAmount() {
      if (lastPeriodAmountBuilder_ == null) {
        if (budgetAmountCase_ == 2) {
          return (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_;
        }
        return com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
      } else {
        if (budgetAmountCase_ == 2) {
          return lastPeriodAmountBuilder_.getMessage();
        }
        return com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    public Builder setLastPeriodAmount(
        com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount value) {
      if (lastPeriodAmountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        budgetAmount_ = value;
        onChanged();
      } else {
        lastPeriodAmountBuilder_.setMessage(value);
      }
      budgetAmountCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    public Builder setLastPeriodAmount(
        com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.Builder builderForValue) {
      if (lastPeriodAmountBuilder_ == null) {
        budgetAmount_ = builderForValue.build();
        onChanged();
      } else {
        lastPeriodAmountBuilder_.setMessage(builderForValue.build());
      }
      budgetAmountCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    public Builder mergeLastPeriodAmount(
        com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount value) {
      if (lastPeriodAmountBuilder_ == null) {
        if (budgetAmountCase_ == 2
            && budgetAmount_
                != com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance()) {
          budgetAmount_ =
              com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.newBuilder(
                      (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          budgetAmount_ = value;
        }
        onChanged();
      } else {
        if (budgetAmountCase_ == 2) {
          lastPeriodAmountBuilder_.mergeFrom(value);
        } else {
          lastPeriodAmountBuilder_.setMessage(value);
        }
      }
      budgetAmountCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    public Builder clearLastPeriodAmount() {
      if (lastPeriodAmountBuilder_ == null) {
        if (budgetAmountCase_ == 2) {
          budgetAmountCase_ = 0;
          budgetAmount_ = null;
          onChanged();
        }
      } else {
        if (budgetAmountCase_ == 2) {
          budgetAmountCase_ = 0;
          budgetAmount_ = null;
        }
        lastPeriodAmountBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    public com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.Builder
        getLastPeriodAmountBuilder() {
      return getLastPeriodAmountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.LastPeriodAmountOrBuilder
        getLastPeriodAmountOrBuilder() {
      if ((budgetAmountCase_ == 2) && (lastPeriodAmountBuilder_ != null)) {
        return lastPeriodAmountBuilder_.getMessageOrBuilder();
      } else {
        if (budgetAmountCase_ == 2) {
          return (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_;
        }
        return com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Use the last period's actual spend as the budget for the present period.
     * LastPeriodAmount can only be set when the budget's time period is a
     * [Filter.calendar_period][google.cloud.billing.budgets.v1beta1.Filter.calendar_period].
     * It cannot be set in combination with
     * [Filter.custom_period][google.cloud.billing.budgets.v1beta1.Filter.custom_period].
     * </pre>
     *
     * <code>.google.cloud.billing.budgets.v1beta1.LastPeriodAmount last_period_amount = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount,
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.Builder,
            com.google.cloud.billing.budgets.v1beta1.LastPeriodAmountOrBuilder>
        getLastPeriodAmountFieldBuilder() {
      if (lastPeriodAmountBuilder_ == null) {
        if (!(budgetAmountCase_ == 2)) {
          budgetAmount_ =
              com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.getDefaultInstance();
        }
        lastPeriodAmountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount,
                com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount.Builder,
                com.google.cloud.billing.budgets.v1beta1.LastPeriodAmountOrBuilder>(
                (com.google.cloud.billing.budgets.v1beta1.LastPeriodAmount) budgetAmount_,
                getParentForChildren(),
                isClean());
        budgetAmount_ = null;
      }
      budgetAmountCase_ = 2;
      onChanged();
      return lastPeriodAmountBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.budgets.v1beta1.BudgetAmount)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.budgets.v1beta1.BudgetAmount)
  private static final com.google.cloud.billing.budgets.v1beta1.BudgetAmount DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.budgets.v1beta1.BudgetAmount();
  }

  public static com.google.cloud.billing.budgets.v1beta1.BudgetAmount getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BudgetAmount> PARSER =
      new com.google.protobuf.AbstractParser<BudgetAmount>() {
        @java.lang.Override
        public BudgetAmount parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BudgetAmount> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BudgetAmount> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.BudgetAmount getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
