/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package com.google.cloud.billing.budgets.v1beta1;

/**
 *
 *
 * <pre>
 * A filter for a budget, limiting the scope of the cost to calculate.
 * </pre>
 *
 * Protobuf type {@code google.cloud.billing.budgets.v1beta1.Filter}
 */
public final class Filter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.billing.budgets.v1beta1.Filter)
    FilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Filter.newBuilder() to construct.
  private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Filter() {
    projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
    resourceAncestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
    creditTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    creditTypesTreatment_ = 0;
    services_ = com.google.protobuf.LazyStringArrayList.emptyList();
    subaccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Filter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_Filter_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.billing.budgets.v1beta1.BudgetModel
        .internal_static_google_cloud_billing_budgets_v1beta1_Filter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.billing.budgets.v1beta1.Filter.class,
            com.google.cloud.billing.budgets.v1beta1.Filter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how credits are applied when determining the spend for
   * threshold calculations. Budgets track the total cost minus any applicable
   * selected credits.
   * [See the documentation for a list of credit
   * types](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment}
   */
  public enum CreditTypesTreatment implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>CREDIT_TYPES_TREATMENT_UNSPECIFIED = 0;</code> */
    CREDIT_TYPES_TREATMENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All types of credit are subtracted from the gross cost to determine the
     * spend for threshold calculations.
     * </pre>
     *
     * <code>INCLUDE_ALL_CREDITS = 1;</code>
     */
    INCLUDE_ALL_CREDITS(1),
    /**
     *
     *
     * <pre>
     * All types of credit are added to the net cost to determine the spend for
     * threshold calculations.
     * </pre>
     *
     * <code>EXCLUDE_ALL_CREDITS = 2;</code>
     */
    EXCLUDE_ALL_CREDITS(2),
    /**
     *
     *
     * <pre>
     * [Credit
     * types](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type)
     * specified in the credit_types field are subtracted from the
     * gross cost to determine the spend for threshold calculations.
     * </pre>
     *
     * <code>INCLUDE_SPECIFIED_CREDITS = 3;</code>
     */
    INCLUDE_SPECIFIED_CREDITS(3),
    UNRECOGNIZED(-1),
    ;

    /** <code>CREDIT_TYPES_TREATMENT_UNSPECIFIED = 0;</code> */
    public static final int CREDIT_TYPES_TREATMENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All types of credit are subtracted from the gross cost to determine the
     * spend for threshold calculations.
     * </pre>
     *
     * <code>INCLUDE_ALL_CREDITS = 1;</code>
     */
    public static final int INCLUDE_ALL_CREDITS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * All types of credit are added to the net cost to determine the spend for
     * threshold calculations.
     * </pre>
     *
     * <code>EXCLUDE_ALL_CREDITS = 2;</code>
     */
    public static final int EXCLUDE_ALL_CREDITS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * [Credit
     * types](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type)
     * specified in the credit_types field are subtracted from the
     * gross cost to determine the spend for threshold calculations.
     * </pre>
     *
     * <code>INCLUDE_SPECIFIED_CREDITS = 3;</code>
     */
    public static final int INCLUDE_SPECIFIED_CREDITS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CreditTypesTreatment valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CreditTypesTreatment forNumber(int value) {
      switch (value) {
        case 0:
          return CREDIT_TYPES_TREATMENT_UNSPECIFIED;
        case 1:
          return INCLUDE_ALL_CREDITS;
        case 2:
          return EXCLUDE_ALL_CREDITS;
        case 3:
          return INCLUDE_SPECIFIED_CREDITS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CreditTypesTreatment>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CreditTypesTreatment>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CreditTypesTreatment>() {
              public CreditTypesTreatment findValueByNumber(int number) {
                return CreditTypesTreatment.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.billing.budgets.v1beta1.Filter.getDescriptor().getEnumTypes().get(0);
    }

    private static final CreditTypesTreatment[] VALUES = values();

    public static CreditTypesTreatment valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CreditTypesTreatment(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment)
  }

  private int usagePeriodCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object usagePeriod_;

  public enum UsagePeriodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CALENDAR_PERIOD(8),
    CUSTOM_PERIOD(9),
    USAGEPERIOD_NOT_SET(0);
    private final int value;

    private UsagePeriodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UsagePeriodCase valueOf(int value) {
      return forNumber(value);
    }

    public static UsagePeriodCase forNumber(int value) {
      switch (value) {
        case 8:
          return CALENDAR_PERIOD;
        case 9:
          return CUSTOM_PERIOD;
        case 0:
          return USAGEPERIOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public UsagePeriodCase getUsagePeriodCase() {
    return UsagePeriodCase.forNumber(usagePeriodCase_);
  }

  public static final int PROJECTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList projects_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A set of projects of the form `projects/{project}`,
   * specifying that usage from only this set of projects should be
   * included in the budget. If omitted, the report will include all usage for
   * the billing account, regardless of which project the usage occurred on.
   * </pre>
   *
   * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the projects.
   */
  public com.google.protobuf.ProtocolStringList getProjectsList() {
    return projects_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of projects of the form `projects/{project}`,
   * specifying that usage from only this set of projects should be
   * included in the budget. If omitted, the report will include all usage for
   * the billing account, regardless of which project the usage occurred on.
   * </pre>
   *
   * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of projects.
   */
  public int getProjectsCount() {
    return projects_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of projects of the form `projects/{project}`,
   * specifying that usage from only this set of projects should be
   * included in the budget. If omitted, the report will include all usage for
   * the billing account, regardless of which project the usage occurred on.
   * </pre>
   *
   * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The projects at the given index.
   */
  public java.lang.String getProjects(int index) {
    return projects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of projects of the form `projects/{project}`,
   * specifying that usage from only this set of projects should be
   * included in the budget. If omitted, the report will include all usage for
   * the billing account, regardless of which project the usage occurred on.
   * </pre>
   *
   * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the projects at the given index.
   */
  public com.google.protobuf.ByteString getProjectsBytes(int index) {
    return projects_.getByteString(index);
  }

  public static final int RESOURCE_ANCESTORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList resourceAncestors_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A set of folder and organization names of the form
   * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
   * usage from only this set of folders and organizations should be included in
   * the budget. If omitted, the budget includes all usage that the billing
   * account pays for. If the folder or organization contains projects that are
   * paid for by a different Cloud Billing account, the budget *doesn't* apply
   * to those projects.
   * </pre>
   *
   * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the resourceAncestors.
   */
  public com.google.protobuf.ProtocolStringList getResourceAncestorsList() {
    return resourceAncestors_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of folder and organization names of the form
   * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
   * usage from only this set of folders and organizations should be included in
   * the budget. If omitted, the budget includes all usage that the billing
   * account pays for. If the folder or organization contains projects that are
   * paid for by a different Cloud Billing account, the budget *doesn't* apply
   * to those projects.
   * </pre>
   *
   * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of resourceAncestors.
   */
  public int getResourceAncestorsCount() {
    return resourceAncestors_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of folder and organization names of the form
   * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
   * usage from only this set of folders and organizations should be included in
   * the budget. If omitted, the budget includes all usage that the billing
   * account pays for. If the folder or organization contains projects that are
   * paid for by a different Cloud Billing account, the budget *doesn't* apply
   * to those projects.
   * </pre>
   *
   * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The resourceAncestors at the given index.
   */
  public java.lang.String getResourceAncestors(int index) {
    return resourceAncestors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of folder and organization names of the form
   * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
   * usage from only this set of folders and organizations should be included in
   * the budget. If omitted, the budget includes all usage that the billing
   * account pays for. If the folder or organization contains projects that are
   * paid for by a different Cloud Billing account, the budget *doesn't* apply
   * to those projects.
   * </pre>
   *
   * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourceAncestors at the given index.
   */
  public com.google.protobuf.ByteString getResourceAncestorsBytes(int index) {
    return resourceAncestors_.getByteString(index);
  }

  public static final int CREDIT_TYPES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList creditTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
   * subtracted from gross cost to determine the spend for threshold
   * calculations. See [a list of acceptable credit type
   * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
   *
   * If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
   * </pre>
   *
   * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the creditTypes.
   */
  public com.google.protobuf.ProtocolStringList getCreditTypesList() {
    return creditTypes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
   * subtracted from gross cost to determine the spend for threshold
   * calculations. See [a list of acceptable credit type
   * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
   *
   * If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
   * </pre>
   *
   * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of creditTypes.
   */
  public int getCreditTypesCount() {
    return creditTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
   * subtracted from gross cost to determine the spend for threshold
   * calculations. See [a list of acceptable credit type
   * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
   *
   * If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
   * </pre>
   *
   * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The creditTypes at the given index.
   */
  public java.lang.String getCreditTypes(int index) {
    return creditTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
   * subtracted from gross cost to determine the spend for threshold
   * calculations. See [a list of acceptable credit type
   * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
   *
   * If
   * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
   * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
   * </pre>
   *
   * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the creditTypes at the given index.
   */
  public com.google.protobuf.ByteString getCreditTypesBytes(int index) {
    return creditTypes_.getByteString(index);
  }

  public static final int CREDIT_TYPES_TREATMENT_FIELD_NUMBER = 4;
  private int creditTypesTreatment_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for creditTypesTreatment.
   */
  @java.lang.Override
  public int getCreditTypesTreatmentValue() {
    return creditTypesTreatment_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The creditTypesTreatment.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
      getCreditTypesTreatment() {
    com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment result =
        com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment.forNumber(
            creditTypesTreatment_);
    return result == null
        ? com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment.UNRECOGNIZED
        : result;
  }

  public static final int SERVICES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList services_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A set of services of the form `services/{service_id}`,
   * specifying that usage from only this set of services should be
   * included in the budget. If omitted, the report will include usage for
   * all the services.
   * The service names are available through the Catalog API:
   * https://cloud.google.com/billing/v1/how-tos/catalog-api.
   * </pre>
   *
   * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the services.
   */
  public com.google.protobuf.ProtocolStringList getServicesList() {
    return services_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of services of the form `services/{service_id}`,
   * specifying that usage from only this set of services should be
   * included in the budget. If omitted, the report will include usage for
   * all the services.
   * The service names are available through the Catalog API:
   * https://cloud.google.com/billing/v1/how-tos/catalog-api.
   * </pre>
   *
   * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of services.
   */
  public int getServicesCount() {
    return services_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of services of the form `services/{service_id}`,
   * specifying that usage from only this set of services should be
   * included in the budget. If omitted, the report will include usage for
   * all the services.
   * The service names are available through the Catalog API:
   * https://cloud.google.com/billing/v1/how-tos/catalog-api.
   * </pre>
   *
   * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The services at the given index.
   */
  public java.lang.String getServices(int index) {
    return services_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of services of the form `services/{service_id}`,
   * specifying that usage from only this set of services should be
   * included in the budget. If omitted, the report will include usage for
   * all the services.
   * The service names are available through the Catalog API:
   * https://cloud.google.com/billing/v1/how-tos/catalog-api.
   * </pre>
   *
   * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the services at the given index.
   */
  public com.google.protobuf.ByteString getServicesBytes(int index) {
    return services_.getByteString(index);
  }

  public static final int SUBACCOUNTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList subaccounts_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
   * specifying that usage from only this set of subaccounts should be included
   * in the budget. If a subaccount is set to the name of the parent account,
   * usage from the parent account will be included. If omitted, the
   * report will include usage from the parent account and all
   * subaccounts, if they exist.
   * </pre>
   *
   * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the subaccounts.
   */
  public com.google.protobuf.ProtocolStringList getSubaccountsList() {
    return subaccounts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
   * specifying that usage from only this set of subaccounts should be included
   * in the budget. If a subaccount is set to the name of the parent account,
   * usage from the parent account will be included. If omitted, the
   * report will include usage from the parent account and all
   * subaccounts, if they exist.
   * </pre>
   *
   * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of subaccounts.
   */
  public int getSubaccountsCount() {
    return subaccounts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
   * specifying that usage from only this set of subaccounts should be included
   * in the budget. If a subaccount is set to the name of the parent account,
   * usage from the parent account will be included. If omitted, the
   * report will include usage from the parent account and all
   * subaccounts, if they exist.
   * </pre>
   *
   * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The subaccounts at the given index.
   */
  public java.lang.String getSubaccounts(int index) {
    return subaccounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
   * specifying that usage from only this set of subaccounts should be included
   * in the budget. If a subaccount is set to the name of the parent account,
   * usage from the parent account will be included. If omitted, the
   * report will include usage from the parent account and all
   * subaccounts, if they exist.
   * </pre>
   *
   * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the subaccounts at the given index.
   */
  public com.google.protobuf.ByteString getSubaccountsBytes(int index) {
    return subaccounts_.getByteString(index);
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.protobuf.ListValue>newDefaultInstance(
                    com.google.cloud.billing.budgets.v1beta1.BudgetModel
                        .internal_static_google_cloud_billing_budgets_v1beta1_Filter_LabelsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.protobuf.ListValue.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue> labels_;

  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
      internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A single label and value pair specifying that usage from only
   * this set of labeled resources should be included in the budget. If omitted,
   * the report will include all labeled and unlabeled usage.
   *
   * An object containing a single `"key": value` pair. Example: `{ "name":
   * "wrench" }`.
   *
   *  _Currently, multiple entries or multiple values per entry are not
   *  allowed._
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A single label and value pair specifying that usage from only
   * this set of labeled resources should be included in the budget. If omitted,
   * the report will include all labeled and unlabeled usage.
   *
   * An object containing a single `"key": value` pair. Example: `{ "name":
   * "wrench" }`.
   *
   *  _Currently, multiple entries or multiple values per entry are not
   *  allowed._
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A single label and value pair specifying that usage from only
   * this set of labeled resources should be included in the budget. If omitted,
   * the report will include all labeled and unlabeled usage.
   *
   * An object containing a single `"key": value` pair. Example: `{ "name":
   * "wrench" }`.
   *
   *  _Currently, multiple entries or multiple values per entry are not
   *  allowed._
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.protobuf.ListValue getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.protobuf.ListValue defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.ListValue> map =
        internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A single label and value pair specifying that usage from only
   * this set of labeled resources should be included in the budget. If omitted,
   * the report will include all labeled and unlabeled usage.
   *
   * An object containing a single `"key": value` pair. Example: `{ "name":
   * "wrench" }`.
   *
   *  _Currently, multiple entries or multiple values per entry are not
   *  allowed._
   * </pre>
   *
   * <code>
   * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.ListValue getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.protobuf.ListValue> map =
        internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CALENDAR_PERIOD_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage for recurring calendar period.
   * For example, assume that CalendarPeriod.QUARTER is set. The budget will
   * track usage from April 1 to June 30, when the current calendar month is
   * April, May, June. After that, it will track usage from July 1 to
   * September 30 when the current calendar month is July, August, September,
   * so on.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the calendarPeriod field is set.
   */
  public boolean hasCalendarPeriod() {
    return usagePeriodCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage for recurring calendar period.
   * For example, assume that CalendarPeriod.QUARTER is set. The budget will
   * track usage from April 1 to June 30, when the current calendar month is
   * April, May, June. After that, it will track usage from July 1 to
   * September 30 when the current calendar month is July, August, September,
   * so on.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for calendarPeriod.
   */
  public int getCalendarPeriodValue() {
    if (usagePeriodCase_ == 8) {
      return (java.lang.Integer) usagePeriod_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage for recurring calendar period.
   * For example, assume that CalendarPeriod.QUARTER is set. The budget will
   * track usage from April 1 to June 30, when the current calendar month is
   * April, May, June. After that, it will track usage from July 1 to
   * September 30 when the current calendar month is July, August, September,
   * so on.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The calendarPeriod.
   */
  public com.google.cloud.billing.budgets.v1beta1.CalendarPeriod getCalendarPeriod() {
    if (usagePeriodCase_ == 8) {
      com.google.cloud.billing.budgets.v1beta1.CalendarPeriod result =
          com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.forNumber(
              (java.lang.Integer) usagePeriod_);
      return result == null
          ? com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.CALENDAR_PERIOD_UNSPECIFIED;
  }

  public static final int CUSTOM_PERIOD_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage from any start date (required) to any
   * end date (optional). This time period is static, it does not recur.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customPeriod field is set.
   */
  @java.lang.Override
  public boolean hasCustomPeriod() {
    return usagePeriodCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage from any start date (required) to any
   * end date (optional). This time period is static, it does not recur.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customPeriod.
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.CustomPeriod getCustomPeriod() {
    if (usagePeriodCase_ == 9) {
      return (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_;
    }
    return com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies to track usage from any start date (required) to any
   * end date (optional). This time period is static, it does not recur.
   * </pre>
   *
   * <code>
   * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.CustomPeriodOrBuilder getCustomPeriodOrBuilder() {
    if (usagePeriodCase_ == 9) {
      return (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_;
    }
    return com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < projects_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projects_.getRaw(i));
    }
    for (int i = 0; i < resourceAncestors_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceAncestors_.getRaw(i));
    }
    for (int i = 0; i < services_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, services_.getRaw(i));
    }
    if (creditTypesTreatment_
        != com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
            .CREDIT_TYPES_TREATMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, creditTypesTreatment_);
    }
    for (int i = 0; i < subaccounts_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, subaccounts_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    for (int i = 0; i < creditTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, creditTypes_.getRaw(i));
    }
    if (usagePeriodCase_ == 8) {
      output.writeEnum(8, ((java.lang.Integer) usagePeriod_));
    }
    if (usagePeriodCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < projects_.size(); i++) {
        dataSize += computeStringSizeNoTag(projects_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProjectsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourceAncestors_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourceAncestors_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResourceAncestorsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < services_.size(); i++) {
        dataSize += computeStringSizeNoTag(services_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServicesList().size();
    }
    if (creditTypesTreatment_
        != com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
            .CREDIT_TYPES_TREATMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, creditTypesTreatment_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < subaccounts_.size(); i++) {
        dataSize += computeStringSizeNoTag(subaccounts_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSubaccountsList().size();
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.ListValue> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < creditTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(creditTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCreditTypesList().size();
    }
    if (usagePeriodCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              8, ((java.lang.Integer) usagePeriod_));
    }
    if (usagePeriodCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.billing.budgets.v1beta1.Filter)) {
      return super.equals(obj);
    }
    com.google.cloud.billing.budgets.v1beta1.Filter other =
        (com.google.cloud.billing.budgets.v1beta1.Filter) obj;

    if (!getProjectsList().equals(other.getProjectsList())) return false;
    if (!getResourceAncestorsList().equals(other.getResourceAncestorsList())) return false;
    if (!getCreditTypesList().equals(other.getCreditTypesList())) return false;
    if (creditTypesTreatment_ != other.creditTypesTreatment_) return false;
    if (!getServicesList().equals(other.getServicesList())) return false;
    if (!getSubaccountsList().equals(other.getSubaccountsList())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUsagePeriodCase().equals(other.getUsagePeriodCase())) return false;
    switch (usagePeriodCase_) {
      case 8:
        if (getCalendarPeriodValue() != other.getCalendarPeriodValue()) return false;
        break;
      case 9:
        if (!getCustomPeriod().equals(other.getCustomPeriod())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProjectsCount() > 0) {
      hash = (37 * hash) + PROJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getProjectsList().hashCode();
    }
    if (getResourceAncestorsCount() > 0) {
      hash = (37 * hash) + RESOURCE_ANCESTORS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceAncestorsList().hashCode();
    }
    if (getCreditTypesCount() > 0) {
      hash = (37 * hash) + CREDIT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getCreditTypesList().hashCode();
    }
    hash = (37 * hash) + CREDIT_TYPES_TREATMENT_FIELD_NUMBER;
    hash = (53 * hash) + creditTypesTreatment_;
    if (getServicesCount() > 0) {
      hash = (37 * hash) + SERVICES_FIELD_NUMBER;
      hash = (53 * hash) + getServicesList().hashCode();
    }
    if (getSubaccountsCount() > 0) {
      hash = (37 * hash) + SUBACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getSubaccountsList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (usagePeriodCase_) {
      case 8:
        hash = (37 * hash) + CALENDAR_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getCalendarPeriodValue();
        break;
      case 9:
        hash = (37 * hash) + CUSTOM_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getCustomPeriod().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.billing.budgets.v1beta1.Filter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A filter for a budget, limiting the scope of the cost to calculate.
   * </pre>
   *
   * Protobuf type {@code google.cloud.billing.budgets.v1beta1.Filter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.billing.budgets.v1beta1.Filter)
      com.google.cloud.billing.budgets.v1beta1.FilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Filter_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.billing.budgets.v1beta1.Filter.class,
              com.google.cloud.billing.budgets.v1beta1.Filter.Builder.class);
    }

    // Construct using com.google.cloud.billing.budgets.v1beta1.Filter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      resourceAncestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      creditTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      creditTypesTreatment_ = 0;
      services_ = com.google.protobuf.LazyStringArrayList.emptyList();
      subaccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableLabels().clear();
      if (customPeriodBuilder_ != null) {
        customPeriodBuilder_.clear();
      }
      usagePeriodCase_ = 0;
      usagePeriod_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.billing.budgets.v1beta1.BudgetModel
          .internal_static_google_cloud_billing_budgets_v1beta1_Filter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Filter getDefaultInstanceForType() {
      return com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Filter build() {
      com.google.cloud.billing.budgets.v1beta1.Filter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Filter buildPartial() {
      com.google.cloud.billing.budgets.v1beta1.Filter result =
          new com.google.cloud.billing.budgets.v1beta1.Filter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.billing.budgets.v1beta1.Filter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        projects_.makeImmutable();
        result.projects_ = projects_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        resourceAncestors_.makeImmutable();
        result.resourceAncestors_ = resourceAncestors_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        creditTypes_.makeImmutable();
        result.creditTypes_ = creditTypes_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creditTypesTreatment_ = creditTypesTreatment_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        services_.makeImmutable();
        result.services_ = services_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        subaccounts_.makeImmutable();
        result.subaccounts_ = subaccounts_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
    }

    private void buildPartialOneofs(com.google.cloud.billing.budgets.v1beta1.Filter result) {
      result.usagePeriodCase_ = usagePeriodCase_;
      result.usagePeriod_ = this.usagePeriod_;
      if (usagePeriodCase_ == 9 && customPeriodBuilder_ != null) {
        result.usagePeriod_ = customPeriodBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.billing.budgets.v1beta1.Filter) {
        return mergeFrom((com.google.cloud.billing.budgets.v1beta1.Filter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.billing.budgets.v1beta1.Filter other) {
      if (other == com.google.cloud.billing.budgets.v1beta1.Filter.getDefaultInstance())
        return this;
      if (!other.projects_.isEmpty()) {
        if (projects_.isEmpty()) {
          projects_ = other.projects_;
          bitField0_ |= 0x00000001;
        } else {
          ensureProjectsIsMutable();
          projects_.addAll(other.projects_);
        }
        onChanged();
      }
      if (!other.resourceAncestors_.isEmpty()) {
        if (resourceAncestors_.isEmpty()) {
          resourceAncestors_ = other.resourceAncestors_;
          bitField0_ |= 0x00000002;
        } else {
          ensureResourceAncestorsIsMutable();
          resourceAncestors_.addAll(other.resourceAncestors_);
        }
        onChanged();
      }
      if (!other.creditTypes_.isEmpty()) {
        if (creditTypes_.isEmpty()) {
          creditTypes_ = other.creditTypes_;
          bitField0_ |= 0x00000004;
        } else {
          ensureCreditTypesIsMutable();
          creditTypes_.addAll(other.creditTypes_);
        }
        onChanged();
      }
      if (other.creditTypesTreatment_ != 0) {
        setCreditTypesTreatmentValue(other.getCreditTypesTreatmentValue());
      }
      if (!other.services_.isEmpty()) {
        if (services_.isEmpty()) {
          services_ = other.services_;
          bitField0_ |= 0x00000010;
        } else {
          ensureServicesIsMutable();
          services_.addAll(other.services_);
        }
        onChanged();
      }
      if (!other.subaccounts_.isEmpty()) {
        if (subaccounts_.isEmpty()) {
          subaccounts_ = other.subaccounts_;
          bitField0_ |= 0x00000020;
        } else {
          ensureSubaccountsIsMutable();
          subaccounts_.addAll(other.subaccounts_);
        }
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      switch (other.getUsagePeriodCase()) {
        case CALENDAR_PERIOD:
          {
            setCalendarPeriodValue(other.getCalendarPeriodValue());
            break;
          }
        case CUSTOM_PERIOD:
          {
            mergeCustomPeriod(other.getCustomPeriod());
            break;
          }
        case USAGEPERIOD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureProjectsIsMutable();
                projects_.add(s);
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourceAncestorsIsMutable();
                resourceAncestors_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureServicesIsMutable();
                services_.add(s);
                break;
              } // case 26
            case 32:
              {
                creditTypesTreatment_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSubaccountsIsMutable();
                subaccounts_.add(s);
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.ListValue>
                    labels__ =
                        input.readMessage(
                            LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCreditTypesIsMutable();
                creditTypes_.add(s);
                break;
              } // case 58
            case 64:
              {
                int rawValue = input.readEnum();
                usagePeriodCase_ = 8;
                usagePeriod_ = rawValue;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getCustomPeriodFieldBuilder().getBuilder(), extensionRegistry);
                usagePeriodCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int usagePeriodCase_ = 0;
    private java.lang.Object usagePeriod_;

    public UsagePeriodCase getUsagePeriodCase() {
      return UsagePeriodCase.forNumber(usagePeriodCase_);
    }

    public Builder clearUsagePeriod() {
      usagePeriodCase_ = 0;
      usagePeriod_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList projects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureProjectsIsMutable() {
      if (!projects_.isModifiable()) {
        projects_ = new com.google.protobuf.LazyStringArrayList(projects_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the projects.
     */
    public com.google.protobuf.ProtocolStringList getProjectsList() {
      projects_.makeImmutable();
      return projects_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of projects.
     */
    public int getProjectsCount() {
      return projects_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The projects at the given index.
     */
    public java.lang.String getProjects(int index) {
      return projects_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the projects at the given index.
     */
    public com.google.protobuf.ByteString getProjectsBytes(int index) {
      return projects_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The projects to set.
     * @return This builder for chaining.
     */
    public Builder setProjects(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProjectsIsMutable();
      projects_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The projects to add.
     * @return This builder for chaining.
     */
    public Builder addProjects(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProjectsIsMutable();
      projects_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The projects to add.
     * @return This builder for chaining.
     */
    public Builder addAllProjects(java.lang.Iterable<java.lang.String> values) {
      ensureProjectsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, projects_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjects() {
      projects_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of projects of the form `projects/{project}`,
     * specifying that usage from only this set of projects should be
     * included in the budget. If omitted, the report will include all usage for
     * the billing account, regardless of which project the usage occurred on.
     * </pre>
     *
     * <code>repeated string projects = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the projects to add.
     * @return This builder for chaining.
     */
    public Builder addProjectsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProjectsIsMutable();
      projects_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList resourceAncestors_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureResourceAncestorsIsMutable() {
      if (!resourceAncestors_.isModifiable()) {
        resourceAncestors_ = new com.google.protobuf.LazyStringArrayList(resourceAncestors_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the resourceAncestors.
     */
    public com.google.protobuf.ProtocolStringList getResourceAncestorsList() {
      resourceAncestors_.makeImmutable();
      return resourceAncestors_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of resourceAncestors.
     */
    public int getResourceAncestorsCount() {
      return resourceAncestors_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The resourceAncestors at the given index.
     */
    public java.lang.String getResourceAncestors(int index) {
      return resourceAncestors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourceAncestors at the given index.
     */
    public com.google.protobuf.ByteString getResourceAncestorsBytes(int index) {
      return resourceAncestors_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The resourceAncestors to set.
     * @return This builder for chaining.
     */
    public Builder setResourceAncestors(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceAncestorsIsMutable();
      resourceAncestors_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The resourceAncestors to add.
     * @return This builder for chaining.
     */
    public Builder addResourceAncestors(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourceAncestorsIsMutable();
      resourceAncestors_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The resourceAncestors to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourceAncestors(java.lang.Iterable<java.lang.String> values) {
      ensureResourceAncestorsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourceAncestors_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceAncestors() {
      resourceAncestors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of folder and organization names of the form
     * `folders/{folderId}` or `organizations/{organizationId}`, specifying that
     * usage from only this set of folders and organizations should be included in
     * the budget. If omitted, the budget includes all usage that the billing
     * account pays for. If the folder or organization contains projects that are
     * paid for by a different Cloud Billing account, the budget *doesn't* apply
     * to those projects.
     * </pre>
     *
     * <code>repeated string resource_ancestors = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the resourceAncestors to add.
     * @return This builder for chaining.
     */
    public Builder addResourceAncestorsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourceAncestorsIsMutable();
      resourceAncestors_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList creditTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCreditTypesIsMutable() {
      if (!creditTypes_.isModifiable()) {
        creditTypes_ = new com.google.protobuf.LazyStringArrayList(creditTypes_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the creditTypes.
     */
    public com.google.protobuf.ProtocolStringList getCreditTypesList() {
      creditTypes_.makeImmutable();
      return creditTypes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of creditTypes.
     */
    public int getCreditTypesCount() {
      return creditTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The creditTypes at the given index.
     */
    public java.lang.String getCreditTypes(int index) {
      return creditTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the creditTypes at the given index.
     */
    public com.google.protobuf.ByteString getCreditTypesBytes(int index) {
      return creditTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The creditTypes to set.
     * @return This builder for chaining.
     */
    public Builder setCreditTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCreditTypesIsMutable();
      creditTypes_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The creditTypes to add.
     * @return This builder for chaining.
     */
    public Builder addCreditTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCreditTypesIsMutable();
      creditTypes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The creditTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllCreditTypes(java.lang.Iterable<java.lang.String> values) {
      ensureCreditTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, creditTypes_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreditTypes() {
      creditTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is INCLUDE_SPECIFIED_CREDITS, this is a list of credit types to be
     * subtracted from gross cost to determine the spend for threshold
     * calculations. See [a list of acceptable credit type
     * values](https://cloud.google.com/billing/docs/how-to/export-data-bigquery-tables#credits-type).
     *
     * If
     * [Filter.credit_types_treatment][google.cloud.billing.budgets.v1beta1.Filter.credit_types_treatment]
     * is **not** INCLUDE_SPECIFIED_CREDITS, this field must be empty.
     * </pre>
     *
     * <code>repeated string credit_types = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the creditTypes to add.
     * @return This builder for chaining.
     */
    public Builder addCreditTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCreditTypesIsMutable();
      creditTypes_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int creditTypesTreatment_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for creditTypesTreatment.
     */
    @java.lang.Override
    public int getCreditTypesTreatmentValue() {
      return creditTypesTreatment_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for creditTypesTreatment to set.
     * @return This builder for chaining.
     */
    public Builder setCreditTypesTreatmentValue(int value) {
      creditTypesTreatment_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The creditTypesTreatment.
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment
        getCreditTypesTreatment() {
      com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment result =
          com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment.forNumber(
              creditTypesTreatment_);
      return result == null
          ? com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The creditTypesTreatment to set.
     * @return This builder for chaining.
     */
    public Builder setCreditTypesTreatment(
        com.google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      creditTypesTreatment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.Filter.CreditTypesTreatment credit_types_treatment = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreditTypesTreatment() {
      bitField0_ = (bitField0_ & ~0x00000008);
      creditTypesTreatment_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList services_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureServicesIsMutable() {
      if (!services_.isModifiable()) {
        services_ = new com.google.protobuf.LazyStringArrayList(services_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the services.
     */
    public com.google.protobuf.ProtocolStringList getServicesList() {
      services_.makeImmutable();
      return services_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of services.
     */
    public int getServicesCount() {
      return services_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The services at the given index.
     */
    public java.lang.String getServices(int index) {
      return services_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the services at the given index.
     */
    public com.google.protobuf.ByteString getServicesBytes(int index) {
      return services_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The services to set.
     * @return This builder for chaining.
     */
    public Builder setServices(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServicesIsMutable();
      services_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The services to add.
     * @return This builder for chaining.
     */
    public Builder addServices(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureServicesIsMutable();
      services_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The services to add.
     * @return This builder for chaining.
     */
    public Builder addAllServices(java.lang.Iterable<java.lang.String> values) {
      ensureServicesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, services_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServices() {
      services_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of services of the form `services/{service_id}`,
     * specifying that usage from only this set of services should be
     * included in the budget. If omitted, the report will include usage for
     * all the services.
     * The service names are available through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     * </pre>
     *
     * <code>repeated string services = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the services to add.
     * @return This builder for chaining.
     */
    public Builder addServicesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureServicesIsMutable();
      services_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList subaccounts_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSubaccountsIsMutable() {
      if (!subaccounts_.isModifiable()) {
        subaccounts_ = new com.google.protobuf.LazyStringArrayList(subaccounts_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the subaccounts.
     */
    public com.google.protobuf.ProtocolStringList getSubaccountsList() {
      subaccounts_.makeImmutable();
      return subaccounts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of subaccounts.
     */
    public int getSubaccountsCount() {
      return subaccounts_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The subaccounts at the given index.
     */
    public java.lang.String getSubaccounts(int index) {
      return subaccounts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the subaccounts at the given index.
     */
    public com.google.protobuf.ByteString getSubaccountsBytes(int index) {
      return subaccounts_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The subaccounts to set.
     * @return This builder for chaining.
     */
    public Builder setSubaccounts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubaccountsIsMutable();
      subaccounts_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The subaccounts to add.
     * @return This builder for chaining.
     */
    public Builder addSubaccounts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSubaccountsIsMutable();
      subaccounts_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The subaccounts to add.
     * @return This builder for chaining.
     */
    public Builder addAllSubaccounts(java.lang.Iterable<java.lang.String> values) {
      ensureSubaccountsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subaccounts_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubaccounts() {
      subaccounts_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A set of subaccounts of the form `billingAccounts/{account_id}`,
     * specifying that usage from only this set of subaccounts should be included
     * in the budget. If a subaccount is set to the name of the parent account,
     * usage from the parent account will be included. If omitted, the
     * report will include usage from the parent account and all
     * subaccounts, if they exist.
     * </pre>
     *
     * <code>repeated string subaccounts = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the subaccounts to add.
     * @return This builder for chaining.
     */
    public Builder addSubaccountsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSubaccountsIsMutable();
      subaccounts_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue> labels_;

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
        internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.ListValue>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protobuf.ListValue getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.protobuf.ListValue defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ListValue> map =
          internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.ListValue getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.protobuf.ListValue> map =
          internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.ListValue> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putLabels(java.lang.String key, com.google.protobuf.ListValue value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A single label and value pair specifying that usage from only
     * this set of labeled resources should be included in the budget. If omitted,
     * the report will include all labeled and unlabeled usage.
     *
     * An object containing a single `"key": value` pair. Example: `{ "name":
     * "wrench" }`.
     *
     *  _Currently, multiple entries or multiple values per entry are not
     *  allowed._
     * </pre>
     *
     * <code>
     * map&lt;string, .google.protobuf.ListValue&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllLabels(
        java.util.Map<java.lang.String, com.google.protobuf.ListValue> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the calendarPeriod field is set.
     */
    @java.lang.Override
    public boolean hasCalendarPeriod() {
      return usagePeriodCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for calendarPeriod.
     */
    @java.lang.Override
    public int getCalendarPeriodValue() {
      if (usagePeriodCase_ == 8) {
        return ((java.lang.Integer) usagePeriod_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for calendarPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCalendarPeriodValue(int value) {
      usagePeriodCase_ = 8;
      usagePeriod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The calendarPeriod.
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.CalendarPeriod getCalendarPeriod() {
      if (usagePeriodCase_ == 8) {
        com.google.cloud.billing.budgets.v1beta1.CalendarPeriod result =
            com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.forNumber(
                (java.lang.Integer) usagePeriod_);
        return result == null
            ? com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.billing.budgets.v1beta1.CalendarPeriod.CALENDAR_PERIOD_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The calendarPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCalendarPeriod(
        com.google.cloud.billing.budgets.v1beta1.CalendarPeriod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      usagePeriodCase_ = 8;
      usagePeriod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage for recurring calendar period.
     * For example, assume that CalendarPeriod.QUARTER is set. The budget will
     * track usage from April 1 to June 30, when the current calendar month is
     * April, May, June. After that, it will track usage from July 1 to
     * September 30 when the current calendar month is July, August, September,
     * so on.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CalendarPeriod calendar_period = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCalendarPeriod() {
      if (usagePeriodCase_ == 8) {
        usagePeriodCase_ = 0;
        usagePeriod_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.CustomPeriod,
            com.google.cloud.billing.budgets.v1beta1.CustomPeriod.Builder,
            com.google.cloud.billing.budgets.v1beta1.CustomPeriodOrBuilder>
        customPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customPeriod field is set.
     */
    @java.lang.Override
    public boolean hasCustomPeriod() {
      return usagePeriodCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customPeriod.
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.CustomPeriod getCustomPeriod() {
      if (customPeriodBuilder_ == null) {
        if (usagePeriodCase_ == 9) {
          return (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_;
        }
        return com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
      } else {
        if (usagePeriodCase_ == 9) {
          return customPeriodBuilder_.getMessage();
        }
        return com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomPeriod(com.google.cloud.billing.budgets.v1beta1.CustomPeriod value) {
      if (customPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usagePeriod_ = value;
        onChanged();
      } else {
        customPeriodBuilder_.setMessage(value);
      }
      usagePeriodCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomPeriod(
        com.google.cloud.billing.budgets.v1beta1.CustomPeriod.Builder builderForValue) {
      if (customPeriodBuilder_ == null) {
        usagePeriod_ = builderForValue.build();
        onChanged();
      } else {
        customPeriodBuilder_.setMessage(builderForValue.build());
      }
      usagePeriodCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomPeriod(com.google.cloud.billing.budgets.v1beta1.CustomPeriod value) {
      if (customPeriodBuilder_ == null) {
        if (usagePeriodCase_ == 9
            && usagePeriod_
                != com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance()) {
          usagePeriod_ =
              com.google.cloud.billing.budgets.v1beta1.CustomPeriod.newBuilder(
                      (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          usagePeriod_ = value;
        }
        onChanged();
      } else {
        if (usagePeriodCase_ == 9) {
          customPeriodBuilder_.mergeFrom(value);
        } else {
          customPeriodBuilder_.setMessage(value);
        }
      }
      usagePeriodCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomPeriod() {
      if (customPeriodBuilder_ == null) {
        if (usagePeriodCase_ == 9) {
          usagePeriodCase_ = 0;
          usagePeriod_ = null;
          onChanged();
        }
      } else {
        if (usagePeriodCase_ == 9) {
          usagePeriodCase_ = 0;
          usagePeriod_ = null;
        }
        customPeriodBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.billing.budgets.v1beta1.CustomPeriod.Builder getCustomPeriodBuilder() {
      return getCustomPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.billing.budgets.v1beta1.CustomPeriodOrBuilder
        getCustomPeriodOrBuilder() {
      if ((usagePeriodCase_ == 9) && (customPeriodBuilder_ != null)) {
        return customPeriodBuilder_.getMessageOrBuilder();
      } else {
        if (usagePeriodCase_ == 9) {
          return (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_;
        }
        return com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies to track usage from any start date (required) to any
     * end date (optional). This time period is static, it does not recur.
     * </pre>
     *
     * <code>
     * .google.cloud.billing.budgets.v1beta1.CustomPeriod custom_period = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.billing.budgets.v1beta1.CustomPeriod,
            com.google.cloud.billing.budgets.v1beta1.CustomPeriod.Builder,
            com.google.cloud.billing.budgets.v1beta1.CustomPeriodOrBuilder>
        getCustomPeriodFieldBuilder() {
      if (customPeriodBuilder_ == null) {
        if (!(usagePeriodCase_ == 9)) {
          usagePeriod_ = com.google.cloud.billing.budgets.v1beta1.CustomPeriod.getDefaultInstance();
        }
        customPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.billing.budgets.v1beta1.CustomPeriod,
                com.google.cloud.billing.budgets.v1beta1.CustomPeriod.Builder,
                com.google.cloud.billing.budgets.v1beta1.CustomPeriodOrBuilder>(
                (com.google.cloud.billing.budgets.v1beta1.CustomPeriod) usagePeriod_,
                getParentForChildren(),
                isClean());
        usagePeriod_ = null;
      }
      usagePeriodCase_ = 9;
      onChanged();
      return customPeriodBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.billing.budgets.v1beta1.Filter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.billing.budgets.v1beta1.Filter)
  private static final com.google.cloud.billing.budgets.v1beta1.Filter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.billing.budgets.v1beta1.Filter();
  }

  public static com.google.cloud.billing.budgets.v1beta1.Filter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Filter> PARSER =
      new com.google.protobuf.AbstractParser<Filter>() {
        @java.lang.Override
        public Filter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Filter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Filter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.billing.budgets.v1beta1.Filter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
