/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.protos.google.cloud.binaryauthorization.v1;

public final class Resources {
  private Resources() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface PolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.Policy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
     */
    int getGlobalPolicyEvaluationModeValue();
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The globalPolicyEvaluationMode.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
            .GlobalPolicyEvaluationMode
        getGlobalPolicyEvaluationMode();

    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .AdmissionWhitelistPattern>
        getAdmissionWhitelistPatternsList();
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
        getAdmissionWhitelistPatterns(int index);
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getAdmissionWhitelistPatternsCount();
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPatternOrBuilder>
        getAdmissionWhitelistPatternsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPatternOrBuilder
        getAdmissionWhitelistPatternsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getClusterAdmissionRulesCount();
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsClusterAdmissionRules(java.lang.String key);
    /** Use {@link #getClusterAdmissionRulesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getClusterAdmissionRules();
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getClusterAdmissionRulesMap();
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getClusterAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getClusterAdmissionRulesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getKubernetesNamespaceAdmissionRulesCount();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key);
    /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesNamespaceAdmissionRules();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesNamespaceAdmissionRulesMap();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getKubernetesServiceAccountAdmissionRulesCount();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key);
    /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesServiceAccountAdmissionRules();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesServiceAccountAdmissionRulesMap();
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getIstioServiceIdentityAdmissionRulesCount();
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key);
    /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getIstioServiceIdentityAdmissionRules();
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getIstioServiceIdentityAdmissionRulesMap();
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the defaultAdmissionRule field is set.
     */
    boolean hasDefaultAdmissionRule();
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The defaultAdmissionRule.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getDefaultAdmissionRule();
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
        getDefaultAdmissionRuleOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A [policy][google.cloud.binaryauthorization.v1.Policy] for container image binary authorization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.Policy}
   */
  public static final class Policy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.Policy)
      PolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Policy.newBuilder() to construct.
    private Policy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Policy() {
      name_ = "";
      description_ = "";
      globalPolicyEvaluationMode_ = 0;
      admissionWhitelistPatterns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Policy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetClusterAdmissionRules();
        case 10:
          return internalGetKubernetesNamespaceAdmissionRules();
        case 8:
          return internalGetKubernetesServiceAccountAdmissionRules();
        case 9:
          return internalGetIstioServiceIdentityAdmissionRules();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_Policy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy.class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy.Builder.class);
    }

    /**
     * Protobuf enum {@code google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode}
     */
    public enum GlobalPolicyEvaluationMode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified: DISABLE is assumed.
       * </pre>
       *
       * <code>GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED = 0;</code>
       */
      GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Enables system policy evaluation.
       * </pre>
       *
       * <code>ENABLE = 1;</code>
       */
      ENABLE(1),
      /**
       *
       *
       * <pre>
       * Disables system policy evaluation.
       * </pre>
       *
       * <code>DISABLE = 2;</code>
       */
      DISABLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified: DISABLE is assumed.
       * </pre>
       *
       * <code>GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED = 0;</code>
       */
      public static final int GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Enables system policy evaluation.
       * </pre>
       *
       * <code>ENABLE = 1;</code>
       */
      public static final int ENABLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Disables system policy evaluation.
       * </pre>
       *
       * <code>DISABLE = 2;</code>
       */
      public static final int DISABLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GlobalPolicyEvaluationMode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GlobalPolicyEvaluationMode forNumber(int value) {
        switch (value) {
          case 0:
            return GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED;
          case 1:
            return ENABLE;
          case 2:
            return DISABLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>() {
                public GlobalPolicyEvaluationMode findValueByNumber(int number) {
                  return GlobalPolicyEvaluationMode.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final GlobalPolicyEvaluationMode[] VALUES = values();

      public static GlobalPolicyEvaluationMode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GlobalPolicyEvaluationMode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode)
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GLOBAL_POLICY_EVALUATION_MODE_FIELD_NUMBER = 7;
    private int globalPolicyEvaluationMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
     */
    @java.lang.Override
    public int getGlobalPolicyEvaluationModeValue() {
      return globalPolicyEvaluationMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The globalPolicyEvaluationMode.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
            .GlobalPolicyEvaluationMode
        getGlobalPolicyEvaluationMode() {
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
              .GlobalPolicyEvaluationMode
          result =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                  .GlobalPolicyEvaluationMode.forNumber(globalPolicyEvaluationMode_);
      return result == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
              .GlobalPolicyEvaluationMode.UNRECOGNIZED
          : result;
    }

    public static final int ADMISSION_WHITELIST_PATTERNS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .AdmissionWhitelistPattern>
        admissionWhitelistPatterns_;
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .AdmissionWhitelistPattern>
        getAdmissionWhitelistPatternsList() {
      return admissionWhitelistPatterns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPatternOrBuilder>
        getAdmissionWhitelistPatternsOrBuilderList() {
      return admissionWhitelistPatterns_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getAdmissionWhitelistPatternsCount() {
      return admissionWhitelistPatterns_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
        getAdmissionWhitelistPatterns(int index) {
      return admissionWhitelistPatterns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPatternOrBuilder
        getAdmissionWhitelistPatternsOrBuilder(int index) {
      return admissionWhitelistPatterns_.get(index);
    }

    public static final int CLUSTER_ADMISSION_RULES_FIELD_NUMBER = 3;

    private static final class ClusterAdmissionRulesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
                      newDefaultInstance(
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        clusterAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        internalGetClusterAdmissionRules() {
      if (clusterAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ClusterAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return clusterAdmissionRules_;
    }

    public int getClusterAdmissionRulesCount() {
      return internalGetClusterAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsClusterAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetClusterAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getClusterAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getClusterAdmissionRules() {
      return getClusterAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getClusterAdmissionRulesMap() {
      return internalGetClusterAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionRule
        getClusterAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetClusterAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getClusterAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetClusterAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int KUBERNETES_NAMESPACE_ADMISSION_RULES_FIELD_NUMBER = 10;

    private static final class KubernetesNamespaceAdmissionRulesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
                      newDefaultInstance(
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        kubernetesNamespaceAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        internalGetKubernetesNamespaceAdmissionRules() {
      if (kubernetesNamespaceAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return kubernetesNamespaceAdmissionRules_;
    }

    public int getKubernetesNamespaceAdmissionRulesCount() {
      return internalGetKubernetesNamespaceAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetKubernetesNamespaceAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesNamespaceAdmissionRules() {
      return getKubernetesNamespaceAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesNamespaceAdmissionRulesMap() {
      return internalGetKubernetesNamespaceAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetKubernetesNamespaceAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     * [a-z.-]+, e.g. 'some-namespace'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetKubernetesNamespaceAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int KUBERNETES_SERVICE_ACCOUNT_ADMISSION_RULES_FIELD_NUMBER = 8;

    private static final class KubernetesServiceAccountAdmissionRulesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
                      newDefaultInstance(
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        kubernetesServiceAccountAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        internalGetKubernetesServiceAccountAdmissionRules() {
      if (kubernetesServiceAccountAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return kubernetesServiceAccountAdmissionRules_;
    }

    public int getKubernetesServiceAccountAdmissionRulesCount() {
      return internalGetKubernetesServiceAccountAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetKubernetesServiceAccountAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesServiceAccountAdmissionRules() {
      return getKubernetesServiceAccountAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getKubernetesServiceAccountAdmissionRulesMap() {
      return internalGetKubernetesServiceAccountAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ISTIO_SERVICE_IDENTITY_ADMISSION_RULES_FIELD_NUMBER = 9;

    private static final class IstioServiceIdentityAdmissionRulesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
                      newDefaultInstance(
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        istioServiceIdentityAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        internalGetIstioServiceIdentityAdmissionRules() {
      if (istioServiceIdentityAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return istioServiceIdentityAdmissionRules_;
    }

    public int getIstioServiceIdentityAdmissionRulesCount() {
      return internalGetIstioServiceIdentityAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIstioServiceIdentityAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getIstioServiceIdentityAdmissionRules() {
      return getIstioServiceIdentityAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
        getIstioServiceIdentityAdmissionRulesMap() {
      return internalGetIstioServiceIdentityAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetIstioServiceIdentityAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
     * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
     * e.g. spiffe://example.com/ns/test-ns/sa/default
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          map = internalGetIstioServiceIdentityAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int DEFAULT_ADMISSION_RULE_FIELD_NUMBER = 4;
    private com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        defaultAdmissionRule_;
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the defaultAdmissionRule field is set.
     */
    @java.lang.Override
    public boolean hasDefaultAdmissionRule() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The defaultAdmissionRule.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getDefaultAdmissionRule() {
      return defaultAdmissionRule_ == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .getDefaultInstance()
          : defaultAdmissionRule_;
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
        getDefaultAdmissionRuleOrBuilder() {
      return defaultAdmissionRule_ == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .getDefaultInstance()
          : defaultAdmissionRule_;
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      for (int i = 0; i < admissionWhitelistPatterns_.size(); i++) {
        output.writeMessage(2, admissionWhitelistPatterns_.get(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetClusterAdmissionRules(),
          ClusterAdmissionRulesDefaultEntryHolder.defaultEntry,
          3);
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getDefaultAdmissionRule());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(5, getUpdateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
      }
      if (globalPolicyEvaluationMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
              .GlobalPolicyEvaluationMode.GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, globalPolicyEvaluationMode_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetKubernetesServiceAccountAdmissionRules(),
          KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry,
          8);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetIstioServiceIdentityAdmissionRules(),
          IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry,
          9);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetKubernetesNamespaceAdmissionRules(),
          KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry,
          10);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      for (int i = 0; i < admissionWhitelistPatterns_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, admissionWhitelistPatterns_.get(i));
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          entry : internalGetClusterAdmissionRules().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            clusterAdmissionRules__ =
                ClusterAdmissionRulesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, clusterAdmissionRules__);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDefaultAdmissionRule());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
      }
      if (globalPolicyEvaluationMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
              .GlobalPolicyEvaluationMode.GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
              .getNumber()) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(7, globalPolicyEvaluationMode_);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          entry : internalGetKubernetesServiceAccountAdmissionRules().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            kubernetesServiceAccountAdmissionRules__ =
                KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, kubernetesServiceAccountAdmissionRules__);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          entry : internalGetIstioServiceIdentityAdmissionRules().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            istioServiceIdentityAdmissionRules__ =
                IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, istioServiceIdentityAdmissionRules__);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          entry : internalGetKubernetesNamespaceAdmissionRules().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            kubernetesNamespaceAdmissionRules__ =
                KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, kubernetesNamespaceAdmissionRules__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (globalPolicyEvaluationMode_ != other.globalPolicyEvaluationMode_) return false;
      if (!getAdmissionWhitelistPatternsList().equals(other.getAdmissionWhitelistPatternsList()))
        return false;
      if (!internalGetClusterAdmissionRules().equals(other.internalGetClusterAdmissionRules()))
        return false;
      if (!internalGetKubernetesNamespaceAdmissionRules()
          .equals(other.internalGetKubernetesNamespaceAdmissionRules())) return false;
      if (!internalGetKubernetesServiceAccountAdmissionRules()
          .equals(other.internalGetKubernetesServiceAccountAdmissionRules())) return false;
      if (!internalGetIstioServiceIdentityAdmissionRules()
          .equals(other.internalGetIstioServiceIdentityAdmissionRules())) return false;
      if (hasDefaultAdmissionRule() != other.hasDefaultAdmissionRule()) return false;
      if (hasDefaultAdmissionRule()) {
        if (!getDefaultAdmissionRule().equals(other.getDefaultAdmissionRule())) return false;
      }
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + GLOBAL_POLICY_EVALUATION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + globalPolicyEvaluationMode_;
      if (getAdmissionWhitelistPatternsCount() > 0) {
        hash = (37 * hash) + ADMISSION_WHITELIST_PATTERNS_FIELD_NUMBER;
        hash = (53 * hash) + getAdmissionWhitelistPatternsList().hashCode();
      }
      if (!internalGetClusterAdmissionRules().getMap().isEmpty()) {
        hash = (37 * hash) + CLUSTER_ADMISSION_RULES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetClusterAdmissionRules().hashCode();
      }
      if (!internalGetKubernetesNamespaceAdmissionRules().getMap().isEmpty()) {
        hash = (37 * hash) + KUBERNETES_NAMESPACE_ADMISSION_RULES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetKubernetesNamespaceAdmissionRules().hashCode();
      }
      if (!internalGetKubernetesServiceAccountAdmissionRules().getMap().isEmpty()) {
        hash = (37 * hash) + KUBERNETES_SERVICE_ACCOUNT_ADMISSION_RULES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetKubernetesServiceAccountAdmissionRules().hashCode();
      }
      if (!internalGetIstioServiceIdentityAdmissionRules().getMap().isEmpty()) {
        hash = (37 * hash) + ISTIO_SERVICE_IDENTITY_ADMISSION_RULES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetIstioServiceIdentityAdmissionRules().hashCode();
      }
      if (hasDefaultAdmissionRule()) {
        hash = (37 * hash) + DEFAULT_ADMISSION_RULE_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultAdmissionRule().hashCode();
      }
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A [policy][google.cloud.binaryauthorization.v1.Policy] for container image binary authorization.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.Policy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.Policy)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetClusterAdmissionRules();
          case 10:
            return internalGetKubernetesNamespaceAdmissionRules();
          case 8:
            return internalGetKubernetesServiceAccountAdmissionRules();
          case 9:
            return internalGetIstioServiceIdentityAdmissionRules();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 3:
            return internalGetMutableClusterAdmissionRules();
          case 10:
            return internalGetMutableKubernetesNamespaceAdmissionRules();
          case 8:
            return internalGetMutableKubernetesServiceAccountAdmissionRules();
          case 9:
            return internalGetMutableIstioServiceIdentityAdmissionRules();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Policy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy.class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy.Builder
                    .class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAdmissionWhitelistPatternsFieldBuilder();
          getDefaultAdmissionRuleFieldBuilder();
          getUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        description_ = "";
        globalPolicyEvaluationMode_ = 0;
        if (admissionWhitelistPatternsBuilder_ == null) {
          admissionWhitelistPatterns_ = java.util.Collections.emptyList();
        } else {
          admissionWhitelistPatterns_ = null;
          admissionWhitelistPatternsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableClusterAdmissionRules().clear();
        internalGetMutableKubernetesNamespaceAdmissionRules().clear();
        internalGetMutableKubernetesServiceAccountAdmissionRules().clear();
        internalGetMutableIstioServiceIdentityAdmissionRules().clear();
        defaultAdmissionRule_ = null;
        if (defaultAdmissionRuleBuilder_ != null) {
          defaultAdmissionRuleBuilder_.dispose();
          defaultAdmissionRuleBuilder_ = null;
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy result =
            new com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy result) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            admissionWhitelistPatterns_ =
                java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.admissionWhitelistPatterns_ = admissionWhitelistPatterns_;
        } else {
          result.admissionWhitelistPatterns_ = admissionWhitelistPatternsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.globalPolicyEvaluationMode_ = globalPolicyEvaluationMode_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.clusterAdmissionRules_ =
              internalGetClusterAdmissionRules()
                  .build(ClusterAdmissionRulesDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.kubernetesNamespaceAdmissionRules_ =
              internalGetKubernetesNamespaceAdmissionRules()
                  .build(KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.kubernetesServiceAccountAdmissionRules_ =
              internalGetKubernetesServiceAccountAdmissionRules()
                  .build(KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry);
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.istioServiceIdentityAdmissionRules_ =
              internalGetIstioServiceIdentityAdmissionRules()
                  .build(IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry);
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.defaultAdmissionRule_ =
              defaultAdmissionRuleBuilder_ == null
                  ? defaultAdmissionRule_
                  : defaultAdmissionRuleBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.globalPolicyEvaluationMode_ != 0) {
          setGlobalPolicyEvaluationModeValue(other.getGlobalPolicyEvaluationModeValue());
        }
        if (admissionWhitelistPatternsBuilder_ == null) {
          if (!other.admissionWhitelistPatterns_.isEmpty()) {
            if (admissionWhitelistPatterns_.isEmpty()) {
              admissionWhitelistPatterns_ = other.admissionWhitelistPatterns_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureAdmissionWhitelistPatternsIsMutable();
              admissionWhitelistPatterns_.addAll(other.admissionWhitelistPatterns_);
            }
            onChanged();
          }
        } else {
          if (!other.admissionWhitelistPatterns_.isEmpty()) {
            if (admissionWhitelistPatternsBuilder_.isEmpty()) {
              admissionWhitelistPatternsBuilder_.dispose();
              admissionWhitelistPatternsBuilder_ = null;
              admissionWhitelistPatterns_ = other.admissionWhitelistPatterns_;
              bitField0_ = (bitField0_ & ~0x00000008);
              admissionWhitelistPatternsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAdmissionWhitelistPatternsFieldBuilder()
                      : null;
            } else {
              admissionWhitelistPatternsBuilder_.addAllMessages(other.admissionWhitelistPatterns_);
            }
          }
        }
        internalGetMutableClusterAdmissionRules()
            .mergeFrom(other.internalGetClusterAdmissionRules());
        bitField0_ |= 0x00000010;
        internalGetMutableKubernetesNamespaceAdmissionRules()
            .mergeFrom(other.internalGetKubernetesNamespaceAdmissionRules());
        bitField0_ |= 0x00000020;
        internalGetMutableKubernetesServiceAccountAdmissionRules()
            .mergeFrom(other.internalGetKubernetesServiceAccountAdmissionRules());
        bitField0_ |= 0x00000040;
        internalGetMutableIstioServiceIdentityAdmissionRules()
            .mergeFrom(other.internalGetIstioServiceIdentityAdmissionRules());
        bitField0_ |= 0x00000080;
        if (other.hasDefaultAdmissionRule()) {
          mergeDefaultAdmissionRule(other.getDefaultAdmissionRule());
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                          .AdmissionWhitelistPattern
                      m =
                          input.readMessage(
                              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                                  .AdmissionWhitelistPattern.parser(),
                              extensionRegistry);
                  if (admissionWhitelistPatternsBuilder_ == null) {
                    ensureAdmissionWhitelistPatternsIsMutable();
                    admissionWhitelistPatterns_.add(m);
                  } else {
                    admissionWhitelistPatternsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule>
                      clusterAdmissionRules__ =
                          input.readMessage(
                              ClusterAdmissionRulesDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableClusterAdmissionRules()
                      .ensureBuilderMap()
                      .put(clusterAdmissionRules__.getKey(), clusterAdmissionRules__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getDefaultAdmissionRuleFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 42
              case 50:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 50
              case 56:
                {
                  globalPolicyEvaluationMode_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 56
              case 66:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule>
                      kubernetesServiceAccountAdmissionRules__ =
                          input.readMessage(
                              KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableKubernetesServiceAccountAdmissionRules()
                      .ensureBuilderMap()
                      .put(
                          kubernetesServiceAccountAdmissionRules__.getKey(),
                          kubernetesServiceAccountAdmissionRules__.getValue());
                  bitField0_ |= 0x00000040;
                  break;
                } // case 66
              case 74:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule>
                      istioServiceIdentityAdmissionRules__ =
                          input.readMessage(
                              IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableIstioServiceIdentityAdmissionRules()
                      .ensureBuilderMap()
                      .put(
                          istioServiceIdentityAdmissionRules__.getKey(),
                          istioServiceIdentityAdmissionRules__.getValue());
                  bitField0_ |= 0x00000080;
                  break;
                } // case 74
              case 82:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.protos.google.cloud.binaryauthorization.v1.Resources
                              .AdmissionRule>
                      kubernetesNamespaceAdmissionRules__ =
                          input.readMessage(
                              KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry
                                  .getParserForType(),
                              extensionRegistry);
                  internalGetMutableKubernetesNamespaceAdmissionRules()
                      .ensureBuilderMap()
                      .put(
                          kubernetesNamespaceAdmissionRules__.getKey(),
                          kubernetesNamespaceAdmissionRules__.getValue());
                  bitField0_ |= 0x00000020;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
       * at most one policy per project.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
       * at most one policy per project.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
       * at most one policy per project.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
       * at most one policy per project.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
       * at most one policy per project.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int globalPolicyEvaluationMode_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Controls the evaluation of a Google-maintained global admission
       * policy for common system-level images. Images not covered by the global
       * policy will be subject to the project admission policy. This setting
       * has no effect when specified inside a global admission policy.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
       */
      @java.lang.Override
      public int getGlobalPolicyEvaluationModeValue() {
        return globalPolicyEvaluationMode_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Controls the evaluation of a Google-maintained global admission
       * policy for common system-level images. Images not covered by the global
       * policy will be subject to the project admission policy. This setting
       * has no effect when specified inside a global admission policy.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for globalPolicyEvaluationMode to set.
       * @return This builder for chaining.
       */
      public Builder setGlobalPolicyEvaluationModeValue(int value) {
        globalPolicyEvaluationMode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Controls the evaluation of a Google-maintained global admission
       * policy for common system-level images. Images not covered by the global
       * policy will be subject to the project admission policy. This setting
       * has no effect when specified inside a global admission policy.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The globalPolicyEvaluationMode.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
              .GlobalPolicyEvaluationMode
          getGlobalPolicyEvaluationMode() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                .GlobalPolicyEvaluationMode
            result =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                    .GlobalPolicyEvaluationMode.forNumber(globalPolicyEvaluationMode_);
        return result == null
            ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                .GlobalPolicyEvaluationMode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. Controls the evaluation of a Google-maintained global admission
       * policy for common system-level images. Images not covered by the global
       * policy will be subject to the project admission policy. This setting
       * has no effect when specified inside a global admission policy.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The globalPolicyEvaluationMode to set.
       * @return This builder for chaining.
       */
      public Builder setGlobalPolicyEvaluationMode(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
                  .GlobalPolicyEvaluationMode
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        globalPolicyEvaluationMode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Controls the evaluation of a Google-maintained global admission
       * policy for common system-level images. Images not covered by the global
       * policy will be subject to the project admission policy. This setting
       * has no effect when specified inside a global admission policy.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGlobalPolicyEvaluationMode() {
        bitField0_ = (bitField0_ & ~0x00000004);
        globalPolicyEvaluationMode_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern>
          admissionWhitelistPatterns_ = java.util.Collections.emptyList();

      private void ensureAdmissionWhitelistPatternsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          admissionWhitelistPatterns_ =
              new java.util.ArrayList<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPattern>(admissionWhitelistPatterns_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPatternOrBuilder>
          admissionWhitelistPatternsBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern>
          getAdmissionWhitelistPatternsList() {
        if (admissionWhitelistPatternsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
        } else {
          return admissionWhitelistPatternsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getAdmissionWhitelistPatternsCount() {
        if (admissionWhitelistPatternsBuilder_ == null) {
          return admissionWhitelistPatterns_.size();
        } else {
          return admissionWhitelistPatternsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern
          getAdmissionWhitelistPatterns(int index) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          return admissionWhitelistPatterns_.get(index);
        } else {
          return admissionWhitelistPatternsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAdmissionWhitelistPatterns(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
              value) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.set(index, value);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAdmissionWhitelistPatterns(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
                  .Builder
              builderForValue) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.set(index, builderForValue.build());
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAdmissionWhitelistPatterns(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
              value) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.add(value);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAdmissionWhitelistPatterns(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
              value) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.add(index, value);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAdmissionWhitelistPatterns(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
                  .Builder
              builderForValue) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.add(builderForValue.build());
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAdmissionWhitelistPatterns(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
                  .Builder
              builderForValue) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.add(index, builderForValue.build());
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllAdmissionWhitelistPatterns(
          java.lang.Iterable<
                  ? extends
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources
                          .AdmissionWhitelistPattern>
              values) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          ensureAdmissionWhitelistPatternsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, admissionWhitelistPatterns_);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAdmissionWhitelistPatterns() {
        if (admissionWhitelistPatternsBuilder_ == null) {
          admissionWhitelistPatterns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeAdmissionWhitelistPatterns(int index) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          ensureAdmissionWhitelistPatternsIsMutable();
          admissionWhitelistPatterns_.remove(index);
          onChanged();
        } else {
          admissionWhitelistPatternsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern.Builder
          getAdmissionWhitelistPatternsBuilder(int index) {
        return getAdmissionWhitelistPatternsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPatternOrBuilder
          getAdmissionWhitelistPatternsOrBuilder(int index) {
        if (admissionWhitelistPatternsBuilder_ == null) {
          return admissionWhitelistPatterns_.get(index);
        } else {
          return admissionWhitelistPatternsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPatternOrBuilder>
          getAdmissionWhitelistPatternsOrBuilderList() {
        if (admissionWhitelistPatternsBuilder_ != null) {
          return admissionWhitelistPatternsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern.Builder
          addAdmissionWhitelistPatternsBuilder() {
        return getAdmissionWhitelistPatternsFieldBuilder()
            .addBuilder(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPattern.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern.Builder
          addAdmissionWhitelistPatternsBuilder(int index) {
        return getAdmissionWhitelistPatternsFieldBuilder()
            .addBuilder(
                index,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPattern.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Admission policy allowlisting. A matching admission request will
       * always be permitted. This feature is typically used to exclude Google or
       * third-party infrastructure images from Binary Authorization policies.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern.Builder>
          getAdmissionWhitelistPatternsBuilderList() {
        return getAdmissionWhitelistPatternsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPatternOrBuilder>
          getAdmissionWhitelistPatternsFieldBuilder() {
        if (admissionWhitelistPatternsBuilder_ == null) {
          admissionWhitelistPatternsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPattern,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPattern.Builder,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPatternOrBuilder>(
                  admissionWhitelistPatterns_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          admissionWhitelistPatterns_ = null;
        }
        return admissionWhitelistPatternsBuilder_;
      }

      private static final class ClusterAdmissionRulesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule> {
        @java.lang.Override
        public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule build(
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
                val) {
          if (val
              instanceof
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                val;
          }
          return ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            defaultEntry() {
          return ClusterAdmissionRulesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final ClusterAdmissionRulesConverter clusterAdmissionRulesConverter =
          new ClusterAdmissionRulesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          clusterAdmissionRules_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetClusterAdmissionRules() {
        if (clusterAdmissionRules_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(clusterAdmissionRulesConverter);
        }
        return clusterAdmissionRules_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetMutableClusterAdmissionRules() {
        if (clusterAdmissionRules_ == null) {
          clusterAdmissionRules_ =
              new com.google.protobuf.MapFieldBuilder<>(clusterAdmissionRulesConverter);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return clusterAdmissionRules_;
      }

      public int getClusterAdmissionRulesCount() {
        return internalGetClusterAdmissionRules().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsClusterAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetClusterAdmissionRules().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getClusterAdmissionRulesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getClusterAdmissionRules() {
        return getClusterAdmissionRulesMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getClusterAdmissionRulesMap() {
        return internalGetClusterAdmissionRules().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionRule
          getClusterAdmissionRulesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableClusterAdmissionRules().ensureBuilderMap();
        return map.containsKey(key)
            ? clusterAdmissionRulesConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getClusterAdmissionRulesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableClusterAdmissionRules().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return clusterAdmissionRulesConverter.build(map.get(key));
      }

      public Builder clearClusterAdmissionRules() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutableClusterAdmissionRules().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeClusterAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableClusterAdmissionRules().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getMutableClusterAdmissionRules() {
        bitField0_ |= 0x00000010;
        return internalGetMutableClusterAdmissionRules().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putClusterAdmissionRules(
          java.lang.String key,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableClusterAdmissionRules().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllClusterAdmissionRules(
          java.util.Map<
                  java.lang.String,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableClusterAdmissionRules().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-cluster admission rules. Cluster spec format:
       * `location.clusterId`. There can be at most one admission rule per cluster
       * spec.
       * A `location` is either a compute zone (e.g. us-central1-a) or a region
       * (e.g. us-central1).
       * For `clusterId` syntax restrictions see
       * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
          putClusterAdmissionRulesBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            builderMap = internalGetMutableClusterAdmissionRules().ensureBuilderMap();
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
            entry = builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
          entry =
              ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                      entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .Builder)
            entry;
      }

      private static final class KubernetesNamespaceAdmissionRulesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule> {
        @java.lang.Override
        public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule build(
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
                val) {
          if (val
              instanceof
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                val;
          }
          return ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            defaultEntry() {
          return KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final KubernetesNamespaceAdmissionRulesConverter
          kubernetesNamespaceAdmissionRulesConverter =
              new KubernetesNamespaceAdmissionRulesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          kubernetesNamespaceAdmissionRules_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetKubernetesNamespaceAdmissionRules() {
        if (kubernetesNamespaceAdmissionRules_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(
              kubernetesNamespaceAdmissionRulesConverter);
        }
        return kubernetesNamespaceAdmissionRules_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetMutableKubernetesNamespaceAdmissionRules() {
        if (kubernetesNamespaceAdmissionRules_ == null) {
          kubernetesNamespaceAdmissionRules_ =
              new com.google.protobuf.MapFieldBuilder<>(kubernetesNamespaceAdmissionRulesConverter);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return kubernetesNamespaceAdmissionRules_;
      }

      public int getKubernetesNamespaceAdmissionRulesCount() {
        return internalGetKubernetesNamespaceAdmissionRules().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetKubernetesNamespaceAdmissionRules().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getKubernetesNamespaceAdmissionRules() {
        return getKubernetesNamespaceAdmissionRulesMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getKubernetesNamespaceAdmissionRulesMap() {
        return internalGetKubernetesNamespaceAdmissionRules().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionRule
          getKubernetesNamespaceAdmissionRulesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap();
        return map.containsKey(key)
            ? kubernetesNamespaceAdmissionRulesConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return kubernetesNamespaceAdmissionRulesConverter.build(map.get(key));
      }

      public Builder clearKubernetesNamespaceAdmissionRules() {
        bitField0_ = (bitField0_ & ~0x00000020);
        internalGetMutableKubernetesNamespaceAdmissionRules().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeKubernetesNamespaceAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getMutableKubernetesNamespaceAdmissionRules() {
        bitField0_ |= 0x00000020;
        return internalGetMutableKubernetesNamespaceAdmissionRules().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putKubernetesNamespaceAdmissionRules(
          java.lang.String key,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllKubernetesNamespaceAdmissionRules(
          java.util.Map<
                  java.lang.String,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
       * [a-z.-]+, e.g. 'some-namespace'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
          putKubernetesNamespaceAdmissionRulesBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            builderMap = internalGetMutableKubernetesNamespaceAdmissionRules().ensureBuilderMap();
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
            entry = builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
          entry =
              ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                      entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .Builder)
            entry;
      }

      private static final class KubernetesServiceAccountAdmissionRulesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule> {
        @java.lang.Override
        public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule build(
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
                val) {
          if (val
              instanceof
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                val;
          }
          return ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            defaultEntry() {
          return KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final KubernetesServiceAccountAdmissionRulesConverter
          kubernetesServiceAccountAdmissionRulesConverter =
              new KubernetesServiceAccountAdmissionRulesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          kubernetesServiceAccountAdmissionRules_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetKubernetesServiceAccountAdmissionRules() {
        if (kubernetesServiceAccountAdmissionRules_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(
              kubernetesServiceAccountAdmissionRulesConverter);
        }
        return kubernetesServiceAccountAdmissionRules_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetMutableKubernetesServiceAccountAdmissionRules() {
        if (kubernetesServiceAccountAdmissionRules_ == null) {
          kubernetesServiceAccountAdmissionRules_ =
              new com.google.protobuf.MapFieldBuilder<>(
                  kubernetesServiceAccountAdmissionRulesConverter);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return kubernetesServiceAccountAdmissionRules_;
      }

      public int getKubernetesServiceAccountAdmissionRulesCount() {
        return internalGetKubernetesServiceAccountAdmissionRules().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetKubernetesServiceAccountAdmissionRules()
            .ensureBuilderMap()
            .containsKey(key);
      }
      /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getKubernetesServiceAccountAdmissionRules() {
        return getKubernetesServiceAccountAdmissionRulesMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getKubernetesServiceAccountAdmissionRulesMap() {
        return internalGetKubernetesServiceAccountAdmissionRules().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionRule
          getKubernetesServiceAccountAdmissionRulesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableKubernetesServiceAccountAdmissionRules().ensureBuilderMap();
        return map.containsKey(key)
            ? kubernetesServiceAccountAdmissionRulesConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableKubernetesServiceAccountAdmissionRules().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return kubernetesServiceAccountAdmissionRulesConverter.build(map.get(key));
      }

      public Builder clearKubernetesServiceAccountAdmissionRules() {
        bitField0_ = (bitField0_ & ~0x00000040);
        internalGetMutableKubernetesServiceAccountAdmissionRules().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeKubernetesServiceAccountAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableKubernetesServiceAccountAdmissionRules().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getMutableKubernetesServiceAccountAdmissionRules() {
        bitField0_ |= 0x00000040;
        return internalGetMutableKubernetesServiceAccountAdmissionRules().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putKubernetesServiceAccountAdmissionRules(
          java.lang.String key,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableKubernetesServiceAccountAdmissionRules()
            .ensureBuilderMap()
            .put(key, value);
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllKubernetesServiceAccountAdmissionRules(
          java.util.Map<
                  java.lang.String,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableKubernetesServiceAccountAdmissionRules()
            .ensureBuilderMap()
            .putAll(values);
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-kubernetes-service-account admission rules. Service account
       * spec format: `namespace:serviceaccount`. e.g. 'test-ns:default'
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
          putKubernetesServiceAccountAdmissionRulesBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            builderMap =
                internalGetMutableKubernetesServiceAccountAdmissionRules().ensureBuilderMap();
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
            entry = builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
          entry =
              ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                      entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .Builder)
            entry;
      }

      private static final class IstioServiceIdentityAdmissionRulesConverter
          implements com.google.protobuf.MapFieldBuilder.Converter<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule> {
        @java.lang.Override
        public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule build(
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
                val) {
          if (val
              instanceof
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                val;
          }
          return ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .Builder)
                  val)
              .build();
        }

        @java.lang.Override
        public com.google.protobuf.MapEntry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            defaultEntry() {
          return IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry;
        }
      };

      private static final IstioServiceIdentityAdmissionRulesConverter
          istioServiceIdentityAdmissionRulesConverter =
              new IstioServiceIdentityAdmissionRulesConverter();

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          istioServiceIdentityAdmissionRules_;

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetIstioServiceIdentityAdmissionRules() {
        if (istioServiceIdentityAdmissionRules_ == null) {
          return new com.google.protobuf.MapFieldBuilder<>(
              istioServiceIdentityAdmissionRulesConverter);
        }
        return istioServiceIdentityAdmissionRules_;
      }

      private com.google.protobuf.MapFieldBuilder<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder>
          internalGetMutableIstioServiceIdentityAdmissionRules() {
        if (istioServiceIdentityAdmissionRules_ == null) {
          istioServiceIdentityAdmissionRules_ =
              new com.google.protobuf.MapFieldBuilder<>(
                  istioServiceIdentityAdmissionRulesConverter);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return istioServiceIdentityAdmissionRules_;
      }

      public int getIstioServiceIdentityAdmissionRulesCount() {
        return internalGetIstioServiceIdentityAdmissionRules().ensureBuilderMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetIstioServiceIdentityAdmissionRules().ensureBuilderMap().containsKey(key);
      }
      /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getIstioServiceIdentityAdmissionRules() {
        return getIstioServiceIdentityAdmissionRulesMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getIstioServiceIdentityAdmissionRulesMap() {
        return internalGetIstioServiceIdentityAdmissionRules().getImmutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionRule
          getIstioServiceIdentityAdmissionRulesOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap();
        return map.containsKey(key)
            ? istioServiceIdentityAdmissionRulesConverter.build(map.get(key))
            : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            map = internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return istioServiceIdentityAdmissionRulesConverter.build(map.get(key));
      }

      public Builder clearIstioServiceIdentityAdmissionRules() {
        bitField0_ = (bitField0_ & ~0x00000080);
        internalGetMutableIstioServiceIdentityAdmissionRules().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeIstioServiceIdentityAdmissionRules(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
          getMutableIstioServiceIdentityAdmissionRules() {
        bitField0_ |= 0x00000080;
        return internalGetMutableIstioServiceIdentityAdmissionRules().ensureMessageMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putIstioServiceIdentityAdmissionRules(
          java.lang.String key,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap().put(key, value);
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllIstioServiceIdentityAdmissionRules(
          java.util.Map<
                  java.lang.String,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
              values) {
        for (java.util.Map.Entry<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule>
            e : values.entrySet()) {
          if (e.getKey() == null || e.getValue() == null) {
            throw new NullPointerException();
          }
        }
        internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap().putAll(values);
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Per-istio-service-identity admission rules. Istio service
       * identity spec format:
       * spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt; or
       * &lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;
       * e.g. spiffe://example.com/ns/test-ns/sa/default
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.binaryauthorization.v1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
          putIstioServiceIdentityAdmissionRulesBuilderIfAbsent(java.lang.String key) {
        java.util.Map<
                java.lang.String,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionRuleOrBuilder>
            builderMap = internalGetMutableIstioServiceIdentityAdmissionRules().ensureBuilderMap();
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
            entry = builderMap.get(key);
        if (entry == null) {
          entry =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .newBuilder();
          builderMap.put(key, entry);
        }
        if (entry
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
          entry =
              ((com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                      entry)
                  .toBuilder();
          builderMap.put(key, entry);
        }
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .Builder)
            entry;
      }

      private com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          defaultAdmissionRule_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder>
          defaultAdmissionRuleBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the defaultAdmissionRule field is set.
       */
      public boolean hasDefaultAdmissionRule() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The defaultAdmissionRule.
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getDefaultAdmissionRule() {
        if (defaultAdmissionRuleBuilder_ == null) {
          return defaultAdmissionRule_ == null
              ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .getDefaultInstance()
              : defaultAdmissionRule_;
        } else {
          return defaultAdmissionRuleBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDefaultAdmissionRule(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (defaultAdmissionRuleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultAdmissionRule_ = value;
        } else {
          defaultAdmissionRuleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDefaultAdmissionRule(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
              builderForValue) {
        if (defaultAdmissionRuleBuilder_ == null) {
          defaultAdmissionRule_ = builderForValue.build();
        } else {
          defaultAdmissionRuleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeDefaultAdmissionRule(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule value) {
        if (defaultAdmissionRuleBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && defaultAdmissionRule_ != null
              && defaultAdmissionRule_
                  != com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .getDefaultInstance()) {
            getDefaultAdmissionRuleBuilder().mergeFrom(value);
          } else {
            defaultAdmissionRule_ = value;
          }
        } else {
          defaultAdmissionRuleBuilder_.mergeFrom(value);
        }
        if (defaultAdmissionRule_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDefaultAdmissionRule() {
        bitField0_ = (bitField0_ & ~0x00000100);
        defaultAdmissionRule_ = null;
        if (defaultAdmissionRuleBuilder_ != null) {
          defaultAdmissionRuleBuilder_.dispose();
          defaultAdmissionRuleBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
          getDefaultAdmissionRuleBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getDefaultAdmissionRuleFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder
          getDefaultAdmissionRuleOrBuilder() {
        if (defaultAdmissionRuleBuilder_ != null) {
          return defaultAdmissionRuleBuilder_.getMessageOrBuilder();
        } else {
          return defaultAdmissionRule_ == null
              ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .getDefaultInstance()
              : defaultAdmissionRule_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Default admission rule for a cluster without a per-cluster, per-
       * kubernetes-service-account, or per-istio-service-identity admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionRuleOrBuilder>
          getDefaultAdmissionRuleFieldBuilder() {
        if (defaultAdmissionRuleBuilder_ == null) {
          defaultAdmissionRuleBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                      .Builder,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionRuleOrBuilder>(
                  getDefaultAdmissionRule(), getParentForChildren(), isClean());
          defaultAdmissionRule_ = null;
        }
        return defaultAdmissionRuleBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        if (updateTime_ != null) {
          bitField0_ |= 0x00000200;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000200);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the policy was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.Policy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.Policy)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Policy> PARSER =
        new com.google.protobuf.AbstractParser<Policy>() {
          @java.lang.Override
          public Policy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Policy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Policy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Policy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AdmissionWhitelistPatternOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An image name pattern to allowlist, in the form `registry/path/to/image`.
     * This supports a trailing `*` wildcard, but this is allowed only in
     * text after the `registry/` part. This also supports a trailing `**`
     * wildcard which matches subdirectories of a given entry.
     * </pre>
     *
     * <code>string name_pattern = 1;</code>
     *
     * @return The namePattern.
     */
    java.lang.String getNamePattern();
    /**
     *
     *
     * <pre>
     * An image name pattern to allowlist, in the form `registry/path/to/image`.
     * This supports a trailing `*` wildcard, but this is allowed only in
     * text after the `registry/` part. This also supports a trailing `**`
     * wildcard which matches subdirectories of a given entry.
     * </pre>
     *
     * <code>string name_pattern = 1;</code>
     *
     * @return The bytes for namePattern.
     */
    com.google.protobuf.ByteString getNamePatternBytes();
  }
  /**
   *
   *
   * <pre>
   * An [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern] exempts images
   * from checks by [admission rules][google.cloud.binaryauthorization.v1.AdmissionRule].
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern}
   */
  public static final class AdmissionWhitelistPattern extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern)
      AdmissionWhitelistPatternOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AdmissionWhitelistPattern.newBuilder() to construct.
    private AdmissionWhitelistPattern(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AdmissionWhitelistPattern() {
      namePattern_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AdmissionWhitelistPattern();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern.class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AdmissionWhitelistPattern.Builder.class);
    }

    public static final int NAME_PATTERN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object namePattern_ = "";
    /**
     *
     *
     * <pre>
     * An image name pattern to allowlist, in the form `registry/path/to/image`.
     * This supports a trailing `*` wildcard, but this is allowed only in
     * text after the `registry/` part. This also supports a trailing `**`
     * wildcard which matches subdirectories of a given entry.
     * </pre>
     *
     * <code>string name_pattern = 1;</code>
     *
     * @return The namePattern.
     */
    @java.lang.Override
    public java.lang.String getNamePattern() {
      java.lang.Object ref = namePattern_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namePattern_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An image name pattern to allowlist, in the form `registry/path/to/image`.
     * This supports a trailing `*` wildcard, but this is allowed only in
     * text after the `registry/` part. This also supports a trailing `**`
     * wildcard which matches subdirectories of a given entry.
     * </pre>
     *
     * <code>string name_pattern = 1;</code>
     *
     * @return The bytes for namePattern.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNamePatternBytes() {
      java.lang.Object ref = namePattern_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namePattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namePattern_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, namePattern_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namePattern_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, namePattern_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
          other =
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPattern)
                  obj;

      if (!getNamePattern().equals(other.getNamePattern())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getNamePattern().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern] exempts images
     * from checks by [admission rules][google.cloud.binaryauthorization.v1.AdmissionRule].
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPatternOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPattern.class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPattern.Builder.class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        namePattern_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern
          build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
            result =
                new com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AdmissionWhitelistPattern(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.namePattern_ = namePattern_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .AdmissionWhitelistPattern) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AdmissionWhitelistPattern)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
              other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .AdmissionWhitelistPattern.getDefaultInstance()) return this;
        if (!other.getNamePattern().isEmpty()) {
          namePattern_ = other.namePattern_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  namePattern_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object namePattern_ = "";
      /**
       *
       *
       * <pre>
       * An image name pattern to allowlist, in the form `registry/path/to/image`.
       * This supports a trailing `*` wildcard, but this is allowed only in
       * text after the `registry/` part. This also supports a trailing `**`
       * wildcard which matches subdirectories of a given entry.
       * </pre>
       *
       * <code>string name_pattern = 1;</code>
       *
       * @return The namePattern.
       */
      public java.lang.String getNamePattern() {
        java.lang.Object ref = namePattern_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          namePattern_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An image name pattern to allowlist, in the form `registry/path/to/image`.
       * This supports a trailing `*` wildcard, but this is allowed only in
       * text after the `registry/` part. This also supports a trailing `**`
       * wildcard which matches subdirectories of a given entry.
       * </pre>
       *
       * <code>string name_pattern = 1;</code>
       *
       * @return The bytes for namePattern.
       */
      public com.google.protobuf.ByteString getNamePatternBytes() {
        java.lang.Object ref = namePattern_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          namePattern_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An image name pattern to allowlist, in the form `registry/path/to/image`.
       * This supports a trailing `*` wildcard, but this is allowed only in
       * text after the `registry/` part. This also supports a trailing `**`
       * wildcard which matches subdirectories of a given entry.
       * </pre>
       *
       * <code>string name_pattern = 1;</code>
       *
       * @param value The namePattern to set.
       * @return This builder for chaining.
       */
      public Builder setNamePattern(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        namePattern_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An image name pattern to allowlist, in the form `registry/path/to/image`.
       * This supports a trailing `*` wildcard, but this is allowed only in
       * text after the `registry/` part. This also supports a trailing `**`
       * wildcard which matches subdirectories of a given entry.
       * </pre>
       *
       * <code>string name_pattern = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNamePattern() {
        namePattern_ = getDefaultInstance().getNamePattern();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An image name pattern to allowlist, in the form `registry/path/to/image`.
       * This supports a trailing `*` wildcard, but this is allowed only in
       * text after the `registry/` part. This also supports a trailing `**`
       * wildcard which matches subdirectories of a given entry.
       * </pre>
       *
       * <code>string name_pattern = 1;</code>
       *
       * @param value The bytes for namePattern to set.
       * @return This builder for chaining.
       */
      public Builder setNamePatternBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        namePattern_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AdmissionWhitelistPattern();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionWhitelistPattern
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AdmissionWhitelistPattern> PARSER =
        new com.google.protobuf.AbstractParser<AdmissionWhitelistPattern>() {
          @java.lang.Override
          public AdmissionWhitelistPattern parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AdmissionWhitelistPattern> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AdmissionWhitelistPattern> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionWhitelistPattern
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AdmissionRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.AdmissionRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for evaluationMode.
     */
    int getEvaluationModeValue();
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The evaluationMode.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.EvaluationMode
        getEvaluationMode();

    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the requireAttestationsBy.
     */
    java.util.List<java.lang.String> getRequireAttestationsByList();
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of requireAttestationsBy.
     */
    int getRequireAttestationsByCount();
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The requireAttestationsBy at the given index.
     */
    java.lang.String getRequireAttestationsBy(int index);
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requireAttestationsBy at the given index.
     */
    com.google.protobuf.ByteString getRequireAttestationsByBytes(int index);

    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for enforcementMode.
     */
    int getEnforcementModeValue();
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enforcementMode.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.EnforcementMode
        getEnforcementMode();
  }
  /**
   *
   *
   * <pre>
   * An [admission rule][google.cloud.binaryauthorization.v1.AdmissionRule] specifies either that all container images
   * used in a pod creation request must be attested to by one or more
   * [attestors][google.cloud.binaryauthorization.v1.Attestor], that all pod creations will be allowed, or that all
   * pod creations will be denied.
   *
   * Images matching an [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern]
   * are exempted from admission rules and will never block a pod creation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.AdmissionRule}
   */
  public static final class AdmissionRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.AdmissionRule)
      AdmissionRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AdmissionRule.newBuilder() to construct.
    private AdmissionRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AdmissionRule() {
      evaluationMode_ = 0;
      requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enforcementMode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AdmissionRule();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.Builder
                  .class);
    }

    /** Protobuf enum {@code google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode} */
    public enum EvaluationMode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Do not use.
       * </pre>
       *
       * <code>EVALUATION_MODE_UNSPECIFIED = 0;</code>
       */
      EVALUATION_MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * This rule allows all all pod creations.
       * </pre>
       *
       * <code>ALWAYS_ALLOW = 1;</code>
       */
      ALWAYS_ALLOW(1),
      /**
       *
       *
       * <pre>
       * This rule allows a pod creation if all the attestors listed in
       * 'require_attestations_by' have valid attestations for all of the
       * images in the pod spec.
       * </pre>
       *
       * <code>REQUIRE_ATTESTATION = 2;</code>
       */
      REQUIRE_ATTESTATION(2),
      /**
       *
       *
       * <pre>
       * This rule denies all pod creations.
       * </pre>
       *
       * <code>ALWAYS_DENY = 3;</code>
       */
      ALWAYS_DENY(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Do not use.
       * </pre>
       *
       * <code>EVALUATION_MODE_UNSPECIFIED = 0;</code>
       */
      public static final int EVALUATION_MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * This rule allows all all pod creations.
       * </pre>
       *
       * <code>ALWAYS_ALLOW = 1;</code>
       */
      public static final int ALWAYS_ALLOW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * This rule allows a pod creation if all the attestors listed in
       * 'require_attestations_by' have valid attestations for all of the
       * images in the pod spec.
       * </pre>
       *
       * <code>REQUIRE_ATTESTATION = 2;</code>
       */
      public static final int REQUIRE_ATTESTATION_VALUE = 2;
      /**
       *
       *
       * <pre>
       * This rule denies all pod creations.
       * </pre>
       *
       * <code>ALWAYS_DENY = 3;</code>
       */
      public static final int ALWAYS_DENY_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EvaluationMode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EvaluationMode forNumber(int value) {
        switch (value) {
          case 0:
            return EVALUATION_MODE_UNSPECIFIED;
          case 1:
            return ALWAYS_ALLOW;
          case 2:
            return REQUIRE_ATTESTATION;
          case 3:
            return ALWAYS_DENY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EvaluationMode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EvaluationMode>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<EvaluationMode>() {
                public EvaluationMode findValueByNumber(int number) {
                  return EvaluationMode.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final EvaluationMode[] VALUES = values();

      public static EvaluationMode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EvaluationMode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode)
    }

    /**
     *
     *
     * <pre>
     * Defines the possible actions when a pod creation is denied by an admission
     * rule.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode}
     */
    public enum EnforcementMode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Do not use.
       * </pre>
       *
       * <code>ENFORCEMENT_MODE_UNSPECIFIED = 0;</code>
       */
      ENFORCEMENT_MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Enforce the admission rule by blocking the pod creation.
       * </pre>
       *
       * <code>ENFORCED_BLOCK_AND_AUDIT_LOG = 1;</code>
       */
      ENFORCED_BLOCK_AND_AUDIT_LOG(1),
      /**
       *
       *
       * <pre>
       * Dryrun mode: Audit logging only.  This will allow the pod creation as if
       * the admission request had specified break-glass.
       * </pre>
       *
       * <code>DRYRUN_AUDIT_LOG_ONLY = 2;</code>
       */
      DRYRUN_AUDIT_LOG_ONLY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Do not use.
       * </pre>
       *
       * <code>ENFORCEMENT_MODE_UNSPECIFIED = 0;</code>
       */
      public static final int ENFORCEMENT_MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Enforce the admission rule by blocking the pod creation.
       * </pre>
       *
       * <code>ENFORCED_BLOCK_AND_AUDIT_LOG = 1;</code>
       */
      public static final int ENFORCED_BLOCK_AND_AUDIT_LOG_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Dryrun mode: Audit logging only.  This will allow the pod creation as if
       * the admission request had specified break-glass.
       * </pre>
       *
       * <code>DRYRUN_AUDIT_LOG_ONLY = 2;</code>
       */
      public static final int DRYRUN_AUDIT_LOG_ONLY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EnforcementMode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static EnforcementMode forNumber(int value) {
        switch (value) {
          case 0:
            return ENFORCEMENT_MODE_UNSPECIFIED;
          case 1:
            return ENFORCED_BLOCK_AND_AUDIT_LOG;
          case 2:
            return DRYRUN_AUDIT_LOG_ONLY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<EnforcementMode>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<EnforcementMode>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<EnforcementMode>() {
                public EnforcementMode findValueByNumber(int number) {
                  return EnforcementMode.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
            .getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final EnforcementMode[] VALUES = values();

      public static EnforcementMode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private EnforcementMode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode)
    }

    public static final int EVALUATION_MODE_FIELD_NUMBER = 1;
    private int evaluationMode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for evaluationMode.
     */
    @java.lang.Override
    public int getEvaluationModeValue() {
      return evaluationMode_;
    }
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The evaluationMode.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
            .EvaluationMode
        getEvaluationMode() {
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.EvaluationMode
          result =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .EvaluationMode.forNumber(evaluationMode_);
      return result == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EvaluationMode.UNRECOGNIZED
          : result;
    }

    public static final int REQUIRE_ATTESTATIONS_BY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList requireAttestationsBy_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the requireAttestationsBy.
     */
    public com.google.protobuf.ProtocolStringList getRequireAttestationsByList() {
      return requireAttestationsBy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of requireAttestationsBy.
     */
    public int getRequireAttestationsByCount() {
      return requireAttestationsBy_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The requireAttestationsBy at the given index.
     */
    public java.lang.String getRequireAttestationsBy(int index) {
      return requireAttestationsBy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requireAttestationsBy at the given index.
     */
    public com.google.protobuf.ByteString getRequireAttestationsByBytes(int index) {
      return requireAttestationsBy_.getByteString(index);
    }

    public static final int ENFORCEMENT_MODE_FIELD_NUMBER = 3;
    private int enforcementMode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for enforcementMode.
     */
    @java.lang.Override
    public int getEnforcementModeValue() {
      return enforcementMode_;
    }
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enforcementMode.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
            .EnforcementMode
        getEnforcementMode() {
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.EnforcementMode
          result =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .EnforcementMode.forNumber(enforcementMode_);
      return result == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EnforcementMode.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (evaluationMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EvaluationMode.EVALUATION_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, evaluationMode_);
      }
      for (int i = 0; i < requireAttestationsBy_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 2, requireAttestationsBy_.getRaw(i));
      }
      if (enforcementMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EnforcementMode.ENFORCEMENT_MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, enforcementMode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (evaluationMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EvaluationMode.EVALUATION_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, evaluationMode_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < requireAttestationsBy_.size(); i++) {
          dataSize += computeStringSizeNoTag(requireAttestationsBy_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getRequireAttestationsByList().size();
      }
      if (enforcementMode_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EnforcementMode.ENFORCEMENT_MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, enforcementMode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) obj;

      if (evaluationMode_ != other.evaluationMode_) return false;
      if (!getRequireAttestationsByList().equals(other.getRequireAttestationsByList()))
        return false;
      if (enforcementMode_ != other.enforcementMode_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EVALUATION_MODE_FIELD_NUMBER;
      hash = (53 * hash) + evaluationMode_;
      if (getRequireAttestationsByCount() > 0) {
        hash = (37 * hash) + REQUIRE_ATTESTATIONS_BY_FIELD_NUMBER;
        hash = (53 * hash) + getRequireAttestationsByList().hashCode();
      }
      hash = (37 * hash) + ENFORCEMENT_MODE_FIELD_NUMBER;
      hash = (53 * hash) + enforcementMode_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An [admission rule][google.cloud.binaryauthorization.v1.AdmissionRule] specifies either that all container images
     * used in a pod creation request must be attested to by one or more
     * [attestors][google.cloud.binaryauthorization.v1.Attestor], that all pod creations will be allowed, or that all
     * pod creations will be denied.
     *
     * Images matching an [admission allowlist pattern][google.cloud.binaryauthorization.v1.AdmissionWhitelistPattern]
     * are exempted from admission rules and will never block a pod creation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.AdmissionRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.AdmissionRule)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                    .Builder.class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        evaluationMode_ = 0;
        requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
        enforcementMode_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule result =
            new com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.evaluationMode_ = evaluationMode_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          requireAttestationsBy_.makeImmutable();
          result.requireAttestationsBy_ = requireAttestationsBy_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.enforcementMode_ = enforcementMode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .getDefaultInstance()) return this;
        if (other.evaluationMode_ != 0) {
          setEvaluationModeValue(other.getEvaluationModeValue());
        }
        if (!other.requireAttestationsBy_.isEmpty()) {
          if (requireAttestationsBy_.isEmpty()) {
            requireAttestationsBy_ = other.requireAttestationsBy_;
            bitField0_ |= 0x00000002;
          } else {
            ensureRequireAttestationsByIsMutable();
            requireAttestationsBy_.addAll(other.requireAttestationsBy_);
          }
          onChanged();
        }
        if (other.enforcementMode_ != 0) {
          setEnforcementModeValue(other.getEnforcementModeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  evaluationMode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureRequireAttestationsByIsMutable();
                  requireAttestationsBy_.add(s);
                  break;
                } // case 18
              case 24:
                {
                  enforcementMode_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int evaluationMode_ = 0;
      /**
       *
       *
       * <pre>
       * Required. How this admission rule will be evaluated.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for evaluationMode.
       */
      @java.lang.Override
      public int getEvaluationModeValue() {
        return evaluationMode_;
      }
      /**
       *
       *
       * <pre>
       * Required. How this admission rule will be evaluated.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for evaluationMode to set.
       * @return This builder for chaining.
       */
      public Builder setEvaluationModeValue(int value) {
        evaluationMode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. How this admission rule will be evaluated.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The evaluationMode.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EvaluationMode
          getEvaluationMode() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule.EvaluationMode
            result =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                    .EvaluationMode.forNumber(evaluationMode_);
        return result == null
            ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .EvaluationMode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. How this admission rule will be evaluated.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The evaluationMode to set.
       * @return This builder for chaining.
       */
      public Builder setEvaluationMode(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .EvaluationMode
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        evaluationMode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. How this admission rule will be evaluated.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEvaluationMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        evaluationMode_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList requireAttestationsBy_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureRequireAttestationsByIsMutable() {
        if (!requireAttestationsBy_.isModifiable()) {
          requireAttestationsBy_ =
              new com.google.protobuf.LazyStringArrayList(requireAttestationsBy_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the requireAttestationsBy.
       */
      public com.google.protobuf.ProtocolStringList getRequireAttestationsByList() {
        requireAttestationsBy_.makeImmutable();
        return requireAttestationsBy_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of requireAttestationsBy.
       */
      public int getRequireAttestationsByCount() {
        return requireAttestationsBy_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The requireAttestationsBy at the given index.
       */
      public java.lang.String getRequireAttestationsBy(int index) {
        return requireAttestationsBy_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the requireAttestationsBy at the given index.
       */
      public com.google.protobuf.ByteString getRequireAttestationsByBytes(int index) {
        return requireAttestationsBy_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The requireAttestationsBy to set.
       * @return This builder for chaining.
       */
      public Builder setRequireAttestationsBy(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequireAttestationsByIsMutable();
        requireAttestationsBy_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The requireAttestationsBy to add.
       * @return This builder for chaining.
       */
      public Builder addRequireAttestationsBy(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequireAttestationsByIsMutable();
        requireAttestationsBy_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The requireAttestationsBy to add.
       * @return This builder for chaining.
       */
      public Builder addAllRequireAttestationsBy(java.lang.Iterable<java.lang.String> values) {
        ensureRequireAttestationsByIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requireAttestationsBy_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequireAttestationsBy() {
        requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The resource names of the attestors that must attest to
       * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
       * attestor must exist before a policy can reference it.  To add an attestor
       * to a policy the principal issuing the policy change request must be able
       * to read the attestor resource.
       *
       * Note: this field must be non-empty when the evaluation_mode field specifies
       * REQUIRE_ATTESTATION, otherwise it must be empty.
       * </pre>
       *
       * <code>
       * repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the requireAttestationsBy to add.
       * @return This builder for chaining.
       */
      public Builder addRequireAttestationsByBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureRequireAttestationsByIsMutable();
        requireAttestationsBy_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int enforcementMode_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The action when a pod creation is denied by the admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for enforcementMode.
       */
      @java.lang.Override
      public int getEnforcementModeValue() {
        return enforcementMode_;
      }
      /**
       *
       *
       * <pre>
       * Required. The action when a pod creation is denied by the admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for enforcementMode to set.
       * @return This builder for chaining.
       */
      public Builder setEnforcementModeValue(int value) {
        enforcementMode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The action when a pod creation is denied by the admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enforcementMode.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
              .EnforcementMode
          getEnforcementMode() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .EnforcementMode
            result =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                    .EnforcementMode.forNumber(enforcementMode_);
        return result == null
            ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                .EnforcementMode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The action when a pod creation is denied by the admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enforcementMode to set.
       * @return This builder for chaining.
       */
      public Builder setEnforcementMode(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
                  .EnforcementMode
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        enforcementMode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The action when a pod creation is denied by the admission rule.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnforcementMode() {
        bitField0_ = (bitField0_ & ~0x00000004);
        enforcementMode_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.AdmissionRule)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.AdmissionRule)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AdmissionRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AdmissionRule> PARSER =
        new com.google.protobuf.AbstractParser<AdmissionRule>() {
          @java.lang.Override
          public AdmissionRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AdmissionRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AdmissionRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AdmissionRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AttestorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.Attestor)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     *
     * @return Whether the userOwnedGrafeasNote field is set.
     */
    boolean hasUserOwnedGrafeasNote();
    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     *
     * @return The userOwnedGrafeasNote.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
        getUserOwnedGrafeasNote();
    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNoteOrBuilder
        getUserOwnedGrafeasNoteOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    boolean hasUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    com.google.protobuf.Timestamp getUpdateTime();
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

    com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.AttestorTypeCase
        getAttestorTypeCase();
  }
  /**
   *
   *
   * <pre>
   * An [attestor][google.cloud.binaryauthorization.v1.Attestor] that attests to container image
   * artifacts. An existing attestor cannot be modified except where
   * indicated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.Attestor}
   */
  public static final class Attestor extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.Attestor)
      AttestorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Attestor.newBuilder() to construct.
    private Attestor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Attestor() {
      name_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Attestor();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_Attestor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.Builder
                  .class);
    }

    private int bitField0_;
    private int attestorTypeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object attestorType_;

    public enum AttestorTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      USER_OWNED_GRAFEAS_NOTE(3),
      ATTESTORTYPE_NOT_SET(0);
      private final int value;

      private AttestorTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AttestorTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static AttestorTypeCase forNumber(int value) {
        switch (value) {
          case 3:
            return USER_OWNED_GRAFEAS_NOTE;
          case 0:
            return ATTESTORTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AttestorTypeCase getAttestorTypeCase() {
      return AttestorTypeCase.forNumber(attestorTypeCase_);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USER_OWNED_GRAFEAS_NOTE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     *
     * @return Whether the userOwnedGrafeasNote field is set.
     */
    @java.lang.Override
    public boolean hasUserOwnedGrafeasNote() {
      return attestorTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     *
     * @return The userOwnedGrafeasNote.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
        getUserOwnedGrafeasNote() {
      if (attestorTypeCase_ == 3) {
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .UserOwnedGrafeasNote)
            attestorType_;
      }
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * This specifies how an attestation will be read, and how it will be used
     * during policy enforcement.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNoteOrBuilder
        getUserOwnedGrafeasNoteOrBuilder() {
      if (attestorTypeCase_ == 3) {
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                .UserOwnedGrafeasNote)
            attestorType_;
      }
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          .getDefaultInstance();
    }

    public static final int UPDATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp updateTime_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (attestorTypeCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote)
                attestorType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getUpdateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (attestorTypeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                        .UserOwnedGrafeasNote)
                    attestorType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (hasUpdateTime() != other.hasUpdateTime()) return false;
      if (hasUpdateTime()) {
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
      }
      if (!getAttestorTypeCase().equals(other.getAttestorTypeCase())) return false;
      switch (attestorTypeCase_) {
        case 3:
          if (!getUserOwnedGrafeasNote().equals(other.getUserOwnedGrafeasNote())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasUpdateTime()) {
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
      }
      switch (attestorTypeCase_) {
        case 3:
          hash = (37 * hash) + USER_OWNED_GRAFEAS_NOTE_FIELD_NUMBER;
          hash = (53 * hash) + getUserOwnedGrafeasNote().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An [attestor][google.cloud.binaryauthorization.v1.Attestor] that attests to container image
     * artifacts. An existing attestor cannot be modified except where
     * indicated.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.Attestor}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.Attestor)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Attestor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.Builder
                    .class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        description_ = "";
        if (userOwnedGrafeasNoteBuilder_ != null) {
          userOwnedGrafeasNoteBuilder_.clear();
        }
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        attestorTypeCase_ = 0;
        attestorType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor result =
            new com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.updateTime_ =
              updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor result) {
        result.attestorTypeCase_ = attestorTypeCase_;
        result.attestorType_ = this.attestorType_;
        if (attestorTypeCase_ == 3 && userOwnedGrafeasNoteBuilder_ != null) {
          result.attestorType_ = userOwnedGrafeasNoteBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasUpdateTime()) {
          mergeUpdateTime(other.getUpdateTime());
        }
        switch (other.getAttestorTypeCase()) {
          case USER_OWNED_GRAFEAS_NOTE:
            {
              mergeUserOwnedGrafeasNote(other.getUserOwnedGrafeasNote());
              break;
            }
          case ATTESTORTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getUserOwnedGrafeasNoteFieldBuilder().getBuilder(), extensionRegistry);
                  attestorTypeCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 50:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int attestorTypeCase_ = 0;
      private java.lang.Object attestorType_;

      public AttestorTypeCase getAttestorTypeCase() {
        return AttestorTypeCase.forNumber(attestorTypeCase_);
      }

      public Builder clearAttestorType() {
        attestorTypeCase_ = 0;
        attestorType_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The resource name, in the format:
       * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name, in the format:
       * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name, in the format:
       * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name, in the format:
       * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The resource name, in the format:
       * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.  This field may be updated.
       * The field may be displayed in chooser dialogs.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.  This field may be updated.
       * The field may be displayed in chooser dialogs.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.  This field may be updated.
       * The field may be displayed in chooser dialogs.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.  This field may be updated.
       * The field may be displayed in chooser dialogs.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment.  This field may be updated.
       * The field may be displayed in chooser dialogs.
       * </pre>
       *
       * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                  .Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .UserOwnedGrafeasNoteOrBuilder>
          userOwnedGrafeasNoteBuilder_;
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       *
       * @return Whether the userOwnedGrafeasNote field is set.
       */
      @java.lang.Override
      public boolean hasUserOwnedGrafeasNote() {
        return attestorTypeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       *
       * @return The userOwnedGrafeasNote.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          getUserOwnedGrafeasNote() {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          if (attestorTypeCase_ == 3) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .UserOwnedGrafeasNote)
                attestorType_;
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .UserOwnedGrafeasNote.getDefaultInstance();
        } else {
          if (attestorTypeCase_ == 3) {
            return userOwnedGrafeasNoteBuilder_.getMessage();
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .UserOwnedGrafeasNote.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      public Builder setUserOwnedGrafeasNote(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              value) {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          attestorType_ = value;
          onChanged();
        } else {
          userOwnedGrafeasNoteBuilder_.setMessage(value);
        }
        attestorTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      public Builder setUserOwnedGrafeasNote(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                  .Builder
              builderForValue) {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          attestorType_ = builderForValue.build();
          onChanged();
        } else {
          userOwnedGrafeasNoteBuilder_.setMessage(builderForValue.build());
        }
        attestorTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      public Builder mergeUserOwnedGrafeasNote(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              value) {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          if (attestorTypeCase_ == 3
              && attestorType_
                  != com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .UserOwnedGrafeasNote.getDefaultInstance()) {
            attestorType_ =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                    .newBuilder(
                        (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                                .UserOwnedGrafeasNote)
                            attestorType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            attestorType_ = value;
          }
          onChanged();
        } else {
          if (attestorTypeCase_ == 3) {
            userOwnedGrafeasNoteBuilder_.mergeFrom(value);
          } else {
            userOwnedGrafeasNoteBuilder_.setMessage(value);
          }
        }
        attestorTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      public Builder clearUserOwnedGrafeasNote() {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          if (attestorTypeCase_ == 3) {
            attestorTypeCase_ = 0;
            attestorType_ = null;
            onChanged();
          }
        } else {
          if (attestorTypeCase_ == 3) {
            attestorTypeCase_ = 0;
            attestorType_ = null;
          }
          userOwnedGrafeasNoteBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              .Builder
          getUserOwnedGrafeasNoteBuilder() {
        return getUserOwnedGrafeasNoteFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .UserOwnedGrafeasNoteOrBuilder
          getUserOwnedGrafeasNoteOrBuilder() {
        if ((attestorTypeCase_ == 3) && (userOwnedGrafeasNoteBuilder_ != null)) {
          return userOwnedGrafeasNoteBuilder_.getMessageOrBuilder();
        } else {
          if (attestorTypeCase_ == 3) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .UserOwnedGrafeasNote)
                attestorType_;
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .UserOwnedGrafeasNote.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * This specifies how an attestation will be read, and how it will be used
       * during policy enforcement.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote user_owned_grafeas_note = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                  .Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .UserOwnedGrafeasNoteOrBuilder>
          getUserOwnedGrafeasNoteFieldBuilder() {
        if (userOwnedGrafeasNoteBuilder_ == null) {
          if (!(attestorTypeCase_ == 3)) {
            attestorType_ =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                    .getDefaultInstance();
          }
          userOwnedGrafeasNoteBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .UserOwnedGrafeasNote,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .UserOwnedGrafeasNote.Builder,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .UserOwnedGrafeasNoteOrBuilder>(
                  (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                          .UserOwnedGrafeasNote)
                      attestorType_,
                  getParentForChildren(),
                  isClean());
          attestorType_ = null;
        }
        attestorTypeCase_ = 3;
        onChanged();
        return userOwnedGrafeasNoteBuilder_;
      }

      private com.google.protobuf.Timestamp updateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          updateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the updateTime field is set.
       */
      public boolean hasUpdateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The updateTime.
       */
      public com.google.protobuf.Timestamp getUpdateTime() {
        if (updateTimeBuilder_ == null) {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        } else {
          return updateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTime_ = value;
        } else {
          updateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (updateTimeBuilder_ == null) {
          updateTime_ = builderForValue.build();
        } else {
          updateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
        if (updateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && updateTime_ != null
              && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getUpdateTimeBuilder().mergeFrom(value);
          } else {
            updateTime_ = value;
          }
        } else {
          updateTimeBuilder_.mergeFrom(value);
        }
        if (updateTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        updateTime_ = null;
        if (updateTimeBuilder_ != null) {
          updateTimeBuilder_.dispose();
          updateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
        if (updateTimeBuilder_ != null) {
          return updateTimeBuilder_.getMessageOrBuilder();
        } else {
          return updateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : updateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Time when the attestor was last updated.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getUpdateTimeFieldBuilder() {
        if (updateTimeBuilder_ == null) {
          updateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getUpdateTime(), getParentForChildren(), isClean());
          updateTime_ = null;
        }
        return updateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.Attestor)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.Attestor)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Attestor> PARSER =
        new com.google.protobuf.AbstractParser<Attestor>() {
          @java.lang.Override
          public Attestor parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Attestor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Attestor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.Attestor
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UserOwnedGrafeasNoteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Grafeas resource name of a Attestation.Authority Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
     * not be updated.
     *
     * An attestation by this attestor is stored as a Grafeas
     * Attestation.Authority Occurrence that names a container image and that
     * links to this Note. Grafeas is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The noteReference.
     */
    java.lang.String getNoteReference();
    /**
     *
     *
     * <pre>
     * Required. The Grafeas resource name of a Attestation.Authority Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
     * not be updated.
     *
     * An attestation by this attestor is stored as a Grafeas
     * Attestation.Authority Occurrence that names a container image and that
     * links to this Note. Grafeas is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for noteReference.
     */
    com.google.protobuf.ByteString getNoteReferenceBytes();

    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey>
        getPublicKeysList();
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey getPublicKeys(
        int index);
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getPublicKeysCount();
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AttestorPublicKeyOrBuilder>
        getPublicKeysOrBuilderList();
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKeyOrBuilder
        getPublicKeysOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The delegationServiceAccountEmail.
     */
    java.lang.String getDelegationServiceAccountEmail();
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for delegationServiceAccountEmail.
     */
    com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes();
  }
  /**
   *
   *
   * <pre>
   * An [user owned Grafeas note][google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote] references a Grafeas
   * Attestation.Authority Note created by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote}
   */
  public static final class UserOwnedGrafeasNote extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote)
      UserOwnedGrafeasNoteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserOwnedGrafeasNote.newBuilder() to construct.
    private UserOwnedGrafeasNote(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserOwnedGrafeasNote() {
      noteReference_ = "";
      publicKeys_ = java.util.Collections.emptyList();
      delegationServiceAccountEmail_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserOwnedGrafeasNote();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                  .class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                  .Builder.class);
    }

    public static final int NOTE_REFERENCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object noteReference_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Grafeas resource name of a Attestation.Authority Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
     * not be updated.
     *
     * An attestation by this attestor is stored as a Grafeas
     * Attestation.Authority Occurrence that names a container image and that
     * links to this Note. Grafeas is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The noteReference.
     */
    @java.lang.Override
    public java.lang.String getNoteReference() {
      java.lang.Object ref = noteReference_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        noteReference_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Grafeas resource name of a Attestation.Authority Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
     * not be updated.
     *
     * An attestation by this attestor is stored as a Grafeas
     * Attestation.Authority Occurrence that names a container image and that
     * links to this Note. Grafeas is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for noteReference.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNoteReferenceBytes() {
      java.lang.Object ref = noteReference_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        noteReference_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PUBLIC_KEYS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey>
        publicKeys_;
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey>
        getPublicKeysList() {
      return publicKeys_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .AttestorPublicKeyOrBuilder>
        getPublicKeysOrBuilderList() {
      return publicKeys_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getPublicKeysCount() {
      return publicKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        getPublicKeys(int index) {
      return publicKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AttestorPublicKeyOrBuilder
        getPublicKeysOrBuilder(int index) {
      return publicKeys_.get(index);
    }

    public static final int DELEGATION_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object delegationServiceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The delegationServiceAccountEmail.
     */
    @java.lang.Override
    public java.lang.String getDelegationServiceAccountEmail() {
      java.lang.Object ref = delegationServiceAccountEmail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        delegationServiceAccountEmail_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for delegationServiceAccountEmail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes() {
      java.lang.Object ref = delegationServiceAccountEmail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        delegationServiceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(noteReference_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, noteReference_);
      }
      for (int i = 0; i < publicKeys_.size(); i++) {
        output.writeMessage(2, publicKeys_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delegationServiceAccountEmail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, delegationServiceAccountEmail_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(noteReference_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, noteReference_);
      }
      for (int i = 0; i < publicKeys_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, publicKeys_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delegationServiceAccountEmail_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                3, delegationServiceAccountEmail_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote)
              obj;

      if (!getNoteReference().equals(other.getNoteReference())) return false;
      if (!getPublicKeysList().equals(other.getPublicKeysList())) return false;
      if (!getDelegationServiceAccountEmail().equals(other.getDelegationServiceAccountEmail()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NOTE_REFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getNoteReference().hashCode();
      if (getPublicKeysCount() > 0) {
        hash = (37 * hash) + PUBLIC_KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getPublicKeysList().hashCode();
      }
      hash = (37 * hash) + DELEGATION_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getDelegationServiceAccountEmail().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An [user owned Grafeas note][google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote] references a Grafeas
     * Attestation.Authority Note created by the user.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNoteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                    .class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                    .Builder.class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        noteReference_ = "";
        if (publicKeysBuilder_ == null) {
          publicKeys_ = java.util.Collections.emptyList();
        } else {
          publicKeys_ = null;
          publicKeysBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        delegationServiceAccountEmail_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
            result =
                new com.google.protos.google.cloud.binaryauthorization.v1.Resources
                    .UserOwnedGrafeasNote(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              result) {
        if (publicKeysBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            publicKeys_ = java.util.Collections.unmodifiableList(publicKeys_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.publicKeys_ = publicKeys_;
        } else {
          result.publicKeys_ = publicKeysBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.noteReference_ = noteReference_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.delegationServiceAccountEmail_ = delegationServiceAccountEmail_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
              other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
                .getDefaultInstance()) return this;
        if (!other.getNoteReference().isEmpty()) {
          noteReference_ = other.noteReference_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (publicKeysBuilder_ == null) {
          if (!other.publicKeys_.isEmpty()) {
            if (publicKeys_.isEmpty()) {
              publicKeys_ = other.publicKeys_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePublicKeysIsMutable();
              publicKeys_.addAll(other.publicKeys_);
            }
            onChanged();
          }
        } else {
          if (!other.publicKeys_.isEmpty()) {
            if (publicKeysBuilder_.isEmpty()) {
              publicKeysBuilder_.dispose();
              publicKeysBuilder_ = null;
              publicKeys_ = other.publicKeys_;
              bitField0_ = (bitField0_ & ~0x00000002);
              publicKeysBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPublicKeysFieldBuilder()
                      : null;
            } else {
              publicKeysBuilder_.addAllMessages(other.publicKeys_);
            }
          }
        }
        if (!other.getDelegationServiceAccountEmail().isEmpty()) {
          delegationServiceAccountEmail_ = other.delegationServiceAccountEmail_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  noteReference_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                      m =
                          input.readMessage(
                              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                                  .AttestorPublicKey.parser(),
                              extensionRegistry);
                  if (publicKeysBuilder_ == null) {
                    ensurePublicKeysIsMutable();
                    publicKeys_.add(m);
                  } else {
                    publicKeysBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  delegationServiceAccountEmail_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object noteReference_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Grafeas resource name of a Attestation.Authority Note,
       * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
       * not be updated.
       *
       * An attestation by this attestor is stored as a Grafeas
       * Attestation.Authority Occurrence that names a container image and that
       * links to this Note. Grafeas is an external dependency.
       * </pre>
       *
       * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The noteReference.
       */
      public java.lang.String getNoteReference() {
        java.lang.Object ref = noteReference_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          noteReference_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Grafeas resource name of a Attestation.Authority Note,
       * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
       * not be updated.
       *
       * An attestation by this attestor is stored as a Grafeas
       * Attestation.Authority Occurrence that names a container image and that
       * links to this Note. Grafeas is an external dependency.
       * </pre>
       *
       * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for noteReference.
       */
      public com.google.protobuf.ByteString getNoteReferenceBytes() {
        java.lang.Object ref = noteReference_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          noteReference_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Grafeas resource name of a Attestation.Authority Note,
       * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
       * not be updated.
       *
       * An attestation by this attestor is stored as a Grafeas
       * Attestation.Authority Occurrence that names a container image and that
       * links to this Note. Grafeas is an external dependency.
       * </pre>
       *
       * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The noteReference to set.
       * @return This builder for chaining.
       */
      public Builder setNoteReference(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        noteReference_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Grafeas resource name of a Attestation.Authority Note,
       * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
       * not be updated.
       *
       * An attestation by this attestor is stored as a Grafeas
       * Attestation.Authority Occurrence that names a container image and that
       * links to this Note. Grafeas is an external dependency.
       * </pre>
       *
       * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNoteReference() {
        noteReference_ = getDefaultInstance().getNoteReference();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Grafeas resource name of a Attestation.Authority Note,
       * created by the user, in the format: `projects/&#42;&#47;notes/&#42;`. This field may
       * not be updated.
       *
       * An attestation by this attestor is stored as a Grafeas
       * Attestation.Authority Occurrence that names a container image and that
       * links to this Note. Grafeas is an external dependency.
       * </pre>
       *
       * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for noteReference to set.
       * @return This builder for chaining.
       */
      public Builder setNoteReferenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        noteReference_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey>
          publicKeys_ = java.util.Collections.emptyList();

      private void ensurePublicKeysIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          publicKeys_ =
              new java.util.ArrayList<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AttestorPublicKey>(publicKeys_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                  .Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AttestorPublicKeyOrBuilder>
          publicKeysBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey>
          getPublicKeysList() {
        if (publicKeysBuilder_ == null) {
          return java.util.Collections.unmodifiableList(publicKeys_);
        } else {
          return publicKeysBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getPublicKeysCount() {
        if (publicKeysBuilder_ == null) {
          return publicKeys_.size();
        } else {
          return publicKeysBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
          getPublicKeys(int index) {
        if (publicKeysBuilder_ == null) {
          return publicKeys_.get(index);
        } else {
          return publicKeysBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPublicKeys(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey value) {
        if (publicKeysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePublicKeysIsMutable();
          publicKeys_.set(index, value);
          onChanged();
        } else {
          publicKeysBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPublicKeys(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey.Builder
              builderForValue) {
        if (publicKeysBuilder_ == null) {
          ensurePublicKeysIsMutable();
          publicKeys_.set(index, builderForValue.build());
          onChanged();
        } else {
          publicKeysBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addPublicKeys(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey value) {
        if (publicKeysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePublicKeysIsMutable();
          publicKeys_.add(value);
          onChanged();
        } else {
          publicKeysBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addPublicKeys(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey value) {
        if (publicKeysBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePublicKeysIsMutable();
          publicKeys_.add(index, value);
          onChanged();
        } else {
          publicKeysBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addPublicKeys(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey.Builder
              builderForValue) {
        if (publicKeysBuilder_ == null) {
          ensurePublicKeysIsMutable();
          publicKeys_.add(builderForValue.build());
          onChanged();
        } else {
          publicKeysBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addPublicKeys(
          int index,
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey.Builder
              builderForValue) {
        if (publicKeysBuilder_ == null) {
          ensurePublicKeysIsMutable();
          publicKeys_.add(index, builderForValue.build());
          onChanged();
        } else {
          publicKeysBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllPublicKeys(
          java.lang.Iterable<
                  ? extends
                      com.google.protos.google.cloud.binaryauthorization.v1.Resources
                          .AttestorPublicKey>
              values) {
        if (publicKeysBuilder_ == null) {
          ensurePublicKeysIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, publicKeys_);
          onChanged();
        } else {
          publicKeysBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPublicKeys() {
        if (publicKeysBuilder_ == null) {
          publicKeys_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          publicKeysBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removePublicKeys(int index) {
        if (publicKeysBuilder_ == null) {
          ensurePublicKeysIsMutable();
          publicKeys_.remove(index);
          onChanged();
        } else {
          publicKeysBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
              .Builder
          getPublicKeysBuilder(int index) {
        return getPublicKeysFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .AttestorPublicKeyOrBuilder
          getPublicKeysOrBuilder(int index) {
        if (publicKeysBuilder_ == null) {
          return publicKeys_.get(index);
        } else {
          return publicKeysBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AttestorPublicKeyOrBuilder>
          getPublicKeysOrBuilderList() {
        if (publicKeysBuilder_ != null) {
          return publicKeysBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(publicKeys_);
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
              .Builder
          addPublicKeysBuilder() {
        return getPublicKeysFieldBuilder()
            .addBuilder(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
              .Builder
          addPublicKeysBuilder(int index) {
        return getPublicKeysFieldBuilder()
            .addBuilder(
                index,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Optional. Public keys that verify attestations signed by this
       * attestor.  This field may be updated.
       *
       * If this field is non-empty, one of the specified public keys must
       * verify that an attestation was signed by this attestor for the
       * image specified in the admission request.
       *
       * If this field is empty, this attestor always returns that no
       * valid attestations exist.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                  .Builder>
          getPublicKeysBuilderList() {
        return getPublicKeysFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                  .Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .AttestorPublicKeyOrBuilder>
          getPublicKeysFieldBuilder() {
        if (publicKeysBuilder_ == null) {
          publicKeysBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                      .Builder,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .AttestorPublicKeyOrBuilder>(
                  publicKeys_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          publicKeys_ = null;
        }
        return publicKeysBuilder_;
      }

      private java.lang.Object delegationServiceAccountEmail_ = "";
      /**
       *
       *
       * <pre>
       * Output only. This field will contain the service account email address
       * that this Attestor will use as the principal when querying Container
       * Analysis. Attestor administrators must grant this service account the
       * IAM role needed to read attestations from the [note_reference][Note] in
       * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
       *
       * This email address is fixed for the lifetime of the Attestor, but callers
       * should not make any other assumptions about the service account email;
       * future versions may use an email based on a different naming pattern.
       * </pre>
       *
       * <code>
       * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The delegationServiceAccountEmail.
       */
      public java.lang.String getDelegationServiceAccountEmail() {
        java.lang.Object ref = delegationServiceAccountEmail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          delegationServiceAccountEmail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will contain the service account email address
       * that this Attestor will use as the principal when querying Container
       * Analysis. Attestor administrators must grant this service account the
       * IAM role needed to read attestations from the [note_reference][Note] in
       * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
       *
       * This email address is fixed for the lifetime of the Attestor, but callers
       * should not make any other assumptions about the service account email;
       * future versions may use an email based on a different naming pattern.
       * </pre>
       *
       * <code>
       * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for delegationServiceAccountEmail.
       */
      public com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes() {
        java.lang.Object ref = delegationServiceAccountEmail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          delegationServiceAccountEmail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will contain the service account email address
       * that this Attestor will use as the principal when querying Container
       * Analysis. Attestor administrators must grant this service account the
       * IAM role needed to read attestations from the [note_reference][Note] in
       * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
       *
       * This email address is fixed for the lifetime of the Attestor, but callers
       * should not make any other assumptions about the service account email;
       * future versions may use an email based on a different naming pattern.
       * </pre>
       *
       * <code>
       * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The delegationServiceAccountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setDelegationServiceAccountEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        delegationServiceAccountEmail_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will contain the service account email address
       * that this Attestor will use as the principal when querying Container
       * Analysis. Attestor administrators must grant this service account the
       * IAM role needed to read attestations from the [note_reference][Note] in
       * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
       *
       * This email address is fixed for the lifetime of the Attestor, but callers
       * should not make any other assumptions about the service account email;
       * future versions may use an email based on a different naming pattern.
       * </pre>
       *
       * <code>
       * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDelegationServiceAccountEmail() {
        delegationServiceAccountEmail_ = getDefaultInstance().getDelegationServiceAccountEmail();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. This field will contain the service account email address
       * that this Attestor will use as the principal when querying Container
       * Analysis. Attestor administrators must grant this service account the
       * IAM role needed to read attestations from the [note_reference][Note] in
       * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
       *
       * This email address is fixed for the lifetime of the Attestor, but callers
       * should not make any other assumptions about the service account email;
       * future versions may use an email based on a different naming pattern.
       * </pre>
       *
       * <code>
       * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for delegationServiceAccountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setDelegationServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        delegationServiceAccountEmail_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.UserOwnedGrafeasNote)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources
              .UserOwnedGrafeasNote();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .UserOwnedGrafeasNote
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserOwnedGrafeasNote> PARSER =
        new com.google.protobuf.AbstractParser<UserOwnedGrafeasNote>() {
          @java.lang.Override
          public UserOwnedGrafeasNote parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserOwnedGrafeasNote> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserOwnedGrafeasNote> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.UserOwnedGrafeasNote
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PkixPublicKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.PkixPublicKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The publicKeyPem.
     */
    java.lang.String getPublicKeyPem();
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The bytes for publicKeyPem.
     */
    com.google.protobuf.ByteString getPublicKeyPemBytes();

    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for signatureAlgorithm.
     */
    int getSignatureAlgorithmValue();
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The signatureAlgorithm.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.SignatureAlgorithm
        getSignatureAlgorithm();
  }
  /**
   *
   *
   * <pre>
   * A public key in the PkixPublicKey format (see
   * https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
   * Public keys of this type are typically textually encoded using the PEM
   * format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.PkixPublicKey}
   */
  public static final class PkixPublicKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.PkixPublicKey)
      PkixPublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PkixPublicKey.newBuilder() to construct.
    private PkixPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PkixPublicKey() {
      publicKeyPem_ = "";
      signatureAlgorithm_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PkixPublicKey();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Represents a signature algorithm and other information necessary to verify
     * signatures with a given public key.
     * This is based primarily on the public key types supported by Tink's
     * PemKeyType, which is in turn based on KMS's supported signing algorithms.
     * See https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz
     * might support additional public key types independently of Tink and/or KMS.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm}
     */
    public enum SignatureAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>SIGNATURE_ALGORITHM_UNSPECIFIED = 0;</code>
       */
      SIGNATURE_ALGORITHM_UNSPECIFIED(0, 0),
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 2048 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_2048_SHA256 = 1;</code>
       */
      RSA_PSS_2048_SHA256(1, 1),
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 3072 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_3072_SHA256 = 2;</code>
       */
      RSA_PSS_3072_SHA256(2, 2),
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 4096 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_4096_SHA256 = 3;</code>
       */
      RSA_PSS_4096_SHA256(3, 3),
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 4096 bit key with a SHA512 digest.
       * </pre>
       *
       * <code>RSA_PSS_4096_SHA512 = 4;</code>
       */
      RSA_PSS_4096_SHA512(4, 4),
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
       */
      RSA_SIGN_PKCS1_2048_SHA256(5, 5),
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
       */
      RSA_SIGN_PKCS1_3072_SHA256(6, 6),
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
       */
      RSA_SIGN_PKCS1_4096_SHA256(7, 7),
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_4096_SHA512 = 8;</code>
       */
      RSA_SIGN_PKCS1_4096_SHA512(8, 8),
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-256 curve with a SHA256 digest.
       * </pre>
       *
       * <code>ECDSA_P256_SHA256 = 9;</code>
       */
      ECDSA_P256_SHA256(9, 9),
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-384 curve with a SHA384 digest.
       * </pre>
       *
       * <code>ECDSA_P384_SHA384 = 10;</code>
       */
      ECDSA_P384_SHA384(11, 10),
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-521 curve with a SHA512 digest.
       * </pre>
       *
       * <code>ECDSA_P521_SHA512 = 11;</code>
       */
      ECDSA_P521_SHA512(13, 11),
      UNRECOGNIZED(-1, -1),
      ;

      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-256 curve with a SHA256 digest.
       * </pre>
       *
       * <code>EC_SIGN_P256_SHA256 = 9;</code>
       */
      public static final SignatureAlgorithm EC_SIGN_P256_SHA256 = ECDSA_P256_SHA256;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-384 curve with a SHA384 digest.
       * </pre>
       *
       * <code>EC_SIGN_P384_SHA384 = 10;</code>
       */
      public static final SignatureAlgorithm EC_SIGN_P384_SHA384 = ECDSA_P384_SHA384;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-521 curve with a SHA512 digest.
       * </pre>
       *
       * <code>EC_SIGN_P521_SHA512 = 11;</code>
       */
      public static final SignatureAlgorithm EC_SIGN_P521_SHA512 = ECDSA_P521_SHA512;
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>SIGNATURE_ALGORITHM_UNSPECIFIED = 0;</code>
       */
      public static final int SIGNATURE_ALGORITHM_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 2048 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_2048_SHA256 = 1;</code>
       */
      public static final int RSA_PSS_2048_SHA256_VALUE = 1;
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 3072 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_3072_SHA256 = 2;</code>
       */
      public static final int RSA_PSS_3072_SHA256_VALUE = 2;
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 4096 bit key with a SHA256 digest.
       * </pre>
       *
       * <code>RSA_PSS_4096_SHA256 = 3;</code>
       */
      public static final int RSA_PSS_4096_SHA256_VALUE = 3;
      /**
       *
       *
       * <pre>
       * RSASSA-PSS 4096 bit key with a SHA512 digest.
       * </pre>
       *
       * <code>RSA_PSS_4096_SHA512 = 4;</code>
       */
      public static final int RSA_PSS_4096_SHA512_VALUE = 4;
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
       */
      public static final int RSA_SIGN_PKCS1_2048_SHA256_VALUE = 5;
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
       */
      public static final int RSA_SIGN_PKCS1_3072_SHA256_VALUE = 6;
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
       */
      public static final int RSA_SIGN_PKCS1_4096_SHA256_VALUE = 7;
      /**
       *
       *
       * <pre>
       * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
       * </pre>
       *
       * <code>RSA_SIGN_PKCS1_4096_SHA512 = 8;</code>
       */
      public static final int RSA_SIGN_PKCS1_4096_SHA512_VALUE = 8;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-256 curve with a SHA256 digest.
       * </pre>
       *
       * <code>ECDSA_P256_SHA256 = 9;</code>
       */
      public static final int ECDSA_P256_SHA256_VALUE = 9;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-256 curve with a SHA256 digest.
       * </pre>
       *
       * <code>EC_SIGN_P256_SHA256 = 9;</code>
       */
      public static final int EC_SIGN_P256_SHA256_VALUE = 9;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-384 curve with a SHA384 digest.
       * </pre>
       *
       * <code>ECDSA_P384_SHA384 = 10;</code>
       */
      public static final int ECDSA_P384_SHA384_VALUE = 10;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-384 curve with a SHA384 digest.
       * </pre>
       *
       * <code>EC_SIGN_P384_SHA384 = 10;</code>
       */
      public static final int EC_SIGN_P384_SHA384_VALUE = 10;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-521 curve with a SHA512 digest.
       * </pre>
       *
       * <code>ECDSA_P521_SHA512 = 11;</code>
       */
      public static final int ECDSA_P521_SHA512_VALUE = 11;
      /**
       *
       *
       * <pre>
       * ECDSA on the NIST P-521 curve with a SHA512 digest.
       * </pre>
       *
       * <code>EC_SIGN_P521_SHA512 = 11;</code>
       */
      public static final int EC_SIGN_P521_SHA512_VALUE = 11;

      public final int getNumber() {
        if (index == -1) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SignatureAlgorithm valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SignatureAlgorithm forNumber(int value) {
        switch (value) {
          case 0:
            return SIGNATURE_ALGORITHM_UNSPECIFIED;
          case 1:
            return RSA_PSS_2048_SHA256;
          case 2:
            return RSA_PSS_3072_SHA256;
          case 3:
            return RSA_PSS_4096_SHA256;
          case 4:
            return RSA_PSS_4096_SHA512;
          case 5:
            return RSA_SIGN_PKCS1_2048_SHA256;
          case 6:
            return RSA_SIGN_PKCS1_3072_SHA256;
          case 7:
            return RSA_SIGN_PKCS1_4096_SHA256;
          case 8:
            return RSA_SIGN_PKCS1_4096_SHA512;
          case 9:
            return ECDSA_P256_SHA256;
          case 10:
            return ECDSA_P384_SHA384;
          case 11:
            return ECDSA_P521_SHA512;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>() {
                public SignatureAlgorithm findValueByNumber(int number) {
                  return SignatureAlgorithm.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (index == -1) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(index);
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SignatureAlgorithm[] VALUES = getStaticValuesArray();

      private static SignatureAlgorithm[] getStaticValuesArray() {
        return new SignatureAlgorithm[] {
          SIGNATURE_ALGORITHM_UNSPECIFIED,
          RSA_PSS_2048_SHA256,
          RSA_PSS_3072_SHA256,
          RSA_PSS_4096_SHA256,
          RSA_PSS_4096_SHA512,
          RSA_SIGN_PKCS1_2048_SHA256,
          RSA_SIGN_PKCS1_3072_SHA256,
          RSA_SIGN_PKCS1_4096_SHA256,
          RSA_SIGN_PKCS1_4096_SHA512,
          ECDSA_P256_SHA256,
          EC_SIGN_P256_SHA256,
          ECDSA_P384_SHA384,
          EC_SIGN_P384_SHA384,
          ECDSA_P521_SHA512,
          EC_SIGN_P521_SHA512,
        };
      }

      public static SignatureAlgorithm valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private SignatureAlgorithm(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm)
    }

    public static final int PUBLIC_KEY_PEM_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publicKeyPem_ = "";
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The publicKeyPem.
     */
    @java.lang.Override
    public java.lang.String getPublicKeyPem() {
      java.lang.Object ref = publicKeyPem_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicKeyPem_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The bytes for publicKeyPem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicKeyPemBytes() {
      java.lang.Object ref = publicKeyPem_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicKeyPem_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIGNATURE_ALGORITHM_FIELD_NUMBER = 2;
    private int signatureAlgorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for signatureAlgorithm.
     */
    @java.lang.Override
    public int getSignatureAlgorithmValue() {
      return signatureAlgorithm_;
    }
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The signatureAlgorithm.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
            .SignatureAlgorithm
        getSignatureAlgorithm() {
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .SignatureAlgorithm
          result =
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                  .SignatureAlgorithm.forNumber(signatureAlgorithm_);
      return result == null
          ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .SignatureAlgorithm.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicKeyPem_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, publicKeyPem_);
      }
      if (signatureAlgorithm_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .SignatureAlgorithm.SIGNATURE_ALGORITHM_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, signatureAlgorithm_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicKeyPem_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, publicKeyPem_);
      }
      if (signatureAlgorithm_
          != com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .SignatureAlgorithm.SIGNATURE_ALGORITHM_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, signatureAlgorithm_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey) obj;

      if (!getPublicKeyPem().equals(other.getPublicKeyPem())) return false;
      if (signatureAlgorithm_ != other.signatureAlgorithm_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PUBLIC_KEY_PEM_FIELD_NUMBER;
      hash = (53 * hash) + getPublicKeyPem().hashCode();
      hash = (37 * hash) + SIGNATURE_ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + signatureAlgorithm_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A public key in the PkixPublicKey format (see
     * https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
     * Public keys of this type are typically textually encoded using the PEM
     * format.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.PkixPublicKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.PkixPublicKey)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                    .Builder.class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        publicKeyPem_ = "";
        signatureAlgorithm_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey result =
            new com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.publicKeyPem_ = publicKeyPem_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.signatureAlgorithm_ = signatureAlgorithm_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                .getDefaultInstance()) return this;
        if (!other.getPublicKeyPem().isEmpty()) {
          publicKeyPem_ = other.publicKeyPem_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.signatureAlgorithm_ != 0) {
          setSignatureAlgorithmValue(other.getSignatureAlgorithmValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  publicKeyPem_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  signatureAlgorithm_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object publicKeyPem_ = "";
      /**
       *
       *
       * <pre>
       * A PEM-encoded public key, as described in
       * https://tools.ietf.org/html/rfc7468#section-13
       * </pre>
       *
       * <code>string public_key_pem = 1;</code>
       *
       * @return The publicKeyPem.
       */
      public java.lang.String getPublicKeyPem() {
        java.lang.Object ref = publicKeyPem_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicKeyPem_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A PEM-encoded public key, as described in
       * https://tools.ietf.org/html/rfc7468#section-13
       * </pre>
       *
       * <code>string public_key_pem = 1;</code>
       *
       * @return The bytes for publicKeyPem.
       */
      public com.google.protobuf.ByteString getPublicKeyPemBytes() {
        java.lang.Object ref = publicKeyPem_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicKeyPem_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A PEM-encoded public key, as described in
       * https://tools.ietf.org/html/rfc7468#section-13
       * </pre>
       *
       * <code>string public_key_pem = 1;</code>
       *
       * @param value The publicKeyPem to set.
       * @return This builder for chaining.
       */
      public Builder setPublicKeyPem(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicKeyPem_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A PEM-encoded public key, as described in
       * https://tools.ietf.org/html/rfc7468#section-13
       * </pre>
       *
       * <code>string public_key_pem = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicKeyPem() {
        publicKeyPem_ = getDefaultInstance().getPublicKeyPem();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A PEM-encoded public key, as described in
       * https://tools.ietf.org/html/rfc7468#section-13
       * </pre>
       *
       * <code>string public_key_pem = 1;</code>
       *
       * @param value The bytes for publicKeyPem to set.
       * @return This builder for chaining.
       */
      public Builder setPublicKeyPemBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicKeyPem_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int signatureAlgorithm_ = 0;
      /**
       *
       *
       * <pre>
       * The signature algorithm used to verify a message against a signature using
       * this key.
       * These signature algorithm must match the structure and any object
       * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
       * that of the public key).
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for signatureAlgorithm.
       */
      @java.lang.Override
      public int getSignatureAlgorithmValue() {
        return signatureAlgorithm_;
      }
      /**
       *
       *
       * <pre>
       * The signature algorithm used to verify a message against a signature using
       * this key.
       * These signature algorithm must match the structure and any object
       * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
       * that of the public key).
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for signatureAlgorithm to set.
       * @return This builder for chaining.
       */
      public Builder setSignatureAlgorithmValue(int value) {
        signatureAlgorithm_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The signature algorithm used to verify a message against a signature using
       * this key.
       * These signature algorithm must match the structure and any object
       * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
       * that of the public key).
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
       * </code>
       *
       * @return The signatureAlgorithm.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .SignatureAlgorithm
          getSignatureAlgorithm() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                .SignatureAlgorithm
            result =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                    .SignatureAlgorithm.forNumber(signatureAlgorithm_);
        return result == null
            ? com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                .SignatureAlgorithm.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The signature algorithm used to verify a message against a signature using
       * this key.
       * These signature algorithm must match the structure and any object
       * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
       * that of the public key).
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
       * </code>
       *
       * @param value The signatureAlgorithm to set.
       * @return This builder for chaining.
       */
      public Builder setSignatureAlgorithm(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                  .SignatureAlgorithm
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        signatureAlgorithm_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The signature algorithm used to verify a message against a signature using
       * this key.
       * These signature algorithm must match the structure and any object
       * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
       * that of the public key).
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSignatureAlgorithm() {
        bitField0_ = (bitField0_ & ~0x00000002);
        signatureAlgorithm_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.PkixPublicKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.PkixPublicKey)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .PkixPublicKey
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PkixPublicKey> PARSER =
        new com.google.protobuf.AbstractParser<PkixPublicKey>() {
          @java.lang.Override
          public PkixPublicKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PkixPublicKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PkixPublicKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AttestorPublicKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1.AttestorPublicKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The comment.
     */
    java.lang.String getComment();
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for comment.
     */
    com.google.protobuf.ByteString getCommentBytes();

    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return Whether the asciiArmoredPgpPublicKey field is set.
     */
    boolean hasAsciiArmoredPgpPublicKey();
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The asciiArmoredPgpPublicKey.
     */
    java.lang.String getAsciiArmoredPgpPublicKey();
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The bytes for asciiArmoredPgpPublicKey.
     */
    com.google.protobuf.ByteString getAsciiArmoredPgpPublicKeyBytes();

    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return Whether the pkixPublicKey field is set.
     */
    boolean hasPkixPublicKey();
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return The pkixPublicKey.
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        getPkixPublicKey();
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     */
    com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKeyOrBuilder
        getPkixPublicKeyOrBuilder();

    com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey.PublicKeyCase
        getPublicKeyCase();
  }
  /**
   *
   *
   * <pre>
   * An [attestor public key][google.cloud.binaryauthorization.v1.AttestorPublicKey] that will be used to verify
   * attestations signed by this attestor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1.AttestorPublicKey}
   */
  public static final class AttestorPublicKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1.AttestorPublicKey)
      AttestorPublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AttestorPublicKey.newBuilder() to construct.
    private AttestorPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AttestorPublicKey() {
      comment_ = "";
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AttestorPublicKey();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources
          .internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                  .class,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                  .Builder.class);
    }

    private int publicKeyCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object publicKey_;

    public enum PublicKeyCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ASCII_ARMORED_PGP_PUBLIC_KEY(3),
      PKIX_PUBLIC_KEY(5),
      PUBLICKEY_NOT_SET(0);
      private final int value;

      private PublicKeyCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PublicKeyCase valueOf(int value) {
        return forNumber(value);
      }

      public static PublicKeyCase forNumber(int value) {
        switch (value) {
          case 3:
            return ASCII_ARMORED_PGP_PUBLIC_KEY;
          case 5:
            return PKIX_PUBLIC_KEY;
          case 0:
            return PUBLICKEY_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public PublicKeyCase getPublicKeyCase() {
      return PublicKeyCase.forNumber(publicKeyCase_);
    }

    public static final int COMMENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object comment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The comment.
     */
    @java.lang.Override
    public java.lang.String getComment() {
      java.lang.Object ref = comment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        comment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for comment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCommentBytes() {
      java.lang.Object ref = comment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        comment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ASCII_ARMORED_PGP_PUBLIC_KEY_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return Whether the asciiArmoredPgpPublicKey field is set.
     */
    public boolean hasAsciiArmoredPgpPublicKey() {
      return publicKeyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The asciiArmoredPgpPublicKey.
     */
    public java.lang.String getAsciiArmoredPgpPublicKey() {
      java.lang.Object ref = "";
      if (publicKeyCase_ == 3) {
        ref = publicKey_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (publicKeyCase_ == 3) {
          publicKey_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The bytes for asciiArmoredPgpPublicKey.
     */
    public com.google.protobuf.ByteString getAsciiArmoredPgpPublicKeyBytes() {
      java.lang.Object ref = "";
      if (publicKeyCase_ == 3) {
        ref = publicKey_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (publicKeyCase_ == 3) {
          publicKey_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PKIX_PUBLIC_KEY_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return Whether the pkixPublicKey field is set.
     */
    @java.lang.Override
    public boolean hasPkixPublicKey() {
      return publicKeyCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return The pkixPublicKey.
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
        getPkixPublicKey() {
      if (publicKeyCase_ == 5) {
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
            publicKey_;
      }
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
     */
    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKeyOrBuilder
        getPkixPublicKeyOrBuilder() {
      if (publicKeyCase_ == 5) {
        return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
            publicKey_;
      }
      return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, comment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
      }
      if (publicKeyCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, publicKey_);
      }
      if (publicKeyCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                publicKey_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, comment_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
      }
      if (publicKeyCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, publicKey_);
      }
      if (publicKeyCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                    publicKey_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey)) {
        return super.equals(obj);
      }
      com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey other =
          (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey) obj;

      if (!getComment().equals(other.getComment())) return false;
      if (!getId().equals(other.getId())) return false;
      if (!getPublicKeyCase().equals(other.getPublicKeyCase())) return false;
      switch (publicKeyCase_) {
        case 3:
          if (!getAsciiArmoredPgpPublicKey().equals(other.getAsciiArmoredPgpPublicKey()))
            return false;
          break;
        case 5:
          if (!getPkixPublicKey().equals(other.getPkixPublicKey())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COMMENT_FIELD_NUMBER;
      hash = (53 * hash) + getComment().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      switch (publicKeyCase_) {
        case 3:
          hash = (37 * hash) + ASCII_ARMORED_PGP_PUBLIC_KEY_FIELD_NUMBER;
          hash = (53 * hash) + getAsciiArmoredPgpPublicKey().hashCode();
          break;
        case 5:
          hash = (37 * hash) + PKIX_PUBLIC_KEY_FIELD_NUMBER;
          hash = (53 * hash) + getPkixPublicKey().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An [attestor public key][google.cloud.binaryauthorization.v1.AttestorPublicKey] that will be used to verify
     * attestations signed by this attestor.
     * </pre>
     *
     * Protobuf type {@code google.cloud.binaryauthorization.v1.AttestorPublicKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1.AttestorPublicKey)
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                    .class,
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                    .Builder.class);
      }

      // Construct using
      // com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        comment_ = "";
        id_ = "";
        if (pkixPublicKeyBuilder_ != null) {
          pkixPublicKeyBuilder_.clear();
        }
        publicKeyCase_ = 0;
        publicKey_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
          getDefaultInstanceForType() {
        return com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
          build() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
          buildPartial() {
        com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey result =
            new com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.comment_ = comment_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.id_ = id_;
        }
      }

      private void buildPartialOneofs(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
              result) {
        result.publicKeyCase_ = publicKeyCase_;
        result.publicKey_ = this.publicKey_;
        if (publicKeyCase_ == 5 && pkixPublicKeyBuilder_ != null) {
          result.publicKey_ = pkixPublicKeyBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey) {
          return mergeFrom(
              (com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey other) {
        if (other
            == com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
                .getDefaultInstance()) return this;
        if (!other.getComment().isEmpty()) {
          comment_ = other.comment_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getPublicKeyCase()) {
          case ASCII_ARMORED_PGP_PUBLIC_KEY:
            {
              publicKeyCase_ = 3;
              publicKey_ = other.publicKey_;
              onChanged();
              break;
            }
          case PKIX_PUBLIC_KEY:
            {
              mergePkixPublicKey(other.getPkixPublicKey());
              break;
            }
          case PUBLICKEY_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  comment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  publicKeyCase_ = 3;
                  publicKey_ = s;
                  break;
                } // case 26
              case 42:
                {
                  input.readMessage(getPkixPublicKeyFieldBuilder().getBuilder(), extensionRegistry);
                  publicKeyCase_ = 5;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int publicKeyCase_ = 0;
      private java.lang.Object publicKey_;

      public PublicKeyCase getPublicKeyCase() {
        return PublicKeyCase.forNumber(publicKeyCase_);
      }

      public Builder clearPublicKey() {
        publicKeyCase_ = 0;
        publicKey_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object comment_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment. This field may be updated.
       * </pre>
       *
       * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The comment.
       */
      public java.lang.String getComment() {
        java.lang.Object ref = comment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          comment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment. This field may be updated.
       * </pre>
       *
       * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for comment.
       */
      public com.google.protobuf.ByteString getCommentBytes() {
        java.lang.Object ref = comment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          comment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment. This field may be updated.
       * </pre>
       *
       * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The comment to set.
       * @return This builder for chaining.
       */
      public Builder setComment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        comment_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment. This field may be updated.
       * </pre>
       *
       * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearComment() {
        comment_ = getDefaultInstance().getComment();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A descriptive comment. This field may be updated.
       * </pre>
       *
       * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for comment to set.
       * @return This builder for chaining.
       */
      public Builder setCommentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        comment_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * The ID of this public key.
       * Signatures verified by BinAuthz must include the ID of the public key that
       * can be used to verify them, and that ID must match the contents of this
       * field exactly.
       * Additional restrictions on this field can be imposed based on which public
       * key type is encapsulated. See the documentation on `public_key` cases below
       * for details.
       * </pre>
       *
       * <code>string id = 2;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of this public key.
       * Signatures verified by BinAuthz must include the ID of the public key that
       * can be used to verify them, and that ID must match the contents of this
       * field exactly.
       * Additional restrictions on this field can be imposed based on which public
       * key type is encapsulated. See the documentation on `public_key` cases below
       * for details.
       * </pre>
       *
       * <code>string id = 2;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of this public key.
       * Signatures verified by BinAuthz must include the ID of the public key that
       * can be used to verify them, and that ID must match the contents of this
       * field exactly.
       * Additional restrictions on this field can be imposed based on which public
       * key type is encapsulated. See the documentation on `public_key` cases below
       * for details.
       * </pre>
       *
       * <code>string id = 2;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of this public key.
       * Signatures verified by BinAuthz must include the ID of the public key that
       * can be used to verify them, and that ID must match the contents of this
       * field exactly.
       * Additional restrictions on this field can be imposed based on which public
       * key type is encapsulated. See the documentation on `public_key` cases below
       * for details.
       * </pre>
       *
       * <code>string id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of this public key.
       * Signatures verified by BinAuthz must include the ID of the public key that
       * can be used to verify them, and that ID must match the contents of this
       * field exactly.
       * Additional restrictions on this field can be imposed based on which public
       * key type is encapsulated. See the documentation on `public_key` cases below
       * for details.
       * </pre>
       *
       * <code>string id = 2;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @return Whether the asciiArmoredPgpPublicKey field is set.
       */
      @java.lang.Override
      public boolean hasAsciiArmoredPgpPublicKey() {
        return publicKeyCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @return The asciiArmoredPgpPublicKey.
       */
      @java.lang.Override
      public java.lang.String getAsciiArmoredPgpPublicKey() {
        java.lang.Object ref = "";
        if (publicKeyCase_ == 3) {
          ref = publicKey_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (publicKeyCase_ == 3) {
            publicKey_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @return The bytes for asciiArmoredPgpPublicKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAsciiArmoredPgpPublicKeyBytes() {
        java.lang.Object ref = "";
        if (publicKeyCase_ == 3) {
          ref = publicKey_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (publicKeyCase_ == 3) {
            publicKey_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @param value The asciiArmoredPgpPublicKey to set.
       * @return This builder for chaining.
       */
      public Builder setAsciiArmoredPgpPublicKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicKeyCase_ = 3;
        publicKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAsciiArmoredPgpPublicKey() {
        if (publicKeyCase_ == 3) {
          publicKeyCase_ = 0;
          publicKey_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * ASCII-armored representation of a PGP public key, as the entire output by
       * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
       * line endings).
       * When using this field, `id` should be left blank.  The BinAuthz API
       * handlers will calculate the ID and fill it in automatically.  BinAuthz
       * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
       * upper-case hex.  If `id` is provided by the caller, it will be
       * overwritten by the API-calculated ID.
       * </pre>
       *
       * <code>string ascii_armored_pgp_public_key = 3;</code>
       *
       * @param value The bytes for asciiArmoredPgpPublicKey to set.
       * @return This builder for chaining.
       */
      public Builder setAsciiArmoredPgpPublicKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicKeyCase_ = 3;
        publicKey_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .PkixPublicKeyOrBuilder>
          pkixPublicKeyBuilder_;
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       *
       * @return Whether the pkixPublicKey field is set.
       */
      @java.lang.Override
      public boolean hasPkixPublicKey() {
        return publicKeyCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       *
       * @return The pkixPublicKey.
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
          getPkixPublicKey() {
        if (pkixPublicKeyBuilder_ == null) {
          if (publicKeyCase_ == 5) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                publicKey_;
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .getDefaultInstance();
        } else {
          if (publicKeyCase_ == 5) {
            return pkixPublicKeyBuilder_.getMessage();
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      public Builder setPkixPublicKey(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey value) {
        if (pkixPublicKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          publicKey_ = value;
          onChanged();
        } else {
          pkixPublicKeyBuilder_.setMessage(value);
        }
        publicKeyCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      public Builder setPkixPublicKey(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.Builder
              builderForValue) {
        if (pkixPublicKeyBuilder_ == null) {
          publicKey_ = builderForValue.build();
          onChanged();
        } else {
          pkixPublicKeyBuilder_.setMessage(builderForValue.build());
        }
        publicKeyCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      public Builder mergePkixPublicKey(
          com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey value) {
        if (pkixPublicKeyBuilder_ == null) {
          if (publicKeyCase_ == 5
              && publicKey_
                  != com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                      .getDefaultInstance()) {
            publicKey_ =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                    .newBuilder(
                        (com.google.protos.google.cloud.binaryauthorization.v1.Resources
                                .PkixPublicKey)
                            publicKey_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            publicKey_ = value;
          }
          onChanged();
        } else {
          if (publicKeyCase_ == 5) {
            pkixPublicKeyBuilder_.mergeFrom(value);
          } else {
            pkixPublicKeyBuilder_.setMessage(value);
          }
        }
        publicKeyCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      public Builder clearPkixPublicKey() {
        if (pkixPublicKeyBuilder_ == null) {
          if (publicKeyCase_ == 5) {
            publicKeyCase_ = 0;
            publicKey_ = null;
            onChanged();
          }
        } else {
          if (publicKeyCase_ == 5) {
            publicKeyCase_ = 0;
            publicKey_ = null;
          }
          pkixPublicKeyBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.Builder
          getPkixPublicKeyBuilder() {
        return getPkixPublicKeyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      @java.lang.Override
      public com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKeyOrBuilder
          getPkixPublicKeyOrBuilder() {
        if ((publicKeyCase_ == 5) && (pkixPublicKeyBuilder_ != null)) {
          return pkixPublicKeyBuilder_.getMessageOrBuilder();
        } else {
          if (publicKeyCase_ == 5) {
            return (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                publicKey_;
          }
          return com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A raw PKIX SubjectPublicKeyInfo format public key.
       *
       * NOTE: `id` may be explicitly provided by the caller when using this
       * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
       * blank, a default one will be computed based on the digest of the DER
       * encoding of the public key.
       * </pre>
       *
       * <code>.google.cloud.binaryauthorization.v1.PkixPublicKey pkix_public_key = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey.Builder,
              com.google.protos.google.cloud.binaryauthorization.v1.Resources
                  .PkixPublicKeyOrBuilder>
          getPkixPublicKeyFieldBuilder() {
        if (pkixPublicKeyBuilder_ == null) {
          if (!(publicKeyCase_ == 5)) {
            publicKey_ =
                com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                    .getDefaultInstance();
          }
          pkixPublicKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey
                      .Builder,
                  com.google.protos.google.cloud.binaryauthorization.v1.Resources
                      .PkixPublicKeyOrBuilder>(
                  (com.google.protos.google.cloud.binaryauthorization.v1.Resources.PkixPublicKey)
                      publicKey_,
                  getParentForChildren(),
                  isClean());
          publicKey_ = null;
        }
        publicKeyCase_ = 5;
        onChanged();
        return pkixPublicKeyBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1.AttestorPublicKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1.AttestorPublicKey)
    private static final com.google.protos.google.cloud.binaryauthorization.v1.Resources
            .AttestorPublicKey
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey();
    }

    public static com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AttestorPublicKey> PARSER =
        new com.google.protobuf.AbstractParser<AttestorPublicKey>() {
          @java.lang.Override
          public AttestorPublicKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AttestorPublicKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AttestorPublicKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protos.google.cloud.binaryauthorization.v1.Resources.AttestorPublicKey
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Policy_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_Attestor_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n3google/cloud/binaryauthorization/v1/re"
          + "sources.proto\022#google.cloud.binaryauthor"
          + "ization.v1\032\037google/api/field_behavior.pr"
          + "oto\032\031google/api/resource.proto\032\037google/p"
          + "rotobuf/timestamp.proto\"\370\014\n\006Policy\022\021\n\004na"
          + "me\030\001 \001(\tB\003\340A\003\022\030\n\013description\030\006 \001(\tB\003\340A\001\022"
          + "r\n\035global_policy_evaluation_mode\030\007 \001(\0162F"
          + ".google.cloud.binaryauthorization.v1.Pol"
          + "icy.GlobalPolicyEvaluationModeB\003\340A\001\022i\n\034a"
          + "dmission_whitelist_patterns\030\002 \003(\0132>.goog"
          + "le.cloud.binaryauthorization.v1.Admissio"
          + "nWhitelistPatternB\003\340A\001\022l\n\027cluster_admiss"
          + "ion_rules\030\003 \003(\0132F.google.cloud.binaryaut"
          + "horization.v1.Policy.ClusterAdmissionRul"
          + "esEntryB\003\340A\001\022\205\001\n$kubernetes_namespace_ad"
          + "mission_rules\030\n \003(\0132R.google.cloud.binar"
          + "yauthorization.v1.Policy.KubernetesNames"
          + "paceAdmissionRulesEntryB\003\340A\001\022\220\001\n*kuberne"
          + "tes_service_account_admission_rules\030\010 \003("
          + "\0132W.google.cloud.binaryauthorization.v1."
          + "Policy.KubernetesServiceAccountAdmission"
          + "RulesEntryB\003\340A\001\022\210\001\n&istio_service_identi"
          + "ty_admission_rules\030\t \003(\0132S.google.cloud."
          + "binaryauthorization.v1.Policy.IstioServi"
          + "ceIdentityAdmissionRulesEntryB\003\340A\001\022W\n\026de"
          + "fault_admission_rule\030\004 \001(\01322.google.clou"
          + "d.binaryauthorization.v1.AdmissionRuleB\003"
          + "\340A\002\0224\n\013update_time\030\005 \001(\0132\032.google.protob"
          + "uf.TimestampB\003\340A\003\032p\n\032ClusterAdmissionRul"
          + "esEntry\022\013\n\003key\030\001 \001(\t\022A\n\005value\030\002 \001(\01322.go"
          + "ogle.cloud.binaryauthorization.v1.Admiss"
          + "ionRule:\0028\001\032|\n&KubernetesNamespaceAdmiss"
          + "ionRulesEntry\022\013\n\003key\030\001 \001(\t\022A\n\005value\030\002 \001("
          + "\01322.google.cloud.binaryauthorization.v1."
          + "AdmissionRule:\0028\001\032\201\001\n+KubernetesServiceA"
          + "ccountAdmissionRulesEntry\022\013\n\003key\030\001 \001(\t\022A"
          + "\n\005value\030\002 \001(\01322.google.cloud.binaryautho"
          + "rization.v1.AdmissionRule:\0028\001\032}\n\'IstioSe"
          + "rviceIdentityAdmissionRulesEntry\022\013\n\003key\030"
          + "\001 \001(\t\022A\n\005value\030\002 \001(\01322.google.cloud.bina"
          + "ryauthorization.v1.AdmissionRule:\0028\001\"d\n\032"
          + "GlobalPolicyEvaluationMode\022-\n)GLOBAL_POL"
          + "ICY_EVALUATION_MODE_UNSPECIFIED\020\000\022\n\n\006ENA"
          + "BLE\020\001\022\013\n\007DISABLE\020\002:f\352Ac\n)binaryauthoriza"
          + "tion.googleapis.com/Policy\022\031projects/{pr"
          + "oject}/policy\022\033locations/{location}/poli"
          + "cy\"1\n\031AdmissionWhitelistPattern\022\024\n\014name_"
          + "pattern\030\001 \001(\t\"\332\003\n\rAdmissionRule\022_\n\017evalu"
          + "ation_mode\030\001 \001(\0162A.google.cloud.binaryau"
          + "thorization.v1.AdmissionRule.EvaluationM"
          + "odeB\003\340A\002\022$\n\027require_attestations_by\030\002 \003("
          + "\tB\003\340A\001\022a\n\020enforcement_mode\030\003 \001(\0162B.googl"
          + "e.cloud.binaryauthorization.v1.Admission"
          + "Rule.EnforcementModeB\003\340A\002\"m\n\016EvaluationM"
          + "ode\022\037\n\033EVALUATION_MODE_UNSPECIFIED\020\000\022\020\n\014"
          + "ALWAYS_ALLOW\020\001\022\027\n\023REQUIRE_ATTESTATION\020\002\022"
          + "\017\n\013ALWAYS_DENY\020\003\"p\n\017EnforcementMode\022 \n\034E"
          + "NFORCEMENT_MODE_UNSPECIFIED\020\000\022 \n\034ENFORCE"
          + "D_BLOCK_AND_AUDIT_LOG\020\001\022\031\n\025DRYRUN_AUDIT_"
          + "LOG_ONLY\020\002\"\267\002\n\010Attestor\022\021\n\004name\030\001 \001(\tB\003\340"
          + "A\002\022\030\n\013description\030\006 \001(\tB\003\340A\001\022\\\n\027user_own"
          + "ed_grafeas_note\030\003 \001(\01329.google.cloud.bin"
          + "aryauthorization.v1.UserOwnedGrafeasNote"
          + "H\000\0224\n\013update_time\030\004 \001(\0132\032.google.protobu"
          + "f.TimestampB\003\340A\003:Y\352AV\n+binaryauthorizati"
          + "on.googleapis.com/Attestor\022\'projects/{pr"
          + "oject}/attestors/{attestor}B\017\n\rattestor_"
          + "type\"\264\001\n\024UserOwnedGrafeasNote\022\033\n\016note_re"
          + "ference\030\001 \001(\tB\003\340A\002\022P\n\013public_keys\030\002 \003(\0132"
          + "6.google.cloud.binaryauthorization.v1.At"
          + "testorPublicKeyB\003\340A\001\022-\n delegation_servi"
          + "ce_account_email\030\003 \001(\tB\003\340A\003\"\277\004\n\rPkixPubl"
          + "icKey\022\026\n\016public_key_pem\030\001 \001(\t\022b\n\023signatu"
          + "re_algorithm\030\002 \001(\0162E.google.cloud.binary"
          + "authorization.v1.PkixPublicKey.Signature"
          + "Algorithm\"\261\003\n\022SignatureAlgorithm\022#\n\037SIGN"
          + "ATURE_ALGORITHM_UNSPECIFIED\020\000\022\027\n\023RSA_PSS"
          + "_2048_SHA256\020\001\022\027\n\023RSA_PSS_3072_SHA256\020\002\022"
          + "\027\n\023RSA_PSS_4096_SHA256\020\003\022\027\n\023RSA_PSS_4096"
          + "_SHA512\020\004\022\036\n\032RSA_SIGN_PKCS1_2048_SHA256\020"
          + "\005\022\036\n\032RSA_SIGN_PKCS1_3072_SHA256\020\006\022\036\n\032RSA"
          + "_SIGN_PKCS1_4096_SHA256\020\007\022\036\n\032RSA_SIGN_PK"
          + "CS1_4096_SHA512\020\010\022\025\n\021ECDSA_P256_SHA256\020\t"
          + "\022\027\n\023EC_SIGN_P256_SHA256\020\t\022\025\n\021ECDSA_P384_"
          + "SHA384\020\n\022\027\n\023EC_SIGN_P384_SHA384\020\n\022\025\n\021ECD"
          + "SA_P521_SHA512\020\013\022\027\n\023EC_SIGN_P521_SHA512\020"
          + "\013\032\002\020\001\"\272\001\n\021AttestorPublicKey\022\024\n\007comment\030\001"
          + " \001(\tB\003\340A\001\022\n\n\002id\030\002 \001(\t\022&\n\034ascii_armored_p"
          + "gp_public_key\030\003 \001(\tH\000\022M\n\017pkix_public_key"
          + "\030\005 \001(\01322.google.cloud.binaryauthorizatio"
          + "n.v1.PkixPublicKeyH\000B\014\n\npublic_keyB\214\002\n5c"
          + "om.google.protos.google.cloud.binaryauth"
          + "orization.v1P\000ZYcloud.google.com/go/bina"
          + "ryauthorization/apiv1/binaryauthorizatio"
          + "npb;binaryauthorizationpb\370\001\001\252\002#Google.Cl"
          + "oud.BinaryAuthorization.V1\312\002#Google\\Clou"
          + "d\\BinaryAuthorization\\V1\352\002&Google::Cloud"
          + "::BinaryAuthorization::V1b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.api.ResourceProto.getDescriptor(),
              com.google.protobuf.TimestampProto.getDescriptor(),
            });
    internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_binaryauthorization_v1_Policy_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor,
            new java.lang.String[] {
              "Name",
              "Description",
              "GlobalPolicyEvaluationMode",
              "AdmissionWhitelistPatterns",
              "ClusterAdmissionRules",
              "KubernetesNamespaceAdmissionRules",
              "KubernetesServiceAccountAdmissionRules",
              "IstioServiceIdentityAdmissionRules",
              "DefaultAdmissionRule",
              "UpdateTime",
            });
    internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_descriptor =
        internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor
            .getNestedTypes()
            .get(0);
    internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Policy_ClusterAdmissionRulesEntry_descriptor,
            new java.lang.String[] {
              "Key", "Value",
            });
    internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_descriptor =
        internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor
            .getNestedTypes()
            .get(1);
    internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesNamespaceAdmissionRulesEntry_descriptor,
            new java.lang.String[] {
              "Key", "Value",
            });
    internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_descriptor =
        internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor
            .getNestedTypes()
            .get(2);
    internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Policy_KubernetesServiceAccountAdmissionRulesEntry_descriptor,
            new java.lang.String[] {
              "Key", "Value",
            });
    internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_descriptor =
        internal_static_google_cloud_binaryauthorization_v1_Policy_descriptor
            .getNestedTypes()
            .get(3);
    internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Policy_IstioServiceIdentityAdmissionRulesEntry_descriptor,
            new java.lang.String[] {
              "Key", "Value",
            });
    internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_AdmissionWhitelistPattern_descriptor,
            new java.lang.String[] {
              "NamePattern",
            });
    internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_AdmissionRule_descriptor,
            new java.lang.String[] {
              "EvaluationMode", "RequireAttestationsBy", "EnforcementMode",
            });
    internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_cloud_binaryauthorization_v1_Attestor_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_Attestor_descriptor,
            new java.lang.String[] {
              "Name", "Description", "UserOwnedGrafeasNote", "UpdateTime", "AttestorType",
            });
    internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_UserOwnedGrafeasNote_descriptor,
            new java.lang.String[] {
              "NoteReference", "PublicKeys", "DelegationServiceAccountEmail",
            });
    internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_PkixPublicKey_descriptor,
            new java.lang.String[] {
              "PublicKeyPem", "SignatureAlgorithm",
            });
    internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_binaryauthorization_v1_AttestorPublicKey_descriptor,
            new java.lang.String[] {
              "Comment", "Id", "AsciiArmoredPgpPublicKey", "PkixPublicKey", "PublicKey",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.ResourceProto.resource);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.api.ResourceProto.getDescriptor();
    com.google.protobuf.TimestampProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
