/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * An [admission rule][google.cloud.binaryauthorization.v1beta1.AdmissionRule] specifies either that all container images
 * used in a pod creation request must be attested to by one or more
 * [attestors][google.cloud.binaryauthorization.v1beta1.Attestor], that all pod creations will be allowed, or that all
 * pod creations will be denied.
 *
 * Images matching an [admission allowlist pattern][google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern]
 * are exempted from admission rules and will never block a pod creation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.AdmissionRule}
 */
public final class AdmissionRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.AdmissionRule)
    AdmissionRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdmissionRule.newBuilder() to construct.
  private AdmissionRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdmissionRule() {
    evaluationMode_ = 0;
    requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
    enforcementMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdmissionRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_AdmissionRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_AdmissionRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.class,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder.class);
  }

  /** Protobuf enum {@code google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode} */
  public enum EvaluationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>EVALUATION_MODE_UNSPECIFIED = 0;</code>
     */
    EVALUATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This rule allows all all pod creations.
     * </pre>
     *
     * <code>ALWAYS_ALLOW = 1;</code>
     */
    ALWAYS_ALLOW(1),
    /**
     *
     *
     * <pre>
     * This rule allows a pod creation if all the attestors listed in
     * `require_attestations_by` have valid attestations for all of the
     * images in the pod spec.
     * </pre>
     *
     * <code>REQUIRE_ATTESTATION = 2;</code>
     */
    REQUIRE_ATTESTATION(2),
    /**
     *
     *
     * <pre>
     * This rule denies all pod creations.
     * </pre>
     *
     * <code>ALWAYS_DENY = 3;</code>
     */
    ALWAYS_DENY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>EVALUATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int EVALUATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This rule allows all all pod creations.
     * </pre>
     *
     * <code>ALWAYS_ALLOW = 1;</code>
     */
    public static final int ALWAYS_ALLOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This rule allows a pod creation if all the attestors listed in
     * `require_attestations_by` have valid attestations for all of the
     * images in the pod spec.
     * </pre>
     *
     * <code>REQUIRE_ATTESTATION = 2;</code>
     */
    public static final int REQUIRE_ATTESTATION_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This rule denies all pod creations.
     * </pre>
     *
     * <code>ALWAYS_DENY = 3;</code>
     */
    public static final int ALWAYS_DENY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EvaluationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EvaluationMode forNumber(int value) {
      switch (value) {
        case 0:
          return EVALUATION_MODE_UNSPECIFIED;
        case 1:
          return ALWAYS_ALLOW;
        case 2:
          return REQUIRE_ATTESTATION;
        case 3:
          return ALWAYS_DENY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EvaluationMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EvaluationMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EvaluationMode>() {
          public EvaluationMode findValueByNumber(int number) {
            return EvaluationMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EvaluationMode[] VALUES = values();

    public static EvaluationMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EvaluationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode)
  }

  /**
   *
   *
   * <pre>
   * Defines the possible actions when a pod creation is denied by an admission
   * rule.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode}
   */
  public enum EnforcementMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>ENFORCEMENT_MODE_UNSPECIFIED = 0;</code>
     */
    ENFORCEMENT_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Enforce the admission rule by blocking the pod creation.
     * </pre>
     *
     * <code>ENFORCED_BLOCK_AND_AUDIT_LOG = 1;</code>
     */
    ENFORCED_BLOCK_AND_AUDIT_LOG(1),
    /**
     *
     *
     * <pre>
     * Dryrun mode: Audit logging only.  This will allow the pod creation as if
     * the admission request had specified break-glass.
     * </pre>
     *
     * <code>DRYRUN_AUDIT_LOG_ONLY = 2;</code>
     */
    DRYRUN_AUDIT_LOG_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>ENFORCEMENT_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int ENFORCEMENT_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Enforce the admission rule by blocking the pod creation.
     * </pre>
     *
     * <code>ENFORCED_BLOCK_AND_AUDIT_LOG = 1;</code>
     */
    public static final int ENFORCED_BLOCK_AND_AUDIT_LOG_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Dryrun mode: Audit logging only.  This will allow the pod creation as if
     * the admission request had specified break-glass.
     * </pre>
     *
     * <code>DRYRUN_AUDIT_LOG_ONLY = 2;</code>
     */
    public static final int DRYRUN_AUDIT_LOG_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnforcementMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EnforcementMode forNumber(int value) {
      switch (value) {
        case 0:
          return ENFORCEMENT_MODE_UNSPECIFIED;
        case 1:
          return ENFORCED_BLOCK_AND_AUDIT_LOG;
        case 2:
          return DRYRUN_AUDIT_LOG_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EnforcementMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EnforcementMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EnforcementMode>() {
              public EnforcementMode findValueByNumber(int number) {
                return EnforcementMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final EnforcementMode[] VALUES = values();

    public static EnforcementMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EnforcementMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode)
  }

  public static final int EVALUATION_MODE_FIELD_NUMBER = 1;
  private int evaluationMode_ = 0;
  /**
   *
   *
   * <pre>
   * Required. How this admission rule will be evaluated.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for evaluationMode.
   */
  @java.lang.Override
  public int getEvaluationModeValue() {
    return evaluationMode_;
  }
  /**
   *
   *
   * <pre>
   * Required. How this admission rule will be evaluated.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The evaluationMode.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode
      getEvaluationMode() {
    com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode result =
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode.forNumber(
            evaluationMode_);
    return result == null
        ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode.UNRECOGNIZED
        : result;
  }

  public static final int REQUIRE_ATTESTATIONS_BY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList requireAttestationsBy_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The resource names of the attestors that must attest to
   * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
   * attestor must exist before a policy can reference it.  To add an attestor
   * to a policy the principal issuing the policy change request must be able
   * to read the attestor resource.
   *
   * Note: this field must be non-empty when the evaluation_mode field specifies
   * REQUIRE_ATTESTATION, otherwise it must be empty.
   * </pre>
   *
   * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the requireAttestationsBy.
   */
  public com.google.protobuf.ProtocolStringList getRequireAttestationsByList() {
    return requireAttestationsBy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource names of the attestors that must attest to
   * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
   * attestor must exist before a policy can reference it.  To add an attestor
   * to a policy the principal issuing the policy change request must be able
   * to read the attestor resource.
   *
   * Note: this field must be non-empty when the evaluation_mode field specifies
   * REQUIRE_ATTESTATION, otherwise it must be empty.
   * </pre>
   *
   * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of requireAttestationsBy.
   */
  public int getRequireAttestationsByCount() {
    return requireAttestationsBy_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource names of the attestors that must attest to
   * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
   * attestor must exist before a policy can reference it.  To add an attestor
   * to a policy the principal issuing the policy change request must be able
   * to read the attestor resource.
   *
   * Note: this field must be non-empty when the evaluation_mode field specifies
   * REQUIRE_ATTESTATION, otherwise it must be empty.
   * </pre>
   *
   * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The requireAttestationsBy at the given index.
   */
  public java.lang.String getRequireAttestationsBy(int index) {
    return requireAttestationsBy_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource names of the attestors that must attest to
   * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
   * attestor must exist before a policy can reference it.  To add an attestor
   * to a policy the principal issuing the policy change request must be able
   * to read the attestor resource.
   *
   * Note: this field must be non-empty when the evaluation_mode field specifies
   * REQUIRE_ATTESTATION, otherwise it must be empty.
   * </pre>
   *
   * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requireAttestationsBy at the given index.
   */
  public com.google.protobuf.ByteString getRequireAttestationsByBytes(int index) {
    return requireAttestationsBy_.getByteString(index);
  }

  public static final int ENFORCEMENT_MODE_FIELD_NUMBER = 3;
  private int enforcementMode_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The action when a pod creation is denied by the admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for enforcementMode.
   */
  @java.lang.Override
  public int getEnforcementModeValue() {
    return enforcementMode_;
  }
  /**
   *
   *
   * <pre>
   * Required. The action when a pod creation is denied by the admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enforcementMode.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode
      getEnforcementMode() {
    com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode result =
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode.forNumber(
            enforcementMode_);
    return result == null
        ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (evaluationMode_
        != com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode
            .EVALUATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, evaluationMode_);
    }
    for (int i = 0; i < requireAttestationsBy_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, requireAttestationsBy_.getRaw(i));
    }
    if (enforcementMode_
        != com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode
            .ENFORCEMENT_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, enforcementMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (evaluationMode_
        != com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode
            .EVALUATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, evaluationMode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requireAttestationsBy_.size(); i++) {
        dataSize += computeStringSizeNoTag(requireAttestationsBy_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequireAttestationsByList().size();
    }
    if (enforcementMode_
        != com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode
            .ENFORCEMENT_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, enforcementMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.AdmissionRule)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.AdmissionRule other =
        (com.google.cloud.binaryauthorization.v1beta1.AdmissionRule) obj;

    if (evaluationMode_ != other.evaluationMode_) return false;
    if (!getRequireAttestationsByList().equals(other.getRequireAttestationsByList())) return false;
    if (enforcementMode_ != other.enforcementMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVALUATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + evaluationMode_;
    if (getRequireAttestationsByCount() > 0) {
      hash = (37 * hash) + REQUIRE_ATTESTATIONS_BY_FIELD_NUMBER;
      hash = (53 * hash) + getRequireAttestationsByList().hashCode();
    }
    hash = (37 * hash) + ENFORCEMENT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + enforcementMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [admission rule][google.cloud.binaryauthorization.v1beta1.AdmissionRule] specifies either that all container images
   * used in a pod creation request must be attested to by one or more
   * [attestors][google.cloud.binaryauthorization.v1beta1.Attestor], that all pod creations will be allowed, or that all
   * pod creations will be denied.
   *
   * Images matching an [admission allowlist pattern][google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern]
   * are exempted from admission rules and will never block a pod creation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.AdmissionRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.AdmissionRule)
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AdmissionRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AdmissionRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.class,
              com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder.class);
    }

    // Construct using com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      evaluationMode_ = 0;
      requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
      enforcementMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AdmissionRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule build() {
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule result =
          new com.google.cloud.binaryauthorization.v1beta1.AdmissionRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.binaryauthorization.v1beta1.AdmissionRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.evaluationMode_ = evaluationMode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        requireAttestationsBy_.makeImmutable();
        result.requireAttestationsBy_ = requireAttestationsBy_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enforcementMode_ = enforcementMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.AdmissionRule) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.AdmissionRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.binaryauthorization.v1beta1.AdmissionRule other) {
      if (other == com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance())
        return this;
      if (other.evaluationMode_ != 0) {
        setEvaluationModeValue(other.getEvaluationModeValue());
      }
      if (!other.requireAttestationsBy_.isEmpty()) {
        if (requireAttestationsBy_.isEmpty()) {
          requireAttestationsBy_ = other.requireAttestationsBy_;
          bitField0_ |= 0x00000002;
        } else {
          ensureRequireAttestationsByIsMutable();
          requireAttestationsBy_.addAll(other.requireAttestationsBy_);
        }
        onChanged();
      }
      if (other.enforcementMode_ != 0) {
        setEnforcementModeValue(other.getEnforcementModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                evaluationMode_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequireAttestationsByIsMutable();
                requireAttestationsBy_.add(s);
                break;
              } // case 18
            case 24:
              {
                enforcementMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int evaluationMode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for evaluationMode.
     */
    @java.lang.Override
    public int getEvaluationModeValue() {
      return evaluationMode_;
    }
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for evaluationMode to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluationModeValue(int value) {
      evaluationMode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The evaluationMode.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode
        getEvaluationMode() {
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode result =
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode.forNumber(
              evaluationMode_);
      return result == null
          ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The evaluationMode to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluationMode(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      evaluationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. How this admission rule will be evaluated.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EvaluationMode evaluation_mode = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvaluationMode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      evaluationMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList requireAttestationsBy_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRequireAttestationsByIsMutable() {
      if (!requireAttestationsBy_.isModifiable()) {
        requireAttestationsBy_ =
            new com.google.protobuf.LazyStringArrayList(requireAttestationsBy_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the requireAttestationsBy.
     */
    public com.google.protobuf.ProtocolStringList getRequireAttestationsByList() {
      requireAttestationsBy_.makeImmutable();
      return requireAttestationsBy_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of requireAttestationsBy.
     */
    public int getRequireAttestationsByCount() {
      return requireAttestationsBy_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The requireAttestationsBy at the given index.
     */
    public java.lang.String getRequireAttestationsBy(int index) {
      return requireAttestationsBy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requireAttestationsBy at the given index.
     */
    public com.google.protobuf.ByteString getRequireAttestationsByBytes(int index) {
      return requireAttestationsBy_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The requireAttestationsBy to set.
     * @return This builder for chaining.
     */
    public Builder setRequireAttestationsBy(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequireAttestationsByIsMutable();
      requireAttestationsBy_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The requireAttestationsBy to add.
     * @return This builder for chaining.
     */
    public Builder addRequireAttestationsBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequireAttestationsByIsMutable();
      requireAttestationsBy_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The requireAttestationsBy to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequireAttestationsBy(java.lang.Iterable<java.lang.String> values) {
      ensureRequireAttestationsByIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requireAttestationsBy_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequireAttestationsBy() {
      requireAttestationsBy_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource names of the attestors that must attest to
     * a container image, in the format `projects/&#42;&#47;attestors/&#42;`. Each
     * attestor must exist before a policy can reference it.  To add an attestor
     * to a policy the principal issuing the policy change request must be able
     * to read the attestor resource.
     *
     * Note: this field must be non-empty when the evaluation_mode field specifies
     * REQUIRE_ATTESTATION, otherwise it must be empty.
     * </pre>
     *
     * <code>repeated string require_attestations_by = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the requireAttestationsBy to add.
     * @return This builder for chaining.
     */
    public Builder addRequireAttestationsByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequireAttestationsByIsMutable();
      requireAttestationsBy_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int enforcementMode_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for enforcementMode.
     */
    @java.lang.Override
    public int getEnforcementModeValue() {
      return enforcementMode_;
    }
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for enforcementMode to set.
     * @return This builder for chaining.
     */
    public Builder setEnforcementModeValue(int value) {
      enforcementMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enforcementMode.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode
        getEnforcementMode() {
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode result =
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode.forNumber(
              enforcementMode_);
      return result == null
          ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enforcementMode to set.
     * @return This builder for chaining.
     */
    public Builder setEnforcementMode(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      enforcementMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action when a pod creation is denied by the admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule.EnforcementMode enforcement_mode = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnforcementMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enforcementMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.AdmissionRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.AdmissionRule)
  private static final com.google.cloud.binaryauthorization.v1beta1.AdmissionRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.AdmissionRule();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdmissionRule> PARSER =
      new com.google.protobuf.AbstractParser<AdmissionRule>() {
        @java.lang.Override
        public AdmissionRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdmissionRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdmissionRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
