/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * An [attestor public key][google.cloud.binaryauthorization.v1beta1.AttestorPublicKey] that will be used to verify
 * attestations signed by this attestor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.AttestorPublicKey}
 */
public final class AttestorPublicKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.AttestorPublicKey)
    AttestorPublicKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttestorPublicKey.newBuilder() to construct.
  private AttestorPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttestorPublicKey() {
    comment_ = "";
    id_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttestorPublicKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_AttestorPublicKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_AttestorPublicKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.class,
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder.class);
  }

  private int publicKeyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object publicKey_;

  public enum PublicKeyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ASCII_ARMORED_PGP_PUBLIC_KEY(3),
    PKIX_PUBLIC_KEY(5),
    PUBLICKEY_NOT_SET(0);
    private final int value;

    private PublicKeyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PublicKeyCase valueOf(int value) {
      return forNumber(value);
    }

    public static PublicKeyCase forNumber(int value) {
      switch (value) {
        case 3:
          return ASCII_ARMORED_PGP_PUBLIC_KEY;
        case 5:
          return PKIX_PUBLIC_KEY;
        case 0:
          return PUBLICKEY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PublicKeyCase getPublicKeyCase() {
    return PublicKeyCase.forNumber(publicKeyCase_);
  }

  public static final int COMMENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object comment_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment. This field may be updated.
   * </pre>
   *
   * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The comment.
   */
  @java.lang.Override
  public java.lang.String getComment() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      comment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment. This field may be updated.
   * </pre>
   *
   * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for comment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCommentBytes() {
    java.lang.Object ref = comment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      comment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * The ID of this public key.
   * Signatures verified by BinAuthz must include the ID of the public key that
   * can be used to verify them, and that ID must match the contents of this
   * field exactly.
   * Additional restrictions on this field can be imposed based on which public
   * key type is encapsulated. See the documentation on `public_key` cases below
   * for details.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of this public key.
   * Signatures verified by BinAuthz must include the ID of the public key that
   * can be used to verify them, and that ID must match the contents of this
   * field exactly.
   * Additional restrictions on this field can be imposed based on which public
   * key type is encapsulated. See the documentation on `public_key` cases below
   * for details.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASCII_ARMORED_PGP_PUBLIC_KEY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * ASCII-armored representation of a PGP public key, as the entire output by
   * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
   * line endings).
   * When using this field, `id` should be left blank.  The BinAuthz API
   * handlers will calculate the ID and fill it in automatically.  BinAuthz
   * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
   * upper-case hex.  If `id` is provided by the caller, it will be
   * overwritten by the API-calculated ID.
   * </pre>
   *
   * <code>string ascii_armored_pgp_public_key = 3;</code>
   *
   * @return Whether the asciiArmoredPgpPublicKey field is set.
   */
  public boolean hasAsciiArmoredPgpPublicKey() {
    return publicKeyCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * ASCII-armored representation of a PGP public key, as the entire output by
   * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
   * line endings).
   * When using this field, `id` should be left blank.  The BinAuthz API
   * handlers will calculate the ID and fill it in automatically.  BinAuthz
   * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
   * upper-case hex.  If `id` is provided by the caller, it will be
   * overwritten by the API-calculated ID.
   * </pre>
   *
   * <code>string ascii_armored_pgp_public_key = 3;</code>
   *
   * @return The asciiArmoredPgpPublicKey.
   */
  public java.lang.String getAsciiArmoredPgpPublicKey() {
    java.lang.Object ref = "";
    if (publicKeyCase_ == 3) {
      ref = publicKey_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (publicKeyCase_ == 3) {
        publicKey_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ASCII-armored representation of a PGP public key, as the entire output by
   * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
   * line endings).
   * When using this field, `id` should be left blank.  The BinAuthz API
   * handlers will calculate the ID and fill it in automatically.  BinAuthz
   * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
   * upper-case hex.  If `id` is provided by the caller, it will be
   * overwritten by the API-calculated ID.
   * </pre>
   *
   * <code>string ascii_armored_pgp_public_key = 3;</code>
   *
   * @return The bytes for asciiArmoredPgpPublicKey.
   */
  public com.google.protobuf.ByteString getAsciiArmoredPgpPublicKeyBytes() {
    java.lang.Object ref = "";
    if (publicKeyCase_ == 3) {
      ref = publicKey_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (publicKeyCase_ == 3) {
        publicKey_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PKIX_PUBLIC_KEY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A raw PKIX SubjectPublicKeyInfo format public key.
   *
   * NOTE: `id` may be explicitly provided by the caller when using this
   * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
   * blank, a default one will be computed based on the digest of the DER
   * encoding of the public key.
   * </pre>
   *
   * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
   *
   * @return Whether the pkixPublicKey field is set.
   */
  @java.lang.Override
  public boolean hasPkixPublicKey() {
    return publicKeyCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A raw PKIX SubjectPublicKeyInfo format public key.
   *
   * NOTE: `id` may be explicitly provided by the caller when using this
   * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
   * blank, a default one will be computed based on the digest of the DER
   * encoding of the public key.
   * </pre>
   *
   * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
   *
   * @return The pkixPublicKey.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey getPkixPublicKey() {
    if (publicKeyCase_ == 5) {
      return (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A raw PKIX SubjectPublicKeyInfo format public key.
   *
   * NOTE: `id` may be explicitly provided by the caller when using this
   * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
   * blank, a default one will be computed based on the digest of the DER
   * encoding of the public key.
   * </pre>
   *
   * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder
      getPkixPublicKeyOrBuilder() {
    if (publicKeyCase_ == 5) {
      return (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, comment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (publicKeyCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, publicKey_);
    }
    if (publicKeyCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(comment_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, comment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (publicKeyCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, publicKey_);
    }
    if (publicKeyCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey other =
        (com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey) obj;

    if (!getComment().equals(other.getComment())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getPublicKeyCase().equals(other.getPublicKeyCase())) return false;
    switch (publicKeyCase_) {
      case 3:
        if (!getAsciiArmoredPgpPublicKey().equals(other.getAsciiArmoredPgpPublicKey()))
          return false;
        break;
      case 5:
        if (!getPkixPublicKey().equals(other.getPkixPublicKey())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COMMENT_FIELD_NUMBER;
    hash = (53 * hash) + getComment().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    switch (publicKeyCase_) {
      case 3:
        hash = (37 * hash) + ASCII_ARMORED_PGP_PUBLIC_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getAsciiArmoredPgpPublicKey().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PKIX_PUBLIC_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getPkixPublicKey().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [attestor public key][google.cloud.binaryauthorization.v1beta1.AttestorPublicKey] that will be used to verify
   * attestations signed by this attestor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.AttestorPublicKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.AttestorPublicKey)
      com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AttestorPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AttestorPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.class,
              com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder.class);
    }

    // Construct using com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      comment_ = "";
      id_ = "";
      if (pkixPublicKeyBuilder_ != null) {
        pkixPublicKeyBuilder_.clear();
      }
      publicKeyCase_ = 0;
      publicKey_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_AttestorPublicKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey
        getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey build() {
      com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey result =
          new com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.comment_ = comment_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey result) {
      result.publicKeyCase_ = publicKeyCase_;
      result.publicKey_ = this.publicKey_;
      if (publicKeyCase_ == 5 && pkixPublicKeyBuilder_ != null) {
        result.publicKey_ = pkixPublicKeyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey other) {
      if (other
          == com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.getDefaultInstance())
        return this;
      if (!other.getComment().isEmpty()) {
        comment_ = other.comment_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getPublicKeyCase()) {
        case ASCII_ARMORED_PGP_PUBLIC_KEY:
          {
            publicKeyCase_ = 3;
            publicKey_ = other.publicKey_;
            onChanged();
            break;
          }
        case PKIX_PUBLIC_KEY:
          {
            mergePkixPublicKey(other.getPkixPublicKey());
            break;
          }
        case PUBLICKEY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                comment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                publicKeyCase_ = 3;
                publicKey_ = s;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getPkixPublicKeyFieldBuilder().getBuilder(), extensionRegistry);
                publicKeyCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int publicKeyCase_ = 0;
    private java.lang.Object publicKey_;

    public PublicKeyCase getPublicKeyCase() {
      return PublicKeyCase.forNumber(publicKeyCase_);
    }

    public Builder clearPublicKey() {
      publicKeyCase_ = 0;
      publicKey_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object comment_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The comment.
     */
    public java.lang.String getComment() {
      java.lang.Object ref = comment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        comment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for comment.
     */
    public com.google.protobuf.ByteString getCommentBytes() {
      java.lang.Object ref = comment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        comment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The comment to set.
     * @return This builder for chaining.
     */
    public Builder setComment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      comment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComment() {
      comment_ = getDefaultInstance().getComment();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment. This field may be updated.
     * </pre>
     *
     * <code>string comment = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for comment to set.
     * @return This builder for chaining.
     */
    public Builder setCommentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      comment_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of this public key.
     * Signatures verified by BinAuthz must include the ID of the public key that
     * can be used to verify them, and that ID must match the contents of this
     * field exactly.
     * Additional restrictions on this field can be imposed based on which public
     * key type is encapsulated. See the documentation on `public_key` cases below
     * for details.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return Whether the asciiArmoredPgpPublicKey field is set.
     */
    @java.lang.Override
    public boolean hasAsciiArmoredPgpPublicKey() {
      return publicKeyCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The asciiArmoredPgpPublicKey.
     */
    @java.lang.Override
    public java.lang.String getAsciiArmoredPgpPublicKey() {
      java.lang.Object ref = "";
      if (publicKeyCase_ == 3) {
        ref = publicKey_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (publicKeyCase_ == 3) {
          publicKey_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return The bytes for asciiArmoredPgpPublicKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAsciiArmoredPgpPublicKeyBytes() {
      java.lang.Object ref = "";
      if (publicKeyCase_ == 3) {
        ref = publicKey_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (publicKeyCase_ == 3) {
          publicKey_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @param value The asciiArmoredPgpPublicKey to set.
     * @return This builder for chaining.
     */
    public Builder setAsciiArmoredPgpPublicKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicKeyCase_ = 3;
      publicKey_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAsciiArmoredPgpPublicKey() {
      if (publicKeyCase_ == 3) {
        publicKeyCase_ = 0;
        publicKey_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * ASCII-armored representation of a PGP public key, as the entire output by
     * the command `gpg --export --armor foo&#64;example.com` (either LF or CRLF
     * line endings).
     * When using this field, `id` should be left blank.  The BinAuthz API
     * handlers will calculate the ID and fill it in automatically.  BinAuthz
     * computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as
     * upper-case hex.  If `id` is provided by the caller, it will be
     * overwritten by the API-calculated ID.
     * </pre>
     *
     * <code>string ascii_armored_pgp_public_key = 3;</code>
     *
     * @param value The bytes for asciiArmoredPgpPublicKey to set.
     * @return This builder for chaining.
     */
    public Builder setAsciiArmoredPgpPublicKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publicKeyCase_ = 3;
      publicKey_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey,
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder,
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder>
        pkixPublicKeyBuilder_;
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return Whether the pkixPublicKey field is set.
     */
    @java.lang.Override
    public boolean hasPkixPublicKey() {
      return publicKeyCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     *
     * @return The pkixPublicKey.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey getPkixPublicKey() {
      if (pkixPublicKeyBuilder_ == null) {
        if (publicKeyCase_ == 5) {
          return (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
      } else {
        if (publicKeyCase_ == 5) {
          return pkixPublicKeyBuilder_.getMessage();
        }
        return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    public Builder setPkixPublicKey(
        com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey value) {
      if (pkixPublicKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicKey_ = value;
        onChanged();
      } else {
        pkixPublicKeyBuilder_.setMessage(value);
      }
      publicKeyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    public Builder setPkixPublicKey(
        com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder builderForValue) {
      if (pkixPublicKeyBuilder_ == null) {
        publicKey_ = builderForValue.build();
        onChanged();
      } else {
        pkixPublicKeyBuilder_.setMessage(builderForValue.build());
      }
      publicKeyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    public Builder mergePkixPublicKey(
        com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey value) {
      if (pkixPublicKeyBuilder_ == null) {
        if (publicKeyCase_ == 5
            && publicKey_
                != com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey
                    .getDefaultInstance()) {
          publicKey_ =
              com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.newBuilder(
                      (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          publicKey_ = value;
        }
        onChanged();
      } else {
        if (publicKeyCase_ == 5) {
          pkixPublicKeyBuilder_.mergeFrom(value);
        } else {
          pkixPublicKeyBuilder_.setMessage(value);
        }
      }
      publicKeyCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    public Builder clearPkixPublicKey() {
      if (pkixPublicKeyBuilder_ == null) {
        if (publicKeyCase_ == 5) {
          publicKeyCase_ = 0;
          publicKey_ = null;
          onChanged();
        }
      } else {
        if (publicKeyCase_ == 5) {
          publicKeyCase_ = 0;
          publicKey_ = null;
        }
        pkixPublicKeyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder
        getPkixPublicKeyBuilder() {
      return getPkixPublicKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder
        getPkixPublicKeyOrBuilder() {
      if ((publicKeyCase_ == 5) && (pkixPublicKeyBuilder_ != null)) {
        return pkixPublicKeyBuilder_.getMessageOrBuilder();
      } else {
        if (publicKeyCase_ == 5) {
          return (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A raw PKIX SubjectPublicKeyInfo format public key.
     *
     * NOTE: `id` may be explicitly provided by the caller when using this
     * type of public key, but it MUST be a valid RFC3986 URI. If `id` is left
     * blank, a default one will be computed based on the digest of the DER
     * encoding of the public key.
     * </pre>
     *
     * <code>.google.cloud.binaryauthorization.v1beta1.PkixPublicKey pkix_public_key = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey,
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder,
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder>
        getPkixPublicKeyFieldBuilder() {
      if (pkixPublicKeyBuilder_ == null) {
        if (!(publicKeyCase_ == 5)) {
          publicKey_ =
              com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
        }
        pkixPublicKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey,
                com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder,
                com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder>(
                (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) publicKey_,
                getParentForChildren(),
                isClean());
        publicKey_ = null;
      }
      publicKeyCase_ = 5;
      onChanged();
      return pkixPublicKeyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.AttestorPublicKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.AttestorPublicKey)
  private static final com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttestorPublicKey> PARSER =
      new com.google.protobuf.AbstractParser<AttestorPublicKey>() {
        @java.lang.Override
        public AttestorPublicKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AttestorPublicKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttestorPublicKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
