/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/continuous_validation_logging.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * Represents an auditing event from Continuous Validation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent}
 */
public final class ContinuousValidationEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent)
    ContinuousValidationEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContinuousValidationEvent.newBuilder() to construct.
  private ContinuousValidationEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContinuousValidationEvent() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContinuousValidationEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.class,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.Builder.class);
  }

  public interface ContinuousValidationPodEventOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The k8s namespace of the Pod.
     * </pre>
     *
     * <code>string pod_namespace = 7;</code>
     *
     * @return The podNamespace.
     */
    java.lang.String getPodNamespace();
    /**
     *
     *
     * <pre>
     * The k8s namespace of the Pod.
     * </pre>
     *
     * <code>string pod_namespace = 7;</code>
     *
     * @return The bytes for podNamespace.
     */
    com.google.protobuf.ByteString getPodNamespaceBytes();

    /**
     *
     *
     * <pre>
     * The name of the Pod.
     * </pre>
     *
     * <code>string pod = 1;</code>
     *
     * @return The pod.
     */
    java.lang.String getPod();
    /**
     *
     *
     * <pre>
     * The name of the Pod.
     * </pre>
     *
     * <code>string pod = 1;</code>
     *
     * @return The bytes for pod.
     */
    com.google.protobuf.ByteString getPodBytes();

    /**
     *
     *
     * <pre>
     * The name of the policy.
     * </pre>
     *
     * <code>string policy_name = 8;</code>
     *
     * @return The policyName.
     */
    java.lang.String getPolicyName();
    /**
     *
     *
     * <pre>
     * The name of the policy.
     * </pre>
     *
     * <code>string policy_name = 8;</code>
     *
     * @return The bytes for policyName.
     */
    com.google.protobuf.ByteString getPolicyNameBytes();

    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     *
     * @return Whether the deployTime field is set.
     */
    boolean hasDeployTime();
    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     *
     * @return The deployTime.
     */
    com.google.protobuf.Timestamp getDeployTime();
    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getDeployTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Auditing verdict for this Pod.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for verdict.
     */
    int getVerdictValue();
    /**
     *
     *
     * <pre>
     * Auditing verdict for this Pod.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
     * </code>
     *
     * @return The verdict.
     */
    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.PolicyConformanceVerdict
        getVerdict();

    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    java.util.List<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails>
        getImagesList();
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.ImageDetails
        getImages(int index);
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    int getImagesCount();
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetailsOrBuilder>
        getImagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.ImageDetailsOrBuilder
        getImagesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * An auditing event for one Pod.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent}
   */
  public static final class ContinuousValidationPodEvent
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent)
      ContinuousValidationPodEventOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ContinuousValidationPodEvent.newBuilder() to construct.
    private ContinuousValidationPodEvent(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContinuousValidationPodEvent() {
      podNamespace_ = "";
      pod_ = "";
      policyName_ = "";
      verdict_ = 0;
      images_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContinuousValidationPodEvent();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.class,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Audit time policy conformance verdict.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict}
     */
    public enum PolicyConformanceVerdict implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * We should always have a verdict. This is an error.
       * </pre>
       *
       * <code>POLICY_CONFORMANCE_VERDICT_UNSPECIFIED = 0;</code>
       */
      POLICY_CONFORMANCE_VERDICT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The pod violates the policy.
       * </pre>
       *
       * <code>VIOLATES_POLICY = 1;</code>
       */
      VIOLATES_POLICY(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * We should always have a verdict. This is an error.
       * </pre>
       *
       * <code>POLICY_CONFORMANCE_VERDICT_UNSPECIFIED = 0;</code>
       */
      public static final int POLICY_CONFORMANCE_VERDICT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The pod violates the policy.
       * </pre>
       *
       * <code>VIOLATES_POLICY = 1;</code>
       */
      public static final int VIOLATES_POLICY_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PolicyConformanceVerdict valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PolicyConformanceVerdict forNumber(int value) {
        switch (value) {
          case 0:
            return POLICY_CONFORMANCE_VERDICT_UNSPECIFIED;
          case 1:
            return VIOLATES_POLICY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PolicyConformanceVerdict>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<PolicyConformanceVerdict>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<PolicyConformanceVerdict>() {
                public PolicyConformanceVerdict findValueByNumber(int number) {
                  return PolicyConformanceVerdict.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final PolicyConformanceVerdict[] VALUES = values();

      public static PolicyConformanceVerdict valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PolicyConformanceVerdict(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict)
    }

    public interface ImageDetailsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The name of the image.
       * </pre>
       *
       * <code>string image = 1;</code>
       *
       * @return The image.
       */
      java.lang.String getImage();
      /**
       *
       *
       * <pre>
       * The name of the image.
       * </pre>
       *
       * <code>string image = 1;</code>
       *
       * @return The bytes for image.
       */
      com.google.protobuf.ByteString getImageBytes();

      /**
       *
       *
       * <pre>
       * The name of the container.
       * </pre>
       *
       * <code>string container_name = 5;</code>
       *
       * @return The containerName.
       */
      java.lang.String getContainerName();
      /**
       *
       *
       * <pre>
       * The name of the container.
       * </pre>
       *
       * <code>string container_name = 5;</code>
       *
       * @return The bytes for containerName.
       */
      com.google.protobuf.ByteString getContainerNameBytes();

      /**
       *
       *
       * <pre>
       * The container type that this image belongs to.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
       * </code>
       *
       * @return The enum numeric value on the wire for containerType.
       */
      int getContainerTypeValue();
      /**
       *
       *
       * <pre>
       * The container type that this image belongs to.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
       * </code>
       *
       * @return The containerType.
       */
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.ContainerType
          getContainerType();

      /**
       *
       *
       * <pre>
       * The result of the audit for this image.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for result.
       */
      int getResultValue();
      /**
       *
       *
       * <pre>
       * The result of the audit for this image.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
       * </code>
       *
       * @return The result.
       */
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.AuditResult
          getResult();

      /**
       *
       *
       * <pre>
       * Description of the above result.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      java.lang.String getDescription();
      /**
       *
       *
       * <pre>
       * Description of the above result.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      com.google.protobuf.ByteString getDescriptionBytes();

      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult>
          getCheckResultsList();
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.CheckResult
          getCheckResults(int index);
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      int getCheckResultsCount();
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>
          getCheckResultsOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder
          getCheckResultsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Container image with auditing details.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails}
     */
    public static final class ImageDetails extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails)
        ImageDetailsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ImageDetails.newBuilder() to construct.
      private ImageDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ImageDetails() {
        image_ = "";
        containerName_ = "";
        containerType_ = 0;
        result_ = 0;
        description_ = "";
        checkResults_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ImageDetails();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.class,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The container type.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType}
       */
      public enum ContainerType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * The container type should always be specified. This is an error.
         * </pre>
         *
         * <code>CONTAINER_TYPE_UNSPECIFIED = 0;</code>
         */
        CONTAINER_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * A regular deployment.
         * </pre>
         *
         * <code>CONTAINER = 1;</code>
         */
        CONTAINER(1),
        /**
         *
         *
         * <pre>
         * Init container defined as specified at
         * https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
         * </pre>
         *
         * <code>INIT_CONTAINER = 2;</code>
         */
        INIT_CONTAINER(2),
        /**
         *
         *
         * <pre>
         * Ephemeral container defined as specified at
         * https://kubernetes.io/docs/concepts/workloads/pods/ephemeral-containers/
         * </pre>
         *
         * <code>EPHEMERAL_CONTAINER = 3;</code>
         */
        EPHEMERAL_CONTAINER(3),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * The container type should always be specified. This is an error.
         * </pre>
         *
         * <code>CONTAINER_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int CONTAINER_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * A regular deployment.
         * </pre>
         *
         * <code>CONTAINER = 1;</code>
         */
        public static final int CONTAINER_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Init container defined as specified at
         * https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
         * </pre>
         *
         * <code>INIT_CONTAINER = 2;</code>
         */
        public static final int INIT_CONTAINER_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Ephemeral container defined as specified at
         * https://kubernetes.io/docs/concepts/workloads/pods/ephemeral-containers/
         * </pre>
         *
         * <code>EPHEMERAL_CONTAINER = 3;</code>
         */
        public static final int EPHEMERAL_CONTAINER_VALUE = 3;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ContainerType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ContainerType forNumber(int value) {
          switch (value) {
            case 0:
              return CONTAINER_TYPE_UNSPECIFIED;
            case 1:
              return CONTAINER;
            case 2:
              return INIT_CONTAINER;
            case 3:
              return EPHEMERAL_CONTAINER;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ContainerType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ContainerType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ContainerType>() {
                  public ContainerType findValueByNumber(int number) {
                    return ContainerType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ContainerType[] VALUES = values();

        public static ContainerType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ContainerType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType)
      }

      /**
       *
       *
       * <pre>
       * Result of the audit.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult}
       */
      public enum AuditResult implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified result. This is an error.
         * </pre>
         *
         * <code>AUDIT_RESULT_UNSPECIFIED = 0;</code>
         */
        AUDIT_RESULT_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Image is allowed.
         * </pre>
         *
         * <code>ALLOW = 1;</code>
         */
        ALLOW(1),
        /**
         *
         *
         * <pre>
         * Image is denied.
         * </pre>
         *
         * <code>DENY = 2;</code>
         */
        DENY(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified result. This is an error.
         * </pre>
         *
         * <code>AUDIT_RESULT_UNSPECIFIED = 0;</code>
         */
        public static final int AUDIT_RESULT_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Image is allowed.
         * </pre>
         *
         * <code>ALLOW = 1;</code>
         */
        public static final int ALLOW_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Image is denied.
         * </pre>
         *
         * <code>DENY = 2;</code>
         */
        public static final int DENY_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static AuditResult valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static AuditResult forNumber(int value) {
          switch (value) {
            case 0:
              return AUDIT_RESULT_UNSPECIFIED;
            case 1:
              return ALLOW;
            case 2:
              return DENY;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<AuditResult> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<AuditResult>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<AuditResult>() {
                  public AuditResult findValueByNumber(int number) {
                    return AuditResult.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.getDescriptor()
              .getEnumTypes()
              .get(1);
        }

        private static final AuditResult[] VALUES = values();

        public static AuditResult valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private AuditResult(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult)
      }

      public interface CheckResultOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The index of the check set.
         * </pre>
         *
         * <code>string check_set_index = 1;</code>
         *
         * @return The checkSetIndex.
         */
        java.lang.String getCheckSetIndex();
        /**
         *
         *
         * <pre>
         * The index of the check set.
         * </pre>
         *
         * <code>string check_set_index = 1;</code>
         *
         * @return The bytes for checkSetIndex.
         */
        com.google.protobuf.ByteString getCheckSetIndexBytes();

        /**
         *
         *
         * <pre>
         * The name of the check set.
         * </pre>
         *
         * <code>string check_set_name = 2;</code>
         *
         * @return The checkSetName.
         */
        java.lang.String getCheckSetName();
        /**
         *
         *
         * <pre>
         * The name of the check set.
         * </pre>
         *
         * <code>string check_set_name = 2;</code>
         *
         * @return The bytes for checkSetName.
         */
        com.google.protobuf.ByteString getCheckSetNameBytes();

        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         *
         * @return Whether the checkSetScope field is set.
         */
        boolean hasCheckSetScope();
        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         *
         * @return The checkSetScope.
         */
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
            getCheckSetScope();
        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         */
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder
            getCheckSetScopeOrBuilder();

        /**
         *
         *
         * <pre>
         * The index of the check.
         * </pre>
         *
         * <code>string check_index = 4;</code>
         *
         * @return The checkIndex.
         */
        java.lang.String getCheckIndex();
        /**
         *
         *
         * <pre>
         * The index of the check.
         * </pre>
         *
         * <code>string check_index = 4;</code>
         *
         * @return The bytes for checkIndex.
         */
        com.google.protobuf.ByteString getCheckIndexBytes();

        /**
         *
         *
         * <pre>
         * The name of the check.
         * </pre>
         *
         * <code>string check_name = 5;</code>
         *
         * @return The checkName.
         */
        java.lang.String getCheckName();
        /**
         *
         *
         * <pre>
         * The name of the check.
         * </pre>
         *
         * <code>string check_name = 5;</code>
         *
         * @return The bytes for checkName.
         */
        com.google.protobuf.ByteString getCheckNameBytes();

        /**
         *
         *
         * <pre>
         * The type of the check.
         * </pre>
         *
         * <code>string check_type = 6;</code>
         *
         * @return The checkType.
         */
        java.lang.String getCheckType();
        /**
         *
         *
         * <pre>
         * The type of the check.
         * </pre>
         *
         * <code>string check_type = 6;</code>
         *
         * @return The bytes for checkType.
         */
        com.google.protobuf.ByteString getCheckTypeBytes();

        /**
         *
         *
         * <pre>
         * The verdict of this check.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
         * </code>
         *
         * @return The enum numeric value on the wire for verdict.
         */
        int getVerdictValue();
        /**
         *
         *
         * <pre>
         * The verdict of this check.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
         * </code>
         *
         * @return The verdict.
         */
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
            getVerdict();

        /**
         *
         *
         * <pre>
         * User-friendly explanation of this check result.
         * </pre>
         *
         * <code>string explanation = 8;</code>
         *
         * @return The explanation.
         */
        java.lang.String getExplanation();
        /**
         *
         *
         * <pre>
         * User-friendly explanation of this check result.
         * </pre>
         *
         * <code>string explanation = 8;</code>
         *
         * @return The bytes for explanation.
         */
        com.google.protobuf.ByteString getExplanationBytes();
      }
      /**
       * Protobuf type {@code
       * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult}
       */
      public static final class CheckResult extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult)
          CheckResultOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use CheckResult.newBuilder() to construct.
        private CheckResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private CheckResult() {
          checkSetIndex_ = "";
          checkSetName_ = "";
          checkIndex_ = "";
          checkName_ = "";
          checkType_ = "";
          verdict_ = 0;
          explanation_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new CheckResult();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
              .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
              .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.class,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * Result of evaluating one check.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict}
         */
        public enum CheckVerdict implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * We should always have a verdict. This is an error.
           * </pre>
           *
           * <code>CHECK_VERDICT_UNSPECIFIED = 0;</code>
           */
          CHECK_VERDICT_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * The check was successfully evaluated and the image did not satisfy
           * the check.
           * </pre>
           *
           * <code>NON_CONFORMANT = 1;</code>
           */
          NON_CONFORMANT(1),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * We should always have a verdict. This is an error.
           * </pre>
           *
           * <code>CHECK_VERDICT_UNSPECIFIED = 0;</code>
           */
          public static final int CHECK_VERDICT_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * The check was successfully evaluated and the image did not satisfy
           * the check.
           * </pre>
           *
           * <code>NON_CONFORMANT = 1;</code>
           */
          public static final int NON_CONFORMANT_VALUE = 1;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static CheckVerdict valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static CheckVerdict forNumber(int value) {
            switch (value) {
              case 0:
                return CHECK_VERDICT_UNSPECIFIED;
              case 1:
                return NON_CONFORMANT;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<CheckVerdict>
              internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<CheckVerdict>
              internalValueMap =
                  new com.google.protobuf.Internal.EnumLiteMap<CheckVerdict>() {
                    public CheckVerdict findValueByNumber(int number) {
                      return CheckVerdict.forNumber(number);
                    }
                  };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final CheckVerdict[] VALUES = values();

          public static CheckVerdict valueOf(
              com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private CheckVerdict(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict)
        }

        public interface CheckSetScopeOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return Whether the kubernetesServiceAccount field is set.
           */
          boolean hasKubernetesServiceAccount();
          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return The kubernetesServiceAccount.
           */
          java.lang.String getKubernetesServiceAccount();
          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return The bytes for kubernetesServiceAccount.
           */
          com.google.protobuf.ByteString getKubernetesServiceAccountBytes();

          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return Whether the kubernetesNamespace field is set.
           */
          boolean hasKubernetesNamespace();
          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return The kubernetesNamespace.
           */
          java.lang.String getKubernetesNamespace();
          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return The bytes for kubernetesNamespace.
           */
          com.google.protobuf.ByteString getKubernetesNamespaceBytes();

          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.ScopeCase
              getScopeCase();
        }
        /**
         *
         *
         * <pre>
         * A scope specifier for check sets.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope}
         */
        public static final class CheckSetScope extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
            CheckSetScopeOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use CheckSetScope.newBuilder() to construct.
          private CheckSetScope(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private CheckSetScope() {}

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new CheckSetScope();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_CheckSetScope_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_CheckSetScope_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.class,
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.Builder
                        .class);
          }

          private int scopeCase_ = 0;

          @SuppressWarnings("serial")
          private java.lang.Object scope_;

          public enum ScopeCase
              implements
                  com.google.protobuf.Internal.EnumLite,
                  com.google.protobuf.AbstractMessage.InternalOneOfEnum {
            KUBERNETES_SERVICE_ACCOUNT(1),
            KUBERNETES_NAMESPACE(2),
            SCOPE_NOT_SET(0);
            private final int value;

            private ScopeCase(int value) {
              this.value = value;
            }
            /**
             * @param value The number of the enum to look for.
             * @return The enum associated with the given number.
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static ScopeCase valueOf(int value) {
              return forNumber(value);
            }

            public static ScopeCase forNumber(int value) {
              switch (value) {
                case 1:
                  return KUBERNETES_SERVICE_ACCOUNT;
                case 2:
                  return KUBERNETES_NAMESPACE;
                case 0:
                  return SCOPE_NOT_SET;
                default:
                  return null;
              }
            }

            public int getNumber() {
              return this.value;
            }
          };

          public ScopeCase getScopeCase() {
            return ScopeCase.forNumber(scopeCase_);
          }

          public static final int KUBERNETES_SERVICE_ACCOUNT_FIELD_NUMBER = 1;
          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return Whether the kubernetesServiceAccount field is set.
           */
          public boolean hasKubernetesServiceAccount() {
            return scopeCase_ == 1;
          }
          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return The kubernetesServiceAccount.
           */
          public java.lang.String getKubernetesServiceAccount() {
            java.lang.Object ref = "";
            if (scopeCase_ == 1) {
              ref = scope_;
            }
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (scopeCase_ == 1) {
                scope_ = s;
              }
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Matches a single Kubernetes service account, e.g.
           * 'my-namespace:my-service-account'.
           * `kubernetes_service_account` scope is always more specific than
           * `kubernetes_namespace` scope for the same namespace.
           * </pre>
           *
           * <code>string kubernetes_service_account = 1;</code>
           *
           * @return The bytes for kubernetesServiceAccount.
           */
          public com.google.protobuf.ByteString getKubernetesServiceAccountBytes() {
            java.lang.Object ref = "";
            if (scopeCase_ == 1) {
              ref = scope_;
            }
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              if (scopeCase_ == 1) {
                scope_ = b;
              }
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int KUBERNETES_NAMESPACE_FIELD_NUMBER = 2;
          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return Whether the kubernetesNamespace field is set.
           */
          public boolean hasKubernetesNamespace() {
            return scopeCase_ == 2;
          }
          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return The kubernetesNamespace.
           */
          public java.lang.String getKubernetesNamespace() {
            java.lang.Object ref = "";
            if (scopeCase_ == 2) {
              ref = scope_;
            }
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (scopeCase_ == 2) {
                scope_ = s;
              }
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Matches all Kubernetes service accounts in the provided
           * namespace, unless a more specific `kubernetes_service_account`
           * scope already matched.
           * </pre>
           *
           * <code>string kubernetes_namespace = 2;</code>
           *
           * @return The bytes for kubernetesNamespace.
           */
          public com.google.protobuf.ByteString getKubernetesNamespaceBytes() {
            java.lang.Object ref = "";
            if (scopeCase_ == 2) {
              ref = scope_;
            }
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              if (scopeCase_ == 2) {
                scope_ = b;
              }
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (scopeCase_ == 1) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
            }
            if (scopeCase_ == 2) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 2, scope_);
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (scopeCase_ == 1) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
            }
            if (scopeCase_ == 2) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, scope_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)) {
              return super.equals(obj);
            }
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                other =
                    (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                            .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
                        obj;

            if (!getScopeCase().equals(other.getScopeCase())) return false;
            switch (scopeCase_) {
              case 1:
                if (!getKubernetesServiceAccount().equals(other.getKubernetesServiceAccount()))
                  return false;
                break;
              case 2:
                if (!getKubernetesNamespace().equals(other.getKubernetesNamespace())) return false;
                break;
              case 0:
              default:
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            switch (scopeCase_) {
              case 1:
                hash = (37 * hash) + KUBERNETES_SERVICE_ACCOUNT_FIELD_NUMBER;
                hash = (53 * hash) + getKubernetesServiceAccount().hashCode();
                break;
              case 2:
                hash = (37 * hash) + KUBERNETES_NAMESPACE_FIELD_NUMBER;
                hash = (53 * hash) + getKubernetesNamespace().hashCode();
                break;
              case 0:
              default:
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * A scope specifier for check sets.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                  .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_CheckSetScope_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                  .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_CheckSetScope_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                          .class,
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                          .Builder.class);
            }

            // Construct using
            // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.newBuilder()
            private Builder() {}

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              scopeCase_ = 0;
              scope_ = null;
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                  .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_CheckSetScope_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                getDefaultInstanceForType() {
              return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  .getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                build() {
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                buildPartial() {
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  result =
                      new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope(
                          this);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              buildPartialOneofs(result);
              onBuilt();
              return result;
            }

            private void buildPartial0(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                    result) {
              int from_bitField0_ = bitField0_;
            }

            private void buildPartialOneofs(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                    result) {
              result.scopeCase_ = scopeCase_;
              result.scope_ = this.scope_;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope) {
                return mergeFrom(
                    (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                            .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                    other) {
              if (other
                  == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                      .getDefaultInstance()) return this;
              switch (other.getScopeCase()) {
                case KUBERNETES_SERVICE_ACCOUNT:
                  {
                    scopeCase_ = 1;
                    scope_ = other.scope_;
                    onChanged();
                    break;
                  }
                case KUBERNETES_NAMESPACE:
                  {
                    scopeCase_ = 2;
                    scope_ = other.scope_;
                    onChanged();
                    break;
                  }
                case SCOPE_NOT_SET:
                  {
                    break;
                  }
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        java.lang.String s = input.readStringRequireUtf8();
                        scopeCase_ = 1;
                        scope_ = s;
                        break;
                      } // case 10
                    case 18:
                      {
                        java.lang.String s = input.readStringRequireUtf8();
                        scopeCase_ = 2;
                        scope_ = s;
                        break;
                      } // case 18
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int scopeCase_ = 0;
            private java.lang.Object scope_;

            public ScopeCase getScopeCase() {
              return ScopeCase.forNumber(scopeCase_);
            }

            public Builder clearScope() {
              scopeCase_ = 0;
              scope_ = null;
              onChanged();
              return this;
            }

            private int bitField0_;

            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @return Whether the kubernetesServiceAccount field is set.
             */
            @java.lang.Override
            public boolean hasKubernetesServiceAccount() {
              return scopeCase_ == 1;
            }
            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @return The kubernetesServiceAccount.
             */
            @java.lang.Override
            public java.lang.String getKubernetesServiceAccount() {
              java.lang.Object ref = "";
              if (scopeCase_ == 1) {
                ref = scope_;
              }
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                if (scopeCase_ == 1) {
                  scope_ = s;
                }
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @return The bytes for kubernetesServiceAccount.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getKubernetesServiceAccountBytes() {
              java.lang.Object ref = "";
              if (scopeCase_ == 1) {
                ref = scope_;
              }
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                if (scopeCase_ == 1) {
                  scope_ = b;
                }
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @param value The kubernetesServiceAccount to set.
             * @return This builder for chaining.
             */
            public Builder setKubernetesServiceAccount(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              scopeCase_ = 1;
              scope_ = value;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearKubernetesServiceAccount() {
              if (scopeCase_ == 1) {
                scopeCase_ = 0;
                scope_ = null;
                onChanged();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Matches a single Kubernetes service account, e.g.
             * 'my-namespace:my-service-account'.
             * `kubernetes_service_account` scope is always more specific than
             * `kubernetes_namespace` scope for the same namespace.
             * </pre>
             *
             * <code>string kubernetes_service_account = 1;</code>
             *
             * @param value The bytes for kubernetesServiceAccount to set.
             * @return This builder for chaining.
             */
            public Builder setKubernetesServiceAccountBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              scopeCase_ = 1;
              scope_ = value;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @return Whether the kubernetesNamespace field is set.
             */
            @java.lang.Override
            public boolean hasKubernetesNamespace() {
              return scopeCase_ == 2;
            }
            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @return The kubernetesNamespace.
             */
            @java.lang.Override
            public java.lang.String getKubernetesNamespace() {
              java.lang.Object ref = "";
              if (scopeCase_ == 2) {
                ref = scope_;
              }
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                if (scopeCase_ == 2) {
                  scope_ = s;
                }
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @return The bytes for kubernetesNamespace.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getKubernetesNamespaceBytes() {
              java.lang.Object ref = "";
              if (scopeCase_ == 2) {
                ref = scope_;
              }
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                if (scopeCase_ == 2) {
                  scope_ = b;
                }
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @param value The kubernetesNamespace to set.
             * @return This builder for chaining.
             */
            public Builder setKubernetesNamespace(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              scopeCase_ = 2;
              scope_ = value;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearKubernetesNamespace() {
              if (scopeCase_ == 2) {
                scopeCase_ = 0;
                scope_ = null;
                onChanged();
              }
              return this;
            }
            /**
             *
             *
             * <pre>
             * Matches all Kubernetes service accounts in the provided
             * namespace, unless a more specific `kubernetes_service_account`
             * scope already matched.
             * </pre>
             *
             * <code>string kubernetes_namespace = 2;</code>
             *
             * @param value The bytes for kubernetesNamespace to set.
             * @return This builder for chaining.
             */
            public Builder setKubernetesNamespaceBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              scopeCase_ = 2;
              scope_ = value;
              onChanged();
              return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope)
          private static final com.google.cloud.binaryauthorization.v1beta1
                  .ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult
                  .CheckSetScope
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope();
          }

          public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<CheckSetScope> PARSER =
              new com.google.protobuf.AbstractParser<CheckSetScope>() {
                @java.lang.Override
                public CheckSetScope parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<CheckSetScope> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<CheckSetScope> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        public static final int CHECK_SET_INDEX_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object checkSetIndex_ = "";
        /**
         *
         *
         * <pre>
         * The index of the check set.
         * </pre>
         *
         * <code>string check_set_index = 1;</code>
         *
         * @return The checkSetIndex.
         */
        @java.lang.Override
        public java.lang.String getCheckSetIndex() {
          java.lang.Object ref = checkSetIndex_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            checkSetIndex_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The index of the check set.
         * </pre>
         *
         * <code>string check_set_index = 1;</code>
         *
         * @return The bytes for checkSetIndex.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCheckSetIndexBytes() {
          java.lang.Object ref = checkSetIndex_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            checkSetIndex_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int CHECK_SET_NAME_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object checkSetName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the check set.
         * </pre>
         *
         * <code>string check_set_name = 2;</code>
         *
         * @return The checkSetName.
         */
        @java.lang.Override
        public java.lang.String getCheckSetName() {
          java.lang.Object ref = checkSetName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            checkSetName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the check set.
         * </pre>
         *
         * <code>string check_set_name = 2;</code>
         *
         * @return The bytes for checkSetName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCheckSetNameBytes() {
          java.lang.Object ref = checkSetName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            checkSetName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int CHECK_SET_SCOPE_FIELD_NUMBER = 3;
        private com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
            checkSetScope_;
        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         *
         * @return Whether the checkSetScope field is set.
         */
        @java.lang.Override
        public boolean hasCheckSetScope() {
          return checkSetScope_ != null;
        }
        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         *
         * @return The checkSetScope.
         */
        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
            getCheckSetScope() {
          return checkSetScope_ == null
              ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  .getDefaultInstance()
              : checkSetScope_;
        }
        /**
         *
         *
         * <pre>
         * The scope of the check set.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder
            getCheckSetScopeOrBuilder() {
          return checkSetScope_ == null
              ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  .getDefaultInstance()
              : checkSetScope_;
        }

        public static final int CHECK_INDEX_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private volatile java.lang.Object checkIndex_ = "";
        /**
         *
         *
         * <pre>
         * The index of the check.
         * </pre>
         *
         * <code>string check_index = 4;</code>
         *
         * @return The checkIndex.
         */
        @java.lang.Override
        public java.lang.String getCheckIndex() {
          java.lang.Object ref = checkIndex_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            checkIndex_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The index of the check.
         * </pre>
         *
         * <code>string check_index = 4;</code>
         *
         * @return The bytes for checkIndex.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCheckIndexBytes() {
          java.lang.Object ref = checkIndex_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            checkIndex_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int CHECK_NAME_FIELD_NUMBER = 5;

        @SuppressWarnings("serial")
        private volatile java.lang.Object checkName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the check.
         * </pre>
         *
         * <code>string check_name = 5;</code>
         *
         * @return The checkName.
         */
        @java.lang.Override
        public java.lang.String getCheckName() {
          java.lang.Object ref = checkName_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            checkName_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the check.
         * </pre>
         *
         * <code>string check_name = 5;</code>
         *
         * @return The bytes for checkName.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCheckNameBytes() {
          java.lang.Object ref = checkName_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            checkName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int CHECK_TYPE_FIELD_NUMBER = 6;

        @SuppressWarnings("serial")
        private volatile java.lang.Object checkType_ = "";
        /**
         *
         *
         * <pre>
         * The type of the check.
         * </pre>
         *
         * <code>string check_type = 6;</code>
         *
         * @return The checkType.
         */
        @java.lang.Override
        public java.lang.String getCheckType() {
          java.lang.Object ref = checkType_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            checkType_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The type of the check.
         * </pre>
         *
         * <code>string check_type = 6;</code>
         *
         * @return The bytes for checkType.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getCheckTypeBytes() {
          java.lang.Object ref = checkType_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            checkType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int VERDICT_FIELD_NUMBER = 7;
        private int verdict_ = 0;
        /**
         *
         *
         * <pre>
         * The verdict of this check.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
         * </code>
         *
         * @return The enum numeric value on the wire for verdict.
         */
        @java.lang.Override
        public int getVerdictValue() {
          return verdict_;
        }
        /**
         *
         *
         * <pre>
         * The verdict of this check.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
         * </code>
         *
         * @return The verdict.
         */
        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
            getVerdict() {
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
              result =
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict.forNumber(
                      verdict_);
          return result == null
              ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict.UNRECOGNIZED
              : result;
        }

        public static final int EXPLANATION_FIELD_NUMBER = 8;

        @SuppressWarnings("serial")
        private volatile java.lang.Object explanation_ = "";
        /**
         *
         *
         * <pre>
         * User-friendly explanation of this check result.
         * </pre>
         *
         * <code>string explanation = 8;</code>
         *
         * @return The explanation.
         */
        @java.lang.Override
        public java.lang.String getExplanation() {
          java.lang.Object ref = explanation_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            explanation_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * User-friendly explanation of this check result.
         * </pre>
         *
         * <code>string explanation = 8;</code>
         *
         * @return The bytes for explanation.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getExplanationBytes() {
          java.lang.Object ref = explanation_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            explanation_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkSetIndex_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, checkSetIndex_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkSetName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, checkSetName_);
          }
          if (checkSetScope_ != null) {
            output.writeMessage(3, getCheckSetScope());
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkIndex_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, checkIndex_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkName_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 5, checkName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkType_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 6, checkType_);
          }
          if (verdict_
              != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
                  .CHECK_VERDICT_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(7, verdict_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanation_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 8, explanation_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkSetIndex_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, checkSetIndex_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkSetName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, checkSetName_);
          }
          if (checkSetScope_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCheckSetScope());
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkIndex_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, checkIndex_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkName_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, checkName_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(checkType_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, checkType_);
          }
          if (verdict_
              != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
                  .CHECK_VERDICT_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, verdict_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(explanation_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, explanation_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult)) {
            return super.equals(obj);
          }
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult
              other =
                  (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult)
                      obj;

          if (!getCheckSetIndex().equals(other.getCheckSetIndex())) return false;
          if (!getCheckSetName().equals(other.getCheckSetName())) return false;
          if (hasCheckSetScope() != other.hasCheckSetScope()) return false;
          if (hasCheckSetScope()) {
            if (!getCheckSetScope().equals(other.getCheckSetScope())) return false;
          }
          if (!getCheckIndex().equals(other.getCheckIndex())) return false;
          if (!getCheckName().equals(other.getCheckName())) return false;
          if (!getCheckType().equals(other.getCheckType())) return false;
          if (verdict_ != other.verdict_) return false;
          if (!getExplanation().equals(other.getExplanation())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + CHECK_SET_INDEX_FIELD_NUMBER;
          hash = (53 * hash) + getCheckSetIndex().hashCode();
          hash = (37 * hash) + CHECK_SET_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getCheckSetName().hashCode();
          if (hasCheckSetScope()) {
            hash = (37 * hash) + CHECK_SET_SCOPE_FIELD_NUMBER;
            hash = (53 * hash) + getCheckSetScope().hashCode();
          }
          hash = (37 * hash) + CHECK_INDEX_FIELD_NUMBER;
          hash = (53 * hash) + getCheckIndex().hashCode();
          hash = (37 * hash) + CHECK_NAME_FIELD_NUMBER;
          hash = (53 * hash) + getCheckName().hashCode();
          hash = (37 * hash) + CHECK_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getCheckType().hashCode();
          hash = (37 * hash) + VERDICT_FIELD_NUMBER;
          hash = (53 * hash) + verdict_;
          hash = (37 * hash) + EXPLANATION_FIELD_NUMBER;
          hash = (53 * hash) + getExplanation().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * Protobuf type {@code
         * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult)
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.class,
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder.class);
          }

          // Construct using
          // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            checkSetIndex_ = "";
            checkSetName_ = "";
            checkSetScope_ = null;
            if (checkSetScopeBuilder_ != null) {
              checkSetScopeBuilder_.dispose();
              checkSetScopeBuilder_ = null;
            }
            checkIndex_ = "";
            checkName_ = "";
            checkType_ = "";
            verdict_ = 0;
            explanation_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
                .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_CheckResult_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult
              getDefaultInstanceForType() {
            return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult
              build() {
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult
              buildPartial() {
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                result =
                    new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.checkSetIndex_ = checkSetIndex_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.checkSetName_ = checkSetName_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.checkSetScope_ =
                  checkSetScopeBuilder_ == null ? checkSetScope_ : checkSetScopeBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.checkIndex_ = checkIndex_;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.checkName_ = checkName_;
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.checkType_ = checkType_;
            }
            if (((from_bitField0_ & 0x00000040) != 0)) {
              result.verdict_ = verdict_;
            }
            if (((from_bitField0_ & 0x00000080) != 0)) {
              result.explanation_ = explanation_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult) {
              return mergeFrom(
                  (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult
                  other) {
            if (other
                == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.getDefaultInstance())
              return this;
            if (!other.getCheckSetIndex().isEmpty()) {
              checkSetIndex_ = other.checkSetIndex_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getCheckSetName().isEmpty()) {
              checkSetName_ = other.checkSetName_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (other.hasCheckSetScope()) {
              mergeCheckSetScope(other.getCheckSetScope());
            }
            if (!other.getCheckIndex().isEmpty()) {
              checkIndex_ = other.checkIndex_;
              bitField0_ |= 0x00000008;
              onChanged();
            }
            if (!other.getCheckName().isEmpty()) {
              checkName_ = other.checkName_;
              bitField0_ |= 0x00000010;
              onChanged();
            }
            if (!other.getCheckType().isEmpty()) {
              checkType_ = other.checkType_;
              bitField0_ |= 0x00000020;
              onChanged();
            }
            if (other.verdict_ != 0) {
              setVerdictValue(other.getVerdictValue());
            }
            if (!other.getExplanation().isEmpty()) {
              explanation_ = other.explanation_;
              bitField0_ |= 0x00000080;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      checkSetIndex_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      checkSetName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      input.readMessage(
                          getCheckSetScopeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 34:
                    {
                      checkIndex_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 34
                  case 42:
                    {
                      checkName_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 42
                  case 50:
                    {
                      checkType_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000020;
                      break;
                    } // case 50
                  case 56:
                    {
                      verdict_ = input.readEnum();
                      bitField0_ |= 0x00000040;
                      break;
                    } // case 56
                  case 66:
                    {
                      explanation_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000080;
                      break;
                    } // case 66
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object checkSetIndex_ = "";
          /**
           *
           *
           * <pre>
           * The index of the check set.
           * </pre>
           *
           * <code>string check_set_index = 1;</code>
           *
           * @return The checkSetIndex.
           */
          public java.lang.String getCheckSetIndex() {
            java.lang.Object ref = checkSetIndex_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              checkSetIndex_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The index of the check set.
           * </pre>
           *
           * <code>string check_set_index = 1;</code>
           *
           * @return The bytes for checkSetIndex.
           */
          public com.google.protobuf.ByteString getCheckSetIndexBytes() {
            java.lang.Object ref = checkSetIndex_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              checkSetIndex_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The index of the check set.
           * </pre>
           *
           * <code>string check_set_index = 1;</code>
           *
           * @param value The checkSetIndex to set.
           * @return This builder for chaining.
           */
          public Builder setCheckSetIndex(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkSetIndex_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The index of the check set.
           * </pre>
           *
           * <code>string check_set_index = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearCheckSetIndex() {
            checkSetIndex_ = getDefaultInstance().getCheckSetIndex();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The index of the check set.
           * </pre>
           *
           * <code>string check_set_index = 1;</code>
           *
           * @param value The bytes for checkSetIndex to set.
           * @return This builder for chaining.
           */
          public Builder setCheckSetIndexBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            checkSetIndex_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object checkSetName_ = "";
          /**
           *
           *
           * <pre>
           * The name of the check set.
           * </pre>
           *
           * <code>string check_set_name = 2;</code>
           *
           * @return The checkSetName.
           */
          public java.lang.String getCheckSetName() {
            java.lang.Object ref = checkSetName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              checkSetName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the check set.
           * </pre>
           *
           * <code>string check_set_name = 2;</code>
           *
           * @return The bytes for checkSetName.
           */
          public com.google.protobuf.ByteString getCheckSetNameBytes() {
            java.lang.Object ref = checkSetName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              checkSetName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the check set.
           * </pre>
           *
           * <code>string check_set_name = 2;</code>
           *
           * @param value The checkSetName to set.
           * @return This builder for chaining.
           */
          public Builder setCheckSetName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkSetName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the check set.
           * </pre>
           *
           * <code>string check_set_name = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearCheckSetName() {
            checkSetName_ = getDefaultInstance().getCheckSetName();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the check set.
           * </pre>
           *
           * <code>string check_set_name = 2;</code>
           *
           * @param value The bytes for checkSetName to set.
           * @return This builder for chaining.
           */
          public Builder setCheckSetNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            checkSetName_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              checkSetScope_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.Builder,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder>
              checkSetScopeBuilder_;
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           *
           * @return Whether the checkSetScope field is set.
           */
          public boolean hasCheckSetScope() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           *
           * @return The checkSetScope.
           */
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
              getCheckSetScope() {
            if (checkSetScopeBuilder_ == null) {
              return checkSetScope_ == null
                  ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                      .getDefaultInstance()
                  : checkSetScope_;
            } else {
              return checkSetScopeBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public Builder setCheckSetScope(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  value) {
            if (checkSetScopeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkSetScope_ = value;
            } else {
              checkSetScopeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public Builder setCheckSetScope(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.Builder
                  builderForValue) {
            if (checkSetScopeBuilder_ == null) {
              checkSetScope_ = builderForValue.build();
            } else {
              checkSetScopeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public Builder mergeCheckSetScope(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                  value) {
            if (checkSetScopeBuilder_ == null) {
              if (((bitField0_ & 0x00000004) != 0)
                  && checkSetScope_ != null
                  && checkSetScope_
                      != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                          .getDefaultInstance()) {
                getCheckSetScopeBuilder().mergeFrom(value);
              } else {
                checkSetScope_ = value;
              }
            } else {
              checkSetScopeBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public Builder clearCheckSetScope() {
            bitField0_ = (bitField0_ & ~0x00000004);
            checkSetScope_ = null;
            if (checkSetScopeBuilder_ != null) {
              checkSetScopeBuilder_.dispose();
              checkSetScopeBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.Builder
              getCheckSetScopeBuilder() {
            bitField0_ |= 0x00000004;
            onChanged();
            return getCheckSetScopeFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder
              getCheckSetScopeOrBuilder() {
            if (checkSetScopeBuilder_ != null) {
              return checkSetScopeBuilder_.getMessageOrBuilder();
            } else {
              return checkSetScope_ == null
                  ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                      .getDefaultInstance()
                  : checkSetScope_;
            }
          }
          /**
           *
           *
           * <pre>
           * The scope of the check set.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope check_set_scope = 3;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope.Builder,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScopeOrBuilder>
              getCheckSetScopeFieldBuilder() {
            if (checkSetScopeBuilder_ == null) {
              checkSetScopeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope,
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckSetScope
                          .Builder,
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails.CheckResult
                          .CheckSetScopeOrBuilder>(
                      getCheckSetScope(), getParentForChildren(), isClean());
              checkSetScope_ = null;
            }
            return checkSetScopeBuilder_;
          }

          private java.lang.Object checkIndex_ = "";
          /**
           *
           *
           * <pre>
           * The index of the check.
           * </pre>
           *
           * <code>string check_index = 4;</code>
           *
           * @return The checkIndex.
           */
          public java.lang.String getCheckIndex() {
            java.lang.Object ref = checkIndex_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              checkIndex_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The index of the check.
           * </pre>
           *
           * <code>string check_index = 4;</code>
           *
           * @return The bytes for checkIndex.
           */
          public com.google.protobuf.ByteString getCheckIndexBytes() {
            java.lang.Object ref = checkIndex_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              checkIndex_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The index of the check.
           * </pre>
           *
           * <code>string check_index = 4;</code>
           *
           * @param value The checkIndex to set.
           * @return This builder for chaining.
           */
          public Builder setCheckIndex(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkIndex_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The index of the check.
           * </pre>
           *
           * <code>string check_index = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearCheckIndex() {
            checkIndex_ = getDefaultInstance().getCheckIndex();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The index of the check.
           * </pre>
           *
           * <code>string check_index = 4;</code>
           *
           * @param value The bytes for checkIndex to set.
           * @return This builder for chaining.
           */
          public Builder setCheckIndexBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            checkIndex_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          private java.lang.Object checkName_ = "";
          /**
           *
           *
           * <pre>
           * The name of the check.
           * </pre>
           *
           * <code>string check_name = 5;</code>
           *
           * @return The checkName.
           */
          public java.lang.String getCheckName() {
            java.lang.Object ref = checkName_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              checkName_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the check.
           * </pre>
           *
           * <code>string check_name = 5;</code>
           *
           * @return The bytes for checkName.
           */
          public com.google.protobuf.ByteString getCheckNameBytes() {
            java.lang.Object ref = checkName_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              checkName_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The name of the check.
           * </pre>
           *
           * <code>string check_name = 5;</code>
           *
           * @param value The checkName to set.
           * @return This builder for chaining.
           */
          public Builder setCheckName(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkName_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the check.
           * </pre>
           *
           * <code>string check_name = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearCheckName() {
            checkName_ = getDefaultInstance().getCheckName();
            bitField0_ = (bitField0_ & ~0x00000010);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The name of the check.
           * </pre>
           *
           * <code>string check_name = 5;</code>
           *
           * @param value The bytes for checkName to set.
           * @return This builder for chaining.
           */
          public Builder setCheckNameBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            checkName_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          private java.lang.Object checkType_ = "";
          /**
           *
           *
           * <pre>
           * The type of the check.
           * </pre>
           *
           * <code>string check_type = 6;</code>
           *
           * @return The checkType.
           */
          public java.lang.String getCheckType() {
            java.lang.Object ref = checkType_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              checkType_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The type of the check.
           * </pre>
           *
           * <code>string check_type = 6;</code>
           *
           * @return The bytes for checkType.
           */
          public com.google.protobuf.ByteString getCheckTypeBytes() {
            java.lang.Object ref = checkType_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              checkType_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The type of the check.
           * </pre>
           *
           * <code>string check_type = 6;</code>
           *
           * @param value The checkType to set.
           * @return This builder for chaining.
           */
          public Builder setCheckType(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkType_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The type of the check.
           * </pre>
           *
           * <code>string check_type = 6;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearCheckType() {
            checkType_ = getDefaultInstance().getCheckType();
            bitField0_ = (bitField0_ & ~0x00000020);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The type of the check.
           * </pre>
           *
           * <code>string check_type = 6;</code>
           *
           * @param value The bytes for checkType to set.
           * @return This builder for chaining.
           */
          public Builder setCheckTypeBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            checkType_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }

          private int verdict_ = 0;
          /**
           *
           *
           * <pre>
           * The verdict of this check.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
           * </code>
           *
           * @return The enum numeric value on the wire for verdict.
           */
          @java.lang.Override
          public int getVerdictValue() {
            return verdict_;
          }
          /**
           *
           *
           * <pre>
           * The verdict of this check.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
           * </code>
           *
           * @param value The enum numeric value on the wire for verdict to set.
           * @return This builder for chaining.
           */
          public Builder setVerdictValue(int value) {
            verdict_ = value;
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The verdict of this check.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
           * </code>
           *
           * @return The verdict.
           */
          @java.lang.Override
          public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
              getVerdict() {
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
                result =
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
                        .forNumber(verdict_);
            return result == null
                ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * The verdict of this check.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
           * </code>
           *
           * @param value The verdict to set.
           * @return This builder for chaining.
           */
          public Builder setVerdict(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000040;
            verdict_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The verdict of this check.
           * </pre>
           *
           * <code>
           * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult.CheckVerdict verdict = 7;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearVerdict() {
            bitField0_ = (bitField0_ & ~0x00000040);
            verdict_ = 0;
            onChanged();
            return this;
          }

          private java.lang.Object explanation_ = "";
          /**
           *
           *
           * <pre>
           * User-friendly explanation of this check result.
           * </pre>
           *
           * <code>string explanation = 8;</code>
           *
           * @return The explanation.
           */
          public java.lang.String getExplanation() {
            java.lang.Object ref = explanation_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              explanation_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * User-friendly explanation of this check result.
           * </pre>
           *
           * <code>string explanation = 8;</code>
           *
           * @return The bytes for explanation.
           */
          public com.google.protobuf.ByteString getExplanationBytes() {
            java.lang.Object ref = explanation_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              explanation_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * User-friendly explanation of this check result.
           * </pre>
           *
           * <code>string explanation = 8;</code>
           *
           * @param value The explanation to set.
           * @return This builder for chaining.
           */
          public Builder setExplanation(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            explanation_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * User-friendly explanation of this check result.
           * </pre>
           *
           * <code>string explanation = 8;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearExplanation() {
            explanation_ = getDefaultInstance().getExplanation();
            bitField0_ = (bitField0_ & ~0x00000080);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * User-friendly explanation of this check result.
           * </pre>
           *
           * <code>string explanation = 8;</code>
           *
           * @param value The bytes for explanation to set.
           * @return This builder for chaining.
           */
          public Builder setExplanationBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            explanation_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult)
        private static final com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult();
        }

        public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<CheckResult> PARSER =
            new com.google.protobuf.AbstractParser<CheckResult>() {
              @java.lang.Override
              public CheckResult parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<CheckResult> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<CheckResult> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int IMAGE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object image_ = "";
      /**
       *
       *
       * <pre>
       * The name of the image.
       * </pre>
       *
       * <code>string image = 1;</code>
       *
       * @return The image.
       */
      @java.lang.Override
      public java.lang.String getImage() {
        java.lang.Object ref = image_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          image_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the image.
       * </pre>
       *
       * <code>string image = 1;</code>
       *
       * @return The bytes for image.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getImageBytes() {
        java.lang.Object ref = image_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          image_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONTAINER_NAME_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object containerName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the container.
       * </pre>
       *
       * <code>string container_name = 5;</code>
       *
       * @return The containerName.
       */
      @java.lang.Override
      public java.lang.String getContainerName() {
        java.lang.Object ref = containerName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          containerName_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the container.
       * </pre>
       *
       * <code>string container_name = 5;</code>
       *
       * @return The bytes for containerName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContainerNameBytes() {
        java.lang.Object ref = containerName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          containerName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONTAINER_TYPE_FIELD_NUMBER = 6;
      private int containerType_ = 0;
      /**
       *
       *
       * <pre>
       * The container type that this image belongs to.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
       * </code>
       *
       * @return The enum numeric value on the wire for containerType.
       */
      @java.lang.Override
      public int getContainerTypeValue() {
        return containerType_;
      }
      /**
       *
       *
       * <pre>
       * The container type that this image belongs to.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
       * </code>
       *
       * @return The containerType.
       */
      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.ContainerType
          getContainerType() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.ContainerType
            result =
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.ContainerType.forNumber(
                    containerType_);
        return result == null
            ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.ContainerType.UNRECOGNIZED
            : result;
      }

      public static final int RESULT_FIELD_NUMBER = 2;
      private int result_ = 0;
      /**
       *
       *
       * <pre>
       * The result of the audit for this image.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for result.
       */
      @java.lang.Override
      public int getResultValue() {
        return result_;
      }
      /**
       *
       *
       * <pre>
       * The result of the audit for this image.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
       * </code>
       *
       * @return The result.
       */
      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.AuditResult
          getResult() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.AuditResult
            result =
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.AuditResult.forNumber(result_);
        return result == null
            ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.AuditResult.UNRECOGNIZED
            : result;
      }

      public static final int DESCRIPTION_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Description of the above result.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      @java.lang.Override
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Description of the above result.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CHECK_RESULTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult>
          checkResults_;
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.CheckResult>
          getCheckResultsList() {
        return checkResults_;
      }
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>
          getCheckResultsOrBuilderList() {
        return checkResults_;
      }
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      @java.lang.Override
      public int getCheckResultsCount() {
        return checkResults_.size();
      }
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.CheckResult
          getCheckResults(int index) {
        return checkResults_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of check results.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder
          getCheckResultsOrBuilder(int index) {
        return checkResults_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, image_);
        }
        if (result_
            != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.AuditResult.AUDIT_RESULT_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, result_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
        }
        for (int i = 0; i < checkResults_.size(); i++) {
          output.writeMessage(4, checkResults_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, containerName_);
        }
        if (containerType_
            != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.ContainerType.CONTAINER_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(6, containerType_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, image_);
        }
        if (result_
            != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.AuditResult.AUDIT_RESULT_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, result_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
        }
        for (int i = 0; i < checkResults_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, checkResults_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, containerName_);
        }
        if (containerType_
            != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.ContainerType.CONTAINER_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, containerType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails)) {
          return super.equals(obj);
        }
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails
            other =
                (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails)
                    obj;

        if (!getImage().equals(other.getImage())) return false;
        if (!getContainerName().equals(other.getContainerName())) return false;
        if (containerType_ != other.containerType_) return false;
        if (result_ != other.result_) return false;
        if (!getDescription().equals(other.getDescription())) return false;
        if (!getCheckResultsList().equals(other.getCheckResultsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getImage().hashCode();
        hash = (37 * hash) + CONTAINER_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getContainerName().hashCode();
        hash = (37 * hash) + CONTAINER_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + containerType_;
        hash = (37 * hash) + RESULT_FIELD_NUMBER;
        hash = (53 * hash) + result_;
        hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
        hash = (53 * hash) + getDescription().hashCode();
        if (getCheckResultsCount() > 0) {
          hash = (37 * hash) + CHECK_RESULTS_FIELD_NUMBER;
          hash = (53 * hash) + getCheckResultsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Container image with auditing details.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails)
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetailsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
              .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
              .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.class,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.Builder.class);
        }

        // Construct using
        // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          image_ = "";
          containerName_ = "";
          containerType_ = 0;
          result_ = 0;
          description_ = "";
          if (checkResultsBuilder_ == null) {
            checkResults_ = java.util.Collections.emptyList();
          } else {
            checkResults_ = null;
            checkResultsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000020);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
              .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_ImageDetails_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails
            getDefaultInstanceForType() {
          return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails
            build() {
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails
            buildPartial() {
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              result =
                  new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails
                result) {
          if (checkResultsBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0)) {
              checkResults_ = java.util.Collections.unmodifiableList(checkResults_);
              bitField0_ = (bitField0_ & ~0x00000020);
            }
            result.checkResults_ = checkResults_;
          } else {
            result.checkResults_ = checkResultsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.image_ = image_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.containerName_ = containerName_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.containerType_ = containerType_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.result_ = result_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.description_ = description_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails) {
            return mergeFrom(
                (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails
                other) {
          if (other
              == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.getDefaultInstance()) return this;
          if (!other.getImage().isEmpty()) {
            image_ = other.image_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getContainerName().isEmpty()) {
            containerName_ = other.containerName_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.containerType_ != 0) {
            setContainerTypeValue(other.getContainerTypeValue());
          }
          if (other.result_ != 0) {
            setResultValue(other.getResultValue());
          }
          if (!other.getDescription().isEmpty()) {
            description_ = other.description_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          if (checkResultsBuilder_ == null) {
            if (!other.checkResults_.isEmpty()) {
              if (checkResults_.isEmpty()) {
                checkResults_ = other.checkResults_;
                bitField0_ = (bitField0_ & ~0x00000020);
              } else {
                ensureCheckResultsIsMutable();
                checkResults_.addAll(other.checkResults_);
              }
              onChanged();
            }
          } else {
            if (!other.checkResults_.isEmpty()) {
              if (checkResultsBuilder_.isEmpty()) {
                checkResultsBuilder_.dispose();
                checkResultsBuilder_ = null;
                checkResults_ = other.checkResults_;
                bitField0_ = (bitField0_ & ~0x00000020);
                checkResultsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getCheckResultsFieldBuilder()
                        : null;
              } else {
                checkResultsBuilder_.addAllMessages(other.checkResults_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    image_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    result_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 16
                case 26:
                  {
                    description_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                            .ContinuousValidationPodEvent.ImageDetails.CheckResult
                        m =
                            input.readMessage(
                                com.google.cloud.binaryauthorization.v1beta1
                                    .ContinuousValidationEvent.ContinuousValidationPodEvent
                                    .ImageDetails.CheckResult.parser(),
                                extensionRegistry);
                    if (checkResultsBuilder_ == null) {
                      ensureCheckResultsIsMutable();
                      checkResults_.add(m);
                    } else {
                      checkResultsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                case 42:
                  {
                    containerName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 42
                case 48:
                  {
                    containerType_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 48
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object image_ = "";
        /**
         *
         *
         * <pre>
         * The name of the image.
         * </pre>
         *
         * <code>string image = 1;</code>
         *
         * @return The image.
         */
        public java.lang.String getImage() {
          java.lang.Object ref = image_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            image_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the image.
         * </pre>
         *
         * <code>string image = 1;</code>
         *
         * @return The bytes for image.
         */
        public com.google.protobuf.ByteString getImageBytes() {
          java.lang.Object ref = image_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            image_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the image.
         * </pre>
         *
         * <code>string image = 1;</code>
         *
         * @param value The image to set.
         * @return This builder for chaining.
         */
        public Builder setImage(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          image_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the image.
         * </pre>
         *
         * <code>string image = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearImage() {
          image_ = getDefaultInstance().getImage();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the image.
         * </pre>
         *
         * <code>string image = 1;</code>
         *
         * @param value The bytes for image to set.
         * @return This builder for chaining.
         */
        public Builder setImageBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          image_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object containerName_ = "";
        /**
         *
         *
         * <pre>
         * The name of the container.
         * </pre>
         *
         * <code>string container_name = 5;</code>
         *
         * @return The containerName.
         */
        public java.lang.String getContainerName() {
          java.lang.Object ref = containerName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            containerName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the container.
         * </pre>
         *
         * <code>string container_name = 5;</code>
         *
         * @return The bytes for containerName.
         */
        public com.google.protobuf.ByteString getContainerNameBytes() {
          java.lang.Object ref = containerName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            containerName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The name of the container.
         * </pre>
         *
         * <code>string container_name = 5;</code>
         *
         * @param value The containerName to set.
         * @return This builder for chaining.
         */
        public Builder setContainerName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          containerName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the container.
         * </pre>
         *
         * <code>string container_name = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContainerName() {
          containerName_ = getDefaultInstance().getContainerName();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The name of the container.
         * </pre>
         *
         * <code>string container_name = 5;</code>
         *
         * @param value The bytes for containerName to set.
         * @return This builder for chaining.
         */
        public Builder setContainerNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          containerName_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private int containerType_ = 0;
        /**
         *
         *
         * <pre>
         * The container type that this image belongs to.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
         * </code>
         *
         * @return The enum numeric value on the wire for containerType.
         */
        @java.lang.Override
        public int getContainerTypeValue() {
          return containerType_;
        }
        /**
         *
         *
         * <pre>
         * The container type that this image belongs to.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
         * </code>
         *
         * @param value The enum numeric value on the wire for containerType to set.
         * @return This builder for chaining.
         */
        public Builder setContainerTypeValue(int value) {
          containerType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The container type that this image belongs to.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
         * </code>
         *
         * @return The containerType.
         */
        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.ContainerType
            getContainerType() {
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.ContainerType
              result =
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.ContainerType.forNumber(
                      containerType_);
          return result == null
              ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.ContainerType.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The container type that this image belongs to.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
         * </code>
         *
         * @param value The containerType to set.
         * @return This builder for chaining.
         */
        public Builder setContainerType(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.ContainerType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          containerType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The container type that this image belongs to.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.ContainerType container_type = 6;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContainerType() {
          bitField0_ = (bitField0_ & ~0x00000004);
          containerType_ = 0;
          onChanged();
          return this;
        }

        private int result_ = 0;
        /**
         *
         *
         * <pre>
         * The result of the audit for this image.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for result.
         */
        @java.lang.Override
        public int getResultValue() {
          return result_;
        }
        /**
         *
         *
         * <pre>
         * The result of the audit for this image.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for result to set.
         * @return This builder for chaining.
         */
        public Builder setResultValue(int value) {
          result_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The result of the audit for this image.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
         * </code>
         *
         * @return The result.
         */
        @java.lang.Override
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.AuditResult
            getResult() {
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.AuditResult
              result =
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.AuditResult.forNumber(result_);
          return result == null
              ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.AuditResult.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The result of the audit for this image.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
         * </code>
         *
         * @param value The result to set.
         * @return This builder for chaining.
         */
        public Builder setResult(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.AuditResult
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          result_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The result of the audit for this image.
         * </pre>
         *
         * <code>
         * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.AuditResult result = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearResult() {
          bitField0_ = (bitField0_ & ~0x00000008);
          result_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object description_ = "";
        /**
         *
         *
         * <pre>
         * Description of the above result.
         * </pre>
         *
         * <code>string description = 3;</code>
         *
         * @return The description.
         */
        public java.lang.String getDescription() {
          java.lang.Object ref = description_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            description_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Description of the above result.
         * </pre>
         *
         * <code>string description = 3;</code>
         *
         * @return The bytes for description.
         */
        public com.google.protobuf.ByteString getDescriptionBytes() {
          java.lang.Object ref = description_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            description_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Description of the above result.
         * </pre>
         *
         * <code>string description = 3;</code>
         *
         * @param value The description to set.
         * @return This builder for chaining.
         */
        public Builder setDescription(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          description_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Description of the above result.
         * </pre>
         *
         * <code>string description = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDescription() {
          description_ = getDefaultInstance().getDescription();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Description of the above result.
         * </pre>
         *
         * <code>string description = 3;</code>
         *
         * @param value The bytes for description to set.
         * @return This builder for chaining.
         */
        public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          description_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult>
            checkResults_ = java.util.Collections.emptyList();

        private void ensureCheckResultsIsMutable() {
          if (!((bitField0_ & 0x00000020) != 0)) {
            checkResults_ =
                new java.util.ArrayList<
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult>(checkResults_);
            bitField0_ |= 0x00000020;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>
            checkResultsBuilder_;

        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult>
            getCheckResultsList() {
          if (checkResultsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(checkResults_);
          } else {
            return checkResultsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public int getCheckResultsCount() {
          if (checkResultsBuilder_ == null) {
            return checkResults_.size();
          } else {
            return checkResultsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult
            getCheckResults(int index) {
          if (checkResultsBuilder_ == null) {
            return checkResults_.get(index);
          } else {
            return checkResultsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder setCheckResults(
            int index,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                value) {
          if (checkResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCheckResultsIsMutable();
            checkResults_.set(index, value);
            onChanged();
          } else {
            checkResultsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder setCheckResults(
            int index,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
                builderForValue) {
          if (checkResultsBuilder_ == null) {
            ensureCheckResultsIsMutable();
            checkResults_.set(index, builderForValue.build());
            onChanged();
          } else {
            checkResultsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder addCheckResults(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                value) {
          if (checkResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCheckResultsIsMutable();
            checkResults_.add(value);
            onChanged();
          } else {
            checkResultsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder addCheckResults(
            int index,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult
                value) {
          if (checkResultsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCheckResultsIsMutable();
            checkResults_.add(index, value);
            onChanged();
          } else {
            checkResultsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder addCheckResults(
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
                builderForValue) {
          if (checkResultsBuilder_ == null) {
            ensureCheckResultsIsMutable();
            checkResults_.add(builderForValue.build());
            onChanged();
          } else {
            checkResultsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder addCheckResults(
            int index,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
                builderForValue) {
          if (checkResultsBuilder_ == null) {
            ensureCheckResultsIsMutable();
            checkResults_.add(index, builderForValue.build());
            onChanged();
          } else {
            checkResultsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder addAllCheckResults(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                            .ContinuousValidationPodEvent.ImageDetails.CheckResult>
                values) {
          if (checkResultsBuilder_ == null) {
            ensureCheckResultsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, checkResults_);
            onChanged();
          } else {
            checkResultsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder clearCheckResults() {
          if (checkResultsBuilder_ == null) {
            checkResults_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000020);
            onChanged();
          } else {
            checkResultsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public Builder removeCheckResults(int index) {
          if (checkResultsBuilder_ == null) {
            ensureCheckResultsIsMutable();
            checkResults_.remove(index);
            onChanged();
          } else {
            checkResultsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
            getCheckResultsBuilder(int index) {
          return getCheckResultsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder
            getCheckResultsOrBuilder(int index) {
          if (checkResultsBuilder_ == null) {
            return checkResults_.get(index);
          } else {
            return checkResultsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>
            getCheckResultsOrBuilderList() {
          if (checkResultsBuilder_ != null) {
            return checkResultsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(checkResults_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
            addCheckResultsBuilder() {
          return getCheckResultsFieldBuilder()
              .addBuilder(
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder
            addCheckResultsBuilder(int index) {
          return getCheckResultsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.CheckResult.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of check results.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails.CheckResult check_results = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder>
            getCheckResultsBuilderList() {
          return getCheckResultsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>
            getCheckResultsFieldBuilder() {
          if (checkResultsBuilder_ == null) {
            checkResultsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult,
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResult.Builder,
                    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent.ImageDetails.CheckResultOrBuilder>(
                    checkResults_,
                    ((bitField0_ & 0x00000020) != 0),
                    getParentForChildren(),
                    isClean());
            checkResults_ = null;
          }
          return checkResultsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails)
      private static final com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails();
      }

      public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ImageDetails> PARSER =
          new com.google.protobuf.AbstractParser<ImageDetails>() {
            @java.lang.Override
            public ImageDetails parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ImageDetails> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ImageDetails> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int POD_NAMESPACE_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object podNamespace_ = "";
    /**
     *
     *
     * <pre>
     * The k8s namespace of the Pod.
     * </pre>
     *
     * <code>string pod_namespace = 7;</code>
     *
     * @return The podNamespace.
     */
    @java.lang.Override
    public java.lang.String getPodNamespace() {
      java.lang.Object ref = podNamespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        podNamespace_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The k8s namespace of the Pod.
     * </pre>
     *
     * <code>string pod_namespace = 7;</code>
     *
     * @return The bytes for podNamespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPodNamespaceBytes() {
      java.lang.Object ref = podNamespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        podNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pod_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Pod.
     * </pre>
     *
     * <code>string pod = 1;</code>
     *
     * @return The pod.
     */
    @java.lang.Override
    public java.lang.String getPod() {
      java.lang.Object ref = pod_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pod_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Pod.
     * </pre>
     *
     * <code>string pod = 1;</code>
     *
     * @return The bytes for pod.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPodBytes() {
      java.lang.Object ref = pod_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POLICY_NAME_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object policyName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the policy.
     * </pre>
     *
     * <code>string policy_name = 8;</code>
     *
     * @return The policyName.
     */
    @java.lang.Override
    public java.lang.String getPolicyName() {
      java.lang.Object ref = policyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policyName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the policy.
     * </pre>
     *
     * <code>string policy_name = 8;</code>
     *
     * @return The bytes for policyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPolicyNameBytes() {
      java.lang.Object ref = policyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPLOY_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp deployTime_;
    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     *
     * @return Whether the deployTime field is set.
     */
    @java.lang.Override
    public boolean hasDeployTime() {
      return deployTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     *
     * @return The deployTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getDeployTime() {
      return deployTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deployTime_;
    }
    /**
     *
     *
     * <pre>
     * Deploy time of the Pod from k8s.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getDeployTimeOrBuilder() {
      return deployTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deployTime_;
    }

    public static final int END_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * Termination time of the Pod from k8s, or nothing if still running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }

    public static final int VERDICT_FIELD_NUMBER = 4;
    private int verdict_ = 0;
    /**
     *
     *
     * <pre>
     * Auditing verdict for this Pod.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for verdict.
     */
    @java.lang.Override
    public int getVerdictValue() {
      return verdict_;
    }
    /**
     *
     *
     * <pre>
     * Auditing verdict for this Pod.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
     * </code>
     *
     * @return The verdict.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.PolicyConformanceVerdict
        getVerdict() {
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.PolicyConformanceVerdict
          result =
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.PolicyConformanceVerdict.forNumber(verdict_);
      return result == null
          ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.PolicyConformanceVerdict.UNRECOGNIZED
          : result;
    }

    public static final int IMAGES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails>
        images_;
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.ImageDetails>
        getImagesList() {
      return images_;
    }
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetailsOrBuilder>
        getImagesOrBuilderList() {
      return images_;
    }
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    @java.lang.Override
    public int getImagesCount() {
      return images_.size();
    }
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.ImageDetails
        getImages(int index) {
      return images_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of images with auditing details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.ImageDetailsOrBuilder
        getImagesOrBuilder(int index) {
      return images_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pod_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pod_);
      }
      if (deployTime_ != null) {
        output.writeMessage(2, getDeployTime());
      }
      if (endTime_ != null) {
        output.writeMessage(3, getEndTime());
      }
      if (verdict_
          != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.PolicyConformanceVerdict
              .POLICY_CONFORMANCE_VERDICT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, verdict_);
      }
      for (int i = 0; i < images_.size(); i++) {
        output.writeMessage(5, images_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podNamespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, podNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, policyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pod_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pod_);
      }
      if (deployTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDeployTime());
      }
      if (endTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
      }
      if (verdict_
          != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.PolicyConformanceVerdict
              .POLICY_CONFORMANCE_VERDICT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, verdict_);
      }
      for (int i = 0; i < images_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, images_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(podNamespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, podNamespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, policyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent)) {
        return super.equals(obj);
      }
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent
          other =
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent)
                  obj;

      if (!getPodNamespace().equals(other.getPodNamespace())) return false;
      if (!getPod().equals(other.getPod())) return false;
      if (!getPolicyName().equals(other.getPolicyName())) return false;
      if (hasDeployTime() != other.hasDeployTime()) return false;
      if (hasDeployTime()) {
        if (!getDeployTime().equals(other.getDeployTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (verdict_ != other.verdict_) return false;
      if (!getImagesList().equals(other.getImagesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + POD_NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getPodNamespace().hashCode();
      hash = (37 * hash) + POD_FIELD_NUMBER;
      hash = (53 * hash) + getPod().hashCode();
      hash = (37 * hash) + POLICY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyName().hashCode();
      if (hasDeployTime()) {
        hash = (37 * hash) + DEPLOY_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDeployTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      hash = (37 * hash) + VERDICT_FIELD_NUMBER;
      hash = (53 * hash) + verdict_;
      if (getImagesCount() > 0) {
        hash = (37 * hash) + IMAGES_FIELD_NUMBER;
        hash = (53 * hash) + getImagesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An auditing event for one Pod.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent)
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEventOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.class,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.Builder.class);
      }

      // Construct using
      // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        podNamespace_ = "";
        pod_ = "";
        policyName_ = "";
        deployTime_ = null;
        if (deployTimeBuilder_ != null) {
          deployTimeBuilder_.dispose();
          deployTimeBuilder_ = null;
        }
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        verdict_ = 0;
        if (imagesBuilder_ == null) {
          images_ = java.util.Collections.emptyList();
        } else {
          images_ = null;
          imagesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ContinuousValidationPodEvent_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent
          getDefaultInstanceForType() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent
          build() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent
          buildPartial() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent
            result =
                new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent
              result) {
        if (imagesBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            images_ = java.util.Collections.unmodifiableList(images_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.images_ = images_;
        } else {
          result.images_ = imagesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.podNamespace_ = podNamespace_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pod_ = pod_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.policyName_ = policyName_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.deployTime_ =
              deployTimeBuilder_ == null ? deployTime_ : deployTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.verdict_ = verdict_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent) {
          return mergeFrom(
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent
              other) {
        if (other
            == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.getDefaultInstance()) return this;
        if (!other.getPodNamespace().isEmpty()) {
          podNamespace_ = other.podNamespace_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPod().isEmpty()) {
          pod_ = other.pod_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPolicyName().isEmpty()) {
          policyName_ = other.policyName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasDeployTime()) {
          mergeDeployTime(other.getDeployTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        if (other.verdict_ != 0) {
          setVerdictValue(other.getVerdictValue());
        }
        if (imagesBuilder_ == null) {
          if (!other.images_.isEmpty()) {
            if (images_.isEmpty()) {
              images_ = other.images_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureImagesIsMutable();
              images_.addAll(other.images_);
            }
            onChanged();
          }
        } else {
          if (!other.images_.isEmpty()) {
            if (imagesBuilder_.isEmpty()) {
              imagesBuilder_.dispose();
              imagesBuilder_ = null;
              images_ = other.images_;
              bitField0_ = (bitField0_ & ~0x00000040);
              imagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getImagesFieldBuilder()
                      : null;
            } else {
              imagesBuilder_.addAllMessages(other.images_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pod_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDeployTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 26
              case 32:
                {
                  verdict_ = input.readEnum();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails
                      m =
                          input.readMessage(
                              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                                  .ContinuousValidationPodEvent.ImageDetails.parser(),
                              extensionRegistry);
                  if (imagesBuilder_ == null) {
                    ensureImagesIsMutable();
                    images_.add(m);
                  } else {
                    imagesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 58:
                {
                  podNamespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 58
              case 66:
                {
                  policyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object podNamespace_ = "";
      /**
       *
       *
       * <pre>
       * The k8s namespace of the Pod.
       * </pre>
       *
       * <code>string pod_namespace = 7;</code>
       *
       * @return The podNamespace.
       */
      public java.lang.String getPodNamespace() {
        java.lang.Object ref = podNamespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          podNamespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The k8s namespace of the Pod.
       * </pre>
       *
       * <code>string pod_namespace = 7;</code>
       *
       * @return The bytes for podNamespace.
       */
      public com.google.protobuf.ByteString getPodNamespaceBytes() {
        java.lang.Object ref = podNamespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          podNamespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The k8s namespace of the Pod.
       * </pre>
       *
       * <code>string pod_namespace = 7;</code>
       *
       * @param value The podNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setPodNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        podNamespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The k8s namespace of the Pod.
       * </pre>
       *
       * <code>string pod_namespace = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPodNamespace() {
        podNamespace_ = getDefaultInstance().getPodNamespace();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The k8s namespace of the Pod.
       * </pre>
       *
       * <code>string pod_namespace = 7;</code>
       *
       * @param value The bytes for podNamespace to set.
       * @return This builder for chaining.
       */
      public Builder setPodNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        podNamespace_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object pod_ = "";
      /**
       *
       *
       * <pre>
       * The name of the Pod.
       * </pre>
       *
       * <code>string pod = 1;</code>
       *
       * @return The pod.
       */
      public java.lang.String getPod() {
        java.lang.Object ref = pod_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pod_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Pod.
       * </pre>
       *
       * <code>string pod = 1;</code>
       *
       * @return The bytes for pod.
       */
      public com.google.protobuf.ByteString getPodBytes() {
        java.lang.Object ref = pod_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pod_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the Pod.
       * </pre>
       *
       * <code>string pod = 1;</code>
       *
       * @param value The pod to set.
       * @return This builder for chaining.
       */
      public Builder setPod(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pod_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Pod.
       * </pre>
       *
       * <code>string pod = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPod() {
        pod_ = getDefaultInstance().getPod();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the Pod.
       * </pre>
       *
       * <code>string pod = 1;</code>
       *
       * @param value The bytes for pod to set.
       * @return This builder for chaining.
       */
      public Builder setPodBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pod_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object policyName_ = "";
      /**
       *
       *
       * <pre>
       * The name of the policy.
       * </pre>
       *
       * <code>string policy_name = 8;</code>
       *
       * @return The policyName.
       */
      public java.lang.String getPolicyName() {
        java.lang.Object ref = policyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          policyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the policy.
       * </pre>
       *
       * <code>string policy_name = 8;</code>
       *
       * @return The bytes for policyName.
       */
      public com.google.protobuf.ByteString getPolicyNameBytes() {
        java.lang.Object ref = policyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          policyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the policy.
       * </pre>
       *
       * <code>string policy_name = 8;</code>
       *
       * @param value The policyName to set.
       * @return This builder for chaining.
       */
      public Builder setPolicyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the policy.
       * </pre>
       *
       * <code>string policy_name = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPolicyName() {
        policyName_ = getDefaultInstance().getPolicyName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the policy.
       * </pre>
       *
       * <code>string policy_name = 8;</code>
       *
       * @param value The bytes for policyName to set.
       * @return This builder for chaining.
       */
      public Builder setPolicyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        policyName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp deployTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          deployTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       *
       * @return Whether the deployTime field is set.
       */
      public boolean hasDeployTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       *
       * @return The deployTime.
       */
      public com.google.protobuf.Timestamp getDeployTime() {
        if (deployTimeBuilder_ == null) {
          return deployTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deployTime_;
        } else {
          return deployTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public Builder setDeployTime(com.google.protobuf.Timestamp value) {
        if (deployTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deployTime_ = value;
        } else {
          deployTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public Builder setDeployTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (deployTimeBuilder_ == null) {
          deployTime_ = builderForValue.build();
        } else {
          deployTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public Builder mergeDeployTime(com.google.protobuf.Timestamp value) {
        if (deployTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && deployTime_ != null
              && deployTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getDeployTimeBuilder().mergeFrom(value);
          } else {
            deployTime_ = value;
          }
        } else {
          deployTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public Builder clearDeployTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        deployTime_ = null;
        if (deployTimeBuilder_ != null) {
          deployTimeBuilder_.dispose();
          deployTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getDeployTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getDeployTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getDeployTimeOrBuilder() {
        if (deployTimeBuilder_ != null) {
          return deployTimeBuilder_.getMessageOrBuilder();
        } else {
          return deployTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deployTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Deploy time of the Pod from k8s.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deploy_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getDeployTimeFieldBuilder() {
        if (deployTimeBuilder_ == null) {
          deployTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getDeployTime(), getParentForChildren(), isClean());
          deployTime_ = null;
        }
        return deployTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
        } else {
          endTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && endTime_ != null
              && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimeBuilder().mergeFrom(value);
          } else {
            endTime_ = value;
          }
        } else {
          endTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public Builder clearEndTime() {
        bitField0_ = (bitField0_ & ~0x00000010);
        endTime_ = null;
        if (endTimeBuilder_ != null) {
          endTimeBuilder_.dispose();
          endTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Termination time of the Pod from k8s, or nothing if still running.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      private int verdict_ = 0;
      /**
       *
       *
       * <pre>
       * Auditing verdict for this Pod.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for verdict.
       */
      @java.lang.Override
      public int getVerdictValue() {
        return verdict_;
      }
      /**
       *
       *
       * <pre>
       * Auditing verdict for this Pod.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for verdict to set.
       * @return This builder for chaining.
       */
      public Builder setVerdictValue(int value) {
        verdict_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Auditing verdict for this Pod.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
       * </code>
       *
       * @return The verdict.
       */
      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.PolicyConformanceVerdict
          getVerdict() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.PolicyConformanceVerdict
            result =
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.PolicyConformanceVerdict.forNumber(verdict_);
        return result == null
            ? com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.PolicyConformanceVerdict.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Auditing verdict for this Pod.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
       * </code>
       *
       * @param value The verdict to set.
       * @return This builder for chaining.
       */
      public Builder setVerdict(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.PolicyConformanceVerdict
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        verdict_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Auditing verdict for this Pod.
       * </pre>
       *
       * <code>
       * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.PolicyConformanceVerdict verdict = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVerdict() {
        bitField0_ = (bitField0_ & ~0x00000020);
        verdict_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails>
          images_ = java.util.Collections.emptyList();

      private void ensureImagesIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          images_ =
              new java.util.ArrayList<
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails>(images_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetailsOrBuilder>
          imagesBuilder_;

      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails>
          getImagesList() {
        if (imagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(images_);
        } else {
          return imagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public int getImagesCount() {
        if (imagesBuilder_ == null) {
          return images_.size();
        } else {
          return imagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails
          getImages(int index) {
        if (imagesBuilder_ == null) {
          return images_.get(index);
        } else {
          return imagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder setImages(
          int index,
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              value) {
        if (imagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureImagesIsMutable();
          images_.set(index, value);
          onChanged();
        } else {
          imagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder setImages(
          int index,
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder
              builderForValue) {
        if (imagesBuilder_ == null) {
          ensureImagesIsMutable();
          images_.set(index, builderForValue.build());
          onChanged();
        } else {
          imagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder addImages(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              value) {
        if (imagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureImagesIsMutable();
          images_.add(value);
          onChanged();
        } else {
          imagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder addImages(
          int index,
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails
              value) {
        if (imagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureImagesIsMutable();
          images_.add(index, value);
          onChanged();
        } else {
          imagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder addImages(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder
              builderForValue) {
        if (imagesBuilder_ == null) {
          ensureImagesIsMutable();
          images_.add(builderForValue.build());
          onChanged();
        } else {
          imagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder addImages(
          int index,
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder
              builderForValue) {
        if (imagesBuilder_ == null) {
          ensureImagesIsMutable();
          images_.add(index, builderForValue.build());
          onChanged();
        } else {
          imagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder addAllImages(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                          .ContinuousValidationPodEvent.ImageDetails>
              values) {
        if (imagesBuilder_ == null) {
          ensureImagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
          onChanged();
        } else {
          imagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder clearImages() {
        if (imagesBuilder_ == null) {
          images_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          imagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public Builder removeImages(int index) {
        if (imagesBuilder_ == null) {
          ensureImagesIsMutable();
          images_.remove(index);
          onChanged();
        } else {
          imagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.Builder
          getImagesBuilder(int index) {
        return getImagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetailsOrBuilder
          getImagesOrBuilder(int index) {
        if (imagesBuilder_ == null) {
          return images_.get(index);
        } else {
          return imagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetailsOrBuilder>
          getImagesOrBuilderList() {
        if (imagesBuilder_ != null) {
          return imagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(images_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.Builder
          addImagesBuilder() {
        return getImagesFieldBuilder()
            .addBuilder(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent.ImageDetails.Builder
          addImagesBuilder(int index) {
        return getImagesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.ImageDetails.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of images with auditing details.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent.ImageDetails images = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder>
          getImagesBuilderList() {
        return getImagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetails.Builder,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.ImageDetailsOrBuilder>
          getImagesFieldBuilder() {
        if (imagesBuilder_ == null) {
          imagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetails.Builder,
                  com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent.ImageDetailsOrBuilder>(
                  images_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
          images_ = null;
        }
        return imagesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent)
    private static final com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent();
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContinuousValidationPodEvent> PARSER =
        new com.google.protobuf.AbstractParser<ContinuousValidationPodEvent>() {
          @java.lang.Override
          public ContinuousValidationPodEvent parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ContinuousValidationPodEvent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContinuousValidationPodEvent> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConfigErrorEventOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A description of the issue.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * A description of the issue.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();
  }
  /**
   *
   *
   * <pre>
   * An event describing a user-actionable configuration issue that prevents CV
   * from auditing.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent}
   */
  public static final class ConfigErrorEvent extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
      ConfigErrorEventOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConfigErrorEvent.newBuilder() to construct.
    private ConfigErrorEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfigErrorEvent() {
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfigErrorEvent();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ConfigErrorEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ConfigErrorEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent.class,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent.Builder.class);
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the issue.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the issue.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ConfigErrorEvent)) {
        return super.equals(obj);
      }
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
          other =
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ConfigErrorEvent)
                  obj;

      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An event describing a user-actionable configuration issue that prevents CV
     * from auditing.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEventOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ConfigErrorEvent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ConfigErrorEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent.class,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent.Builder.class);
      }

      // Construct using
      // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        description_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
            .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_ConfigErrorEvent_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
          getDefaultInstanceForType() {
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
          build() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
          buildPartial() {
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            result =
                new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.description_ = description_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ConfigErrorEvent) {
          return mergeFrom(
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ConfigErrorEvent)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
              other) {
        if (other
            == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ConfigErrorEvent.getDefaultInstance()) return this;
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * A description of the issue.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A description of the issue.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A description of the issue.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A description of the issue.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A description of the issue.
       * </pre>
       *
       * <code>string description = 1;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
    private static final com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ConfigErrorEvent();
    }

    public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfigErrorEvent> PARSER =
        new com.google.protobuf.AbstractParser<ConfigErrorEvent>() {
          @java.lang.Override
          public ConfigErrorEvent parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConfigErrorEvent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfigErrorEvent> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int eventTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object eventType_;

  public enum EventTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    POD_EVENT(1),
    CONFIG_ERROR_EVENT(4),
    EVENTTYPE_NOT_SET(0);
    private final int value;

    private EventTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static EventTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return POD_EVENT;
        case 4:
          return CONFIG_ERROR_EVENT;
        case 0:
          return EVENTTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EventTypeCase getEventTypeCase() {
    return EventTypeCase.forNumber(eventTypeCase_);
  }

  public static final int POD_EVENT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Pod event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
   * </code>
   *
   * @return Whether the podEvent field is set.
   */
  @java.lang.Override
  public boolean hasPodEvent() {
    return eventTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Pod event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
   * </code>
   *
   * @return The podEvent.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
          .ContinuousValidationPodEvent
      getPodEvent() {
    if (eventTypeCase_ == 1) {
      return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent)
          eventType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
        .ContinuousValidationPodEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Pod event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
          .ContinuousValidationPodEventOrBuilder
      getPodEventOrBuilder() {
    if (eventTypeCase_ == 1) {
      return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ContinuousValidationPodEvent)
          eventType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
        .ContinuousValidationPodEvent.getDefaultInstance();
  }

  public static final int CONFIG_ERROR_EVENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Config error event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
   * </code>
   *
   * @return Whether the configErrorEvent field is set.
   */
  @java.lang.Override
  public boolean hasConfigErrorEvent() {
    return eventTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Config error event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
   * </code>
   *
   * @return The configErrorEvent.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
      getConfigErrorEvent() {
    if (eventTypeCase_ == 4) {
      return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ConfigErrorEvent)
          eventType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Config error event.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
          .ConfigErrorEventOrBuilder
      getConfigErrorEventOrBuilder() {
    if (eventTypeCase_ == 4) {
      return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .ConfigErrorEvent)
          eventType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (eventTypeCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent)
              eventType_);
    }
    if (eventTypeCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent)
              eventType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (eventTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ContinuousValidationPodEvent)
                  eventType_);
    }
    if (eventTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                      .ConfigErrorEvent)
                  eventType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent other =
        (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent) obj;

    if (!getEventTypeCase().equals(other.getEventTypeCase())) return false;
    switch (eventTypeCase_) {
      case 1:
        if (!getPodEvent().equals(other.getPodEvent())) return false;
        break;
      case 4:
        if (!getConfigErrorEvent().equals(other.getConfigErrorEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (eventTypeCase_) {
      case 1:
        hash = (37 * hash) + POD_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getPodEvent().hashCode();
        break;
      case 4:
        hash = (37 * hash) + CONFIG_ERROR_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getConfigErrorEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an auditing event from Continuous Validation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent)
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.class,
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.Builder.class);
    }

    // Construct using
    // com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (podEventBuilder_ != null) {
        podEventBuilder_.clear();
      }
      if (configErrorEventBuilder_ != null) {
        configErrorEventBuilder_.clear();
      }
      eventTypeCase_ = 0;
      eventType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationLoggingProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ContinuousValidationEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
        getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent build() {
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent result =
          new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent result) {
      result.eventTypeCase_ = eventTypeCase_;
      result.eventType_ = this.eventType_;
      if (eventTypeCase_ == 1 && podEventBuilder_ != null) {
        result.eventType_ = podEventBuilder_.build();
      }
      if (eventTypeCase_ == 4 && configErrorEventBuilder_ != null) {
        result.eventType_ = configErrorEventBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent) {
        return mergeFrom(
            (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent other) {
      if (other
          == com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
              .getDefaultInstance()) return this;
      switch (other.getEventTypeCase()) {
        case POD_EVENT:
          {
            mergePodEvent(other.getPodEvent());
            break;
          }
        case CONFIG_ERROR_EVENT:
          {
            mergeConfigErrorEvent(other.getConfigErrorEvent());
            break;
          }
        case EVENTTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPodEventFieldBuilder().getBuilder(), extensionRegistry);
                eventTypeCase_ = 1;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(
                    getConfigErrorEventFieldBuilder().getBuilder(), extensionRegistry);
                eventTypeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int eventTypeCase_ = 0;
    private java.lang.Object eventType_;

    public EventTypeCase getEventTypeCase() {
      return EventTypeCase.forNumber(eventTypeCase_);
    }

    public Builder clearEventType() {
      eventTypeCase_ = 0;
      eventType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.Builder,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEventOrBuilder>
        podEventBuilder_;
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     *
     * @return Whether the podEvent field is set.
     */
    @java.lang.Override
    public boolean hasPodEvent() {
      return eventTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     *
     * @return The podEvent.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent
        getPodEvent() {
      if (podEventBuilder_ == null) {
        if (eventTypeCase_ == 1) {
          return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent)
              eventType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.getDefaultInstance();
      } else {
        if (eventTypeCase_ == 1) {
          return podEventBuilder_.getMessage();
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    public Builder setPodEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent
            value) {
      if (podEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventType_ = value;
        onChanged();
      } else {
        podEventBuilder_.setMessage(value);
      }
      eventTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    public Builder setPodEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.Builder
            builderForValue) {
      if (podEventBuilder_ == null) {
        eventType_ = builderForValue.build();
        onChanged();
      } else {
        podEventBuilder_.setMessage(builderForValue.build());
      }
      eventTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    public Builder mergePodEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent
            value) {
      if (podEventBuilder_ == null) {
        if (eventTypeCase_ == 1
            && eventType_
                != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.getDefaultInstance()) {
          eventType_ =
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.newBuilder(
                      (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                              .ContinuousValidationPodEvent)
                          eventType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          eventType_ = value;
        }
        onChanged();
      } else {
        if (eventTypeCase_ == 1) {
          podEventBuilder_.mergeFrom(value);
        } else {
          podEventBuilder_.setMessage(value);
        }
      }
      eventTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    public Builder clearPodEvent() {
      if (podEventBuilder_ == null) {
        if (eventTypeCase_ == 1) {
          eventTypeCase_ = 0;
          eventType_ = null;
          onChanged();
        }
      } else {
        if (eventTypeCase_ == 1) {
          eventTypeCase_ = 0;
          eventType_ = null;
        }
        podEventBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.Builder
        getPodEventBuilder() {
      return getPodEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEventOrBuilder
        getPodEventOrBuilder() {
      if ((eventTypeCase_ == 1) && (podEventBuilder_ != null)) {
        return podEventBuilder_.getMessageOrBuilder();
      } else {
        if (eventTypeCase_ == 1) {
          return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent)
              eventType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ContinuousValidationPodEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pod event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ContinuousValidationPodEvent pod_event = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEvent.Builder,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ContinuousValidationPodEventOrBuilder>
        getPodEventFieldBuilder() {
      if (podEventBuilder_ == null) {
        if (!(eventTypeCase_ == 1)) {
          eventType_ =
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ContinuousValidationPodEvent.getDefaultInstance();
        }
        podEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEvent.Builder,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ContinuousValidationPodEventOrBuilder>(
                (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ContinuousValidationPodEvent)
                    eventType_,
                getParentForChildren(),
                isClean());
        eventType_ = null;
      }
      eventTypeCase_ = 1;
      onChanged();
      return podEventBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
                .Builder,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ConfigErrorEventOrBuilder>
        configErrorEventBuilder_;
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     *
     * @return Whether the configErrorEvent field is set.
     */
    @java.lang.Override
    public boolean hasConfigErrorEvent() {
      return eventTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     *
     * @return The configErrorEvent.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
        getConfigErrorEvent() {
      if (configErrorEventBuilder_ == null) {
        if (eventTypeCase_ == 4) {
          return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent)
              eventType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent.getDefaultInstance();
      } else {
        if (eventTypeCase_ == 4) {
          return configErrorEventBuilder_.getMessage();
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    public Builder setConfigErrorEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            value) {
      if (configErrorEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventType_ = value;
        onChanged();
      } else {
        configErrorEventBuilder_.setMessage(value);
      }
      eventTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    public Builder setConfigErrorEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
                .Builder
            builderForValue) {
      if (configErrorEventBuilder_ == null) {
        eventType_ = builderForValue.build();
        onChanged();
      } else {
        configErrorEventBuilder_.setMessage(builderForValue.build());
      }
      eventTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    public Builder mergeConfigErrorEvent(
        com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            value) {
      if (configErrorEventBuilder_ == null) {
        if (eventTypeCase_ == 4
            && eventType_
                != com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent.getDefaultInstance()) {
          eventType_ =
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent.newBuilder(
                      (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                              .ConfigErrorEvent)
                          eventType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          eventType_ = value;
        }
        onChanged();
      } else {
        if (eventTypeCase_ == 4) {
          configErrorEventBuilder_.mergeFrom(value);
        } else {
          configErrorEventBuilder_.setMessage(value);
        }
      }
      eventTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    public Builder clearConfigErrorEvent() {
      if (configErrorEventBuilder_ == null) {
        if (eventTypeCase_ == 4) {
          eventTypeCase_ = 0;
          eventType_ = null;
          onChanged();
        }
      } else {
        if (eventTypeCase_ == 4) {
          eventTypeCase_ = 0;
          eventType_ = null;
        }
        configErrorEventBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
            .Builder
        getConfigErrorEventBuilder() {
      return getConfigErrorEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEventOrBuilder
        getConfigErrorEventOrBuilder() {
      if ((eventTypeCase_ == 4) && (configErrorEventBuilder_ != null)) {
        return configErrorEventBuilder_.getMessageOrBuilder();
      } else {
        if (eventTypeCase_ == 4) {
          return (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent)
              eventType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
            .ConfigErrorEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Config error event.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent config_error_event = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent.ConfigErrorEvent
                .Builder,
            com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                .ConfigErrorEventOrBuilder>
        getConfigErrorEventFieldBuilder() {
      if (configErrorEventBuilder_ == null) {
        if (!(eventTypeCase_ == 4)) {
          eventType_ =
              com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                  .ConfigErrorEvent.getDefaultInstance();
        }
        configErrorEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEvent.Builder,
                com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                    .ConfigErrorEventOrBuilder>(
                (com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
                        .ConfigErrorEvent)
                    eventType_,
                getParentForChildren(),
                isClean());
        eventType_ = null;
      }
      eventTypeCase_ = 4;
      onChanged();
      return configErrorEventBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent)
  private static final com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContinuousValidationEvent> PARSER =
      new com.google.protobuf.AbstractParser<ContinuousValidationEvent>() {
        @java.lang.Override
        public ContinuousValidationEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContinuousValidationEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContinuousValidationEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ContinuousValidationEvent
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
