/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/service.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for [BinauthzManagementService.ListAttestors][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse}
 */
public final class ListAttestorsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse)
    ListAttestorsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAttestorsResponse.newBuilder() to construct.
  private ListAttestorsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAttestorsResponse() {
    attestors_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAttestorsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationServiceProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_ListAttestorsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationServiceProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_ListAttestorsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.class,
            com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.Builder.class);
  }

  public static final int ATTESTORS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.binaryauthorization.v1beta1.Attestor> attestors_;
  /**
   *
   *
   * <pre>
   * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
   * </pre>
   *
   * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.binaryauthorization.v1beta1.Attestor> getAttestorsList() {
    return attestors_;
  }
  /**
   *
   *
   * <pre>
   * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
   * </pre>
   *
   * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder>
      getAttestorsOrBuilderList() {
    return attestors_;
  }
  /**
   *
   *
   * <pre>
   * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
   * </pre>
   *
   * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
   */
  @java.lang.Override
  public int getAttestorsCount() {
    return attestors_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
   * </pre>
   *
   * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.Attestor getAttestors(int index) {
    return attestors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
   * </pre>
   *
   * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder getAttestorsOrBuilder(
      int index) {
    return attestors_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results. Pass this value in the
   * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
   * `ListAttestors` method to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results. Pass this value in the
   * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
   * `ListAttestors` method to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < attestors_.size(); i++) {
      output.writeMessage(1, attestors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < attestors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, attestors_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse other =
        (com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse) obj;

    if (!getAttestorsList().equals(other.getAttestorsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAttestorsCount() > 0) {
      hash = (37 * hash) + ATTESTORS_FIELD_NUMBER;
      hash = (53 * hash) + getAttestorsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for [BinauthzManagementService.ListAttestors][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse)
      com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationServiceProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ListAttestorsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationServiceProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ListAttestorsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.class,
              com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (attestorsBuilder_ == null) {
        attestors_ = java.util.Collections.emptyList();
      } else {
        attestors_ = null;
        attestorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationServiceProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_ListAttestorsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse build() {
      com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse result =
          new com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse result) {
      if (attestorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attestors_ = java.util.Collections.unmodifiableList(attestors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attestors_ = attestors_;
      } else {
        result.attestors_ = attestorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse) {
        return mergeFrom(
            (com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse other) {
      if (other
          == com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
              .getDefaultInstance()) return this;
      if (attestorsBuilder_ == null) {
        if (!other.attestors_.isEmpty()) {
          if (attestors_.isEmpty()) {
            attestors_ = other.attestors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttestorsIsMutable();
            attestors_.addAll(other.attestors_);
          }
          onChanged();
        }
      } else {
        if (!other.attestors_.isEmpty()) {
          if (attestorsBuilder_.isEmpty()) {
            attestorsBuilder_.dispose();
            attestorsBuilder_ = null;
            attestors_ = other.attestors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attestorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttestorsFieldBuilder()
                    : null;
          } else {
            attestorsBuilder_.addAllMessages(other.attestors_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.binaryauthorization.v1beta1.Attestor m =
                    input.readMessage(
                        com.google.cloud.binaryauthorization.v1beta1.Attestor.parser(),
                        extensionRegistry);
                if (attestorsBuilder_ == null) {
                  ensureAttestorsIsMutable();
                  attestors_.add(m);
                } else {
                  attestorsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.binaryauthorization.v1beta1.Attestor> attestors_ =
        java.util.Collections.emptyList();

    private void ensureAttestorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attestors_ =
            new java.util.ArrayList<com.google.cloud.binaryauthorization.v1beta1.Attestor>(
                attestors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.Attestor,
            com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder>
        attestorsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public java.util.List<com.google.cloud.binaryauthorization.v1beta1.Attestor>
        getAttestorsList() {
      if (attestorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attestors_);
      } else {
        return attestorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public int getAttestorsCount() {
      if (attestorsBuilder_ == null) {
        return attestors_.size();
      } else {
        return attestorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.Attestor getAttestors(int index) {
      if (attestorsBuilder_ == null) {
        return attestors_.get(index);
      } else {
        return attestorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder setAttestors(
        int index, com.google.cloud.binaryauthorization.v1beta1.Attestor value) {
      if (attestorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttestorsIsMutable();
        attestors_.set(index, value);
        onChanged();
      } else {
        attestorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder setAttestors(
        int index, com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder builderForValue) {
      if (attestorsBuilder_ == null) {
        ensureAttestorsIsMutable();
        attestors_.set(index, builderForValue.build());
        onChanged();
      } else {
        attestorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder addAttestors(com.google.cloud.binaryauthorization.v1beta1.Attestor value) {
      if (attestorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttestorsIsMutable();
        attestors_.add(value);
        onChanged();
      } else {
        attestorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder addAttestors(
        int index, com.google.cloud.binaryauthorization.v1beta1.Attestor value) {
      if (attestorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttestorsIsMutable();
        attestors_.add(index, value);
        onChanged();
      } else {
        attestorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder addAttestors(
        com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder builderForValue) {
      if (attestorsBuilder_ == null) {
        ensureAttestorsIsMutable();
        attestors_.add(builderForValue.build());
        onChanged();
      } else {
        attestorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder addAttestors(
        int index, com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder builderForValue) {
      if (attestorsBuilder_ == null) {
        ensureAttestorsIsMutable();
        attestors_.add(index, builderForValue.build());
        onChanged();
      } else {
        attestorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder addAllAttestors(
        java.lang.Iterable<? extends com.google.cloud.binaryauthorization.v1beta1.Attestor>
            values) {
      if (attestorsBuilder_ == null) {
        ensureAttestorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attestors_);
        onChanged();
      } else {
        attestorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder clearAttestors() {
      if (attestorsBuilder_ == null) {
        attestors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attestorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public Builder removeAttestors(int index) {
      if (attestorsBuilder_ == null) {
        ensureAttestorsIsMutable();
        attestors_.remove(index);
        onChanged();
      } else {
        attestorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder getAttestorsBuilder(
        int index) {
      return getAttestorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder getAttestorsOrBuilder(
        int index) {
      if (attestorsBuilder_ == null) {
        return attestors_.get(index);
      } else {
        return attestorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder>
        getAttestorsOrBuilderList() {
      if (attestorsBuilder_ != null) {
        return attestorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attestors_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder addAttestorsBuilder() {
      return getAttestorsFieldBuilder()
          .addBuilder(com.google.cloud.binaryauthorization.v1beta1.Attestor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder addAttestorsBuilder(
        int index) {
      return getAttestorsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.binaryauthorization.v1beta1.Attestor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of [attestors][google.cloud.binaryauthorization.v1beta1.Attestor].
     * </pre>
     *
     * <code>repeated .google.cloud.binaryauthorization.v1beta1.Attestor attestors = 1;</code>
     */
    public java.util.List<com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder>
        getAttestorsBuilderList() {
      return getAttestorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.Attestor,
            com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder>
        getAttestorsFieldBuilder() {
      if (attestorsBuilder_ == null) {
        attestorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.Attestor,
                com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder,
                com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder>(
                attestors_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        attestors_ = null;
      }
      return attestorsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results. Pass this value in the
     * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
     * `ListAttestors` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results. Pass this value in the
     * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
     * `ListAttestors` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results. Pass this value in the
     * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
     * `ListAttestors` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results. Pass this value in the
     * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
     * `ListAttestors` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results. Pass this value in the
     * [ListAttestorsRequest.page_token][google.cloud.binaryauthorization.v1beta1.ListAttestorsRequest.page_token] field in the subsequent call to the
     * `ListAttestors` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse)
  private static final com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAttestorsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListAttestorsResponse>() {
        @java.lang.Override
        public ListAttestorsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAttestorsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAttestorsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.ListAttestorsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
