/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * A public key in the PkixPublicKey format (see
 * https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
 * Public keys of this type are typically textually encoded using the PEM
 * format.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.PkixPublicKey}
 */
public final class PkixPublicKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.PkixPublicKey)
    PkixPublicKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PkixPublicKey.newBuilder() to construct.
  private PkixPublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PkixPublicKey() {
    publicKeyPem_ = "";
    signatureAlgorithm_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PkixPublicKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_PkixPublicKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_PkixPublicKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.class,
            com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents a signature algorithm and other information necessary to verify
   * signatures with a given public key.
   * This is based primarily on the public key types supported by Tink's
   * PemKeyType, which is in turn based on KMS's supported signing algorithms.
   * See https://cloud.google.com/kms/docs/algorithms. In the future, BinAuthz
   * might support additional public key types independently of Tink and/or KMS.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm}
   */
  public enum SignatureAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>SIGNATURE_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    SIGNATURE_ALGORITHM_UNSPECIFIED(0, 0),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_2048_SHA256 = 1;</code>
     */
    RSA_PSS_2048_SHA256(1, 1),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_3072_SHA256 = 2;</code>
     */
    RSA_PSS_3072_SHA256(2, 2),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_4096_SHA256 = 3;</code>
     */
    RSA_PSS_4096_SHA256(3, 3),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_PSS_4096_SHA512 = 4;</code>
     */
    RSA_PSS_4096_SHA512(4, 4),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    RSA_SIGN_PKCS1_2048_SHA256(5, 5),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    RSA_SIGN_PKCS1_3072_SHA256(6, 6),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA256(7, 7),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 8;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA512(8, 8),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>ECDSA_P256_SHA256 = 9;</code>
     */
    ECDSA_P256_SHA256(9, 9),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>ECDSA_P384_SHA384 = 10;</code>
     */
    ECDSA_P384_SHA384(11, 10),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     * </pre>
     *
     * <code>ECDSA_P521_SHA512 = 11;</code>
     */
    ECDSA_P521_SHA512(13, 11),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 9;</code>
     */
    public static final SignatureAlgorithm EC_SIGN_P256_SHA256 = ECDSA_P256_SHA256;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 10;</code>
     */
    public static final SignatureAlgorithm EC_SIGN_P384_SHA384 = ECDSA_P384_SHA384;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     * </pre>
     *
     * <code>EC_SIGN_P521_SHA512 = 11;</code>
     */
    public static final SignatureAlgorithm EC_SIGN_P521_SHA512 = ECDSA_P521_SHA512;
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>SIGNATURE_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int SIGNATURE_ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_2048_SHA256 = 1;</code>
     */
    public static final int RSA_PSS_2048_SHA256_VALUE = 1;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_3072_SHA256 = 2;</code>
     */
    public static final int RSA_PSS_3072_SHA256_VALUE = 2;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_PSS_4096_SHA256 = 3;</code>
     */
    public static final int RSA_PSS_4096_SHA256_VALUE = 3;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_PSS_4096_SHA512 = 4;</code>
     */
    public static final int RSA_PSS_4096_SHA512_VALUE = 4;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    public static final int RSA_SIGN_PKCS1_2048_SHA256_VALUE = 5;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    public static final int RSA_SIGN_PKCS1_3072_SHA256_VALUE = 6;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA256_VALUE = 7;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 8;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA512_VALUE = 8;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>ECDSA_P256_SHA256 = 9;</code>
     */
    public static final int ECDSA_P256_SHA256_VALUE = 9;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 9;</code>
     */
    public static final int EC_SIGN_P256_SHA256_VALUE = 9;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>ECDSA_P384_SHA384 = 10;</code>
     */
    public static final int ECDSA_P384_SHA384_VALUE = 10;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 10;</code>
     */
    public static final int EC_SIGN_P384_SHA384_VALUE = 10;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     * </pre>
     *
     * <code>ECDSA_P521_SHA512 = 11;</code>
     */
    public static final int ECDSA_P521_SHA512_VALUE = 11;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-521 curve with a SHA512 digest.
     * </pre>
     *
     * <code>EC_SIGN_P521_SHA512 = 11;</code>
     */
    public static final int EC_SIGN_P521_SHA512_VALUE = 11;

    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SignatureAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SignatureAlgorithm forNumber(int value) {
      switch (value) {
        case 0:
          return SIGNATURE_ALGORITHM_UNSPECIFIED;
        case 1:
          return RSA_PSS_2048_SHA256;
        case 2:
          return RSA_PSS_3072_SHA256;
        case 3:
          return RSA_PSS_4096_SHA256;
        case 4:
          return RSA_PSS_4096_SHA512;
        case 5:
          return RSA_SIGN_PKCS1_2048_SHA256;
        case 6:
          return RSA_SIGN_PKCS1_3072_SHA256;
        case 7:
          return RSA_SIGN_PKCS1_4096_SHA256;
        case 8:
          return RSA_SIGN_PKCS1_4096_SHA512;
        case 9:
          return ECDSA_P256_SHA256;
        case 10:
          return ECDSA_P384_SHA384;
        case 11:
          return ECDSA_P521_SHA512;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SignatureAlgorithm>() {
              public SignatureAlgorithm findValueByNumber(int number) {
                return SignatureAlgorithm.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (index == -1) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(index);
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SignatureAlgorithm[] VALUES = getStaticValuesArray();

    private static SignatureAlgorithm[] getStaticValuesArray() {
      return new SignatureAlgorithm[] {
        SIGNATURE_ALGORITHM_UNSPECIFIED,
        RSA_PSS_2048_SHA256,
        RSA_PSS_3072_SHA256,
        RSA_PSS_4096_SHA256,
        RSA_PSS_4096_SHA512,
        RSA_SIGN_PKCS1_2048_SHA256,
        RSA_SIGN_PKCS1_3072_SHA256,
        RSA_SIGN_PKCS1_4096_SHA256,
        RSA_SIGN_PKCS1_4096_SHA512,
        ECDSA_P256_SHA256,
        EC_SIGN_P256_SHA256,
        ECDSA_P384_SHA384,
        EC_SIGN_P384_SHA384,
        ECDSA_P521_SHA512,
        EC_SIGN_P521_SHA512,
      };
    }

    public static SignatureAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private SignatureAlgorithm(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm)
  }

  public static final int PUBLIC_KEY_PEM_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publicKeyPem_ = "";
  /**
   *
   *
   * <pre>
   * A PEM-encoded public key, as described in
   * https://tools.ietf.org/html/rfc7468#section-13
   * </pre>
   *
   * <code>string public_key_pem = 1;</code>
   *
   * @return The publicKeyPem.
   */
  @java.lang.Override
  public java.lang.String getPublicKeyPem() {
    java.lang.Object ref = publicKeyPem_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publicKeyPem_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A PEM-encoded public key, as described in
   * https://tools.ietf.org/html/rfc7468#section-13
   * </pre>
   *
   * <code>string public_key_pem = 1;</code>
   *
   * @return The bytes for publicKeyPem.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicKeyPemBytes() {
    java.lang.Object ref = publicKeyPem_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publicKeyPem_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIGNATURE_ALGORITHM_FIELD_NUMBER = 2;
  private int signatureAlgorithm_ = 0;
  /**
   *
   *
   * <pre>
   * The signature algorithm used to verify a message against a signature using
   * this key.
   * These signature algorithm must match the structure and any object
   * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
   * that of the public key).
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for signatureAlgorithm.
   */
  @java.lang.Override
  public int getSignatureAlgorithmValue() {
    return signatureAlgorithm_;
  }
  /**
   *
   *
   * <pre>
   * The signature algorithm used to verify a message against a signature using
   * this key.
   * These signature algorithm must match the structure and any object
   * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
   * that of the public key).
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
   * </code>
   *
   * @return The signatureAlgorithm.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm
      getSignatureAlgorithm() {
    com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm result =
        com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm.forNumber(
            signatureAlgorithm_);
    return result == null
        ? com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicKeyPem_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, publicKeyPem_);
    }
    if (signatureAlgorithm_
        != com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm
            .SIGNATURE_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, signatureAlgorithm_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicKeyPem_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, publicKeyPem_);
    }
    if (signatureAlgorithm_
        != com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm
            .SIGNATURE_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, signatureAlgorithm_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey other =
        (com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) obj;

    if (!getPublicKeyPem().equals(other.getPublicKeyPem())) return false;
    if (signatureAlgorithm_ != other.signatureAlgorithm_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PUBLIC_KEY_PEM_FIELD_NUMBER;
    hash = (53 * hash) + getPublicKeyPem().hashCode();
    hash = (37 * hash) + SIGNATURE_ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + signatureAlgorithm_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A public key in the PkixPublicKey format (see
   * https://tools.ietf.org/html/rfc5280#section-4.1.2.7 for details).
   * Public keys of this type are typically textually encoded using the PEM
   * format.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.PkixPublicKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.PkixPublicKey)
      com.google.cloud.binaryauthorization.v1beta1.PkixPublicKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_PkixPublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_PkixPublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.class,
              com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.Builder.class);
    }

    // Construct using com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      publicKeyPem_ = "";
      signatureAlgorithm_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_PkixPublicKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey build() {
      com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey result =
          new com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.publicKeyPem_ = publicKeyPem_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.signatureAlgorithm_ = signatureAlgorithm_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey other) {
      if (other == com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.getDefaultInstance())
        return this;
      if (!other.getPublicKeyPem().isEmpty()) {
        publicKeyPem_ = other.publicKeyPem_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.signatureAlgorithm_ != 0) {
        setSignatureAlgorithmValue(other.getSignatureAlgorithmValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                publicKeyPem_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                signatureAlgorithm_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object publicKeyPem_ = "";
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The publicKeyPem.
     */
    public java.lang.String getPublicKeyPem() {
      java.lang.Object ref = publicKeyPem_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicKeyPem_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return The bytes for publicKeyPem.
     */
    public com.google.protobuf.ByteString getPublicKeyPemBytes() {
      java.lang.Object ref = publicKeyPem_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicKeyPem_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @param value The publicKeyPem to set.
     * @return This builder for chaining.
     */
    public Builder setPublicKeyPem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicKeyPem_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicKeyPem() {
      publicKeyPem_ = getDefaultInstance().getPublicKeyPem();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A PEM-encoded public key, as described in
     * https://tools.ietf.org/html/rfc7468#section-13
     * </pre>
     *
     * <code>string public_key_pem = 1;</code>
     *
     * @param value The bytes for publicKeyPem to set.
     * @return This builder for chaining.
     */
    public Builder setPublicKeyPemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publicKeyPem_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int signatureAlgorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for signatureAlgorithm.
     */
    @java.lang.Override
    public int getSignatureAlgorithmValue() {
      return signatureAlgorithm_;
    }
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for signatureAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setSignatureAlgorithmValue(int value) {
      signatureAlgorithm_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return The signatureAlgorithm.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm
        getSignatureAlgorithm() {
      com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm result =
          com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm.forNumber(
              signatureAlgorithm_);
      return result == null
          ? com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @param value The signatureAlgorithm to set.
     * @return This builder for chaining.
     */
    public Builder setSignatureAlgorithm(
        com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      signatureAlgorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The signature algorithm used to verify a message against a signature using
     * this key.
     * These signature algorithm must match the structure and any object
     * identifiers encoded in `public_key_pem` (i.e. this algorithm must match
     * that of the public key).
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.PkixPublicKey.SignatureAlgorithm signature_algorithm = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSignatureAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000002);
      signatureAlgorithm_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.PkixPublicKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.PkixPublicKey)
  private static final com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PkixPublicKey> PARSER =
      new com.google.protobuf.AbstractParser<PkixPublicKey>() {
        @java.lang.Override
        public PkixPublicKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PkixPublicKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PkixPublicKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.PkixPublicKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
