/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * An [user owned drydock note][google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote] references a Drydock
 * ATTESTATION_AUTHORITY Note created by the user.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote}
 */
public final class UserOwnedDrydockNote extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
    UserOwnedDrydockNoteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserOwnedDrydockNote.newBuilder() to construct.
  private UserOwnedDrydockNote(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserOwnedDrydockNote() {
    noteReference_ = "";
    publicKeys_ = java.util.Collections.emptyList();
    delegationServiceAccountEmail_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserOwnedDrydockNote();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_UserOwnedDrydockNote_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_UserOwnedDrydockNote_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.class,
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder.class);
  }

  public static final int NOTE_REFERENCE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object noteReference_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
   * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
   * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
   *
   * An attestation by this attestor is stored as a Drydock
   * ATTESTATION_AUTHORITY Occurrence that names a container image and that
   * links to this Note. Drydock is an external dependency.
   * </pre>
   *
   * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The noteReference.
   */
  @java.lang.Override
  public java.lang.String getNoteReference() {
    java.lang.Object ref = noteReference_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      noteReference_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
   * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
   * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
   *
   * An attestation by this attestor is stored as a Drydock
   * ATTESTATION_AUTHORITY Occurrence that names a container image and that
   * links to this Note. Drydock is an external dependency.
   * </pre>
   *
   * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for noteReference.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNoteReferenceBytes() {
    java.lang.Object ref = noteReference_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      noteReference_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_KEYS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
      publicKeys_;
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
      getPublicKeysList() {
    return publicKeys_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>
      getPublicKeysOrBuilderList() {
    return publicKeys_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPublicKeysCount() {
    return publicKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey getPublicKeys(int index) {
    return publicKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder
      getPublicKeysOrBuilder(int index) {
    return publicKeys_.get(index);
  }

  public static final int DELEGATION_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object delegationServiceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * Output only. This field will contain the service account email address
   * that this Attestor will use as the principal when querying Container
   * Analysis. Attestor administrators must grant this service account the
   * IAM role needed to read attestations from the [note_reference][Note] in
   * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
   *
   * This email address is fixed for the lifetime of the Attestor, but callers
   * should not make any other assumptions about the service account email;
   * future versions may use an email based on a different naming pattern.
   * </pre>
   *
   * <code>string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The delegationServiceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getDelegationServiceAccountEmail() {
    java.lang.Object ref = delegationServiceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      delegationServiceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. This field will contain the service account email address
   * that this Attestor will use as the principal when querying Container
   * Analysis. Attestor administrators must grant this service account the
   * IAM role needed to read attestations from the [note_reference][Note] in
   * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
   *
   * This email address is fixed for the lifetime of the Attestor, but callers
   * should not make any other assumptions about the service account email;
   * future versions may use an email based on a different naming pattern.
   * </pre>
   *
   * <code>string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for delegationServiceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes() {
    java.lang.Object ref = delegationServiceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      delegationServiceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(noteReference_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, noteReference_);
    }
    for (int i = 0; i < publicKeys_.size(); i++) {
      output.writeMessage(2, publicKeys_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delegationServiceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, delegationServiceAccountEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(noteReference_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, noteReference_);
    }
    for (int i = 0; i < publicKeys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, publicKeys_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(delegationServiceAccountEmail_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              3, delegationServiceAccountEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote other =
        (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) obj;

    if (!getNoteReference().equals(other.getNoteReference())) return false;
    if (!getPublicKeysList().equals(other.getPublicKeysList())) return false;
    if (!getDelegationServiceAccountEmail().equals(other.getDelegationServiceAccountEmail()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NOTE_REFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + getNoteReference().hashCode();
    if (getPublicKeysCount() > 0) {
      hash = (37 * hash) + PUBLIC_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getPublicKeysList().hashCode();
    }
    hash = (37 * hash) + DELEGATION_SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getDelegationServiceAccountEmail().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [user owned drydock note][google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote] references a Drydock
   * ATTESTATION_AUTHORITY Note created by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
      com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_UserOwnedDrydockNote_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_UserOwnedDrydockNote_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.class,
              com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder.class);
    }

    // Construct using
    // com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      noteReference_ = "";
      if (publicKeysBuilder_ == null) {
        publicKeys_ = java.util.Collections.emptyList();
      } else {
        publicKeys_ = null;
        publicKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      delegationServiceAccountEmail_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_UserOwnedDrydockNote_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
        getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote build() {
      com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote result =
          new com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote result) {
      if (publicKeysBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          publicKeys_ = java.util.Collections.unmodifiableList(publicKeys_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.publicKeys_ = publicKeys_;
      } else {
        result.publicKeys_ = publicKeysBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.noteReference_ = noteReference_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.delegationServiceAccountEmail_ = delegationServiceAccountEmail_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote other) {
      if (other
          == com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.getDefaultInstance())
        return this;
      if (!other.getNoteReference().isEmpty()) {
        noteReference_ = other.noteReference_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (publicKeysBuilder_ == null) {
        if (!other.publicKeys_.isEmpty()) {
          if (publicKeys_.isEmpty()) {
            publicKeys_ = other.publicKeys_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePublicKeysIsMutable();
            publicKeys_.addAll(other.publicKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.publicKeys_.isEmpty()) {
          if (publicKeysBuilder_.isEmpty()) {
            publicKeysBuilder_.dispose();
            publicKeysBuilder_ = null;
            publicKeys_ = other.publicKeys_;
            bitField0_ = (bitField0_ & ~0x00000002);
            publicKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPublicKeysFieldBuilder()
                    : null;
          } else {
            publicKeysBuilder_.addAllMessages(other.publicKeys_);
          }
        }
      }
      if (!other.getDelegationServiceAccountEmail().isEmpty()) {
        delegationServiceAccountEmail_ = other.delegationServiceAccountEmail_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                noteReference_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey m =
                    input.readMessage(
                        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.parser(),
                        extensionRegistry);
                if (publicKeysBuilder_ == null) {
                  ensurePublicKeysIsMutable();
                  publicKeys_.add(m);
                } else {
                  publicKeysBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                delegationServiceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object noteReference_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
     * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
     *
     * An attestation by this attestor is stored as a Drydock
     * ATTESTATION_AUTHORITY Occurrence that names a container image and that
     * links to this Note. Drydock is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The noteReference.
     */
    public java.lang.String getNoteReference() {
      java.lang.Object ref = noteReference_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        noteReference_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
     * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
     *
     * An attestation by this attestor is stored as a Drydock
     * ATTESTATION_AUTHORITY Occurrence that names a container image and that
     * links to this Note. Drydock is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for noteReference.
     */
    public com.google.protobuf.ByteString getNoteReferenceBytes() {
      java.lang.Object ref = noteReference_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        noteReference_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
     * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
     *
     * An attestation by this attestor is stored as a Drydock
     * ATTESTATION_AUTHORITY Occurrence that names a container image and that
     * links to this Note. Drydock is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The noteReference to set.
     * @return This builder for chaining.
     */
    public Builder setNoteReference(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      noteReference_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
     * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
     *
     * An attestation by this attestor is stored as a Drydock
     * ATTESTATION_AUTHORITY Occurrence that names a container image and that
     * links to this Note. Drydock is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoteReference() {
      noteReference_ = getDefaultInstance().getNoteReference();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
     * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
     * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
     *
     * An attestation by this attestor is stored as a Drydock
     * ATTESTATION_AUTHORITY Occurrence that names a container image and that
     * links to this Note. Drydock is an external dependency.
     * </pre>
     *
     * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for noteReference to set.
     * @return This builder for chaining.
     */
    public Builder setNoteReferenceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      noteReference_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
        publicKeys_ = java.util.Collections.emptyList();

    private void ensurePublicKeysIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        publicKeys_ =
            new java.util.ArrayList<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>(
                publicKeys_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey,
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>
        publicKeysBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
        getPublicKeysList() {
      if (publicKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(publicKeys_);
      } else {
        return publicKeysBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPublicKeysCount() {
      if (publicKeysBuilder_ == null) {
        return publicKeys_.size();
      } else {
        return publicKeysBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey getPublicKeys(int index) {
      if (publicKeysBuilder_ == null) {
        return publicKeys_.get(index);
      } else {
        return publicKeysBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPublicKeys(
        int index, com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey value) {
      if (publicKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicKeysIsMutable();
        publicKeys_.set(index, value);
        onChanged();
      } else {
        publicKeysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPublicKeys(
        int index,
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder builderForValue) {
      if (publicKeysBuilder_ == null) {
        ensurePublicKeysIsMutable();
        publicKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        publicKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPublicKeys(
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey value) {
      if (publicKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicKeysIsMutable();
        publicKeys_.add(value);
        onChanged();
      } else {
        publicKeysBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPublicKeys(
        int index, com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey value) {
      if (publicKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePublicKeysIsMutable();
        publicKeys_.add(index, value);
        onChanged();
      } else {
        publicKeysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPublicKeys(
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder builderForValue) {
      if (publicKeysBuilder_ == null) {
        ensurePublicKeysIsMutable();
        publicKeys_.add(builderForValue.build());
        onChanged();
      } else {
        publicKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPublicKeys(
        int index,
        com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder builderForValue) {
      if (publicKeysBuilder_ == null) {
        ensurePublicKeysIsMutable();
        publicKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        publicKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPublicKeys(
        java.lang.Iterable<? extends com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
            values) {
      if (publicKeysBuilder_ == null) {
        ensurePublicKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, publicKeys_);
        onChanged();
      } else {
        publicKeysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPublicKeys() {
      if (publicKeysBuilder_ == null) {
        publicKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        publicKeysBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePublicKeys(int index) {
      if (publicKeysBuilder_ == null) {
        ensurePublicKeysIsMutable();
        publicKeys_.remove(index);
        onChanged();
      } else {
        publicKeysBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder
        getPublicKeysBuilder(int index) {
      return getPublicKeysFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder
        getPublicKeysOrBuilder(int index) {
      if (publicKeysBuilder_ == null) {
        return publicKeys_.get(index);
      } else {
        return publicKeysBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>
        getPublicKeysOrBuilderList() {
      if (publicKeysBuilder_ != null) {
        return publicKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(publicKeys_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder
        addPublicKeysBuilder() {
      return getPublicKeysFieldBuilder()
          .addBuilder(
              com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder
        addPublicKeysBuilder(int index) {
      return getPublicKeysFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Public keys that verify attestations signed by this
     * attestor.  This field may be updated.
     *
     * If this field is non-empty, one of the specified public keys must
     * verify that an attestation was signed by this attestor for the
     * image specified in the admission request.
     *
     * If this field is empty, this attestor always returns that no
     * valid attestations exist.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder>
        getPublicKeysBuilderList() {
      return getPublicKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey,
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>
        getPublicKeysFieldBuilder() {
      if (publicKeysBuilder_ == null) {
        publicKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey,
                com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey.Builder,
                com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>(
                publicKeys_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        publicKeys_ = null;
      }
      return publicKeysBuilder_;
    }

    private java.lang.Object delegationServiceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The delegationServiceAccountEmail.
     */
    public java.lang.String getDelegationServiceAccountEmail() {
      java.lang.Object ref = delegationServiceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        delegationServiceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for delegationServiceAccountEmail.
     */
    public com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes() {
      java.lang.Object ref = delegationServiceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        delegationServiceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The delegationServiceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setDelegationServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      delegationServiceAccountEmail_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDelegationServiceAccountEmail() {
      delegationServiceAccountEmail_ = getDefaultInstance().getDelegationServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field will contain the service account email address
     * that this Attestor will use as the principal when querying Container
     * Analysis. Attestor administrators must grant this service account the
     * IAM role needed to read attestations from the [note_reference][Note] in
     * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
     *
     * This email address is fixed for the lifetime of the Attestor, but callers
     * should not make any other assumptions about the service account email;
     * future versions may use an email based on a different naming pattern.
     * </pre>
     *
     * <code>
     * string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for delegationServiceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setDelegationServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      delegationServiceAccountEmail_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
  private static final com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserOwnedDrydockNote> PARSER =
      new com.google.protobuf.AbstractParser<UserOwnedDrydockNote>() {
        @java.lang.Override
        public UserOwnedDrydockNote parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserOwnedDrydockNote> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserOwnedDrydockNote> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
