/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * An [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] that attests to container image
 * artifacts. An existing attestor cannot be modified except where
 * indicated.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.Attestor}
 */
public final class Attestor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.Attestor)
    AttestorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Attestor.newBuilder() to construct.
  private Attestor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Attestor() {
    name_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Attestor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_Attestor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_Attestor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.Attestor.class,
            com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder.class);
  }

  private int attestorTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object attestorType_;

  public enum AttestorTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_OWNED_DRYDOCK_NOTE(3),
    ATTESTORTYPE_NOT_SET(0);
    private final int value;

    private AttestorTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttestorTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static AttestorTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return USER_OWNED_DRYDOCK_NOTE;
        case 0:
          return ATTESTORTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AttestorTypeCase getAttestorTypeCase() {
    return AttestorTypeCase.forNumber(attestorTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name, in the format:
   * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name, in the format:
   * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.  This field may be updated.
   * The field may be displayed in chooser dialogs.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.  This field may be updated.
   * The field may be displayed in chooser dialogs.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_OWNED_DRYDOCK_NOTE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
   * </code>
   *
   * @return Whether the userOwnedDrydockNote field is set.
   */
  @java.lang.Override
  public boolean hasUserOwnedDrydockNote() {
    return attestorTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
   * </code>
   *
   * @return The userOwnedDrydockNote.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
      getUserOwnedDrydockNote() {
    if (attestorTypeCase_ == 3) {
      return (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder
      getUserOwnedDrydockNoteOrBuilder() {
    if (attestorTypeCase_ == 3) {
      return (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_;
    }
    return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.getDefaultInstance();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the attestor was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the attestor was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the attestor was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (attestorTypeCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_);
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (attestorTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.Attestor)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.Attestor other =
        (com.google.cloud.binaryauthorization.v1beta1.Attestor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getAttestorTypeCase().equals(other.getAttestorTypeCase())) return false;
    switch (attestorTypeCase_) {
      case 3:
        if (!getUserOwnedDrydockNote().equals(other.getUserOwnedDrydockNote())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (attestorTypeCase_) {
      case 3:
        hash = (37 * hash) + USER_OWNED_DRYDOCK_NOTE_FIELD_NUMBER;
        hash = (53 * hash) + getUserOwnedDrydockNote().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.binaryauthorization.v1beta1.Attestor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An [attestor][google.cloud.binaryauthorization.v1beta1.Attestor] that attests to container image
   * artifacts. An existing attestor cannot be modified except where
   * indicated.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.Attestor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.Attestor)
      com.google.cloud.binaryauthorization.v1beta1.AttestorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Attestor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Attestor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.Attestor.class,
              com.google.cloud.binaryauthorization.v1beta1.Attestor.Builder.class);
    }

    // Construct using com.google.cloud.binaryauthorization.v1beta1.Attestor.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      if (userOwnedDrydockNoteBuilder_ != null) {
        userOwnedDrydockNoteBuilder_.clear();
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      attestorTypeCase_ = 0;
      attestorType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Attestor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Attestor getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.Attestor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Attestor build() {
      com.google.cloud.binaryauthorization.v1beta1.Attestor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Attestor buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.Attestor result =
          new com.google.cloud.binaryauthorization.v1beta1.Attestor(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.binaryauthorization.v1beta1.Attestor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.binaryauthorization.v1beta1.Attestor result) {
      result.attestorTypeCase_ = attestorTypeCase_;
      result.attestorType_ = this.attestorType_;
      if (attestorTypeCase_ == 3 && userOwnedDrydockNoteBuilder_ != null) {
        result.attestorType_ = userOwnedDrydockNoteBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.Attestor) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.Attestor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.binaryauthorization.v1beta1.Attestor other) {
      if (other == com.google.cloud.binaryauthorization.v1beta1.Attestor.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getAttestorTypeCase()) {
        case USER_OWNED_DRYDOCK_NOTE:
          {
            mergeUserOwnedDrydockNote(other.getUserOwnedDrydockNote());
            break;
          }
        case ATTESTORTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getUserOwnedDrydockNoteFieldBuilder().getBuilder(), extensionRegistry);
                attestorTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int attestorTypeCase_ = 0;
    private java.lang.Object attestorType_;

    public AttestorTypeCase getAttestorTypeCase() {
      return AttestorTypeCase.forNumber(attestorTypeCase_);
    }

    public Builder clearAttestorType() {
      attestorTypeCase_ = 0;
      attestorType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name, in the format:
     * `projects/&#42;&#47;attestors/&#42;`. This field may not be updated.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.  This field may be updated.
     * The field may be displayed in chooser dialogs.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote,
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder,
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder>
        userOwnedDrydockNoteBuilder_;
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     *
     * @return Whether the userOwnedDrydockNote field is set.
     */
    @java.lang.Override
    public boolean hasUserOwnedDrydockNote() {
      return attestorTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     *
     * @return The userOwnedDrydockNote.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
        getUserOwnedDrydockNote() {
      if (userOwnedDrydockNoteBuilder_ == null) {
        if (attestorTypeCase_ == 3) {
          return (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
            .getDefaultInstance();
      } else {
        if (attestorTypeCase_ == 3) {
          return userOwnedDrydockNoteBuilder_.getMessage();
        }
        return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    public Builder setUserOwnedDrydockNote(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote value) {
      if (userOwnedDrydockNoteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attestorType_ = value;
        onChanged();
      } else {
        userOwnedDrydockNoteBuilder_.setMessage(value);
      }
      attestorTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    public Builder setUserOwnedDrydockNote(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder builderForValue) {
      if (userOwnedDrydockNoteBuilder_ == null) {
        attestorType_ = builderForValue.build();
        onChanged();
      } else {
        userOwnedDrydockNoteBuilder_.setMessage(builderForValue.build());
      }
      attestorTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    public Builder mergeUserOwnedDrydockNote(
        com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote value) {
      if (userOwnedDrydockNoteBuilder_ == null) {
        if (attestorTypeCase_ == 3
            && attestorType_
                != com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
                    .getDefaultInstance()) {
          attestorType_ =
              com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.newBuilder(
                      (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
                          attestorType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          attestorType_ = value;
        }
        onChanged();
      } else {
        if (attestorTypeCase_ == 3) {
          userOwnedDrydockNoteBuilder_.mergeFrom(value);
        } else {
          userOwnedDrydockNoteBuilder_.setMessage(value);
        }
      }
      attestorTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    public Builder clearUserOwnedDrydockNote() {
      if (userOwnedDrydockNoteBuilder_ == null) {
        if (attestorTypeCase_ == 3) {
          attestorTypeCase_ = 0;
          attestorType_ = null;
          onChanged();
        }
      } else {
        if (attestorTypeCase_ == 3) {
          attestorTypeCase_ = 0;
          attestorType_ = null;
        }
        userOwnedDrydockNoteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder
        getUserOwnedDrydockNoteBuilder() {
      return getUserOwnedDrydockNoteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder
        getUserOwnedDrydockNoteOrBuilder() {
      if ((attestorTypeCase_ == 3) && (userOwnedDrydockNoteBuilder_ != null)) {
        return userOwnedDrydockNoteBuilder_.getMessageOrBuilder();
      } else {
        if (attestorTypeCase_ == 3) {
          return (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_;
        }
        return com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A Drydock ATTESTATION_AUTHORITY Note, created by the user.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote user_owned_drydock_note = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote,
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder,
            com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder>
        getUserOwnedDrydockNoteFieldBuilder() {
      if (userOwnedDrydockNoteBuilder_ == null) {
        if (!(attestorTypeCase_ == 3)) {
          attestorType_ =
              com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote
                  .getDefaultInstance();
        }
        userOwnedDrydockNoteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote,
                com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote.Builder,
                com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNoteOrBuilder>(
                (com.google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote) attestorType_,
                getParentForChildren(),
                isClean());
        attestorType_ = null;
      }
      attestorTypeCase_ = 3;
      onChanged();
      return userOwnedDrydockNoteBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the attestor was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.Attestor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.Attestor)
  private static final com.google.cloud.binaryauthorization.v1beta1.Attestor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.Attestor();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Attestor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Attestor> PARSER =
      new com.google.protobuf.AbstractParser<Attestor>() {
        @java.lang.Override
        public Attestor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Attestor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Attestor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.Attestor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
