/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

/**
 *
 *
 * <pre>
 * A [policy][google.cloud.binaryauthorization.v1beta1.Policy] for Binary Authorization.
 * </pre>
 *
 * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.Policy}
 */
public final class Policy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.binaryauthorization.v1beta1.Policy)
    PolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Policy.newBuilder() to construct.
  private Policy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Policy() {
    name_ = "";
    description_ = "";
    globalPolicyEvaluationMode_ = 0;
    admissionWhitelistPatterns_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Policy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetClusterAdmissionRules();
      case 10:
        return internalGetKubernetesNamespaceAdmissionRules();
      case 8:
        return internalGetKubernetesServiceAccountAdmissionRules();
      case 9:
        return internalGetIstioServiceIdentityAdmissionRules();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
        .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.binaryauthorization.v1beta1.Policy.class,
            com.google.cloud.binaryauthorization.v1beta1.Policy.Builder.class);
  }

  /**
   * Protobuf enum {@code
   * google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode}
   */
  public enum GlobalPolicyEvaluationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified: DISABLE is assumed.
     * </pre>
     *
     * <code>GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED = 0;</code>
     */
    GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Enables system policy evaluation.
     * </pre>
     *
     * <code>ENABLE = 1;</code>
     */
    ENABLE(1),
    /**
     *
     *
     * <pre>
     * Disables system policy evaluation.
     * </pre>
     *
     * <code>DISABLE = 2;</code>
     */
    DISABLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified: DISABLE is assumed.
     * </pre>
     *
     * <code>GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Enables system policy evaluation.
     * </pre>
     *
     * <code>ENABLE = 1;</code>
     */
    public static final int ENABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Disables system policy evaluation.
     * </pre>
     *
     * <code>DISABLE = 2;</code>
     */
    public static final int DISABLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static GlobalPolicyEvaluationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static GlobalPolicyEvaluationMode forNumber(int value) {
      switch (value) {
        case 0:
          return GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED;
        case 1:
          return ENABLE;
        case 2:
          return DISABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<GlobalPolicyEvaluationMode>() {
              public GlobalPolicyEvaluationMode findValueByNumber(int number) {
                return GlobalPolicyEvaluationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.Policy.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final GlobalPolicyEvaluationMode[] VALUES = values();

    public static GlobalPolicyEvaluationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private GlobalPolicyEvaluationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
   * at most one policy per project.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
   * at most one policy per project.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GLOBAL_POLICY_EVALUATION_MODE_FIELD_NUMBER = 7;
  private int globalPolicyEvaluationMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Controls the evaluation of a Google-maintained global admission
   * policy for common system-level images. Images not covered by the global
   * policy will be subject to the project admission policy. This setting
   * has no effect when specified inside a global admission policy.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
   */
  @java.lang.Override
  public int getGlobalPolicyEvaluationModeValue() {
    return globalPolicyEvaluationMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Controls the evaluation of a Google-maintained global admission
   * policy for common system-level images. Images not covered by the global
   * policy will be subject to the project admission policy. This setting
   * has no effect when specified inside a global admission policy.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The globalPolicyEvaluationMode.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
      getGlobalPolicyEvaluationMode() {
    com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode result =
        com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode.forNumber(
            globalPolicyEvaluationMode_);
    return result == null
        ? com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
            .UNRECOGNIZED
        : result;
  }

  public static final int ADMISSION_WHITELIST_PATTERNS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
      admissionWhitelistPatterns_;
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
      getAdmissionWhitelistPatternsList() {
    return admissionWhitelistPatterns_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>
      getAdmissionWhitelistPatternsOrBuilderList() {
    return admissionWhitelistPatterns_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAdmissionWhitelistPatternsCount() {
    return admissionWhitelistPatterns_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
      getAdmissionWhitelistPatterns(int index) {
    return admissionWhitelistPatterns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder
      getAdmissionWhitelistPatternsOrBuilder(int index) {
    return admissionWhitelistPatterns_.get(index);
  }

  public static final int CLUSTER_ADMISSION_RULES_FIELD_NUMBER = 3;

  private static final class ClusterAdmissionRulesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    newDefaultInstance(
                        com.google.cloud.binaryauthorization.v1beta1
                            .BinaryAuthorizationResourcesProto
                            .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_ClusterAdmissionRulesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      clusterAdmissionRules_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      internalGetClusterAdmissionRules() {
    if (clusterAdmissionRules_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ClusterAdmissionRulesDefaultEntryHolder.defaultEntry);
    }
    return clusterAdmissionRules_;
  }

  public int getClusterAdmissionRulesCount() {
    return internalGetClusterAdmissionRules().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsClusterAdmissionRules(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetClusterAdmissionRules().getMap().containsKey(key);
  }
  /** Use {@link #getClusterAdmissionRulesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getClusterAdmissionRules() {
    return getClusterAdmissionRulesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getClusterAdmissionRulesMap() {
    return internalGetClusterAdmissionRules().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getClusterAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetClusterAdmissionRules().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getClusterAdmissionRulesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetClusterAdmissionRules().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KUBERNETES_NAMESPACE_ADMISSION_RULES_FIELD_NUMBER = 10;

  private static final class KubernetesNamespaceAdmissionRulesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    newDefaultInstance(
                        com.google.cloud.binaryauthorization.v1beta1
                            .BinaryAuthorizationResourcesProto
                            .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_KubernetesNamespaceAdmissionRulesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      kubernetesNamespaceAdmissionRules_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      internalGetKubernetesNamespaceAdmissionRules() {
    if (kubernetesNamespaceAdmissionRules_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry);
    }
    return kubernetesNamespaceAdmissionRules_;
  }

  public int getKubernetesNamespaceAdmissionRulesCount() {
    return internalGetKubernetesNamespaceAdmissionRules().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetKubernetesNamespaceAdmissionRules().getMap().containsKey(key);
  }
  /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesNamespaceAdmissionRules() {
    return getKubernetesNamespaceAdmissionRulesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesNamespaceAdmissionRulesMap() {
    return internalGetKubernetesNamespaceAdmissionRules().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesNamespaceAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetKubernetesNamespaceAdmissionRules().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetKubernetesNamespaceAdmissionRules().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KUBERNETES_SERVICE_ACCOUNT_ADMISSION_RULES_FIELD_NUMBER = 8;

  private static final class KubernetesServiceAccountAdmissionRulesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    newDefaultInstance(
                        com.google.cloud.binaryauthorization.v1beta1
                            .BinaryAuthorizationResourcesProto
                            .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_KubernetesServiceAccountAdmissionRulesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      kubernetesServiceAccountAdmissionRules_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      internalGetKubernetesServiceAccountAdmissionRules() {
    if (kubernetesServiceAccountAdmissionRules_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry);
    }
    return kubernetesServiceAccountAdmissionRules_;
  }

  public int getKubernetesServiceAccountAdmissionRulesCount() {
    return internalGetKubernetesServiceAccountAdmissionRules().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetKubernetesServiceAccountAdmissionRules().getMap().containsKey(key);
  }
  /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesServiceAccountAdmissionRules() {
    return getKubernetesServiceAccountAdmissionRulesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesServiceAccountAdmissionRulesMap() {
    return internalGetKubernetesServiceAccountAdmissionRules().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesServiceAccountAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ISTIO_SERVICE_IDENTITY_ADMISSION_RULES_FIELD_NUMBER = 9;

  private static final class IstioServiceIdentityAdmissionRulesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    newDefaultInstance(
                        com.google.cloud.binaryauthorization.v1beta1
                            .BinaryAuthorizationResourcesProto
                            .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_IstioServiceIdentityAdmissionRulesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      istioServiceIdentityAdmissionRules_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      internalGetIstioServiceIdentityAdmissionRules() {
    if (istioServiceIdentityAdmissionRules_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry);
    }
    return istioServiceIdentityAdmissionRules_;
  }

  public int getIstioServiceIdentityAdmissionRulesCount() {
    return internalGetIstioServiceIdentityAdmissionRules().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetIstioServiceIdentityAdmissionRules().getMap().containsKey(key);
  }
  /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getIstioServiceIdentityAdmissionRules() {
    return getIstioServiceIdentityAdmissionRulesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getIstioServiceIdentityAdmissionRulesMap() {
    return internalGetIstioServiceIdentityAdmissionRules().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getIstioServiceIdentityAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetIstioServiceIdentityAdmissionRules().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        map = internalGetIstioServiceIdentityAdmissionRules().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DEFAULT_ADMISSION_RULE_FIELD_NUMBER = 4;
  private com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultAdmissionRule_;
  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the defaultAdmissionRule field is set.
   */
  @java.lang.Override
  public boolean hasDefaultAdmissionRule() {
    return defaultAdmissionRule_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The defaultAdmissionRule.
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultAdmissionRule() {
    return defaultAdmissionRule_ == null
        ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance()
        : defaultAdmissionRule_;
  }
  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder
      getDefaultAdmissionRuleOrBuilder() {
    return defaultAdmissionRule_ == null
        ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance()
        : defaultAdmissionRule_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < admissionWhitelistPatterns_.size(); i++) {
      output.writeMessage(2, admissionWhitelistPatterns_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetClusterAdmissionRules(),
        ClusterAdmissionRulesDefaultEntryHolder.defaultEntry,
        3);
    if (defaultAdmissionRule_ != null) {
      output.writeMessage(4, getDefaultAdmissionRule());
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (globalPolicyEvaluationMode_
        != com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
            .GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, globalPolicyEvaluationMode_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetKubernetesServiceAccountAdmissionRules(),
        KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry,
        8);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetIstioServiceIdentityAdmissionRules(),
        IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry,
        9);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetKubernetesNamespaceAdmissionRules(),
        KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry,
        10);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < admissionWhitelistPatterns_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, admissionWhitelistPatterns_.get(i));
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        entry : internalGetClusterAdmissionRules().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          clusterAdmissionRules__ =
              ClusterAdmissionRulesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, clusterAdmissionRules__);
    }
    if (defaultAdmissionRule_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDefaultAdmissionRule());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (globalPolicyEvaluationMode_
        != com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
            .GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, globalPolicyEvaluationMode_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        entry : internalGetKubernetesServiceAccountAdmissionRules().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          kubernetesServiceAccountAdmissionRules__ =
              KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, kubernetesServiceAccountAdmissionRules__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        entry : internalGetIstioServiceIdentityAdmissionRules().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          istioServiceIdentityAdmissionRules__ =
              IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, istioServiceIdentityAdmissionRules__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        entry : internalGetKubernetesNamespaceAdmissionRules().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          kubernetesNamespaceAdmissionRules__ =
              KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, kubernetesNamespaceAdmissionRules__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.binaryauthorization.v1beta1.Policy)) {
      return super.equals(obj);
    }
    com.google.cloud.binaryauthorization.v1beta1.Policy other =
        (com.google.cloud.binaryauthorization.v1beta1.Policy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (globalPolicyEvaluationMode_ != other.globalPolicyEvaluationMode_) return false;
    if (!getAdmissionWhitelistPatternsList().equals(other.getAdmissionWhitelistPatternsList()))
      return false;
    if (!internalGetClusterAdmissionRules().equals(other.internalGetClusterAdmissionRules()))
      return false;
    if (!internalGetKubernetesNamespaceAdmissionRules()
        .equals(other.internalGetKubernetesNamespaceAdmissionRules())) return false;
    if (!internalGetKubernetesServiceAccountAdmissionRules()
        .equals(other.internalGetKubernetesServiceAccountAdmissionRules())) return false;
    if (!internalGetIstioServiceIdentityAdmissionRules()
        .equals(other.internalGetIstioServiceIdentityAdmissionRules())) return false;
    if (hasDefaultAdmissionRule() != other.hasDefaultAdmissionRule()) return false;
    if (hasDefaultAdmissionRule()) {
      if (!getDefaultAdmissionRule().equals(other.getDefaultAdmissionRule())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + GLOBAL_POLICY_EVALUATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + globalPolicyEvaluationMode_;
    if (getAdmissionWhitelistPatternsCount() > 0) {
      hash = (37 * hash) + ADMISSION_WHITELIST_PATTERNS_FIELD_NUMBER;
      hash = (53 * hash) + getAdmissionWhitelistPatternsList().hashCode();
    }
    if (!internalGetClusterAdmissionRules().getMap().isEmpty()) {
      hash = (37 * hash) + CLUSTER_ADMISSION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetClusterAdmissionRules().hashCode();
    }
    if (!internalGetKubernetesNamespaceAdmissionRules().getMap().isEmpty()) {
      hash = (37 * hash) + KUBERNETES_NAMESPACE_ADMISSION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetKubernetesNamespaceAdmissionRules().hashCode();
    }
    if (!internalGetKubernetesServiceAccountAdmissionRules().getMap().isEmpty()) {
      hash = (37 * hash) + KUBERNETES_SERVICE_ACCOUNT_ADMISSION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetKubernetesServiceAccountAdmissionRules().hashCode();
    }
    if (!internalGetIstioServiceIdentityAdmissionRules().getMap().isEmpty()) {
      hash = (37 * hash) + ISTIO_SERVICE_IDENTITY_ADMISSION_RULES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetIstioServiceIdentityAdmissionRules().hashCode();
    }
    if (hasDefaultAdmissionRule()) {
      hash = (37 * hash) + DEFAULT_ADMISSION_RULE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultAdmissionRule().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.binaryauthorization.v1beta1.Policy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [policy][google.cloud.binaryauthorization.v1beta1.Policy] for Binary Authorization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.binaryauthorization.v1beta1.Policy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.binaryauthorization.v1beta1.Policy)
      com.google.cloud.binaryauthorization.v1beta1.PolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetClusterAdmissionRules();
        case 10:
          return internalGetKubernetesNamespaceAdmissionRules();
        case 8:
          return internalGetKubernetesServiceAccountAdmissionRules();
        case 9:
          return internalGetIstioServiceIdentityAdmissionRules();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableClusterAdmissionRules();
        case 10:
          return internalGetMutableKubernetesNamespaceAdmissionRules();
        case 8:
          return internalGetMutableKubernetesServiceAccountAdmissionRules();
        case 9:
          return internalGetMutableIstioServiceIdentityAdmissionRules();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.binaryauthorization.v1beta1.Policy.class,
              com.google.cloud.binaryauthorization.v1beta1.Policy.Builder.class);
    }

    // Construct using com.google.cloud.binaryauthorization.v1beta1.Policy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      globalPolicyEvaluationMode_ = 0;
      if (admissionWhitelistPatternsBuilder_ == null) {
        admissionWhitelistPatterns_ = java.util.Collections.emptyList();
      } else {
        admissionWhitelistPatterns_ = null;
        admissionWhitelistPatternsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableClusterAdmissionRules().clear();
      internalGetMutableKubernetesNamespaceAdmissionRules().clear();
      internalGetMutableKubernetesServiceAccountAdmissionRules().clear();
      internalGetMutableIstioServiceIdentityAdmissionRules().clear();
      defaultAdmissionRule_ = null;
      if (defaultAdmissionRuleBuilder_ != null) {
        defaultAdmissionRuleBuilder_.dispose();
        defaultAdmissionRuleBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.binaryauthorization.v1beta1.BinaryAuthorizationResourcesProto
          .internal_static_google_cloud_binaryauthorization_v1beta1_Policy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Policy getDefaultInstanceForType() {
      return com.google.cloud.binaryauthorization.v1beta1.Policy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Policy build() {
      com.google.cloud.binaryauthorization.v1beta1.Policy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Policy buildPartial() {
      com.google.cloud.binaryauthorization.v1beta1.Policy result =
          new com.google.cloud.binaryauthorization.v1beta1.Policy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.binaryauthorization.v1beta1.Policy result) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          admissionWhitelistPatterns_ =
              java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.admissionWhitelistPatterns_ = admissionWhitelistPatterns_;
      } else {
        result.admissionWhitelistPatterns_ = admissionWhitelistPatternsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.binaryauthorization.v1beta1.Policy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.globalPolicyEvaluationMode_ = globalPolicyEvaluationMode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.clusterAdmissionRules_ = internalGetClusterAdmissionRules();
        result.clusterAdmissionRules_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kubernetesNamespaceAdmissionRules_ = internalGetKubernetesNamespaceAdmissionRules();
        result.kubernetesNamespaceAdmissionRules_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kubernetesServiceAccountAdmissionRules_ =
            internalGetKubernetesServiceAccountAdmissionRules();
        result.kubernetesServiceAccountAdmissionRules_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.istioServiceIdentityAdmissionRules_ =
            internalGetIstioServiceIdentityAdmissionRules();
        result.istioServiceIdentityAdmissionRules_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.defaultAdmissionRule_ =
            defaultAdmissionRuleBuilder_ == null
                ? defaultAdmissionRule_
                : defaultAdmissionRuleBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.binaryauthorization.v1beta1.Policy) {
        return mergeFrom((com.google.cloud.binaryauthorization.v1beta1.Policy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.binaryauthorization.v1beta1.Policy other) {
      if (other == com.google.cloud.binaryauthorization.v1beta1.Policy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.globalPolicyEvaluationMode_ != 0) {
        setGlobalPolicyEvaluationModeValue(other.getGlobalPolicyEvaluationModeValue());
      }
      if (admissionWhitelistPatternsBuilder_ == null) {
        if (!other.admissionWhitelistPatterns_.isEmpty()) {
          if (admissionWhitelistPatterns_.isEmpty()) {
            admissionWhitelistPatterns_ = other.admissionWhitelistPatterns_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAdmissionWhitelistPatternsIsMutable();
            admissionWhitelistPatterns_.addAll(other.admissionWhitelistPatterns_);
          }
          onChanged();
        }
      } else {
        if (!other.admissionWhitelistPatterns_.isEmpty()) {
          if (admissionWhitelistPatternsBuilder_.isEmpty()) {
            admissionWhitelistPatternsBuilder_.dispose();
            admissionWhitelistPatternsBuilder_ = null;
            admissionWhitelistPatterns_ = other.admissionWhitelistPatterns_;
            bitField0_ = (bitField0_ & ~0x00000008);
            admissionWhitelistPatternsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdmissionWhitelistPatternsFieldBuilder()
                    : null;
          } else {
            admissionWhitelistPatternsBuilder_.addAllMessages(other.admissionWhitelistPatterns_);
          }
        }
      }
      internalGetMutableClusterAdmissionRules().mergeFrom(other.internalGetClusterAdmissionRules());
      bitField0_ |= 0x00000010;
      internalGetMutableKubernetesNamespaceAdmissionRules()
          .mergeFrom(other.internalGetKubernetesNamespaceAdmissionRules());
      bitField0_ |= 0x00000020;
      internalGetMutableKubernetesServiceAccountAdmissionRules()
          .mergeFrom(other.internalGetKubernetesServiceAccountAdmissionRules());
      bitField0_ |= 0x00000040;
      internalGetMutableIstioServiceIdentityAdmissionRules()
          .mergeFrom(other.internalGetIstioServiceIdentityAdmissionRules());
      bitField0_ |= 0x00000080;
      if (other.hasDefaultAdmissionRule()) {
        mergeDefaultAdmissionRule(other.getDefaultAdmissionRule());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern m =
                    input.readMessage(
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
                            .parser(),
                        extensionRegistry);
                if (admissionWhitelistPatternsBuilder_ == null) {
                  ensureAdmissionWhitelistPatternsIsMutable();
                  admissionWhitelistPatterns_.add(m);
                } else {
                  admissionWhitelistPatternsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    clusterAdmissionRules__ =
                        input.readMessage(
                            ClusterAdmissionRulesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableClusterAdmissionRules()
                    .getMutableMap()
                    .put(clusterAdmissionRules__.getKey(), clusterAdmissionRules__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getDefaultAdmissionRuleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 56:
              {
                globalPolicyEvaluationMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            case 66:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    kubernetesServiceAccountAdmissionRules__ =
                        input.readMessage(
                            KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableKubernetesServiceAccountAdmissionRules()
                    .getMutableMap()
                    .put(
                        kubernetesServiceAccountAdmissionRules__.getKey(),
                        kubernetesServiceAccountAdmissionRules__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    istioServiceIdentityAdmissionRules__ =
                        input.readMessage(
                            IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableIstioServiceIdentityAdmissionRules()
                    .getMutableMap()
                    .put(
                        istioServiceIdentityAdmissionRules__.getKey(),
                        istioServiceIdentityAdmissionRules__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
                    kubernetesNamespaceAdmissionRules__ =
                        input.readMessage(
                            KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableKubernetesNamespaceAdmissionRules()
                    .getMutableMap()
                    .put(
                        kubernetesNamespaceAdmissionRules__.getKey(),
                        kubernetesNamespaceAdmissionRules__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
     * at most one policy per project.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A descriptive comment.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int globalPolicyEvaluationMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
     */
    @java.lang.Override
    public int getGlobalPolicyEvaluationModeValue() {
      return globalPolicyEvaluationMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for globalPolicyEvaluationMode to set.
     * @return This builder for chaining.
     */
    public Builder setGlobalPolicyEvaluationModeValue(int value) {
      globalPolicyEvaluationMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The globalPolicyEvaluationMode.
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
        getGlobalPolicyEvaluationMode() {
      com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode result =
          com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode.forNumber(
              globalPolicyEvaluationMode_);
      return result == null
          ? com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The globalPolicyEvaluationMode to set.
     * @return This builder for chaining.
     */
    public Builder setGlobalPolicyEvaluationMode(
        com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      globalPolicyEvaluationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Controls the evaluation of a Google-maintained global admission
     * policy for common system-level images. Images not covered by the global
     * policy will be subject to the project admission policy. This setting
     * has no effect when specified inside a global admission policy.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGlobalPolicyEvaluationMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      globalPolicyEvaluationMode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
        admissionWhitelistPatterns_ = java.util.Collections.emptyList();

    private void ensureAdmissionWhitelistPatternsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        admissionWhitelistPatterns_ =
            new java.util.ArrayList<
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>(
                admissionWhitelistPatterns_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>
        admissionWhitelistPatternsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
        getAdmissionWhitelistPatternsList() {
      if (admissionWhitelistPatternsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
      } else {
        return admissionWhitelistPatternsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAdmissionWhitelistPatternsCount() {
      if (admissionWhitelistPatternsBuilder_ == null) {
        return admissionWhitelistPatterns_.size();
      } else {
        return admissionWhitelistPatternsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
        getAdmissionWhitelistPatterns(int index) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        return admissionWhitelistPatterns_.get(index);
      } else {
        return admissionWhitelistPatternsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdmissionWhitelistPatterns(
        int index, com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern value) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.set(index, value);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdmissionWhitelistPatterns(
        int index,
        com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
            builderForValue) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.set(index, builderForValue.build());
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAdmissionWhitelistPatterns(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern value) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.add(value);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAdmissionWhitelistPatterns(
        int index, com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern value) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.add(index, value);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAdmissionWhitelistPatterns(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
            builderForValue) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.add(builderForValue.build());
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAdmissionWhitelistPatterns(
        int index,
        com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
            builderForValue) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.add(index, builderForValue.build());
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAdmissionWhitelistPatterns(
        java.lang.Iterable<
                ? extends com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
            values) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        ensureAdmissionWhitelistPatternsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, admissionWhitelistPatterns_);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAdmissionWhitelistPatterns() {
      if (admissionWhitelistPatternsBuilder_ == null) {
        admissionWhitelistPatterns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAdmissionWhitelistPatterns(int index) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        ensureAdmissionWhitelistPatternsIsMutable();
        admissionWhitelistPatterns_.remove(index);
        onChanged();
      } else {
        admissionWhitelistPatternsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
        getAdmissionWhitelistPatternsBuilder(int index) {
      return getAdmissionWhitelistPatternsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder
        getAdmissionWhitelistPatternsOrBuilder(int index) {
      if (admissionWhitelistPatternsBuilder_ == null) {
        return admissionWhitelistPatterns_.get(index);
      } else {
        return admissionWhitelistPatternsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>
        getAdmissionWhitelistPatternsOrBuilderList() {
      if (admissionWhitelistPatternsBuilder_ != null) {
        return admissionWhitelistPatternsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(admissionWhitelistPatterns_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
        addAdmissionWhitelistPatternsBuilder() {
      return getAdmissionWhitelistPatternsFieldBuilder()
          .addBuilder(
              com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder
        addAdmissionWhitelistPatternsBuilder(int index) {
      return getAdmissionWhitelistPatternsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Admission policy allowlisting. A matching admission request will
     * always be permitted. This feature is typically used to exclude Google or
     * third-party infrastructure images from Binary Authorization policies.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder>
        getAdmissionWhitelistPatternsBuilderList() {
      return getAdmissionWhitelistPatternsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>
        getAdmissionWhitelistPatternsFieldBuilder() {
      if (admissionWhitelistPatternsBuilder_ == null) {
        admissionWhitelistPatternsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern,
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern.Builder,
                com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>(
                admissionWhitelistPatterns_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        admissionWhitelistPatterns_ = null;
      }
      return admissionWhitelistPatternsBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        clusterAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetClusterAdmissionRules() {
      if (clusterAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ClusterAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return clusterAdmissionRules_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetMutableClusterAdmissionRules() {
      if (clusterAdmissionRules_ == null) {
        clusterAdmissionRules_ =
            com.google.protobuf.MapField.newMapField(
                ClusterAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      if (!clusterAdmissionRules_.isMutable()) {
        clusterAdmissionRules_ = clusterAdmissionRules_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return clusterAdmissionRules_;
    }

    public int getClusterAdmissionRulesCount() {
      return internalGetClusterAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsClusterAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetClusterAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getClusterAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getClusterAdmissionRules() {
      return getClusterAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getClusterAdmissionRulesMap() {
      return internalGetClusterAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getClusterAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetClusterAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getClusterAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetClusterAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearClusterAdmissionRules() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableClusterAdmissionRules().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeClusterAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableClusterAdmissionRules().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getMutableClusterAdmissionRules() {
      bitField0_ |= 0x00000010;
      return internalGetMutableClusterAdmissionRules().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putClusterAdmissionRules(
        java.lang.String key, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableClusterAdmissionRules().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-cluster admission rules. Cluster spec format:
     * `location.clusterId`. There can be at most one admission rule per cluster
     * spec.
     * A `location` is either a compute zone (e.g. us-central1-a) or a region
     * (e.g. us-central1).
     * For `clusterId` syntax restrictions see
     * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllClusterAdmissionRules(
        java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
            values) {
      internalGetMutableClusterAdmissionRules().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        kubernetesNamespaceAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetKubernetesNamespaceAdmissionRules() {
      if (kubernetesNamespaceAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return kubernetesNamespaceAdmissionRules_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetMutableKubernetesNamespaceAdmissionRules() {
      if (kubernetesNamespaceAdmissionRules_ == null) {
        kubernetesNamespaceAdmissionRules_ =
            com.google.protobuf.MapField.newMapField(
                KubernetesNamespaceAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      if (!kubernetesNamespaceAdmissionRules_.isMutable()) {
        kubernetesNamespaceAdmissionRules_ = kubernetesNamespaceAdmissionRules_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return kubernetesNamespaceAdmissionRules_;
    }

    public int getKubernetesNamespaceAdmissionRulesCount() {
      return internalGetKubernetesNamespaceAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetKubernetesNamespaceAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getKubernetesNamespaceAdmissionRules() {
      return getKubernetesNamespaceAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getKubernetesNamespaceAdmissionRulesMap() {
      return internalGetKubernetesNamespaceAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetKubernetesNamespaceAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetKubernetesNamespaceAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearKubernetesNamespaceAdmissionRules() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableKubernetesNamespaceAdmissionRules().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeKubernetesNamespaceAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableKubernetesNamespaceAdmissionRules().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getMutableKubernetesNamespaceAdmissionRules() {
      bitField0_ |= 0x00000020;
      return internalGetMutableKubernetesNamespaceAdmissionRules().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putKubernetesNamespaceAdmissionRules(
        java.lang.String key, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableKubernetesNamespaceAdmissionRules().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
     *   `[a-z.-]+`, e.g. `some-namespace`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllKubernetesNamespaceAdmissionRules(
        java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
            values) {
      internalGetMutableKubernetesNamespaceAdmissionRules().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        kubernetesServiceAccountAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetKubernetesServiceAccountAdmissionRules() {
      if (kubernetesServiceAccountAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return kubernetesServiceAccountAdmissionRules_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetMutableKubernetesServiceAccountAdmissionRules() {
      if (kubernetesServiceAccountAdmissionRules_ == null) {
        kubernetesServiceAccountAdmissionRules_ =
            com.google.protobuf.MapField.newMapField(
                KubernetesServiceAccountAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      if (!kubernetesServiceAccountAdmissionRules_.isMutable()) {
        kubernetesServiceAccountAdmissionRules_ = kubernetesServiceAccountAdmissionRules_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return kubernetesServiceAccountAdmissionRules_;
    }

    public int getKubernetesServiceAccountAdmissionRulesCount() {
      return internalGetKubernetesServiceAccountAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetKubernetesServiceAccountAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getKubernetesServiceAccountAdmissionRules() {
      return getKubernetesServiceAccountAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getKubernetesServiceAccountAdmissionRulesMap() {
      return internalGetKubernetesServiceAccountAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetKubernetesServiceAccountAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearKubernetesServiceAccountAdmissionRules() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableKubernetesServiceAccountAdmissionRules().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeKubernetesServiceAccountAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableKubernetesServiceAccountAdmissionRules().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getMutableKubernetesServiceAccountAdmissionRules() {
      bitField0_ |= 0x00000040;
      return internalGetMutableKubernetesServiceAccountAdmissionRules().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putKubernetesServiceAccountAdmissionRules(
        java.lang.String key, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableKubernetesServiceAccountAdmissionRules().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-kubernetes-service-account admission rules. Service account
     * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllKubernetesServiceAccountAdmissionRules(
        java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
            values) {
      internalGetMutableKubernetesServiceAccountAdmissionRules().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        istioServiceIdentityAdmissionRules_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetIstioServiceIdentityAdmissionRules() {
      if (istioServiceIdentityAdmissionRules_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      return istioServiceIdentityAdmissionRules_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        internalGetMutableIstioServiceIdentityAdmissionRules() {
      if (istioServiceIdentityAdmissionRules_ == null) {
        istioServiceIdentityAdmissionRules_ =
            com.google.protobuf.MapField.newMapField(
                IstioServiceIdentityAdmissionRulesDefaultEntryHolder.defaultEntry);
      }
      if (!istioServiceIdentityAdmissionRules_.isMutable()) {
        istioServiceIdentityAdmissionRules_ = istioServiceIdentityAdmissionRules_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return istioServiceIdentityAdmissionRules_;
    }

    public int getIstioServiceIdentityAdmissionRulesCount() {
      return internalGetIstioServiceIdentityAdmissionRules().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIstioServiceIdentityAdmissionRules().getMap().containsKey(key);
    }
    /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getIstioServiceIdentityAdmissionRules() {
      return getIstioServiceIdentityAdmissionRulesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getIstioServiceIdentityAdmissionRulesMap() {
      return internalGetIstioServiceIdentityAdmissionRules().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetIstioServiceIdentityAdmissionRules().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
        getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
          map = internalGetIstioServiceIdentityAdmissionRules().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearIstioServiceIdentityAdmissionRules() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableIstioServiceIdentityAdmissionRules().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeIstioServiceIdentityAdmissionRules(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableIstioServiceIdentityAdmissionRules().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
        getMutableIstioServiceIdentityAdmissionRules() {
      bitField0_ |= 0x00000080;
      return internalGetMutableIstioServiceIdentityAdmissionRules().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putIstioServiceIdentityAdmissionRules(
        java.lang.String key, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableIstioServiceIdentityAdmissionRules().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per-istio-service-identity admission rules. Istio service
     * identity spec format:
     * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
     * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
     * e.g. `spiffe://example.com/ns/test-ns/sa/default`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllIstioServiceIdentityAdmissionRules(
        java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
            values) {
      internalGetMutableIstioServiceIdentityAdmissionRules().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultAdmissionRule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder>
        defaultAdmissionRuleBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the defaultAdmissionRule field is set.
     */
    public boolean hasDefaultAdmissionRule() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The defaultAdmissionRule.
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultAdmissionRule() {
      if (defaultAdmissionRuleBuilder_ == null) {
        return defaultAdmissionRule_ == null
            ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance()
            : defaultAdmissionRule_;
      } else {
        return defaultAdmissionRuleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDefaultAdmissionRule(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (defaultAdmissionRuleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultAdmissionRule_ = value;
      } else {
        defaultAdmissionRuleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDefaultAdmissionRule(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder builderForValue) {
      if (defaultAdmissionRuleBuilder_ == null) {
        defaultAdmissionRule_ = builderForValue.build();
      } else {
        defaultAdmissionRuleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDefaultAdmissionRule(
        com.google.cloud.binaryauthorization.v1beta1.AdmissionRule value) {
      if (defaultAdmissionRuleBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && defaultAdmissionRule_ != null
            && defaultAdmissionRule_
                != com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
                    .getDefaultInstance()) {
          getDefaultAdmissionRuleBuilder().mergeFrom(value);
        } else {
          defaultAdmissionRule_ = value;
        }
      } else {
        defaultAdmissionRuleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDefaultAdmissionRule() {
      bitField0_ = (bitField0_ & ~0x00000100);
      defaultAdmissionRule_ = null;
      if (defaultAdmissionRuleBuilder_ != null) {
        defaultAdmissionRuleBuilder_.dispose();
        defaultAdmissionRuleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder
        getDefaultAdmissionRuleBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDefaultAdmissionRuleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder
        getDefaultAdmissionRuleOrBuilder() {
      if (defaultAdmissionRuleBuilder_ != null) {
        return defaultAdmissionRuleBuilder_.getMessageOrBuilder();
      } else {
        return defaultAdmissionRule_ == null
            ? com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.getDefaultInstance()
            : defaultAdmissionRule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Default admission rule for a cluster without a per-cluster, per-
     * kubernetes-service-account, or per-istio-service-identity admission rule.
     * </pre>
     *
     * <code>
     * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder,
            com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder>
        getDefaultAdmissionRuleFieldBuilder() {
      if (defaultAdmissionRuleBuilder_ == null) {
        defaultAdmissionRuleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.binaryauthorization.v1beta1.AdmissionRule,
                com.google.cloud.binaryauthorization.v1beta1.AdmissionRule.Builder,
                com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder>(
                getDefaultAdmissionRule(), getParentForChildren(), isClean());
        defaultAdmissionRule_ = null;
      }
      return defaultAdmissionRuleBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the policy was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.binaryauthorization.v1beta1.Policy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.binaryauthorization.v1beta1.Policy)
  private static final com.google.cloud.binaryauthorization.v1beta1.Policy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.binaryauthorization.v1beta1.Policy();
  }

  public static com.google.cloud.binaryauthorization.v1beta1.Policy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Policy> PARSER =
      new com.google.protobuf.AbstractParser<Policy>() {
        @java.lang.Override
        public Policy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Policy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Policy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.binaryauthorization.v1beta1.Policy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
