/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

public interface PolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.Policy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
   * at most one policy per project.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. The resource name, in the format `projects/&#42;&#47;policy`. There is
   * at most one policy per project.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Optional. A descriptive comment.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Optional. Controls the evaluation of a Google-maintained global admission
   * policy for common system-level images. Images not covered by the global
   * policy will be subject to the project admission policy. This setting
   * has no effect when specified inside a global admission policy.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for globalPolicyEvaluationMode.
   */
  int getGlobalPolicyEvaluationModeValue();
  /**
   *
   *
   * <pre>
   * Optional. Controls the evaluation of a Google-maintained global admission
   * policy for common system-level images. Images not covered by the global
   * policy will be subject to the project admission policy. This setting
   * has no effect when specified inside a global admission policy.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode global_policy_evaluation_mode = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The globalPolicyEvaluationMode.
   */
  com.google.cloud.binaryauthorization.v1beta1.Policy.GlobalPolicyEvaluationMode
      getGlobalPolicyEvaluationMode();

  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern>
      getAdmissionWhitelistPatternsList();
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern
      getAdmissionWhitelistPatterns(int index);
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAdmissionWhitelistPatternsCount();
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder>
      getAdmissionWhitelistPatternsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Admission policy allowlisting. A matching admission request will
   * always be permitted. This feature is typically used to exclude Google or
   * third-party infrastructure images from Binary Authorization policies.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPattern admission_whitelist_patterns = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionWhitelistPatternOrBuilder
      getAdmissionWhitelistPatternsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getClusterAdmissionRulesCount();
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsClusterAdmissionRules(java.lang.String key);
  /** Use {@link #getClusterAdmissionRulesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getClusterAdmissionRules();
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getClusterAdmissionRulesMap();
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getClusterAdmissionRulesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Per-cluster admission rules. Cluster spec format:
   * `location.clusterId`. There can be at most one admission rule per cluster
   * spec.
   * A `location` is either a compute zone (e.g. us-central1-a) or a region
   * (e.g. us-central1).
   * For `clusterId` syntax restrictions see
   * https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; cluster_admission_rules = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getClusterAdmissionRulesOrThrow(
      java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getKubernetesNamespaceAdmissionRulesCount();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsKubernetesNamespaceAdmissionRules(java.lang.String key);
  /** Use {@link #getKubernetesNamespaceAdmissionRulesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesNamespaceAdmissionRules();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesNamespaceAdmissionRulesMap();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesNamespaceAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-namespace admission rules. K8s namespace spec format:
   *   `[a-z.-]+`, e.g. `some-namespace`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_namespace_admission_rules = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesNamespaceAdmissionRulesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getKubernetesServiceAccountAdmissionRulesCount();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsKubernetesServiceAccountAdmissionRules(java.lang.String key);
  /** Use {@link #getKubernetesServiceAccountAdmissionRulesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesServiceAccountAdmissionRules();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getKubernetesServiceAccountAdmissionRulesMap();
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesServiceAccountAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Per-kubernetes-service-account admission rules. Service account
   * spec format: `namespace:serviceaccount`. e.g. `test-ns:default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; kubernetes_service_account_admission_rules = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getKubernetesServiceAccountAdmissionRulesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getIstioServiceIdentityAdmissionRulesCount();
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsIstioServiceIdentityAdmissionRules(java.lang.String key);
  /** Use {@link #getIstioServiceIdentityAdmissionRulesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getIstioServiceIdentityAdmissionRules();
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, com.google.cloud.binaryauthorization.v1beta1.AdmissionRule>
      getIstioServiceIdentityAdmissionRulesMap();
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getIstioServiceIdentityAdmissionRulesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.binaryauthorization.v1beta1.AdmissionRule defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Per-istio-service-identity admission rules. Istio service
   * identity spec format:
   * `spiffe://&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;` or
   * `&lt;domain&gt;/ns/&lt;namespace&gt;/sa/&lt;serviceaccount&gt;`
   * e.g. `spiffe://example.com/ns/test-ns/sa/default`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.binaryauthorization.v1beta1.AdmissionRule&gt; istio_service_identity_admission_rules = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule
      getIstioServiceIdentityAdmissionRulesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the defaultAdmissionRule field is set.
   */
  boolean hasDefaultAdmissionRule();
  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The defaultAdmissionRule.
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRule getDefaultAdmissionRule();
  /**
   *
   *
   * <pre>
   * Required. Default admission rule for a cluster without a per-cluster, per-
   * kubernetes-service-account, or per-istio-service-identity admission rule.
   * </pre>
   *
   * <code>
   * .google.cloud.binaryauthorization.v1beta1.AdmissionRule default_admission_rule = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AdmissionRuleOrBuilder
      getDefaultAdmissionRuleOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time when the policy was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();
}
