/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/binaryauthorization/v1beta1/resources.proto

package com.google.cloud.binaryauthorization.v1beta1;

public interface UserOwnedDrydockNoteOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.binaryauthorization.v1beta1.UserOwnedDrydockNote)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
   * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
   * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
   *
   * An attestation by this attestor is stored as a Drydock
   * ATTESTATION_AUTHORITY Occurrence that names a container image and that
   * links to this Note. Drydock is an external dependency.
   * </pre>
   *
   * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The noteReference.
   */
  java.lang.String getNoteReference();
  /**
   *
   *
   * <pre>
   * Required. The Drydock resource name of a ATTESTATION_AUTHORITY Note,
   * created by the user, in the format: `projects/&#42;&#47;notes/&#42;` (or the legacy
   * `providers/&#42;&#47;notes/&#42;`). This field may not be updated.
   *
   * An attestation by this attestor is stored as a Drydock
   * ATTESTATION_AUTHORITY Occurrence that names a container image and that
   * links to this Note. Drydock is an external dependency.
   * </pre>
   *
   * <code>string note_reference = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for noteReference.
   */
  com.google.protobuf.ByteString getNoteReferenceBytes();

  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey>
      getPublicKeysList();
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKey getPublicKeys(int index);
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getPublicKeysCount();
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder>
      getPublicKeysOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Public keys that verify attestations signed by this
   * attestor.  This field may be updated.
   *
   * If this field is non-empty, one of the specified public keys must
   * verify that an attestation was signed by this attestor for the
   * image specified in the admission request.
   *
   * If this field is empty, this attestor always returns that no
   * valid attestations exist.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.binaryauthorization.v1beta1.AttestorPublicKey public_keys = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.binaryauthorization.v1beta1.AttestorPublicKeyOrBuilder getPublicKeysOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. This field will contain the service account email address
   * that this Attestor will use as the principal when querying Container
   * Analysis. Attestor administrators must grant this service account the
   * IAM role needed to read attestations from the [note_reference][Note] in
   * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
   *
   * This email address is fixed for the lifetime of the Attestor, but callers
   * should not make any other assumptions about the service account email;
   * future versions may use an email based on a different naming pattern.
   * </pre>
   *
   * <code>string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The delegationServiceAccountEmail.
   */
  java.lang.String getDelegationServiceAccountEmail();
  /**
   *
   *
   * <pre>
   * Output only. This field will contain the service account email address
   * that this Attestor will use as the principal when querying Container
   * Analysis. Attestor administrators must grant this service account the
   * IAM role needed to read attestations from the [note_reference][Note] in
   * Container Analysis (`containeranalysis.notes.occurrences.viewer`).
   *
   * This email address is fixed for the lifetime of the Attestor, but callers
   * should not make any other assumptions about the service account email;
   * future versions may use an email based on a different naming pattern.
   * </pre>
   *
   * <code>string delegation_service_account_email = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for delegationServiceAccountEmail.
   */
  com.google.protobuf.ByteString getDelegationServiceAccountEmailBytes();
}
