/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Artifacts produced by a build that should be uploaded upon
 * successful completion of all build steps.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts}
 */
public final class Artifacts extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts)
    ArtifactsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Artifacts.newBuilder() to construct.
  private Artifacts(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Artifacts() {
    images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Artifacts();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Artifacts(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                images_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              images_.add(s);
              break;
            }
          case 18:
            {
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder subBuilder = null;
              if (objects_ != null) {
                subBuilder = objects_.toBuilder();
              }
              objects_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.Artifacts.ArtifactObjects.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(objects_);
                objects_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        images_ = images_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Artifacts_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Artifacts.class,
            com.google.cloudbuild.v1.Artifacts.Builder.class);
  }

  public interface ArtifactObjectsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    java.util.List<java.lang.String> getPathsList();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    int getPathsCount();
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    java.lang.String getPaths(int index);
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    com.google.protobuf.ByteString getPathsBytes(int index);

    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     *
     * @return Whether the timing field is set.
     */
    boolean hasTiming();
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     *
     * @return The timing.
     */
    com.google.cloudbuild.v1.TimeSpan getTiming();
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     */
    com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Files in the workspace to upload to Cloud Storage upon successful
   * completion of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects}
   */
  public static final class ArtifactObjects extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
      ArtifactObjectsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ArtifactObjects.newBuilder() to construct.
    private ArtifactObjects(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ArtifactObjects() {
      location_ = "";
      paths_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ArtifactObjects();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ArtifactObjects(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                location_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  paths_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                paths_.add(s);
                break;
              }
            case 26:
              {
                com.google.cloudbuild.v1.TimeSpan.Builder subBuilder = null;
                if (timing_ != null) {
                  subBuilder = timing_.toBuilder();
                }
                timing_ =
                    input.readMessage(
                        com.google.cloudbuild.v1.TimeSpan.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(timing_);
                  timing_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          paths_ = paths_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.class,
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder.class);
    }

    public static final int LOCATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object location_;
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket and optional object path, in the form
     * "gs://bucket/path/to/somewhere/". (see [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Files in the workspace matching any path pattern will be uploaded to
     * Cloud Storage with this location as a prefix.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATHS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList paths_;
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return A list containing the paths.
     */
    public com.google.protobuf.ProtocolStringList getPathsList() {
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @return The count of paths.
     */
    public int getPathsCount() {
      return paths_.size();
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The paths at the given index.
     */
    public java.lang.String getPaths(int index) {
      return paths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Path globs used to match files in the build's workspace.
     * </pre>
     *
     * <code>repeated string paths = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the paths at the given index.
     */
    public com.google.protobuf.ByteString getPathsBytes(int index) {
      return paths_.getByteString(index);
    }

    public static final int TIMING_FIELD_NUMBER = 3;
    private com.google.cloudbuild.v1.TimeSpan timing_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     *
     * @return Whether the timing field is set.
     */
    @java.lang.Override
    public boolean hasTiming() {
      return timing_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     *
     * @return The timing.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpan getTiming() {
      return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pushing all artifact objects.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
      return getTiming();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      for (int i = 0; i < paths_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, paths_.getRaw(i));
      }
      if (timing_ != null) {
        output.writeMessage(3, getTiming());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < paths_.size(); i++) {
          dataSize += computeStringSizeNoTag(paths_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathsList().size();
      }
      if (timing_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTiming());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Artifacts.ArtifactObjects)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Artifacts.ArtifactObjects other =
          (com.google.cloudbuild.v1.Artifacts.ArtifactObjects) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getPathsList().equals(other.getPathsList())) return false;
      if (hasTiming() != other.hasTiming()) return false;
      if (hasTiming()) {
        if (!getTiming().equals(other.getTiming())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      if (getPathsCount() > 0) {
        hash = (37 * hash) + PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getPathsList().hashCode();
      }
      if (hasTiming()) {
        hash = (37 * hash) + TIMING_FIELD_NUMBER;
        hash = (53 * hash) + getTiming().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts.ArtifactObjects prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Files in the workspace to upload to Cloud Storage upon successful
     * completion of all build steps.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
        com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.class,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Artifacts.ArtifactObjects.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        location_ = "";

        paths_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (timingBuilder_ == null) {
          timing_ = null;
        } else {
          timing_ = null;
          timingBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Artifacts_ArtifactObjects_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects build() {
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Artifacts.ArtifactObjects buildPartial() {
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects result =
            new com.google.cloudbuild.v1.Artifacts.ArtifactObjects(this);
        int from_bitField0_ = bitField0_;
        result.location_ = location_;
        if (((bitField0_ & 0x00000001) != 0)) {
          paths_ = paths_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.paths_ = paths_;
        if (timingBuilder_ == null) {
          result.timing_ = timing_;
        } else {
          result.timing_ = timingBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Artifacts.ArtifactObjects) {
          return mergeFrom((com.google.cloudbuild.v1.Artifacts.ArtifactObjects) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts.ArtifactObjects other) {
        if (other == com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance())
          return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.paths_.isEmpty()) {
          if (paths_.isEmpty()) {
            paths_ = other.paths_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePathsIsMutable();
            paths_.addAll(other.paths_);
          }
          onChanged();
        }
        if (other.hasTiming()) {
          mergeTiming(other.getTiming());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloudbuild.v1.Artifacts.ArtifactObjects) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        location_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {

        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage bucket and optional object path, in the form
       * "gs://bucket/path/to/somewhere/". (see [Bucket Name
       * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
       * Files in the workspace matching any path pattern will be uploaded to
       * Cloud Storage with this location as a prefix.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        location_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList paths_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensurePathsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          paths_ = new com.google.protobuf.LazyStringArrayList(paths_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return A list containing the paths.
       */
      public com.google.protobuf.ProtocolStringList getPathsList() {
        return paths_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return The count of paths.
       */
      public int getPathsCount() {
        return paths_.size();
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The paths at the given index.
       */
      public java.lang.String getPaths(int index) {
        return paths_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the paths at the given index.
       */
      public com.google.protobuf.ByteString getPathsBytes(int index) {
        return paths_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The paths to set.
       * @return This builder for chaining.
       */
      public Builder setPaths(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The paths to add.
       * @return This builder for chaining.
       */
      public Builder addPaths(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathsIsMutable();
        paths_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param values The paths to add.
       * @return This builder for chaining.
       */
      public Builder addAllPaths(java.lang.Iterable<java.lang.String> values) {
        ensurePathsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paths_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPaths() {
        paths_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path globs used to match files in the build's workspace.
       * </pre>
       *
       * <code>repeated string paths = 2;</code>
       *
       * @param value The bytes of the paths to add.
       * @return This builder for chaining.
       */
      public Builder addPathsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePathsIsMutable();
        paths_.add(value);
        onChanged();
        return this;
      }

      private com.google.cloudbuild.v1.TimeSpan timing_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloudbuild.v1.TimeSpan,
              com.google.cloudbuild.v1.TimeSpan.Builder,
              com.google.cloudbuild.v1.TimeSpanOrBuilder>
          timingBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       *
       * @return Whether the timing field is set.
       */
      public boolean hasTiming() {
        return timingBuilder_ != null || timing_ != null;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       *
       * @return The timing.
       */
      public com.google.cloudbuild.v1.TimeSpan getTiming() {
        if (timingBuilder_ == null) {
          return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
        } else {
          return timingBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public Builder setTiming(com.google.cloudbuild.v1.TimeSpan value) {
        if (timingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timing_ = value;
          onChanged();
        } else {
          timingBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public Builder setTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
        if (timingBuilder_ == null) {
          timing_ = builderForValue.build();
          onChanged();
        } else {
          timingBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public Builder mergeTiming(com.google.cloudbuild.v1.TimeSpan value) {
        if (timingBuilder_ == null) {
          if (timing_ != null) {
            timing_ =
                com.google.cloudbuild.v1.TimeSpan.newBuilder(timing_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timing_ = value;
          }
          onChanged();
        } else {
          timingBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public Builder clearTiming() {
        if (timingBuilder_ == null) {
          timing_ = null;
          onChanged();
        } else {
          timing_ = null;
          timingBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public com.google.cloudbuild.v1.TimeSpan.Builder getTimingBuilder() {

        onChanged();
        return getTimingFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
        if (timingBuilder_ != null) {
          return timingBuilder_.getMessageOrBuilder();
        } else {
          return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Stores timing information for pushing all artifact objects.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.TimeSpan timing = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloudbuild.v1.TimeSpan,
              com.google.cloudbuild.v1.TimeSpan.Builder,
              com.google.cloudbuild.v1.TimeSpanOrBuilder>
          getTimingFieldBuilder() {
        if (timingBuilder_ == null) {
          timingBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloudbuild.v1.TimeSpan,
                  com.google.cloudbuild.v1.TimeSpan.Builder,
                  com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                  getTiming(), getParentForChildren(), isClean());
          timing_ = null;
        }
        return timingBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects)
    private static final com.google.cloudbuild.v1.Artifacts.ArtifactObjects DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts.ArtifactObjects();
    }

    public static com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ArtifactObjects> PARSER =
        new com.google.protobuf.AbstractParser<ArtifactObjects>() {
          @java.lang.Override
          public ArtifactObjects parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ArtifactObjects(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ArtifactObjects> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactObjects> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int IMAGES_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList images_;
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return A list containing the images.
   */
  public com.google.protobuf.ProtocolStringList getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return The count of images.
   */
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The images at the given index.
   */
  public java.lang.String getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the images at the given index.
   */
  public com.google.protobuf.ByteString getImagesBytes(int index) {
    return images_.getByteString(index);
  }

  public static final int OBJECTS_FIELD_NUMBER = 2;
  private com.google.cloudbuild.v1.Artifacts.ArtifactObjects objects_;
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return Whether the objects field is set.
   */
  @java.lang.Override
  public boolean hasObjects() {
    return objects_ != null;
  }
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return The objects.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getObjects() {
    return objects_ == null
        ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
        : objects_;
  }
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder getObjectsOrBuilder() {
    return getObjects();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < images_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, images_.getRaw(i));
    }
    if (objects_ != null) {
      output.writeMessage(2, getObjects());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < images_.size(); i++) {
        dataSize += computeStringSizeNoTag(images_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getImagesList().size();
    }
    if (objects_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getObjects());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Artifacts)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Artifacts other = (com.google.cloudbuild.v1.Artifacts) obj;

    if (!getImagesList().equals(other.getImagesList())) return false;
    if (hasObjects() != other.hasObjects()) return false;
    if (hasObjects()) {
      if (!getObjects().equals(other.getObjects())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (hasObjects()) {
      hash = (37 * hash) + OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getObjects().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Artifacts parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Artifacts prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by a build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Artifacts}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Artifacts)
      com.google.cloudbuild.v1.ArtifactsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Artifacts.class,
              com.google.cloudbuild.v1.Artifacts.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Artifacts.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (objectsBuilder_ == null) {
        objects_ = null;
      } else {
        objects_ = null;
        objectsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Artifacts_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Artifacts.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts build() {
      com.google.cloudbuild.v1.Artifacts result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Artifacts buildPartial() {
      com.google.cloudbuild.v1.Artifacts result = new com.google.cloudbuild.v1.Artifacts(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        images_ = images_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.images_ = images_;
      if (objectsBuilder_ == null) {
        result.objects_ = objects_;
      } else {
        result.objects_ = objectsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Artifacts) {
        return mergeFrom((com.google.cloudbuild.v1.Artifacts) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Artifacts other) {
      if (other == com.google.cloudbuild.v1.Artifacts.getDefaultInstance()) return this;
      if (!other.images_.isEmpty()) {
        if (images_.isEmpty()) {
          images_ = other.images_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureImagesIsMutable();
          images_.addAll(other.images_);
        }
        onChanged();
      }
      if (other.hasObjects()) {
        mergeObjects(other.getObjects());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.Artifacts parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.Artifacts) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList images_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureImagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        images_ = new com.google.protobuf.LazyStringArrayList(images_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return A list containing the images.
     */
    public com.google.protobuf.ProtocolStringList getImagesList() {
      return images_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return The count of images.
     */
    public int getImagesCount() {
      return images_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The images at the given index.
     */
    public java.lang.String getImages(int index) {
      return images_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the images at the given index.
     */
    public com.google.protobuf.ByteString getImagesBytes(int index) {
      return images_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The images to set.
     * @return This builder for chaining.
     */
    public Builder setImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param value The images to add.
     * @return This builder for chaining.
     */
    public Builder addImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param values The images to add.
     * @return This builder for chaining.
     */
    public Builder addAllImages(java.lang.Iterable<java.lang.String> values) {
      ensureImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImages() {
      images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images will be pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's
     * results field.
     * If any of the images fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>repeated string images = 1;</code>
     *
     * @param value The bytes of the images to add.
     * @return This builder for chaining.
     */
    public Builder addImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureImagesIsMutable();
      images_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Artifacts.ArtifactObjects objects_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>
        objectsBuilder_;
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     *
     * @return Whether the objects field is set.
     */
    public boolean hasObjects() {
      return objectsBuilder_ != null || objects_ != null;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     *
     * @return The objects.
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects getObjects() {
      if (objectsBuilder_ == null) {
        return objects_ == null
            ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
            : objects_;
      } else {
        return objectsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder setObjects(com.google.cloudbuild.v1.Artifacts.ArtifactObjects value) {
      if (objectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objects_ = value;
        onChanged();
      } else {
        objectsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder setObjects(
        com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder builderForValue) {
      if (objectsBuilder_ == null) {
        objects_ = builderForValue.build();
        onChanged();
      } else {
        objectsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder mergeObjects(com.google.cloudbuild.v1.Artifacts.ArtifactObjects value) {
      if (objectsBuilder_ == null) {
        if (objects_ != null) {
          objects_ =
              com.google.cloudbuild.v1.Artifacts.ArtifactObjects.newBuilder(objects_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          objects_ = value;
        }
        onChanged();
      } else {
        objectsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public Builder clearObjects() {
      if (objectsBuilder_ == null) {
        objects_ = null;
        onChanged();
      } else {
        objects_ = null;
        objectsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder getObjectsBuilder() {

      onChanged();
      return getObjectsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder getObjectsOrBuilder() {
      if (objectsBuilder_ != null) {
        return objectsBuilder_.getMessageOrBuilder();
      } else {
        return objects_ == null
            ? com.google.cloudbuild.v1.Artifacts.ArtifactObjects.getDefaultInstance()
            : objects_;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of objects to be uploaded to Cloud Storage upon successful
     * completion of all build steps.
     * Files in the workspace matching specified paths globs will be uploaded to
     * the specified Cloud Storage location using the builder service account's
     * credentials.
     * The location and generation of the uploaded objects will be stored in the
     * Build resource's results field.
     * If any objects fail to be pushed, the build is marked FAILURE.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
            com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>
        getObjectsFieldBuilder() {
      if (objectsBuilder_ == null) {
        objectsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjects.Builder,
                com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder>(
                getObjects(), getParentForChildren(), isClean());
        objects_ = null;
      }
      return objectsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Artifacts)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Artifacts)
  private static final com.google.cloudbuild.v1.Artifacts DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Artifacts();
  }

  public static com.google.cloudbuild.v1.Artifacts getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Artifacts> PARSER =
      new com.google.protobuf.AbstractParser<Artifacts>() {
        @java.lang.Override
        public Artifacts parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Artifacts(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Artifacts> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Artifacts> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
