/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

public interface ArtifactsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Artifacts)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return A list containing the images.
   */
  java.util.List<java.lang.String> getImagesList();
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @return The count of images.
   */
  int getImagesCount();
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The images at the given index.
   */
  java.lang.String getImages(int index);
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images will be pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the Build resource's
   * results field.
   * If any of the images fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>repeated string images = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the images at the given index.
   */
  com.google.protobuf.ByteString getImagesBytes(int index);

  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return Whether the objects field is set.
   */
  boolean hasObjects();
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   *
   * @return The objects.
   */
  com.google.cloudbuild.v1.Artifacts.ArtifactObjects getObjects();
  /**
   *
   *
   * <pre>
   * A list of objects to be uploaded to Cloud Storage upon successful
   * completion of all build steps.
   * Files in the workspace matching specified paths globs will be uploaded to
   * the specified Cloud Storage location using the builder service account's
   * credentials.
   * The location and generation of the uploaded objects will be stored in the
   * Build resource's results field.
   * If any objects fail to be pushed, the build is marked FAILURE.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects objects = 2;</code>
   */
  com.google.cloudbuild.v1.Artifacts.ArtifactObjectsOrBuilder getObjectsOrBuilder();
}
