/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Optional arguments to enable specific features of builds.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.BuildOptions}
 */
public final class BuildOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.BuildOptions)
    BuildOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildOptions.newBuilder() to construct.
  private BuildOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildOptions() {
    sourceProvenanceHash_ = java.util.Collections.emptyList();
    requestedVerifyOption_ = 0;
    machineType_ = 0;
    substitutionOption_ = 0;
    logStreamingOption_ = 0;
    workerPool_ = "";
    logging_ = 0;
    env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    volumes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildOptions();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BuildOptions(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                sourceProvenanceHash_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              sourceProvenanceHash_.add(rawValue);
              break;
            }
          case 10:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  sourceProvenanceHash_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                sourceProvenanceHash_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              requestedVerifyOption_ = rawValue;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              machineType_ = rawValue;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              substitutionOption_ = rawValue;
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              logStreamingOption_ = rawValue;
              break;
            }
          case 48:
            {
              diskSizeGb_ = input.readInt64();
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              workerPool_ = s;
              break;
            }
          case 88:
            {
              int rawValue = input.readEnum();

              logging_ = rawValue;
              break;
            }
          case 98:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                env_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              env_.add(s);
              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                secretEnv_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              secretEnv_.add(s);
              break;
            }
          case 114:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                volumes_ = new java.util.ArrayList<com.google.cloudbuild.v1.Volume>();
                mutable_bitField0_ |= 0x00000008;
              }
              volumes_.add(
                  input.readMessage(com.google.cloudbuild.v1.Volume.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        sourceProvenanceHash_ = java.util.Collections.unmodifiableList(sourceProvenanceHash_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        env_ = env_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        secretEnv_ = secretEnv_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        volumes_ = java.util.Collections.unmodifiableList(volumes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.BuildOptions.class,
            com.google.cloudbuild.v1.BuildOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the manner in which the build should be verified, if at all.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.BuildOptions.VerifyOption}
   */
  public enum VerifyOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not a verifiable build. (default)
     * </pre>
     *
     * <code>NOT_VERIFIED = 0;</code>
     */
    NOT_VERIFIED(0),
    /**
     *
     *
     * <pre>
     * Verified build.
     * </pre>
     *
     * <code>VERIFIED = 1;</code>
     */
    VERIFIED(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not a verifiable build. (default)
     * </pre>
     *
     * <code>NOT_VERIFIED = 0;</code>
     */
    public static final int NOT_VERIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Verified build.
     * </pre>
     *
     * <code>VERIFIED = 1;</code>
     */
    public static final int VERIFIED_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VerifyOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VerifyOption forNumber(int value) {
      switch (value) {
        case 0:
          return NOT_VERIFIED;
        case 1:
          return VERIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VerifyOption> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VerifyOption> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VerifyOption>() {
          public VerifyOption findValueByNumber(int number) {
            return VerifyOption.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.BuildOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final VerifyOption[] VALUES = values();

    public static VerifyOption valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VerifyOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.BuildOptions.VerifyOption)
  }

  /**
   *
   *
   * <pre>
   * Supported VM sizes.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.BuildOptions.MachineType}
   */
  public enum MachineType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Standard machine type.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Highcpu machine with 8 CPUs.
     * </pre>
     *
     * <code>N1_HIGHCPU_8 = 1;</code>
     */
    N1_HIGHCPU_8(1),
    /**
     *
     *
     * <pre>
     * Highcpu machine with 32 CPUs.
     * </pre>
     *
     * <code>N1_HIGHCPU_32 = 2;</code>
     */
    N1_HIGHCPU_32(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Standard machine type.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Highcpu machine with 8 CPUs.
     * </pre>
     *
     * <code>N1_HIGHCPU_8 = 1;</code>
     */
    public static final int N1_HIGHCPU_8_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Highcpu machine with 32 CPUs.
     * </pre>
     *
     * <code>N1_HIGHCPU_32 = 2;</code>
     */
    public static final int N1_HIGHCPU_32_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MachineType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MachineType forNumber(int value) {
      switch (value) {
        case 0:
          return UNSPECIFIED;
        case 1:
          return N1_HIGHCPU_8;
        case 2:
          return N1_HIGHCPU_32;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MachineType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MachineType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MachineType>() {
          public MachineType findValueByNumber(int number) {
            return MachineType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.BuildOptions.getDescriptor().getEnumTypes().get(1);
    }

    private static final MachineType[] VALUES = values();

    public static MachineType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MachineType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.BuildOptions.MachineType)
  }

  /**
   *
   *
   * <pre>
   * Specifies the behavior when there is an error in the substitution checks.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption}
   */
  public enum SubstitutionOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Fails the build if error in substitutions checks, like missing
     * a substitution in the template or in the map.
     * </pre>
     *
     * <code>MUST_MATCH = 0;</code>
     */
    MUST_MATCH(0),
    /**
     *
     *
     * <pre>
     * Do not fail the build if error in substitutions checks.
     * </pre>
     *
     * <code>ALLOW_LOOSE = 1;</code>
     */
    ALLOW_LOOSE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Fails the build if error in substitutions checks, like missing
     * a substitution in the template or in the map.
     * </pre>
     *
     * <code>MUST_MATCH = 0;</code>
     */
    public static final int MUST_MATCH_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Do not fail the build if error in substitutions checks.
     * </pre>
     *
     * <code>ALLOW_LOOSE = 1;</code>
     */
    public static final int ALLOW_LOOSE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SubstitutionOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SubstitutionOption forNumber(int value) {
      switch (value) {
        case 0:
          return MUST_MATCH;
        case 1:
          return ALLOW_LOOSE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SubstitutionOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SubstitutionOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SubstitutionOption>() {
              public SubstitutionOption findValueByNumber(int number) {
                return SubstitutionOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.BuildOptions.getDescriptor().getEnumTypes().get(2);
    }

    private static final SubstitutionOption[] VALUES = values();

    public static SubstitutionOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SubstitutionOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption)
  }

  /**
   *
   *
   * <pre>
   * Specifies the behavior when writing build logs to Google Cloud Storage.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption}
   */
  public enum LogStreamingOption implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Service may automatically determine build log streaming behavior.
     * </pre>
     *
     * <code>STREAM_DEFAULT = 0;</code>
     */
    STREAM_DEFAULT(0),
    /**
     *
     *
     * <pre>
     * Build logs should be streamed to Google Cloud Storage.
     * </pre>
     *
     * <code>STREAM_ON = 1;</code>
     */
    STREAM_ON(1),
    /**
     *
     *
     * <pre>
     * Build logs should not be streamed to Google Cloud Storage; they will be
     * written when the build is completed.
     * </pre>
     *
     * <code>STREAM_OFF = 2;</code>
     */
    STREAM_OFF(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Service may automatically determine build log streaming behavior.
     * </pre>
     *
     * <code>STREAM_DEFAULT = 0;</code>
     */
    public static final int STREAM_DEFAULT_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Build logs should be streamed to Google Cloud Storage.
     * </pre>
     *
     * <code>STREAM_ON = 1;</code>
     */
    public static final int STREAM_ON_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Build logs should not be streamed to Google Cloud Storage; they will be
     * written when the build is completed.
     * </pre>
     *
     * <code>STREAM_OFF = 2;</code>
     */
    public static final int STREAM_OFF_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LogStreamingOption valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LogStreamingOption forNumber(int value) {
      switch (value) {
        case 0:
          return STREAM_DEFAULT;
        case 1:
          return STREAM_ON;
        case 2:
          return STREAM_OFF;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LogStreamingOption>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LogStreamingOption>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LogStreamingOption>() {
              public LogStreamingOption findValueByNumber(int number) {
                return LogStreamingOption.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.BuildOptions.getDescriptor().getEnumTypes().get(3);
    }

    private static final LogStreamingOption[] VALUES = values();

    public static LogStreamingOption valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LogStreamingOption(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption)
  }

  /**
   *
   *
   * <pre>
   * Specifies the logging mode.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.BuildOptions.LoggingMode}
   */
  public enum LoggingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The service determines the logging mode. The default is `LEGACY`. Do not
     * rely on the default logging behavior as it may change in the future.
     * </pre>
     *
     * <code>LOGGING_UNSPECIFIED = 0;</code>
     */
    LOGGING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Stackdriver logging and Cloud Storage logging are enabled.
     * </pre>
     *
     * <code>LEGACY = 1;</code>
     */
    LEGACY(1),
    /**
     *
     *
     * <pre>
     * Only Cloud Storage logging is enabled.
     * </pre>
     *
     * <code>GCS_ONLY = 2;</code>
     */
    GCS_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The service determines the logging mode. The default is `LEGACY`. Do not
     * rely on the default logging behavior as it may change in the future.
     * </pre>
     *
     * <code>LOGGING_UNSPECIFIED = 0;</code>
     */
    public static final int LOGGING_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Stackdriver logging and Cloud Storage logging are enabled.
     * </pre>
     *
     * <code>LEGACY = 1;</code>
     */
    public static final int LEGACY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only Cloud Storage logging is enabled.
     * </pre>
     *
     * <code>GCS_ONLY = 2;</code>
     */
    public static final int GCS_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoggingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoggingMode forNumber(int value) {
      switch (value) {
        case 0:
          return LOGGING_UNSPECIFIED;
        case 1:
          return LEGACY;
        case 2:
          return GCS_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoggingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoggingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LoggingMode>() {
          public LoggingMode findValueByNumber(int number) {
            return LoggingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.BuildOptions.getDescriptor().getEnumTypes().get(4);
    }

    private static final LoggingMode[] VALUES = values();

    public static LoggingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoggingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.BuildOptions.LoggingMode)
  }

  public static final int SOURCE_PROVENANCE_HASH_FIELD_NUMBER = 1;
  private java.util.List<java.lang.Integer> sourceProvenanceHash_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloudbuild.v1.Hash.HashType>
      sourceProvenanceHash_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloudbuild.v1.Hash.HashType>() {
            public com.google.cloudbuild.v1.Hash.HashType convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloudbuild.v1.Hash.HashType result =
                  com.google.cloudbuild.v1.Hash.HashType.valueOf(from);
              return result == null ? com.google.cloudbuild.v1.Hash.HashType.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Requested hash for SourceProvenance.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;</code>
   *
   * @return A list containing the sourceProvenanceHash.
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Hash.HashType> getSourceProvenanceHashList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloudbuild.v1.Hash.HashType>(
        sourceProvenanceHash_, sourceProvenanceHash_converter_);
  }
  /**
   *
   *
   * <pre>
   * Requested hash for SourceProvenance.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;</code>
   *
   * @return The count of sourceProvenanceHash.
   */
  @java.lang.Override
  public int getSourceProvenanceHashCount() {
    return sourceProvenanceHash_.size();
  }
  /**
   *
   *
   * <pre>
   * Requested hash for SourceProvenance.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The sourceProvenanceHash at the given index.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Hash.HashType getSourceProvenanceHash(int index) {
    return sourceProvenanceHash_converter_.convert(sourceProvenanceHash_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Requested hash for SourceProvenance.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;</code>
   *
   * @return A list containing the enum numeric values on the wire for sourceProvenanceHash.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSourceProvenanceHashValueList() {
    return sourceProvenanceHash_;
  }
  /**
   *
   *
   * <pre>
   * Requested hash for SourceProvenance.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of sourceProvenanceHash at the given index.
   */
  @java.lang.Override
  public int getSourceProvenanceHashValue(int index) {
    return sourceProvenanceHash_.get(index);
  }

  private int sourceProvenanceHashMemoizedSerializedSize;

  public static final int REQUESTED_VERIFY_OPTION_FIELD_NUMBER = 2;
  private int requestedVerifyOption_;
  /**
   *
   *
   * <pre>
   * Requested verifiability options.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for requestedVerifyOption.
   */
  @java.lang.Override
  public int getRequestedVerifyOptionValue() {
    return requestedVerifyOption_;
  }
  /**
   *
   *
   * <pre>
   * Requested verifiability options.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
   * </code>
   *
   * @return The requestedVerifyOption.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions.VerifyOption getRequestedVerifyOption() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.BuildOptions.VerifyOption result =
        com.google.cloudbuild.v1.BuildOptions.VerifyOption.valueOf(requestedVerifyOption_);
    return result == null
        ? com.google.cloudbuild.v1.BuildOptions.VerifyOption.UNRECOGNIZED
        : result;
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 3;
  private int machineType_;
  /**
   *
   *
   * <pre>
   * Compute Engine machine type on which to run the build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
   *
   * @return The enum numeric value on the wire for machineType.
   */
  @java.lang.Override
  public int getMachineTypeValue() {
    return machineType_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine type on which to run the build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions.MachineType getMachineType() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.BuildOptions.MachineType result =
        com.google.cloudbuild.v1.BuildOptions.MachineType.valueOf(machineType_);
    return result == null ? com.google.cloudbuild.v1.BuildOptions.MachineType.UNRECOGNIZED : result;
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 6;
  private long diskSizeGb_;
  /**
   *
   *
   * <pre>
   * Requested disk size for the VM that runs the build. Note that this is *NOT*
   * "disk free"; some of the space will be used by the operating system and
   * build utilities. Also note that this is the minimum disk size that will be
   * allocated for the build -- the build may run with a larger disk than
   * requested. At present, the maximum disk size is 1000GB; builds that request
   * more than the maximum are rejected with an error.
   * </pre>
   *
   * <code>int64 disk_size_gb = 6;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int SUBSTITUTION_OPTION_FIELD_NUMBER = 4;
  private int substitutionOption_;
  /**
   *
   *
   * <pre>
   * Option to specify behavior when there is an error in the substitution
   * checks.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for substitutionOption.
   */
  @java.lang.Override
  public int getSubstitutionOptionValue() {
    return substitutionOption_;
  }
  /**
   *
   *
   * <pre>
   * Option to specify behavior when there is an error in the substitution
   * checks.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
   * </code>
   *
   * @return The substitutionOption.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions.SubstitutionOption getSubstitutionOption() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.BuildOptions.SubstitutionOption result =
        com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.valueOf(substitutionOption_);
    return result == null
        ? com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.UNRECOGNIZED
        : result;
  }

  public static final int LOG_STREAMING_OPTION_FIELD_NUMBER = 5;
  private int logStreamingOption_;
  /**
   *
   *
   * <pre>
   * Option to define build log streaming behavior to Google Cloud
   * Storage.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for logStreamingOption.
   */
  @java.lang.Override
  public int getLogStreamingOptionValue() {
    return logStreamingOption_;
  }
  /**
   *
   *
   * <pre>
   * Option to define build log streaming behavior to Google Cloud
   * Storage.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
   * </code>
   *
   * @return The logStreamingOption.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions.LogStreamingOption getLogStreamingOption() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.BuildOptions.LogStreamingOption result =
        com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.valueOf(logStreamingOption_);
    return result == null
        ? com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.UNRECOGNIZED
        : result;
  }

  public static final int WORKER_POOL_FIELD_NUMBER = 7;
  private volatile java.lang.Object workerPool_;
  /**
   *
   *
   * <pre>
   * Option to specify a `WorkerPool` for the build.
   * Format: projects/{project}/workerPools/{workerPool}
   * This field is experimental.
   * </pre>
   *
   * <code>string worker_pool = 7;</code>
   *
   * @return The workerPool.
   */
  @java.lang.Override
  public java.lang.String getWorkerPool() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workerPool_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Option to specify a `WorkerPool` for the build.
   * Format: projects/{project}/workerPools/{workerPool}
   * This field is experimental.
   * </pre>
   *
   * <code>string worker_pool = 7;</code>
   *
   * @return The bytes for workerPool.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkerPoolBytes() {
    java.lang.Object ref = workerPool_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workerPool_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOGGING_FIELD_NUMBER = 11;
  private int logging_;
  /**
   *
   *
   * <pre>
   * Option to specify the logging mode, which determines where the logs are
   * stored.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
   *
   * @return The enum numeric value on the wire for logging.
   */
  @java.lang.Override
  public int getLoggingValue() {
    return logging_;
  }
  /**
   *
   *
   * <pre>
   * Option to specify the logging mode, which determines where the logs are
   * stored.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
   *
   * @return The logging.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions.LoggingMode getLogging() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.BuildOptions.LoggingMode result =
        com.google.cloudbuild.v1.BuildOptions.LoggingMode.valueOf(logging_);
    return result == null ? com.google.cloudbuild.v1.BuildOptions.LoggingMode.UNRECOGNIZED : result;
  }

  public static final int ENV_FIELD_NUMBER = 12;
  private com.google.protobuf.LazyStringList env_;
  /**
   *
   *
   * <pre>
   * A list of global environment variable definitions that will exist for all
   * build steps in this build. If a variable is defined in both globally and in
   * a build step, the variable will use the build step value.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 12;</code>
   *
   * @return A list containing the env.
   */
  public com.google.protobuf.ProtocolStringList getEnvList() {
    return env_;
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variable definitions that will exist for all
   * build steps in this build. If a variable is defined in both globally and in
   * a build step, the variable will use the build step value.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 12;</code>
   *
   * @return The count of env.
   */
  public int getEnvCount() {
    return env_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variable definitions that will exist for all
   * build steps in this build. If a variable is defined in both globally and in
   * a build step, the variable will use the build step value.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The env at the given index.
   */
  public java.lang.String getEnv(int index) {
    return env_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variable definitions that will exist for all
   * build steps in this build. If a variable is defined in both globally and in
   * a build step, the variable will use the build step value.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the env at the given index.
   */
  public com.google.protobuf.ByteString getEnvBytes(int index) {
    return env_.getByteString(index);
  }

  public static final int SECRET_ENV_FIELD_NUMBER = 13;
  private com.google.protobuf.LazyStringList secretEnv_;
  /**
   *
   *
   * <pre>
   * A list of global environment variables, which are encrypted using a Cloud
   * Key Management Service crypto key. These values must be specified in the
   * build's `Secret`. These variables will be available to all build steps
   * in this build.
   * </pre>
   *
   * <code>repeated string secret_env = 13;</code>
   *
   * @return A list containing the secretEnv.
   */
  public com.google.protobuf.ProtocolStringList getSecretEnvList() {
    return secretEnv_;
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variables, which are encrypted using a Cloud
   * Key Management Service crypto key. These values must be specified in the
   * build's `Secret`. These variables will be available to all build steps
   * in this build.
   * </pre>
   *
   * <code>repeated string secret_env = 13;</code>
   *
   * @return The count of secretEnv.
   */
  public int getSecretEnvCount() {
    return secretEnv_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variables, which are encrypted using a Cloud
   * Key Management Service crypto key. These values must be specified in the
   * build's `Secret`. These variables will be available to all build steps
   * in this build.
   * </pre>
   *
   * <code>repeated string secret_env = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The secretEnv at the given index.
   */
  public java.lang.String getSecretEnv(int index) {
    return secretEnv_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of global environment variables, which are encrypted using a Cloud
   * Key Management Service crypto key. These values must be specified in the
   * build's `Secret`. These variables will be available to all build steps
   * in this build.
   * </pre>
   *
   * <code>repeated string secret_env = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the secretEnv at the given index.
   */
  public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
    return secretEnv_.getByteString(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloudbuild.v1.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * Global list of volumes to mount for ALL build steps
   * Each volume is created as an empty volume prior to starting the build
   * process. Upon completion of the build, volumes and their contents are
   * discarded. Global volume names and paths cannot conflict with the volumes
   * defined a build step.
   * Using a global volume in a build with only one step is not valid as
   * it is indicative of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * Global list of volumes to mount for ALL build steps
   * Each volume is created as an empty volume prior to starting the build
   * process. Upon completion of the build, volumes and their contents are
   * discarded. Global volume names and paths cannot conflict with the volumes
   * defined a build step.
   * Using a global volume in a build with only one step is not valid as
   * it is indicative of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * Global list of volumes to mount for ALL build steps
   * Each volume is created as an empty volume prior to starting the build
   * process. Upon completion of the build, volumes and their contents are
   * discarded. Global volume names and paths cannot conflict with the volumes
   * defined a build step.
   * Using a global volume in a build with only one step is not valid as
   * it is indicative of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * Global list of volumes to mount for ALL build steps
   * Each volume is created as an empty volume prior to starting the build
   * process. Upon completion of the build, volumes and their contents are
   * discarded. Global volume names and paths cannot conflict with the volumes
   * defined a build step.
   * Using a global volume in a build with only one step is not valid as
   * it is indicative of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Global list of volumes to mount for ALL build steps
   * Each volume is created as an empty volume prior to starting the build
   * process. Upon completion of the build, volumes and their contents are
   * discarded. Global volume names and paths cannot conflict with the volumes
   * defined a build step.
   * Using a global volume in a build with only one step is not valid as
   * it is indicative of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getSourceProvenanceHashList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(sourceProvenanceHashMemoizedSerializedSize);
    }
    for (int i = 0; i < sourceProvenanceHash_.size(); i++) {
      output.writeEnumNoTag(sourceProvenanceHash_.get(i));
    }
    if (requestedVerifyOption_
        != com.google.cloudbuild.v1.BuildOptions.VerifyOption.NOT_VERIFIED.getNumber()) {
      output.writeEnum(2, requestedVerifyOption_);
    }
    if (machineType_ != com.google.cloudbuild.v1.BuildOptions.MachineType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, machineType_);
    }
    if (substitutionOption_
        != com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.MUST_MATCH.getNumber()) {
      output.writeEnum(4, substitutionOption_);
    }
    if (logStreamingOption_
        != com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.STREAM_DEFAULT.getNumber()) {
      output.writeEnum(5, logStreamingOption_);
    }
    if (diskSizeGb_ != 0L) {
      output.writeInt64(6, diskSizeGb_);
    }
    if (!getWorkerPoolBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, workerPool_);
    }
    if (logging_
        != com.google.cloudbuild.v1.BuildOptions.LoggingMode.LOGGING_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, logging_);
    }
    for (int i = 0; i < env_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, env_.getRaw(i));
    }
    for (int i = 0; i < secretEnv_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, secretEnv_.getRaw(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(14, volumes_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < sourceProvenanceHash_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                sourceProvenanceHash_.get(i));
      }
      size += dataSize;
      if (!getSourceProvenanceHashList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      sourceProvenanceHashMemoizedSerializedSize = dataSize;
    }
    if (requestedVerifyOption_
        != com.google.cloudbuild.v1.BuildOptions.VerifyOption.NOT_VERIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, requestedVerifyOption_);
    }
    if (machineType_ != com.google.cloudbuild.v1.BuildOptions.MachineType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, machineType_);
    }
    if (substitutionOption_
        != com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.MUST_MATCH.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, substitutionOption_);
    }
    if (logStreamingOption_
        != com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.STREAM_DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, logStreamingOption_);
    }
    if (diskSizeGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, diskSizeGb_);
    }
    if (!getWorkerPoolBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, workerPool_);
    }
    if (logging_
        != com.google.cloudbuild.v1.BuildOptions.LoggingMode.LOGGING_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, logging_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < env_.size(); i++) {
        dataSize += computeStringSizeNoTag(env_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEnvList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < secretEnv_.size(); i++) {
        dataSize += computeStringSizeNoTag(secretEnv_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSecretEnvList().size();
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, volumes_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.BuildOptions)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.BuildOptions other = (com.google.cloudbuild.v1.BuildOptions) obj;

    if (!sourceProvenanceHash_.equals(other.sourceProvenanceHash_)) return false;
    if (requestedVerifyOption_ != other.requestedVerifyOption_) return false;
    if (machineType_ != other.machineType_) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (substitutionOption_ != other.substitutionOption_) return false;
    if (logStreamingOption_ != other.logStreamingOption_) return false;
    if (!getWorkerPool().equals(other.getWorkerPool())) return false;
    if (logging_ != other.logging_) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getSecretEnvList().equals(other.getSecretEnvList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSourceProvenanceHashCount() > 0) {
      hash = (37 * hash) + SOURCE_PROVENANCE_HASH_FIELD_NUMBER;
      hash = (53 * hash) + sourceProvenanceHash_.hashCode();
    }
    hash = (37 * hash) + REQUESTED_VERIFY_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + requestedVerifyOption_;
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + machineType_;
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    hash = (37 * hash) + SUBSTITUTION_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + substitutionOption_;
    hash = (37 * hash) + LOG_STREAMING_OPTION_FIELD_NUMBER;
    hash = (53 * hash) + logStreamingOption_;
    hash = (37 * hash) + WORKER_POOL_FIELD_NUMBER;
    hash = (53 * hash) + getWorkerPool().hashCode();
    hash = (37 * hash) + LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + logging_;
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (getSecretEnvCount() > 0) {
      hash = (37 * hash) + SECRET_ENV_FIELD_NUMBER;
      hash = (53 * hash) + getSecretEnvList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.BuildOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Optional arguments to enable specific features of builds.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.BuildOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.BuildOptions)
      com.google.cloudbuild.v1.BuildOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.BuildOptions.class,
              com.google.cloudbuild.v1.BuildOptions.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.BuildOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVolumesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      sourceProvenanceHash_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      requestedVerifyOption_ = 0;

      machineType_ = 0;

      diskSizeGb_ = 0L;

      substitutionOption_ = 0;

      logStreamingOption_ = 0;

      workerPool_ = "";

      logging_ = 0;

      env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.BuildOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions build() {
      com.google.cloudbuild.v1.BuildOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions buildPartial() {
      com.google.cloudbuild.v1.BuildOptions result =
          new com.google.cloudbuild.v1.BuildOptions(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        sourceProvenanceHash_ = java.util.Collections.unmodifiableList(sourceProvenanceHash_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.sourceProvenanceHash_ = sourceProvenanceHash_;
      result.requestedVerifyOption_ = requestedVerifyOption_;
      result.machineType_ = machineType_;
      result.diskSizeGb_ = diskSizeGb_;
      result.substitutionOption_ = substitutionOption_;
      result.logStreamingOption_ = logStreamingOption_;
      result.workerPool_ = workerPool_;
      result.logging_ = logging_;
      if (((bitField0_ & 0x00000002) != 0)) {
        env_ = env_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.env_ = env_;
      if (((bitField0_ & 0x00000004) != 0)) {
        secretEnv_ = secretEnv_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.secretEnv_ = secretEnv_;
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.BuildOptions) {
        return mergeFrom((com.google.cloudbuild.v1.BuildOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.BuildOptions other) {
      if (other == com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()) return this;
      if (!other.sourceProvenanceHash_.isEmpty()) {
        if (sourceProvenanceHash_.isEmpty()) {
          sourceProvenanceHash_ = other.sourceProvenanceHash_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSourceProvenanceHashIsMutable();
          sourceProvenanceHash_.addAll(other.sourceProvenanceHash_);
        }
        onChanged();
      }
      if (other.requestedVerifyOption_ != 0) {
        setRequestedVerifyOptionValue(other.getRequestedVerifyOptionValue());
      }
      if (other.machineType_ != 0) {
        setMachineTypeValue(other.getMachineTypeValue());
      }
      if (other.getDiskSizeGb() != 0L) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.substitutionOption_ != 0) {
        setSubstitutionOptionValue(other.getSubstitutionOptionValue());
      }
      if (other.logStreamingOption_ != 0) {
        setLogStreamingOptionValue(other.getLogStreamingOptionValue());
      }
      if (!other.getWorkerPool().isEmpty()) {
        workerPool_ = other.workerPool_;
        onChanged();
      }
      if (other.logging_ != 0) {
        setLoggingValue(other.getLoggingValue());
      }
      if (!other.env_.isEmpty()) {
        if (env_.isEmpty()) {
          env_ = other.env_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureEnvIsMutable();
          env_.addAll(other.env_);
        }
        onChanged();
      }
      if (!other.secretEnv_.isEmpty()) {
        if (secretEnv_.isEmpty()) {
          secretEnv_ = other.secretEnv_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureSecretEnvIsMutable();
          secretEnv_.addAll(other.secretEnv_);
        }
        onChanged();
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000008);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.BuildOptions parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.BuildOptions) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> sourceProvenanceHash_ =
        java.util.Collections.emptyList();

    private void ensureSourceProvenanceHashIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        sourceProvenanceHash_ = new java.util.ArrayList<java.lang.Integer>(sourceProvenanceHash_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @return A list containing the sourceProvenanceHash.
     */
    public java.util.List<com.google.cloudbuild.v1.Hash.HashType> getSourceProvenanceHashList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloudbuild.v1.Hash.HashType>(
          sourceProvenanceHash_, sourceProvenanceHash_converter_);
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @return The count of sourceProvenanceHash.
     */
    public int getSourceProvenanceHashCount() {
      return sourceProvenanceHash_.size();
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The sourceProvenanceHash at the given index.
     */
    public com.google.cloudbuild.v1.Hash.HashType getSourceProvenanceHash(int index) {
      return sourceProvenanceHash_converter_.convert(sourceProvenanceHash_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The sourceProvenanceHash to set.
     * @return This builder for chaining.
     */
    public Builder setSourceProvenanceHash(
        int index, com.google.cloudbuild.v1.Hash.HashType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceProvenanceHashIsMutable();
      sourceProvenanceHash_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param value The sourceProvenanceHash to add.
     * @return This builder for chaining.
     */
    public Builder addSourceProvenanceHash(com.google.cloudbuild.v1.Hash.HashType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourceProvenanceHashIsMutable();
      sourceProvenanceHash_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param values The sourceProvenanceHash to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceProvenanceHash(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Hash.HashType> values) {
      ensureSourceProvenanceHashIsMutable();
      for (com.google.cloudbuild.v1.Hash.HashType value : values) {
        sourceProvenanceHash_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceProvenanceHash() {
      sourceProvenanceHash_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for sourceProvenanceHash.
     */
    public java.util.List<java.lang.Integer> getSourceProvenanceHashValueList() {
      return java.util.Collections.unmodifiableList(sourceProvenanceHash_);
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of sourceProvenanceHash at the given index.
     */
    public int getSourceProvenanceHashValue(int index) {
      return sourceProvenanceHash_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of sourceProvenanceHash at the given index.
     * @return This builder for chaining.
     */
    public Builder setSourceProvenanceHashValue(int index, int value) {
      ensureSourceProvenanceHashIsMutable();
      sourceProvenanceHash_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for sourceProvenanceHash to add.
     * @return This builder for chaining.
     */
    public Builder addSourceProvenanceHashValue(int value) {
      ensureSourceProvenanceHashIsMutable();
      sourceProvenanceHash_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested hash for SourceProvenance.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Hash.HashType source_provenance_hash = 1;
     * </code>
     *
     * @param values The enum numeric values on the wire for sourceProvenanceHash to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourceProvenanceHashValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSourceProvenanceHashIsMutable();
      for (int value : values) {
        sourceProvenanceHash_.add(value);
      }
      onChanged();
      return this;
    }

    private int requestedVerifyOption_ = 0;
    /**
     *
     *
     * <pre>
     * Requested verifiability options.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for requestedVerifyOption.
     */
    @java.lang.Override
    public int getRequestedVerifyOptionValue() {
      return requestedVerifyOption_;
    }
    /**
     *
     *
     * <pre>
     * Requested verifiability options.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for requestedVerifyOption to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedVerifyOptionValue(int value) {

      requestedVerifyOption_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested verifiability options.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
     * </code>
     *
     * @return The requestedVerifyOption.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions.VerifyOption getRequestedVerifyOption() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.BuildOptions.VerifyOption result =
          com.google.cloudbuild.v1.BuildOptions.VerifyOption.valueOf(requestedVerifyOption_);
      return result == null
          ? com.google.cloudbuild.v1.BuildOptions.VerifyOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Requested verifiability options.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
     * </code>
     *
     * @param value The requestedVerifyOption to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedVerifyOption(
        com.google.cloudbuild.v1.BuildOptions.VerifyOption value) {
      if (value == null) {
        throw new NullPointerException();
      }

      requestedVerifyOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested verifiability options.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.VerifyOption requested_verify_option = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedVerifyOption() {

      requestedVerifyOption_ = 0;
      onChanged();
      return this;
    }

    private int machineType_ = 0;
    /**
     *
     *
     * <pre>
     * Compute Engine machine type on which to run the build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
     *
     * @return The enum numeric value on the wire for machineType.
     */
    @java.lang.Override
    public int getMachineTypeValue() {
      return machineType_;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type on which to run the build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeValue(int value) {

      machineType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type on which to run the build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions.MachineType getMachineType() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.BuildOptions.MachineType result =
          com.google.cloudbuild.v1.BuildOptions.MachineType.valueOf(machineType_);
      return result == null
          ? com.google.cloudbuild.v1.BuildOptions.MachineType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type on which to run the build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(com.google.cloudbuild.v1.BuildOptions.MachineType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      machineType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type on which to run the build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.MachineType machine_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {

      machineType_ = 0;
      onChanged();
      return this;
    }

    private long diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Requested disk size for the VM that runs the build. Note that this is *NOT*
     * "disk free"; some of the space will be used by the operating system and
     * build utilities. Also note that this is the minimum disk size that will be
     * allocated for the build -- the build may run with a larger disk than
     * requested. At present, the maximum disk size is 1000GB; builds that request
     * more than the maximum are rejected with an error.
     * </pre>
     *
     * <code>int64 disk_size_gb = 6;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Requested disk size for the VM that runs the build. Note that this is *NOT*
     * "disk free"; some of the space will be used by the operating system and
     * build utilities. Also note that this is the minimum disk size that will be
     * allocated for the build -- the build may run with a larger disk than
     * requested. At present, the maximum disk size is 1000GB; builds that request
     * more than the maximum are rejected with an error.
     * </pre>
     *
     * <code>int64 disk_size_gb = 6;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested disk size for the VM that runs the build. Note that this is *NOT*
     * "disk free"; some of the space will be used by the operating system and
     * build utilities. Also note that this is the minimum disk size that will be
     * allocated for the build -- the build may run with a larger disk than
     * requested. At present, the maximum disk size is 1000GB; builds that request
     * more than the maximum are rejected with an error.
     * </pre>
     *
     * <code>int64 disk_size_gb = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {

      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private int substitutionOption_ = 0;
    /**
     *
     *
     * <pre>
     * Option to specify behavior when there is an error in the substitution
     * checks.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for substitutionOption.
     */
    @java.lang.Override
    public int getSubstitutionOptionValue() {
      return substitutionOption_;
    }
    /**
     *
     *
     * <pre>
     * Option to specify behavior when there is an error in the substitution
     * checks.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for substitutionOption to set.
     * @return This builder for chaining.
     */
    public Builder setSubstitutionOptionValue(int value) {

      substitutionOption_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify behavior when there is an error in the substitution
     * checks.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
     * </code>
     *
     * @return The substitutionOption.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions.SubstitutionOption getSubstitutionOption() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.BuildOptions.SubstitutionOption result =
          com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.valueOf(substitutionOption_);
      return result == null
          ? com.google.cloudbuild.v1.BuildOptions.SubstitutionOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Option to specify behavior when there is an error in the substitution
     * checks.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
     * </code>
     *
     * @param value The substitutionOption to set.
     * @return This builder for chaining.
     */
    public Builder setSubstitutionOption(
        com.google.cloudbuild.v1.BuildOptions.SubstitutionOption value) {
      if (value == null) {
        throw new NullPointerException();
      }

      substitutionOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify behavior when there is an error in the substitution
     * checks.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption substitution_option = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubstitutionOption() {

      substitutionOption_ = 0;
      onChanged();
      return this;
    }

    private int logStreamingOption_ = 0;
    /**
     *
     *
     * <pre>
     * Option to define build log streaming behavior to Google Cloud
     * Storage.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for logStreamingOption.
     */
    @java.lang.Override
    public int getLogStreamingOptionValue() {
      return logStreamingOption_;
    }
    /**
     *
     *
     * <pre>
     * Option to define build log streaming behavior to Google Cloud
     * Storage.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for logStreamingOption to set.
     * @return This builder for chaining.
     */
    public Builder setLogStreamingOptionValue(int value) {

      logStreamingOption_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to define build log streaming behavior to Google Cloud
     * Storage.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
     * </code>
     *
     * @return The logStreamingOption.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions.LogStreamingOption getLogStreamingOption() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.BuildOptions.LogStreamingOption result =
          com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.valueOf(logStreamingOption_);
      return result == null
          ? com.google.cloudbuild.v1.BuildOptions.LogStreamingOption.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Option to define build log streaming behavior to Google Cloud
     * Storage.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
     * </code>
     *
     * @param value The logStreamingOption to set.
     * @return This builder for chaining.
     */
    public Builder setLogStreamingOption(
        com.google.cloudbuild.v1.BuildOptions.LogStreamingOption value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logStreamingOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to define build log streaming behavior to Google Cloud
     * Storage.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption log_streaming_option = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogStreamingOption() {

      logStreamingOption_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object workerPool_ = "";
    /**
     *
     *
     * <pre>
     * Option to specify a `WorkerPool` for the build.
     * Format: projects/{project}/workerPools/{workerPool}
     * This field is experimental.
     * </pre>
     *
     * <code>string worker_pool = 7;</code>
     *
     * @return The workerPool.
     */
    public java.lang.String getWorkerPool() {
      java.lang.Object ref = workerPool_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workerPool_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Option to specify a `WorkerPool` for the build.
     * Format: projects/{project}/workerPools/{workerPool}
     * This field is experimental.
     * </pre>
     *
     * <code>string worker_pool = 7;</code>
     *
     * @return The bytes for workerPool.
     */
    public com.google.protobuf.ByteString getWorkerPoolBytes() {
      java.lang.Object ref = workerPool_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workerPool_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Option to specify a `WorkerPool` for the build.
     * Format: projects/{project}/workerPools/{workerPool}
     * This field is experimental.
     * </pre>
     *
     * <code>string worker_pool = 7;</code>
     *
     * @param value The workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPool(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      workerPool_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify a `WorkerPool` for the build.
     * Format: projects/{project}/workerPools/{workerPool}
     * This field is experimental.
     * </pre>
     *
     * <code>string worker_pool = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerPool() {

      workerPool_ = getDefaultInstance().getWorkerPool();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify a `WorkerPool` for the build.
     * Format: projects/{project}/workerPools/{workerPool}
     * This field is experimental.
     * </pre>
     *
     * <code>string worker_pool = 7;</code>
     *
     * @param value The bytes for workerPool to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerPoolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      workerPool_ = value;
      onChanged();
      return this;
    }

    private int logging_ = 0;
    /**
     *
     *
     * <pre>
     * Option to specify the logging mode, which determines where the logs are
     * stored.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
     *
     * @return The enum numeric value on the wire for logging.
     */
    @java.lang.Override
    public int getLoggingValue() {
      return logging_;
    }
    /**
     *
     *
     * <pre>
     * Option to specify the logging mode, which determines where the logs are
     * stored.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
     *
     * @param value The enum numeric value on the wire for logging to set.
     * @return This builder for chaining.
     */
    public Builder setLoggingValue(int value) {

      logging_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify the logging mode, which determines where the logs are
     * stored.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
     *
     * @return The logging.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOptions.LoggingMode getLogging() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.BuildOptions.LoggingMode result =
          com.google.cloudbuild.v1.BuildOptions.LoggingMode.valueOf(logging_);
      return result == null
          ? com.google.cloudbuild.v1.BuildOptions.LoggingMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Option to specify the logging mode, which determines where the logs are
     * stored.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
     *
     * @param value The logging to set.
     * @return This builder for chaining.
     */
    public Builder setLogging(com.google.cloudbuild.v1.BuildOptions.LoggingMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logging_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Option to specify the logging mode, which determines where the logs are
     * stored.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions.LoggingMode logging = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogging() {

      logging_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList env_ = com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        env_ = new com.google.protobuf.LazyStringArrayList(env_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @return A list containing the env.
     */
    public com.google.protobuf.ProtocolStringList getEnvList() {
      return env_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @return The count of env.
     */
    public int getEnvCount() {
      return env_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The env at the given index.
     */
    public java.lang.String getEnv(int index) {
      return env_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the env at the given index.
     */
    public com.google.protobuf.ByteString getEnvBytes(int index) {
      return env_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The env to set.
     * @return This builder for chaining.
     */
    public Builder setEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param value The env to add.
     * @return This builder for chaining.
     */
    public Builder addEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param values The env to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnv(java.lang.Iterable<java.lang.String> values) {
      ensureEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnv() {
      env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variable definitions that will exist for all
     * build steps in this build. If a variable is defined in both globally and in
     * a build step, the variable will use the build step value.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 12;</code>
     *
     * @param value The bytes of the env to add.
     * @return This builder for chaining.
     */
    public Builder addEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnvIsMutable();
      env_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList secretEnv_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSecretEnvIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        secretEnv_ = new com.google.protobuf.LazyStringArrayList(secretEnv_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @return A list containing the secretEnv.
     */
    public com.google.protobuf.ProtocolStringList getSecretEnvList() {
      return secretEnv_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @return The count of secretEnv.
     */
    public int getSecretEnvCount() {
      return secretEnv_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The secretEnv at the given index.
     */
    public java.lang.String getSecretEnv(int index) {
      return secretEnv_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the secretEnv at the given index.
     */
    public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
      return secretEnv_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The secretEnv to set.
     * @return This builder for chaining.
     */
    public Builder setSecretEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param value The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param values The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addAllSecretEnv(java.lang.Iterable<java.lang.String> values) {
      ensureSecretEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnv_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecretEnv() {
      secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of global environment variables, which are encrypted using a Cloud
     * Key Management Service crypto key. These values must be specified in the
     * build's `Secret`. These variables will be available to all build steps
     * in this build.
     * </pre>
     *
     * <code>repeated string secret_env = 13;</code>
     *
     * @param value The bytes of the secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloudbuild.v1.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloudbuild.v1.Volume>(volumes_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public com.google.cloudbuild.v1.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Global list of volumes to mount for ALL build steps
     * Each volume is created as an empty volume prior to starting the build
     * process. Upon completion of the build, volumes and their contents are
     * discarded. Global volume names and paths cannot conflict with the volumes
     * defined a build step.
     * Using a global volume in a build with only one step is not valid as
     * it is indicative of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 14;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Volume,
                com.google.cloudbuild.v1.Volume.Builder,
                com.google.cloudbuild.v1.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.BuildOptions)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.BuildOptions)
  private static final com.google.cloudbuild.v1.BuildOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.BuildOptions();
  }

  public static com.google.cloudbuild.v1.BuildOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildOptions> PARSER =
      new com.google.protobuf.AbstractParser<BuildOptions>() {
        @java.lang.Override
        public BuildOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BuildOptions(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BuildOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
