/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * A step in the build pipeline.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.BuildStep}
 */
public final class BuildStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.BuildStep)
    BuildStepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildStep.newBuilder() to construct.
  private BuildStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildStep() {
    name_ = "";
    env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    dir_ = "";
    id_ = "";
    waitFor_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    entrypoint_ = "";
    secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    volumes_ = java.util.Collections.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildStep();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BuildStep(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                env_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              env_.add(s);
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                args_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              args_.add(s);
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              dir_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                waitFor_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              waitFor_.add(s);
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              entrypoint_ = s;
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                secretEnv_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              secretEnv_.add(s);
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                volumes_ = new java.util.ArrayList<com.google.cloudbuild.v1.Volume>();
                mutable_bitField0_ |= 0x00000010;
              }
              volumes_.add(
                  input.readMessage(com.google.cloudbuild.v1.Volume.parser(), extensionRegistry));
              break;
            }
          case 82:
            {
              com.google.cloudbuild.v1.TimeSpan.Builder subBuilder = null;
              if (timing_ != null) {
                subBuilder = timing_.toBuilder();
              }
              timing_ =
                  input.readMessage(com.google.cloudbuild.v1.TimeSpan.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timing_);
                timing_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeout_ != null) {
                subBuilder = timeout_.toBuilder();
              }
              timeout_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeout_);
                timeout_ = subBuilder.buildPartial();
              }

              break;
            }
          case 96:
            {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
          case 106:
            {
              com.google.cloudbuild.v1.TimeSpan.Builder subBuilder = null;
              if (pullTiming_ != null) {
                subBuilder = pullTiming_.toBuilder();
              }
              pullTiming_ =
                  input.readMessage(com.google.cloudbuild.v1.TimeSpan.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(pullTiming_);
                pullTiming_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        env_ = env_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        waitFor_ = waitFor_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        secretEnv_ = secretEnv_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        volumes_ = java.util.Collections.unmodifiableList(volumes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.BuildStep.class,
            com.google.cloudbuild.v1.BuildStep.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The name of the container image that will run this particular
   * build step.
   * If the image is available in the host's Docker daemon's cache, it
   * will be run directly. If not, the host will attempt to pull the image
   * first, using the builder service account's credentials if necessary.
   * The Docker daemon's cache will already have the latest versions of all of
   * the officially supported build steps
   * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
   * The Docker daemon will also have cached many of the layers for some popular
   * images, like "ubuntu", "debian", but they will be refreshed at the time you
   * attempt to use them.
   * If you built an image in a previous build step, it will be stored in the
   * host's Docker daemon's cache and is available to use as the name for a
   * later build step.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the container image that will run this particular
   * build step.
   * If the image is available in the host's Docker daemon's cache, it
   * will be run directly. If not, the host will attempt to pull the image
   * first, using the builder service account's credentials if necessary.
   * The Docker daemon's cache will already have the latest versions of all of
   * the officially supported build steps
   * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
   * The Docker daemon will also have cached many of the layers for some popular
   * images, like "ubuntu", "debian", but they will be refreshed at the time you
   * attempt to use them.
   * If you built an image in a previous build step, it will be stored in the
   * host's Docker daemon's cache and is available to use as the name for a
   * later build step.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENV_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList env_;
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @return A list containing the env.
   */
  public com.google.protobuf.ProtocolStringList getEnvList() {
    return env_;
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @return The count of env.
   */
  public int getEnvCount() {
    return env_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The env at the given index.
   */
  public java.lang.String getEnv(int index) {
    return env_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the env at the given index.
   */
  public com.google.protobuf.ByteString getEnvBytes(int index) {
    return env_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList args_;
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int DIR_FIELD_NUMBER = 4;
  private volatile java.lang.Object dir_;
  /**
   *
   *
   * <pre>
   * Working directory to use when running this step's container.
   * If this value is a relative path, it is relative to the build's working
   * directory. If this value is absolute, it may be outside the build's working
   * directory, in which case the contents of the path may not be persisted
   * across build step executions, unless a `volume` for that path is specified.
   * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
   * which specifies an absolute path, the `RepoSource` `dir` is ignored for
   * the step's execution.
   * </pre>
   *
   * <code>string dir = 4;</code>
   *
   * @return The dir.
   */
  @java.lang.Override
  public java.lang.String getDir() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Working directory to use when running this step's container.
   * If this value is a relative path, it is relative to the build's working
   * directory. If this value is absolute, it may be outside the build's working
   * directory, in which case the contents of the path may not be persisted
   * across build step executions, unless a `volume` for that path is specified.
   * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
   * which specifies an absolute path, the `RepoSource` `dir` is ignored for
   * the step's execution.
   * </pre>
   *
   * <code>string dir = 4;</code>
   *
   * @return The bytes for dir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirBytes() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Unique identifier for this build step, used in `wait_for` to
   * reference this build step as a dependency.
   * </pre>
   *
   * <code>string id = 5;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for this build step, used in `wait_for` to
   * reference this build step as a dependency.
   * </pre>
   *
   * <code>string id = 5;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WAIT_FOR_FIELD_NUMBER = 6;
  private com.google.protobuf.LazyStringList waitFor_;
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @return A list containing the waitFor.
   */
  public com.google.protobuf.ProtocolStringList getWaitForList() {
    return waitFor_;
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @return The count of waitFor.
   */
  public int getWaitForCount() {
    return waitFor_.size();
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The waitFor at the given index.
   */
  public java.lang.String getWaitFor(int index) {
    return waitFor_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the waitFor at the given index.
   */
  public com.google.protobuf.ByteString getWaitForBytes(int index) {
    return waitFor_.getByteString(index);
  }

  public static final int ENTRYPOINT_FIELD_NUMBER = 7;
  private volatile java.lang.Object entrypoint_;
  /**
   *
   *
   * <pre>
   * Entrypoint to be used instead of the build step image's default entrypoint.
   * If unset, the image's default entrypoint is used.
   * </pre>
   *
   * <code>string entrypoint = 7;</code>
   *
   * @return The entrypoint.
   */
  @java.lang.Override
  public java.lang.String getEntrypoint() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entrypoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Entrypoint to be used instead of the build step image's default entrypoint.
   * If unset, the image's default entrypoint is used.
   * </pre>
   *
   * <code>string entrypoint = 7;</code>
   *
   * @return The bytes for entrypoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntrypointBytes() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entrypoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_ENV_FIELD_NUMBER = 8;
  private com.google.protobuf.LazyStringList secretEnv_;
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @return A list containing the secretEnv.
   */
  public com.google.protobuf.ProtocolStringList getSecretEnvList() {
    return secretEnv_;
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @return The count of secretEnv.
   */
  public int getSecretEnvCount() {
    return secretEnv_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The secretEnv at the given index.
   */
  public java.lang.String getSecretEnv(int index) {
    return secretEnv_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the secretEnv at the given index.
   */
  public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
    return secretEnv_.getByteString(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloudbuild.v1.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int TIMING_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v1.TimeSpan timing_;
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the timing field is set.
   */
  @java.lang.Override
  public boolean hasTiming() {
    return timing_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The timing.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getTiming() {
    return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
    return getTiming();
  }

  public static final int PULL_TIMING_FIELD_NUMBER = 13;
  private com.google.cloudbuild.v1.TimeSpan pullTiming_;
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
   *
   * @return Whether the pullTiming field is set.
   */
  @java.lang.Override
  public boolean hasPullTiming() {
    return pullTiming_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
   *
   * @return The pullTiming.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getPullTiming() {
    return pullTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : pullTiming_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getPullTimingOrBuilder() {
    return getPullTiming();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 11;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int STATUS_FIELD_NUMBER = 12;
  private int status_;
  /**
   *
   *
   * <pre>
   * Output only. Status of the build step. At this time, build step status is
   * only updated on build completion; step status is not updated in real-time
   * as the build progresses.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the build step. At this time, build step status is
   * only updated on build completion; step status is not updated in real-time
   * as the build progresses.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.Status getStatus() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.Build.Status result =
        com.google.cloudbuild.v1.Build.Status.valueOf(status_);
    return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < env_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, env_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    if (!getDirBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, dir_);
    }
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, id_);
    }
    for (int i = 0; i < waitFor_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, waitFor_.getRaw(i));
    }
    if (!getEntrypointBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, entrypoint_);
    }
    for (int i = 0; i < secretEnv_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, secretEnv_.getRaw(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(9, volumes_.get(i));
    }
    if (timing_ != null) {
      output.writeMessage(10, getTiming());
    }
    if (timeout_ != null) {
      output.writeMessage(11, getTimeout());
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      output.writeEnum(12, status_);
    }
    if (pullTiming_ != null) {
      output.writeMessage(13, getPullTiming());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < env_.size(); i++) {
        dataSize += computeStringSizeNoTag(env_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEnvList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    if (!getDirBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, dir_);
    }
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < waitFor_.size(); i++) {
        dataSize += computeStringSizeNoTag(waitFor_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWaitForList().size();
    }
    if (!getEntrypointBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, entrypoint_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < secretEnv_.size(); i++) {
        dataSize += computeStringSizeNoTag(secretEnv_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSecretEnvList().size();
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, volumes_.get(i));
    }
    if (timing_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getTiming());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getTimeout());
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, status_);
    }
    if (pullTiming_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getPullTiming());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.BuildStep)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.BuildStep other = (com.google.cloudbuild.v1.BuildStep) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getDir().equals(other.getDir())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getWaitForList().equals(other.getWaitForList())) return false;
    if (!getEntrypoint().equals(other.getEntrypoint())) return false;
    if (!getSecretEnvList().equals(other.getSecretEnvList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (hasTiming() != other.hasTiming()) return false;
    if (hasTiming()) {
      if (!getTiming().equals(other.getTiming())) return false;
    }
    if (hasPullTiming() != other.hasPullTiming()) return false;
    if (hasPullTiming()) {
      if (!getPullTiming().equals(other.getPullTiming())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (status_ != other.status_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    hash = (37 * hash) + DIR_FIELD_NUMBER;
    hash = (53 * hash) + getDir().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getWaitForCount() > 0) {
      hash = (37 * hash) + WAIT_FOR_FIELD_NUMBER;
      hash = (53 * hash) + getWaitForList().hashCode();
    }
    hash = (37 * hash) + ENTRYPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntrypoint().hashCode();
    if (getSecretEnvCount() > 0) {
      hash = (37 * hash) + SECRET_ENV_FIELD_NUMBER;
      hash = (53 * hash) + getSecretEnvList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    if (hasTiming()) {
      hash = (37 * hash) + TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getTiming().hashCode();
    }
    if (hasPullTiming()) {
      hash = (37 * hash) + PULL_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getPullTiming().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.BuildStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A step in the build pipeline.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.BuildStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.BuildStep)
      com.google.cloudbuild.v1.BuildStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.BuildStep.class,
              com.google.cloudbuild.v1.BuildStep.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.BuildStep.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVolumesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      dir_ = "";

      id_ = "";

      waitFor_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      entrypoint_ = "";

      secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        volumesBuilder_.clear();
      }
      if (timingBuilder_ == null) {
        timing_ = null;
      } else {
        timing_ = null;
        timingBuilder_ = null;
      }
      if (pullTimingBuilder_ == null) {
        pullTiming_ = null;
      } else {
        pullTiming_ = null;
        pullTimingBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      status_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.BuildStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep build() {
      com.google.cloudbuild.v1.BuildStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep buildPartial() {
      com.google.cloudbuild.v1.BuildStep result = new com.google.cloudbuild.v1.BuildStep(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (((bitField0_ & 0x00000001) != 0)) {
        env_ = env_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.env_ = env_;
      if (((bitField0_ & 0x00000002) != 0)) {
        args_ = args_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.args_ = args_;
      result.dir_ = dir_;
      result.id_ = id_;
      if (((bitField0_ & 0x00000004) != 0)) {
        waitFor_ = waitFor_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.waitFor_ = waitFor_;
      result.entrypoint_ = entrypoint_;
      if (((bitField0_ & 0x00000008) != 0)) {
        secretEnv_ = secretEnv_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.secretEnv_ = secretEnv_;
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
      if (timingBuilder_ == null) {
        result.timing_ = timing_;
      } else {
        result.timing_ = timingBuilder_.build();
      }
      if (pullTimingBuilder_ == null) {
        result.pullTiming_ = pullTiming_;
      } else {
        result.pullTiming_ = pullTimingBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.status_ = status_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.BuildStep) {
        return mergeFrom((com.google.cloudbuild.v1.BuildStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.BuildStep other) {
      if (other == com.google.cloudbuild.v1.BuildStep.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.env_.isEmpty()) {
        if (env_.isEmpty()) {
          env_ = other.env_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureEnvIsMutable();
          env_.addAll(other.env_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (!other.getDir().isEmpty()) {
        dir_ = other.dir_;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.waitFor_.isEmpty()) {
        if (waitFor_.isEmpty()) {
          waitFor_ = other.waitFor_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureWaitForIsMutable();
          waitFor_.addAll(other.waitFor_);
        }
        onChanged();
      }
      if (!other.getEntrypoint().isEmpty()) {
        entrypoint_ = other.entrypoint_;
        onChanged();
      }
      if (!other.secretEnv_.isEmpty()) {
        if (secretEnv_.isEmpty()) {
          secretEnv_ = other.secretEnv_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureSecretEnvIsMutable();
          secretEnv_.addAll(other.secretEnv_);
        }
        onChanged();
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000010);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (other.hasTiming()) {
        mergeTiming(other.getTiming());
      }
      if (other.hasPullTiming()) {
        mergePullTiming(other.getPullTiming());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.BuildStep parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.BuildStep) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList env_ = com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        env_ = new com.google.protobuf.LazyStringArrayList(env_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return A list containing the env.
     */
    public com.google.protobuf.ProtocolStringList getEnvList() {
      return env_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return The count of env.
     */
    public int getEnvCount() {
      return env_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The env at the given index.
     */
    public java.lang.String getEnv(int index) {
      return env_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the env at the given index.
     */
    public com.google.protobuf.ByteString getEnvBytes(int index) {
      return env_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The env to set.
     * @return This builder for chaining.
     */
    public Builder setEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param value The env to add.
     * @return This builder for chaining.
     */
    public Builder addEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param values The env to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnv(java.lang.Iterable<java.lang.String> values) {
      ensureEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnv() {
      env_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param value The bytes of the env to add.
     * @return This builder for chaining.
     */
    public Builder addEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnvIsMutable();
      env_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList args_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureArgsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      return args_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object dir_ = "";
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return The dir.
     */
    public java.lang.String getDir() {
      java.lang.Object ref = dir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return The bytes for dir.
     */
    public com.google.protobuf.ByteString getDirBytes() {
      java.lang.Object ref = dir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @param value The dir to set.
     * @return This builder for chaining.
     */
    public Builder setDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dir_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDir() {

      dir_ = getDefaultInstance().getDir();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @param value The bytes for dir to set.
     * @return This builder for chaining.
     */
    public Builder setDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dir_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList waitFor_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureWaitForIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        waitFor_ = new com.google.protobuf.LazyStringArrayList(waitFor_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return A list containing the waitFor.
     */
    public com.google.protobuf.ProtocolStringList getWaitForList() {
      return waitFor_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return The count of waitFor.
     */
    public int getWaitForCount() {
      return waitFor_.size();
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The waitFor at the given index.
     */
    public java.lang.String getWaitFor(int index) {
      return waitFor_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the waitFor at the given index.
     */
    public com.google.protobuf.ByteString getWaitForBytes(int index) {
      return waitFor_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The waitFor to set.
     * @return This builder for chaining.
     */
    public Builder setWaitFor(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWaitForIsMutable();
      waitFor_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param value The waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addWaitFor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWaitForIsMutable();
      waitFor_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param values The waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addAllWaitFor(java.lang.Iterable<java.lang.String> values) {
      ensureWaitForIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, waitFor_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWaitFor() {
      waitFor_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param value The bytes of the waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addWaitForBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWaitForIsMutable();
      waitFor_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object entrypoint_ = "";
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return The entrypoint.
     */
    public java.lang.String getEntrypoint() {
      java.lang.Object ref = entrypoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entrypoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return The bytes for entrypoint.
     */
    public com.google.protobuf.ByteString getEntrypointBytes() {
      java.lang.Object ref = entrypoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entrypoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @param value The entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entrypoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntrypoint() {

      entrypoint_ = getDefaultInstance().getEntrypoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @param value The bytes for entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entrypoint_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList secretEnv_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSecretEnvIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        secretEnv_ = new com.google.protobuf.LazyStringArrayList(secretEnv_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return A list containing the secretEnv.
     */
    public com.google.protobuf.ProtocolStringList getSecretEnvList() {
      return secretEnv_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return The count of secretEnv.
     */
    public int getSecretEnvCount() {
      return secretEnv_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The secretEnv at the given index.
     */
    public java.lang.String getSecretEnv(int index) {
      return secretEnv_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the secretEnv at the given index.
     */
    public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
      return secretEnv_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The secretEnv to set.
     * @return This builder for chaining.
     */
    public Builder setSecretEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param value The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param values The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addAllSecretEnv(java.lang.Iterable<java.lang.String> values) {
      ensureSecretEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnv_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecretEnv() {
      secretEnv_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param value The bytes of the secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloudbuild.v1.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloudbuild.v1.Volume>(volumes_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Volume,
                com.google.cloudbuild.v1.Volume.Builder,
                com.google.cloudbuild.v1.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    private com.google.cloudbuild.v1.TimeSpan timing_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        timingBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the timing field is set.
     */
    public boolean hasTiming() {
      return timingBuilder_ != null || timing_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The timing.
     */
    public com.google.cloudbuild.v1.TimeSpan getTiming() {
      if (timingBuilder_ == null) {
        return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
      } else {
        return timingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (timingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timing_ = value;
        onChanged();
      } else {
        timingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (timingBuilder_ == null) {
        timing_ = builderForValue.build();
        onChanged();
      } else {
        timingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (timingBuilder_ == null) {
        if (timing_ != null) {
          timing_ =
              com.google.cloudbuild.v1.TimeSpan.newBuilder(timing_).mergeFrom(value).buildPartial();
        } else {
          timing_ = value;
        }
        onChanged();
      } else {
        timingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTiming() {
      if (timingBuilder_ == null) {
        timing_ = null;
        onChanged();
      } else {
        timing_ = null;
        timingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getTimingBuilder() {

      onChanged();
      return getTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
      if (timingBuilder_ != null) {
        return timingBuilder_.getMessageOrBuilder();
      } else {
        return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getTimingFieldBuilder() {
      if (timingBuilder_ == null) {
        timingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getTiming(), getParentForChildren(), isClean());
        timing_ = null;
      }
      return timingBuilder_;
    }

    private com.google.cloudbuild.v1.TimeSpan pullTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        pullTimingBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     *
     * @return Whether the pullTiming field is set.
     */
    public boolean hasPullTiming() {
      return pullTimingBuilder_ != null || pullTiming_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     *
     * @return The pullTiming.
     */
    public com.google.cloudbuild.v1.TimeSpan getPullTiming() {
      if (pullTimingBuilder_ == null) {
        return pullTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : pullTiming_;
      } else {
        return pullTimingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public Builder setPullTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (pullTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pullTiming_ = value;
        onChanged();
      } else {
        pullTimingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public Builder setPullTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (pullTimingBuilder_ == null) {
        pullTiming_ = builderForValue.build();
        onChanged();
      } else {
        pullTimingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public Builder mergePullTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (pullTimingBuilder_ == null) {
        if (pullTiming_ != null) {
          pullTiming_ =
              com.google.cloudbuild.v1.TimeSpan.newBuilder(pullTiming_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pullTiming_ = value;
        }
        onChanged();
      } else {
        pullTimingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public Builder clearPullTiming() {
      if (pullTimingBuilder_ == null) {
        pullTiming_ = null;
        onChanged();
      } else {
        pullTiming_ = null;
        pullTimingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getPullTimingBuilder() {

      onChanged();
      return getPullTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getPullTimingOrBuilder() {
      if (pullTimingBuilder_ != null) {
        return pullTimingBuilder_.getMessageOrBuilder();
      } else {
        return pullTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : pullTiming_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getPullTimingFieldBuilder() {
      if (pullTimingBuilder_ == null) {
        pullTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getPullTiming(), getParentForChildren(), isClean());
        pullTiming_ = null;
      }
      return pullTimingBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {

      status_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Status getStatus() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.Build.Status result =
          com.google.cloudbuild.v1.Build.Status.valueOf(status_);
      return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloudbuild.v1.Build.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }

      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Status status = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {

      status_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.BuildStep)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.BuildStep)
  private static final com.google.cloudbuild.v1.BuildStep DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.BuildStep();
  }

  public static com.google.cloudbuild.v1.BuildStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildStep> PARSER =
      new com.google.protobuf.AbstractParser<BuildStep>() {
        @java.lang.Override
        public BuildStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BuildStep(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BuildStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
