/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * WorkerConfig defines the configuration to be used for a creating workers in
 * the pool.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.WorkerConfig}
 */
public final class WorkerConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.WorkerConfig)
    WorkerConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkerConfig.newBuilder() to construct.
  private WorkerConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkerConfig() {
    machineType_ = "";
    tag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkerConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WorkerConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              machineType_ = s;
              break;
            }
          case 16:
            {
              diskSizeGb_ = input.readInt64();
              break;
            }
          case 26:
            {
              com.google.cloudbuild.v1.Network.Builder subBuilder = null;
              if (network_ != null) {
                subBuilder = network_.toBuilder();
              }
              network_ =
                  input.readMessage(com.google.cloudbuild.v1.Network.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(network_);
                network_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              tag_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WorkerConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WorkerConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.WorkerConfig.class,
            com.google.cloudbuild.v1.WorkerConfig.Builder.class);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object machineType_;
  /**
   *
   *
   * <pre>
   * Machine Type of the worker, such as n1-standard-1.
   * See https://cloud.google.com/compute/docs/machine-types.
   * If left blank, Cloud Build will use a standard unspecified machine to
   * create the worker pool.
   * `machine_type` is overridden if you specify a different machine type in
   * `build_options`. In this case, the VM specified in the `build_options`
   * will be created on demand at build time. For more information see
   * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
   * </pre>
   *
   * <code>string machine_type = 1;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Machine Type of the worker, such as n1-standard-1.
   * See https://cloud.google.com/compute/docs/machine-types.
   * If left blank, Cloud Build will use a standard unspecified machine to
   * create the worker pool.
   * `machine_type` is overridden if you specify a different machine type in
   * `build_options`. In this case, the VM specified in the `build_options`
   * will be created on demand at build time. For more information see
   * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
   * </pre>
   *
   * <code>string machine_type = 1;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 2;
  private long diskSizeGb_;
  /**
   *
   *
   * <pre>
   * Size of the disk attached to the worker, in GB.
   * See https://cloud.google.com/compute/docs/disks/
   * If `0` is specified, Cloud Build will use a standard disk size.
   * `disk_size` is overridden if you specify a different disk size in
   * `build_options`. In this case, a VM with a disk size specified in the
   * `build_options` will be created on demand at build time. For more
   * information see
   * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
   * </pre>
   *
   * <code>int64 disk_size_gb = 2;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int NETWORK_FIELD_NUMBER = 3;
  private com.google.cloudbuild.v1.Network network_;
  /**
   *
   *
   * <pre>
   * The network definition used to create the worker.
   * If this section is left empty, the workers will be created in
   * WorkerPool.project_id on the default network.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return network_ != null;
  }
  /**
   *
   *
   * <pre>
   * The network definition used to create the worker.
   * If this section is left empty, the workers will be created in
   * WorkerPool.project_id on the default network.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Network getNetwork() {
    return network_ == null ? com.google.cloudbuild.v1.Network.getDefaultInstance() : network_;
  }
  /**
   *
   *
   * <pre>
   * The network definition used to create the worker.
   * If this section is left empty, the workers will be created in
   * WorkerPool.project_id on the default network.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.NetworkOrBuilder getNetworkOrBuilder() {
    return getNetwork();
  }

  public static final int TAG_FIELD_NUMBER = 4;
  private volatile java.lang.Object tag_;
  /**
   *
   *
   * <pre>
   * The tag applied to the worker, and the same tag used by the firewall rule.
   * It is used to identify the Cloud Build workers among other VMs.
   * The default value for tag is `worker`.
   * </pre>
   *
   * <code>string tag = 4;</code>
   *
   * @return The tag.
   */
  @java.lang.Override
  public java.lang.String getTag() {
    java.lang.Object ref = tag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The tag applied to the worker, and the same tag used by the firewall rule.
   * It is used to identify the Cloud Build workers among other VMs.
   * The default value for tag is `worker`.
   * </pre>
   *
   * <code>string tag = 4;</code>
   *
   * @return The bytes for tag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagBytes() {
    java.lang.Object ref = tag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getMachineTypeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
    }
    if (diskSizeGb_ != 0L) {
      output.writeInt64(2, diskSizeGb_);
    }
    if (network_ != null) {
      output.writeMessage(3, getNetwork());
    }
    if (!getTagBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tag_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getMachineTypeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
    }
    if (diskSizeGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, diskSizeGb_);
    }
    if (network_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getNetwork());
    }
    if (!getTagBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, tag_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.WorkerConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.WorkerConfig other = (com.google.cloudbuild.v1.WorkerConfig) obj;

    if (!getMachineType().equals(other.getMachineType())) return false;
    if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (!getTag().equals(other.getTag())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    hash = (37 * hash) + TAG_FIELD_NUMBER;
    hash = (53 * hash) + getTag().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.WorkerConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * WorkerConfig defines the configuration to be used for a creating workers in
   * the pool.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.WorkerConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.WorkerConfig)
      com.google.cloudbuild.v1.WorkerConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.WorkerConfig.class,
              com.google.cloudbuild.v1.WorkerConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.WorkerConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      machineType_ = "";

      diskSizeGb_ = 0L;

      if (networkBuilder_ == null) {
        network_ = null;
      } else {
        network_ = null;
        networkBuilder_ = null;
      }
      tag_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.WorkerConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerConfig build() {
      com.google.cloudbuild.v1.WorkerConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerConfig buildPartial() {
      com.google.cloudbuild.v1.WorkerConfig result =
          new com.google.cloudbuild.v1.WorkerConfig(this);
      result.machineType_ = machineType_;
      result.diskSizeGb_ = diskSizeGb_;
      if (networkBuilder_ == null) {
        result.network_ = network_;
      } else {
        result.network_ = networkBuilder_.build();
      }
      result.tag_ = tag_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.WorkerConfig) {
        return mergeFrom((com.google.cloudbuild.v1.WorkerConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.WorkerConfig other) {
      if (other == com.google.cloudbuild.v1.WorkerConfig.getDefaultInstance()) return this;
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        onChanged();
      }
      if (other.getDiskSizeGb() != 0L) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.hasNetwork()) {
        mergeNetwork(other.getNetwork());
      }
      if (!other.getTag().isEmpty()) {
        tag_ = other.tag_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.WorkerConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.WorkerConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      machineType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {

      machineType_ = getDefaultInstance().getMachineType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      machineType_ = value;
      onChanged();
      return this;
    }

    private long diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     * </pre>
     *
     * <code>int64 disk_size_gb = 2;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     * </pre>
     *
     * <code>int64 disk_size_gb = 2;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     * </pre>
     *
     * <code>int64 disk_size_gb = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {

      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Network network_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Network,
            com.google.cloudbuild.v1.Network.Builder,
            com.google.cloudbuild.v1.NetworkOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return networkBuilder_ != null || network_ != null;
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     *
     * @return The network.
     */
    public com.google.cloudbuild.v1.Network getNetwork() {
      if (networkBuilder_ == null) {
        return network_ == null ? com.google.cloudbuild.v1.Network.getDefaultInstance() : network_;
      } else {
        return networkBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public Builder setNetwork(com.google.cloudbuild.v1.Network value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
        onChanged();
      } else {
        networkBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public Builder setNetwork(com.google.cloudbuild.v1.Network.Builder builderForValue) {
      if (networkBuilder_ == null) {
        network_ = builderForValue.build();
        onChanged();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public Builder mergeNetwork(com.google.cloudbuild.v1.Network value) {
      if (networkBuilder_ == null) {
        if (network_ != null) {
          network_ =
              com.google.cloudbuild.v1.Network.newBuilder(network_).mergeFrom(value).buildPartial();
        } else {
          network_ = value;
        }
        onChanged();
      } else {
        networkBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public Builder clearNetwork() {
      if (networkBuilder_ == null) {
        network_ = null;
        onChanged();
      } else {
        network_ = null;
        networkBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public com.google.cloudbuild.v1.Network.Builder getNetworkBuilder() {

      onChanged();
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    public com.google.cloudbuild.v1.NetworkOrBuilder getNetworkOrBuilder() {
      if (networkBuilder_ != null) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        return network_ == null ? com.google.cloudbuild.v1.Network.getDefaultInstance() : network_;
      }
    }
    /**
     *
     *
     * <pre>
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Network,
            com.google.cloudbuild.v1.Network.Builder,
            com.google.cloudbuild.v1.NetworkOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Network,
                com.google.cloudbuild.v1.Network.Builder,
                com.google.cloudbuild.v1.NetworkOrBuilder>(
                getNetwork(), getParentForChildren(), isClean());
        network_ = null;
      }
      return networkBuilder_;
    }

    private java.lang.Object tag_ = "";
    /**
     *
     *
     * <pre>
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     * </pre>
     *
     * <code>string tag = 4;</code>
     *
     * @return The tag.
     */
    public java.lang.String getTag() {
      java.lang.Object ref = tag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     * </pre>
     *
     * <code>string tag = 4;</code>
     *
     * @return The bytes for tag.
     */
    public com.google.protobuf.ByteString getTagBytes() {
      java.lang.Object ref = tag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     * </pre>
     *
     * <code>string tag = 4;</code>
     *
     * @param value The tag to set.
     * @return This builder for chaining.
     */
    public Builder setTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     * </pre>
     *
     * <code>string tag = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTag() {

      tag_ = getDefaultInstance().getTag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     * </pre>
     *
     * <code>string tag = 4;</code>
     *
     * @param value The bytes for tag to set.
     * @return This builder for chaining.
     */
    public Builder setTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.WorkerConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.WorkerConfig)
  private static final com.google.cloudbuild.v1.WorkerConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.WorkerConfig();
  }

  public static com.google.cloudbuild.v1.WorkerConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkerConfig> PARSER =
      new com.google.protobuf.AbstractParser<WorkerConfig>() {
        @java.lang.Override
        public WorkerConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WorkerConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WorkerConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkerConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
