/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Configuration for a WorkerPool to run the builds.
 * Workers are machines that Cloud Build uses to run your builds. By default,
 * all workers run in a project owned by Cloud Build. To have full control over
 * the workers that execute your builds -- such as enabling them to access
 * private resources on your private network -- you can request Cloud Build to
 * run the workers in your own project by creating a custom workers pool.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.WorkerPool}
 */
public final class WorkerPool extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.WorkerPool)
    WorkerPoolOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkerPool.newBuilder() to construct.
  private WorkerPool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkerPool() {
    name_ = "";
    projectId_ = "";
    serviceAccountEmail_ = "";
    regions_ = java.util.Collections.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkerPool();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WorkerPool(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccountEmail_ = s;
              break;
            }
          case 32:
            {
              workerCount_ = input.readInt64();
              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                regions_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              regions_.add(rawValue);
              break;
            }
          case 74:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  regions_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                regions_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (deleteTime_ != null) {
                subBuilder = deleteTime_.toBuilder();
              }
              deleteTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(deleteTime_);
                deleteTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 104:
            {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
          case 114:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 130:
            {
              com.google.cloudbuild.v1.WorkerConfig.Builder subBuilder = null;
              if (workerConfig_ != null) {
                subBuilder = workerConfig_.toBuilder();
              }
              workerConfig_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.WorkerConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(workerConfig_);
                workerConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 138:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        regions_ = java.util.Collections.unmodifiableList(regions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WorkerPool_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WorkerPool_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.WorkerPool.class,
            com.google.cloudbuild.v1.WorkerPool.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Supported GCP regions to create the `WorkerPool`.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.WorkerPool.Region}
   */
  public enum Region implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * no region
     * </pre>
     *
     * <code>REGION_UNSPECIFIED = 0;</code>
     */
    REGION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * us-central1 region
     * </pre>
     *
     * <code>US_CENTRAL1 = 1;</code>
     */
    US_CENTRAL1(1),
    /**
     *
     *
     * <pre>
     * us-west1 region
     * </pre>
     *
     * <code>US_WEST1 = 2;</code>
     */
    US_WEST1(2),
    /**
     *
     *
     * <pre>
     * us-east1 region
     * </pre>
     *
     * <code>US_EAST1 = 3;</code>
     */
    US_EAST1(3),
    /**
     *
     *
     * <pre>
     * us-east4 region
     * </pre>
     *
     * <code>US_EAST4 = 4;</code>
     */
    US_EAST4(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * no region
     * </pre>
     *
     * <code>REGION_UNSPECIFIED = 0;</code>
     */
    public static final int REGION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * us-central1 region
     * </pre>
     *
     * <code>US_CENTRAL1 = 1;</code>
     */
    public static final int US_CENTRAL1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * us-west1 region
     * </pre>
     *
     * <code>US_WEST1 = 2;</code>
     */
    public static final int US_WEST1_VALUE = 2;
    /**
     *
     *
     * <pre>
     * us-east1 region
     * </pre>
     *
     * <code>US_EAST1 = 3;</code>
     */
    public static final int US_EAST1_VALUE = 3;
    /**
     *
     *
     * <pre>
     * us-east4 region
     * </pre>
     *
     * <code>US_EAST4 = 4;</code>
     */
    public static final int US_EAST4_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Region valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Region forNumber(int value) {
      switch (value) {
        case 0:
          return REGION_UNSPECIFIED;
        case 1:
          return US_CENTRAL1;
        case 2:
          return US_WEST1;
        case 3:
          return US_EAST1;
        case 4:
          return US_EAST4;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Region> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Region> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Region>() {
          public Region findValueByNumber(int number) {
            return Region.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.WorkerPool.getDescriptor().getEnumTypes().get(0);
    }

    private static final Region[] VALUES = values();

    public static Region valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Region(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.WorkerPool.Region)
  }

  /**
   *
   *
   * <pre>
   * `WorkerPool` status
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.WorkerPool.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Status of the `WorkerPool` is unknown.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    STATUS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * `WorkerPool` is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * `WorkerPool` is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * `WorkerPool` is being deleted: cancelling builds and draining workers.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    DELETING(3),
    /**
     *
     *
     * <pre>
     * `WorkerPool` is deleted.
     * </pre>
     *
     * <code>DELETED = 4;</code>
     */
    DELETED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Status of the `WorkerPool` is unknown.
     * </pre>
     *
     * <code>STATUS_UNSPECIFIED = 0;</code>
     */
    public static final int STATUS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * `WorkerPool` is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * `WorkerPool` is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * `WorkerPool` is being deleted: cancelling builds and draining workers.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    public static final int DELETING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * `WorkerPool` is deleted.
     * </pre>
     *
     * <code>DELETED = 4;</code>
     */
    public static final int DELETED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return RUNNING;
        case 3:
          return DELETING;
        case 4:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.WorkerPool.getDescriptor().getEnumTypes().get(1);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.WorkerPool.Status)
  }

  public static final int NAME_FIELD_NUMBER = 14;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * User-defined name of the `WorkerPool`.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-defined name of the `WorkerPool`.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * The project ID of the GCP project for which the `WorkerPool` is created.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project ID of the GCP project for which the `WorkerPool` is created.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 3;
  private volatile java.lang.Object serviceAccountEmail_;
  /**
   *
   *
   * <pre>
   * Output only. The service account used to manage the `WorkerPool`. The
   * service account must have the Compute Instance Admin (Beta) permission at
   * the project level.
   * </pre>
   *
   * <code>string service_account_email = 3;</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The service account used to manage the `WorkerPool`. The
   * service account must have the Compute Instance Admin (Beta) permission at
   * the project level.
   * </pre>
   *
   * <code>string service_account_email = 3;</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKER_COUNT_FIELD_NUMBER = 4;
  private long workerCount_;
  /**
   *
   *
   * <pre>
   * Total number of workers to be created across all requested regions.
   * </pre>
   *
   * <code>int64 worker_count = 4;</code>
   *
   * @return The workerCount.
   */
  @java.lang.Override
  public long getWorkerCount() {
    return workerCount_;
  }

  public static final int WORKER_CONFIG_FIELD_NUMBER = 16;
  private com.google.cloudbuild.v1.WorkerConfig workerConfig_;
  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   *
   * @return Whether the workerConfig field is set.
   */
  @java.lang.Override
  public boolean hasWorkerConfig() {
    return workerConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   *
   * @return The workerConfig.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerConfig getWorkerConfig() {
    return workerConfig_ == null
        ? com.google.cloudbuild.v1.WorkerConfig.getDefaultInstance()
        : workerConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerConfigOrBuilder getWorkerConfigOrBuilder() {
    return getWorkerConfig();
  }

  public static final int REGIONS_FIELD_NUMBER = 9;
  private java.util.List<java.lang.Integer> regions_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloudbuild.v1.WorkerPool.Region>
      regions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloudbuild.v1.WorkerPool.Region>() {
            public com.google.cloudbuild.v1.WorkerPool.Region convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloudbuild.v1.WorkerPool.Region result =
                  com.google.cloudbuild.v1.WorkerPool.Region.valueOf(from);
              return result == null
                  ? com.google.cloudbuild.v1.WorkerPool.Region.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return A list containing the regions.
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.WorkerPool.Region> getRegionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloudbuild.v1.WorkerPool.Region>(
        regions_, regions_converter_);
  }
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return The count of regions.
   */
  @java.lang.Override
  public int getRegionsCount() {
    return regions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The regions at the given index.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerPool.Region getRegions(int index) {
    return regions_converter_.convert(regions_.get(index));
  }
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return A list containing the enum numeric values on the wire for regions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRegionsValueList() {
    return regions_;
  }
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of regions at the given index.
   */
  @java.lang.Override
  public int getRegionsValue(int index) {
    return regions_.get(index);
  }

  private int regionsMemoizedSerializedSize;

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp deleteTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return deleteTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return getDeleteTime();
  }

  public static final int STATUS_FIELD_NUMBER = 13;
  private int status_;
  /**
   *
   *
   * <pre>
   * Output only. WorkerPool Status.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. WorkerPool Status.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerPool.Status getStatus() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.WorkerPool.Status result =
        com.google.cloudbuild.v1.WorkerPool.Status.valueOf(status_);
    return result == null ? com.google.cloudbuild.v1.WorkerPool.Status.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!getServiceAccountEmailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceAccountEmail_);
    }
    if (workerCount_ != 0L) {
      output.writeInt64(4, workerCount_);
    }
    if (getRegionsList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(regionsMemoizedSerializedSize);
    }
    for (int i = 0; i < regions_.size(); i++) {
      output.writeEnumNoTag(regions_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (deleteTime_ != null) {
      output.writeMessage(12, getDeleteTime());
    }
    if (status_ != com.google.cloudbuild.v1.WorkerPool.Status.STATUS_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, status_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, name_);
    }
    if (workerConfig_ != null) {
      output.writeMessage(16, getWorkerConfig());
    }
    if (updateTime_ != null) {
      output.writeMessage(17, getUpdateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!getServiceAccountEmailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceAccountEmail_);
    }
    if (workerCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, workerCount_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < regions_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(regions_.get(i));
      }
      size += dataSize;
      if (!getRegionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      regionsMemoizedSerializedSize = dataSize;
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (deleteTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDeleteTime());
    }
    if (status_ != com.google.cloudbuild.v1.WorkerPool.Status.STATUS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, status_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, name_);
    }
    if (workerConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getWorkerConfig());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getUpdateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.WorkerPool)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.WorkerPool other = (com.google.cloudbuild.v1.WorkerPool) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (getWorkerCount() != other.getWorkerCount()) return false;
    if (hasWorkerConfig() != other.hasWorkerConfig()) return false;
    if (hasWorkerConfig()) {
      if (!getWorkerConfig().equals(other.getWorkerConfig())) return false;
    }
    if (!regions_.equals(other.regions_)) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (status_ != other.status_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    hash = (37 * hash) + WORKER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getWorkerCount());
    if (hasWorkerConfig()) {
      hash = (37 * hash) + WORKER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getWorkerConfig().hashCode();
    }
    if (getRegionsCount() > 0) {
      hash = (37 * hash) + REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + regions_.hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WorkerPool parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.WorkerPool prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a WorkerPool to run the builds.
   * Workers are machines that Cloud Build uses to run your builds. By default,
   * all workers run in a project owned by Cloud Build. To have full control over
   * the workers that execute your builds -- such as enabling them to access
   * private resources on your private network -- you can request Cloud Build to
   * run the workers in your own project by creating a custom workers pool.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.WorkerPool}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.WorkerPool)
      com.google.cloudbuild.v1.WorkerPoolOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerPool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.WorkerPool.class,
              com.google.cloudbuild.v1.WorkerPool.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.WorkerPool.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      projectId_ = "";

      serviceAccountEmail_ = "";

      workerCount_ = 0L;

      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }
      regions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = null;
      } else {
        deleteTime_ = null;
        deleteTimeBuilder_ = null;
      }
      status_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WorkerPool_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerPool getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.WorkerPool.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerPool build() {
      com.google.cloudbuild.v1.WorkerPool result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerPool buildPartial() {
      com.google.cloudbuild.v1.WorkerPool result = new com.google.cloudbuild.v1.WorkerPool(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.projectId_ = projectId_;
      result.serviceAccountEmail_ = serviceAccountEmail_;
      result.workerCount_ = workerCount_;
      if (workerConfigBuilder_ == null) {
        result.workerConfig_ = workerConfig_;
      } else {
        result.workerConfig_ = workerConfigBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        regions_ = java.util.Collections.unmodifiableList(regions_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.regions_ = regions_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (deleteTimeBuilder_ == null) {
        result.deleteTime_ = deleteTime_;
      } else {
        result.deleteTime_ = deleteTimeBuilder_.build();
      }
      result.status_ = status_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.WorkerPool) {
        return mergeFrom((com.google.cloudbuild.v1.WorkerPool) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.WorkerPool other) {
      if (other == com.google.cloudbuild.v1.WorkerPool.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        onChanged();
      }
      if (other.getWorkerCount() != 0L) {
        setWorkerCount(other.getWorkerCount());
      }
      if (other.hasWorkerConfig()) {
        mergeWorkerConfig(other.getWorkerConfig());
      }
      if (!other.regions_.isEmpty()) {
        if (regions_.isEmpty()) {
          regions_ = other.regions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRegionsIsMutable();
          regions_.addAll(other.regions_);
        }
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.WorkerPool parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.WorkerPool) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * User-defined name of the `WorkerPool`.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined name of the `WorkerPool`.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-defined name of the `WorkerPool`.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined name of the `WorkerPool`.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined name of the `WorkerPool`.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project ID of the GCP project for which the `WorkerPool` is created.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID of the GCP project for which the `WorkerPool` is created.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID of the GCP project for which the `WorkerPool` is created.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID of the GCP project for which the `WorkerPool` is created.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID of the GCP project for which the `WorkerPool` is created.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     * </pre>
     *
     * <code>string service_account_email = 3;</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     * </pre>
     *
     * <code>string service_account_email = 3;</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     * </pre>
     *
     * <code>string service_account_email = 3;</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccountEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     * </pre>
     *
     * <code>string service_account_email = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {

      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account used to manage the `WorkerPool`. The
     * service account must have the Compute Instance Admin (Beta) permission at
     * the project level.
     * </pre>
     *
     * <code>string service_account_email = 3;</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccountEmail_ = value;
      onChanged();
      return this;
    }

    private long workerCount_;
    /**
     *
     *
     * <pre>
     * Total number of workers to be created across all requested regions.
     * </pre>
     *
     * <code>int64 worker_count = 4;</code>
     *
     * @return The workerCount.
     */
    @java.lang.Override
    public long getWorkerCount() {
      return workerCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of workers to be created across all requested regions.
     * </pre>
     *
     * <code>int64 worker_count = 4;</code>
     *
     * @param value The workerCount to set.
     * @return This builder for chaining.
     */
    public Builder setWorkerCount(long value) {

      workerCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of workers to be created across all requested regions.
     * </pre>
     *
     * <code>int64 worker_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkerCount() {

      workerCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.WorkerConfig workerConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.WorkerConfig,
            com.google.cloudbuild.v1.WorkerConfig.Builder,
            com.google.cloudbuild.v1.WorkerConfigOrBuilder>
        workerConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     *
     * @return Whether the workerConfig field is set.
     */
    public boolean hasWorkerConfig() {
      return workerConfigBuilder_ != null || workerConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     *
     * @return The workerConfig.
     */
    public com.google.cloudbuild.v1.WorkerConfig getWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        return workerConfig_ == null
            ? com.google.cloudbuild.v1.WorkerConfig.getDefaultInstance()
            : workerConfig_;
      } else {
        return workerConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public Builder setWorkerConfig(com.google.cloudbuild.v1.WorkerConfig value) {
      if (workerConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workerConfig_ = value;
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public Builder setWorkerConfig(com.google.cloudbuild.v1.WorkerConfig.Builder builderForValue) {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = builderForValue.build();
        onChanged();
      } else {
        workerConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public Builder mergeWorkerConfig(com.google.cloudbuild.v1.WorkerConfig value) {
      if (workerConfigBuilder_ == null) {
        if (workerConfig_ != null) {
          workerConfig_ =
              com.google.cloudbuild.v1.WorkerConfig.newBuilder(workerConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          workerConfig_ = value;
        }
        onChanged();
      } else {
        workerConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public Builder clearWorkerConfig() {
      if (workerConfigBuilder_ == null) {
        workerConfig_ = null;
        onChanged();
      } else {
        workerConfig_ = null;
        workerConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public com.google.cloudbuild.v1.WorkerConfig.Builder getWorkerConfigBuilder() {

      onChanged();
      return getWorkerConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    public com.google.cloudbuild.v1.WorkerConfigOrBuilder getWorkerConfigOrBuilder() {
      if (workerConfigBuilder_ != null) {
        return workerConfigBuilder_.getMessageOrBuilder();
      } else {
        return workerConfig_ == null
            ? com.google.cloudbuild.v1.WorkerConfig.getDefaultInstance()
            : workerConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to be used for a creating workers in the `WorkerPool`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.WorkerConfig,
            com.google.cloudbuild.v1.WorkerConfig.Builder,
            com.google.cloudbuild.v1.WorkerConfigOrBuilder>
        getWorkerConfigFieldBuilder() {
      if (workerConfigBuilder_ == null) {
        workerConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.WorkerConfig,
                com.google.cloudbuild.v1.WorkerConfig.Builder,
                com.google.cloudbuild.v1.WorkerConfigOrBuilder>(
                getWorkerConfig(), getParentForChildren(), isClean());
        workerConfig_ = null;
      }
      return workerConfigBuilder_;
    }

    private java.util.List<java.lang.Integer> regions_ = java.util.Collections.emptyList();

    private void ensureRegionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        regions_ = new java.util.ArrayList<java.lang.Integer>(regions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @return A list containing the regions.
     */
    public java.util.List<com.google.cloudbuild.v1.WorkerPool.Region> getRegionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloudbuild.v1.WorkerPool.Region>(
          regions_, regions_converter_);
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @return The count of regions.
     */
    public int getRegionsCount() {
      return regions_.size();
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The regions at the given index.
     */
    public com.google.cloudbuild.v1.WorkerPool.Region getRegions(int index) {
      return regions_converter_.convert(regions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The regions to set.
     * @return This builder for chaining.
     */
    public Builder setRegions(int index, com.google.cloudbuild.v1.WorkerPool.Region value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param value The regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegions(com.google.cloudbuild.v1.WorkerPool.Region value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param values The regions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRegions(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.WorkerPool.Region> values) {
      ensureRegionsIsMutable();
      for (com.google.cloudbuild.v1.WorkerPool.Region value : values) {
        regions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegions() {
      regions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @return A list containing the enum numeric values on the wire for regions.
     */
    public java.util.List<java.lang.Integer> getRegionsValueList() {
      return java.util.Collections.unmodifiableList(regions_);
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of regions at the given index.
     */
    public int getRegionsValue(int index) {
      return regions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of regions at the given index.
     * @return This builder for chaining.
     */
    public Builder setRegionsValue(int index, int value) {
      ensureRegionsIsMutable();
      regions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param value The enum numeric value on the wire for regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegionsValue(int value) {
      ensureRegionsIsMutable();
      regions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions to create the `WorkerPool`. Regions can't be empty.
     * If Cloud Build adds a new GCP region in the future, the existing
     * `WorkerPool` will not be enabled in the new region automatically;
     * you must add the new region to the `regions` field to enable the
     * `WorkerPool` in that region.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
     *
     * @param values The enum numeric values on the wire for regions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRegionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureRegionsIsMutable();
      for (int value : values) {
        regions_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to update the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return deleteTimeBuilder_ != null || deleteTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
        onChanged();
      } else {
        deleteTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
        onChanged();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (deleteTime_ != null) {
          deleteTime_ =
              com.google.protobuf.Timestamp.newBuilder(deleteTime_).mergeFrom(value).buildPartial();
        } else {
          deleteTime_ = value;
        }
        onChanged();
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public Builder clearDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = null;
        onChanged();
      } else {
        deleteTime_ = null;
        deleteTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {

      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to delete the `WorkerPool` was
     * received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp delete_time = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. WorkerPool Status.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. WorkerPool Status.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {

      status_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. WorkerPool Status.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.WorkerPool.Status getStatus() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.WorkerPool.Status result =
          com.google.cloudbuild.v1.WorkerPool.Status.valueOf(status_);
      return result == null ? com.google.cloudbuild.v1.WorkerPool.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. WorkerPool Status.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloudbuild.v1.WorkerPool.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }

      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. WorkerPool Status.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {

      status_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.WorkerPool)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.WorkerPool)
  private static final com.google.cloudbuild.v1.WorkerPool DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.WorkerPool();
  }

  public static com.google.cloudbuild.v1.WorkerPool getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkerPool> PARSER =
      new com.google.protobuf.AbstractParser<WorkerPool>() {
        @java.lang.Override
        public WorkerPool parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WorkerPool(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WorkerPool> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkerPool> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.WorkerPool getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
