/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

public interface WorkerPoolOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.WorkerPool)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * User-defined name of the `WorkerPool`.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * User-defined name of the `WorkerPool`.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The project ID of the GCP project for which the `WorkerPool` is created.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  java.lang.String getProjectId();
  /**
   *
   *
   * <pre>
   * The project ID of the GCP project for which the `WorkerPool` is created.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  com.google.protobuf.ByteString getProjectIdBytes();

  /**
   *
   *
   * <pre>
   * Output only. The service account used to manage the `WorkerPool`. The
   * service account must have the Compute Instance Admin (Beta) permission at
   * the project level.
   * </pre>
   *
   * <code>string service_account_email = 3;</code>
   *
   * @return The serviceAccountEmail.
   */
  java.lang.String getServiceAccountEmail();
  /**
   *
   *
   * <pre>
   * Output only. The service account used to manage the `WorkerPool`. The
   * service account must have the Compute Instance Admin (Beta) permission at
   * the project level.
   * </pre>
   *
   * <code>string service_account_email = 3;</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  com.google.protobuf.ByteString getServiceAccountEmailBytes();

  /**
   *
   *
   * <pre>
   * Total number of workers to be created across all requested regions.
   * </pre>
   *
   * <code>int64 worker_count = 4;</code>
   *
   * @return The workerCount.
   */
  long getWorkerCount();

  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   *
   * @return Whether the workerConfig field is set.
   */
  boolean hasWorkerConfig();
  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   *
   * @return The workerConfig.
   */
  com.google.cloudbuild.v1.WorkerConfig getWorkerConfig();
  /**
   *
   *
   * <pre>
   * Configuration to be used for a creating workers in the `WorkerPool`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerConfig worker_config = 16;</code>
   */
  com.google.cloudbuild.v1.WorkerConfigOrBuilder getWorkerConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return A list containing the regions.
   */
  java.util.List<com.google.cloudbuild.v1.WorkerPool.Region> getRegionsList();
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return The count of regions.
   */
  int getRegionsCount();
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The regions at the given index.
   */
  com.google.cloudbuild.v1.WorkerPool.Region getRegions(int index);
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @return A list containing the enum numeric values on the wire for regions.
   */
  java.util.List<java.lang.Integer> getRegionsValueList();
  /**
   *
   *
   * <pre>
   * List of regions to create the `WorkerPool`. Regions can't be empty.
   * If Cloud Build adds a new GCP region in the future, the existing
   * `WorkerPool` will not be enabled in the new region automatically;
   * you must add the new region to the `regions` field to enable the
   * `WorkerPool` in that region.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.WorkerPool.Region regions = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of regions at the given index.
   */
  int getRegionsValue(int index);

  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to update the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17;</code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   *
   * @return Whether the deleteTime field is set.
   */
  boolean hasDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   *
   * @return The deleteTime.
   */
  com.google.protobuf.Timestamp getDeleteTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to delete the `WorkerPool` was
   * received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12;</code>
   */
  com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. WorkerPool Status.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
   *
   * @return The enum numeric value on the wire for status.
   */
  int getStatusValue();
  /**
   *
   *
   * <pre>
   * Output only. WorkerPool Status.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WorkerPool.Status status = 13;</code>
   *
   * @return The status.
   */
  com.google.cloudbuild.v1.WorkerPool.Status getStatus();
}
