/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * A build resource in the Cloud Build API.
 * At a high level, a `Build` describes where to find source code, how to build
 * it (for example, the builder image to run on the source), and where to store
 * the built artifacts.
 * Fields can include the following variables, which will be expanded when the
 * build is created:
 * - $PROJECT_ID: the project ID of the build.
 * - $BUILD_ID: the autogenerated ID of the build.
 * - $REPO_NAME: the source repository name specified by RepoSource.
 * - $BRANCH_NAME: the branch name specified by RepoSource.
 * - $TAG_NAME: the tag name specified by RepoSource.
 * - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
 *   resolved from the specified branch or tag.
 * - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Build}
 */
public final class Build extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Build)
    BuildOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Build.newBuilder() to construct.
  private Build(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Build() {
    name_ = "";
    id_ = "";
    projectId_ = "";
    status_ = 0;
    statusDetail_ = "";
    steps_ = java.util.Collections.emptyList();
    images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    logsBucket_ = "";
    buildTriggerId_ = "";
    logUrl_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    secrets_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Build();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Build(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.cloudbuild.v1.Source.Builder subBuilder = null;
              if (source_ != null) {
                subBuilder = source_.toBuilder();
              }
              source_ =
                  input.readMessage(com.google.cloudbuild.v1.Source.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(source_);
                source_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (finishTime_ != null) {
                subBuilder = finishTime_.toBuilder();
              }
              finishTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(finishTime_);
                finishTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.cloudbuild.v1.Results.Builder subBuilder = null;
              if (results_ != null) {
                subBuilder = results_.toBuilder();
              }
              results_ =
                  input.readMessage(com.google.cloudbuild.v1.Results.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(results_);
                results_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                steps_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuildStep>();
                mutable_bitField0_ |= 0x00000001;
              }
              steps_.add(
                  input.readMessage(
                      com.google.cloudbuild.v1.BuildStep.parser(), extensionRegistry));
              break;
            }
          case 98:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeout_ != null) {
                subBuilder = timeout_.toBuilder();
              }
              timeout_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeout_);
                timeout_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                images_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              images_.add(s);
              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          case 154:
            {
              java.lang.String s = input.readStringRequireUtf8();

              logsBucket_ = s;
              break;
            }
          case 170:
            {
              com.google.cloudbuild.v1.SourceProvenance.Builder subBuilder = null;
              if (sourceProvenance_ != null) {
                subBuilder = sourceProvenance_.toBuilder();
              }
              sourceProvenance_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.SourceProvenance.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(sourceProvenance_);
                sourceProvenance_ = subBuilder.buildPartial();
              }

              break;
            }
          case 178:
            {
              java.lang.String s = input.readStringRequireUtf8();

              buildTriggerId_ = s;
              break;
            }
          case 186:
            {
              com.google.cloudbuild.v1.BuildOptions.Builder subBuilder = null;
              if (options_ != null) {
                subBuilder = options_.toBuilder();
              }
              options_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.BuildOptions.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(options_);
                options_ = subBuilder.buildPartial();
              }

              break;
            }
          case 194:
            {
              java.lang.String s = input.readStringRequireUtf8();

              statusDetail_ = s;
              break;
            }
          case 202:
            {
              java.lang.String s = input.readStringRequireUtf8();

              logUrl_ = s;
              break;
            }
          case 234:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                substitutions_ =
                    com.google.protobuf.MapField.newMapField(
                        SubstitutionsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000004;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
                  input.readMessage(
                      SubstitutionsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              substitutions_
                  .getMutableMap()
                  .put(substitutions__.getKey(), substitutions__.getValue());
              break;
            }
          case 250:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                tags_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              tags_.add(s);
              break;
            }
          case 258:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                secrets_ = new java.util.ArrayList<com.google.cloudbuild.v1.Secret>();
                mutable_bitField0_ |= 0x00000010;
              }
              secrets_.add(
                  input.readMessage(com.google.cloudbuild.v1.Secret.parser(), extensionRegistry));
              break;
            }
          case 266:
            {
              if (!((mutable_bitField0_ & 0x00000020) != 0)) {
                timing_ =
                    com.google.protobuf.MapField.newMapField(TimingDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000020;
              }
              com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
                  timing__ =
                      input.readMessage(
                          TimingDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              timing_.getMutableMap().put(timing__.getKey(), timing__.getValue());
              break;
            }
          case 298:
            {
              com.google.cloudbuild.v1.Artifacts.Builder subBuilder = null;
              if (artifacts_ != null) {
                subBuilder = artifacts_.toBuilder();
              }
              artifacts_ =
                  input.readMessage(com.google.cloudbuild.v1.Artifacts.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(artifacts_);
                artifacts_ = subBuilder.buildPartial();
              }

              break;
            }
          case 322:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (queueTtl_ != null) {
                subBuilder = queueTtl_.toBuilder();
              }
              queueTtl_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queueTtl_);
                queueTtl_ = subBuilder.buildPartial();
              }

              break;
            }
          case 338:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccount_ = s;
              break;
            }
          case 362:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        steps_ = java.util.Collections.unmodifiableList(steps_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        images_ = images_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        tags_ = tags_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        secrets_ = java.util.Collections.unmodifiableList(secrets_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 29:
        return internalGetSubstitutions();
      case 33:
        return internalGetTiming();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Build_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Build.class, com.google.cloudbuild.v1.Build.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible status of a build or build step.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.Build.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Status of the build is unknown.
     * </pre>
     *
     * <code>STATUS_UNKNOWN = 0;</code>
     */
    STATUS_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Build or step is queued; work has not yet begun.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    QUEUED(1),
    /**
     *
     *
     * <pre>
     * Build or step is being executed.
     * </pre>
     *
     * <code>WORKING = 2;</code>
     */
    WORKING(2),
    /**
     *
     *
     * <pre>
     * Build or step finished successfully.
     * </pre>
     *
     * <code>SUCCESS = 3;</code>
     */
    SUCCESS(3),
    /**
     *
     *
     * <pre>
     * Build or step failed to complete successfully.
     * </pre>
     *
     * <code>FAILURE = 4;</code>
     */
    FAILURE(4),
    /**
     *
     *
     * <pre>
     * Build or step failed due to an internal cause.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 5;</code>
     */
    INTERNAL_ERROR(5),
    /**
     *
     *
     * <pre>
     * Build or step took longer than was allowed.
     * </pre>
     *
     * <code>TIMEOUT = 6;</code>
     */
    TIMEOUT(6),
    /**
     *
     *
     * <pre>
     * Build or step was canceled by a user.
     * </pre>
     *
     * <code>CANCELLED = 7;</code>
     */
    CANCELLED(7),
    /**
     *
     *
     * <pre>
     * Build was enqueued for longer than the value of `queue_ttl`.
     * </pre>
     *
     * <code>EXPIRED = 9;</code>
     */
    EXPIRED(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Status of the build is unknown.
     * </pre>
     *
     * <code>STATUS_UNKNOWN = 0;</code>
     */
    public static final int STATUS_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Build or step is queued; work has not yet begun.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    public static final int QUEUED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Build or step is being executed.
     * </pre>
     *
     * <code>WORKING = 2;</code>
     */
    public static final int WORKING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Build or step finished successfully.
     * </pre>
     *
     * <code>SUCCESS = 3;</code>
     */
    public static final int SUCCESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Build or step failed to complete successfully.
     * </pre>
     *
     * <code>FAILURE = 4;</code>
     */
    public static final int FAILURE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Build or step failed due to an internal cause.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 5;</code>
     */
    public static final int INTERNAL_ERROR_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Build or step took longer than was allowed.
     * </pre>
     *
     * <code>TIMEOUT = 6;</code>
     */
    public static final int TIMEOUT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Build or step was canceled by a user.
     * </pre>
     *
     * <code>CANCELLED = 7;</code>
     */
    public static final int CANCELLED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Build was enqueued for longer than the value of `queue_ttl`.
     * </pre>
     *
     * <code>EXPIRED = 9;</code>
     */
    public static final int EXPIRED_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNKNOWN;
        case 1:
          return QUEUED;
        case 2:
          return WORKING;
        case 3:
          return SUCCESS;
        case 4:
          return FAILURE;
        case 5:
          return INTERNAL_ERROR;
        case 6:
          return TIMEOUT;
        case 7:
          return CANCELLED;
        case 9:
          return EXPIRED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.Build.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.Build.Status)
  }

  public static final int NAME_FIELD_NUMBER = 45;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build}
   * is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build}
   * is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the build.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the build.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 16;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Output only. ID of the project.
   * </pre>
   *
   * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. ID of the project.
   * </pre>
   *
   * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private int status_;
  /**
   *
   *
   * <pre>
   * Output only. Status of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.Status getStatus() {
    @SuppressWarnings("deprecation")
    com.google.cloudbuild.v1.Build.Status result =
        com.google.cloudbuild.v1.Build.Status.valueOf(status_);
    return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_DETAIL_FIELD_NUMBER = 24;
  private volatile java.lang.Object statusDetail_;
  /**
   *
   *
   * <pre>
   * Output only. Customer-readable message about the current status.
   * </pre>
   *
   * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusDetail.
   */
  @java.lang.Override
  public java.lang.String getStatusDetail() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusDetail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Customer-readable message about the current status.
   * </pre>
   *
   * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusDetailBytes() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 3;
  private com.google.cloudbuild.v1.Source source_;
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return source_ != null;
  }
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Source getSource() {
    return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
  }
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceOrBuilder getSourceOrBuilder() {
    return getSource();
  }

  public static final int STEPS_FIELD_NUMBER = 11;
  private java.util.List<com.google.cloudbuild.v1.BuildStep> steps_;
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.BuildStep> getStepsList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.BuildStepOrBuilder>
      getStepsOrBuilderList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public int getStepsCount() {
    return steps_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStep getSteps(int index) {
    return steps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStepOrBuilder getStepsOrBuilder(int index) {
    return steps_.get(index);
  }

  public static final int RESULTS_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v1.Results results_;
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the results field is set.
   */
  @java.lang.Override
  public boolean hasResults() {
    return results_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The results.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Results getResults() {
    return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.ResultsOrBuilder getResultsOrBuilder() {
    return getResults();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int FINISH_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp finishTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the finishTime field is set.
   */
  @java.lang.Override
  public boolean hasFinishTime() {
    return finishTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The finishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinishTime() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
    return getFinishTime();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   * `timeout` starts ticking from `startTime`.
   * Default time is ten minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   * `timeout` starts ticking from `startTime`.
   * Default time is ten minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   * `timeout` starts ticking from `startTime`.
   * Default time is ten minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int IMAGES_FIELD_NUMBER = 13;
  private com.google.protobuf.LazyStringList images_;
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images are pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @return A list containing the images.
   */
  public com.google.protobuf.ProtocolStringList getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images are pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @return The count of images.
   */
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images are pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The images at the given index.
   */
  public java.lang.String getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   * The images are pushed using the builder service account's credentials.
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the images at the given index.
   */
  public com.google.protobuf.ByteString getImagesBytes(int index) {
    return images_.getByteString(index);
  }

  public static final int QUEUE_TTL_FIELD_NUMBER = 40;
  private com.google.protobuf.Duration queueTtl_;
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   *
   * @return Whether the queueTtl field is set.
   */
  @java.lang.Override
  public boolean hasQueueTtl() {
    return queueTtl_ != null;
  }
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   *
   * @return The queueTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getQueueTtl() {
    return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
  }
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getQueueTtlOrBuilder() {
    return getQueueTtl();
  }

  public static final int ARTIFACTS_FIELD_NUMBER = 37;
  private com.google.cloudbuild.v1.Artifacts artifacts_;
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   *
   * @return Whether the artifacts field is set.
   */
  @java.lang.Override
  public boolean hasArtifacts() {
    return artifacts_ != null;
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   *
   * @return The artifacts.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts getArtifacts() {
    return artifacts_ == null
        ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
        : artifacts_;
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.ArtifactsOrBuilder getArtifactsOrBuilder() {
    return getArtifacts();
  }

  public static final int LOGS_BUCKET_FIELD_NUMBER = 19;
  private volatile java.lang.Object logsBucket_;
  /**
   *
   *
   * <pre>
   * Google Cloud Storage bucket where logs should be written (see
   * [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
   * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * </pre>
   *
   * <code>string logs_bucket = 19;</code>
   *
   * @return The logsBucket.
   */
  @java.lang.Override
  public java.lang.String getLogsBucket() {
    java.lang.Object ref = logsBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logsBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage bucket where logs should be written (see
   * [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
   * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * </pre>
   *
   * <code>string logs_bucket = 19;</code>
   *
   * @return The bytes for logsBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogsBucketBytes() {
    java.lang.Object ref = logsBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logsBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PROVENANCE_FIELD_NUMBER = 21;
  private com.google.cloudbuild.v1.SourceProvenance sourceProvenance_;
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sourceProvenance field is set.
   */
  @java.lang.Override
  public boolean hasSourceProvenance() {
    return sourceProvenance_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourceProvenance.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceProvenance getSourceProvenance() {
    return sourceProvenance_ == null
        ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
        : sourceProvenance_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
    return getSourceProvenance();
  }

  public static final int BUILD_TRIGGER_ID_FIELD_NUMBER = 22;
  private volatile java.lang.Object buildTriggerId_;
  /**
   *
   *
   * <pre>
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   * </pre>
   *
   * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildTriggerId.
   */
  @java.lang.Override
  public java.lang.String getBuildTriggerId() {
    java.lang.Object ref = buildTriggerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildTriggerId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   * </pre>
   *
   * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildTriggerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildTriggerIdBytes() {
    java.lang.Object ref = buildTriggerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildTriggerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPTIONS_FIELD_NUMBER = 23;
  private com.google.cloudbuild.v1.BuildOptions options_;
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   *
   * @return Whether the options field is set.
   */
  @java.lang.Override
  public boolean hasOptions() {
    return options_ != null;
  }
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   *
   * @return The options.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions getOptions() {
    return options_ == null ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance() : options_;
  }
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptionsOrBuilder getOptionsOrBuilder() {
    return getOptions();
  }

  public static final int LOG_URL_FIELD_NUMBER = 25;
  private volatile java.lang.Object logUrl_;
  /**
   *
   *
   * <pre>
   * Output only. URL to logs for this build in Google Cloud Console.
   * </pre>
   *
   * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logUrl.
   */
  @java.lang.Override
  public java.lang.String getLogUrl() {
    java.lang.Object ref = logUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URL to logs for this build in Google Cloud Console.
   * </pre>
   *
   * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogUrlBytes() {
    java.lang.Object ref = logUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBSTITUTIONS_FIELD_NUMBER = 29;

  private static final class SubstitutionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v1.Cloudbuild
                .internal_static_google_devtools_cloudbuild_v1_Build_SubstitutionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSubstitutions() {
    if (substitutions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SubstitutionsDefaultEntryHolder.defaultEntry);
    }
    return substitutions_;
  }

  public int getSubstitutionsCount() {
    return internalGetSubstitutions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public boolean containsSubstitutions(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetSubstitutions().getMap().containsKey(key);
  }
  /** Use {@link #getSubstitutionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
    return getSubstitutionsMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
    return internalGetSubstitutions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TAGS_FIELD_NUMBER = 31;
  private com.google.protobuf.LazyStringList tags_;
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int SECRETS_FIELD_NUMBER = 32;
  private java.util.List<com.google.cloudbuild.v1.Secret> secrets_;
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Secret> getSecretsList() {
    return secrets_;
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.SecretOrBuilder>
      getSecretsOrBuilderList() {
    return secrets_;
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public int getSecretsCount() {
    return secrets_.size();
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Secret getSecrets(int index) {
    return secrets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SecretOrBuilder getSecretsOrBuilder(int index) {
    return secrets_.get(index);
  }

  public static final int TIMING_FIELD_NUMBER = 33;

  private static final class TimingDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloudbuild.v1.TimeSpan>newDefaultInstance(
                    com.google.cloudbuild.v1.Cloudbuild
                        .internal_static_google_devtools_cloudbuild_v1_Build_TimingEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloudbuild.v1.TimeSpan.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan> timing_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
      internalGetTiming() {
    if (timing_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TimingDefaultEntryHolder.defaultEntry);
    }
    return timing_;
  }

  public int getTimingCount() {
    return internalGetTiming().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   * * BUILD: time to execute all build steps
   * * PUSH: time to push all specified images.
   * * FETCHSOURCE: time to fetch source.
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsTiming(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetTiming().getMap().containsKey(key);
  }
  /** Use {@link #getTimingMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTiming() {
    return getTimingMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   * * BUILD: time to execute all build steps
   * * PUSH: time to push all specified images.
   * * FETCHSOURCE: time to fetch source.
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTimingMap() {
    return internalGetTiming().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   * * BUILD: time to execute all build steps
   * * PUSH: time to push all specified images.
   * * FETCHSOURCE: time to fetch source.
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getTimingOrDefault(
      java.lang.String key, com.google.cloudbuild.v1.TimeSpan defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
        internalGetTiming().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   * * BUILD: time to execute all build steps
   * * PUSH: time to push all specified images.
   * * FETCHSOURCE: time to fetch source.
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getTimingOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
        internalGetTiming().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 42;
  private volatile java.lang.Object serviceAccount_;
  /**
   *
   *
   * <pre>
   * IAM service account whose credentials will be used at build runtime.
   * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   * ACCOUNT can be email address or uniqueId of the service account.
   * This field is in alpha and is not publicly available.
   * </pre>
   *
   * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IAM service account whose credentials will be used at build runtime.
   * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   * ACCOUNT can be email address or uniqueId of the service account.
   * This field is in alpha and is not publicly available.
   * </pre>
   *
   * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      output.writeEnum(2, status_);
    }
    if (source_ != null) {
      output.writeMessage(3, getSource());
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(7, getStartTime());
    }
    if (finishTime_ != null) {
      output.writeMessage(8, getFinishTime());
    }
    if (results_ != null) {
      output.writeMessage(10, getResults());
    }
    for (int i = 0; i < steps_.size(); i++) {
      output.writeMessage(11, steps_.get(i));
    }
    if (timeout_ != null) {
      output.writeMessage(12, getTimeout());
    }
    for (int i = 0; i < images_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, images_.getRaw(i));
    }
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, projectId_);
    }
    if (!getLogsBucketBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, logsBucket_);
    }
    if (sourceProvenance_ != null) {
      output.writeMessage(21, getSourceProvenance());
    }
    if (!getBuildTriggerIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, buildTriggerId_);
    }
    if (options_ != null) {
      output.writeMessage(23, getOptions());
    }
    if (!getStatusDetailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, statusDetail_);
    }
    if (!getLogUrlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, logUrl_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSubstitutions(), SubstitutionsDefaultEntryHolder.defaultEntry, 29);
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 31, tags_.getRaw(i));
    }
    for (int i = 0; i < secrets_.size(); i++) {
      output.writeMessage(32, secrets_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTiming(), TimingDefaultEntryHolder.defaultEntry, 33);
    if (artifacts_ != null) {
      output.writeMessage(37, getArtifacts());
    }
    if (queueTtl_ != null) {
      output.writeMessage(40, getQueueTtl());
    }
    if (!getServiceAccountBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 42, serviceAccount_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 45, name_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, status_);
    }
    if (source_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSource());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (finishTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getFinishTime());
    }
    if (results_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getResults());
    }
    for (int i = 0; i < steps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, steps_.get(i));
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTimeout());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < images_.size(); i++) {
        dataSize += computeStringSizeNoTag(images_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getImagesList().size();
    }
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, projectId_);
    }
    if (!getLogsBucketBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, logsBucket_);
    }
    if (sourceProvenance_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getSourceProvenance());
    }
    if (!getBuildTriggerIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, buildTriggerId_);
    }
    if (options_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getOptions());
    }
    if (!getStatusDetailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, statusDetail_);
    }
    if (!getLogUrlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, logUrl_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSubstitutions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
          SubstitutionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, substitutions__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getTagsList().size();
    }
    for (int i = 0; i < secrets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, secrets_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloudbuild.v1.TimeSpan> entry :
        internalGetTiming().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan> timing__ =
          TimingDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33, timing__);
    }
    if (artifacts_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, getArtifacts());
    }
    if (queueTtl_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(40, getQueueTtl());
    }
    if (!getServiceAccountBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(42, serviceAccount_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(45, name_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Build)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Build other = (com.google.cloudbuild.v1.Build) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (status_ != other.status_) return false;
    if (!getStatusDetail().equals(other.getStatusDetail())) return false;
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (!getStepsList().equals(other.getStepsList())) return false;
    if (hasResults() != other.hasResults()) return false;
    if (hasResults()) {
      if (!getResults().equals(other.getResults())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasFinishTime() != other.hasFinishTime()) return false;
    if (hasFinishTime()) {
      if (!getFinishTime().equals(other.getFinishTime())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getImagesList().equals(other.getImagesList())) return false;
    if (hasQueueTtl() != other.hasQueueTtl()) return false;
    if (hasQueueTtl()) {
      if (!getQueueTtl().equals(other.getQueueTtl())) return false;
    }
    if (hasArtifacts() != other.hasArtifacts()) return false;
    if (hasArtifacts()) {
      if (!getArtifacts().equals(other.getArtifacts())) return false;
    }
    if (!getLogsBucket().equals(other.getLogsBucket())) return false;
    if (hasSourceProvenance() != other.hasSourceProvenance()) return false;
    if (hasSourceProvenance()) {
      if (!getSourceProvenance().equals(other.getSourceProvenance())) return false;
    }
    if (!getBuildTriggerId().equals(other.getBuildTriggerId())) return false;
    if (hasOptions() != other.hasOptions()) return false;
    if (hasOptions()) {
      if (!getOptions().equals(other.getOptions())) return false;
    }
    if (!getLogUrl().equals(other.getLogUrl())) return false;
    if (!internalGetSubstitutions().equals(other.internalGetSubstitutions())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getSecretsList().equals(other.getSecretsList())) return false;
    if (!internalGetTiming().equals(other.internalGetTiming())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + STATUS_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStatusDetail().hashCode();
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (getStepsCount() > 0) {
      hash = (37 * hash) + STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getStepsList().hashCode();
    }
    if (hasResults()) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResults().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasFinishTime()) {
      hash = (37 * hash) + FINISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinishTime().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (hasQueueTtl()) {
      hash = (37 * hash) + QUEUE_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getQueueTtl().hashCode();
    }
    if (hasArtifacts()) {
      hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getArtifacts().hashCode();
    }
    hash = (37 * hash) + LOGS_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getLogsBucket().hashCode();
    if (hasSourceProvenance()) {
      hash = (37 * hash) + SOURCE_PROVENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceProvenance().hashCode();
    }
    hash = (37 * hash) + BUILD_TRIGGER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBuildTriggerId().hashCode();
    if (hasOptions()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOptions().hashCode();
    }
    hash = (37 * hash) + LOG_URL_FIELD_NUMBER;
    hash = (53 * hash) + getLogUrl().hashCode();
    if (!internalGetSubstitutions().getMap().isEmpty()) {
      hash = (37 * hash) + SUBSTITUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSubstitutions().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (getSecretsCount() > 0) {
      hash = (37 * hash) + SECRETS_FIELD_NUMBER;
      hash = (53 * hash) + getSecretsList().hashCode();
    }
    if (!internalGetTiming().getMap().isEmpty()) {
      hash = (37 * hash) + TIMING_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTiming().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Build parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Build prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A build resource in the Cloud Build API.
   * At a high level, a `Build` describes where to find source code, how to build
   * it (for example, the builder image to run on the source), and where to store
   * the built artifacts.
   * Fields can include the following variables, which will be expanded when the
   * build is created:
   * - $PROJECT_ID: the project ID of the build.
   * - $BUILD_ID: the autogenerated ID of the build.
   * - $REPO_NAME: the source repository name specified by RepoSource.
   * - $BRANCH_NAME: the branch name specified by RepoSource.
   * - $TAG_NAME: the tag name specified by RepoSource.
   * - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
   *   resolved from the specified branch or tag.
   * - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Build}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Build)
      com.google.cloudbuild.v1.BuildOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 29:
          return internalGetSubstitutions();
        case 33:
          return internalGetTiming();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 29:
          return internalGetMutableSubstitutions();
        case 33:
          return internalGetMutableTiming();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Build.class, com.google.cloudbuild.v1.Build.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Build.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStepsFieldBuilder();
        getSecretsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      id_ = "";

      projectId_ = "";

      status_ = 0;

      statusDetail_ = "";

      if (sourceBuilder_ == null) {
        source_ = null;
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        stepsBuilder_.clear();
      }
      if (resultsBuilder_ == null) {
        results_ = null;
      } else {
        results_ = null;
        resultsBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (finishTimeBuilder_ == null) {
        finishTime_ = null;
      } else {
        finishTime_ = null;
        finishTimeBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (queueTtlBuilder_ == null) {
        queueTtl_ = null;
      } else {
        queueTtl_ = null;
        queueTtlBuilder_ = null;
      }
      if (artifactsBuilder_ == null) {
        artifacts_ = null;
      } else {
        artifacts_ = null;
        artifactsBuilder_ = null;
      }
      logsBucket_ = "";

      if (sourceProvenanceBuilder_ == null) {
        sourceProvenance_ = null;
      } else {
        sourceProvenance_ = null;
        sourceProvenanceBuilder_ = null;
      }
      buildTriggerId_ = "";

      if (optionsBuilder_ == null) {
        options_ = null;
      } else {
        options_ = null;
        optionsBuilder_ = null;
      }
      logUrl_ = "";

      internalGetMutableSubstitutions().clear();
      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      if (secretsBuilder_ == null) {
        secrets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        secretsBuilder_.clear();
      }
      internalGetMutableTiming().clear();
      serviceAccount_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Build.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build build() {
      com.google.cloudbuild.v1.Build result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build buildPartial() {
      com.google.cloudbuild.v1.Build result = new com.google.cloudbuild.v1.Build(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.id_ = id_;
      result.projectId_ = projectId_;
      result.status_ = status_;
      result.statusDetail_ = statusDetail_;
      if (sourceBuilder_ == null) {
        result.source_ = source_;
      } else {
        result.source_ = sourceBuilder_.build();
      }
      if (stepsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          steps_ = java.util.Collections.unmodifiableList(steps_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.steps_ = steps_;
      } else {
        result.steps_ = stepsBuilder_.build();
      }
      if (resultsBuilder_ == null) {
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (finishTimeBuilder_ == null) {
        result.finishTime_ = finishTime_;
      } else {
        result.finishTime_ = finishTimeBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        images_ = images_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.images_ = images_;
      if (queueTtlBuilder_ == null) {
        result.queueTtl_ = queueTtl_;
      } else {
        result.queueTtl_ = queueTtlBuilder_.build();
      }
      if (artifactsBuilder_ == null) {
        result.artifacts_ = artifacts_;
      } else {
        result.artifacts_ = artifactsBuilder_.build();
      }
      result.logsBucket_ = logsBucket_;
      if (sourceProvenanceBuilder_ == null) {
        result.sourceProvenance_ = sourceProvenance_;
      } else {
        result.sourceProvenance_ = sourceProvenanceBuilder_.build();
      }
      result.buildTriggerId_ = buildTriggerId_;
      if (optionsBuilder_ == null) {
        result.options_ = options_;
      } else {
        result.options_ = optionsBuilder_.build();
      }
      result.logUrl_ = logUrl_;
      result.substitutions_ = internalGetSubstitutions();
      result.substitutions_.makeImmutable();
      if (((bitField0_ & 0x00000008) != 0)) {
        tags_ = tags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.tags_ = tags_;
      if (secretsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          secrets_ = java.util.Collections.unmodifiableList(secrets_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.secrets_ = secrets_;
      } else {
        result.secrets_ = secretsBuilder_.build();
      }
      result.timing_ = internalGetTiming();
      result.timing_.makeImmutable();
      result.serviceAccount_ = serviceAccount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Build) {
        return mergeFrom((com.google.cloudbuild.v1.Build) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Build other) {
      if (other == com.google.cloudbuild.v1.Build.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStatusDetail().isEmpty()) {
        statusDetail_ = other.statusDetail_;
        onChanged();
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (stepsBuilder_ == null) {
        if (!other.steps_.isEmpty()) {
          if (steps_.isEmpty()) {
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureStepsIsMutable();
            steps_.addAll(other.steps_);
          }
          onChanged();
        }
      } else {
        if (!other.steps_.isEmpty()) {
          if (stepsBuilder_.isEmpty()) {
            stepsBuilder_.dispose();
            stepsBuilder_ = null;
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000001);
            stepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStepsFieldBuilder()
                    : null;
          } else {
            stepsBuilder_.addAllMessages(other.steps_);
          }
        }
      }
      if (other.hasResults()) {
        mergeResults(other.getResults());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasFinishTime()) {
        mergeFinishTime(other.getFinishTime());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (!other.images_.isEmpty()) {
        if (images_.isEmpty()) {
          images_ = other.images_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureImagesIsMutable();
          images_.addAll(other.images_);
        }
        onChanged();
      }
      if (other.hasQueueTtl()) {
        mergeQueueTtl(other.getQueueTtl());
      }
      if (other.hasArtifacts()) {
        mergeArtifacts(other.getArtifacts());
      }
      if (!other.getLogsBucket().isEmpty()) {
        logsBucket_ = other.logsBucket_;
        onChanged();
      }
      if (other.hasSourceProvenance()) {
        mergeSourceProvenance(other.getSourceProvenance());
      }
      if (!other.getBuildTriggerId().isEmpty()) {
        buildTriggerId_ = other.buildTriggerId_;
        onChanged();
      }
      if (other.hasOptions()) {
        mergeOptions(other.getOptions());
      }
      if (!other.getLogUrl().isEmpty()) {
        logUrl_ = other.logUrl_;
        onChanged();
      }
      internalGetMutableSubstitutions().mergeFrom(other.internalGetSubstitutions());
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (secretsBuilder_ == null) {
        if (!other.secrets_.isEmpty()) {
          if (secrets_.isEmpty()) {
            secrets_ = other.secrets_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureSecretsIsMutable();
            secrets_.addAll(other.secrets_);
          }
          onChanged();
        }
      } else {
        if (!other.secrets_.isEmpty()) {
          if (secretsBuilder_.isEmpty()) {
            secretsBuilder_.dispose();
            secretsBuilder_ = null;
            secrets_ = other.secrets_;
            bitField0_ = (bitField0_ & ~0x00000010);
            secretsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretsFieldBuilder()
                    : null;
          } else {
            secretsBuilder_.addAllMessages(other.secrets_);
          }
        }
      }
      internalGetMutableTiming().mergeFrom(other.internalGetTiming());
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.Build parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.Build) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {

      status_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Status getStatus() {
      @SuppressWarnings("deprecation")
      com.google.cloudbuild.v1.Build.Status result =
          com.google.cloudbuild.v1.Build.Status.valueOf(status_);
      return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloudbuild.v1.Build.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }

      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {

      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusDetail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusDetail.
     */
    public java.lang.String getStatusDetail() {
      java.lang.Object ref = statusDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusDetail.
     */
    public com.google.protobuf.ByteString getStatusDetailBytes() {
      java.lang.Object ref = statusDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      statusDetail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusDetail() {

      statusDetail_ = getDefaultInstance().getStatusDetail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      statusDetail_ = value;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Source source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Source,
            com.google.cloudbuild.v1.Source.Builder,
            com.google.cloudbuild.v1.SourceOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return sourceBuilder_ != null || source_ != null;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     *
     * @return The source.
     */
    public com.google.cloudbuild.v1.Source getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder setSource(com.google.cloudbuild.v1.Source value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        sourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder setSource(com.google.cloudbuild.v1.Source.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder mergeSource(com.google.cloudbuild.v1.Source value) {
      if (sourceBuilder_ == null) {
        if (source_ != null) {
          source_ =
              com.google.cloudbuild.v1.Source.newBuilder(source_).mergeFrom(value).buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        sourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder clearSource() {
      if (sourceBuilder_ == null) {
        source_ = null;
        onChanged();
      } else {
        source_ = null;
        sourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public com.google.cloudbuild.v1.Source.Builder getSourceBuilder() {

      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public com.google.cloudbuild.v1.SourceOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Source,
            com.google.cloudbuild.v1.Source.Builder,
            com.google.cloudbuild.v1.SourceOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Source,
                com.google.cloudbuild.v1.Source.Builder,
                com.google.cloudbuild.v1.SourceOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.BuildStep> steps_ =
        java.util.Collections.emptyList();

    private void ensureStepsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        steps_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuildStep>(steps_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuildStep,
            com.google.cloudbuild.v1.BuildStep.Builder,
            com.google.cloudbuild.v1.BuildStepOrBuilder>
        stepsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuildStep> getStepsList() {
      if (stepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(steps_);
      } else {
        return stepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public int getStepsCount() {
      if (stepsBuilder_ == null) {
        return steps_.size();
      } else {
        return stepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep getSteps(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder setSteps(int index, com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.set(index, value);
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder setSteps(int index, com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.set(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(int index, com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(index, value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(int index, com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addAllSteps(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.BuildStep> values) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
        onChanged();
      } else {
        stepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder clearSteps() {
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        stepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder removeSteps(int index) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.remove(index);
        onChanged();
      } else {
        stepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder getStepsBuilder(int index) {
      return getStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStepOrBuilder getStepsOrBuilder(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.BuildStepOrBuilder>
        getStepsOrBuilderList() {
      if (stepsBuilder_ != null) {
        return stepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(steps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder addStepsBuilder() {
      return getStepsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.BuildStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder addStepsBuilder(int index) {
      return getStepsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.BuildStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuildStep.Builder> getStepsBuilderList() {
      return getStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuildStep,
            com.google.cloudbuild.v1.BuildStep.Builder,
            com.google.cloudbuild.v1.BuildStepOrBuilder>
        getStepsFieldBuilder() {
      if (stepsBuilder_ == null) {
        stepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.BuildStep,
                com.google.cloudbuild.v1.BuildStep.Builder,
                com.google.cloudbuild.v1.BuildStepOrBuilder>(
                steps_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        steps_ = null;
      }
      return stepsBuilder_;
    }

    private com.google.cloudbuild.v1.Results results_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Results,
            com.google.cloudbuild.v1.Results.Builder,
            com.google.cloudbuild.v1.ResultsOrBuilder>
        resultsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the results field is set.
     */
    public boolean hasResults() {
      return resultsBuilder_ != null || results_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The results.
     */
    public com.google.cloudbuild.v1.Results getResults() {
      if (resultsBuilder_ == null) {
        return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
      } else {
        return resultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResults(com.google.cloudbuild.v1.Results value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        results_ = value;
        onChanged();
      } else {
        resultsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResults(com.google.cloudbuild.v1.Results.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        results_ = builderForValue.build();
        onChanged();
      } else {
        resultsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResults(com.google.cloudbuild.v1.Results value) {
      if (resultsBuilder_ == null) {
        if (results_ != null) {
          results_ =
              com.google.cloudbuild.v1.Results.newBuilder(results_).mergeFrom(value).buildPartial();
        } else {
          results_ = value;
        }
        onChanged();
      } else {
        resultsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = null;
        onChanged();
      } else {
        results_ = null;
        resultsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Results.Builder getResultsBuilder() {

      onChanged();
      return getResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.ResultsOrBuilder getResultsOrBuilder() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilder();
      } else {
        return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Results,
            com.google.cloudbuild.v1.Results.Builder,
            com.google.cloudbuild.v1.ResultsOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Results,
                com.google.cloudbuild.v1.Results.Builder,
                com.google.cloudbuild.v1.ResultsOrBuilder>(
                getResults(), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the finishTime field is set.
     */
    public boolean hasFinishTime() {
      return finishTimeBuilder_ != null || finishTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finishTime.
     */
    public com.google.protobuf.Timestamp getFinishTime() {
      if (finishTimeBuilder_ == null) {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      } else {
        return finishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishTime_ = value;
        onChanged();
      } else {
        finishTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finishTimeBuilder_ == null) {
        finishTime_ = builderForValue.build();
        onChanged();
      } else {
        finishTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (finishTime_ != null) {
          finishTime_ =
              com.google.protobuf.Timestamp.newBuilder(finishTime_).mergeFrom(value).buildPartial();
        } else {
          finishTime_ = value;
        }
        onChanged();
      } else {
        finishTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFinishTime() {
      if (finishTimeBuilder_ == null) {
        finishTime_ = null;
        onChanged();
      } else {
        finishTime_ = null;
        finishTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getFinishTimeBuilder() {

      onChanged();
      return getFinishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
      if (finishTimeBuilder_ != null) {
        return finishTimeBuilder_.getMessageOrBuilder();
      } else {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinishTimeFieldBuilder() {
      if (finishTimeBuilder_ == null) {
        finishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinishTime(), getParentForChildren(), isClean());
        finishTime_ = null;
      }
      return finishTimeBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     * `timeout` starts ticking from `startTime`.
     * Default time is ten minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private com.google.protobuf.LazyStringList images_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureImagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        images_ = new com.google.protobuf.LazyStringArrayList(images_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return A list containing the images.
     */
    public com.google.protobuf.ProtocolStringList getImagesList() {
      return images_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return The count of images.
     */
    public int getImagesCount() {
      return images_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The images at the given index.
     */
    public java.lang.String getImages(int index) {
      return images_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the images at the given index.
     */
    public com.google.protobuf.ByteString getImagesBytes(int index) {
      return images_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The images to set.
     * @return This builder for chaining.
     */
    public Builder setImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param value The images to add.
     * @return This builder for chaining.
     */
    public Builder addImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param values The images to add.
     * @return This builder for chaining.
     */
    public Builder addAllImages(java.lang.Iterable<java.lang.String> values) {
      ensureImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImages() {
      images_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param value The bytes of the images to add.
     * @return This builder for chaining.
     */
    public Builder addImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureImagesIsMutable();
      images_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration queueTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        queueTtlBuilder_;
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     *
     * @return Whether the queueTtl field is set.
     */
    public boolean hasQueueTtl() {
      return queueTtlBuilder_ != null || queueTtl_ != null;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     *
     * @return The queueTtl.
     */
    public com.google.protobuf.Duration getQueueTtl() {
      if (queueTtlBuilder_ == null) {
        return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
      } else {
        return queueTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder setQueueTtl(com.google.protobuf.Duration value) {
      if (queueTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queueTtl_ = value;
        onChanged();
      } else {
        queueTtlBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder setQueueTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (queueTtlBuilder_ == null) {
        queueTtl_ = builderForValue.build();
        onChanged();
      } else {
        queueTtlBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder mergeQueueTtl(com.google.protobuf.Duration value) {
      if (queueTtlBuilder_ == null) {
        if (queueTtl_ != null) {
          queueTtl_ =
              com.google.protobuf.Duration.newBuilder(queueTtl_).mergeFrom(value).buildPartial();
        } else {
          queueTtl_ = value;
        }
        onChanged();
      } else {
        queueTtlBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder clearQueueTtl() {
      if (queueTtlBuilder_ == null) {
        queueTtl_ = null;
        onChanged();
      } else {
        queueTtl_ = null;
        queueTtlBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public com.google.protobuf.Duration.Builder getQueueTtlBuilder() {

      onChanged();
      return getQueueTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public com.google.protobuf.DurationOrBuilder getQueueTtlOrBuilder() {
      if (queueTtlBuilder_ != null) {
        return queueTtlBuilder_.getMessageOrBuilder();
      } else {
        return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getQueueTtlFieldBuilder() {
      if (queueTtlBuilder_ == null) {
        queueTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getQueueTtl(), getParentForChildren(), isClean());
        queueTtl_ = null;
      }
      return queueTtlBuilder_;
    }

    private com.google.cloudbuild.v1.Artifacts artifacts_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts,
            com.google.cloudbuild.v1.Artifacts.Builder,
            com.google.cloudbuild.v1.ArtifactsOrBuilder>
        artifactsBuilder_;
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     *
     * @return Whether the artifacts field is set.
     */
    public boolean hasArtifacts() {
      return artifactsBuilder_ != null || artifacts_ != null;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     *
     * @return The artifacts.
     */
    public com.google.cloudbuild.v1.Artifacts getArtifacts() {
      if (artifactsBuilder_ == null) {
        return artifacts_ == null
            ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
            : artifacts_;
      } else {
        return artifactsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder setArtifacts(com.google.cloudbuild.v1.Artifacts value) {
      if (artifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifacts_ = value;
        onChanged();
      } else {
        artifactsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder setArtifacts(com.google.cloudbuild.v1.Artifacts.Builder builderForValue) {
      if (artifactsBuilder_ == null) {
        artifacts_ = builderForValue.build();
        onChanged();
      } else {
        artifactsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder mergeArtifacts(com.google.cloudbuild.v1.Artifacts value) {
      if (artifactsBuilder_ == null) {
        if (artifacts_ != null) {
          artifacts_ =
              com.google.cloudbuild.v1.Artifacts.newBuilder(artifacts_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          artifacts_ = value;
        }
        onChanged();
      } else {
        artifactsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder clearArtifacts() {
      if (artifactsBuilder_ == null) {
        artifacts_ = null;
        onChanged();
      } else {
        artifacts_ = null;
        artifactsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.Builder getArtifactsBuilder() {

      onChanged();
      return getArtifactsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public com.google.cloudbuild.v1.ArtifactsOrBuilder getArtifactsOrBuilder() {
      if (artifactsBuilder_ != null) {
        return artifactsBuilder_.getMessageOrBuilder();
      } else {
        return artifacts_ == null
            ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
            : artifacts_;
      }
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts,
            com.google.cloudbuild.v1.Artifacts.Builder,
            com.google.cloudbuild.v1.ArtifactsOrBuilder>
        getArtifactsFieldBuilder() {
      if (artifactsBuilder_ == null) {
        artifactsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts,
                com.google.cloudbuild.v1.Artifacts.Builder,
                com.google.cloudbuild.v1.ArtifactsOrBuilder>(
                getArtifacts(), getParentForChildren(), isClean());
        artifacts_ = null;
      }
      return artifactsBuilder_;
    }

    private java.lang.Object logsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Google Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return The logsBucket.
     */
    public java.lang.String getLogsBucket() {
      java.lang.Object ref = logsBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logsBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return The bytes for logsBucket.
     */
    public com.google.protobuf.ByteString getLogsBucketBytes() {
      java.lang.Object ref = logsBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @param value The logsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logsBucket_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogsBucket() {

      logsBucket_ = getDefaultInstance().getLogsBucket();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @param value The bytes for logsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      logsBucket_ = value;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.SourceProvenance sourceProvenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.SourceProvenance,
            com.google.cloudbuild.v1.SourceProvenance.Builder,
            com.google.cloudbuild.v1.SourceProvenanceOrBuilder>
        sourceProvenanceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sourceProvenance field is set.
     */
    public boolean hasSourceProvenance() {
      return sourceProvenanceBuilder_ != null || sourceProvenance_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourceProvenance.
     */
    public com.google.cloudbuild.v1.SourceProvenance getSourceProvenance() {
      if (sourceProvenanceBuilder_ == null) {
        return sourceProvenance_ == null
            ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      } else {
        return sourceProvenanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(com.google.cloudbuild.v1.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceProvenance_ = value;
        onChanged();
      } else {
        sourceProvenanceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(
        com.google.cloudbuild.v1.SourceProvenance.Builder builderForValue) {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenance_ = builderForValue.build();
        onChanged();
      } else {
        sourceProvenanceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSourceProvenance(com.google.cloudbuild.v1.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (sourceProvenance_ != null) {
          sourceProvenance_ =
              com.google.cloudbuild.v1.SourceProvenance.newBuilder(sourceProvenance_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceProvenance_ = value;
        }
        onChanged();
      } else {
        sourceProvenanceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSourceProvenance() {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenance_ = null;
        onChanged();
      } else {
        sourceProvenance_ = null;
        sourceProvenanceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.SourceProvenance.Builder getSourceProvenanceBuilder() {

      onChanged();
      return getSourceProvenanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
      if (sourceProvenanceBuilder_ != null) {
        return sourceProvenanceBuilder_.getMessageOrBuilder();
      } else {
        return sourceProvenance_ == null
            ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.SourceProvenance,
            com.google.cloudbuild.v1.SourceProvenance.Builder,
            com.google.cloudbuild.v1.SourceProvenanceOrBuilder>
        getSourceProvenanceFieldBuilder() {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.SourceProvenance,
                com.google.cloudbuild.v1.SourceProvenance.Builder,
                com.google.cloudbuild.v1.SourceProvenanceOrBuilder>(
                getSourceProvenance(), getParentForChildren(), isClean());
        sourceProvenance_ = null;
      }
      return sourceProvenanceBuilder_;
    }

    private java.lang.Object buildTriggerId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildTriggerId.
     */
    public java.lang.String getBuildTriggerId() {
      java.lang.Object ref = buildTriggerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildTriggerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildTriggerId.
     */
    public com.google.protobuf.ByteString getBuildTriggerIdBytes() {
      java.lang.Object ref = buildTriggerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildTriggerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildTriggerId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildTriggerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      buildTriggerId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildTriggerId() {

      buildTriggerId_ = getDefaultInstance().getBuildTriggerId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildTriggerId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildTriggerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      buildTriggerId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.BuildOptions options_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildOptions,
            com.google.cloudbuild.v1.BuildOptions.Builder,
            com.google.cloudbuild.v1.BuildOptionsOrBuilder>
        optionsBuilder_;
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     *
     * @return Whether the options field is set.
     */
    public boolean hasOptions() {
      return optionsBuilder_ != null || options_ != null;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     *
     * @return The options.
     */
    public com.google.cloudbuild.v1.BuildOptions getOptions() {
      if (optionsBuilder_ == null) {
        return options_ == null
            ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()
            : options_;
      } else {
        return optionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder setOptions(com.google.cloudbuild.v1.BuildOptions value) {
      if (optionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
        onChanged();
      } else {
        optionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder setOptions(com.google.cloudbuild.v1.BuildOptions.Builder builderForValue) {
      if (optionsBuilder_ == null) {
        options_ = builderForValue.build();
        onChanged();
      } else {
        optionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder mergeOptions(com.google.cloudbuild.v1.BuildOptions value) {
      if (optionsBuilder_ == null) {
        if (options_ != null) {
          options_ =
              com.google.cloudbuild.v1.BuildOptions.newBuilder(options_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          options_ = value;
        }
        onChanged();
      } else {
        optionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder clearOptions() {
      if (optionsBuilder_ == null) {
        options_ = null;
        onChanged();
      } else {
        options_ = null;
        optionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public com.google.cloudbuild.v1.BuildOptions.Builder getOptionsBuilder() {

      onChanged();
      return getOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public com.google.cloudbuild.v1.BuildOptionsOrBuilder getOptionsOrBuilder() {
      if (optionsBuilder_ != null) {
        return optionsBuilder_.getMessageOrBuilder();
      } else {
        return options_ == null
            ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()
            : options_;
      }
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildOptions,
            com.google.cloudbuild.v1.BuildOptions.Builder,
            com.google.cloudbuild.v1.BuildOptionsOrBuilder>
        getOptionsFieldBuilder() {
      if (optionsBuilder_ == null) {
        optionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.BuildOptions,
                com.google.cloudbuild.v1.BuildOptions.Builder,
                com.google.cloudbuild.v1.BuildOptionsOrBuilder>(
                getOptions(), getParentForChildren(), isClean());
        options_ = null;
      }
      return optionsBuilder_;
    }

    private java.lang.Object logUrl_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logUrl.
     */
    public java.lang.String getLogUrl() {
      java.lang.Object ref = logUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logUrl.
     */
    public com.google.protobuf.ByteString getLogUrlBytes() {
      java.lang.Object ref = logUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logUrl to set.
     * @return This builder for chaining.
     */
    public Builder setLogUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      logUrl_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogUrl() {

      logUrl_ = getDefaultInstance().getLogUrl();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logUrl to set.
     * @return This builder for chaining.
     */
    public Builder setLogUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      logUrl_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSubstitutions() {
      if (substitutions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      return substitutions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSubstitutions() {
      onChanged();
      ;
      if (substitutions_ == null) {
        substitutions_ =
            com.google.protobuf.MapField.newMapField(SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      if (!substitutions_.isMutable()) {
        substitutions_ = substitutions_.copy();
      }
      return substitutions_;
    }

    public int getSubstitutionsCount() {
      return internalGetSubstitutions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public boolean containsSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetSubstitutions().getMap().containsKey(key);
    }
    /** Use {@link #getSubstitutionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
      return getSubstitutionsMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
      return internalGetSubstitutions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSubstitutions() {
      internalGetMutableSubstitutions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder removeSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSubstitutions() {
      return internalGetMutableSubstitutions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder putSubstitutions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder putAllSubstitutions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSubstitutions().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.LazyStringList tags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTagsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloudbuild.v1.Secret> secrets_ =
        java.util.Collections.emptyList();

    private void ensureSecretsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        secrets_ = new java.util.ArrayList<com.google.cloudbuild.v1.Secret>(secrets_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Secret,
            com.google.cloudbuild.v1.Secret.Builder,
            com.google.cloudbuild.v1.SecretOrBuilder>
        secretsBuilder_;

    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Secret> getSecretsList() {
      if (secretsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secrets_);
      } else {
        return secretsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public int getSecretsCount() {
      if (secretsBuilder_ == null) {
        return secrets_.size();
      } else {
        return secretsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret getSecrets(int index) {
      if (secretsBuilder_ == null) {
        return secrets_.get(index);
      } else {
        return secretsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder setSecrets(int index, com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.set(index, value);
        onChanged();
      } else {
        secretsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder setSecrets(int index, com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.add(value);
        onChanged();
      } else {
        secretsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(int index, com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.add(index, value);
        onChanged();
      } else {
        secretsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.add(builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(int index, com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addAllSecrets(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Secret> values) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secrets_);
        onChanged();
      } else {
        secretsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder clearSecrets() {
      if (secretsBuilder_ == null) {
        secrets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        secretsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder removeSecrets(int index) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.remove(index);
        onChanged();
      } else {
        secretsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder getSecretsBuilder(int index) {
      return getSecretsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.SecretOrBuilder getSecretsOrBuilder(int index) {
      if (secretsBuilder_ == null) {
        return secrets_.get(index);
      } else {
        return secretsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.SecretOrBuilder>
        getSecretsOrBuilderList() {
      if (secretsBuilder_ != null) {
        return secretsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secrets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder addSecretsBuilder() {
      return getSecretsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Secret.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder addSecretsBuilder(int index) {
      return getSecretsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Secret.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Secret.Builder> getSecretsBuilderList() {
      return getSecretsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Secret,
            com.google.cloudbuild.v1.Secret.Builder,
            com.google.cloudbuild.v1.SecretOrBuilder>
        getSecretsFieldBuilder() {
      if (secretsBuilder_ == null) {
        secretsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Secret,
                com.google.cloudbuild.v1.Secret.Builder,
                com.google.cloudbuild.v1.SecretOrBuilder>(
                secrets_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        secrets_ = null;
      }
      return secretsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
        timing_;

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
        internalGetTiming() {
      if (timing_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TimingDefaultEntryHolder.defaultEntry);
      }
      return timing_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
        internalGetMutableTiming() {
      onChanged();
      ;
      if (timing_ == null) {
        timing_ = com.google.protobuf.MapField.newMapField(TimingDefaultEntryHolder.defaultEntry);
      }
      if (!timing_.isMutable()) {
        timing_ = timing_.copy();
      }
      return timing_;
    }

    public int getTimingCount() {
      return internalGetTiming().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsTiming(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetTiming().getMap().containsKey(key);
    }
    /** Use {@link #getTimingMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTiming() {
      return getTimingMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTimingMap() {
      return internalGetTiming().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpan getTimingOrDefault(
        java.lang.String key, com.google.cloudbuild.v1.TimeSpan defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
          internalGetTiming().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpan getTimingOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
          internalGetTiming().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTiming() {
      internalGetMutableTiming().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTiming(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableTiming().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getMutableTiming() {
      return internalGetMutableTiming().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putTiming(java.lang.String key, com.google.cloudbuild.v1.TimeSpan value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableTiming().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     * * BUILD: time to execute all build steps
     * * PUSH: time to push all specified images.
     * * FETCHSOURCE: time to fetch source.
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllTiming(
        java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> values) {
      internalGetMutableTiming().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * This field is in alpha and is not publicly available.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * This field is in alpha and is not publicly available.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * This field is in alpha and is not publicly available.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * This field is in alpha and is not publicly available.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {

      serviceAccount_ = getDefaultInstance().getServiceAccount();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * This field is in alpha and is not publicly available.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccount_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Build)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Build)
  private static final com.google.cloudbuild.v1.Build DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Build();
  }

  public static com.google.cloudbuild.v1.Build getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Build> PARSER =
      new com.google.protobuf.AbstractParser<Build>() {
        @java.lang.Override
        public Build parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Build(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Build> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Build> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Build getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
