/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Configuration for an automated build in response to source repository
 * changes.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.BuildTrigger}
 */
public final class BuildTrigger extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.BuildTrigger)
    BuildTriggerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildTrigger.newBuilder() to construct.
  private BuildTrigger(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildTrigger() {
    id_ = "";
    description_ = "";
    name_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    ignoredFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    includedFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildTrigger();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BuildTrigger(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          case 34:
            {
              com.google.cloudbuild.v1.Build.Builder subBuilder = null;
              if (buildTemplateCase_ == 4) {
                subBuilder = ((com.google.cloudbuild.v1.Build) buildTemplate_).toBuilder();
              }
              buildTemplate_ =
                  input.readMessage(com.google.cloudbuild.v1.Build.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloudbuild.v1.Build) buildTemplate_);
                buildTemplate_ = subBuilder.buildPartial();
              }
              buildTemplateCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloudbuild.v1.RepoSource.Builder subBuilder = null;
              if (triggerTemplate_ != null) {
                subBuilder = triggerTemplate_.toBuilder();
              }
              triggerTemplate_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.RepoSource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(triggerTemplate_);
                triggerTemplate_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();
              buildTemplateCase_ = 8;
              buildTemplate_ = s;
              break;
            }
          case 72:
            {
              disabled_ = input.readBool();
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 90:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                substitutions_ =
                    com.google.protobuf.MapField.newMapField(
                        SubstitutionsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
                  input.readMessage(
                      SubstitutionsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              substitutions_
                  .getMutableMap()
                  .put(substitutions__.getKey(), substitutions__.getValue());
              break;
            }
          case 106:
            {
              com.google.cloudbuild.v1.GitHubEventsConfig.Builder subBuilder = null;
              if (github_ != null) {
                subBuilder = github_.toBuilder();
              }
              github_ =
                  input.readMessage(
                      com.google.cloudbuild.v1.GitHubEventsConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(github_);
                github_ = subBuilder.buildPartial();
              }

              break;
            }
          case 122:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                ignoredFiles_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              ignoredFiles_.add(s);
              break;
            }
          case 130:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                includedFiles_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              includedFiles_.add(s);
              break;
            }
          case 154:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                tags_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              tags_.add(s);
              break;
            }
          case 170:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        ignoredFiles_ = ignoredFiles_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        includedFiles_ = includedFiles_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        tags_ = tags_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetSubstitutions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.BuildTrigger.class,
            com.google.cloudbuild.v1.BuildTrigger.Builder.class);
  }

  private int buildTemplateCase_ = 0;
  private java.lang.Object buildTemplate_;

  public enum BuildTemplateCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BUILD(4),
    FILENAME(8),
    BUILDTEMPLATE_NOT_SET(0);
    private final int value;

    private BuildTemplateCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BuildTemplateCase valueOf(int value) {
      return forNumber(value);
    }

    public static BuildTemplateCase forNumber(int value) {
      switch (value) {
        case 4:
          return BUILD;
        case 8:
          return FILENAME;
        case 0:
          return BUILDTEMPLATE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BuildTemplateCase getBuildTemplateCase() {
    return BuildTemplateCase.forNumber(buildTemplateCase_);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the trigger.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the trigger.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 10;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Human-readable description of this trigger.
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Human-readable description of this trigger.
   * </pre>
   *
   * <code>string description = 10;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 21;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * User-assigned name of the trigger. Must be unique within the project.
   * Trigger names must meet the following requirements:
   * + They must contain only alphanumeric characters and dashes.
   * + They can be 1-64 characters long.
   * + They must begin and end with an alphanumeric character.
   * </pre>
   *
   * <code>string name = 21;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-assigned name of the trigger. Must be unique within the project.
   * Trigger names must meet the following requirements:
   * + They must contain only alphanumeric characters and dashes.
   * + They can be 1-64 characters long.
   * + They must begin and end with an alphanumeric character.
   * </pre>
   *
   * <code>string name = 21;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAGS_FIELD_NUMBER = 19;
  private com.google.protobuf.LazyStringList tags_;
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `BuildTrigger`
   * </pre>
   *
   * <code>repeated string tags = 19;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int TRIGGER_TEMPLATE_FIELD_NUMBER = 7;
  private com.google.cloudbuild.v1.RepoSource triggerTemplate_;
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   *
   * @return Whether the triggerTemplate field is set.
   */
  @java.lang.Override
  public boolean hasTriggerTemplate() {
    return triggerTemplate_ != null;
  }
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   *
   * @return The triggerTemplate.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSource getTriggerTemplate() {
    return triggerTemplate_ == null
        ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
        : triggerTemplate_;
  }
  /**
   *
   *
   * <pre>
   * Template describing the types of source changes to trigger a build.
   * Branch and tag names in trigger templates are interpreted as regular
   * expressions. Any branch or tag change that matches that regular expression
   * will trigger a build.
   * Mutually exclusive with `github`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSourceOrBuilder getTriggerTemplateOrBuilder() {
    return getTriggerTemplate();
  }

  public static final int GITHUB_FIELD_NUMBER = 13;
  private com.google.cloudbuild.v1.GitHubEventsConfig github_;
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   *
   * @return Whether the github field is set.
   */
  @java.lang.Override
  public boolean hasGithub() {
    return github_ != null;
  }
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   *
   * @return The github.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEventsConfig getGithub() {
    return github_ == null
        ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
        : github_;
  }
  /**
   *
   *
   * <pre>
   * GitHubEventsConfig describes the configuration of a trigger that creates
   * a build whenever a GitHub event is received.
   * Mutually exclusive with `trigger_template`.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder getGithubOrBuilder() {
    return getGithub();
  }

  public static final int BUILD_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   *
   * @return Whether the build field is set.
   */
  @java.lang.Override
  public boolean hasBuild() {
    return buildTemplateCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   *
   * @return The build.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build getBuild() {
    if (buildTemplateCase_ == 4) {
      return (com.google.cloudbuild.v1.Build) buildTemplate_;
    }
    return com.google.cloudbuild.v1.Build.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Contents of the build template.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOrBuilder getBuildOrBuilder() {
    if (buildTemplateCase_ == 4) {
      return (com.google.cloudbuild.v1.Build) buildTemplate_;
    }
    return com.google.cloudbuild.v1.Build.getDefaultInstance();
  }

  public static final int FILENAME_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Path, from the source root, to a file whose contents is used for the
   * template.
   * </pre>
   *
   * <code>string filename = 8;</code>
   *
   * @return The filename.
   */
  public java.lang.String getFilename() {
    java.lang.Object ref = "";
    if (buildTemplateCase_ == 8) {
      ref = buildTemplate_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (buildTemplateCase_ == 8) {
        buildTemplate_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path, from the source root, to a file whose contents is used for the
   * template.
   * </pre>
   *
   * <code>string filename = 8;</code>
   *
   * @return The bytes for filename.
   */
  public com.google.protobuf.ByteString getFilenameBytes() {
    java.lang.Object ref = "";
    if (buildTemplateCase_ == 8) {
      ref = buildTemplate_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (buildTemplateCase_ == 8) {
        buildTemplate_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the trigger was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int DISABLED_FIELD_NUMBER = 9;
  private boolean disabled_;
  /**
   *
   *
   * <pre>
   * If true, the trigger will never automatically execute a build.
   * </pre>
   *
   * <code>bool disabled = 9;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int SUBSTITUTIONS_FIELD_NUMBER = 11;

  private static final class SubstitutionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v1.Cloudbuild
                .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_SubstitutionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSubstitutions() {
    if (substitutions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SubstitutionsDefaultEntryHolder.defaultEntry);
    }
    return substitutions_;
  }

  public int getSubstitutionsCount() {
    return internalGetSubstitutions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public boolean containsSubstitutions(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetSubstitutions().getMap().containsKey(key);
  }
  /** Use {@link #getSubstitutionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
    return getSubstitutionsMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
    return internalGetSubstitutions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Substitutions for Build resource. The keys must match the following
   * regular expression: `^_[A-Z0-9_]+$`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IGNORED_FILES_FIELD_NUMBER = 15;
  private com.google.protobuf.LazyStringList ignoredFiles_;
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @return A list containing the ignoredFiles.
   */
  public com.google.protobuf.ProtocolStringList getIgnoredFilesList() {
    return ignoredFiles_;
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @return The count of ignoredFiles.
   */
  public int getIgnoredFilesCount() {
    return ignoredFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoredFiles at the given index.
   */
  public java.lang.String getIgnoredFiles(int index) {
    return ignoredFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * ignored_files and included_files are file glob matches using
   * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
   * If ignored_files and changed files are both empty, then they are
   * not used to determine whether or not to trigger a build.
   * If ignored_files is not empty, then we ignore any files that match
   * any of the ignored_file globs. If the change has no files that are
   * outside of the ignored_files globs, then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string ignored_files = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ignoredFiles at the given index.
   */
  public com.google.protobuf.ByteString getIgnoredFilesBytes(int index) {
    return ignoredFiles_.getByteString(index);
  }

  public static final int INCLUDED_FILES_FIELD_NUMBER = 16;
  private com.google.protobuf.LazyStringList includedFiles_;
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @return A list containing the includedFiles.
   */
  public com.google.protobuf.ProtocolStringList getIncludedFilesList() {
    return includedFiles_;
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @return The count of includedFiles.
   */
  public int getIncludedFilesCount() {
    return includedFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The includedFiles at the given index.
   */
  public java.lang.String getIncludedFiles(int index) {
    return includedFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is empty, then as far as this filter is
   * concerned, we should trigger the build.
   * If any of the files altered in the commit pass the ignored_files
   * filter and included_files is not empty, then we make sure that at
   * least one of those files matches a included_files glob. If not,
   * then we do not trigger a build.
   * </pre>
   *
   * <code>repeated string included_files = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includedFiles at the given index.
   */
  public com.google.protobuf.ByteString getIncludedFilesBytes(int index) {
    return includedFiles_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (buildTemplateCase_ == 4) {
      output.writeMessage(4, (com.google.cloudbuild.v1.Build) buildTemplate_);
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (triggerTemplate_ != null) {
      output.writeMessage(7, getTriggerTemplate());
    }
    if (buildTemplateCase_ == 8) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, buildTemplate_);
    }
    if (disabled_ != false) {
      output.writeBool(9, disabled_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSubstitutions(), SubstitutionsDefaultEntryHolder.defaultEntry, 11);
    if (github_ != null) {
      output.writeMessage(13, getGithub());
    }
    for (int i = 0; i < ignoredFiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, ignoredFiles_.getRaw(i));
    }
    for (int i = 0; i < includedFiles_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, includedFiles_.getRaw(i));
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, tags_.getRaw(i));
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, name_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (buildTemplateCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloudbuild.v1.Build) buildTemplate_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (triggerTemplate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTriggerTemplate());
    }
    if (buildTemplateCase_ == 8) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, buildTemplate_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, disabled_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSubstitutions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
          SubstitutionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, substitutions__);
    }
    if (github_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getGithub());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoredFiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(ignoredFiles_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIgnoredFilesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includedFiles_.size(); i++) {
        dataSize += computeStringSizeNoTag(includedFiles_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getIncludedFilesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getTagsList().size();
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, name_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.BuildTrigger)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.BuildTrigger other = (com.google.cloudbuild.v1.BuildTrigger) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (hasTriggerTemplate() != other.hasTriggerTemplate()) return false;
    if (hasTriggerTemplate()) {
      if (!getTriggerTemplate().equals(other.getTriggerTemplate())) return false;
    }
    if (hasGithub() != other.hasGithub()) return false;
    if (hasGithub()) {
      if (!getGithub().equals(other.getGithub())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (!internalGetSubstitutions().equals(other.internalGetSubstitutions())) return false;
    if (!getIgnoredFilesList().equals(other.getIgnoredFilesList())) return false;
    if (!getIncludedFilesList().equals(other.getIncludedFilesList())) return false;
    if (!getBuildTemplateCase().equals(other.getBuildTemplateCase())) return false;
    switch (buildTemplateCase_) {
      case 4:
        if (!getBuild().equals(other.getBuild())) return false;
        break;
      case 8:
        if (!getFilename().equals(other.getFilename())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (hasTriggerTemplate()) {
      hash = (37 * hash) + TRIGGER_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTriggerTemplate().hashCode();
    }
    if (hasGithub()) {
      hash = (37 * hash) + GITHUB_FIELD_NUMBER;
      hash = (53 * hash) + getGithub().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (!internalGetSubstitutions().getMap().isEmpty()) {
      hash = (37 * hash) + SUBSTITUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSubstitutions().hashCode();
    }
    if (getIgnoredFilesCount() > 0) {
      hash = (37 * hash) + IGNORED_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getIgnoredFilesList().hashCode();
    }
    if (getIncludedFilesCount() > 0) {
      hash = (37 * hash) + INCLUDED_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedFilesList().hashCode();
    }
    switch (buildTemplateCase_) {
      case 4:
        hash = (37 * hash) + BUILD_FIELD_NUMBER;
        hash = (53 * hash) + getBuild().hashCode();
        break;
      case 8:
        hash = (37 * hash) + FILENAME_FIELD_NUMBER;
        hash = (53 * hash) + getFilename().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildTrigger parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.BuildTrigger prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an automated build in response to source repository
   * changes.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.BuildTrigger}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.BuildTrigger)
      com.google.cloudbuild.v1.BuildTriggerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.BuildTrigger.class,
              com.google.cloudbuild.v1.BuildTrigger.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.BuildTrigger.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      id_ = "";

      description_ = "";

      name_ = "";

      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (triggerTemplateBuilder_ == null) {
        triggerTemplate_ = null;
      } else {
        triggerTemplate_ = null;
        triggerTemplateBuilder_ = null;
      }
      if (githubBuilder_ == null) {
        github_ = null;
      } else {
        github_ = null;
        githubBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      disabled_ = false;

      internalGetMutableSubstitutions().clear();
      ignoredFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      includedFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      buildTemplateCase_ = 0;
      buildTemplate_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildTrigger_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.BuildTrigger.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger build() {
      com.google.cloudbuild.v1.BuildTrigger result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildTrigger buildPartial() {
      com.google.cloudbuild.v1.BuildTrigger result =
          new com.google.cloudbuild.v1.BuildTrigger(this);
      int from_bitField0_ = bitField0_;
      result.id_ = id_;
      result.description_ = description_;
      result.name_ = name_;
      if (((bitField0_ & 0x00000001) != 0)) {
        tags_ = tags_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.tags_ = tags_;
      if (triggerTemplateBuilder_ == null) {
        result.triggerTemplate_ = triggerTemplate_;
      } else {
        result.triggerTemplate_ = triggerTemplateBuilder_.build();
      }
      if (githubBuilder_ == null) {
        result.github_ = github_;
      } else {
        result.github_ = githubBuilder_.build();
      }
      if (buildTemplateCase_ == 4) {
        if (buildBuilder_ == null) {
          result.buildTemplate_ = buildTemplate_;
        } else {
          result.buildTemplate_ = buildBuilder_.build();
        }
      }
      if (buildTemplateCase_ == 8) {
        result.buildTemplate_ = buildTemplate_;
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.disabled_ = disabled_;
      result.substitutions_ = internalGetSubstitutions();
      result.substitutions_.makeImmutable();
      if (((bitField0_ & 0x00000004) != 0)) {
        ignoredFiles_ = ignoredFiles_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.ignoredFiles_ = ignoredFiles_;
      if (((bitField0_ & 0x00000008) != 0)) {
        includedFiles_ = includedFiles_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.includedFiles_ = includedFiles_;
      result.buildTemplateCase_ = buildTemplateCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.BuildTrigger) {
        return mergeFrom((com.google.cloudbuild.v1.BuildTrigger) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.BuildTrigger other) {
      if (other == com.google.cloudbuild.v1.BuildTrigger.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.hasTriggerTemplate()) {
        mergeTriggerTemplate(other.getTriggerTemplate());
      }
      if (other.hasGithub()) {
        mergeGithub(other.getGithub());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      internalGetMutableSubstitutions().mergeFrom(other.internalGetSubstitutions());
      if (!other.ignoredFiles_.isEmpty()) {
        if (ignoredFiles_.isEmpty()) {
          ignoredFiles_ = other.ignoredFiles_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureIgnoredFilesIsMutable();
          ignoredFiles_.addAll(other.ignoredFiles_);
        }
        onChanged();
      }
      if (!other.includedFiles_.isEmpty()) {
        if (includedFiles_.isEmpty()) {
          includedFiles_ = other.includedFiles_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureIncludedFilesIsMutable();
          includedFiles_.addAll(other.includedFiles_);
        }
        onChanged();
      }
      switch (other.getBuildTemplateCase()) {
        case BUILD:
          {
            mergeBuild(other.getBuild());
            break;
          }
        case FILENAME:
          {
            buildTemplateCase_ = 8;
            buildTemplate_ = other.buildTemplate_;
            onChanged();
            break;
          }
        case BUILDTEMPLATE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.BuildTrigger parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.BuildTrigger) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int buildTemplateCase_ = 0;
    private java.lang.Object buildTemplate_;

    public BuildTemplateCase getBuildTemplateCase() {
      return BuildTemplateCase.forNumber(buildTemplateCase_);
    }

    public Builder clearBuildTemplate() {
      buildTemplateCase_ = 0;
      buildTemplate_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      id_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {

      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the trigger.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      id_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Human-readable description of this trigger.
     * </pre>
     *
     * <code>string description = 10;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-assigned name of the trigger. Must be unique within the project.
     * Trigger names must meet the following requirements:
     * + They must contain only alphanumeric characters and dashes.
     * + They can be 1-64 characters long.
     * + They must begin and end with an alphanumeric character.
     * </pre>
     *
     * <code>string name = 21;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList tags_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTagsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `BuildTrigger`
     * </pre>
     *
     * <code>repeated string tags = 19;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.RepoSource triggerTemplate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        triggerTemplateBuilder_;
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     *
     * @return Whether the triggerTemplate field is set.
     */
    public boolean hasTriggerTemplate() {
      return triggerTemplateBuilder_ != null || triggerTemplate_ != null;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     *
     * @return The triggerTemplate.
     */
    public com.google.cloudbuild.v1.RepoSource getTriggerTemplate() {
      if (triggerTemplateBuilder_ == null) {
        return triggerTemplate_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : triggerTemplate_;
      } else {
        return triggerTemplateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder setTriggerTemplate(com.google.cloudbuild.v1.RepoSource value) {
      if (triggerTemplateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        triggerTemplate_ = value;
        onChanged();
      } else {
        triggerTemplateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder setTriggerTemplate(com.google.cloudbuild.v1.RepoSource.Builder builderForValue) {
      if (triggerTemplateBuilder_ == null) {
        triggerTemplate_ = builderForValue.build();
        onChanged();
      } else {
        triggerTemplateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder mergeTriggerTemplate(com.google.cloudbuild.v1.RepoSource value) {
      if (triggerTemplateBuilder_ == null) {
        if (triggerTemplate_ != null) {
          triggerTemplate_ =
              com.google.cloudbuild.v1.RepoSource.newBuilder(triggerTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          triggerTemplate_ = value;
        }
        onChanged();
      } else {
        triggerTemplateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public Builder clearTriggerTemplate() {
      if (triggerTemplateBuilder_ == null) {
        triggerTemplate_ = null;
        onChanged();
      } else {
        triggerTemplate_ = null;
        triggerTemplateBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public com.google.cloudbuild.v1.RepoSource.Builder getTriggerTemplateBuilder() {

      onChanged();
      return getTriggerTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    public com.google.cloudbuild.v1.RepoSourceOrBuilder getTriggerTemplateOrBuilder() {
      if (triggerTemplateBuilder_ != null) {
        return triggerTemplateBuilder_.getMessageOrBuilder();
      } else {
        return triggerTemplate_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : triggerTemplate_;
      }
    }
    /**
     *
     *
     * <pre>
     * Template describing the types of source changes to trigger a build.
     * Branch and tag names in trigger templates are interpreted as regular
     * expressions. Any branch or tag change that matches that regular expression
     * will trigger a build.
     * Mutually exclusive with `github`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource trigger_template = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        getTriggerTemplateFieldBuilder() {
      if (triggerTemplateBuilder_ == null) {
        triggerTemplateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.RepoSource,
                com.google.cloudbuild.v1.RepoSource.Builder,
                com.google.cloudbuild.v1.RepoSourceOrBuilder>(
                getTriggerTemplate(), getParentForChildren(), isClean());
        triggerTemplate_ = null;
      }
      return triggerTemplateBuilder_;
    }

    private com.google.cloudbuild.v1.GitHubEventsConfig github_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEventsConfig,
            com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
            com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>
        githubBuilder_;
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     *
     * @return Whether the github field is set.
     */
    public boolean hasGithub() {
      return githubBuilder_ != null || github_ != null;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     *
     * @return The github.
     */
    public com.google.cloudbuild.v1.GitHubEventsConfig getGithub() {
      if (githubBuilder_ == null) {
        return github_ == null
            ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
            : github_;
      } else {
        return githubBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder setGithub(com.google.cloudbuild.v1.GitHubEventsConfig value) {
      if (githubBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        github_ = value;
        onChanged();
      } else {
        githubBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder setGithub(com.google.cloudbuild.v1.GitHubEventsConfig.Builder builderForValue) {
      if (githubBuilder_ == null) {
        github_ = builderForValue.build();
        onChanged();
      } else {
        githubBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder mergeGithub(com.google.cloudbuild.v1.GitHubEventsConfig value) {
      if (githubBuilder_ == null) {
        if (github_ != null) {
          github_ =
              com.google.cloudbuild.v1.GitHubEventsConfig.newBuilder(github_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          github_ = value;
        }
        onChanged();
      } else {
        githubBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public Builder clearGithub() {
      if (githubBuilder_ == null) {
        github_ = null;
        onChanged();
      } else {
        github_ = null;
        githubBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public com.google.cloudbuild.v1.GitHubEventsConfig.Builder getGithubBuilder() {

      onChanged();
      return getGithubFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    public com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder getGithubOrBuilder() {
      if (githubBuilder_ != null) {
        return githubBuilder_.getMessageOrBuilder();
      } else {
        return github_ == null
            ? com.google.cloudbuild.v1.GitHubEventsConfig.getDefaultInstance()
            : github_;
      }
    }
    /**
     *
     *
     * <pre>
     * GitHubEventsConfig describes the configuration of a trigger that creates
     * a build whenever a GitHub event is received.
     * Mutually exclusive with `trigger_template`.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitHubEventsConfig github = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.GitHubEventsConfig,
            com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
            com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>
        getGithubFieldBuilder() {
      if (githubBuilder_ == null) {
        githubBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.GitHubEventsConfig,
                com.google.cloudbuild.v1.GitHubEventsConfig.Builder,
                com.google.cloudbuild.v1.GitHubEventsConfigOrBuilder>(
                getGithub(), getParentForChildren(), isClean());
        github_ = null;
      }
      return githubBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build,
            com.google.cloudbuild.v1.Build.Builder,
            com.google.cloudbuild.v1.BuildOrBuilder>
        buildBuilder_;
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     *
     * @return Whether the build field is set.
     */
    @java.lang.Override
    public boolean hasBuild() {
      return buildTemplateCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     *
     * @return The build.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build getBuild() {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4) {
          return (com.google.cloudbuild.v1.Build) buildTemplate_;
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      } else {
        if (buildTemplateCase_ == 4) {
          return buildBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder setBuild(com.google.cloudbuild.v1.Build value) {
      if (buildBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildTemplate_ = value;
        onChanged();
      } else {
        buildBuilder_.setMessage(value);
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder setBuild(com.google.cloudbuild.v1.Build.Builder builderForValue) {
      if (buildBuilder_ == null) {
        buildTemplate_ = builderForValue.build();
        onChanged();
      } else {
        buildBuilder_.setMessage(builderForValue.build());
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder mergeBuild(com.google.cloudbuild.v1.Build value) {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4
            && buildTemplate_ != com.google.cloudbuild.v1.Build.getDefaultInstance()) {
          buildTemplate_ =
              com.google.cloudbuild.v1.Build.newBuilder(
                      (com.google.cloudbuild.v1.Build) buildTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          buildTemplate_ = value;
        }
        onChanged();
      } else {
        if (buildTemplateCase_ == 4) {
          buildBuilder_.mergeFrom(value);
        }
        buildBuilder_.setMessage(value);
      }
      buildTemplateCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public Builder clearBuild() {
      if (buildBuilder_ == null) {
        if (buildTemplateCase_ == 4) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
          onChanged();
        }
      } else {
        if (buildTemplateCase_ == 4) {
          buildTemplateCase_ = 0;
          buildTemplate_ = null;
        }
        buildBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    public com.google.cloudbuild.v1.Build.Builder getBuildBuilder() {
      return getBuildFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.BuildOrBuilder getBuildOrBuilder() {
      if ((buildTemplateCase_ == 4) && (buildBuilder_ != null)) {
        return buildBuilder_.getMessageOrBuilder();
      } else {
        if (buildTemplateCase_ == 4) {
          return (com.google.cloudbuild.v1.Build) buildTemplate_;
        }
        return com.google.cloudbuild.v1.Build.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Contents of the build template.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build build = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build,
            com.google.cloudbuild.v1.Build.Builder,
            com.google.cloudbuild.v1.BuildOrBuilder>
        getBuildFieldBuilder() {
      if (buildBuilder_ == null) {
        if (!(buildTemplateCase_ == 4)) {
          buildTemplate_ = com.google.cloudbuild.v1.Build.getDefaultInstance();
        }
        buildBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Build,
                com.google.cloudbuild.v1.Build.Builder,
                com.google.cloudbuild.v1.BuildOrBuilder>(
                (com.google.cloudbuild.v1.Build) buildTemplate_, getParentForChildren(), isClean());
        buildTemplate_ = null;
      }
      buildTemplateCase_ = 4;
      onChanged();
      ;
      return buildBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Path, from the source root, to a file whose contents is used for the
     * template.
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return The filename.
     */
    @java.lang.Override
    public java.lang.String getFilename() {
      java.lang.Object ref = "";
      if (buildTemplateCase_ == 8) {
        ref = buildTemplate_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (buildTemplateCase_ == 8) {
          buildTemplate_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to a file whose contents is used for the
     * template.
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return The bytes for filename.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilenameBytes() {
      java.lang.Object ref = "";
      if (buildTemplateCase_ == 8) {
        ref = buildTemplate_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (buildTemplateCase_ == 8) {
          buildTemplate_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to a file whose contents is used for the
     * template.
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @param value The filename to set.
     * @return This builder for chaining.
     */
    public Builder setFilename(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildTemplateCase_ = 8;
      buildTemplate_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to a file whose contents is used for the
     * template.
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilename() {
      if (buildTemplateCase_ == 8) {
        buildTemplateCase_ = 0;
        buildTemplate_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path, from the source root, to a file whose contents is used for the
     * template.
     * </pre>
     *
     * <code>string filename = 8;</code>
     *
     * @param value The bytes for filename to set.
     * @return This builder for chaining.
     */
    public Builder setFilenameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildTemplateCase_ = 8;
      buildTemplate_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the trigger was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, the trigger will never automatically execute a build.
     * </pre>
     *
     * <code>bool disabled = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {

      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSubstitutions() {
      if (substitutions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      return substitutions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSubstitutions() {
      onChanged();
      ;
      if (substitutions_ == null) {
        substitutions_ =
            com.google.protobuf.MapField.newMapField(SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      if (!substitutions_.isMutable()) {
        substitutions_ = substitutions_.copy();
      }
      return substitutions_;
    }

    public int getSubstitutionsCount() {
      return internalGetSubstitutions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public boolean containsSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetSubstitutions().getMap().containsKey(key);
    }
    /** Use {@link #getSubstitutionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
      return getSubstitutionsMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
      return internalGetSubstitutions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSubstitutions() {
      internalGetMutableSubstitutions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder removeSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSubstitutions() {
      return internalGetMutableSubstitutions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder putSubstitutions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions for Build resource. The keys must match the following
     * regular expression: `^_[A-Z0-9_]+$`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 11;</code>
     */
    public Builder putAllSubstitutions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSubstitutions().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.LazyStringList ignoredFiles_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureIgnoredFilesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        ignoredFiles_ = new com.google.protobuf.LazyStringArrayList(ignoredFiles_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return A list containing the ignoredFiles.
     */
    public com.google.protobuf.ProtocolStringList getIgnoredFilesList() {
      return ignoredFiles_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return The count of ignoredFiles.
     */
    public int getIgnoredFilesCount() {
      return ignoredFiles_.size();
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The ignoredFiles at the given index.
     */
    public java.lang.String getIgnoredFiles(int index) {
      return ignoredFiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ignoredFiles at the given index.
     */
    public com.google.protobuf.ByteString getIgnoredFilesBytes(int index) {
      return ignoredFiles_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The ignoredFiles to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoredFiles(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param value The ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoredFiles(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param values The ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoredFiles(java.lang.Iterable<java.lang.String> values) {
      ensureIgnoredFilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ignoredFiles_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoredFiles() {
      ignoredFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ignored_files and included_files are file glob matches using
     * https://golang.org/pkg/path/filepath/#Match extended with support for "**".
     * If ignored_files and changed files are both empty, then they are
     * not used to determine whether or not to trigger a build.
     * If ignored_files is not empty, then we ignore any files that match
     * any of the ignored_file globs. If the change has no files that are
     * outside of the ignored_files globs, then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string ignored_files = 15;</code>
     *
     * @param value The bytes of the ignoredFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoredFilesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIgnoredFilesIsMutable();
      ignoredFiles_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList includedFiles_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureIncludedFilesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        includedFiles_ = new com.google.protobuf.LazyStringArrayList(includedFiles_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return A list containing the includedFiles.
     */
    public com.google.protobuf.ProtocolStringList getIncludedFilesList() {
      return includedFiles_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return The count of includedFiles.
     */
    public int getIncludedFilesCount() {
      return includedFiles_.size();
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The includedFiles at the given index.
     */
    public java.lang.String getIncludedFiles(int index) {
      return includedFiles_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedFiles at the given index.
     */
    public com.google.protobuf.ByteString getIncludedFilesBytes(int index) {
      return includedFiles_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The includedFiles to set.
     * @return This builder for chaining.
     */
    public Builder setIncludedFiles(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedFilesIsMutable();
      includedFiles_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param value The includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedFiles(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedFilesIsMutable();
      includedFiles_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param values The includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludedFiles(java.lang.Iterable<java.lang.String> values) {
      ensureIncludedFilesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedFiles_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludedFiles() {
      includedFiles_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is empty, then as far as this filter is
     * concerned, we should trigger the build.
     * If any of the files altered in the commit pass the ignored_files
     * filter and included_files is not empty, then we make sure that at
     * least one of those files matches a included_files glob. If not,
     * then we do not trigger a build.
     * </pre>
     *
     * <code>repeated string included_files = 16;</code>
     *
     * @param value The bytes of the includedFiles to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedFilesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludedFilesIsMutable();
      includedFiles_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.BuildTrigger)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.BuildTrigger)
  private static final com.google.cloudbuild.v1.BuildTrigger DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.BuildTrigger();
  }

  public static com.google.cloudbuild.v1.BuildTrigger getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildTrigger> PARSER =
      new com.google.protobuf.AbstractParser<BuildTrigger>() {
        @java.lang.Override
        public BuildTrigger parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BuildTrigger(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BuildTrigger> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildTrigger> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.BuildTrigger getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
