/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Location of the source in a Google Cloud Source Repository.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.RepoSource}
 */
public final class RepoSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.RepoSource)
    RepoSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepoSource.newBuilder() to construct.
  private RepoSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepoSource() {
    projectId_ = "";
    repoName_ = "";
    dir_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepoSource();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RepoSource(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              repoName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              revisionCase_ = 3;
              revision_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              revisionCase_ = 4;
              revision_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();
              revisionCase_ = 5;
              revision_ = s;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              dir_ = s;
              break;
            }
          case 64:
            {
              invertRegex_ = input.readBool();
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                substitutions_ =
                    com.google.protobuf.MapField.newMapField(
                        SubstitutionsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
                  input.readMessage(
                      SubstitutionsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              substitutions_
                  .getMutableMap()
                  .put(substitutions__.getKey(), substitutions__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_RepoSource_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetSubstitutions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_RepoSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.RepoSource.class,
            com.google.cloudbuild.v1.RepoSource.Builder.class);
  }

  private int revisionCase_ = 0;
  private java.lang.Object revision_;

  public enum RevisionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BRANCH_NAME(3),
    TAG_NAME(4),
    COMMIT_SHA(5),
    REVISION_NOT_SET(0);
    private final int value;

    private RevisionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RevisionCase valueOf(int value) {
      return forNumber(value);
    }

    public static RevisionCase forNumber(int value) {
      switch (value) {
        case 3:
          return BRANCH_NAME;
        case 4:
          return TAG_NAME;
        case 5:
          return COMMIT_SHA;
        case 0:
          return REVISION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RevisionCase getRevisionCase() {
    return RevisionCase.forNumber(revisionCase_);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * ID of the project that owns the Cloud Source Repository. If omitted, the
   * project ID requesting the build is assumed.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the project that owns the Cloud Source Repository. If omitted, the
   * project ID requesting the build is assumed.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPO_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object repoName_;
  /**
   *
   *
   * <pre>
   * Required. Name of the Cloud Source Repository.
   * </pre>
   *
   * <code>string repo_name = 2;</code>
   *
   * @return The repoName.
   */
  @java.lang.Override
  public java.lang.String getRepoName() {
    java.lang.Object ref = repoName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      repoName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the Cloud Source Repository.
   * </pre>
   *
   * <code>string repo_name = 2;</code>
   *
   * @return The bytes for repoName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRepoNameBytes() {
    java.lang.Object ref = repoName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      repoName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BRANCH_NAME_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Regex matching branches to build.
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string branch_name = 3;</code>
   *
   * @return The branchName.
   */
  public java.lang.String getBranchName() {
    java.lang.Object ref = "";
    if (revisionCase_ == 3) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 3) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Regex matching branches to build.
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string branch_name = 3;</code>
   *
   * @return The bytes for branchName.
   */
  public com.google.protobuf.ByteString getBranchNameBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 3) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 3) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_NAME_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Regex matching tags to build.
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string tag_name = 4;</code>
   *
   * @return The tagName.
   */
  public java.lang.String getTagName() {
    java.lang.Object ref = "";
    if (revisionCase_ == 4) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 4) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Regex matching tags to build.
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string tag_name = 4;</code>
   *
   * @return The bytes for tagName.
   */
  public com.google.protobuf.ByteString getTagNameBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 4) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 4) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMIT_SHA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Explicit commit SHA to build.
   * </pre>
   *
   * <code>string commit_sha = 5;</code>
   *
   * @return The commitSha.
   */
  public java.lang.String getCommitSha() {
    java.lang.Object ref = "";
    if (revisionCase_ == 5) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 5) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Explicit commit SHA to build.
   * </pre>
   *
   * <code>string commit_sha = 5;</code>
   *
   * @return The bytes for commitSha.
   */
  public com.google.protobuf.ByteString getCommitShaBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 5) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 5) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIR_FIELD_NUMBER = 7;
  private volatile java.lang.Object dir_;
  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * </pre>
   *
   * <code>string dir = 7;</code>
   *
   * @return The dir.
   */
  @java.lang.Override
  public java.lang.String getDir() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * </pre>
   *
   * <code>string dir = 7;</code>
   *
   * @return The bytes for dir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirBytes() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVERT_REGEX_FIELD_NUMBER = 8;
  private boolean invertRegex_;
  /**
   *
   *
   * <pre>
   * Only trigger a build if the revision regex does NOT match the revision
   * regex.
   * </pre>
   *
   * <code>bool invert_regex = 8;</code>
   *
   * @return The invertRegex.
   */
  @java.lang.Override
  public boolean getInvertRegex() {
    return invertRegex_;
  }

  public static final int SUBSTITUTIONS_FIELD_NUMBER = 9;

  private static final class SubstitutionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v1.Cloudbuild
                .internal_static_google_devtools_cloudbuild_v1_RepoSource_SubstitutionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSubstitutions() {
    if (substitutions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SubstitutionsDefaultEntryHolder.defaultEntry);
    }
    return substitutions_;
  }

  public int getSubstitutionsCount() {
    return internalGetSubstitutions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Substitutions to use in a triggered build.
   * Should only be used with RunBuildTrigger
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 9;</code>
   */
  @java.lang.Override
  public boolean containsSubstitutions(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetSubstitutions().getMap().containsKey(key);
  }
  /** Use {@link #getSubstitutionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
    return getSubstitutionsMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions to use in a triggered build.
   * Should only be used with RunBuildTrigger
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
    return internalGetSubstitutions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions to use in a triggered build.
   * Should only be used with RunBuildTrigger
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Substitutions to use in a triggered build.
   * Should only be used with RunBuildTrigger
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!getRepoNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, repoName_);
    }
    if (revisionCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, revision_);
    }
    if (revisionCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, revision_);
    }
    if (revisionCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, revision_);
    }
    if (!getDirBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, dir_);
    }
    if (invertRegex_ != false) {
      output.writeBool(8, invertRegex_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSubstitutions(), SubstitutionsDefaultEntryHolder.defaultEntry, 9);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!getRepoNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, repoName_);
    }
    if (revisionCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, revision_);
    }
    if (revisionCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, revision_);
    }
    if (revisionCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, revision_);
    }
    if (!getDirBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, dir_);
    }
    if (invertRegex_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, invertRegex_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSubstitutions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
          SubstitutionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, substitutions__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.RepoSource)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.RepoSource other = (com.google.cloudbuild.v1.RepoSource) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getRepoName().equals(other.getRepoName())) return false;
    if (!getDir().equals(other.getDir())) return false;
    if (getInvertRegex() != other.getInvertRegex()) return false;
    if (!internalGetSubstitutions().equals(other.internalGetSubstitutions())) return false;
    if (!getRevisionCase().equals(other.getRevisionCase())) return false;
    switch (revisionCase_) {
      case 3:
        if (!getBranchName().equals(other.getBranchName())) return false;
        break;
      case 4:
        if (!getTagName().equals(other.getTagName())) return false;
        break;
      case 5:
        if (!getCommitSha().equals(other.getCommitSha())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + REPO_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getRepoName().hashCode();
    hash = (37 * hash) + DIR_FIELD_NUMBER;
    hash = (53 * hash) + getDir().hashCode();
    hash = (37 * hash) + INVERT_REGEX_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInvertRegex());
    if (!internalGetSubstitutions().getMap().isEmpty()) {
      hash = (37 * hash) + SUBSTITUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSubstitutions().hashCode();
    }
    switch (revisionCase_) {
      case 3:
        hash = (37 * hash) + BRANCH_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getBranchName().hashCode();
        break;
      case 4:
        hash = (37 * hash) + TAG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTagName().hashCode();
        break;
      case 5:
        hash = (37 * hash) + COMMIT_SHA_FIELD_NUMBER;
        hash = (53 * hash) + getCommitSha().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepoSource parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepoSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepoSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.RepoSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Location of the source in a Google Cloud Source Repository.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.RepoSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.RepoSource)
      com.google.cloudbuild.v1.RepoSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepoSource_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableSubstitutions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepoSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.RepoSource.class,
              com.google.cloudbuild.v1.RepoSource.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.RepoSource.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      projectId_ = "";

      repoName_ = "";

      dir_ = "";

      invertRegex_ = false;

      internalGetMutableSubstitutions().clear();
      revisionCase_ = 0;
      revision_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepoSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepoSource getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.RepoSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepoSource build() {
      com.google.cloudbuild.v1.RepoSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepoSource buildPartial() {
      com.google.cloudbuild.v1.RepoSource result = new com.google.cloudbuild.v1.RepoSource(this);
      int from_bitField0_ = bitField0_;
      result.projectId_ = projectId_;
      result.repoName_ = repoName_;
      if (revisionCase_ == 3) {
        result.revision_ = revision_;
      }
      if (revisionCase_ == 4) {
        result.revision_ = revision_;
      }
      if (revisionCase_ == 5) {
        result.revision_ = revision_;
      }
      result.dir_ = dir_;
      result.invertRegex_ = invertRegex_;
      result.substitutions_ = internalGetSubstitutions();
      result.substitutions_.makeImmutable();
      result.revisionCase_ = revisionCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.RepoSource) {
        return mergeFrom((com.google.cloudbuild.v1.RepoSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.RepoSource other) {
      if (other == com.google.cloudbuild.v1.RepoSource.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (!other.getRepoName().isEmpty()) {
        repoName_ = other.repoName_;
        onChanged();
      }
      if (!other.getDir().isEmpty()) {
        dir_ = other.dir_;
        onChanged();
      }
      if (other.getInvertRegex() != false) {
        setInvertRegex(other.getInvertRegex());
      }
      internalGetMutableSubstitutions().mergeFrom(other.internalGetSubstitutions());
      switch (other.getRevisionCase()) {
        case BRANCH_NAME:
          {
            revisionCase_ = 3;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case TAG_NAME:
          {
            revisionCase_ = 4;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case COMMIT_SHA:
          {
            revisionCase_ = 5;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case REVISION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.RepoSource parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.RepoSource) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int revisionCase_ = 0;
    private java.lang.Object revision_;

    public RevisionCase getRevisionCase() {
      return RevisionCase.forNumber(revisionCase_);
    }

    public Builder clearRevision() {
      revisionCase_ = 0;
      revision_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object repoName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return The repoName.
     */
    public java.lang.String getRepoName() {
      java.lang.Object ref = repoName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repoName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return The bytes for repoName.
     */
    public com.google.protobuf.ByteString getRepoNameBytes() {
      java.lang.Object ref = repoName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repoName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @param value The repoName to set.
     * @return This builder for chaining.
     */
    public Builder setRepoName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      repoName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepoName() {

      repoName_ = getDefaultInstance().getRepoName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @param value The bytes for repoName to set.
     * @return This builder for chaining.
     */
    public Builder setRepoNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      repoName_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return The branchName.
     */
    @java.lang.Override
    public java.lang.String getBranchName() {
      java.lang.Object ref = "";
      if (revisionCase_ == 3) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 3) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return The bytes for branchName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBranchNameBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 3) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 3) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @param value The branchName to set.
     * @return This builder for chaining.
     */
    public Builder setBranchName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 3;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranchName() {
      if (revisionCase_ == 3) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @param value The bytes for branchName to set.
     * @return This builder for chaining.
     */
    public Builder setBranchNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 3;
      revision_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return The tagName.
     */
    @java.lang.Override
    public java.lang.String getTagName() {
      java.lang.Object ref = "";
      if (revisionCase_ == 4) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 4) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return The bytes for tagName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTagNameBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 4) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 4) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @param value The tagName to set.
     * @return This builder for chaining.
     */
    public Builder setTagName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 4;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagName() {
      if (revisionCase_ == 4) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @param value The bytes for tagName to set.
     * @return This builder for chaining.
     */
    public Builder setTagNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 4;
      revision_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return The commitSha.
     */
    @java.lang.Override
    public java.lang.String getCommitSha() {
      java.lang.Object ref = "";
      if (revisionCase_ == 5) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 5) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return The bytes for commitSha.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCommitShaBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 5) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 5) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @param value The commitSha to set.
     * @return This builder for chaining.
     */
    public Builder setCommitSha(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 5;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitSha() {
      if (revisionCase_ == 5) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @param value The bytes for commitSha to set.
     * @return This builder for chaining.
     */
    public Builder setCommitShaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 5;
      revision_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object dir_ = "";
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * </pre>
     *
     * <code>string dir = 7;</code>
     *
     * @return The dir.
     */
    public java.lang.String getDir() {
      java.lang.Object ref = dir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * </pre>
     *
     * <code>string dir = 7;</code>
     *
     * @return The bytes for dir.
     */
    public com.google.protobuf.ByteString getDirBytes() {
      java.lang.Object ref = dir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * </pre>
     *
     * <code>string dir = 7;</code>
     *
     * @param value The dir to set.
     * @return This builder for chaining.
     */
    public Builder setDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dir_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * </pre>
     *
     * <code>string dir = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDir() {

      dir_ = getDefaultInstance().getDir();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * </pre>
     *
     * <code>string dir = 7;</code>
     *
     * @param value The bytes for dir to set.
     * @return This builder for chaining.
     */
    public Builder setDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dir_ = value;
      onChanged();
      return this;
    }

    private boolean invertRegex_;
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 8;</code>
     *
     * @return The invertRegex.
     */
    @java.lang.Override
    public boolean getInvertRegex() {
      return invertRegex_;
    }
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 8;</code>
     *
     * @param value The invertRegex to set.
     * @return This builder for chaining.
     */
    public Builder setInvertRegex(boolean value) {

      invertRegex_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvertRegex() {

      invertRegex_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSubstitutions() {
      if (substitutions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      return substitutions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSubstitutions() {
      onChanged();
      ;
      if (substitutions_ == null) {
        substitutions_ =
            com.google.protobuf.MapField.newMapField(SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      if (!substitutions_.isMutable()) {
        substitutions_ = substitutions_.copy();
      }
      return substitutions_;
    }

    public int getSubstitutionsCount() {
      return internalGetSubstitutions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    @java.lang.Override
    public boolean containsSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetSubstitutions().getMap().containsKey(key);
    }
    /** Use {@link #getSubstitutionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
      return getSubstitutionsMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
      return internalGetSubstitutions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSubstitutions() {
      internalGetMutableSubstitutions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    public Builder removeSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSubstitutions() {
      return internalGetMutableSubstitutions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    public Builder putSubstitutions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableSubstitutions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions to use in a triggered build.
     * Should only be used with RunBuildTrigger
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 9;</code>
     */
    public Builder putAllSubstitutions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSubstitutions().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.RepoSource)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.RepoSource)
  private static final com.google.cloudbuild.v1.RepoSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.RepoSource();
  }

  public static com.google.cloudbuild.v1.RepoSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepoSource> PARSER =
      new com.google.protobuf.AbstractParser<RepoSource>() {
        @java.lang.Override
        public RepoSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RepoSource(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RepoSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepoSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
