/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Artifacts created by the build pipeline.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Results}
 */
public final class Results extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Results)
    ResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Results.newBuilder() to construct.
  private Results(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Results() {
    images_ = java.util.Collections.emptyList();
    buildStepImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    artifactManifest_ = "";
    buildStepOutputs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Results();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Results(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                images_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuiltImage>();
                mutable_bitField0_ |= 0x00000001;
              }
              images_.add(
                  input.readMessage(
                      com.google.cloudbuild.v1.BuiltImage.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                buildStepImages_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              buildStepImages_.add(s);
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              artifactManifest_ = s;
              break;
            }
          case 40:
            {
              numArtifacts_ = input.readInt64();
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                buildStepOutputs_ = new java.util.ArrayList<com.google.protobuf.ByteString>();
                mutable_bitField0_ |= 0x00000004;
              }
              buildStepOutputs_.add(input.readBytes());
              break;
            }
          case 58:
            {
              com.google.cloudbuild.v1.TimeSpan.Builder subBuilder = null;
              if (artifactTiming_ != null) {
                subBuilder = artifactTiming_.toBuilder();
              }
              artifactTiming_ =
                  input.readMessage(com.google.cloudbuild.v1.TimeSpan.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(artifactTiming_);
                artifactTiming_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        images_ = java.util.Collections.unmodifiableList(images_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        buildStepImages_ = buildStepImages_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        buildStepOutputs_ = java.util.Collections.unmodifiableList(buildStepOutputs_); // C
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Results_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Results.class, com.google.cloudbuild.v1.Results.Builder.class);
  }

  public static final int IMAGES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloudbuild.v1.BuiltImage> images_;
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.BuiltImage> getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.BuiltImageOrBuilder>
      getImagesOrBuilderList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuiltImage getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Container images that were built as a part of the build.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuiltImageOrBuilder getImagesOrBuilder(int index) {
    return images_.get(index);
  }

  public static final int BUILD_STEP_IMAGES_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList buildStepImages_;
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @return A list containing the buildStepImages.
   */
  public com.google.protobuf.ProtocolStringList getBuildStepImagesList() {
    return buildStepImages_;
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @return The count of buildStepImages.
   */
  public int getBuildStepImagesCount() {
    return buildStepImages_.size();
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The buildStepImages at the given index.
   */
  public java.lang.String getBuildStepImages(int index) {
    return buildStepImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of build step digests, in the order corresponding to build step
   * indices.
   * </pre>
   *
   * <code>repeated string build_step_images = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the buildStepImages at the given index.
   */
  public com.google.protobuf.ByteString getBuildStepImagesBytes(int index) {
    return buildStepImages_.getByteString(index);
  }

  public static final int ARTIFACT_MANIFEST_FIELD_NUMBER = 4;
  private volatile java.lang.Object artifactManifest_;
  /**
   *
   *
   * <pre>
   * Path to the artifact manifest. Only populated when artifacts are uploaded.
   * </pre>
   *
   * <code>string artifact_manifest = 4;</code>
   *
   * @return The artifactManifest.
   */
  @java.lang.Override
  public java.lang.String getArtifactManifest() {
    java.lang.Object ref = artifactManifest_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      artifactManifest_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path to the artifact manifest. Only populated when artifacts are uploaded.
   * </pre>
   *
   * <code>string artifact_manifest = 4;</code>
   *
   * @return The bytes for artifactManifest.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArtifactManifestBytes() {
    java.lang.Object ref = artifactManifest_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      artifactManifest_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUM_ARTIFACTS_FIELD_NUMBER = 5;
  private long numArtifacts_;
  /**
   *
   *
   * <pre>
   * Number of artifacts uploaded. Only populated when artifacts are uploaded.
   * </pre>
   *
   * <code>int64 num_artifacts = 5;</code>
   *
   * @return The numArtifacts.
   */
  @java.lang.Override
  public long getNumArtifacts() {
    return numArtifacts_;
  }

  public static final int BUILD_STEP_OUTPUTS_FIELD_NUMBER = 6;
  private java.util.List<com.google.protobuf.ByteString> buildStepOutputs_;
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @return A list containing the buildStepOutputs.
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.ByteString> getBuildStepOutputsList() {
    return buildStepOutputs_;
  }
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @return The count of buildStepOutputs.
   */
  public int getBuildStepOutputsCount() {
    return buildStepOutputs_.size();
  }
  /**
   *
   *
   * <pre>
   * List of build step outputs, produced by builder images, in the order
   * corresponding to build step indices.
   * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
   * can produce this output by writing to `$BUILDER_OUTPUT/output`.
   * Only the first 4KB of data is stored.
   * </pre>
   *
   * <code>repeated bytes build_step_outputs = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The buildStepOutputs at the given index.
   */
  public com.google.protobuf.ByteString getBuildStepOutputs(int index) {
    return buildStepOutputs_.get(index);
  }

  public static final int ARTIFACT_TIMING_FIELD_NUMBER = 7;
  private com.google.cloudbuild.v1.TimeSpan artifactTiming_;
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   *
   * @return Whether the artifactTiming field is set.
   */
  @java.lang.Override
  public boolean hasArtifactTiming() {
    return artifactTiming_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   *
   * @return The artifactTiming.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getArtifactTiming() {
    return artifactTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : artifactTiming_;
  }
  /**
   *
   *
   * <pre>
   * Time to push all non-container artifacts.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getArtifactTimingOrBuilder() {
    return getArtifactTiming();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < images_.size(); i++) {
      output.writeMessage(2, images_.get(i));
    }
    for (int i = 0; i < buildStepImages_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, buildStepImages_.getRaw(i));
    }
    if (!getArtifactManifestBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, artifactManifest_);
    }
    if (numArtifacts_ != 0L) {
      output.writeInt64(5, numArtifacts_);
    }
    for (int i = 0; i < buildStepOutputs_.size(); i++) {
      output.writeBytes(6, buildStepOutputs_.get(i));
    }
    if (artifactTiming_ != null) {
      output.writeMessage(7, getArtifactTiming());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < images_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, images_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < buildStepImages_.size(); i++) {
        dataSize += computeStringSizeNoTag(buildStepImages_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBuildStepImagesList().size();
    }
    if (!getArtifactManifestBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, artifactManifest_);
    }
    if (numArtifacts_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, numArtifacts_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < buildStepOutputs_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(buildStepOutputs_.get(i));
      }
      size += dataSize;
      size += 1 * getBuildStepOutputsList().size();
    }
    if (artifactTiming_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getArtifactTiming());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Results)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Results other = (com.google.cloudbuild.v1.Results) obj;

    if (!getImagesList().equals(other.getImagesList())) return false;
    if (!getBuildStepImagesList().equals(other.getBuildStepImagesList())) return false;
    if (!getArtifactManifest().equals(other.getArtifactManifest())) return false;
    if (getNumArtifacts() != other.getNumArtifacts()) return false;
    if (!getBuildStepOutputsList().equals(other.getBuildStepOutputsList())) return false;
    if (hasArtifactTiming() != other.hasArtifactTiming()) return false;
    if (hasArtifactTiming()) {
      if (!getArtifactTiming().equals(other.getArtifactTiming())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (getBuildStepImagesCount() > 0) {
      hash = (37 * hash) + BUILD_STEP_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getBuildStepImagesList().hashCode();
    }
    hash = (37 * hash) + ARTIFACT_MANIFEST_FIELD_NUMBER;
    hash = (53 * hash) + getArtifactManifest().hashCode();
    hash = (37 * hash) + NUM_ARTIFACTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNumArtifacts());
    if (getBuildStepOutputsCount() > 0) {
      hash = (37 * hash) + BUILD_STEP_OUTPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getBuildStepOutputsList().hashCode();
    }
    if (hasArtifactTiming()) {
      hash = (37 * hash) + ARTIFACT_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getArtifactTiming().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Results parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Results parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Results prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Artifacts created by the build pipeline.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Results}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Results)
      com.google.cloudbuild.v1.ResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Results.class,
              com.google.cloudbuild.v1.Results.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Results.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getImagesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        imagesBuilder_.clear();
      }
      buildStepImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      artifactManifest_ = "";

      numArtifacts_ = 0L;

      buildStepOutputs_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      if (artifactTimingBuilder_ == null) {
        artifactTiming_ = null;
      } else {
        artifactTiming_ = null;
        artifactTimingBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Results_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Results.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results build() {
      com.google.cloudbuild.v1.Results result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Results buildPartial() {
      com.google.cloudbuild.v1.Results result = new com.google.cloudbuild.v1.Results(this);
      int from_bitField0_ = bitField0_;
      if (imagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          images_ = java.util.Collections.unmodifiableList(images_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.images_ = images_;
      } else {
        result.images_ = imagesBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        buildStepImages_ = buildStepImages_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.buildStepImages_ = buildStepImages_;
      result.artifactManifest_ = artifactManifest_;
      result.numArtifacts_ = numArtifacts_;
      if (((bitField0_ & 0x00000004) != 0)) {
        buildStepOutputs_ = java.util.Collections.unmodifiableList(buildStepOutputs_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.buildStepOutputs_ = buildStepOutputs_;
      if (artifactTimingBuilder_ == null) {
        result.artifactTiming_ = artifactTiming_;
      } else {
        result.artifactTiming_ = artifactTimingBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Results) {
        return mergeFrom((com.google.cloudbuild.v1.Results) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Results other) {
      if (other == com.google.cloudbuild.v1.Results.getDefaultInstance()) return this;
      if (imagesBuilder_ == null) {
        if (!other.images_.isEmpty()) {
          if (images_.isEmpty()) {
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureImagesIsMutable();
            images_.addAll(other.images_);
          }
          onChanged();
        }
      } else {
        if (!other.images_.isEmpty()) {
          if (imagesBuilder_.isEmpty()) {
            imagesBuilder_.dispose();
            imagesBuilder_ = null;
            images_ = other.images_;
            bitField0_ = (bitField0_ & ~0x00000001);
            imagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImagesFieldBuilder()
                    : null;
          } else {
            imagesBuilder_.addAllMessages(other.images_);
          }
        }
      }
      if (!other.buildStepImages_.isEmpty()) {
        if (buildStepImages_.isEmpty()) {
          buildStepImages_ = other.buildStepImages_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureBuildStepImagesIsMutable();
          buildStepImages_.addAll(other.buildStepImages_);
        }
        onChanged();
      }
      if (!other.getArtifactManifest().isEmpty()) {
        artifactManifest_ = other.artifactManifest_;
        onChanged();
      }
      if (other.getNumArtifacts() != 0L) {
        setNumArtifacts(other.getNumArtifacts());
      }
      if (!other.buildStepOutputs_.isEmpty()) {
        if (buildStepOutputs_.isEmpty()) {
          buildStepOutputs_ = other.buildStepOutputs_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureBuildStepOutputsIsMutable();
          buildStepOutputs_.addAll(other.buildStepOutputs_);
        }
        onChanged();
      }
      if (other.hasArtifactTiming()) {
        mergeArtifactTiming(other.getArtifactTiming());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloudbuild.v1.Results parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloudbuild.v1.Results) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloudbuild.v1.BuiltImage> images_ =
        java.util.Collections.emptyList();

    private void ensureImagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        images_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuiltImage>(images_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuiltImage,
            com.google.cloudbuild.v1.BuiltImage.Builder,
            com.google.cloudbuild.v1.BuiltImageOrBuilder>
        imagesBuilder_;

    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuiltImage> getImagesList() {
      if (imagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(images_);
      } else {
        return imagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public int getImagesCount() {
      if (imagesBuilder_ == null) {
        return images_.size();
      } else {
        return imagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage getImages(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder setImages(int index, com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.set(index, value);
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder setImages(
        int index, com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.set(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(int index, com.google.cloudbuild.v1.BuiltImage value) {
      if (imagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImagesIsMutable();
        images_.add(index, value);
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addImages(
        int index, com.google.cloudbuild.v1.BuiltImage.Builder builderForValue) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.add(index, builderForValue.build());
        onChanged();
      } else {
        imagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder addAllImages(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.BuiltImage> values) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
        onChanged();
      } else {
        imagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder clearImages() {
      if (imagesBuilder_ == null) {
        images_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        imagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public Builder removeImages(int index) {
      if (imagesBuilder_ == null) {
        ensureImagesIsMutable();
        images_.remove(index);
        onChanged();
      } else {
        imagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder getImagesBuilder(int index) {
      return getImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImageOrBuilder getImagesOrBuilder(int index) {
      if (imagesBuilder_ == null) {
        return images_.get(index);
      } else {
        return imagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.BuiltImageOrBuilder>
        getImagesOrBuilderList() {
      if (imagesBuilder_ != null) {
        return imagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(images_);
      }
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder addImagesBuilder() {
      return getImagesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.BuiltImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public com.google.cloudbuild.v1.BuiltImage.Builder addImagesBuilder(int index) {
      return getImagesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.BuiltImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Container images that were built as a part of the build.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuiltImage images = 2;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuiltImage.Builder> getImagesBuilderList() {
      return getImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuiltImage,
            com.google.cloudbuild.v1.BuiltImage.Builder,
            com.google.cloudbuild.v1.BuiltImageOrBuilder>
        getImagesFieldBuilder() {
      if (imagesBuilder_ == null) {
        imagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.BuiltImage,
                com.google.cloudbuild.v1.BuiltImage.Builder,
                com.google.cloudbuild.v1.BuiltImageOrBuilder>(
                images_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        images_ = null;
      }
      return imagesBuilder_;
    }

    private com.google.protobuf.LazyStringList buildStepImages_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureBuildStepImagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        buildStepImages_ = new com.google.protobuf.LazyStringArrayList(buildStepImages_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return A list containing the buildStepImages.
     */
    public com.google.protobuf.ProtocolStringList getBuildStepImagesList() {
      return buildStepImages_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return The count of buildStepImages.
     */
    public int getBuildStepImagesCount() {
      return buildStepImages_.size();
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The buildStepImages at the given index.
     */
    public java.lang.String getBuildStepImages(int index) {
      return buildStepImages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the buildStepImages at the given index.
     */
    public com.google.protobuf.ByteString getBuildStepImagesBytes(int index) {
      return buildStepImages_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The buildStepImages to set.
     * @return This builder for chaining.
     */
    public Builder setBuildStepImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepImagesIsMutable();
      buildStepImages_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param value The buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepImagesIsMutable();
      buildStepImages_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param values The buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addAllBuildStepImages(java.lang.Iterable<java.lang.String> values) {
      ensureBuildStepImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buildStepImages_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildStepImages() {
      buildStepImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step digests, in the order corresponding to build step
     * indices.
     * </pre>
     *
     * <code>repeated string build_step_images = 3;</code>
     *
     * @param value The bytes of the buildStepImages to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBuildStepImagesIsMutable();
      buildStepImages_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object artifactManifest_ = "";
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return The artifactManifest.
     */
    public java.lang.String getArtifactManifest() {
      java.lang.Object ref = artifactManifest_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        artifactManifest_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return The bytes for artifactManifest.
     */
    public com.google.protobuf.ByteString getArtifactManifestBytes() {
      java.lang.Object ref = artifactManifest_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        artifactManifest_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @param value The artifactManifest to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactManifest(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      artifactManifest_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArtifactManifest() {

      artifactManifest_ = getDefaultInstance().getArtifactManifest();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path to the artifact manifest. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>string artifact_manifest = 4;</code>
     *
     * @param value The bytes for artifactManifest to set.
     * @return This builder for chaining.
     */
    public Builder setArtifactManifestBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      artifactManifest_ = value;
      onChanged();
      return this;
    }

    private long numArtifacts_;
    /**
     *
     *
     * <pre>
     * Number of artifacts uploaded. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @return The numArtifacts.
     */
    @java.lang.Override
    public long getNumArtifacts() {
      return numArtifacts_;
    }
    /**
     *
     *
     * <pre>
     * Number of artifacts uploaded. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @param value The numArtifacts to set.
     * @return This builder for chaining.
     */
    public Builder setNumArtifacts(long value) {

      numArtifacts_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of artifacts uploaded. Only populated when artifacts are uploaded.
     * </pre>
     *
     * <code>int64 num_artifacts = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumArtifacts() {

      numArtifacts_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.ByteString> buildStepOutputs_ =
        java.util.Collections.emptyList();

    private void ensureBuildStepOutputsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        buildStepOutputs_ =
            new java.util.ArrayList<com.google.protobuf.ByteString>(buildStepOutputs_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return A list containing the buildStepOutputs.
     */
    public java.util.List<com.google.protobuf.ByteString> getBuildStepOutputsList() {
      return ((bitField0_ & 0x00000004) != 0)
          ? java.util.Collections.unmodifiableList(buildStepOutputs_)
          : buildStepOutputs_;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return The count of buildStepOutputs.
     */
    public int getBuildStepOutputsCount() {
      return buildStepOutputs_.size();
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The buildStepOutputs at the given index.
     */
    public com.google.protobuf.ByteString getBuildStepOutputs(int index) {
      return buildStepOutputs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The buildStepOutputs to set.
     * @return This builder for chaining.
     */
    public Builder setBuildStepOutputs(int index, com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepOutputsIsMutable();
      buildStepOutputs_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param value The buildStepOutputs to add.
     * @return This builder for chaining.
     */
    public Builder addBuildStepOutputs(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBuildStepOutputsIsMutable();
      buildStepOutputs_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @param values The buildStepOutputs to add.
     * @return This builder for chaining.
     */
    public Builder addAllBuildStepOutputs(
        java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
      ensureBuildStepOutputsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buildStepOutputs_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of build step outputs, produced by builder images, in the order
     * corresponding to build step indices.
     * [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
     * can produce this output by writing to `$BUILDER_OUTPUT/output`.
     * Only the first 4KB of data is stored.
     * </pre>
     *
     * <code>repeated bytes build_step_outputs = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildStepOutputs() {
      buildStepOutputs_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.TimeSpan artifactTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        artifactTimingBuilder_;
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     *
     * @return Whether the artifactTiming field is set.
     */
    public boolean hasArtifactTiming() {
      return artifactTimingBuilder_ != null || artifactTiming_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     *
     * @return The artifactTiming.
     */
    public com.google.cloudbuild.v1.TimeSpan getArtifactTiming() {
      if (artifactTimingBuilder_ == null) {
        return artifactTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : artifactTiming_;
      } else {
        return artifactTimingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder setArtifactTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (artifactTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifactTiming_ = value;
        onChanged();
      } else {
        artifactTimingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder setArtifactTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (artifactTimingBuilder_ == null) {
        artifactTiming_ = builderForValue.build();
        onChanged();
      } else {
        artifactTimingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder mergeArtifactTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (artifactTimingBuilder_ == null) {
        if (artifactTiming_ != null) {
          artifactTiming_ =
              com.google.cloudbuild.v1.TimeSpan.newBuilder(artifactTiming_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          artifactTiming_ = value;
        }
        onChanged();
      } else {
        artifactTimingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public Builder clearArtifactTiming() {
      if (artifactTimingBuilder_ == null) {
        artifactTiming_ = null;
        onChanged();
      } else {
        artifactTiming_ = null;
        artifactTimingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getArtifactTimingBuilder() {

      onChanged();
      return getArtifactTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getArtifactTimingOrBuilder() {
      if (artifactTimingBuilder_ != null) {
        return artifactTimingBuilder_.getMessageOrBuilder();
      } else {
        return artifactTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : artifactTiming_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time to push all non-container artifacts.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.TimeSpan artifact_timing = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getArtifactTimingFieldBuilder() {
      if (artifactTimingBuilder_ == null) {
        artifactTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getArtifactTiming(), getParentForChildren(), isClean());
        artifactTiming_ = null;
      }
      return artifactTimingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Results)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Results)
  private static final com.google.cloudbuild.v1.Results DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Results();
  }

  public static com.google.cloudbuild.v1.Results getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Results> PARSER =
      new com.google.protobuf.AbstractParser<Results>() {
        @java.lang.Override
        public Results parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Results(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Results> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Results> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Results getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
