/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * A step in the build pipeline.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.BuildStep}
 */
public final class BuildStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.BuildStep)
    BuildStepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BuildStep.newBuilder() to construct.
  private BuildStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BuildStep() {
    name_ = "";
    env_ = com.google.protobuf.LazyStringArrayList.emptyList();
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    dir_ = "";
    id_ = "";
    waitFor_ = com.google.protobuf.LazyStringArrayList.emptyList();
    entrypoint_ = "";
    secretEnv_ = com.google.protobuf.LazyStringArrayList.emptyList();
    volumes_ = java.util.Collections.emptyList();
    status_ = 0;
    allowExitCodes_ = emptyIntList();
    script_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BuildStep();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_BuildStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.BuildStep.class,
            com.google.cloudbuild.v1.BuildStep.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the container image that will run this particular
   * build step.
   *
   * If the image is available in the host's Docker daemon's cache, it
   * will be run directly. If not, the host will attempt to pull the image
   * first, using the builder service account's credentials if necessary.
   *
   * The Docker daemon's cache will already have the latest versions of all of
   * the officially supported build steps
   * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
   * The Docker daemon will also have cached many of the layers for some popular
   * images, like "ubuntu", "debian", but they will be refreshed at the time you
   * attempt to use them.
   *
   * If you built an image in a previous build step, it will be stored in the
   * host's Docker daemon's cache and is available to use as the name for a
   * later build step.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the container image that will run this particular
   * build step.
   *
   * If the image is available in the host's Docker daemon's cache, it
   * will be run directly. If not, the host will attempt to pull the image
   * first, using the builder service account's credentials if necessary.
   *
   * The Docker daemon's cache will already have the latest versions of all of
   * the officially supported build steps
   * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
   * The Docker daemon will also have cached many of the layers for some popular
   * images, like "ubuntu", "debian", but they will be refreshed at the time you
   * attempt to use them.
   *
   * If you built an image in a previous build step, it will be stored in the
   * host's Docker daemon's cache and is available to use as the name for a
   * later build step.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENV_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList env_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   *
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @return A list containing the env.
   */
  public com.google.protobuf.ProtocolStringList getEnvList() {
    return env_;
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   *
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @return The count of env.
   */
  public int getEnvCount() {
    return env_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   *
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The env at the given index.
   */
  public java.lang.String getEnv(int index) {
    return env_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of environment variable definitions to be used when running a step.
   *
   * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
   * being given the value "VALUE".
   * </pre>
   *
   * <code>repeated string env = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the env at the given index.
   */
  public com.google.protobuf.ByteString getEnvBytes(int index) {
    return env_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   *
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   *
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   *
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of arguments that will be presented to the step when it is started.
   *
   * If the image used to run the step's container has an entrypoint, the `args`
   * are used as arguments to that entrypoint. If the image does not define
   * an entrypoint, the first element in args is used as the entrypoint,
   * and the remainder will be used as arguments.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int DIR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dir_ = "";
  /**
   *
   *
   * <pre>
   * Working directory to use when running this step's container.
   *
   * If this value is a relative path, it is relative to the build's working
   * directory. If this value is absolute, it may be outside the build's working
   * directory, in which case the contents of the path may not be persisted
   * across build step executions, unless a `volume` for that path is specified.
   *
   * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
   * which specifies an absolute path, the `RepoSource` `dir` is ignored for
   * the step's execution.
   * </pre>
   *
   * <code>string dir = 4;</code>
   *
   * @return The dir.
   */
  @java.lang.Override
  public java.lang.String getDir() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Working directory to use when running this step's container.
   *
   * If this value is a relative path, it is relative to the build's working
   * directory. If this value is absolute, it may be outside the build's working
   * directory, in which case the contents of the path may not be persisted
   * across build step executions, unless a `volume` for that path is specified.
   *
   * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
   * which specifies an absolute path, the `RepoSource` `dir` is ignored for
   * the step's execution.
   * </pre>
   *
   * <code>string dir = 4;</code>
   *
   * @return The bytes for dir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirBytes() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Unique identifier for this build step, used in `wait_for` to
   * reference this build step as a dependency.
   * </pre>
   *
   * <code>string id = 5;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique identifier for this build step, used in `wait_for` to
   * reference this build step as a dependency.
   * </pre>
   *
   * <code>string id = 5;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WAIT_FOR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList waitFor_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @return A list containing the waitFor.
   */
  public com.google.protobuf.ProtocolStringList getWaitForList() {
    return waitFor_;
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @return The count of waitFor.
   */
  public int getWaitForCount() {
    return waitFor_.size();
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The waitFor at the given index.
   */
  public java.lang.String getWaitFor(int index) {
    return waitFor_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The ID(s) of the step(s) that this build step depends on.
   * This build step will not start until all the build steps in `wait_for`
   * have completed successfully. If `wait_for` is empty, this build step will
   * start when all previous build steps in the `Build.Steps` list have
   * completed successfully.
   * </pre>
   *
   * <code>repeated string wait_for = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the waitFor at the given index.
   */
  public com.google.protobuf.ByteString getWaitForBytes(int index) {
    return waitFor_.getByteString(index);
  }

  public static final int ENTRYPOINT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object entrypoint_ = "";
  /**
   *
   *
   * <pre>
   * Entrypoint to be used instead of the build step image's default entrypoint.
   * If unset, the image's default entrypoint is used.
   * </pre>
   *
   * <code>string entrypoint = 7;</code>
   *
   * @return The entrypoint.
   */
  @java.lang.Override
  public java.lang.String getEntrypoint() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entrypoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Entrypoint to be used instead of the build step image's default entrypoint.
   * If unset, the image's default entrypoint is used.
   * </pre>
   *
   * <code>string entrypoint = 7;</code>
   *
   * @return The bytes for entrypoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntrypointBytes() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entrypoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_ENV_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList secretEnv_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @return A list containing the secretEnv.
   */
  public com.google.protobuf.ProtocolStringList getSecretEnvList() {
    return secretEnv_;
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @return The count of secretEnv.
   */
  public int getSecretEnvCount() {
    return secretEnv_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The secretEnv at the given index.
   */
  public java.lang.String getSecretEnv(int index) {
    return secretEnv_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of environment variables which are encrypted using a Cloud Key
   * Management Service crypto key. These values must be specified in the
   * build's `Secret`.
   * </pre>
   *
   * <code>repeated string secret_env = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the secretEnv at the given index.
   */
  public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
    return secretEnv_.getByteString(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   *
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   *
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   *
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   *
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   *
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   *
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   *
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   *
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of volumes to mount into the build step.
   *
   * Each volume is created as an empty volume prior to execution of the
   * build step. Upon completion of the build, volumes and their contents are
   * discarded.
   *
   * Using a named volume in only one step is not valid as it is indicative
   * of a build request with an incorrect configuration.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int TIMING_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v1.TimeSpan timing_;
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the timing field is set.
   */
  @java.lang.Override
  public boolean hasTiming() {
    return timing_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The timing.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getTiming() {
    return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for executing this build step.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
    return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
  }

  public static final int PULL_TIMING_FIELD_NUMBER = 13;
  private com.google.cloudbuild.v1.TimeSpan pullTiming_;
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the pullTiming field is set.
   */
  @java.lang.Override
  public boolean hasPullTiming() {
    return pullTiming_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The pullTiming.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getPullTiming() {
    return pullTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : pullTiming_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for pulling this build step's
   * builder image only.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpanOrBuilder getPullTimingOrBuilder() {
    return pullTiming_ == null
        ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
        : pullTiming_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 11;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Time limit for executing this build step. If not defined, the step has no
   * time limit and will be allowed to continue to run until either it completes
   * or the build itself times out.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int STATUS_FIELD_NUMBER = 12;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Status of the build step. At this time, build step status is
   * only updated on build completion; step status is not updated in real-time
   * as the build progresses.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the build step. At this time, build step status is
   * only updated on build completion; step status is not updated in real-time
   * as the build progresses.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.Status getStatus() {
    com.google.cloudbuild.v1.Build.Status result =
        com.google.cloudbuild.v1.Build.Status.forNumber(status_);
    return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
  }

  public static final int ALLOW_FAILURE_FIELD_NUMBER = 14;
  private boolean allowFailure_ = false;
  /**
   *
   *
   * <pre>
   * Allow this build step to fail without failing the entire build.
   *
   * If false, the entire build will fail if this step fails. Otherwise, the
   * build will succeed, but this step will still have a failure status.
   * Error information will be reported in the failure_detail field.
   * </pre>
   *
   * <code>bool allow_failure = 14;</code>
   *
   * @return The allowFailure.
   */
  @java.lang.Override
  public boolean getAllowFailure() {
    return allowFailure_;
  }

  public static final int EXIT_CODE_FIELD_NUMBER = 16;
  private int exitCode_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Return code from running the step.
   * </pre>
   *
   * <code>int32 exit_code = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The exitCode.
   */
  @java.lang.Override
  public int getExitCode() {
    return exitCode_;
  }

  public static final int ALLOW_EXIT_CODES_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList allowExitCodes_;
  /**
   *
   *
   * <pre>
   * Allow this build step to fail without failing the entire build if and
   * only if the exit code is one of the specified codes. If allow_failure
   * is also specified, this field will take precedence.
   * </pre>
   *
   * <code>repeated int32 allow_exit_codes = 18;</code>
   *
   * @return A list containing the allowExitCodes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAllowExitCodesList() {
    return allowExitCodes_;
  }
  /**
   *
   *
   * <pre>
   * Allow this build step to fail without failing the entire build if and
   * only if the exit code is one of the specified codes. If allow_failure
   * is also specified, this field will take precedence.
   * </pre>
   *
   * <code>repeated int32 allow_exit_codes = 18;</code>
   *
   * @return The count of allowExitCodes.
   */
  public int getAllowExitCodesCount() {
    return allowExitCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Allow this build step to fail without failing the entire build if and
   * only if the exit code is one of the specified codes. If allow_failure
   * is also specified, this field will take precedence.
   * </pre>
   *
   * <code>repeated int32 allow_exit_codes = 18;</code>
   *
   * @param index The index of the element to return.
   * @return The allowExitCodes at the given index.
   */
  public int getAllowExitCodes(int index) {
    return allowExitCodes_.getInt(index);
  }

  private int allowExitCodesMemoizedSerializedSize = -1;

  public static final int SCRIPT_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object script_ = "";
  /**
   *
   *
   * <pre>
   * A shell script to be executed in the step.
   *
   * When script is provided, the user cannot specify the entrypoint or args.
   * </pre>
   *
   * <code>string script = 19;</code>
   *
   * @return The script.
   */
  @java.lang.Override
  public java.lang.String getScript() {
    java.lang.Object ref = script_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      script_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A shell script to be executed in the step.
   *
   * When script is provided, the user cannot specify the entrypoint or args.
   * </pre>
   *
   * <code>string script = 19;</code>
   *
   * @return The bytes for script.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScriptBytes() {
    java.lang.Object ref = script_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      script_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < env_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, env_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, dir_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, id_);
    }
    for (int i = 0; i < waitFor_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, waitFor_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, entrypoint_);
    }
    for (int i = 0; i < secretEnv_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, secretEnv_.getRaw(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(9, volumes_.get(i));
    }
    if (timing_ != null) {
      output.writeMessage(10, getTiming());
    }
    if (timeout_ != null) {
      output.writeMessage(11, getTimeout());
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      output.writeEnum(12, status_);
    }
    if (pullTiming_ != null) {
      output.writeMessage(13, getPullTiming());
    }
    if (allowFailure_ != false) {
      output.writeBool(14, allowFailure_);
    }
    if (exitCode_ != 0) {
      output.writeInt32(16, exitCode_);
    }
    if (getAllowExitCodesList().size() > 0) {
      output.writeUInt32NoTag(146);
      output.writeUInt32NoTag(allowExitCodesMemoizedSerializedSize);
    }
    for (int i = 0; i < allowExitCodes_.size(); i++) {
      output.writeInt32NoTag(allowExitCodes_.getInt(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(script_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, script_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < env_.size(); i++) {
        dataSize += computeStringSizeNoTag(env_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEnvList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, dir_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < waitFor_.size(); i++) {
        dataSize += computeStringSizeNoTag(waitFor_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWaitForList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, entrypoint_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < secretEnv_.size(); i++) {
        dataSize += computeStringSizeNoTag(secretEnv_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSecretEnvList().size();
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, volumes_.get(i));
    }
    if (timing_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getTiming());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getTimeout());
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, status_);
    }
    if (pullTiming_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getPullTiming());
    }
    if (allowFailure_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, allowFailure_);
    }
    if (exitCode_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(16, exitCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowExitCodes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(allowExitCodes_.getInt(i));
      }
      size += dataSize;
      if (!getAllowExitCodesList().isEmpty()) {
        size += 2;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      allowExitCodesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(script_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, script_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.BuildStep)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.BuildStep other = (com.google.cloudbuild.v1.BuildStep) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getDir().equals(other.getDir())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getWaitForList().equals(other.getWaitForList())) return false;
    if (!getEntrypoint().equals(other.getEntrypoint())) return false;
    if (!getSecretEnvList().equals(other.getSecretEnvList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (hasTiming() != other.hasTiming()) return false;
    if (hasTiming()) {
      if (!getTiming().equals(other.getTiming())) return false;
    }
    if (hasPullTiming() != other.hasPullTiming()) return false;
    if (hasPullTiming()) {
      if (!getPullTiming().equals(other.getPullTiming())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (status_ != other.status_) return false;
    if (getAllowFailure() != other.getAllowFailure()) return false;
    if (getExitCode() != other.getExitCode()) return false;
    if (!getAllowExitCodesList().equals(other.getAllowExitCodesList())) return false;
    if (!getScript().equals(other.getScript())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    hash = (37 * hash) + DIR_FIELD_NUMBER;
    hash = (53 * hash) + getDir().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getWaitForCount() > 0) {
      hash = (37 * hash) + WAIT_FOR_FIELD_NUMBER;
      hash = (53 * hash) + getWaitForList().hashCode();
    }
    hash = (37 * hash) + ENTRYPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntrypoint().hashCode();
    if (getSecretEnvCount() > 0) {
      hash = (37 * hash) + SECRET_ENV_FIELD_NUMBER;
      hash = (53 * hash) + getSecretEnvList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    if (hasTiming()) {
      hash = (37 * hash) + TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getTiming().hashCode();
    }
    if (hasPullTiming()) {
      hash = (37 * hash) + PULL_TIMING_FIELD_NUMBER;
      hash = (53 * hash) + getPullTiming().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + ALLOW_FAILURE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowFailure());
    hash = (37 * hash) + EXIT_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getExitCode();
    if (getAllowExitCodesCount() > 0) {
      hash = (37 * hash) + ALLOW_EXIT_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowExitCodesList().hashCode();
    }
    hash = (37 * hash) + SCRIPT_FIELD_NUMBER;
    hash = (53 * hash) + getScript().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.BuildStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.BuildStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A step in the build pipeline.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.BuildStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.BuildStep)
      com.google.cloudbuild.v1.BuildStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.BuildStep.class,
              com.google.cloudbuild.v1.BuildStep.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.BuildStep.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      env_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dir_ = "";
      id_ = "";
      waitFor_ = com.google.protobuf.LazyStringArrayList.emptyList();
      entrypoint_ = "";
      secretEnv_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      timing_ = null;
      if (timingBuilder_ != null) {
        timingBuilder_.dispose();
        timingBuilder_ = null;
      }
      pullTiming_ = null;
      if (pullTimingBuilder_ != null) {
        pullTimingBuilder_.dispose();
        pullTimingBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      status_ = 0;
      allowFailure_ = false;
      exitCode_ = 0;
      allowExitCodes_ = emptyIntList();
      script_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_BuildStep_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.BuildStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep build() {
      com.google.cloudbuild.v1.BuildStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.BuildStep buildPartial() {
      com.google.cloudbuild.v1.BuildStep result = new com.google.cloudbuild.v1.BuildStep(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloudbuild.v1.BuildStep result) {
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
      if (((bitField0_ & 0x00008000) != 0)) {
        allowExitCodes_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00008000);
      }
      result.allowExitCodes_ = allowExitCodes_;
    }

    private void buildPartial0(com.google.cloudbuild.v1.BuildStep result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        env_.makeImmutable();
        result.env_ = env_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dir_ = dir_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        waitFor_.makeImmutable();
        result.waitFor_ = waitFor_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.entrypoint_ = entrypoint_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        secretEnv_.makeImmutable();
        result.secretEnv_ = secretEnv_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.timing_ = timingBuilder_ == null ? timing_ : timingBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pullTiming_ = pullTimingBuilder_ == null ? pullTiming_ : pullTimingBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.allowFailure_ = allowFailure_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.exitCode_ = exitCode_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.script_ = script_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.BuildStep) {
        return mergeFrom((com.google.cloudbuild.v1.BuildStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.BuildStep other) {
      if (other == com.google.cloudbuild.v1.BuildStep.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.env_.isEmpty()) {
        if (env_.isEmpty()) {
          env_ = other.env_;
          bitField0_ |= 0x00000002;
        } else {
          ensureEnvIsMutable();
          env_.addAll(other.env_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000004;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (!other.getDir().isEmpty()) {
        dir_ = other.dir_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.waitFor_.isEmpty()) {
        if (waitFor_.isEmpty()) {
          waitFor_ = other.waitFor_;
          bitField0_ |= 0x00000020;
        } else {
          ensureWaitForIsMutable();
          waitFor_.addAll(other.waitFor_);
        }
        onChanged();
      }
      if (!other.getEntrypoint().isEmpty()) {
        entrypoint_ = other.entrypoint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.secretEnv_.isEmpty()) {
        if (secretEnv_.isEmpty()) {
          secretEnv_ = other.secretEnv_;
          bitField0_ |= 0x00000080;
        } else {
          ensureSecretEnvIsMutable();
          secretEnv_.addAll(other.secretEnv_);
        }
        onChanged();
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000100);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (other.hasTiming()) {
        mergeTiming(other.getTiming());
      }
      if (other.hasPullTiming()) {
        mergePullTiming(other.getPullTiming());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.getAllowFailure() != false) {
        setAllowFailure(other.getAllowFailure());
      }
      if (other.getExitCode() != 0) {
        setExitCode(other.getExitCode());
      }
      if (!other.allowExitCodes_.isEmpty()) {
        if (allowExitCodes_.isEmpty()) {
          allowExitCodes_ = other.allowExitCodes_;
          bitField0_ = (bitField0_ & ~0x00008000);
        } else {
          ensureAllowExitCodesIsMutable();
          allowExitCodes_.addAll(other.allowExitCodes_);
        }
        onChanged();
      }
      if (!other.getScript().isEmpty()) {
        script_ = other.script_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEnvIsMutable();
                env_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 26
            case 34:
              {
                dir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWaitForIsMutable();
                waitFor_.add(s);
                break;
              } // case 50
            case 58:
              {
                entrypoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSecretEnvIsMutable();
                secretEnv_.add(s);
                break;
              } // case 66
            case 74:
              {
                com.google.cloudbuild.v1.Volume m =
                    input.readMessage(com.google.cloudbuild.v1.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getTimingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 96:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getPullTimingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 112:
              {
                allowFailure_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 128:
              {
                exitCode_ = input.readInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case 128
            case 144:
              {
                int v = input.readInt32();
                ensureAllowExitCodesIsMutable();
                allowExitCodes_.addInt(v);
                break;
              } // case 144
            case 146:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureAllowExitCodesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  allowExitCodes_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 146
            case 154:
              {
                script_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     *
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     *
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     *
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     *
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the container image that will run this particular
     * build step.
     *
     * If the image is available in the host's Docker daemon's cache, it
     * will be run directly. If not, the host will attempt to pull the image
     * first, using the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps
     * ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time you
     * attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList env_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEnvIsMutable() {
      if (!env_.isModifiable()) {
        env_ = new com.google.protobuf.LazyStringArrayList(env_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return A list containing the env.
     */
    public com.google.protobuf.ProtocolStringList getEnvList() {
      env_.makeImmutable();
      return env_;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return The count of env.
     */
    public int getEnvCount() {
      return env_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The env at the given index.
     */
    public java.lang.String getEnv(int index) {
      return env_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the env at the given index.
     */
    public com.google.protobuf.ByteString getEnvBytes(int index) {
      return env_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The env to set.
     * @return This builder for chaining.
     */
    public Builder setEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param value The env to add.
     * @return This builder for chaining.
     */
    public Builder addEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnvIsMutable();
      env_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param values The env to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnv(java.lang.Iterable<java.lang.String> values) {
      ensureEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnv() {
      env_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY"
     * being given the value "VALUE".
     * </pre>
     *
     * <code>repeated string env = 2;</code>
     *
     * @param value The bytes of the env to add.
     * @return This builder for chaining.
     */
    public Builder addEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnvIsMutable();
      env_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the `args`
     * are used as arguments to that entrypoint. If the image does not define
     * an entrypoint, the first element in args is used as the entrypoint,
     * and the remainder will be used as arguments.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object dir_ = "";
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     *
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return The dir.
     */
    public java.lang.String getDir() {
      java.lang.Object ref = dir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     *
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return The bytes for dir.
     */
    public com.google.protobuf.ByteString getDirBytes() {
      java.lang.Object ref = dir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     *
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @param value The dir to set.
     * @return This builder for chaining.
     */
    public Builder setDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dir_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     *
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDir() {
      dir_ = getDefaultInstance().getDir();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a `volume` for that path is specified.
     *
     * If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
     * which specifies an absolute path, the `RepoSource` `dir` is ignored for
     * the step's execution.
     * </pre>
     *
     * <code>string dir = 4;</code>
     *
     * @param value The bytes for dir to set.
     * @return This builder for chaining.
     */
    public Builder setDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dir_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for this build step, used in `wait_for` to
     * reference this build step as a dependency.
     * </pre>
     *
     * <code>string id = 5;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList waitFor_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWaitForIsMutable() {
      if (!waitFor_.isModifiable()) {
        waitFor_ = new com.google.protobuf.LazyStringArrayList(waitFor_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return A list containing the waitFor.
     */
    public com.google.protobuf.ProtocolStringList getWaitForList() {
      waitFor_.makeImmutable();
      return waitFor_;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return The count of waitFor.
     */
    public int getWaitForCount() {
      return waitFor_.size();
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The waitFor at the given index.
     */
    public java.lang.String getWaitFor(int index) {
      return waitFor_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the waitFor at the given index.
     */
    public com.google.protobuf.ByteString getWaitForBytes(int index) {
      return waitFor_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The waitFor to set.
     * @return This builder for chaining.
     */
    public Builder setWaitFor(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWaitForIsMutable();
      waitFor_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param value The waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addWaitFor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWaitForIsMutable();
      waitFor_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param values The waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addAllWaitFor(java.lang.Iterable<java.lang.String> values) {
      ensureWaitForIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, waitFor_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWaitFor() {
      waitFor_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID(s) of the step(s) that this build step depends on.
     * This build step will not start until all the build steps in `wait_for`
     * have completed successfully. If `wait_for` is empty, this build step will
     * start when all previous build steps in the `Build.Steps` list have
     * completed successfully.
     * </pre>
     *
     * <code>repeated string wait_for = 6;</code>
     *
     * @param value The bytes of the waitFor to add.
     * @return This builder for chaining.
     */
    public Builder addWaitForBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWaitForIsMutable();
      waitFor_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object entrypoint_ = "";
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return The entrypoint.
     */
    public java.lang.String getEntrypoint() {
      java.lang.Object ref = entrypoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entrypoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return The bytes for entrypoint.
     */
    public com.google.protobuf.ByteString getEntrypointBytes() {
      java.lang.Object ref = entrypoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entrypoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @param value The entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entrypoint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntrypoint() {
      entrypoint_ = getDefaultInstance().getEntrypoint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entrypoint to be used instead of the build step image's default entrypoint.
     * If unset, the image's default entrypoint is used.
     * </pre>
     *
     * <code>string entrypoint = 7;</code>
     *
     * @param value The bytes for entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entrypoint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList secretEnv_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSecretEnvIsMutable() {
      if (!secretEnv_.isModifiable()) {
        secretEnv_ = new com.google.protobuf.LazyStringArrayList(secretEnv_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return A list containing the secretEnv.
     */
    public com.google.protobuf.ProtocolStringList getSecretEnvList() {
      secretEnv_.makeImmutable();
      return secretEnv_;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return The count of secretEnv.
     */
    public int getSecretEnvCount() {
      return secretEnv_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The secretEnv at the given index.
     */
    public java.lang.String getSecretEnv(int index) {
      return secretEnv_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the secretEnv at the given index.
     */
    public com.google.protobuf.ByteString getSecretEnvBytes(int index) {
      return secretEnv_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The secretEnv to set.
     * @return This builder for chaining.
     */
    public Builder setSecretEnv(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param value The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param values The secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addAllSecretEnv(java.lang.Iterable<java.lang.String> values) {
      ensureSecretEnvIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnv_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecretEnv() {
      secretEnv_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of environment variables which are encrypted using a Cloud Key
     * Management Service crypto key. These values must be specified in the
     * build's `Secret`.
     * </pre>
     *
     * <code>repeated string secret_env = 8;</code>
     *
     * @param value The bytes of the secretEnv to add.
     * @return This builder for chaining.
     */
    public Builder addSecretEnvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSecretEnvIsMutable();
      secretEnv_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloudbuild.v1.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloudbuild.v1.Volume>(volumes_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder setVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addVolumes(int index, com.google.cloudbuild.v1.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public com.google.cloudbuild.v1.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of volumes to mount into the build step.
     *
     * Each volume is created as an empty volume prior to execution of the
     * build step. Upon completion of the build, volumes and their contents are
     * discarded.
     *
     * Using a named volume in only one step is not valid as it is indicative
     * of a build request with an incorrect configuration.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Volume volumes = 9;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Volume,
            com.google.cloudbuild.v1.Volume.Builder,
            com.google.cloudbuild.v1.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Volume,
                com.google.cloudbuild.v1.Volume.Builder,
                com.google.cloudbuild.v1.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    private com.google.cloudbuild.v1.TimeSpan timing_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        timingBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the timing field is set.
     */
    public boolean hasTiming() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The timing.
     */
    public com.google.cloudbuild.v1.TimeSpan getTiming() {
      if (timingBuilder_ == null) {
        return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
      } else {
        return timingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (timingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timing_ = value;
      } else {
        timingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (timingBuilder_ == null) {
        timing_ = builderForValue.build();
      } else {
        timingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (timingBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && timing_ != null
            && timing_ != com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()) {
          getTimingBuilder().mergeFrom(value);
        } else {
          timing_ = value;
        }
      } else {
        timingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTiming() {
      bitField0_ = (bitField0_ & ~0x00000200);
      timing_ = null;
      if (timingBuilder_ != null) {
        timingBuilder_.dispose();
        timingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getTimingBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getTimingOrBuilder() {
      if (timingBuilder_ != null) {
        return timingBuilder_.getMessageOrBuilder();
      } else {
        return timing_ == null ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance() : timing_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for executing this build step.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan timing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getTimingFieldBuilder() {
      if (timingBuilder_ == null) {
        timingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getTiming(), getParentForChildren(), isClean());
        timing_ = null;
      }
      return timingBuilder_;
    }

    private com.google.cloudbuild.v1.TimeSpan pullTiming_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        pullTimingBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the pullTiming field is set.
     */
    public boolean hasPullTiming() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The pullTiming.
     */
    public com.google.cloudbuild.v1.TimeSpan getPullTiming() {
      if (pullTimingBuilder_ == null) {
        return pullTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : pullTiming_;
      } else {
        return pullTimingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPullTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (pullTimingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pullTiming_ = value;
      } else {
        pullTimingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPullTiming(com.google.cloudbuild.v1.TimeSpan.Builder builderForValue) {
      if (pullTimingBuilder_ == null) {
        pullTiming_ = builderForValue.build();
      } else {
        pullTimingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePullTiming(com.google.cloudbuild.v1.TimeSpan value) {
      if (pullTimingBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && pullTiming_ != null
            && pullTiming_ != com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()) {
          getPullTimingBuilder().mergeFrom(value);
        } else {
          pullTiming_ = value;
        }
      } else {
        pullTimingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPullTiming() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pullTiming_ = null;
      if (pullTimingBuilder_ != null) {
        pullTimingBuilder_.dispose();
        pullTimingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder getPullTimingBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPullTimingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpanOrBuilder getPullTimingOrBuilder() {
      if (pullTimingBuilder_ != null) {
        return pullTimingBuilder_.getMessageOrBuilder();
      } else {
        return pullTiming_ == null
            ? com.google.cloudbuild.v1.TimeSpan.getDefaultInstance()
            : pullTiming_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for pulling this build step's
     * builder image only.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.TimeSpan pull_timing = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder,
            com.google.cloudbuild.v1.TimeSpanOrBuilder>
        getPullTimingFieldBuilder() {
      if (pullTimingBuilder_ == null) {
        pullTimingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.TimeSpan,
                com.google.cloudbuild.v1.TimeSpan.Builder,
                com.google.cloudbuild.v1.TimeSpanOrBuilder>(
                getPullTiming(), getParentForChildren(), isClean());
        pullTiming_ = null;
      }
      return pullTimingBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000800);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time limit for executing this build step. If not defined, the step has no
     * time limit and will be allowed to continue to run until either it completes
     * or the build itself times out.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Status getStatus() {
      com.google.cloudbuild.v1.Build.Status result =
          com.google.cloudbuild.v1.Build.Status.forNumber(status_);
      return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloudbuild.v1.Build.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build step. At this time, build step status is
     * only updated on build completion; step status is not updated in real-time
     * as the build progresses.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00001000);
      status_ = 0;
      onChanged();
      return this;
    }

    private boolean allowFailure_;
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build.
     *
     * If false, the entire build will fail if this step fails. Otherwise, the
     * build will succeed, but this step will still have a failure status.
     * Error information will be reported in the failure_detail field.
     * </pre>
     *
     * <code>bool allow_failure = 14;</code>
     *
     * @return The allowFailure.
     */
    @java.lang.Override
    public boolean getAllowFailure() {
      return allowFailure_;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build.
     *
     * If false, the entire build will fail if this step fails. Otherwise, the
     * build will succeed, but this step will still have a failure status.
     * Error information will be reported in the failure_detail field.
     * </pre>
     *
     * <code>bool allow_failure = 14;</code>
     *
     * @param value The allowFailure to set.
     * @return This builder for chaining.
     */
    public Builder setAllowFailure(boolean value) {

      allowFailure_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build.
     *
     * If false, the entire build will fail if this step fails. Otherwise, the
     * build will succeed, but this step will still have a failure status.
     * Error information will be reported in the failure_detail field.
     * </pre>
     *
     * <code>bool allow_failure = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowFailure() {
      bitField0_ = (bitField0_ & ~0x00002000);
      allowFailure_ = false;
      onChanged();
      return this;
    }

    private int exitCode_;
    /**
     *
     *
     * <pre>
     * Output only. Return code from running the step.
     * </pre>
     *
     * <code>int32 exit_code = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The exitCode.
     */
    @java.lang.Override
    public int getExitCode() {
      return exitCode_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Return code from running the step.
     * </pre>
     *
     * <code>int32 exit_code = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The exitCode to set.
     * @return This builder for chaining.
     */
    public Builder setExitCode(int value) {

      exitCode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Return code from running the step.
     * </pre>
     *
     * <code>int32 exit_code = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExitCode() {
      bitField0_ = (bitField0_ & ~0x00004000);
      exitCode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList allowExitCodes_ = emptyIntList();

    private void ensureAllowExitCodesIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        allowExitCodes_ = mutableCopy(allowExitCodes_);
        bitField0_ |= 0x00008000;
      }
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @return A list containing the allowExitCodes.
     */
    public java.util.List<java.lang.Integer> getAllowExitCodesList() {
      return ((bitField0_ & 0x00008000) != 0)
          ? java.util.Collections.unmodifiableList(allowExitCodes_)
          : allowExitCodes_;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @return The count of allowExitCodes.
     */
    public int getAllowExitCodesCount() {
      return allowExitCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @param index The index of the element to return.
     * @return The allowExitCodes at the given index.
     */
    public int getAllowExitCodes(int index) {
      return allowExitCodes_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowExitCodes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowExitCodes(int index, int value) {

      ensureAllowExitCodesIsMutable();
      allowExitCodes_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @param value The allowExitCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowExitCodes(int value) {

      ensureAllowExitCodesIsMutable();
      allowExitCodes_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @param values The allowExitCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowExitCodes(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureAllowExitCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowExitCodes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allow this build step to fail without failing the entire build if and
     * only if the exit code is one of the specified codes. If allow_failure
     * is also specified, this field will take precedence.
     * </pre>
     *
     * <code>repeated int32 allow_exit_codes = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowExitCodes() {
      allowExitCodes_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    private java.lang.Object script_ = "";
    /**
     *
     *
     * <pre>
     * A shell script to be executed in the step.
     *
     * When script is provided, the user cannot specify the entrypoint or args.
     * </pre>
     *
     * <code>string script = 19;</code>
     *
     * @return The script.
     */
    public java.lang.String getScript() {
      java.lang.Object ref = script_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        script_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A shell script to be executed in the step.
     *
     * When script is provided, the user cannot specify the entrypoint or args.
     * </pre>
     *
     * <code>string script = 19;</code>
     *
     * @return The bytes for script.
     */
    public com.google.protobuf.ByteString getScriptBytes() {
      java.lang.Object ref = script_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        script_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A shell script to be executed in the step.
     *
     * When script is provided, the user cannot specify the entrypoint or args.
     * </pre>
     *
     * <code>string script = 19;</code>
     *
     * @param value The script to set.
     * @return This builder for chaining.
     */
    public Builder setScript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      script_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A shell script to be executed in the step.
     *
     * When script is provided, the user cannot specify the entrypoint or args.
     * </pre>
     *
     * <code>string script = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScript() {
      script_ = getDefaultInstance().getScript();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A shell script to be executed in the step.
     *
     * When script is provided, the user cannot specify the entrypoint or args.
     * </pre>
     *
     * <code>string script = 19;</code>
     *
     * @param value The bytes for script to set.
     * @return This builder for chaining.
     */
    public Builder setScriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      script_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.BuildStep)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.BuildStep)
  private static final com.google.cloudbuild.v1.BuildStep DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.BuildStep();
  }

  public static com.google.cloudbuild.v1.BuildStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BuildStep> PARSER =
      new com.google.protobuf.AbstractParser<BuildStep>() {
        @java.lang.Override
        public BuildStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BuildStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BuildStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
