/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * WebhookConfig describes the configuration of a trigger that
 * creates a build whenever a webhook is sent to a trigger's webhook URL.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.WebhookConfig}
 */
public final class WebhookConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.WebhookConfig)
    WebhookConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebhookConfig.newBuilder() to construct.
  private WebhookConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebhookConfig() {
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebhookConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WebhookConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_WebhookConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.WebhookConfig.class,
            com.google.cloudbuild.v1.WebhookConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumerates potential issues with the Secret Manager secret provided by the
   * user.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.WebhookConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The webhook auth configuration not been checked.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The auth configuration is properly setup.
     * </pre>
     *
     * <code>OK = 1;</code>
     */
    OK(1),
    /**
     *
     *
     * <pre>
     * The secret provided in auth_method has been deleted.
     * </pre>
     *
     * <code>SECRET_DELETED = 2;</code>
     */
    SECRET_DELETED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The webhook auth configuration not been checked.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The auth configuration is properly setup.
     * </pre>
     *
     * <code>OK = 1;</code>
     */
    public static final int OK_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The secret provided in auth_method has been deleted.
     * </pre>
     *
     * <code>SECRET_DELETED = 2;</code>
     */
    public static final int SECRET_DELETED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return OK;
        case 2:
          return SECRET_DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.WebhookConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.WebhookConfig.State)
  }

  private int authMethodCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authMethod_;

  public enum AuthMethodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SECRET(3),
    AUTHMETHOD_NOT_SET(0);
    private final int value;

    private AuthMethodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthMethodCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthMethodCase forNumber(int value) {
      switch (value) {
        case 3:
          return SECRET;
        case 0:
          return AUTHMETHOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthMethodCase getAuthMethodCase() {
    return AuthMethodCase.forNumber(authMethodCase_);
  }

  public static final int SECRET_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Required. Resource name for the secret required as a URL parameter.
   * </pre>
   *
   * <code>
   * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return Whether the secret field is set.
   */
  public boolean hasSecret() {
    return authMethodCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Required. Resource name for the secret required as a URL parameter.
   * </pre>
   *
   * <code>
   * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The secret.
   */
  public java.lang.String getSecret() {
    java.lang.Object ref = "";
    if (authMethodCase_ == 3) {
      ref = authMethod_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (authMethodCase_ == 3) {
        authMethod_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Resource name for the secret required as a URL parameter.
   * </pre>
   *
   * <code>
   * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for secret.
   */
  public com.google.protobuf.ByteString getSecretBytes() {
    java.lang.Object ref = "";
    if (authMethodCase_ == 3) {
      ref = authMethod_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (authMethodCase_ == 3) {
        authMethod_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Potential issues with the underlying Pub/Sub subscription configuration.
   * Only populated on get requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Potential issues with the underlying Pub/Sub subscription configuration.
   * Only populated on get requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.WebhookConfig.State getState() {
    com.google.cloudbuild.v1.WebhookConfig.State result =
        com.google.cloudbuild.v1.WebhookConfig.State.forNumber(state_);
    return result == null ? com.google.cloudbuild.v1.WebhookConfig.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (authMethodCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, authMethod_);
    }
    if (state_ != com.google.cloudbuild.v1.WebhookConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (authMethodCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, authMethod_);
    }
    if (state_ != com.google.cloudbuild.v1.WebhookConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.WebhookConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.WebhookConfig other = (com.google.cloudbuild.v1.WebhookConfig) obj;

    if (state_ != other.state_) return false;
    if (!getAuthMethodCase().equals(other.getAuthMethodCase())) return false;
    switch (authMethodCase_) {
      case 3:
        if (!getSecret().equals(other.getSecret())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (authMethodCase_) {
      case 3:
        hash = (37 * hash) + SECRET_FIELD_NUMBER;
        hash = (53 * hash) + getSecret().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.WebhookConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.WebhookConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * WebhookConfig describes the configuration of a trigger that
   * creates a build whenever a webhook is sent to a trigger's webhook URL.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.WebhookConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.WebhookConfig)
      com.google.cloudbuild.v1.WebhookConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WebhookConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WebhookConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.WebhookConfig.class,
              com.google.cloudbuild.v1.WebhookConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.WebhookConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      authMethodCase_ = 0;
      authMethod_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_WebhookConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WebhookConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WebhookConfig build() {
      com.google.cloudbuild.v1.WebhookConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.WebhookConfig buildPartial() {
      com.google.cloudbuild.v1.WebhookConfig result =
          new com.google.cloudbuild.v1.WebhookConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.WebhookConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
    }

    private void buildPartialOneofs(com.google.cloudbuild.v1.WebhookConfig result) {
      result.authMethodCase_ = authMethodCase_;
      result.authMethod_ = this.authMethod_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.WebhookConfig) {
        return mergeFrom((com.google.cloudbuild.v1.WebhookConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.WebhookConfig other) {
      if (other == com.google.cloudbuild.v1.WebhookConfig.getDefaultInstance()) return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getAuthMethodCase()) {
        case SECRET:
          {
            authMethodCase_ = 3;
            authMethod_ = other.authMethod_;
            onChanged();
            break;
          }
        case AUTHMETHOD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                authMethodCase_ = 3;
                authMethod_ = s;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authMethodCase_ = 0;
    private java.lang.Object authMethod_;

    public AuthMethodCase getAuthMethodCase() {
      return AuthMethodCase.forNumber(authMethodCase_);
    }

    public Builder clearAuthMethod() {
      authMethodCase_ = 0;
      authMethod_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the secret field is set.
     */
    @java.lang.Override
    public boolean hasSecret() {
      return authMethodCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The secret.
     */
    @java.lang.Override
    public java.lang.String getSecret() {
      java.lang.Object ref = "";
      if (authMethodCase_ == 3) {
        ref = authMethod_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (authMethodCase_ == 3) {
          authMethod_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for secret.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSecretBytes() {
      java.lang.Object ref = "";
      if (authMethodCase_ == 3) {
        ref = authMethod_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (authMethodCase_ == 3) {
          authMethod_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authMethodCase_ = 3;
      authMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecret() {
      if (authMethodCase_ == 3) {
        authMethodCase_ = 0;
        authMethod_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Resource name for the secret required as a URL parameter.
     * </pre>
     *
     * <code>
     * string secret = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authMethodCase_ = 3;
      authMethod_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Potential issues with the underlying Pub/Sub subscription configuration.
     * Only populated on get requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Potential issues with the underlying Pub/Sub subscription configuration.
     * Only populated on get requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Potential issues with the underlying Pub/Sub subscription configuration.
     * Only populated on get requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.WebhookConfig.State getState() {
      com.google.cloudbuild.v1.WebhookConfig.State result =
          com.google.cloudbuild.v1.WebhookConfig.State.forNumber(state_);
      return result == null ? com.google.cloudbuild.v1.WebhookConfig.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Potential issues with the underlying Pub/Sub subscription configuration.
     * Only populated on get requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloudbuild.v1.WebhookConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Potential issues with the underlying Pub/Sub subscription configuration.
     * Only populated on get requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.WebhookConfig.State state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.WebhookConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.WebhookConfig)
  private static final com.google.cloudbuild.v1.WebhookConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.WebhookConfig();
  }

  public static com.google.cloudbuild.v1.WebhookConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebhookConfig> PARSER =
      new com.google.protobuf.AbstractParser<WebhookConfig>() {
        @java.lang.Override
        public WebhookConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebhookConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebhookConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.WebhookConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
