/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * The configuration of a trigger that creates a build whenever an event from
 * Repo API is received.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.RepositoryEventConfig}
 */
public final class RepositoryEventConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.RepositoryEventConfig)
    RepositoryEventConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepositoryEventConfig.newBuilder() to construct.
  private RepositoryEventConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepositoryEventConfig() {
    repository_ = "";
    repositoryType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepositoryEventConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_RepositoryEventConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_RepositoryEventConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.RepositoryEventConfig.class,
            com.google.cloudbuild.v1.RepositoryEventConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * All possible SCM repo types from Repo API.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType}
   */
  public enum RepositoryType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * If unspecified, RepositoryType defaults to GITHUB.
     * </pre>
     *
     * <code>REPOSITORY_TYPE_UNSPECIFIED = 0;</code>
     */
    REPOSITORY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The SCM repo is GITHUB.
     * </pre>
     *
     * <code>GITHUB = 1;</code>
     */
    GITHUB(1),
    /**
     *
     *
     * <pre>
     * The SCM repo is GITHUB Enterprise.
     * </pre>
     *
     * <code>GITHUB_ENTERPRISE = 2;</code>
     */
    GITHUB_ENTERPRISE(2),
    /**
     *
     *
     * <pre>
     * The SCM repo is GITLAB Enterprise.
     * </pre>
     *
     * <code>GITLAB_ENTERPRISE = 3;</code>
     */
    GITLAB_ENTERPRISE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * If unspecified, RepositoryType defaults to GITHUB.
     * </pre>
     *
     * <code>REPOSITORY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int REPOSITORY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The SCM repo is GITHUB.
     * </pre>
     *
     * <code>GITHUB = 1;</code>
     */
    public static final int GITHUB_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The SCM repo is GITHUB Enterprise.
     * </pre>
     *
     * <code>GITHUB_ENTERPRISE = 2;</code>
     */
    public static final int GITHUB_ENTERPRISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The SCM repo is GITLAB Enterprise.
     * </pre>
     *
     * <code>GITLAB_ENTERPRISE = 3;</code>
     */
    public static final int GITLAB_ENTERPRISE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RepositoryType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RepositoryType forNumber(int value) {
      switch (value) {
        case 0:
          return REPOSITORY_TYPE_UNSPECIFIED;
        case 1:
          return GITHUB;
        case 2:
          return GITHUB_ENTERPRISE;
        case 3:
          return GITLAB_ENTERPRISE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RepositoryType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RepositoryType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RepositoryType>() {
          public RepositoryType findValueByNumber(int number) {
            return RepositoryType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.RepositoryEventConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final RepositoryType[] VALUES = values();

    public static RepositoryType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RepositoryType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType)
  }

  private int filterCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PULL_REQUEST(3),
    PUSH(4),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 3:
          return PULL_REQUEST;
        case 4:
          return PUSH;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int REPOSITORY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object repository_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Repo API resource.
   * </pre>
   *
   * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The repository.
   */
  @java.lang.Override
  public java.lang.String getRepository() {
    java.lang.Object ref = repository_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      repository_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Repo API resource.
   * </pre>
   *
   * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for repository.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRepositoryBytes() {
    java.lang.Object ref = repository_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      repository_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPOSITORY_TYPE_FIELD_NUMBER = 2;
  private int repositoryType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The type of the SCM vendor the repository points to.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for repositoryType.
   */
  @java.lang.Override
  public int getRepositoryTypeValue() {
    return repositoryType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The type of the SCM vendor the repository points to.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The repositoryType.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType getRepositoryType() {
    com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType result =
        com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.forNumber(repositoryType_);
    return result == null
        ? com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.UNRECOGNIZED
        : result;
  }

  public static final int PULL_REQUEST_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
   *
   * @return Whether the pullRequest field is set.
   */
  @java.lang.Override
  public boolean hasPullRequest() {
    return filterCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
   *
   * @return The pullRequest.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PullRequestFilter getPullRequest() {
    if (filterCase_ == 3) {
      return (com.google.cloudbuild.v1.PullRequestFilter) filter_;
    }
    return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Filter to match changes in pull requests.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PullRequestFilterOrBuilder getPullRequestOrBuilder() {
    if (filterCase_ == 3) {
      return (com.google.cloudbuild.v1.PullRequestFilter) filter_;
    }
    return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
  }

  public static final int PUSH_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
   *
   * @return Whether the push field is set.
   */
  @java.lang.Override
  public boolean hasPush() {
    return filterCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
   *
   * @return The push.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PushFilter getPush() {
    if (filterCase_ == 4) {
      return (com.google.cloudbuild.v1.PushFilter) filter_;
    }
    return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Filter to match changes in refs like branches, tags.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.PushFilterOrBuilder getPushOrBuilder() {
    if (filterCase_ == 4) {
      return (com.google.cloudbuild.v1.PushFilter) filter_;
    }
    return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, repository_);
    }
    if (repositoryType_
        != com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.REPOSITORY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, repositoryType_);
    }
    if (filterCase_ == 3) {
      output.writeMessage(3, (com.google.cloudbuild.v1.PullRequestFilter) filter_);
    }
    if (filterCase_ == 4) {
      output.writeMessage(4, (com.google.cloudbuild.v1.PushFilter) filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repository_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, repository_);
    }
    if (repositoryType_
        != com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.REPOSITORY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, repositoryType_);
    }
    if (filterCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloudbuild.v1.PullRequestFilter) filter_);
    }
    if (filterCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloudbuild.v1.PushFilter) filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.RepositoryEventConfig)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.RepositoryEventConfig other =
        (com.google.cloudbuild.v1.RepositoryEventConfig) obj;

    if (!getRepository().equals(other.getRepository())) return false;
    if (repositoryType_ != other.repositoryType_) return false;
    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 3:
        if (!getPullRequest().equals(other.getPullRequest())) return false;
        break;
      case 4:
        if (!getPush().equals(other.getPush())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
    hash = (53 * hash) + getRepository().hashCode();
    hash = (37 * hash) + REPOSITORY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + repositoryType_;
    switch (filterCase_) {
      case 3:
        hash = (37 * hash) + PULL_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getPullRequest().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PUSH_FIELD_NUMBER;
        hash = (53 * hash) + getPush().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.RepositoryEventConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of a trigger that creates a build whenever an event from
   * Repo API is received.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.RepositoryEventConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.RepositoryEventConfig)
      com.google.cloudbuild.v1.RepositoryEventConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepositoryEventConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepositoryEventConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.RepositoryEventConfig.class,
              com.google.cloudbuild.v1.RepositoryEventConfig.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.RepositoryEventConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      repository_ = "";
      repositoryType_ = 0;
      if (pullRequestBuilder_ != null) {
        pullRequestBuilder_.clear();
      }
      if (pushBuilder_ != null) {
        pushBuilder_.clear();
      }
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_RepositoryEventConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepositoryEventConfig getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepositoryEventConfig build() {
      com.google.cloudbuild.v1.RepositoryEventConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.RepositoryEventConfig buildPartial() {
      com.google.cloudbuild.v1.RepositoryEventConfig result =
          new com.google.cloudbuild.v1.RepositoryEventConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.RepositoryEventConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.repository_ = repository_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.repositoryType_ = repositoryType_;
      }
    }

    private void buildPartialOneofs(com.google.cloudbuild.v1.RepositoryEventConfig result) {
      result.filterCase_ = filterCase_;
      result.filter_ = this.filter_;
      if (filterCase_ == 3 && pullRequestBuilder_ != null) {
        result.filter_ = pullRequestBuilder_.build();
      }
      if (filterCase_ == 4 && pushBuilder_ != null) {
        result.filter_ = pushBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.RepositoryEventConfig) {
        return mergeFrom((com.google.cloudbuild.v1.RepositoryEventConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.RepositoryEventConfig other) {
      if (other == com.google.cloudbuild.v1.RepositoryEventConfig.getDefaultInstance()) return this;
      if (!other.getRepository().isEmpty()) {
        repository_ = other.repository_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.repositoryType_ != 0) {
        setRepositoryTypeValue(other.getRepositoryTypeValue());
      }
      switch (other.getFilterCase()) {
        case PULL_REQUEST:
          {
            mergePullRequest(other.getPullRequest());
            break;
          }
        case PUSH:
          {
            mergePush(other.getPush());
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                repository_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                repositoryType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getPullRequestFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPushFieldBuilder().getBuilder(), extensionRegistry);
                filterCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object repository_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Repo API resource.
     * </pre>
     *
     * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The repository.
     */
    public java.lang.String getRepository() {
      java.lang.Object ref = repository_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repository_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Repo API resource.
     * </pre>
     *
     * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for repository.
     */
    public com.google.protobuf.ByteString getRepositoryBytes() {
      java.lang.Object ref = repository_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repository_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Repo API resource.
     * </pre>
     *
     * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The repository to set.
     * @return This builder for chaining.
     */
    public Builder setRepository(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      repository_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Repo API resource.
     * </pre>
     *
     * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepository() {
      repository_ = getDefaultInstance().getRepository();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Repo API resource.
     * </pre>
     *
     * <code>string repository = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for repository to set.
     * @return This builder for chaining.
     */
    public Builder setRepositoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      repository_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int repositoryType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The type of the SCM vendor the repository points to.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for repositoryType.
     */
    @java.lang.Override
    public int getRepositoryTypeValue() {
      return repositoryType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the SCM vendor the repository points to.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for repositoryType to set.
     * @return This builder for chaining.
     */
    public Builder setRepositoryTypeValue(int value) {
      repositoryType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the SCM vendor the repository points to.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The repositoryType.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType getRepositoryType() {
      com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType result =
          com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.forNumber(repositoryType_);
      return result == null
          ? com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the SCM vendor the repository points to.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The repositoryType to set.
     * @return This builder for chaining.
     */
    public Builder setRepositoryType(
        com.google.cloudbuild.v1.RepositoryEventConfig.RepositoryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      repositoryType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The type of the SCM vendor the repository points to.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.RepositoryEventConfig.RepositoryType repository_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepositoryType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      repositoryType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PullRequestFilter,
            com.google.cloudbuild.v1.PullRequestFilter.Builder,
            com.google.cloudbuild.v1.PullRequestFilterOrBuilder>
        pullRequestBuilder_;
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     *
     * @return Whether the pullRequest field is set.
     */
    @java.lang.Override
    public boolean hasPullRequest() {
      return filterCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     *
     * @return The pullRequest.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PullRequestFilter getPullRequest() {
      if (pullRequestBuilder_ == null) {
        if (filterCase_ == 3) {
          return (com.google.cloudbuild.v1.PullRequestFilter) filter_;
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 3) {
          return pullRequestBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    public Builder setPullRequest(com.google.cloudbuild.v1.PullRequestFilter value) {
      if (pullRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        pullRequestBuilder_.setMessage(value);
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    public Builder setPullRequest(
        com.google.cloudbuild.v1.PullRequestFilter.Builder builderForValue) {
      if (pullRequestBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        pullRequestBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    public Builder mergePullRequest(com.google.cloudbuild.v1.PullRequestFilter value) {
      if (pullRequestBuilder_ == null) {
        if (filterCase_ == 3
            && filter_ != com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloudbuild.v1.PullRequestFilter.newBuilder(
                      (com.google.cloudbuild.v1.PullRequestFilter) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 3) {
          pullRequestBuilder_.mergeFrom(value);
        } else {
          pullRequestBuilder_.setMessage(value);
        }
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    public Builder clearPullRequest() {
      if (pullRequestBuilder_ == null) {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
        }
        pullRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    public com.google.cloudbuild.v1.PullRequestFilter.Builder getPullRequestBuilder() {
      return getPullRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PullRequestFilterOrBuilder getPullRequestOrBuilder() {
      if ((filterCase_ == 3) && (pullRequestBuilder_ != null)) {
        return pullRequestBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 3) {
          return (com.google.cloudbuild.v1.PullRequestFilter) filter_;
        }
        return com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in pull requests.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PullRequestFilter pull_request = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PullRequestFilter,
            com.google.cloudbuild.v1.PullRequestFilter.Builder,
            com.google.cloudbuild.v1.PullRequestFilterOrBuilder>
        getPullRequestFieldBuilder() {
      if (pullRequestBuilder_ == null) {
        if (!(filterCase_ == 3)) {
          filter_ = com.google.cloudbuild.v1.PullRequestFilter.getDefaultInstance();
        }
        pullRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PullRequestFilter,
                com.google.cloudbuild.v1.PullRequestFilter.Builder,
                com.google.cloudbuild.v1.PullRequestFilterOrBuilder>(
                (com.google.cloudbuild.v1.PullRequestFilter) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 3;
      onChanged();
      return pullRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PushFilter,
            com.google.cloudbuild.v1.PushFilter.Builder,
            com.google.cloudbuild.v1.PushFilterOrBuilder>
        pushBuilder_;
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     *
     * @return Whether the push field is set.
     */
    @java.lang.Override
    public boolean hasPush() {
      return filterCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     *
     * @return The push.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PushFilter getPush() {
      if (pushBuilder_ == null) {
        if (filterCase_ == 4) {
          return (com.google.cloudbuild.v1.PushFilter) filter_;
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      } else {
        if (filterCase_ == 4) {
          return pushBuilder_.getMessage();
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    public Builder setPush(com.google.cloudbuild.v1.PushFilter value) {
      if (pushBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        pushBuilder_.setMessage(value);
      }
      filterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    public Builder setPush(com.google.cloudbuild.v1.PushFilter.Builder builderForValue) {
      if (pushBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        pushBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    public Builder mergePush(com.google.cloudbuild.v1.PushFilter value) {
      if (pushBuilder_ == null) {
        if (filterCase_ == 4
            && filter_ != com.google.cloudbuild.v1.PushFilter.getDefaultInstance()) {
          filter_ =
              com.google.cloudbuild.v1.PushFilter.newBuilder(
                      (com.google.cloudbuild.v1.PushFilter) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 4) {
          pushBuilder_.mergeFrom(value);
        } else {
          pushBuilder_.setMessage(value);
        }
      }
      filterCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    public Builder clearPush() {
      if (pushBuilder_ == null) {
        if (filterCase_ == 4) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 4) {
          filterCase_ = 0;
          filter_ = null;
        }
        pushBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    public com.google.cloudbuild.v1.PushFilter.Builder getPushBuilder() {
      return getPushFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.PushFilterOrBuilder getPushOrBuilder() {
      if ((filterCase_ == 4) && (pushBuilder_ != null)) {
        return pushBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 4) {
          return (com.google.cloudbuild.v1.PushFilter) filter_;
        }
        return com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Filter to match changes in refs like branches, tags.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.PushFilter push = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.PushFilter,
            com.google.cloudbuild.v1.PushFilter.Builder,
            com.google.cloudbuild.v1.PushFilterOrBuilder>
        getPushFieldBuilder() {
      if (pushBuilder_ == null) {
        if (!(filterCase_ == 4)) {
          filter_ = com.google.cloudbuild.v1.PushFilter.getDefaultInstance();
        }
        pushBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.PushFilter,
                com.google.cloudbuild.v1.PushFilter.Builder,
                com.google.cloudbuild.v1.PushFilterOrBuilder>(
                (com.google.cloudbuild.v1.PushFilter) filter_, getParentForChildren(), isClean());
        filter_ = null;
      }
      filterCase_ = 4;
      onChanged();
      return pushBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.RepositoryEventConfig)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.RepositoryEventConfig)
  private static final com.google.cloudbuild.v1.RepositoryEventConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.RepositoryEventConfig();
  }

  public static com.google.cloudbuild.v1.RepositoryEventConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepositoryEventConfig> PARSER =
      new com.google.protobuf.AbstractParser<RepositoryEventConfig>() {
        @java.lang.Override
        public RepositoryEventConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepositoryEventConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepositoryEventConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.RepositoryEventConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
