/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * Provenance of the source. Ways to find the original source, or verify that
 * some source was used for this build.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.SourceProvenance}
 */
public final class SourceProvenance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.SourceProvenance)
    SourceProvenanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SourceProvenance.newBuilder() to construct.
  private SourceProvenance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceProvenance() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceProvenance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetFileHashes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.SourceProvenance.class,
            com.google.cloudbuild.v1.SourceProvenance.Builder.class);
  }

  public static final int RESOLVED_STORAGE_SOURCE_FIELD_NUMBER = 3;
  private com.google.cloudbuild.v1.StorageSource resolvedStorageSource_;
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source`, if exists, with any
   * generations resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
   *
   * @return Whether the resolvedStorageSource field is set.
   */
  @java.lang.Override
  public boolean hasResolvedStorageSource() {
    return resolvedStorageSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source`, if exists, with any
   * generations resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
   *
   * @return The resolvedStorageSource.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.StorageSource getResolvedStorageSource() {
    return resolvedStorageSource_ == null
        ? com.google.cloudbuild.v1.StorageSource.getDefaultInstance()
        : resolvedStorageSource_;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source`, if exists, with any
   * generations resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.StorageSourceOrBuilder getResolvedStorageSourceOrBuilder() {
    return resolvedStorageSource_ == null
        ? com.google.cloudbuild.v1.StorageSource.getDefaultInstance()
        : resolvedStorageSource_;
  }

  public static final int RESOLVED_REPO_SOURCE_FIELD_NUMBER = 6;
  private com.google.cloudbuild.v1.RepoSource resolvedRepoSource_;
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.repo_source`, if exists, with any
   * revisions resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
   *
   * @return Whether the resolvedRepoSource field is set.
   */
  @java.lang.Override
  public boolean hasResolvedRepoSource() {
    return resolvedRepoSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.repo_source`, if exists, with any
   * revisions resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
   *
   * @return The resolvedRepoSource.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSource getResolvedRepoSource() {
    return resolvedRepoSource_ == null
        ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
        : resolvedRepoSource_;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.repo_source`, if exists, with any
   * revisions resolved.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.RepoSourceOrBuilder getResolvedRepoSourceOrBuilder() {
    return resolvedRepoSource_ == null
        ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
        : resolvedRepoSource_;
  }

  public static final int RESOLVED_STORAGE_SOURCE_MANIFEST_FIELD_NUMBER = 9;
  private com.google.cloudbuild.v1.StorageSourceManifest resolvedStorageSourceManifest_;
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source_manifest`, if exists, with any
   * revisions resolved.
   * This feature is in Preview.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
   * </code>
   *
   * @return Whether the resolvedStorageSourceManifest field is set.
   */
  @java.lang.Override
  public boolean hasResolvedStorageSourceManifest() {
    return resolvedStorageSourceManifest_ != null;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source_manifest`, if exists, with any
   * revisions resolved.
   * This feature is in Preview.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
   * </code>
   *
   * @return The resolvedStorageSourceManifest.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.StorageSourceManifest getResolvedStorageSourceManifest() {
    return resolvedStorageSourceManifest_ == null
        ? com.google.cloudbuild.v1.StorageSourceManifest.getDefaultInstance()
        : resolvedStorageSourceManifest_;
  }
  /**
   *
   *
   * <pre>
   * A copy of the build's `source.storage_source_manifest`, if exists, with any
   * revisions resolved.
   * This feature is in Preview.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.StorageSourceManifestOrBuilder
      getResolvedStorageSourceManifestOrBuilder() {
    return resolvedStorageSourceManifest_ == null
        ? com.google.cloudbuild.v1.StorageSourceManifest.getDefaultInstance()
        : resolvedStorageSourceManifest_;
  }

  public static final int FILE_HASHES_FIELD_NUMBER = 4;

  private static final class FileHashesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.FileHashes>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloudbuild.v1.FileHashes>newDefaultInstance(
                    com.google.cloudbuild.v1.Cloudbuild
                        .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_FileHashesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloudbuild.v1.FileHashes.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.FileHashes>
      fileHashes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.FileHashes>
      internalGetFileHashes() {
    if (fileHashes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FileHashesDefaultEntryHolder.defaultEntry);
    }
    return fileHashes_;
  }

  public int getFileHashesCount() {
    return internalGetFileHashes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Hash(es) of the build source, which can be used to verify that
   * the original source integrity was maintained in the build. Note that
   * `FileHashes` will only be populated if `BuildOptions` has requested a
   * `SourceProvenanceHash`.
   *
   * The keys to this map are file paths used as build source and the values
   * contain the hash values for those files.
   *
   * If the build source came in a single package such as a gzipped tarfile
   * (`.tar.gz`), the `FileHash` will be for the single path to that file.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsFileHashes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFileHashes().getMap().containsKey(key);
  }
  /** Use {@link #getFileHashesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> getFileHashes() {
    return getFileHashesMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Hash(es) of the build source, which can be used to verify that
   * the original source integrity was maintained in the build. Note that
   * `FileHashes` will only be populated if `BuildOptions` has requested a
   * `SourceProvenanceHash`.
   *
   * The keys to this map are file paths used as build source and the values
   * contain the hash values for those files.
   *
   * If the build source came in a single package such as a gzipped tarfile
   * (`.tar.gz`), the `FileHash` will be for the single path to that file.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> getFileHashesMap() {
    return internalGetFileHashes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Hash(es) of the build source, which can be used to verify that
   * the original source integrity was maintained in the build. Note that
   * `FileHashes` will only be populated if `BuildOptions` has requested a
   * `SourceProvenanceHash`.
   *
   * The keys to this map are file paths used as build source and the values
   * contain the hash values for those files.
   *
   * If the build source came in a single package such as a gzipped tarfile
   * (`.tar.gz`), the `FileHash` will be for the single path to that file.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloudbuild.v1.FileHashes getFileHashesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloudbuild.v1.FileHashes defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> map =
        internalGetFileHashes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Hash(es) of the build source, which can be used to verify that
   * the original source integrity was maintained in the build. Note that
   * `FileHashes` will only be populated if `BuildOptions` has requested a
   * `SourceProvenanceHash`.
   *
   * The keys to this map are file paths used as build source and the values
   * contain the hash values for those files.
   *
   * If the build source came in a single package such as a gzipped tarfile
   * (`.tar.gz`), the `FileHash` will be for the single path to that file.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.FileHashes getFileHashesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> map =
        internalGetFileHashes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resolvedStorageSource_ != null) {
      output.writeMessage(3, getResolvedStorageSource());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFileHashes(), FileHashesDefaultEntryHolder.defaultEntry, 4);
    if (resolvedRepoSource_ != null) {
      output.writeMessage(6, getResolvedRepoSource());
    }
    if (resolvedStorageSourceManifest_ != null) {
      output.writeMessage(9, getResolvedStorageSourceManifest());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resolvedStorageSource_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResolvedStorageSource());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloudbuild.v1.FileHashes> entry :
        internalGetFileHashes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.FileHashes>
          fileHashes__ =
              FileHashesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, fileHashes__);
    }
    if (resolvedRepoSource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getResolvedRepoSource());
    }
    if (resolvedStorageSourceManifest_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getResolvedStorageSourceManifest());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.SourceProvenance)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.SourceProvenance other =
        (com.google.cloudbuild.v1.SourceProvenance) obj;

    if (hasResolvedStorageSource() != other.hasResolvedStorageSource()) return false;
    if (hasResolvedStorageSource()) {
      if (!getResolvedStorageSource().equals(other.getResolvedStorageSource())) return false;
    }
    if (hasResolvedRepoSource() != other.hasResolvedRepoSource()) return false;
    if (hasResolvedRepoSource()) {
      if (!getResolvedRepoSource().equals(other.getResolvedRepoSource())) return false;
    }
    if (hasResolvedStorageSourceManifest() != other.hasResolvedStorageSourceManifest())
      return false;
    if (hasResolvedStorageSourceManifest()) {
      if (!getResolvedStorageSourceManifest().equals(other.getResolvedStorageSourceManifest()))
        return false;
    }
    if (!internalGetFileHashes().equals(other.internalGetFileHashes())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasResolvedStorageSource()) {
      hash = (37 * hash) + RESOLVED_STORAGE_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResolvedStorageSource().hashCode();
    }
    if (hasResolvedRepoSource()) {
      hash = (37 * hash) + RESOLVED_REPO_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResolvedRepoSource().hashCode();
    }
    if (hasResolvedStorageSourceManifest()) {
      hash = (37 * hash) + RESOLVED_STORAGE_SOURCE_MANIFEST_FIELD_NUMBER;
      hash = (53 * hash) + getResolvedStorageSourceManifest().hashCode();
    }
    if (!internalGetFileHashes().getMap().isEmpty()) {
      hash = (37 * hash) + FILE_HASHES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFileHashes().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.SourceProvenance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.SourceProvenance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provenance of the source. Ways to find the original source, or verify that
   * some source was used for this build.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.SourceProvenance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.SourceProvenance)
      com.google.cloudbuild.v1.SourceProvenanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetFileHashes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableFileHashes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.SourceProvenance.class,
              com.google.cloudbuild.v1.SourceProvenance.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.SourceProvenance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resolvedStorageSource_ = null;
      if (resolvedStorageSourceBuilder_ != null) {
        resolvedStorageSourceBuilder_.dispose();
        resolvedStorageSourceBuilder_ = null;
      }
      resolvedRepoSource_ = null;
      if (resolvedRepoSourceBuilder_ != null) {
        resolvedRepoSourceBuilder_.dispose();
        resolvedRepoSourceBuilder_ = null;
      }
      resolvedStorageSourceManifest_ = null;
      if (resolvedStorageSourceManifestBuilder_ != null) {
        resolvedStorageSourceManifestBuilder_.dispose();
        resolvedStorageSourceManifestBuilder_ = null;
      }
      internalGetMutableFileHashes().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_SourceProvenance_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.SourceProvenance getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.SourceProvenance build() {
      com.google.cloudbuild.v1.SourceProvenance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.SourceProvenance buildPartial() {
      com.google.cloudbuild.v1.SourceProvenance result =
          new com.google.cloudbuild.v1.SourceProvenance(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.SourceProvenance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resolvedStorageSource_ =
            resolvedStorageSourceBuilder_ == null
                ? resolvedStorageSource_
                : resolvedStorageSourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resolvedRepoSource_ =
            resolvedRepoSourceBuilder_ == null
                ? resolvedRepoSource_
                : resolvedRepoSourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resolvedStorageSourceManifest_ =
            resolvedStorageSourceManifestBuilder_ == null
                ? resolvedStorageSourceManifest_
                : resolvedStorageSourceManifestBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fileHashes_ = internalGetFileHashes();
        result.fileHashes_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.SourceProvenance) {
        return mergeFrom((com.google.cloudbuild.v1.SourceProvenance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.SourceProvenance other) {
      if (other == com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()) return this;
      if (other.hasResolvedStorageSource()) {
        mergeResolvedStorageSource(other.getResolvedStorageSource());
      }
      if (other.hasResolvedRepoSource()) {
        mergeResolvedRepoSource(other.getResolvedRepoSource());
      }
      if (other.hasResolvedStorageSourceManifest()) {
        mergeResolvedStorageSourceManifest(other.getResolvedStorageSourceManifest());
      }
      internalGetMutableFileHashes().mergeFrom(other.internalGetFileHashes());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(
                    getResolvedStorageSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.FileHashes>
                    fileHashes__ =
                        input.readMessage(
                            FileHashesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableFileHashes()
                    .getMutableMap()
                    .put(fileHashes__.getKey(), fileHashes__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getResolvedRepoSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 74:
              {
                input.readMessage(
                    getResolvedStorageSourceManifestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloudbuild.v1.StorageSource resolvedStorageSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.StorageSource,
            com.google.cloudbuild.v1.StorageSource.Builder,
            com.google.cloudbuild.v1.StorageSourceOrBuilder>
        resolvedStorageSourceBuilder_;
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     *
     * @return Whether the resolvedStorageSource field is set.
     */
    public boolean hasResolvedStorageSource() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     *
     * @return The resolvedStorageSource.
     */
    public com.google.cloudbuild.v1.StorageSource getResolvedStorageSource() {
      if (resolvedStorageSourceBuilder_ == null) {
        return resolvedStorageSource_ == null
            ? com.google.cloudbuild.v1.StorageSource.getDefaultInstance()
            : resolvedStorageSource_;
      } else {
        return resolvedStorageSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public Builder setResolvedStorageSource(com.google.cloudbuild.v1.StorageSource value) {
      if (resolvedStorageSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resolvedStorageSource_ = value;
      } else {
        resolvedStorageSourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public Builder setResolvedStorageSource(
        com.google.cloudbuild.v1.StorageSource.Builder builderForValue) {
      if (resolvedStorageSourceBuilder_ == null) {
        resolvedStorageSource_ = builderForValue.build();
      } else {
        resolvedStorageSourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public Builder mergeResolvedStorageSource(com.google.cloudbuild.v1.StorageSource value) {
      if (resolvedStorageSourceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && resolvedStorageSource_ != null
            && resolvedStorageSource_
                != com.google.cloudbuild.v1.StorageSource.getDefaultInstance()) {
          getResolvedStorageSourceBuilder().mergeFrom(value);
        } else {
          resolvedStorageSource_ = value;
        }
      } else {
        resolvedStorageSourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public Builder clearResolvedStorageSource() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resolvedStorageSource_ = null;
      if (resolvedStorageSourceBuilder_ != null) {
        resolvedStorageSourceBuilder_.dispose();
        resolvedStorageSourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public com.google.cloudbuild.v1.StorageSource.Builder getResolvedStorageSourceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getResolvedStorageSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    public com.google.cloudbuild.v1.StorageSourceOrBuilder getResolvedStorageSourceOrBuilder() {
      if (resolvedStorageSourceBuilder_ != null) {
        return resolvedStorageSourceBuilder_.getMessageOrBuilder();
      } else {
        return resolvedStorageSource_ == null
            ? com.google.cloudbuild.v1.StorageSource.getDefaultInstance()
            : resolvedStorageSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source`, if exists, with any
     * generations resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.StorageSource resolved_storage_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.StorageSource,
            com.google.cloudbuild.v1.StorageSource.Builder,
            com.google.cloudbuild.v1.StorageSourceOrBuilder>
        getResolvedStorageSourceFieldBuilder() {
      if (resolvedStorageSourceBuilder_ == null) {
        resolvedStorageSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.StorageSource,
                com.google.cloudbuild.v1.StorageSource.Builder,
                com.google.cloudbuild.v1.StorageSourceOrBuilder>(
                getResolvedStorageSource(), getParentForChildren(), isClean());
        resolvedStorageSource_ = null;
      }
      return resolvedStorageSourceBuilder_;
    }

    private com.google.cloudbuild.v1.RepoSource resolvedRepoSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        resolvedRepoSourceBuilder_;
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     *
     * @return Whether the resolvedRepoSource field is set.
     */
    public boolean hasResolvedRepoSource() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     *
     * @return The resolvedRepoSource.
     */
    public com.google.cloudbuild.v1.RepoSource getResolvedRepoSource() {
      if (resolvedRepoSourceBuilder_ == null) {
        return resolvedRepoSource_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : resolvedRepoSource_;
      } else {
        return resolvedRepoSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public Builder setResolvedRepoSource(com.google.cloudbuild.v1.RepoSource value) {
      if (resolvedRepoSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resolvedRepoSource_ = value;
      } else {
        resolvedRepoSourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public Builder setResolvedRepoSource(
        com.google.cloudbuild.v1.RepoSource.Builder builderForValue) {
      if (resolvedRepoSourceBuilder_ == null) {
        resolvedRepoSource_ = builderForValue.build();
      } else {
        resolvedRepoSourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public Builder mergeResolvedRepoSource(com.google.cloudbuild.v1.RepoSource value) {
      if (resolvedRepoSourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && resolvedRepoSource_ != null
            && resolvedRepoSource_ != com.google.cloudbuild.v1.RepoSource.getDefaultInstance()) {
          getResolvedRepoSourceBuilder().mergeFrom(value);
        } else {
          resolvedRepoSource_ = value;
        }
      } else {
        resolvedRepoSourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public Builder clearResolvedRepoSource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      resolvedRepoSource_ = null;
      if (resolvedRepoSourceBuilder_ != null) {
        resolvedRepoSourceBuilder_.dispose();
        resolvedRepoSourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public com.google.cloudbuild.v1.RepoSource.Builder getResolvedRepoSourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResolvedRepoSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    public com.google.cloudbuild.v1.RepoSourceOrBuilder getResolvedRepoSourceOrBuilder() {
      if (resolvedRepoSourceBuilder_ != null) {
        return resolvedRepoSourceBuilder_.getMessageOrBuilder();
      } else {
        return resolvedRepoSource_ == null
            ? com.google.cloudbuild.v1.RepoSource.getDefaultInstance()
            : resolvedRepoSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.repo_source`, if exists, with any
     * revisions resolved.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.RepoSource resolved_repo_source = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.RepoSource,
            com.google.cloudbuild.v1.RepoSource.Builder,
            com.google.cloudbuild.v1.RepoSourceOrBuilder>
        getResolvedRepoSourceFieldBuilder() {
      if (resolvedRepoSourceBuilder_ == null) {
        resolvedRepoSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.RepoSource,
                com.google.cloudbuild.v1.RepoSource.Builder,
                com.google.cloudbuild.v1.RepoSourceOrBuilder>(
                getResolvedRepoSource(), getParentForChildren(), isClean());
        resolvedRepoSource_ = null;
      }
      return resolvedRepoSourceBuilder_;
    }

    private com.google.cloudbuild.v1.StorageSourceManifest resolvedStorageSourceManifest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.StorageSourceManifest,
            com.google.cloudbuild.v1.StorageSourceManifest.Builder,
            com.google.cloudbuild.v1.StorageSourceManifestOrBuilder>
        resolvedStorageSourceManifestBuilder_;
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     *
     * @return Whether the resolvedStorageSourceManifest field is set.
     */
    public boolean hasResolvedStorageSourceManifest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     *
     * @return The resolvedStorageSourceManifest.
     */
    public com.google.cloudbuild.v1.StorageSourceManifest getResolvedStorageSourceManifest() {
      if (resolvedStorageSourceManifestBuilder_ == null) {
        return resolvedStorageSourceManifest_ == null
            ? com.google.cloudbuild.v1.StorageSourceManifest.getDefaultInstance()
            : resolvedStorageSourceManifest_;
      } else {
        return resolvedStorageSourceManifestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public Builder setResolvedStorageSourceManifest(
        com.google.cloudbuild.v1.StorageSourceManifest value) {
      if (resolvedStorageSourceManifestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resolvedStorageSourceManifest_ = value;
      } else {
        resolvedStorageSourceManifestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public Builder setResolvedStorageSourceManifest(
        com.google.cloudbuild.v1.StorageSourceManifest.Builder builderForValue) {
      if (resolvedStorageSourceManifestBuilder_ == null) {
        resolvedStorageSourceManifest_ = builderForValue.build();
      } else {
        resolvedStorageSourceManifestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public Builder mergeResolvedStorageSourceManifest(
        com.google.cloudbuild.v1.StorageSourceManifest value) {
      if (resolvedStorageSourceManifestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resolvedStorageSourceManifest_ != null
            && resolvedStorageSourceManifest_
                != com.google.cloudbuild.v1.StorageSourceManifest.getDefaultInstance()) {
          getResolvedStorageSourceManifestBuilder().mergeFrom(value);
        } else {
          resolvedStorageSourceManifest_ = value;
        }
      } else {
        resolvedStorageSourceManifestBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public Builder clearResolvedStorageSourceManifest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resolvedStorageSourceManifest_ = null;
      if (resolvedStorageSourceManifestBuilder_ != null) {
        resolvedStorageSourceManifestBuilder_.dispose();
        resolvedStorageSourceManifestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.StorageSourceManifest.Builder
        getResolvedStorageSourceManifestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResolvedStorageSourceManifestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    public com.google.cloudbuild.v1.StorageSourceManifestOrBuilder
        getResolvedStorageSourceManifestOrBuilder() {
      if (resolvedStorageSourceManifestBuilder_ != null) {
        return resolvedStorageSourceManifestBuilder_.getMessageOrBuilder();
      } else {
        return resolvedStorageSourceManifest_ == null
            ? com.google.cloudbuild.v1.StorageSourceManifest.getDefaultInstance()
            : resolvedStorageSourceManifest_;
      }
    }
    /**
     *
     *
     * <pre>
     * A copy of the build's `source.storage_source_manifest`, if exists, with any
     * revisions resolved.
     * This feature is in Preview.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.StorageSourceManifest resolved_storage_source_manifest = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.StorageSourceManifest,
            com.google.cloudbuild.v1.StorageSourceManifest.Builder,
            com.google.cloudbuild.v1.StorageSourceManifestOrBuilder>
        getResolvedStorageSourceManifestFieldBuilder() {
      if (resolvedStorageSourceManifestBuilder_ == null) {
        resolvedStorageSourceManifestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.StorageSourceManifest,
                com.google.cloudbuild.v1.StorageSourceManifest.Builder,
                com.google.cloudbuild.v1.StorageSourceManifestOrBuilder>(
                getResolvedStorageSourceManifest(), getParentForChildren(), isClean());
        resolvedStorageSourceManifest_ = null;
      }
      return resolvedStorageSourceManifestBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.FileHashes>
        fileHashes_;

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.FileHashes>
        internalGetFileHashes() {
      if (fileHashes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FileHashesDefaultEntryHolder.defaultEntry);
      }
      return fileHashes_;
    }

    private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.FileHashes>
        internalGetMutableFileHashes() {
      if (fileHashes_ == null) {
        fileHashes_ =
            com.google.protobuf.MapField.newMapField(FileHashesDefaultEntryHolder.defaultEntry);
      }
      if (!fileHashes_.isMutable()) {
        fileHashes_ = fileHashes_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return fileHashes_;
    }

    public int getFileHashesCount() {
      return internalGetFileHashes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsFileHashes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFileHashes().getMap().containsKey(key);
    }
    /** Use {@link #getFileHashesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> getFileHashes() {
      return getFileHashesMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> getFileHashesMap() {
      return internalGetFileHashes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloudbuild.v1.FileHashes getFileHashesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloudbuild.v1.FileHashes defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> map =
          internalGetFileHashes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.FileHashes getFileHashesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> map =
          internalGetFileHashes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFileHashes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableFileHashes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeFileHashes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFileHashes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes>
        getMutableFileHashes() {
      bitField0_ |= 0x00000008;
      return internalGetMutableFileHashes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putFileHashes(java.lang.String key, com.google.cloudbuild.v1.FileHashes value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableFileHashes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Hash(es) of the build source, which can be used to verify that
     * the original source integrity was maintained in the build. Note that
     * `FileHashes` will only be populated if `BuildOptions` has requested a
     * `SourceProvenanceHash`.
     *
     * The keys to this map are file paths used as build source and the values
     * contain the hash values for those files.
     *
     * If the build source came in a single package such as a gzipped tarfile
     * (`.tar.gz`), the `FileHash` will be for the single path to that file.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.FileHashes&gt; file_hashes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllFileHashes(
        java.util.Map<java.lang.String, com.google.cloudbuild.v1.FileHashes> values) {
      internalGetMutableFileHashes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.SourceProvenance)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.SourceProvenance)
  private static final com.google.cloudbuild.v1.SourceProvenance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.SourceProvenance();
  }

  public static com.google.cloudbuild.v1.SourceProvenance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceProvenance> PARSER =
      new com.google.protobuf.AbstractParser<SourceProvenance>() {
        @java.lang.Override
        public SourceProvenance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceProvenance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceProvenance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.SourceProvenance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
