/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * A build resource in the Cloud Build API.
 *
 * At a high level, a `Build` describes where to find source code, how to build
 * it (for example, the builder image to run on the source), and where to store
 * the built artifacts.
 *
 * Fields can include the following variables, which will be expanded when the
 * build is created:
 *
 * - $PROJECT_ID: the project ID of the build.
 * - $PROJECT_NUMBER: the project number of the build.
 * - $LOCATION: the location/region of the build.
 * - $BUILD_ID: the autogenerated ID of the build.
 * - $REPO_NAME: the source repository name specified by RepoSource.
 * - $BRANCH_NAME: the branch name specified by RepoSource.
 * - $TAG_NAME: the tag name specified by RepoSource.
 * - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
 *   resolved from the specified branch or tag.
 * - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.Build}
 */
public final class Build extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Build)
    BuildOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Build.newBuilder() to construct.
  private Build(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Build() {
    name_ = "";
    id_ = "";
    projectId_ = "";
    status_ = 0;
    statusDetail_ = "";
    steps_ = java.util.Collections.emptyList();
    images_ = com.google.protobuf.LazyStringArrayList.emptyList();
    logsBucket_ = "";
    buildTriggerId_ = "";
    logUrl_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    secrets_ = java.util.Collections.emptyList();
    serviceAccount_ = "";
    warnings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Build();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 29:
        return internalGetSubstitutions();
      case 33:
        return internalGetTiming();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_Build_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.Build.class, com.google.cloudbuild.v1.Build.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible status of a build or build step.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.Build.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Status of the build is unknown.
     * </pre>
     *
     * <code>STATUS_UNKNOWN = 0;</code>
     */
    STATUS_UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Build has been created and is pending execution and queuing. It has not
     * been queued.
     * </pre>
     *
     * <code>PENDING = 10;</code>
     */
    PENDING(10),
    /**
     *
     *
     * <pre>
     * Build or step is queued; work has not yet begun.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    QUEUED(1),
    /**
     *
     *
     * <pre>
     * Build or step is being executed.
     * </pre>
     *
     * <code>WORKING = 2;</code>
     */
    WORKING(2),
    /**
     *
     *
     * <pre>
     * Build or step finished successfully.
     * </pre>
     *
     * <code>SUCCESS = 3;</code>
     */
    SUCCESS(3),
    /**
     *
     *
     * <pre>
     * Build or step failed to complete successfully.
     * </pre>
     *
     * <code>FAILURE = 4;</code>
     */
    FAILURE(4),
    /**
     *
     *
     * <pre>
     * Build or step failed due to an internal cause.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 5;</code>
     */
    INTERNAL_ERROR(5),
    /**
     *
     *
     * <pre>
     * Build or step took longer than was allowed.
     * </pre>
     *
     * <code>TIMEOUT = 6;</code>
     */
    TIMEOUT(6),
    /**
     *
     *
     * <pre>
     * Build or step was canceled by a user.
     * </pre>
     *
     * <code>CANCELLED = 7;</code>
     */
    CANCELLED(7),
    /**
     *
     *
     * <pre>
     * Build was enqueued for longer than the value of `queue_ttl`.
     * </pre>
     *
     * <code>EXPIRED = 9;</code>
     */
    EXPIRED(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Status of the build is unknown.
     * </pre>
     *
     * <code>STATUS_UNKNOWN = 0;</code>
     */
    public static final int STATUS_UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Build has been created and is pending execution and queuing. It has not
     * been queued.
     * </pre>
     *
     * <code>PENDING = 10;</code>
     */
    public static final int PENDING_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Build or step is queued; work has not yet begun.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    public static final int QUEUED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Build or step is being executed.
     * </pre>
     *
     * <code>WORKING = 2;</code>
     */
    public static final int WORKING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Build or step finished successfully.
     * </pre>
     *
     * <code>SUCCESS = 3;</code>
     */
    public static final int SUCCESS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Build or step failed to complete successfully.
     * </pre>
     *
     * <code>FAILURE = 4;</code>
     */
    public static final int FAILURE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Build or step failed due to an internal cause.
     * </pre>
     *
     * <code>INTERNAL_ERROR = 5;</code>
     */
    public static final int INTERNAL_ERROR_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Build or step took longer than was allowed.
     * </pre>
     *
     * <code>TIMEOUT = 6;</code>
     */
    public static final int TIMEOUT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Build or step was canceled by a user.
     * </pre>
     *
     * <code>CANCELLED = 7;</code>
     */
    public static final int CANCELLED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Build was enqueued for longer than the value of `queue_ttl`.
     * </pre>
     *
     * <code>EXPIRED = 9;</code>
     */
    public static final int EXPIRED_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return STATUS_UNKNOWN;
        case 10:
          return PENDING;
        case 1:
          return QUEUED;
        case 2:
          return WORKING;
        case 3:
          return SUCCESS;
        case 4:
          return FAILURE;
        case 5:
          return INTERNAL_ERROR;
        case 6:
          return TIMEOUT;
        case 7:
          return CANCELLED;
        case 9:
          return EXPIRED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.Build.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.Build.Status)
  }

  public interface WarningOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Build.Warning)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Explanation of the warning generated.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    java.lang.String getText();
    /**
     *
     *
     * <pre>
     * Explanation of the warning generated.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    /**
     *
     *
     * <pre>
     * The priority for this warning.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    int getPriorityValue();
    /**
     *
     *
     * <pre>
     * The priority for this warning.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
     *
     * @return The priority.
     */
    com.google.cloudbuild.v1.Build.Warning.Priority getPriority();
  }
  /**
   *
   *
   * <pre>
   * A non-fatal problem encountered during the execution of the build.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Build.Warning}
   */
  public static final class Warning extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Build.Warning)
      WarningOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Warning.newBuilder() to construct.
    private Warning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Warning() {
      text_ = "";
      priority_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Warning();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_Warning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_Warning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Build.Warning.class,
              com.google.cloudbuild.v1.Build.Warning.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The relative importance of this warning.
     * </pre>
     *
     * Protobuf enum {@code google.devtools.cloudbuild.v1.Build.Warning.Priority}
     */
    public enum Priority implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>PRIORITY_UNSPECIFIED = 0;</code>
       */
      PRIORITY_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * e.g. deprecation warnings and alternative feature highlights.
       * </pre>
       *
       * <code>INFO = 1;</code>
       */
      INFO(1),
      /**
       *
       *
       * <pre>
       * e.g. automated detection of possible issues with the build.
       * </pre>
       *
       * <code>WARNING = 2;</code>
       */
      WARNING(2),
      /**
       *
       *
       * <pre>
       * e.g. alerts that a feature used in the build is pending removal
       * </pre>
       *
       * <code>ALERT = 3;</code>
       */
      ALERT(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Should not be used.
       * </pre>
       *
       * <code>PRIORITY_UNSPECIFIED = 0;</code>
       */
      public static final int PRIORITY_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * e.g. deprecation warnings and alternative feature highlights.
       * </pre>
       *
       * <code>INFO = 1;</code>
       */
      public static final int INFO_VALUE = 1;
      /**
       *
       *
       * <pre>
       * e.g. automated detection of possible issues with the build.
       * </pre>
       *
       * <code>WARNING = 2;</code>
       */
      public static final int WARNING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * e.g. alerts that a feature used in the build is pending removal
       * </pre>
       *
       * <code>ALERT = 3;</code>
       */
      public static final int ALERT_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Priority valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Priority forNumber(int value) {
        switch (value) {
          case 0:
            return PRIORITY_UNSPECIFIED;
          case 1:
            return INFO;
          case 2:
            return WARNING;
          case 3:
            return ALERT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Priority> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Priority> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Priority>() {
            public Priority findValueByNumber(int number) {
              return Priority.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloudbuild.v1.Build.Warning.getDescriptor().getEnumTypes().get(0);
      }

      private static final Priority[] VALUES = values();

      public static Priority valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Priority(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.Build.Warning.Priority)
    }

    public static final int TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * Explanation of the warning generated.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Explanation of the warning generated.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRIORITY_FIELD_NUMBER = 2;
    private int priority_ = 0;
    /**
     *
     *
     * <pre>
     * The priority for this warning.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    public int getPriorityValue() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * The priority for this warning.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Warning.Priority getPriority() {
      com.google.cloudbuild.v1.Build.Warning.Priority result =
          com.google.cloudbuild.v1.Build.Warning.Priority.forNumber(priority_);
      return result == null ? com.google.cloudbuild.v1.Build.Warning.Priority.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
      }
      if (priority_
          != com.google.cloudbuild.v1.Build.Warning.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, priority_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
      }
      if (priority_
          != com.google.cloudbuild.v1.Build.Warning.Priority.PRIORITY_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, priority_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Build.Warning)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Build.Warning other = (com.google.cloudbuild.v1.Build.Warning) obj;

      if (!getText().equals(other.getText())) return false;
      if (priority_ != other.priority_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getText().hashCode();
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + priority_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.Warning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Build.Warning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A non-fatal problem encountered during the execution of the build.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Build.Warning}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Build.Warning)
        com.google.cloudbuild.v1.Build.WarningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_Warning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_Warning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Build.Warning.class,
                com.google.cloudbuild.v1.Build.Warning.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Build.Warning.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        text_ = "";
        priority_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_Warning_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.Warning getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Build.Warning.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.Warning build() {
        com.google.cloudbuild.v1.Build.Warning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.Warning buildPartial() {
        com.google.cloudbuild.v1.Build.Warning result =
            new com.google.cloudbuild.v1.Build.Warning(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Build.Warning result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.text_ = text_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.priority_ = priority_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Build.Warning) {
          return mergeFrom((com.google.cloudbuild.v1.Build.Warning) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Build.Warning other) {
        if (other == com.google.cloudbuild.v1.Build.Warning.getDefaultInstance()) return this;
        if (!other.getText().isEmpty()) {
          text_ = other.text_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.priority_ != 0) {
          setPriorityValue(other.getPriorityValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  text_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  priority_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * Explanation of the warning generated.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation of the warning generated.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explanation of the warning generated.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation of the warning generated.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        text_ = getDefaultInstance().getText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explanation of the warning generated.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        text_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int priority_ = 0;
      /**
       *
       *
       * <pre>
       * The priority for this warning.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
       *
       * @return The enum numeric value on the wire for priority.
       */
      @java.lang.Override
      public int getPriorityValue() {
        return priority_;
      }
      /**
       *
       *
       * <pre>
       * The priority for this warning.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
       *
       * @param value The enum numeric value on the wire for priority to set.
       * @return This builder for chaining.
       */
      public Builder setPriorityValue(int value) {
        priority_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The priority for this warning.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
       *
       * @return The priority.
       */
      @java.lang.Override
      public com.google.cloudbuild.v1.Build.Warning.Priority getPriority() {
        com.google.cloudbuild.v1.Build.Warning.Priority result =
            com.google.cloudbuild.v1.Build.Warning.Priority.forNumber(priority_);
        return result == null
            ? com.google.cloudbuild.v1.Build.Warning.Priority.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The priority for this warning.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
       *
       * @param value The priority to set.
       * @return This builder for chaining.
       */
      public Builder setPriority(com.google.cloudbuild.v1.Build.Warning.Priority value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        priority_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The priority for this warning.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.Warning.Priority priority = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPriority() {
        bitField0_ = (bitField0_ & ~0x00000002);
        priority_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Build.Warning)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Build.Warning)
    private static final com.google.cloudbuild.v1.Build.Warning DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Build.Warning();
    }

    public static com.google.cloudbuild.v1.Build.Warning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Warning> PARSER =
        new com.google.protobuf.AbstractParser<Warning>() {
          @java.lang.Override
          public Warning parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Warning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Warning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Warning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FailureInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.devtools.cloudbuild.v1.Build.FailureInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the failure.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The name of the failure.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloudbuild.v1.Build.FailureInfo.FailureType getType();

    /**
     *
     *
     * <pre>
     * Explains the failure issue in more detail using hard-coded text.
     * </pre>
     *
     * <code>string detail = 2;</code>
     *
     * @return The detail.
     */
    java.lang.String getDetail();
    /**
     *
     *
     * <pre>
     * Explains the failure issue in more detail using hard-coded text.
     * </pre>
     *
     * <code>string detail = 2;</code>
     *
     * @return The bytes for detail.
     */
    com.google.protobuf.ByteString getDetailBytes();
  }
  /**
   *
   *
   * <pre>
   * A fatal problem encountered during the execution of the build.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Build.FailureInfo}
   */
  public static final class FailureInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.Build.FailureInfo)
      FailureInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FailureInfo.newBuilder() to construct.
    private FailureInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FailureInfo() {
      type_ = 0;
      detail_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FailureInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_FailureInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_FailureInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Build.FailureInfo.class,
              com.google.cloudbuild.v1.Build.FailureInfo.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The name of a fatal problem encountered during the execution of the
     * build.
     * </pre>
     *
     * Protobuf enum {@code google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType}
     */
    public enum FailureType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Type unspecified
       * </pre>
       *
       * <code>FAILURE_TYPE_UNSPECIFIED = 0;</code>
       */
      FAILURE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Unable to push the image to the repository.
       * </pre>
       *
       * <code>PUSH_FAILED = 1;</code>
       */
      PUSH_FAILED(1),
      /**
       *
       *
       * <pre>
       * Final image not found.
       * </pre>
       *
       * <code>PUSH_IMAGE_NOT_FOUND = 2;</code>
       */
      PUSH_IMAGE_NOT_FOUND(2),
      /**
       *
       *
       * <pre>
       * Unauthorized push of the final image.
       * </pre>
       *
       * <code>PUSH_NOT_AUTHORIZED = 3;</code>
       */
      PUSH_NOT_AUTHORIZED(3),
      /**
       *
       *
       * <pre>
       * Backend logging failures. Should retry.
       * </pre>
       *
       * <code>LOGGING_FAILURE = 4;</code>
       */
      LOGGING_FAILURE(4),
      /**
       *
       *
       * <pre>
       * A build step has failed.
       * </pre>
       *
       * <code>USER_BUILD_STEP = 5;</code>
       */
      USER_BUILD_STEP(5),
      /**
       *
       *
       * <pre>
       * The source fetching has failed.
       * </pre>
       *
       * <code>FETCH_SOURCE_FAILED = 6;</code>
       */
      FETCH_SOURCE_FAILED(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Type unspecified
       * </pre>
       *
       * <code>FAILURE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int FAILURE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Unable to push the image to the repository.
       * </pre>
       *
       * <code>PUSH_FAILED = 1;</code>
       */
      public static final int PUSH_FAILED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Final image not found.
       * </pre>
       *
       * <code>PUSH_IMAGE_NOT_FOUND = 2;</code>
       */
      public static final int PUSH_IMAGE_NOT_FOUND_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Unauthorized push of the final image.
       * </pre>
       *
       * <code>PUSH_NOT_AUTHORIZED = 3;</code>
       */
      public static final int PUSH_NOT_AUTHORIZED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Backend logging failures. Should retry.
       * </pre>
       *
       * <code>LOGGING_FAILURE = 4;</code>
       */
      public static final int LOGGING_FAILURE_VALUE = 4;
      /**
       *
       *
       * <pre>
       * A build step has failed.
       * </pre>
       *
       * <code>USER_BUILD_STEP = 5;</code>
       */
      public static final int USER_BUILD_STEP_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The source fetching has failed.
       * </pre>
       *
       * <code>FETCH_SOURCE_FAILED = 6;</code>
       */
      public static final int FETCH_SOURCE_FAILED_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FailureType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FailureType forNumber(int value) {
        switch (value) {
          case 0:
            return FAILURE_TYPE_UNSPECIFIED;
          case 1:
            return PUSH_FAILED;
          case 2:
            return PUSH_IMAGE_NOT_FOUND;
          case 3:
            return PUSH_NOT_AUTHORIZED;
          case 4:
            return LOGGING_FAILURE;
          case 5:
            return USER_BUILD_STEP;
          case 6:
            return FETCH_SOURCE_FAILED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FailureType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<FailureType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FailureType>() {
            public FailureType findValueByNumber(int number) {
              return FailureType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloudbuild.v1.Build.FailureInfo.getDescriptor().getEnumTypes().get(0);
      }

      private static final FailureType[] VALUES = values();

      public static FailureType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FailureType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The name of the failure.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The name of the failure.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.FailureInfo.FailureType getType() {
      com.google.cloudbuild.v1.Build.FailureInfo.FailureType result =
          com.google.cloudbuild.v1.Build.FailureInfo.FailureType.forNumber(type_);
      return result == null
          ? com.google.cloudbuild.v1.Build.FailureInfo.FailureType.UNRECOGNIZED
          : result;
    }

    public static final int DETAIL_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object detail_ = "";
    /**
     *
     *
     * <pre>
     * Explains the failure issue in more detail using hard-coded text.
     * </pre>
     *
     * <code>string detail = 2;</code>
     *
     * @return The detail.
     */
    @java.lang.Override
    public java.lang.String getDetail() {
      java.lang.Object ref = detail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        detail_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Explains the failure issue in more detail using hard-coded text.
     * </pre>
     *
     * <code>string detail = 2;</code>
     *
     * @return The bytes for detail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDetailBytes() {
      java.lang.Object ref = detail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        detail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloudbuild.v1.Build.FailureInfo.FailureType.FAILURE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, detail_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloudbuild.v1.Build.FailureInfo.FailureType.FAILURE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(detail_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, detail_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloudbuild.v1.Build.FailureInfo)) {
        return super.equals(obj);
      }
      com.google.cloudbuild.v1.Build.FailureInfo other =
          (com.google.cloudbuild.v1.Build.FailureInfo) obj;

      if (type_ != other.type_) return false;
      if (!getDetail().equals(other.getDetail())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + DETAIL_FIELD_NUMBER;
      hash = (53 * hash) + getDetail().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloudbuild.v1.Build.FailureInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A fatal problem encountered during the execution of the build.
     * </pre>
     *
     * Protobuf type {@code google.devtools.cloudbuild.v1.Build.FailureInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Build.FailureInfo)
        com.google.cloudbuild.v1.Build.FailureInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_FailureInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_FailureInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloudbuild.v1.Build.FailureInfo.class,
                com.google.cloudbuild.v1.Build.FailureInfo.Builder.class);
      }

      // Construct using com.google.cloudbuild.v1.Build.FailureInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        detail_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloudbuild.v1.Cloudbuild
            .internal_static_google_devtools_cloudbuild_v1_Build_FailureInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.FailureInfo getDefaultInstanceForType() {
        return com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.FailureInfo build() {
        com.google.cloudbuild.v1.Build.FailureInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloudbuild.v1.Build.FailureInfo buildPartial() {
        com.google.cloudbuild.v1.Build.FailureInfo result =
            new com.google.cloudbuild.v1.Build.FailureInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloudbuild.v1.Build.FailureInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.detail_ = detail_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloudbuild.v1.Build.FailureInfo) {
          return mergeFrom((com.google.cloudbuild.v1.Build.FailureInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloudbuild.v1.Build.FailureInfo other) {
        if (other == com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.getDetail().isEmpty()) {
          detail_ = other.detail_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  detail_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The name of the failure.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The name of the failure.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the failure.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloudbuild.v1.Build.FailureInfo.FailureType getType() {
        com.google.cloudbuild.v1.Build.FailureInfo.FailureType result =
            com.google.cloudbuild.v1.Build.FailureInfo.FailureType.forNumber(type_);
        return result == null
            ? com.google.cloudbuild.v1.Build.FailureInfo.FailureType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The name of the failure.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloudbuild.v1.Build.FailureInfo.FailureType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the failure.
       * </pre>
       *
       * <code>.google.devtools.cloudbuild.v1.Build.FailureInfo.FailureType type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object detail_ = "";
      /**
       *
       *
       * <pre>
       * Explains the failure issue in more detail using hard-coded text.
       * </pre>
       *
       * <code>string detail = 2;</code>
       *
       * @return The detail.
       */
      public java.lang.String getDetail() {
        java.lang.Object ref = detail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          detail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explains the failure issue in more detail using hard-coded text.
       * </pre>
       *
       * <code>string detail = 2;</code>
       *
       * @return The bytes for detail.
       */
      public com.google.protobuf.ByteString getDetailBytes() {
        java.lang.Object ref = detail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          detail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Explains the failure issue in more detail using hard-coded text.
       * </pre>
       *
       * <code>string detail = 2;</code>
       *
       * @param value The detail to set.
       * @return This builder for chaining.
       */
      public Builder setDetail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        detail_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explains the failure issue in more detail using hard-coded text.
       * </pre>
       *
       * <code>string detail = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDetail() {
        detail_ = getDefaultInstance().getDetail();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Explains the failure issue in more detail using hard-coded text.
       * </pre>
       *
       * <code>string detail = 2;</code>
       *
       * @param value The bytes for detail to set.
       * @return This builder for chaining.
       */
      public Builder setDetailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        detail_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Build.FailureInfo)
    }

    // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Build.FailureInfo)
    private static final com.google.cloudbuild.v1.Build.FailureInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Build.FailureInfo();
    }

    public static com.google.cloudbuild.v1.Build.FailureInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FailureInfo> PARSER =
        new com.google.protobuf.AbstractParser<FailureInfo>() {
          @java.lang.Override
          public FailureInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FailureInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FailureInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build.FailureInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 45;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build}
   * is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The 'Build' name with format:
   * `projects/{project}/locations/{location}/builds/{build}`, where {build}
   * is a unique identifier generated by the service.
   * </pre>
   *
   * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the build.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the build.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. ID of the project.
   * </pre>
   *
   * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. ID of the project.
   * </pre>
   *
   * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Status of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Status of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.Status getStatus() {
    com.google.cloudbuild.v1.Build.Status result =
        com.google.cloudbuild.v1.Build.Status.forNumber(status_);
    return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_DETAIL_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusDetail_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Customer-readable message about the current status.
   * </pre>
   *
   * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusDetail.
   */
  @java.lang.Override
  public java.lang.String getStatusDetail() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusDetail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Customer-readable message about the current status.
   * </pre>
   *
   * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusDetailBytes() {
    java.lang.Object ref = statusDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 3;
  private com.google.cloudbuild.v1.Source source_;
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   *
   * @return Whether the source field is set.
   */
  @java.lang.Override
  public boolean hasSource() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Source getSource() {
    return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
  }
  /**
   *
   *
   * <pre>
   * The location of the source files to build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceOrBuilder getSourceOrBuilder() {
    return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
  }

  public static final int STEPS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.BuildStep> steps_;
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.BuildStep> getStepsList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.BuildStepOrBuilder>
      getStepsOrBuilderList() {
    return steps_;
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public int getStepsCount() {
    return steps_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStep getSteps(int index) {
    return steps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The operations to be performed on the workspace.
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildStepOrBuilder getStepsOrBuilder(int index) {
    return steps_.get(index);
  }

  public static final int RESULTS_FIELD_NUMBER = 10;
  private com.google.cloudbuild.v1.Results results_;
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the results field is set.
   */
  @java.lang.Override
  public boolean hasResults() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The results.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Results getResults() {
    return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Results of the build.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.ResultsOrBuilder getResultsOrBuilder() {
    return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the request to create the build was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int FINISH_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp finishTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   *
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the finishTime field is set.
   */
  @java.lang.Override
  public boolean hasFinishTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   *
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The finishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinishTime() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which execution of the build was finished.
   *
   * The difference between finish_time and start_time is the duration of the
   * build's execution.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   *
   * `timeout` starts ticking from `startTime`.
   *
   * Default time is 60 minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   *
   * `timeout` starts ticking from `startTime`.
   *
   * Default time is 60 minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Amount of time that this build should be allowed to run, to second
   * granularity. If this amount of time elapses, work on the build will cease
   * and the build status will be `TIMEOUT`.
   *
   * `timeout` starts ticking from `startTime`.
   *
   * Default time is 60 minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int IMAGES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList images_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images are pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @return A list containing the images.
   */
  public com.google.protobuf.ProtocolStringList getImagesList() {
    return images_;
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images are pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @return The count of images.
   */
  public int getImagesCount() {
    return images_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images are pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The images at the given index.
   */
  public java.lang.String getImages(int index) {
    return images_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of images to be pushed upon the successful completion of all build
   * steps.
   *
   * The images are pushed using the builder service account's credentials.
   *
   * The digests of the pushed images will be stored in the `Build` resource's
   * results field.
   *
   * If any of the images fail to be pushed, the build status is marked
   * `FAILURE`.
   * </pre>
   *
   * <code>repeated string images = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the images at the given index.
   */
  public com.google.protobuf.ByteString getImagesBytes(int index) {
    return images_.getByteString(index);
  }

  public static final int QUEUE_TTL_FIELD_NUMBER = 40;
  private com.google.protobuf.Duration queueTtl_;
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   *
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   *
   * @return Whether the queueTtl field is set.
   */
  @java.lang.Override
  public boolean hasQueueTtl() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   *
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   *
   * @return The queueTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getQueueTtl() {
    return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
  }
  /**
   *
   *
   * <pre>
   * TTL in queue for this build. If provided and the build is enqueued longer
   * than this value, the build will expire and the build status will be
   * `EXPIRED`.
   *
   * The TTL starts ticking from create_time.
   * </pre>
   *
   * <code>.google.protobuf.Duration queue_ttl = 40;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getQueueTtlOrBuilder() {
    return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
  }

  public static final int ARTIFACTS_FIELD_NUMBER = 37;
  private com.google.cloudbuild.v1.Artifacts artifacts_;
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   *
   * @return Whether the artifacts field is set.
   */
  @java.lang.Override
  public boolean hasArtifacts() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   *
   * @return The artifacts.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Artifacts getArtifacts() {
    return artifacts_ == null
        ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
        : artifacts_;
  }
  /**
   *
   *
   * <pre>
   * Artifacts produced by the build that should be uploaded upon
   * successful completion of all build steps.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.ArtifactsOrBuilder getArtifactsOrBuilder() {
    return artifacts_ == null
        ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
        : artifacts_;
  }

  public static final int LOGS_BUCKET_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logsBucket_ = "";
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket where logs should be written (see
   * [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
   * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * </pre>
   *
   * <code>string logs_bucket = 19;</code>
   *
   * @return The logsBucket.
   */
  @java.lang.Override
  public java.lang.String getLogsBucket() {
    java.lang.Object ref = logsBucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logsBucket_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage bucket where logs should be written (see
   * [Bucket Name
   * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
   * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
   * </pre>
   *
   * <code>string logs_bucket = 19;</code>
   *
   * @return The bytes for logsBucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogsBucketBytes() {
    java.lang.Object ref = logsBucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logsBucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PROVENANCE_FIELD_NUMBER = 21;
  private com.google.cloudbuild.v1.SourceProvenance sourceProvenance_;
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the sourceProvenance field is set.
   */
  @java.lang.Override
  public boolean hasSourceProvenance() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourceProvenance.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceProvenance getSourceProvenance() {
    return sourceProvenance_ == null
        ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
        : sourceProvenance_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A permanent fixed identifier for source.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
    return sourceProvenance_ == null
        ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
        : sourceProvenance_;
  }

  public static final int BUILD_TRIGGER_ID_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildTriggerId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   * </pre>
   *
   * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The buildTriggerId.
   */
  @java.lang.Override
  public java.lang.String getBuildTriggerId() {
    java.lang.Object ref = buildTriggerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildTriggerId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the `BuildTrigger` that triggered this build, if it
   * was triggered automatically.
   * </pre>
   *
   * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for buildTriggerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildTriggerIdBytes() {
    java.lang.Object ref = buildTriggerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildTriggerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPTIONS_FIELD_NUMBER = 23;
  private com.google.cloudbuild.v1.BuildOptions options_;
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   *
   * @return Whether the options field is set.
   */
  @java.lang.Override
  public boolean hasOptions() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   *
   * @return The options.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptions getOptions() {
    return options_ == null ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance() : options_;
  }
  /**
   *
   *
   * <pre>
   * Special options for this build.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildOptionsOrBuilder getOptionsOrBuilder() {
    return options_ == null ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance() : options_;
  }

  public static final int LOG_URL_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logUrl_ = "";
  /**
   *
   *
   * <pre>
   * Output only. URL to logs for this build in Google Cloud Console.
   * </pre>
   *
   * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The logUrl.
   */
  @java.lang.Override
  public java.lang.String getLogUrl() {
    java.lang.Object ref = logUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URL to logs for this build in Google Cloud Console.
   * </pre>
   *
   * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for logUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogUrlBytes() {
    java.lang.Object ref = logUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBSTITUTIONS_FIELD_NUMBER = 29;

  private static final class SubstitutionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloudbuild.v1.Cloudbuild
                .internal_static_google_devtools_cloudbuild_v1_Build_SubstitutionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSubstitutions() {
    if (substitutions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SubstitutionsDefaultEntryHolder.defaultEntry);
    }
    return substitutions_;
  }

  public int getSubstitutionsCount() {
    return internalGetSubstitutions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public boolean containsSubstitutions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSubstitutions().getMap().containsKey(key);
  }
  /** Use {@link #getSubstitutionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
    return getSubstitutionsMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
    return internalGetSubstitutions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getSubstitutionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Substitutions data for `Build` resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; substitutions = 29;</code>
   */
  @java.lang.Override
  public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TAGS_FIELD_NUMBER = 31;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tags for annotation of a `Build`. These are not docker tags.
   * </pre>
   *
   * <code>repeated string tags = 31;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int SECRETS_FIELD_NUMBER = 32;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Secret> secrets_;
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * Note: Secret Manager is the recommended technique
   * for managing sensitive data with Cloud Build. Use `available_secrets` to
   * configure builds to access secrets from Secret Manager. For instructions,
   * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Secret> getSecretsList() {
    return secrets_;
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * Note: Secret Manager is the recommended technique
   * for managing sensitive data with Cloud Build. Use `available_secrets` to
   * configure builds to access secrets from Secret Manager. For instructions,
   * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.SecretOrBuilder>
      getSecretsOrBuilderList() {
    return secrets_;
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * Note: Secret Manager is the recommended technique
   * for managing sensitive data with Cloud Build. Use `available_secrets` to
   * configure builds to access secrets from Secret Manager. For instructions,
   * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public int getSecretsCount() {
    return secrets_.size();
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * Note: Secret Manager is the recommended technique
   * for managing sensitive data with Cloud Build. Use `available_secrets` to
   * configure builds to access secrets from Secret Manager. For instructions,
   * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Secret getSecrets(int index) {
    return secrets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secrets to decrypt using Cloud Key Management Service.
   * Note: Secret Manager is the recommended technique
   * for managing sensitive data with Cloud Build. Use `available_secrets` to
   * configure builds to access secrets from Secret Manager. For instructions,
   * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
   * </pre>
   *
   * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SecretOrBuilder getSecretsOrBuilder(int index) {
    return secrets_.get(index);
  }

  public static final int TIMING_FIELD_NUMBER = 33;

  private static final class TimingDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloudbuild.v1.TimeSpan>newDefaultInstance(
                    com.google.cloudbuild.v1.Cloudbuild
                        .internal_static_google_devtools_cloudbuild_v1_Build_TimingEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloudbuild.v1.TimeSpan.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan> timing_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
      internalGetTiming() {
    if (timing_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TimingDefaultEntryHolder.defaultEntry);
    }
    return timing_;
  }

  public int getTimingCount() {
    return internalGetTiming().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   *
   * * BUILD: time to execute all build steps.
   * * PUSH: time to push all artifacts including docker images and non docker
   * artifacts.
   * * FETCHSOURCE: time to fetch source.
   * * SETUPBUILD: time to set up build.
   *
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsTiming(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTiming().getMap().containsKey(key);
  }
  /** Use {@link #getTimingMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTiming() {
    return getTimingMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   *
   * * BUILD: time to execute all build steps.
   * * PUSH: time to push all artifacts including docker images and non docker
   * artifacts.
   * * FETCHSOURCE: time to fetch source.
   * * SETUPBUILD: time to set up build.
   *
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTimingMap() {
    return internalGetTiming().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   *
   * * BUILD: time to execute all build steps.
   * * PUSH: time to push all artifacts including docker images and non docker
   * artifacts.
   * * FETCHSOURCE: time to fetch source.
   * * SETUPBUILD: time to set up build.
   *
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloudbuild.v1.TimeSpan getTimingOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloudbuild.v1.TimeSpan defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
        internalGetTiming().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Stores timing information for phases of the build. Valid keys
   * are:
   *
   * * BUILD: time to execute all build steps.
   * * PUSH: time to push all artifacts including docker images and non docker
   * artifacts.
   * * FETCHSOURCE: time to fetch source.
   * * SETUPBUILD: time to set up build.
   *
   * If the build does not specify source or images,
   * these keys will not be included.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.TimeSpan getTimingOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> map =
        internalGetTiming().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int APPROVAL_FIELD_NUMBER = 44;
  private com.google.cloudbuild.v1.BuildApproval approval_;
  /**
   *
   *
   * <pre>
   * Output only. Describes this build's approval configuration, status,
   * and result.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the approval field is set.
   */
  @java.lang.Override
  public boolean hasApproval() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes this build's approval configuration, status,
   * and result.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The approval.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildApproval getApproval() {
    return approval_ == null
        ? com.google.cloudbuild.v1.BuildApproval.getDefaultInstance()
        : approval_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes this build's approval configuration, status,
   * and result.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.BuildApprovalOrBuilder getApprovalOrBuilder() {
    return approval_ == null
        ? com.google.cloudbuild.v1.BuildApproval.getDefaultInstance()
        : approval_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 42;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * IAM service account whose credentials will be used at build runtime.
   * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   * ACCOUNT can be email address or uniqueId of the service account.
   * </pre>
   *
   * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IAM service account whose credentials will be used at build runtime.
   * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
   * ACCOUNT can be email address or uniqueId of the service account.
   * </pre>
   *
   * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_SECRETS_FIELD_NUMBER = 47;
  private com.google.cloudbuild.v1.Secrets availableSecrets_;
  /**
   *
   *
   * <pre>
   * Secrets and secret environment variables.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
   *
   * @return Whether the availableSecrets field is set.
   */
  @java.lang.Override
  public boolean hasAvailableSecrets() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Secrets and secret environment variables.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
   *
   * @return The availableSecrets.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Secrets getAvailableSecrets() {
    return availableSecrets_ == null
        ? com.google.cloudbuild.v1.Secrets.getDefaultInstance()
        : availableSecrets_;
  }
  /**
   *
   *
   * <pre>
   * Secrets and secret environment variables.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.SecretsOrBuilder getAvailableSecretsOrBuilder() {
    return availableSecrets_ == null
        ? com.google.cloudbuild.v1.Secrets.getDefaultInstance()
        : availableSecrets_;
  }

  public static final int WARNINGS_FIELD_NUMBER = 49;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloudbuild.v1.Build.Warning> warnings_;
  /**
   *
   *
   * <pre>
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloudbuild.v1.Build.Warning> getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloudbuild.v1.Build.WarningOrBuilder>
      getWarningsOrBuilderList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.Warning getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Non-fatal problems encountered during the execution of the
   * build.
   * </pre>
   *
   * <code>
   * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.WarningOrBuilder getWarningsOrBuilder(int index) {
    return warnings_.get(index);
  }

  public static final int FAILURE_INFO_FIELD_NUMBER = 51;
  private com.google.cloudbuild.v1.Build.FailureInfo failureInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Contains information about the build when status=FAILURE.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the failureInfo field is set.
   */
  @java.lang.Override
  public boolean hasFailureInfo() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains information about the build when status=FAILURE.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The failureInfo.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.FailureInfo getFailureInfo() {
    return failureInfo_ == null
        ? com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()
        : failureInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Contains information about the build when status=FAILURE.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.Build.FailureInfoOrBuilder getFailureInfoOrBuilder() {
    return failureInfo_ == null
        ? com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()
        : failureInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      output.writeEnum(2, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSource());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getStartTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(8, getFinishTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getResults());
    }
    for (int i = 0; i < steps_.size(); i++) {
      output.writeMessage(11, steps_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(12, getTimeout());
    }
    for (int i = 0; i < images_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, images_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logsBucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, logsBucket_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(21, getSourceProvenance());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildTriggerId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, buildTriggerId_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(23, getOptions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusDetail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, statusDetail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, logUrl_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSubstitutions(), SubstitutionsDefaultEntryHolder.defaultEntry, 29);
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 31, tags_.getRaw(i));
    }
    for (int i = 0; i < secrets_.size(); i++) {
      output.writeMessage(32, secrets_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTiming(), TimingDefaultEntryHolder.defaultEntry, 33);
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(37, getArtifacts());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(40, getQueueTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 42, serviceAccount_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(44, getApproval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 45, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(47, getAvailableSecrets());
    }
    for (int i = 0; i < warnings_.size(); i++) {
      output.writeMessage(49, warnings_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(51, getFailureInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (status_ != com.google.cloudbuild.v1.Build.Status.STATUS_UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSource());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getFinishTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getResults());
    }
    for (int i = 0; i < steps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, steps_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTimeout());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < images_.size(); i++) {
        dataSize += computeStringSizeNoTag(images_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getImagesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logsBucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, logsBucket_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getSourceProvenance());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildTriggerId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, buildTriggerId_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getOptions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusDetail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, statusDetail_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, logUrl_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSubstitutions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
          SubstitutionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, substitutions__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getTagsList().size();
    }
    for (int i = 0; i < secrets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(32, secrets_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloudbuild.v1.TimeSpan> entry :
        internalGetTiming().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan> timing__ =
          TimingDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(33, timing__);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(37, getArtifacts());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(40, getQueueTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(42, serviceAccount_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(44, getApproval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(45, name_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(47, getAvailableSecrets());
    }
    for (int i = 0; i < warnings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(49, warnings_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(51, getFailureInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.Build)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.Build other = (com.google.cloudbuild.v1.Build) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (status_ != other.status_) return false;
    if (!getStatusDetail().equals(other.getStatusDetail())) return false;
    if (hasSource() != other.hasSource()) return false;
    if (hasSource()) {
      if (!getSource().equals(other.getSource())) return false;
    }
    if (!getStepsList().equals(other.getStepsList())) return false;
    if (hasResults() != other.hasResults()) return false;
    if (hasResults()) {
      if (!getResults().equals(other.getResults())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasFinishTime() != other.hasFinishTime()) return false;
    if (hasFinishTime()) {
      if (!getFinishTime().equals(other.getFinishTime())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getImagesList().equals(other.getImagesList())) return false;
    if (hasQueueTtl() != other.hasQueueTtl()) return false;
    if (hasQueueTtl()) {
      if (!getQueueTtl().equals(other.getQueueTtl())) return false;
    }
    if (hasArtifacts() != other.hasArtifacts()) return false;
    if (hasArtifacts()) {
      if (!getArtifacts().equals(other.getArtifacts())) return false;
    }
    if (!getLogsBucket().equals(other.getLogsBucket())) return false;
    if (hasSourceProvenance() != other.hasSourceProvenance()) return false;
    if (hasSourceProvenance()) {
      if (!getSourceProvenance().equals(other.getSourceProvenance())) return false;
    }
    if (!getBuildTriggerId().equals(other.getBuildTriggerId())) return false;
    if (hasOptions() != other.hasOptions()) return false;
    if (hasOptions()) {
      if (!getOptions().equals(other.getOptions())) return false;
    }
    if (!getLogUrl().equals(other.getLogUrl())) return false;
    if (!internalGetSubstitutions().equals(other.internalGetSubstitutions())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getSecretsList().equals(other.getSecretsList())) return false;
    if (!internalGetTiming().equals(other.internalGetTiming())) return false;
    if (hasApproval() != other.hasApproval()) return false;
    if (hasApproval()) {
      if (!getApproval().equals(other.getApproval())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasAvailableSecrets() != other.hasAvailableSecrets()) return false;
    if (hasAvailableSecrets()) {
      if (!getAvailableSecrets().equals(other.getAvailableSecrets())) return false;
    }
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (hasFailureInfo() != other.hasFailureInfo()) return false;
    if (hasFailureInfo()) {
      if (!getFailureInfo().equals(other.getFailureInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + STATUS_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStatusDetail().hashCode();
    if (hasSource()) {
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
    }
    if (getStepsCount() > 0) {
      hash = (37 * hash) + STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getStepsList().hashCode();
    }
    if (hasResults()) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResults().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasFinishTime()) {
      hash = (37 * hash) + FINISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinishTime().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (getImagesCount() > 0) {
      hash = (37 * hash) + IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getImagesList().hashCode();
    }
    if (hasQueueTtl()) {
      hash = (37 * hash) + QUEUE_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getQueueTtl().hashCode();
    }
    if (hasArtifacts()) {
      hash = (37 * hash) + ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getArtifacts().hashCode();
    }
    hash = (37 * hash) + LOGS_BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getLogsBucket().hashCode();
    if (hasSourceProvenance()) {
      hash = (37 * hash) + SOURCE_PROVENANCE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceProvenance().hashCode();
    }
    hash = (37 * hash) + BUILD_TRIGGER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBuildTriggerId().hashCode();
    if (hasOptions()) {
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOptions().hashCode();
    }
    hash = (37 * hash) + LOG_URL_FIELD_NUMBER;
    hash = (53 * hash) + getLogUrl().hashCode();
    if (!internalGetSubstitutions().getMap().isEmpty()) {
      hash = (37 * hash) + SUBSTITUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSubstitutions().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (getSecretsCount() > 0) {
      hash = (37 * hash) + SECRETS_FIELD_NUMBER;
      hash = (53 * hash) + getSecretsList().hashCode();
    }
    if (!internalGetTiming().getMap().isEmpty()) {
      hash = (37 * hash) + TIMING_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTiming().hashCode();
    }
    if (hasApproval()) {
      hash = (37 * hash) + APPROVAL_FIELD_NUMBER;
      hash = (53 * hash) + getApproval().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasAvailableSecrets()) {
      hash = (37 * hash) + AVAILABLE_SECRETS_FIELD_NUMBER;
      hash = (53 * hash) + getAvailableSecrets().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    if (hasFailureInfo()) {
      hash = (37 * hash) + FAILURE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFailureInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.Build parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.Build parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.Build prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A build resource in the Cloud Build API.
   *
   * At a high level, a `Build` describes where to find source code, how to build
   * it (for example, the builder image to run on the source), and where to store
   * the built artifacts.
   *
   * Fields can include the following variables, which will be expanded when the
   * build is created:
   *
   * - $PROJECT_ID: the project ID of the build.
   * - $PROJECT_NUMBER: the project number of the build.
   * - $LOCATION: the location/region of the build.
   * - $BUILD_ID: the autogenerated ID of the build.
   * - $REPO_NAME: the source repository name specified by RepoSource.
   * - $BRANCH_NAME: the branch name specified by RepoSource.
   * - $TAG_NAME: the tag name specified by RepoSource.
   * - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
   *   resolved from the specified branch or tag.
   * - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.Build}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.Build)
      com.google.cloudbuild.v1.BuildOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 29:
          return internalGetSubstitutions();
        case 33:
          return internalGetTiming();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 29:
          return internalGetMutableSubstitutions();
        case 33:
          return internalGetMutableTiming();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.Build.class, com.google.cloudbuild.v1.Build.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.Build.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSourceFieldBuilder();
        getStepsFieldBuilder();
        getResultsFieldBuilder();
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getFinishTimeFieldBuilder();
        getTimeoutFieldBuilder();
        getQueueTtlFieldBuilder();
        getArtifactsFieldBuilder();
        getSourceProvenanceFieldBuilder();
        getOptionsFieldBuilder();
        getSecretsFieldBuilder();
        getApprovalFieldBuilder();
        getAvailableSecretsFieldBuilder();
        getWarningsFieldBuilder();
        getFailureInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      id_ = "";
      projectId_ = "";
      status_ = 0;
      statusDetail_ = "";
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
      } else {
        steps_ = null;
        stepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      results_ = null;
      if (resultsBuilder_ != null) {
        resultsBuilder_.dispose();
        resultsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      images_ = com.google.protobuf.LazyStringArrayList.emptyList();
      queueTtl_ = null;
      if (queueTtlBuilder_ != null) {
        queueTtlBuilder_.dispose();
        queueTtlBuilder_ = null;
      }
      artifacts_ = null;
      if (artifactsBuilder_ != null) {
        artifactsBuilder_.dispose();
        artifactsBuilder_ = null;
      }
      logsBucket_ = "";
      sourceProvenance_ = null;
      if (sourceProvenanceBuilder_ != null) {
        sourceProvenanceBuilder_.dispose();
        sourceProvenanceBuilder_ = null;
      }
      buildTriggerId_ = "";
      options_ = null;
      if (optionsBuilder_ != null) {
        optionsBuilder_.dispose();
        optionsBuilder_ = null;
      }
      logUrl_ = "";
      internalGetMutableSubstitutions().clear();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (secretsBuilder_ == null) {
        secrets_ = java.util.Collections.emptyList();
      } else {
        secrets_ = null;
        secretsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00400000);
      internalGetMutableTiming().clear();
      approval_ = null;
      if (approvalBuilder_ != null) {
        approvalBuilder_.dispose();
        approvalBuilder_ = null;
      }
      serviceAccount_ = "";
      availableSecrets_ = null;
      if (availableSecretsBuilder_ != null) {
        availableSecretsBuilder_.dispose();
        availableSecretsBuilder_ = null;
      }
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
      } else {
        warnings_ = null;
        warningsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x08000000);
      failureInfo_ = null;
      if (failureInfoBuilder_ != null) {
        failureInfoBuilder_.dispose();
        failureInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_Build_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.Build.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build build() {
      com.google.cloudbuild.v1.Build result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.Build buildPartial() {
      com.google.cloudbuild.v1.Build result = new com.google.cloudbuild.v1.Build(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloudbuild.v1.Build result) {
      if (stepsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          steps_ = java.util.Collections.unmodifiableList(steps_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.steps_ = steps_;
      } else {
        result.steps_ = stepsBuilder_.build();
      }
      if (secretsBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)) {
          secrets_ = java.util.Collections.unmodifiableList(secrets_);
          bitField0_ = (bitField0_ & ~0x00400000);
        }
        result.secrets_ = secrets_;
      } else {
        result.secrets_ = secretsBuilder_.build();
      }
      if (warningsBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)) {
          warnings_ = java.util.Collections.unmodifiableList(warnings_);
          bitField0_ = (bitField0_ & ~0x08000000);
        }
        result.warnings_ = warnings_;
      } else {
        result.warnings_ = warningsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloudbuild.v1.Build result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.statusDetail_ = statusDetail_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.source_ = sourceBuilder_ == null ? source_ : sourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.results_ = resultsBuilder_ == null ? results_ : resultsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.finishTime_ = finishTimeBuilder_ == null ? finishTime_ : finishTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        images_.makeImmutable();
        result.images_ = images_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.queueTtl_ = queueTtlBuilder_ == null ? queueTtl_ : queueTtlBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.artifacts_ = artifactsBuilder_ == null ? artifacts_ : artifactsBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.logsBucket_ = logsBucket_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.sourceProvenance_ =
            sourceProvenanceBuilder_ == null ? sourceProvenance_ : sourceProvenanceBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.buildTriggerId_ = buildTriggerId_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.options_ = optionsBuilder_ == null ? options_ : optionsBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.logUrl_ = logUrl_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.substitutions_ = internalGetSubstitutions();
        result.substitutions_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.timing_ = internalGetTiming().build(TimingDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.approval_ = approvalBuilder_ == null ? approval_ : approvalBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.availableSecrets_ =
            availableSecretsBuilder_ == null ? availableSecrets_ : availableSecretsBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.failureInfo_ =
            failureInfoBuilder_ == null ? failureInfo_ : failureInfoBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.Build) {
        return mergeFrom((com.google.cloudbuild.v1.Build) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.Build other) {
      if (other == com.google.cloudbuild.v1.Build.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (!other.getStatusDetail().isEmpty()) {
        statusDetail_ = other.statusDetail_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSource()) {
        mergeSource(other.getSource());
      }
      if (stepsBuilder_ == null) {
        if (!other.steps_.isEmpty()) {
          if (steps_.isEmpty()) {
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureStepsIsMutable();
            steps_.addAll(other.steps_);
          }
          onChanged();
        }
      } else {
        if (!other.steps_.isEmpty()) {
          if (stepsBuilder_.isEmpty()) {
            stepsBuilder_.dispose();
            stepsBuilder_ = null;
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000040);
            stepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStepsFieldBuilder()
                    : null;
          } else {
            stepsBuilder_.addAllMessages(other.steps_);
          }
        }
      }
      if (other.hasResults()) {
        mergeResults(other.getResults());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasFinishTime()) {
        mergeFinishTime(other.getFinishTime());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (!other.images_.isEmpty()) {
        if (images_.isEmpty()) {
          images_ = other.images_;
          bitField0_ |= 0x00001000;
        } else {
          ensureImagesIsMutable();
          images_.addAll(other.images_);
        }
        onChanged();
      }
      if (other.hasQueueTtl()) {
        mergeQueueTtl(other.getQueueTtl());
      }
      if (other.hasArtifacts()) {
        mergeArtifacts(other.getArtifacts());
      }
      if (!other.getLogsBucket().isEmpty()) {
        logsBucket_ = other.logsBucket_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasSourceProvenance()) {
        mergeSourceProvenance(other.getSourceProvenance());
      }
      if (!other.getBuildTriggerId().isEmpty()) {
        buildTriggerId_ = other.buildTriggerId_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasOptions()) {
        mergeOptions(other.getOptions());
      }
      if (!other.getLogUrl().isEmpty()) {
        logUrl_ = other.logUrl_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      internalGetMutableSubstitutions().mergeFrom(other.internalGetSubstitutions());
      bitField0_ |= 0x00100000;
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00200000;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (secretsBuilder_ == null) {
        if (!other.secrets_.isEmpty()) {
          if (secrets_.isEmpty()) {
            secrets_ = other.secrets_;
            bitField0_ = (bitField0_ & ~0x00400000);
          } else {
            ensureSecretsIsMutable();
            secrets_.addAll(other.secrets_);
          }
          onChanged();
        }
      } else {
        if (!other.secrets_.isEmpty()) {
          if (secretsBuilder_.isEmpty()) {
            secretsBuilder_.dispose();
            secretsBuilder_ = null;
            secrets_ = other.secrets_;
            bitField0_ = (bitField0_ & ~0x00400000);
            secretsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretsFieldBuilder()
                    : null;
          } else {
            secretsBuilder_.addAllMessages(other.secrets_);
          }
        }
      }
      internalGetMutableTiming().mergeFrom(other.internalGetTiming());
      bitField0_ |= 0x00800000;
      if (other.hasApproval()) {
        mergeApproval(other.getApproval());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (other.hasAvailableSecrets()) {
        mergeAvailableSecrets(other.getAvailableSecrets());
      }
      if (warningsBuilder_ == null) {
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x08000000);
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
      } else {
        if (!other.warnings_.isEmpty()) {
          if (warningsBuilder_.isEmpty()) {
            warningsBuilder_.dispose();
            warningsBuilder_ = null;
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x08000000);
            warningsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningsFieldBuilder()
                    : null;
          } else {
            warningsBuilder_.addAllMessages(other.warnings_);
          }
        }
      }
      if (other.hasFailureInfo()) {
        mergeFailureInfo(other.getFailureInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 16:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getFinishTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(getResultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                com.google.cloudbuild.v1.BuildStep m =
                    input.readMessage(
                        com.google.cloudbuild.v1.BuildStep.parser(), extensionRegistry);
                if (stepsBuilder_ == null) {
                  ensureStepsIsMutable();
                  steps_.add(m);
                } else {
                  stepsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureImagesIsMutable();
                images_.add(s);
                break;
              } // case 106
            case 130:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 130
            case 154:
              {
                logsBucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 154
            case 170:
              {
                input.readMessage(
                    getSourceProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 170
            case 178:
              {
                buildTriggerId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 186
            case 194:
              {
                statusDetail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 194
            case 202:
              {
                logUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 202
            case 234:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> substitutions__ =
                    input.readMessage(
                        SubstitutionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableSubstitutions()
                    .getMutableMap()
                    .put(substitutions__.getKey(), substitutions__.getValue());
                bitField0_ |= 0x00100000;
                break;
              } // case 234
            case 250:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 250
            case 258:
              {
                com.google.cloudbuild.v1.Secret m =
                    input.readMessage(com.google.cloudbuild.v1.Secret.parser(), extensionRegistry);
                if (secretsBuilder_ == null) {
                  ensureSecretsIsMutable();
                  secrets_.add(m);
                } else {
                  secretsBuilder_.addMessage(m);
                }
                break;
              } // case 258
            case 266:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
                    timing__ =
                        input.readMessage(
                            TimingDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTiming()
                    .ensureBuilderMap()
                    .put(timing__.getKey(), timing__.getValue());
                bitField0_ |= 0x00800000;
                break;
              } // case 266
            case 298:
              {
                input.readMessage(getArtifactsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 298
            case 322:
              {
                input.readMessage(getQueueTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 322
            case 338:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 338
            case 354:
              {
                input.readMessage(getApprovalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 354
            case 362:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 362
            case 378:
              {
                input.readMessage(
                    getAvailableSecretsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 378
            case 394:
              {
                com.google.cloudbuild.v1.Build.Warning m =
                    input.readMessage(
                        com.google.cloudbuild.v1.Build.Warning.parser(), extensionRegistry);
                if (warningsBuilder_ == null) {
                  ensureWarningsIsMutable();
                  warnings_.add(m);
                } else {
                  warningsBuilder_.addMessage(m);
                }
                break;
              } // case 394
            case 410:
              {
                input.readMessage(getFailureInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 410
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The 'Build' name with format:
     * `projects/{project}/locations/{location}/builds/{build}`, where {build}
     * is a unique identifier generated by the service.
     * </pre>
     *
     * <code>string name = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the build.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. ID of the project.
     * </pre>
     *
     * <code>string project_id = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.Build.Status getStatus() {
      com.google.cloudbuild.v1.Build.Status result =
          com.google.cloudbuild.v1.Build.Status.forNumber(status_);
      return result == null ? com.google.cloudbuild.v1.Build.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloudbuild.v1.Build.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Status of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.Status status = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusDetail_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusDetail.
     */
    public java.lang.String getStatusDetail() {
      java.lang.Object ref = statusDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusDetail.
     */
    public com.google.protobuf.ByteString getStatusDetailBytes() {
      java.lang.Object ref = statusDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusDetail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusDetail() {
      statusDetail_ = getDefaultInstance().getStatusDetail();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Customer-readable message about the current status.
     * </pre>
     *
     * <code>string status_detail = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStatusDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusDetail_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Source source_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Source,
            com.google.cloudbuild.v1.Source.Builder,
            com.google.cloudbuild.v1.SourceOrBuilder>
        sourceBuilder_;
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     *
     * @return Whether the source field is set.
     */
    public boolean hasSource() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     *
     * @return The source.
     */
    public com.google.cloudbuild.v1.Source getSource() {
      if (sourceBuilder_ == null) {
        return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
      } else {
        return sourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder setSource(com.google.cloudbuild.v1.Source value) {
      if (sourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
      } else {
        sourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder setSource(com.google.cloudbuild.v1.Source.Builder builderForValue) {
      if (sourceBuilder_ == null) {
        source_ = builderForValue.build();
      } else {
        sourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder mergeSource(com.google.cloudbuild.v1.Source value) {
      if (sourceBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && source_ != null
            && source_ != com.google.cloudbuild.v1.Source.getDefaultInstance()) {
          getSourceBuilder().mergeFrom(value);
        } else {
          source_ = value;
        }
      } else {
        sourceBuilder_.mergeFrom(value);
      }
      if (source_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public Builder clearSource() {
      bitField0_ = (bitField0_ & ~0x00000020);
      source_ = null;
      if (sourceBuilder_ != null) {
        sourceBuilder_.dispose();
        sourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public com.google.cloudbuild.v1.Source.Builder getSourceBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    public com.google.cloudbuild.v1.SourceOrBuilder getSourceOrBuilder() {
      if (sourceBuilder_ != null) {
        return sourceBuilder_.getMessageOrBuilder();
      } else {
        return source_ == null ? com.google.cloudbuild.v1.Source.getDefaultInstance() : source_;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the source files to build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Source source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Source,
            com.google.cloudbuild.v1.Source.Builder,
            com.google.cloudbuild.v1.SourceOrBuilder>
        getSourceFieldBuilder() {
      if (sourceBuilder_ == null) {
        sourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Source,
                com.google.cloudbuild.v1.Source.Builder,
                com.google.cloudbuild.v1.SourceOrBuilder>(
                getSource(), getParentForChildren(), isClean());
        source_ = null;
      }
      return sourceBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.BuildStep> steps_ =
        java.util.Collections.emptyList();

    private void ensureStepsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        steps_ = new java.util.ArrayList<com.google.cloudbuild.v1.BuildStep>(steps_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuildStep,
            com.google.cloudbuild.v1.BuildStep.Builder,
            com.google.cloudbuild.v1.BuildStepOrBuilder>
        stepsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuildStep> getStepsList() {
      if (stepsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(steps_);
      } else {
        return stepsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public int getStepsCount() {
      if (stepsBuilder_ == null) {
        return steps_.size();
      } else {
        return stepsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep getSteps(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder setSteps(int index, com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.set(index, value);
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder setSteps(int index, com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.set(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(int index, com.google.cloudbuild.v1.BuildStep value) {
      if (stepsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStepsIsMutable();
        steps_.add(index, value);
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addSteps(int index, com.google.cloudbuild.v1.BuildStep.Builder builderForValue) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.add(index, builderForValue.build());
        onChanged();
      } else {
        stepsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder addAllSteps(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.BuildStep> values) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, steps_);
        onChanged();
      } else {
        stepsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder clearSteps() {
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        stepsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public Builder removeSteps(int index) {
      if (stepsBuilder_ == null) {
        ensureStepsIsMutable();
        steps_.remove(index);
        onChanged();
      } else {
        stepsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder getStepsBuilder(int index) {
      return getStepsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStepOrBuilder getStepsOrBuilder(int index) {
      if (stepsBuilder_ == null) {
        return steps_.get(index);
      } else {
        return stepsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.BuildStepOrBuilder>
        getStepsOrBuilderList() {
      if (stepsBuilder_ != null) {
        return stepsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(steps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder addStepsBuilder() {
      return getStepsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.BuildStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public com.google.cloudbuild.v1.BuildStep.Builder addStepsBuilder(int index) {
      return getStepsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.BuildStep.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The operations to be performed on the workspace.
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.BuildStep steps = 11;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.BuildStep.Builder> getStepsBuilderList() {
      return getStepsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.BuildStep,
            com.google.cloudbuild.v1.BuildStep.Builder,
            com.google.cloudbuild.v1.BuildStepOrBuilder>
        getStepsFieldBuilder() {
      if (stepsBuilder_ == null) {
        stepsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.BuildStep,
                com.google.cloudbuild.v1.BuildStep.Builder,
                com.google.cloudbuild.v1.BuildStepOrBuilder>(
                steps_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        steps_ = null;
      }
      return stepsBuilder_;
    }

    private com.google.cloudbuild.v1.Results results_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Results,
            com.google.cloudbuild.v1.Results.Builder,
            com.google.cloudbuild.v1.ResultsOrBuilder>
        resultsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the results field is set.
     */
    public boolean hasResults() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The results.
     */
    public com.google.cloudbuild.v1.Results getResults() {
      if (resultsBuilder_ == null) {
        return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
      } else {
        return resultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResults(com.google.cloudbuild.v1.Results value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        results_ = value;
      } else {
        resultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResults(com.google.cloudbuild.v1.Results.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        results_ = builderForValue.build();
      } else {
        resultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResults(com.google.cloudbuild.v1.Results value) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && results_ != null
            && results_ != com.google.cloudbuild.v1.Results.getDefaultInstance()) {
          getResultsBuilder().mergeFrom(value);
        } else {
          results_ = value;
        }
      } else {
        resultsBuilder_.mergeFrom(value);
      }
      if (results_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResults() {
      bitField0_ = (bitField0_ & ~0x00000080);
      results_ = null;
      if (resultsBuilder_ != null) {
        resultsBuilder_.dispose();
        resultsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Results.Builder getResultsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.ResultsOrBuilder getResultsOrBuilder() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilder();
      } else {
        return results_ == null ? com.google.cloudbuild.v1.Results.getDefaultInstance() : results_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Results of the build.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Results results = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Results,
            com.google.cloudbuild.v1.Results.Builder,
            com.google.cloudbuild.v1.ResultsOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Results,
                com.google.cloudbuild.v1.Results.Builder,
                com.google.cloudbuild.v1.ResultsOrBuilder>(
                getResults(), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the request to create the build was received.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the finishTime field is set.
     */
    public boolean hasFinishTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finishTime.
     */
    public com.google.protobuf.Timestamp getFinishTime() {
      if (finishTimeBuilder_ == null) {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      } else {
        return finishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishTime_ = value;
      } else {
        finishTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finishTimeBuilder_ == null) {
        finishTime_ = builderForValue.build();
      } else {
        finishTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && finishTime_ != null
            && finishTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getFinishTimeBuilder().mergeFrom(value);
        } else {
          finishTime_ = value;
        }
      } else {
        finishTimeBuilder_.mergeFrom(value);
      }
      if (finishTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFinishTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getFinishTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getFinishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
      if (finishTimeBuilder_ != null) {
        return finishTimeBuilder_.getMessageOrBuilder();
      } else {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which execution of the build was finished.
     *
     * The difference between finish_time and start_time is the duration of the
     * build's execution.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finish_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinishTimeFieldBuilder() {
      if (finishTimeBuilder_ == null) {
        finishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinishTime(), getParentForChildren(), isClean());
        finishTime_ = null;
      }
      return finishTimeBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000800);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Amount of time that this build should be allowed to run, to second
     * granularity. If this amount of time elapses, work on the build will cease
     * and the build status will be `TIMEOUT`.
     *
     * `timeout` starts ticking from `startTime`.
     *
     * Default time is 60 minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList images_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureImagesIsMutable() {
      if (!images_.isModifiable()) {
        images_ = new com.google.protobuf.LazyStringArrayList(images_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return A list containing the images.
     */
    public com.google.protobuf.ProtocolStringList getImagesList() {
      images_.makeImmutable();
      return images_;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return The count of images.
     */
    public int getImagesCount() {
      return images_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The images at the given index.
     */
    public java.lang.String getImages(int index) {
      return images_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the images at the given index.
     */
    public com.google.protobuf.ByteString getImagesBytes(int index) {
      return images_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The images to set.
     * @return This builder for chaining.
     */
    public Builder setImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param value The images to add.
     * @return This builder for chaining.
     */
    public Builder addImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureImagesIsMutable();
      images_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param values The images to add.
     * @return This builder for chaining.
     */
    public Builder addAllImages(java.lang.Iterable<java.lang.String> values) {
      ensureImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, images_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImages() {
      images_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of images to be pushed upon the successful completion of all build
     * steps.
     *
     * The images are pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the `Build` resource's
     * results field.
     *
     * If any of the images fail to be pushed, the build status is marked
     * `FAILURE`.
     * </pre>
     *
     * <code>repeated string images = 13;</code>
     *
     * @param value The bytes of the images to add.
     * @return This builder for chaining.
     */
    public Builder addImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureImagesIsMutable();
      images_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration queueTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        queueTtlBuilder_;
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     *
     * @return Whether the queueTtl field is set.
     */
    public boolean hasQueueTtl() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     *
     * @return The queueTtl.
     */
    public com.google.protobuf.Duration getQueueTtl() {
      if (queueTtlBuilder_ == null) {
        return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
      } else {
        return queueTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder setQueueTtl(com.google.protobuf.Duration value) {
      if (queueTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queueTtl_ = value;
      } else {
        queueTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder setQueueTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (queueTtlBuilder_ == null) {
        queueTtl_ = builderForValue.build();
      } else {
        queueTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder mergeQueueTtl(com.google.protobuf.Duration value) {
      if (queueTtlBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && queueTtl_ != null
            && queueTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getQueueTtlBuilder().mergeFrom(value);
        } else {
          queueTtl_ = value;
        }
      } else {
        queueTtlBuilder_.mergeFrom(value);
      }
      if (queueTtl_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public Builder clearQueueTtl() {
      bitField0_ = (bitField0_ & ~0x00002000);
      queueTtl_ = null;
      if (queueTtlBuilder_ != null) {
        queueTtlBuilder_.dispose();
        queueTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public com.google.protobuf.Duration.Builder getQueueTtlBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getQueueTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    public com.google.protobuf.DurationOrBuilder getQueueTtlOrBuilder() {
      if (queueTtlBuilder_ != null) {
        return queueTtlBuilder_.getMessageOrBuilder();
      } else {
        return queueTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : queueTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * TTL in queue for this build. If provided and the build is enqueued longer
     * than this value, the build will expire and the build status will be
     * `EXPIRED`.
     *
     * The TTL starts ticking from create_time.
     * </pre>
     *
     * <code>.google.protobuf.Duration queue_ttl = 40;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getQueueTtlFieldBuilder() {
      if (queueTtlBuilder_ == null) {
        queueTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getQueueTtl(), getParentForChildren(), isClean());
        queueTtl_ = null;
      }
      return queueTtlBuilder_;
    }

    private com.google.cloudbuild.v1.Artifacts artifacts_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts,
            com.google.cloudbuild.v1.Artifacts.Builder,
            com.google.cloudbuild.v1.ArtifactsOrBuilder>
        artifactsBuilder_;
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     *
     * @return Whether the artifacts field is set.
     */
    public boolean hasArtifacts() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     *
     * @return The artifacts.
     */
    public com.google.cloudbuild.v1.Artifacts getArtifacts() {
      if (artifactsBuilder_ == null) {
        return artifacts_ == null
            ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
            : artifacts_;
      } else {
        return artifactsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder setArtifacts(com.google.cloudbuild.v1.Artifacts value) {
      if (artifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        artifacts_ = value;
      } else {
        artifactsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder setArtifacts(com.google.cloudbuild.v1.Artifacts.Builder builderForValue) {
      if (artifactsBuilder_ == null) {
        artifacts_ = builderForValue.build();
      } else {
        artifactsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder mergeArtifacts(com.google.cloudbuild.v1.Artifacts value) {
      if (artifactsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && artifacts_ != null
            && artifacts_ != com.google.cloudbuild.v1.Artifacts.getDefaultInstance()) {
          getArtifactsBuilder().mergeFrom(value);
        } else {
          artifacts_ = value;
        }
      } else {
        artifactsBuilder_.mergeFrom(value);
      }
      if (artifacts_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public Builder clearArtifacts() {
      bitField0_ = (bitField0_ & ~0x00004000);
      artifacts_ = null;
      if (artifactsBuilder_ != null) {
        artifactsBuilder_.dispose();
        artifactsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public com.google.cloudbuild.v1.Artifacts.Builder getArtifactsBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getArtifactsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    public com.google.cloudbuild.v1.ArtifactsOrBuilder getArtifactsOrBuilder() {
      if (artifactsBuilder_ != null) {
        return artifactsBuilder_.getMessageOrBuilder();
      } else {
        return artifacts_ == null
            ? com.google.cloudbuild.v1.Artifacts.getDefaultInstance()
            : artifacts_;
      }
    }
    /**
     *
     *
     * <pre>
     * Artifacts produced by the build that should be uploaded upon
     * successful completion of all build steps.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Artifacts artifacts = 37;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Artifacts,
            com.google.cloudbuild.v1.Artifacts.Builder,
            com.google.cloudbuild.v1.ArtifactsOrBuilder>
        getArtifactsFieldBuilder() {
      if (artifactsBuilder_ == null) {
        artifactsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Artifacts,
                com.google.cloudbuild.v1.Artifacts.Builder,
                com.google.cloudbuild.v1.ArtifactsOrBuilder>(
                getArtifacts(), getParentForChildren(), isClean());
        artifacts_ = null;
      }
      return artifactsBuilder_;
    }

    private java.lang.Object logsBucket_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return The logsBucket.
     */
    public java.lang.String getLogsBucket() {
      java.lang.Object ref = logsBucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logsBucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return The bytes for logsBucket.
     */
    public com.google.protobuf.ByteString getLogsBucketBytes() {
      java.lang.Object ref = logsBucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logsBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @param value The logsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logsBucket_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogsBucket() {
      logsBucket_ = getDefaultInstance().getLogsBucket();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage bucket where logs should be written (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     * Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
     * </pre>
     *
     * <code>string logs_bucket = 19;</code>
     *
     * @param value The bytes for logsBucket to set.
     * @return This builder for chaining.
     */
    public Builder setLogsBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logsBucket_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.SourceProvenance sourceProvenance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.SourceProvenance,
            com.google.cloudbuild.v1.SourceProvenance.Builder,
            com.google.cloudbuild.v1.SourceProvenanceOrBuilder>
        sourceProvenanceBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the sourceProvenance field is set.
     */
    public boolean hasSourceProvenance() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourceProvenance.
     */
    public com.google.cloudbuild.v1.SourceProvenance getSourceProvenance() {
      if (sourceProvenanceBuilder_ == null) {
        return sourceProvenance_ == null
            ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      } else {
        return sourceProvenanceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(com.google.cloudbuild.v1.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceProvenance_ = value;
      } else {
        sourceProvenanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSourceProvenance(
        com.google.cloudbuild.v1.SourceProvenance.Builder builderForValue) {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenance_ = builderForValue.build();
      } else {
        sourceProvenanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSourceProvenance(com.google.cloudbuild.v1.SourceProvenance value) {
      if (sourceProvenanceBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && sourceProvenance_ != null
            && sourceProvenance_
                != com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()) {
          getSourceProvenanceBuilder().mergeFrom(value);
        } else {
          sourceProvenance_ = value;
        }
      } else {
        sourceProvenanceBuilder_.mergeFrom(value);
      }
      if (sourceProvenance_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSourceProvenance() {
      bitField0_ = (bitField0_ & ~0x00010000);
      sourceProvenance_ = null;
      if (sourceProvenanceBuilder_ != null) {
        sourceProvenanceBuilder_.dispose();
        sourceProvenanceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.SourceProvenance.Builder getSourceProvenanceBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getSourceProvenanceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.SourceProvenanceOrBuilder getSourceProvenanceOrBuilder() {
      if (sourceProvenanceBuilder_ != null) {
        return sourceProvenanceBuilder_.getMessageOrBuilder();
      } else {
        return sourceProvenance_ == null
            ? com.google.cloudbuild.v1.SourceProvenance.getDefaultInstance()
            : sourceProvenance_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A permanent fixed identifier for source.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.SourceProvenance source_provenance = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.SourceProvenance,
            com.google.cloudbuild.v1.SourceProvenance.Builder,
            com.google.cloudbuild.v1.SourceProvenanceOrBuilder>
        getSourceProvenanceFieldBuilder() {
      if (sourceProvenanceBuilder_ == null) {
        sourceProvenanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.SourceProvenance,
                com.google.cloudbuild.v1.SourceProvenance.Builder,
                com.google.cloudbuild.v1.SourceProvenanceOrBuilder>(
                getSourceProvenance(), getParentForChildren(), isClean());
        sourceProvenance_ = null;
      }
      return sourceProvenanceBuilder_;
    }

    private java.lang.Object buildTriggerId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The buildTriggerId.
     */
    public java.lang.String getBuildTriggerId() {
      java.lang.Object ref = buildTriggerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildTriggerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for buildTriggerId.
     */
    public com.google.protobuf.ByteString getBuildTriggerIdBytes() {
      java.lang.Object ref = buildTriggerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildTriggerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The buildTriggerId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildTriggerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildTriggerId_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildTriggerId() {
      buildTriggerId_ = getDefaultInstance().getBuildTriggerId();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the `BuildTrigger` that triggered this build, if it
     * was triggered automatically.
     * </pre>
     *
     * <code>string build_trigger_id = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for buildTriggerId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildTriggerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildTriggerId_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.BuildOptions options_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildOptions,
            com.google.cloudbuild.v1.BuildOptions.Builder,
            com.google.cloudbuild.v1.BuildOptionsOrBuilder>
        optionsBuilder_;
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     *
     * @return Whether the options field is set.
     */
    public boolean hasOptions() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     *
     * @return The options.
     */
    public com.google.cloudbuild.v1.BuildOptions getOptions() {
      if (optionsBuilder_ == null) {
        return options_ == null
            ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()
            : options_;
      } else {
        return optionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder setOptions(com.google.cloudbuild.v1.BuildOptions value) {
      if (optionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
      } else {
        optionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder setOptions(com.google.cloudbuild.v1.BuildOptions.Builder builderForValue) {
      if (optionsBuilder_ == null) {
        options_ = builderForValue.build();
      } else {
        optionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder mergeOptions(com.google.cloudbuild.v1.BuildOptions value) {
      if (optionsBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && options_ != null
            && options_ != com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()) {
          getOptionsBuilder().mergeFrom(value);
        } else {
          options_ = value;
        }
      } else {
        optionsBuilder_.mergeFrom(value);
      }
      if (options_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public Builder clearOptions() {
      bitField0_ = (bitField0_ & ~0x00040000);
      options_ = null;
      if (optionsBuilder_ != null) {
        optionsBuilder_.dispose();
        optionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public com.google.cloudbuild.v1.BuildOptions.Builder getOptionsBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    public com.google.cloudbuild.v1.BuildOptionsOrBuilder getOptionsOrBuilder() {
      if (optionsBuilder_ != null) {
        return optionsBuilder_.getMessageOrBuilder();
      } else {
        return options_ == null
            ? com.google.cloudbuild.v1.BuildOptions.getDefaultInstance()
            : options_;
      }
    }
    /**
     *
     *
     * <pre>
     * Special options for this build.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.BuildOptions options = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildOptions,
            com.google.cloudbuild.v1.BuildOptions.Builder,
            com.google.cloudbuild.v1.BuildOptionsOrBuilder>
        getOptionsFieldBuilder() {
      if (optionsBuilder_ == null) {
        optionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.BuildOptions,
                com.google.cloudbuild.v1.BuildOptions.Builder,
                com.google.cloudbuild.v1.BuildOptionsOrBuilder>(
                getOptions(), getParentForChildren(), isClean());
        options_ = null;
      }
      return optionsBuilder_;
    }

    private java.lang.Object logUrl_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The logUrl.
     */
    public java.lang.String getLogUrl() {
      java.lang.Object ref = logUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for logUrl.
     */
    public com.google.protobuf.ByteString getLogUrlBytes() {
      java.lang.Object ref = logUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The logUrl to set.
     * @return This builder for chaining.
     */
    public Builder setLogUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logUrl_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogUrl() {
      logUrl_ = getDefaultInstance().getLogUrl();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URL to logs for this build in Google Cloud Console.
     * </pre>
     *
     * <code>string log_url = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for logUrl to set.
     * @return This builder for chaining.
     */
    public Builder setLogUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logUrl_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> substitutions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSubstitutions() {
      if (substitutions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      return substitutions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSubstitutions() {
      if (substitutions_ == null) {
        substitutions_ =
            com.google.protobuf.MapField.newMapField(SubstitutionsDefaultEntryHolder.defaultEntry);
      }
      if (!substitutions_.isMutable()) {
        substitutions_ = substitutions_.copy();
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return substitutions_;
    }

    public int getSubstitutionsCount() {
      return internalGetSubstitutions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public boolean containsSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSubstitutions().getMap().containsKey(key);
    }
    /** Use {@link #getSubstitutionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
      return getSubstitutionsMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSubstitutionsMap() {
      return internalGetSubstitutions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSubstitutionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    @java.lang.Override
    public java.lang.String getSubstitutionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSubstitutions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSubstitutions() {
      bitField0_ = (bitField0_ & ~0x00100000);
      internalGetMutableSubstitutions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder removeSubstitutions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSubstitutions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSubstitutions() {
      bitField0_ |= 0x00100000;
      return internalGetMutableSubstitutions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder putSubstitutions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSubstitutions().getMutableMap().put(key, value);
      bitField0_ |= 0x00100000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Substitutions data for `Build` resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; substitutions = 29;</code>
     */
    public Builder putAllSubstitutions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSubstitutions().getMutableMap().putAll(values);
      bitField0_ |= 0x00100000;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00200000;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00200000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tags for annotation of a `Build`. These are not docker tags.
     * </pre>
     *
     * <code>repeated string tags = 31;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloudbuild.v1.Secret> secrets_ =
        java.util.Collections.emptyList();

    private void ensureSecretsIsMutable() {
      if (!((bitField0_ & 0x00400000) != 0)) {
        secrets_ = new java.util.ArrayList<com.google.cloudbuild.v1.Secret>(secrets_);
        bitField0_ |= 0x00400000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Secret,
            com.google.cloudbuild.v1.Secret.Builder,
            com.google.cloudbuild.v1.SecretOrBuilder>
        secretsBuilder_;

    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Secret> getSecretsList() {
      if (secretsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secrets_);
      } else {
        return secretsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public int getSecretsCount() {
      if (secretsBuilder_ == null) {
        return secrets_.size();
      } else {
        return secretsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret getSecrets(int index) {
      if (secretsBuilder_ == null) {
        return secrets_.get(index);
      } else {
        return secretsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder setSecrets(int index, com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.set(index, value);
        onChanged();
      } else {
        secretsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder setSecrets(int index, com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.add(value);
        onChanged();
      } else {
        secretsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(int index, com.google.cloudbuild.v1.Secret value) {
      if (secretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretsIsMutable();
        secrets_.add(index, value);
        onChanged();
      } else {
        secretsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.add(builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addSecrets(int index, com.google.cloudbuild.v1.Secret.Builder builderForValue) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder addAllSecrets(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Secret> values) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secrets_);
        onChanged();
      } else {
        secretsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder clearSecrets() {
      if (secretsBuilder_ == null) {
        secrets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00400000);
        onChanged();
      } else {
        secretsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public Builder removeSecrets(int index) {
      if (secretsBuilder_ == null) {
        ensureSecretsIsMutable();
        secrets_.remove(index);
        onChanged();
      } else {
        secretsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder getSecretsBuilder(int index) {
      return getSecretsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.SecretOrBuilder getSecretsOrBuilder(int index) {
      if (secretsBuilder_ == null) {
        return secrets_.get(index);
      } else {
        return secretsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.SecretOrBuilder>
        getSecretsOrBuilderList() {
      if (secretsBuilder_ != null) {
        return secretsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secrets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder addSecretsBuilder() {
      return getSecretsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Secret.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public com.google.cloudbuild.v1.Secret.Builder addSecretsBuilder(int index) {
      return getSecretsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Secret.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secrets to decrypt using Cloud Key Management Service.
     * Note: Secret Manager is the recommended technique
     * for managing sensitive data with Cloud Build. Use `available_secrets` to
     * configure builds to access secrets from Secret Manager. For instructions,
     * see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
     * </pre>
     *
     * <code>repeated .google.devtools.cloudbuild.v1.Secret secrets = 32;</code>
     */
    public java.util.List<com.google.cloudbuild.v1.Secret.Builder> getSecretsBuilderList() {
      return getSecretsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Secret,
            com.google.cloudbuild.v1.Secret.Builder,
            com.google.cloudbuild.v1.SecretOrBuilder>
        getSecretsFieldBuilder() {
      if (secretsBuilder_ == null) {
        secretsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Secret,
                com.google.cloudbuild.v1.Secret.Builder,
                com.google.cloudbuild.v1.SecretOrBuilder>(
                secrets_, ((bitField0_ & 0x00400000) != 0), getParentForChildren(), isClean());
        secrets_ = null;
      }
      return secretsBuilder_;
    }

    private static final class TimingConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloudbuild.v1.TimeSpanOrBuilder,
            com.google.cloudbuild.v1.TimeSpan> {
      @java.lang.Override
      public com.google.cloudbuild.v1.TimeSpan build(
          com.google.cloudbuild.v1.TimeSpanOrBuilder val) {
        if (val instanceof com.google.cloudbuild.v1.TimeSpan) {
          return (com.google.cloudbuild.v1.TimeSpan) val;
        }
        return ((com.google.cloudbuild.v1.TimeSpan.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.cloudbuild.v1.TimeSpan>
          defaultEntry() {
        return TimingDefaultEntryHolder.defaultEntry;
      }
    };

    private static final TimingConverter timingConverter = new TimingConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloudbuild.v1.TimeSpanOrBuilder,
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder>
        timing_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloudbuild.v1.TimeSpanOrBuilder,
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder>
        internalGetTiming() {
      if (timing_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(timingConverter);
      }
      return timing_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloudbuild.v1.TimeSpanOrBuilder,
            com.google.cloudbuild.v1.TimeSpan,
            com.google.cloudbuild.v1.TimeSpan.Builder>
        internalGetMutableTiming() {
      if (timing_ == null) {
        timing_ = new com.google.protobuf.MapFieldBuilder<>(timingConverter);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return timing_;
    }

    public int getTimingCount() {
      return internalGetTiming().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsTiming(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTiming().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getTimingMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTiming() {
      return getTimingMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getTimingMap() {
      return internalGetTiming().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloudbuild.v1.TimeSpan getTimingOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloudbuild.v1.TimeSpan defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpanOrBuilder> map =
          internalGetMutableTiming().ensureBuilderMap();
      return map.containsKey(key) ? timingConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.TimeSpan getTimingOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpanOrBuilder> map =
          internalGetMutableTiming().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return timingConverter.build(map.get(key));
    }

    public Builder clearTiming() {
      bitField0_ = (bitField0_ & ~0x00800000);
      internalGetMutableTiming().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTiming(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTiming().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> getMutableTiming() {
      bitField0_ |= 0x00800000;
      return internalGetMutableTiming().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putTiming(java.lang.String key, com.google.cloudbuild.v1.TimeSpan value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTiming().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00800000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllTiming(
        java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpan> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloudbuild.v1.TimeSpan> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableTiming().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00800000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Stores timing information for phases of the build. Valid keys
     * are:
     *
     * * BUILD: time to execute all build steps.
     * * PUSH: time to push all artifacts including docker images and non docker
     * artifacts.
     * * FETCHSOURCE: time to fetch source.
     * * SETUPBUILD: time to set up build.
     *
     * If the build does not specify source or images,
     * these keys will not be included.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.devtools.cloudbuild.v1.TimeSpan&gt; timing = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.TimeSpan.Builder putTimingBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloudbuild.v1.TimeSpanOrBuilder> builderMap =
          internalGetMutableTiming().ensureBuilderMap();
      com.google.cloudbuild.v1.TimeSpanOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloudbuild.v1.TimeSpan.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloudbuild.v1.TimeSpan) {
        entry = ((com.google.cloudbuild.v1.TimeSpan) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloudbuild.v1.TimeSpan.Builder) entry;
    }

    private com.google.cloudbuild.v1.BuildApproval approval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildApproval,
            com.google.cloudbuild.v1.BuildApproval.Builder,
            com.google.cloudbuild.v1.BuildApprovalOrBuilder>
        approvalBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the approval field is set.
     */
    public boolean hasApproval() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The approval.
     */
    public com.google.cloudbuild.v1.BuildApproval getApproval() {
      if (approvalBuilder_ == null) {
        return approval_ == null
            ? com.google.cloudbuild.v1.BuildApproval.getDefaultInstance()
            : approval_;
      } else {
        return approvalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproval(com.google.cloudbuild.v1.BuildApproval value) {
      if (approvalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approval_ = value;
      } else {
        approvalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setApproval(com.google.cloudbuild.v1.BuildApproval.Builder builderForValue) {
      if (approvalBuilder_ == null) {
        approval_ = builderForValue.build();
      } else {
        approvalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeApproval(com.google.cloudbuild.v1.BuildApproval value) {
      if (approvalBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && approval_ != null
            && approval_ != com.google.cloudbuild.v1.BuildApproval.getDefaultInstance()) {
          getApprovalBuilder().mergeFrom(value);
        } else {
          approval_ = value;
        }
      } else {
        approvalBuilder_.mergeFrom(value);
      }
      if (approval_ != null) {
        bitField0_ |= 0x01000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearApproval() {
      bitField0_ = (bitField0_ & ~0x01000000);
      approval_ = null;
      if (approvalBuilder_ != null) {
        approvalBuilder_.dispose();
        approvalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.BuildApproval.Builder getApprovalBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getApprovalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.BuildApprovalOrBuilder getApprovalOrBuilder() {
      if (approvalBuilder_ != null) {
        return approvalBuilder_.getMessageOrBuilder();
      } else {
        return approval_ == null
            ? com.google.cloudbuild.v1.BuildApproval.getDefaultInstance()
            : approval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes this build's approval configuration, status,
     * and result.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.BuildApproval approval = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.BuildApproval,
            com.google.cloudbuild.v1.BuildApproval.Builder,
            com.google.cloudbuild.v1.BuildApprovalOrBuilder>
        getApprovalFieldBuilder() {
      if (approvalBuilder_ == null) {
        approvalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.BuildApproval,
                com.google.cloudbuild.v1.BuildApproval.Builder,
                com.google.cloudbuild.v1.BuildApprovalOrBuilder>(
                getApproval(), getParentForChildren(), isClean());
        approval_ = null;
      }
      return approvalBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IAM service account whose credentials will be used at build runtime.
     * Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
     * ACCOUNT can be email address or uniqueId of the service account.
     * </pre>
     *
     * <code>string service_account = 42 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private com.google.cloudbuild.v1.Secrets availableSecrets_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Secrets,
            com.google.cloudbuild.v1.Secrets.Builder,
            com.google.cloudbuild.v1.SecretsOrBuilder>
        availableSecretsBuilder_;
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     *
     * @return Whether the availableSecrets field is set.
     */
    public boolean hasAvailableSecrets() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     *
     * @return The availableSecrets.
     */
    public com.google.cloudbuild.v1.Secrets getAvailableSecrets() {
      if (availableSecretsBuilder_ == null) {
        return availableSecrets_ == null
            ? com.google.cloudbuild.v1.Secrets.getDefaultInstance()
            : availableSecrets_;
      } else {
        return availableSecretsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public Builder setAvailableSecrets(com.google.cloudbuild.v1.Secrets value) {
      if (availableSecretsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        availableSecrets_ = value;
      } else {
        availableSecretsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public Builder setAvailableSecrets(com.google.cloudbuild.v1.Secrets.Builder builderForValue) {
      if (availableSecretsBuilder_ == null) {
        availableSecrets_ = builderForValue.build();
      } else {
        availableSecretsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public Builder mergeAvailableSecrets(com.google.cloudbuild.v1.Secrets value) {
      if (availableSecretsBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && availableSecrets_ != null
            && availableSecrets_ != com.google.cloudbuild.v1.Secrets.getDefaultInstance()) {
          getAvailableSecretsBuilder().mergeFrom(value);
        } else {
          availableSecrets_ = value;
        }
      } else {
        availableSecretsBuilder_.mergeFrom(value);
      }
      if (availableSecrets_ != null) {
        bitField0_ |= 0x04000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public Builder clearAvailableSecrets() {
      bitField0_ = (bitField0_ & ~0x04000000);
      availableSecrets_ = null;
      if (availableSecretsBuilder_ != null) {
        availableSecretsBuilder_.dispose();
        availableSecretsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public com.google.cloudbuild.v1.Secrets.Builder getAvailableSecretsBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getAvailableSecretsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    public com.google.cloudbuild.v1.SecretsOrBuilder getAvailableSecretsOrBuilder() {
      if (availableSecretsBuilder_ != null) {
        return availableSecretsBuilder_.getMessageOrBuilder();
      } else {
        return availableSecrets_ == null
            ? com.google.cloudbuild.v1.Secrets.getDefaultInstance()
            : availableSecrets_;
      }
    }
    /**
     *
     *
     * <pre>
     * Secrets and secret environment variables.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.Secrets available_secrets = 47;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Secrets,
            com.google.cloudbuild.v1.Secrets.Builder,
            com.google.cloudbuild.v1.SecretsOrBuilder>
        getAvailableSecretsFieldBuilder() {
      if (availableSecretsBuilder_ == null) {
        availableSecretsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Secrets,
                com.google.cloudbuild.v1.Secrets.Builder,
                com.google.cloudbuild.v1.SecretsOrBuilder>(
                getAvailableSecrets(), getParentForChildren(), isClean());
        availableSecrets_ = null;
      }
      return availableSecretsBuilder_;
    }

    private java.util.List<com.google.cloudbuild.v1.Build.Warning> warnings_ =
        java.util.Collections.emptyList();

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x08000000) != 0)) {
        warnings_ = new java.util.ArrayList<com.google.cloudbuild.v1.Build.Warning>(warnings_);
        bitField0_ |= 0x08000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Build.Warning,
            com.google.cloudbuild.v1.Build.Warning.Builder,
            com.google.cloudbuild.v1.Build.WarningOrBuilder>
        warningsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Build.Warning> getWarningsList() {
      if (warningsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warnings_);
      } else {
        return warningsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getWarningsCount() {
      if (warningsBuilder_ == null) {
        return warnings_.size();
      } else {
        return warningsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.Warning getWarnings(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWarnings(int index, com.google.cloudbuild.v1.Build.Warning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWarnings(
        int index, com.google.cloudbuild.v1.Build.Warning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(com.google.cloudbuild.v1.Build.Warning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(int index, com.google.cloudbuild.v1.Build.Warning value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(index, value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(com.google.cloudbuild.v1.Build.Warning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(
        int index, com.google.cloudbuild.v1.Build.Warning.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllWarnings(
        java.lang.Iterable<? extends com.google.cloudbuild.v1.Build.Warning> values) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        onChanged();
      } else {
        warningsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearWarnings() {
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x08000000);
        onChanged();
      } else {
        warningsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeWarnings(int index) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.remove(index);
        onChanged();
      } else {
        warningsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.Warning.Builder getWarningsBuilder(int index) {
      return getWarningsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.WarningOrBuilder getWarningsOrBuilder(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloudbuild.v1.Build.WarningOrBuilder>
        getWarningsOrBuilderList() {
      if (warningsBuilder_ != null) {
        return warningsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warnings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.Warning.Builder addWarningsBuilder() {
      return getWarningsFieldBuilder()
          .addBuilder(com.google.cloudbuild.v1.Build.Warning.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.Warning.Builder addWarningsBuilder(int index) {
      return getWarningsFieldBuilder()
          .addBuilder(index, com.google.cloudbuild.v1.Build.Warning.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Non-fatal problems encountered during the execution of the
     * build.
     * </pre>
     *
     * <code>
     * repeated .google.devtools.cloudbuild.v1.Build.Warning warnings = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloudbuild.v1.Build.Warning.Builder> getWarningsBuilderList() {
      return getWarningsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloudbuild.v1.Build.Warning,
            com.google.cloudbuild.v1.Build.Warning.Builder,
            com.google.cloudbuild.v1.Build.WarningOrBuilder>
        getWarningsFieldBuilder() {
      if (warningsBuilder_ == null) {
        warningsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloudbuild.v1.Build.Warning,
                com.google.cloudbuild.v1.Build.Warning.Builder,
                com.google.cloudbuild.v1.Build.WarningOrBuilder>(
                warnings_, ((bitField0_ & 0x08000000) != 0), getParentForChildren(), isClean());
        warnings_ = null;
      }
      return warningsBuilder_;
    }

    private com.google.cloudbuild.v1.Build.FailureInfo failureInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build.FailureInfo,
            com.google.cloudbuild.v1.Build.FailureInfo.Builder,
            com.google.cloudbuild.v1.Build.FailureInfoOrBuilder>
        failureInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the failureInfo field is set.
     */
    public boolean hasFailureInfo() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureInfo.
     */
    public com.google.cloudbuild.v1.Build.FailureInfo getFailureInfo() {
      if (failureInfoBuilder_ == null) {
        return failureInfo_ == null
            ? com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()
            : failureInfo_;
      } else {
        return failureInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureInfo(com.google.cloudbuild.v1.Build.FailureInfo value) {
      if (failureInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        failureInfo_ = value;
      } else {
        failureInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFailureInfo(
        com.google.cloudbuild.v1.Build.FailureInfo.Builder builderForValue) {
      if (failureInfoBuilder_ == null) {
        failureInfo_ = builderForValue.build();
      } else {
        failureInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFailureInfo(com.google.cloudbuild.v1.Build.FailureInfo value) {
      if (failureInfoBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && failureInfo_ != null
            && failureInfo_ != com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()) {
          getFailureInfoBuilder().mergeFrom(value);
        } else {
          failureInfo_ = value;
        }
      } else {
        failureInfoBuilder_.mergeFrom(value);
      }
      if (failureInfo_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFailureInfo() {
      bitField0_ = (bitField0_ & ~0x10000000);
      failureInfo_ = null;
      if (failureInfoBuilder_ != null) {
        failureInfoBuilder_.dispose();
        failureInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.FailureInfo.Builder getFailureInfoBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getFailureInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloudbuild.v1.Build.FailureInfoOrBuilder getFailureInfoOrBuilder() {
      if (failureInfoBuilder_ != null) {
        return failureInfoBuilder_.getMessageOrBuilder();
      } else {
        return failureInfo_ == null
            ? com.google.cloudbuild.v1.Build.FailureInfo.getDefaultInstance()
            : failureInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Contains information about the build when status=FAILURE.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudbuild.v1.Build.FailureInfo failure_info = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloudbuild.v1.Build.FailureInfo,
            com.google.cloudbuild.v1.Build.FailureInfo.Builder,
            com.google.cloudbuild.v1.Build.FailureInfoOrBuilder>
        getFailureInfoFieldBuilder() {
      if (failureInfoBuilder_ == null) {
        failureInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloudbuild.v1.Build.FailureInfo,
                com.google.cloudbuild.v1.Build.FailureInfo.Builder,
                com.google.cloudbuild.v1.Build.FailureInfoOrBuilder>(
                getFailureInfo(), getParentForChildren(), isClean());
        failureInfo_ = null;
      }
      return failureInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.Build)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.Build)
  private static final com.google.cloudbuild.v1.Build DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.Build();
  }

  public static com.google.cloudbuild.v1.Build getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Build> PARSER =
      new com.google.protobuf.AbstractParser<Build>() {
        @java.lang.Override
        public Build parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Build> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Build> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.Build getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
