/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

// Protobuf Java Version: 3.25.2
package com.google.cloudbuild.v1;

/**
 *
 *
 * <pre>
 * GitFileSource describes a file within a (possibly remote) code repository.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudbuild.v1.GitFileSource}
 */
public final class GitFileSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudbuild.v1.GitFileSource)
    GitFileSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GitFileSource.newBuilder() to construct.
  private GitFileSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GitFileSource() {
    path_ = "";
    uri_ = "";
    repoType_ = 0;
    revision_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GitFileSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitFileSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloudbuild.v1.Cloudbuild
        .internal_static_google_devtools_cloudbuild_v1_GitFileSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloudbuild.v1.GitFileSource.class,
            com.google.cloudbuild.v1.GitFileSource.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the repo, since it may not be explicit from the `repo` field
   * (e.g from a URL).
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudbuild.v1.GitFileSource.RepoType}
   */
  public enum RepoType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default, unknown repo type. Don't use it, instead use one of
     * the other repo types.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * A Google Cloud Source Repositories-hosted repo.
     * </pre>
     *
     * <code>CLOUD_SOURCE_REPOSITORIES = 1;</code>
     */
    CLOUD_SOURCE_REPOSITORIES(1),
    /**
     *
     *
     * <pre>
     * A GitHub-hosted repo not necessarily on "github.com" (i.e. GitHub
     * Enterprise).
     * </pre>
     *
     * <code>GITHUB = 2;</code>
     */
    GITHUB(2),
    /**
     *
     *
     * <pre>
     * A Bitbucket Server-hosted repo.
     * </pre>
     *
     * <code>BITBUCKET_SERVER = 3;</code>
     */
    BITBUCKET_SERVER(3),
    /**
     *
     *
     * <pre>
     * A GitLab-hosted repo.
     * </pre>
     *
     * <code>GITLAB = 4;</code>
     */
    GITLAB(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default, unknown repo type. Don't use it, instead use one of
     * the other repo types.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A Google Cloud Source Repositories-hosted repo.
     * </pre>
     *
     * <code>CLOUD_SOURCE_REPOSITORIES = 1;</code>
     */
    public static final int CLOUD_SOURCE_REPOSITORIES_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A GitHub-hosted repo not necessarily on "github.com" (i.e. GitHub
     * Enterprise).
     * </pre>
     *
     * <code>GITHUB = 2;</code>
     */
    public static final int GITHUB_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A Bitbucket Server-hosted repo.
     * </pre>
     *
     * <code>BITBUCKET_SERVER = 3;</code>
     */
    public static final int BITBUCKET_SERVER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A GitLab-hosted repo.
     * </pre>
     *
     * <code>GITLAB = 4;</code>
     */
    public static final int GITLAB_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RepoType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RepoType forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return CLOUD_SOURCE_REPOSITORIES;
        case 2:
          return GITHUB;
        case 3:
          return BITBUCKET_SERVER;
        case 4:
          return GITLAB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RepoType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RepoType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RepoType>() {
          public RepoType findValueByNumber(int number) {
            return RepoType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloudbuild.v1.GitFileSource.getDescriptor().getEnumTypes().get(0);
    }

    private static final RepoType[] VALUES = values();

    public static RepoType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RepoType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudbuild.v1.GitFileSource.RepoType)
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    REPOSITORY(7),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 7:
          return REPOSITORY;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  private int enterpriseConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object enterpriseConfig_;

  public enum EnterpriseConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GITHUB_ENTERPRISE_CONFIG(5),
    ENTERPRISECONFIG_NOT_SET(0);
    private final int value;

    private EnterpriseConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EnterpriseConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static EnterpriseConfigCase forNumber(int value) {
      switch (value) {
        case 5:
          return GITHUB_ENTERPRISE_CONFIG;
        case 0:
          return ENTERPRISECONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EnterpriseConfigCase getEnterpriseConfigCase() {
    return EnterpriseConfigCase.forNumber(enterpriseConfigCase_);
  }

  public static final int PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object path_ = "";
  /**
   *
   *
   * <pre>
   * The path of the file, with the repo root as the root of the path.
   * </pre>
   *
   * <code>string path = 1;</code>
   *
   * @return The path.
   */
  @java.lang.Override
  public java.lang.String getPath() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The path of the file, with the repo root as the root of the path.
   * </pre>
   *
   * <code>string path = 1;</code>
   *
   * @return The bytes for path.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathBytes() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      path_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of the repo.
   * Either uri or repository can be specified.
   * If unspecified, the repo from which the trigger invocation originated is
   * assumed to be the repo from which to read the specified path.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of the repo.
   * Either uri or repository can be specified.
   * If unspecified, the repo from which the trigger invocation originated is
   * assumed to be the repo from which to read the specified path.
   * </pre>
   *
   * <code>string uri = 2;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPOSITORY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of the Repos API repository.
   * Either URI or repository can be specified.
   * If unspecified, the repo from which the trigger invocation originated is
   * assumed to be the repo from which to read the specified path.
   * </pre>
   *
   * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the repository field is set.
   */
  public boolean hasRepository() {
    return sourceCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of the Repos API repository.
   * Either URI or repository can be specified.
   * If unspecified, the repo from which the trigger invocation originated is
   * assumed to be the repo from which to read the specified path.
   * </pre>
   *
   * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The repository.
   */
  public java.lang.String getRepository() {
    java.lang.Object ref = "";
    if (sourceCase_ == 7) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 7) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The fully qualified resource name of the Repos API repository.
   * Either URI or repository can be specified.
   * If unspecified, the repo from which the trigger invocation originated is
   * assumed to be the repo from which to read the specified path.
   * </pre>
   *
   * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for repository.
   */
  public com.google.protobuf.ByteString getRepositoryBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 7) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 7) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPO_TYPE_FIELD_NUMBER = 3;
  private int repoType_ = 0;
  /**
   *
   *
   * <pre>
   * See RepoType above.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
   *
   * @return The enum numeric value on the wire for repoType.
   */
  @java.lang.Override
  public int getRepoTypeValue() {
    return repoType_;
  }
  /**
   *
   *
   * <pre>
   * See RepoType above.
   * </pre>
   *
   * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
   *
   * @return The repoType.
   */
  @java.lang.Override
  public com.google.cloudbuild.v1.GitFileSource.RepoType getRepoType() {
    com.google.cloudbuild.v1.GitFileSource.RepoType result =
        com.google.cloudbuild.v1.GitFileSource.RepoType.forNumber(repoType_);
    return result == null ? com.google.cloudbuild.v1.GitFileSource.RepoType.UNRECOGNIZED : result;
  }

  public static final int REVISION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revision_ = "";
  /**
   *
   *
   * <pre>
   * The branch, tag, arbitrary ref, or SHA version of the repo to use when
   * resolving the filename (optional).
   * This field respects the same syntax/resolution as described here:
   * https://git-scm.com/docs/gitrevisions
   * If unspecified, the revision from which the trigger invocation originated
   * is assumed to be the revision from which to read the specified path.
   * </pre>
   *
   * <code>string revision = 4;</code>
   *
   * @return The revision.
   */
  @java.lang.Override
  public java.lang.String getRevision() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The branch, tag, arbitrary ref, or SHA version of the repo to use when
   * resolving the filename (optional).
   * This field respects the same syntax/resolution as described here:
   * https://git-scm.com/docs/gitrevisions
   * If unspecified, the revision from which the trigger invocation originated
   * is assumed to be the revision from which to read the specified path.
   * </pre>
   *
   * <code>string revision = 4;</code>
   *
   * @return The bytes for revision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionBytes() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GITHUB_ENTERPRISE_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The full resource name of the github enterprise config.
   * Format:
   * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
   * `projects/{project}/githubEnterpriseConfigs/{id}`.
   * </pre>
   *
   * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the githubEnterpriseConfig field is set.
   */
  public boolean hasGithubEnterpriseConfig() {
    return enterpriseConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The full resource name of the github enterprise config.
   * Format:
   * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
   * `projects/{project}/githubEnterpriseConfigs/{id}`.
   * </pre>
   *
   * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The githubEnterpriseConfig.
   */
  public java.lang.String getGithubEnterpriseConfig() {
    java.lang.Object ref = "";
    if (enterpriseConfigCase_ == 5) {
      ref = enterpriseConfig_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (enterpriseConfigCase_ == 5) {
        enterpriseConfig_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of the github enterprise config.
   * Format:
   * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
   * `projects/{project}/githubEnterpriseConfigs/{id}`.
   * </pre>
   *
   * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for githubEnterpriseConfig.
   */
  public com.google.protobuf.ByteString getGithubEnterpriseConfigBytes() {
    java.lang.Object ref = "";
    if (enterpriseConfigCase_ == 5) {
      ref = enterpriseConfig_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (enterpriseConfigCase_ == 5) {
        enterpriseConfig_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    if (repoType_ != com.google.cloudbuild.v1.GitFileSource.RepoType.UNKNOWN.getNumber()) {
      output.writeEnum(3, repoType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, revision_);
    }
    if (enterpriseConfigCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, enterpriseConfig_);
    }
    if (sourceCase_ == 7) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    if (repoType_ != com.google.cloudbuild.v1.GitFileSource.RepoType.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, repoType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, revision_);
    }
    if (enterpriseConfigCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, enterpriseConfig_);
    }
    if (sourceCase_ == 7) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloudbuild.v1.GitFileSource)) {
      return super.equals(obj);
    }
    com.google.cloudbuild.v1.GitFileSource other = (com.google.cloudbuild.v1.GitFileSource) obj;

    if (!getPath().equals(other.getPath())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (repoType_ != other.repoType_) return false;
    if (!getRevision().equals(other.getRevision())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 7:
        if (!getRepository().equals(other.getRepository())) return false;
        break;
      case 0:
      default:
    }
    if (!getEnterpriseConfigCase().equals(other.getEnterpriseConfigCase())) return false;
    switch (enterpriseConfigCase_) {
      case 5:
        if (!getGithubEnterpriseConfig().equals(other.getGithubEnterpriseConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PATH_FIELD_NUMBER;
    hash = (53 * hash) + getPath().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + REPO_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + repoType_;
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision().hashCode();
    switch (sourceCase_) {
      case 7:
        hash = (37 * hash) + REPOSITORY_FIELD_NUMBER;
        hash = (53 * hash) + getRepository().hashCode();
        break;
      case 0:
      default:
    }
    switch (enterpriseConfigCase_) {
      case 5:
        hash = (37 * hash) + GITHUB_ENTERPRISE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGithubEnterpriseConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloudbuild.v1.GitFileSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloudbuild.v1.GitFileSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * GitFileSource describes a file within a (possibly remote) code repository.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudbuild.v1.GitFileSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudbuild.v1.GitFileSource)
      com.google.cloudbuild.v1.GitFileSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitFileSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitFileSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloudbuild.v1.GitFileSource.class,
              com.google.cloudbuild.v1.GitFileSource.Builder.class);
    }

    // Construct using com.google.cloudbuild.v1.GitFileSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      path_ = "";
      uri_ = "";
      repoType_ = 0;
      revision_ = "";
      sourceCase_ = 0;
      source_ = null;
      enterpriseConfigCase_ = 0;
      enterpriseConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloudbuild.v1.Cloudbuild
          .internal_static_google_devtools_cloudbuild_v1_GitFileSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSource getDefaultInstanceForType() {
      return com.google.cloudbuild.v1.GitFileSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSource build() {
      com.google.cloudbuild.v1.GitFileSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSource buildPartial() {
      com.google.cloudbuild.v1.GitFileSource result =
          new com.google.cloudbuild.v1.GitFileSource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloudbuild.v1.GitFileSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.path_ = path_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.repoType_ = repoType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.revision_ = revision_;
      }
    }

    private void buildPartialOneofs(com.google.cloudbuild.v1.GitFileSource result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      result.enterpriseConfigCase_ = enterpriseConfigCase_;
      result.enterpriseConfig_ = this.enterpriseConfig_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloudbuild.v1.GitFileSource) {
        return mergeFrom((com.google.cloudbuild.v1.GitFileSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloudbuild.v1.GitFileSource other) {
      if (other == com.google.cloudbuild.v1.GitFileSource.getDefaultInstance()) return this;
      if (!other.getPath().isEmpty()) {
        path_ = other.path_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.repoType_ != 0) {
        setRepoTypeValue(other.getRepoTypeValue());
      }
      if (!other.getRevision().isEmpty()) {
        revision_ = other.revision_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case REPOSITORY:
          {
            sourceCase_ = 7;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getEnterpriseConfigCase()) {
        case GITHUB_ENTERPRISE_CONFIG:
          {
            enterpriseConfigCase_ = 5;
            enterpriseConfig_ = other.enterpriseConfig_;
            onChanged();
            break;
          }
        case ENTERPRISECONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                path_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                repoType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                revision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                enterpriseConfigCase_ = 5;
                enterpriseConfig_ = s;
                break;
              } // case 42
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 7;
                source_ = s;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int enterpriseConfigCase_ = 0;
    private java.lang.Object enterpriseConfig_;

    public EnterpriseConfigCase getEnterpriseConfigCase() {
      return EnterpriseConfigCase.forNumber(enterpriseConfigCase_);
    }

    public Builder clearEnterpriseConfig() {
      enterpriseConfigCase_ = 0;
      enterpriseConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * The path of the file, with the repo root as the root of the path.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path of the file, with the repo root as the root of the path.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path of the file, with the repo root as the root of the path.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @param value The path to set.
     * @return This builder for chaining.
     */
    public Builder setPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      path_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path of the file, with the repo root as the root of the path.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPath() {
      path_ = getDefaultInstance().getPath();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path of the file, with the repo root as the root of the path.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @param value The bytes for path to set.
     * @return This builder for chaining.
     */
    public Builder setPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      path_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the repo.
     * Either uri or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the repo.
     * Either uri or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the repo.
     * Either uri or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the repo.
     * Either uri or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of the repo.
     * Either uri or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the repository field is set.
     */
    @java.lang.Override
    public boolean hasRepository() {
      return sourceCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The repository.
     */
    @java.lang.Override
    public java.lang.String getRepository() {
      java.lang.Object ref = "";
      if (sourceCase_ == 7) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 7) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for repository.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRepositoryBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 7) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 7) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The repository to set.
     * @return This builder for chaining.
     */
    public Builder setRepository(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 7;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepository() {
      if (sourceCase_ == 7) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fully qualified resource name of the Repos API repository.
     * Either URI or repository can be specified.
     * If unspecified, the repo from which the trigger invocation originated is
     * assumed to be the repo from which to read the specified path.
     * </pre>
     *
     * <code>string repository = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for repository to set.
     * @return This builder for chaining.
     */
    public Builder setRepositoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 7;
      source_ = value;
      onChanged();
      return this;
    }

    private int repoType_ = 0;
    /**
     *
     *
     * <pre>
     * See RepoType above.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
     *
     * @return The enum numeric value on the wire for repoType.
     */
    @java.lang.Override
    public int getRepoTypeValue() {
      return repoType_;
    }
    /**
     *
     *
     * <pre>
     * See RepoType above.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for repoType to set.
     * @return This builder for chaining.
     */
    public Builder setRepoTypeValue(int value) {
      repoType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See RepoType above.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
     *
     * @return The repoType.
     */
    @java.lang.Override
    public com.google.cloudbuild.v1.GitFileSource.RepoType getRepoType() {
      com.google.cloudbuild.v1.GitFileSource.RepoType result =
          com.google.cloudbuild.v1.GitFileSource.RepoType.forNumber(repoType_);
      return result == null ? com.google.cloudbuild.v1.GitFileSource.RepoType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * See RepoType above.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
     *
     * @param value The repoType to set.
     * @return This builder for chaining.
     */
    public Builder setRepoType(com.google.cloudbuild.v1.GitFileSource.RepoType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      repoType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See RepoType above.
     * </pre>
     *
     * <code>.google.devtools.cloudbuild.v1.GitFileSource.RepoType repo_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepoType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      repoType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object revision_ = "";
    /**
     *
     *
     * <pre>
     * The branch, tag, arbitrary ref, or SHA version of the repo to use when
     * resolving the filename (optional).
     * This field respects the same syntax/resolution as described here:
     * https://git-scm.com/docs/gitrevisions
     * If unspecified, the revision from which the trigger invocation originated
     * is assumed to be the revision from which to read the specified path.
     * </pre>
     *
     * <code>string revision = 4;</code>
     *
     * @return The revision.
     */
    public java.lang.String getRevision() {
      java.lang.Object ref = revision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch, tag, arbitrary ref, or SHA version of the repo to use when
     * resolving the filename (optional).
     * This field respects the same syntax/resolution as described here:
     * https://git-scm.com/docs/gitrevisions
     * If unspecified, the revision from which the trigger invocation originated
     * is assumed to be the revision from which to read the specified path.
     * </pre>
     *
     * <code>string revision = 4;</code>
     *
     * @return The bytes for revision.
     */
    public com.google.protobuf.ByteString getRevisionBytes() {
      java.lang.Object ref = revision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The branch, tag, arbitrary ref, or SHA version of the repo to use when
     * resolving the filename (optional).
     * This field respects the same syntax/resolution as described here:
     * https://git-scm.com/docs/gitrevisions
     * If unspecified, the revision from which the trigger invocation originated
     * is assumed to be the revision from which to read the specified path.
     * </pre>
     *
     * <code>string revision = 4;</code>
     *
     * @param value The revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revision_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch, tag, arbitrary ref, or SHA version of the repo to use when
     * resolving the filename (optional).
     * This field respects the same syntax/resolution as described here:
     * https://git-scm.com/docs/gitrevisions
     * If unspecified, the revision from which the trigger invocation originated
     * is assumed to be the revision from which to read the specified path.
     * </pre>
     *
     * <code>string revision = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevision() {
      revision_ = getDefaultInstance().getRevision();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The branch, tag, arbitrary ref, or SHA version of the repo to use when
     * resolving the filename (optional).
     * This field respects the same syntax/resolution as described here:
     * https://git-scm.com/docs/gitrevisions
     * If unspecified, the revision from which the trigger invocation originated
     * is assumed to be the revision from which to read the specified path.
     * </pre>
     *
     * <code>string revision = 4;</code>
     *
     * @param value The bytes for revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revision_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the githubEnterpriseConfig field is set.
     */
    @java.lang.Override
    public boolean hasGithubEnterpriseConfig() {
      return enterpriseConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The githubEnterpriseConfig.
     */
    @java.lang.Override
    public java.lang.String getGithubEnterpriseConfig() {
      java.lang.Object ref = "";
      if (enterpriseConfigCase_ == 5) {
        ref = enterpriseConfig_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (enterpriseConfigCase_ == 5) {
          enterpriseConfig_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for githubEnterpriseConfig.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGithubEnterpriseConfigBytes() {
      java.lang.Object ref = "";
      if (enterpriseConfigCase_ == 5) {
        ref = enterpriseConfig_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (enterpriseConfigCase_ == 5) {
          enterpriseConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The githubEnterpriseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setGithubEnterpriseConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      enterpriseConfigCase_ = 5;
      enterpriseConfig_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGithubEnterpriseConfig() {
      if (enterpriseConfigCase_ == 5) {
        enterpriseConfigCase_ = 0;
        enterpriseConfig_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the github enterprise config.
     * Format:
     * `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
     * `projects/{project}/githubEnterpriseConfigs/{id}`.
     * </pre>
     *
     * <code>string github_enterprise_config = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for githubEnterpriseConfig to set.
     * @return This builder for chaining.
     */
    public Builder setGithubEnterpriseConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      enterpriseConfigCase_ = 5;
      enterpriseConfig_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudbuild.v1.GitFileSource)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudbuild.v1.GitFileSource)
  private static final com.google.cloudbuild.v1.GitFileSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloudbuild.v1.GitFileSource();
  }

  public static com.google.cloudbuild.v1.GitFileSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GitFileSource> PARSER =
      new com.google.protobuf.AbstractParser<GitFileSource>() {
        @java.lang.Override
        public GitFileSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GitFileSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GitFileSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloudbuild.v1.GitFileSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
